<?
include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/user.php';
$set['title']='Учебник JavaScript';
include_once '../../sys/inc/thead.php';
title();
err();
//aut();
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<phpl<TITLE>Функции</TITLE>
<BODY>
<h5><a href="contents.php">Оглавление</a> | <a href="stmtsov.php">Назад</a>
| <a href="obj.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5>
<HR><h1>Глава 6<BR><a name="1008302"></a>Функции</h1>
<p><A NAME="1008304"></a>Функции это фундаментальные конструкции JavaScript. 
Функция это процедура JavaScript - набор операторов, выполняющих специфическую 
задачу. Для использования функции Вы обязаны сначала определить её; затем Ваш 
скрипт может её вызвать.</p>
<p><A NAME="1009575"></a>В главе имеются следующие разделы:</p>
<ul><LI><A NAME="1009576"></a>
<a href="#1008305">Определение функций</a></LI><LI><A NAME="1009577"></a>
<a href="#1008321">Вызов функций</a></LI><LI><A NAME="1009764"></a>
<a href="#1012766">Использование массива arguments</a></LI><LI><A NAME="1009765"></a>
<a href="#1008357">Предопределённые функции</a></LI></ul>
<H2><A NAME="Defining Functions"></A><A NAME="1008305"></a>Определение функций</H2><hr>
<p><A NAME="1009697"></a>Определение функции состоит из ключевого слова <CODE>function</CODE> и:</p>
<ul><LI><A NAME="1008308"></a>имени функции</LI><LI><A NAME="1008309"></a>
списка аргументов, заключённых в скобки и разделённых запятыми</LI><LI>
<A NAME="1008310"></a>операторов JavaScript, определяющих функцию, заключённых 
в фигурные скобки { }. Операторы функции могут содержать вызовы других функций, 
определённых в текущем приложении.</LI></ul>
<p><A NAME="1013062"></a>Вы должны определять все Ваши функции в HEAD/шапке 
страницы, чтобы при её загрузке пользователем функции загружались в первую 
очередь. Иначе пользователь может выполнить действие, когда страница ещё 
загружается, и включить обработчик и вызвать функцию, которая ещё не определена, 
что приведёт к возникновению ошибки.</p><p><A NAME="1008313"></a>
Например, следующий код определяет простую функцию <CODE>square</CODE>:</p>
<PRE><A NAME="1009645"></a>function square(number) {<br>&nbsp;&nbsp;&nbsp;return number * number;<br>}</PRE>
<p><A NAME="1009646"></a>Функция <CODE>square</CODE> принимает один аргумент <CODE>number</CODE>.
Эта функция состоит из одного оператора, указывающего возвращаемое значение - 
аргумент функции, умноженный сам на себя. Оператор <CODE>return</CODE> специфицирует 
значение, возвращаемое функцией.</p>
<PRE><A NAME="1009624"></a><CODE>return number * number</CODE></PRE><p><A NAME="1012732"></a>
Все параметры передаются функциям <i>по значению</i>; значение передаётся 
функции, но если функция изменяет значение параметра, это изменение не 
отражается глобально или в вызывающей функции. Однако, если Вы передаёте функции 
объект в качестве параметра и функция изменяет свойства объекта, это изменение 
видно&#x0301; вне функции, как показано в примере:</p>
<PRE><A NAME="1012733"></a>function myFunc(theObject) {<br>&nbsp;&nbsp;&nbsp;theObject.make="Toyota"<br>}<br>
<br>mycar = {make:"Honda", model:"Accord", year:1998}<br>x=mycar.make &nbsp;&nbsp;&nbsp;&nbsp;// возвращает Honda<br>myFunc(mycar) &nbsp;&nbsp;&nbsp;// передаёт объект mycar функции<br>y=mycar.make &nbsp;&nbsp;&nbsp;&nbsp;// возвращает Toyota (prop было изменено функцией)</PRE><p><A NAME="1008317"></a>
Помимо описанного здесь определения функции, Вы можете также определять объекты <CODE>Function</CODE>,
как показано в разделе <A HREF="obj.php#1008590">"Объект Function"</A>.</p><p><A NAME="1009691"></a>
<i>Метод</i> это функция, ассоциированная с объектом. Вы может узнать больше об 
объектах и методах в <A HREF="obj.php#1008302">Главе 7 "Работа с Объектами&quot;</A>.</p>
<H2><A NAME="Calling Functions"></A><A NAME="1008321"></a>Вызов функций</H2><hr><p><A NAME="1013067"></a>
В приложениях для Navigator'а Вы можете использовать (или
<i>вызывать</i>) любую функцию, определённую на текущей странице. Вы можете 
также использовать функции, определённые другими именованными окнами или 
фрэймами.</p><p><A NAME="1009651"></a>
Определение функции не вызывает её выполнения. Определение функции просто 
именует функцию и специфицирует, что&#x0301; выполняется при вызове функции. <i>Вызов</i> функции реально 
выполняет специфицированные акции с указанными параметрами. Например, если Вы 
определили функцию <CODE>square</CODE>, Вы можете вызвать её так:</p><PRE><A NAME="1009664"></a>square(5)</PRE>
<p><A NAME="1009686"></a>Это оператор вызова функции с аргументом 5.
Функция выполняет свои операторы и возвращает значение 25.</p><p><A NAME="1008325"></a>
Аргументы функции не ограничиваются только числами и строками. Вы можете 
также передавать  в функцию объекты. Функция <CODE>show_props</CODE> (определённая 
в разделе <A HREF="obj.php#1008312">"Объекты и Свойства"</A>)
это пример функции, принимающей в качестве аргумента объект.</p><p><A NAME="1008330"></a>
Функция может быть рекурсивной, то есть вызывать сама себя. Например, вот функция вычисления факториалов:</p>
<PRE><A NAME="1008331"></a>function factorial(n) {<br>&nbsp;&nbsp;&nbsp;if ((n == 0) || (n == 1))<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;return 1<br>&nbsp;&nbsp;&nbsp;else {<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;result = (n * factorial(n-1) )<br>&nbsp;&nbsp;&nbsp;return result<br>
&nbsp;&nbsp;&nbsp;}<br>}</PRE><p><A NAME="1012574"></a>Вы можете вычислить факториалы значений от 1 до 5:</p>
<PRE><A NAME="1012645"></a>a=factorial(1) // возвращает 1<br>b=factorial(2) // возвращает 2<br>c=factorial(3) // возвращает 6<br>d=factorial(4) // возвращает 24<br>e=factorial(5) // возвращает 120</PRE>
<H2><A NAME="Using the arguments Array"></A><A NAME="1012766"></a>Использование 
массива arguments</H2><hr><p><A NAME="1008338"></a>Аргументы обрабатываются в массиве. В функции
Вы можете адресовать параметры, передаваемые ей:</p>
<PRE><A NAME="1008339"></a>arguments[<I>i</I>]<br>functionName.arguments[i]</PRE>
<p><A NAME="1008340"></a>где <CODE>i</CODE> это порядковый номер аргумента, начиная с 0.
Таким образом, первый аргумент, передаваемый функции, это <CODE>arguments[0]</CODE>. 
Общее число аргументов указывается свойством <CODE>arguments.length</CODE>.</p><p><A NAME="1008343"></a>
Используя массив <CODE>arguments</CODE>, Вы можете вызвать функцию с большим 
количеством аргументов, чем объявлено в формальном определении. Это часто 
используется, если заранее не известно точное количество аргументов, 
передаваемых функции. Вы можете использовать <CODE>arguments.length</CODE> для 
определения количества аргументов, реально передаваемых функции, а затем 
работать с каждым аргументом с использованием массива
<CODE>arguments</CODE>.</p><p><A NAME="1009813"></a>
Например, рассмотрим функцию, которая объединяет несколько строк. Единственным 
формальным аргументом для этой функции является строка, которая специфицирует 
символы, разделяющие объединяемые элементы. Функция определена так:</p>
<PRE><A NAME="1012590"></a>function myConcat(separator) {<br>&nbsp;&nbsp;&nbsp;result="" // инициализирует список<br>
&nbsp;&nbsp;&nbsp;// итерирует по аргументам<br>&nbsp;&nbsp;&nbsp;for (var i=1; i&lt;arguments.length; i++) {<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;result += arguments[i] + separator<br>&nbsp;&nbsp;&nbsp;}<br>
&nbsp;&nbsp;&nbsp;return result<br>}</PRE><p><A NAME="1012591"></a>Вы можете 
передать этой функции любое количество аргументов, и она создаст список, используя каждый аргумент как элемент списка.</p>
<PRE><A NAME="1012592"></a>// возвращает "red, orange, blue, "<br>myConcat(", ","red","orange","blue")</PRE>
<PRE><A NAME="1012593"></a>// возвращает "elephant; giraffe; lion; cheetah;"<br>
myConcat("; ","elephant","giraffe","lion", "cheetah")</PRE><PRE><A NAME="1012594"></a>
// возвращает "sage. basil. oregano. pepper. parsley. "<br>myConcat(". ","sage","basil","oregano", "pepper", "parsley")</PRE>
<p><A NAME="1009506"></a>См. статью об объекте <CODE>Function</CODE> в книге <I>
<a TARGET="_top" href="../clientref13/index.php">Клиентский JavaScript. 
Справочник.</a></I></p><H2><A NAME="Predefined Functions"></A><A NAME="1008357"></a>Предопределённые 
функции</H2><hr>
<p><A NAME="1009833"></a>В JavaScript есть несколько предопределённых функций:</p>
<ul><LI><CODE><a NAME="1009845"></a><a NAME="1009845"><a href="#1008364">eval</a></CODE></LI><LI><A NAME="1009916"></a>
<CODE><a NAME="1009916"></a><a href="#1009925">isFinite</a></CODE></LI><LI><A NAME="1009849"></a>
<CODE><a NAME="1009849"></a><a href="#1008370">isNaN</a></CODE></LI><LI><A NAME="1009863"></a>
<a NAME="1009863"></a><a href="#1008379"><CODE>parseInt</CODE> и <CODE>parseFloat</CODE></a></LI><LI><A NAME="1009853"></a>
<a NAME="1009853"></a><a href="#1008394"><CODE>Number</CODE> и <CODE>String</CODE></a></LI><LI><A NAME="1009855"></a>
<a NAME="1009855"></a><a href="#1012712"><CODE>escape</CODE> и <CODE>unescape</CODE></a></LI></ul><p><A NAME="1009836"></a>
В следующих разделах рассматриваются эти функции. См. также книгу <I>
<a TARGET="_top" href="../clientref13/index.php">Клиентский JavaScript. Справочник.</a></I></p>
<H3><A NAME="Head2;"></A><A NAME="1008364"></a>Функция eval</H3><hr><p><A NAME="1008365"></a>
Функция <CODE>eval</CODE> вычисляет строку кода JavaScript без ссылки на 
определённый объект. Синтаксис <CODE>eval</CODE> таков:</p><PRE><A NAME="1008366"></a>eval(<I>expr</I>)</PRE>
<p><A NAME="1008367"></a>где <CODE>expr</CODE> это вычисляемая строка.</p><p><A NAME="1008368"></a>
Если строка представляет выражение, <CODE>eval</CODE> вычисляет это выражение. 
Если аргумент представляет собой один или несколько операторов JavaScript, <CODE>eval</CODE> 
выполняет эти операторы. Не вызывайте <CODE>eval</CODE> для вычисления 
арифметических выражений; JavaScript вычисляет арифметические выражения 
автоматически.</p><H3><A NAME="Head2;"></A><A NAME="1009925"></a>Функция 
isFinite</H3><hr><p>
<A NAME="1009926"></a>Функция isFinite вычисляет аргумент, чтобы определить, 
является ли он конечным числом. Синтаксис <CODE>isFinite</CODE>:</p>
<PRE><A NAME="1009948"></a>isFinite(<I>number</I>)</PRE><p><A NAME="1009980"></a>
где <CODE>number</CODE> это вычисляемое число.</p><p><A NAME="1009996"></a>
Если аргумент имеет значения <CODE>NaN</CODE>, положительная или отрицательная 
бесконечность, то этот метод возвращает <CODE>false</CODE>, иначе возвращает <CODE>true</CODE>.</p><p><A NAME="1010011"></a>
Следующий код проверяет клиентский ввод и определяет, является ли он конечным числом.</p>
<PRE><A NAME="1010012"></a>if(isFinite(ClientInput) == true)<br>{<br>&nbsp;&nbsp;&nbsp;/* некоторые специальные шаги */<br>}</PRE><H3><A NAME="Head2;"></A><A NAME="1008370"></a>
Функция isNaN</H3><hr><p><A NAME="1008371"></a>
Функция <CODE>isNaN</CODE> вычисляет аргумент, чтобы определить, является ли он "NaN" (не-числом). 
Синтаксис <CODE>isNaN</CODE>:</p><PRE><A NAME="1008372"></a>isNaN(<I>testValue</I>)</PRE>
<p><A NAME="1008373"></a>где <CODE>testValue</CODE> это значение, которое Вы 
хотите обсчитать.</p>
<p><A NAME="1008374"></a>Функции <CODE>parseFloat</CODE> и <CODE>parseInt</CODE> 
возвращают "NaN", если они вычисляют значение, которое не является числом. <CODE>isNaN</CODE> 
возвращает true, если передано "NaN&quot;, и false - в ином случае.</p><p><A NAME="1008375"></a>
Следующий код вычисляет <CODE>floatValue</CODE> и определяет, является ли оно 
числом, а затем вызывает соответствующую процедуру:</p>
<PRE><A NAME="1008376"></a>floatValue=parseFloat(toFloat)</PRE>
<PRE><A NAME="1008377"></a>if (isNaN(floatValue)) {<br>&nbsp;&nbsp;&nbsp;notFloat()<br>} else {<br>
&nbsp;&nbsp;&nbsp;isFloat()<br>}</PRE><H3><A NAME="Head2;"></A><A NAME="1008379"></a>
Функции parseInt и parseFloat</H3><hr><p><A NAME="1008380"></a>
Две "parse"-функции, <CODE>parseInt</CODE> и <CODE>parseFloat</CODE>, возвращают 
числовое значение при получении строкового аргумента.</p><p><A NAME="1009327"></a>
Синтаксис <CODE>parseFloat</CODE> таков:</p><PRE><A NAME="1008387"></a>parseFloat(<I>str</I>)</PRE>
<p><A NAME="1008388"></a>где <CODE>parseFloat</CODE> разбирает свой аргумент, 
строку <CODE>str</CODE>, и пытается возвратить число с плавающей точкой. Если 
она обнаруживает символ, отличный от знака (+ или -), числа (0-9), десятичной 
точки или экспоненты, она возвращает значение, разобранное до этого места, и игнорирует этот символ и 
все последующие символы. Если первый символ не может быть конвертирован в число, 
функция возвращает значение "NaN" (не-число).</p>
<p><A NAME="1008389"></a>Синтаксис <CODE>parseInt</CODE> таков:</p><PRE><A NAME="1008390"></a>parseInt(str [, radix])</PRE>
<p><A NAME="1008391"></a><CODE>parseInt</CODE> разбирает первый аргумент, строку <CODE>str</CODE>, 
и пытается возвратить целое число со специфицированной <CODE>radix</CODE> (базой),
обозначаемой вторым не обязательным аргументом <CODE>radix</CODE>. Например, radix 
10 указывает на конвертацию десятеричного числа, 8 -восьмеричного, 16 - 
шестнадцатеричного, и так далее. При radix более 10 буквы латинского алфавита 
используются для обозначения цифр больше 9. Например, для 16-ричных чисел (база 16), 
используются английские буквы от A до F.</p><p><A NAME="1008392"></a>
Если <CODE>parseInt</CODE> обнаруживает символ, не являющийся цифрой в 
специфицированном radix, она игнорирует этот и все последующие символы и возвращает целочисленное 
значение, разобранное до этого места.
Если первый символ не может быть конвертирован в число со специфицированной базой, функция возвращает "NaN."
Функция <CODE>parseInt</CODE> усекает строку до целочисленных значений.</p>
<H3><A NAME="Head2;"></A><A NAME="1008394"></a>Функции Number и String</H3><hr><p><A NAME="1008395"></a>
Функции <CODE>Number</CODE> и <CODE>String</CODE> позволяют конвертировать 
объект в число или строку. Синтаксис таков:</p>
<PRE><A NAME="1008396"></a>Number(<I>objRef</I>)<br>String(<I>objRef</I>)</PRE><p><A NAME="1008397"></a>
где <CODE>objRef</CODE> это ссылка на объект.</p><p><A NAME="1012662"></a>
В следующем примере <CODE>Date</CODE>-объект конвертируется в читабельную строку.</p>
<PRE><A NAME="1012710"></a>D = new Date (430054663215)<br>// возвращает<br>// "Thu Aug 18 04:37:43 GMT-0700 (Pacific Daylight Time) 1983"<br>x = String(D)</PRE>
<H3><A NAME="Head2;"></A></a><A NAME="1012712"></a>Функции escape и unescape</H3><hr><p><A NAME="1008402"></a>
Функции <CODE>escape</CODE> и <CODE>unescape</CODE> позволяют кодировать и 
декодировать строки. Функция <CODE>escape</CODE> возвращает 16-ричное кодовое значение 
своего аргумента - 
символа их набора ISO Latin. Функция <CODE>unescape</CODE> возвращает ASCII-строку 
для специфицированного 16-ричного кодового значения.</p>
<p><A NAME="1008403"></a>Синтаксис этих функций таков:</p><PRE><A NAME="1008404"></a>escape(string)<br>unescape(string)</PRE>
<p><A NAME="1008405"></a>Эти функции используются в основном в серверном JavaScript 
для кодирования и декодирования пар имя/значение в URL.</p>
<h5><a href="contents.php">Оглавление</a> | <a href="stmtsov.php">Назад</a>
| <a href="obj.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5>
<hr></BODY></HTML>
<?
include_once '../../sys/inc/tfoot.php';
?>