<?php 

include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/user.php';
$set['title']='Учебник PHP, Глава 1';
include_once '../../sys/inc/thead.php';
title();
err();
//aut();

?>
<html><head>
		<title>Учебник PHP, Глава 1</title>
		<meta http-equiv="Content-type" content="text/html; charset=Windows-1251">
		</head>
		
      <DIV class=infotxt>
      <LI><A href="#a">Глава 1. Знакомство с PHP 
      </A>
      <UL>
        <LI><A href="#b">Краткая история </A>
        <LI><A href="#c">Характеристики PHP </A>
        <UL>
          <LI><A href="#d">Традиционность</A> 
          <LI><A href="#e">Простота</A> 
          <LI><A href="#f">Эффективность</A> 
          <LI><A href="#g">Безопасность</A> 
          <LI><A href="#h">Гибкость</A> 
          <LI><A href="#i">Бесплатное 
          распространение</A> </LI></UL>
        <LI><A href="#j">Рекомендации 
        пользователей </A>
        <LI><A href="#k">Вводный пример </A>
        <LI><A href="#l">Загрузка PHP/Apache </A>
        <LI><A href="#m">Установка и настройка 
</A>
        <UL>
          <LI><A href="#n">Системы, не входящие в 
          семейство Windows</A> 
          <LI><A href="#o">Установка в Windows 
          95/98/NT</A> </LI></UL>
        <LI><A href="#p">Конфигурация PHP </A>
        <UL>
          <LI><A href="#q">Общие параметры 
          конфигурации</A> </LI></UL>
        <LI><A href="#r">Основные конструкции PHP 
        </A>
        <UL>
          <LI><A href="#s">Переход в PHP</A> 
          <LI><A href="#t">Внедрение HTML в код 
          PHP</A> 
          <LI><A href="#u">Включение нескольких 
          сценариев PHP</A> 
          <LI><A href="#v">Комментарии в коде 
          PHP</A> </LI></UL>
        <LI><A href="#w">Итоги</A> </LI></UL>
      <UL></UL><A name=a></A>
      <P></P>
      <P>ГЛАВА 1 </P>
      <P>Знакомство с РНР</P>
      <P>Последние пять лет ознаменовались фантастическим развитием Интернета и 
      новых способов общения между людьми. На переднем крае этого явления 
      находится World Wide Web (WWW). Ежедневно в этой новой коммуникационной 
      среде открываются тысячи новых сайтов, а потребителям предлагаются новые 
      виды услуг. Вместе с бурным развитием рынка появился огромный спрос на 
      новые технологии и разработчиков, владеющих ими. Если вы читаете этот 
      абзац, вероятно, вы уже являетесь или скоро станете web-разработчиком. 
      Впрочем, какой бы ни была ваша профессия, вы выбрали эту книгу потому, что 
      слышали о замечательной новой технологии — РНР. </P>
      <P>В этой главе вы познакомитесь с языком РНР, получите представление о 
      его истории и возможностях, а также основную информацию, необходимую для 
      разработки сайтов с поддержкой РНР. Надеюсь, приведенные примеры пробудят 
      ваш энтузиазм и наглядно покажут, какие перспективы РНР открывает перед 
      вами и вашей организацией. Вы узнаете, как установить и настроить 
      программное обеспечение РНР на компьютерах с Linux/UNIX или Windows и как 
      внедрить РНР в HTML. К концу главы вы будете готовы к тому, чтобы 
      углубленно заняться изучением других важных аспектов языка РНР. Итак, 
      зажигайте свет, включайте свою любимую музыку и устраивайтесь поудобнее. 
      Пришла пора познакомиться с тем, что станет одним из важнейших пунктов в 
      вашем резюме, - с программированием на РНР. </P>
      <P><A href="http.html://doks.gorodok.net/0" name=b></A>Краткая история</P>
      <P>История РНР начинается с 1995 года, когда независимый 
      программист-контрактник по имени Расмус Лердорф (Rasmus Lerdorf) написал 
      сценарий Perl/CGI для подсчета количества посетителей сайта, прочитавших 
      его онлайновое резюме. Его сценарий решал две задачи: регистрацию данных 
      посетителя и вывод количества посетителей на web-странице. Развитие WWW 
      еще только начиналось, никаких специальных средств для решения этих задач 
      не было, и к автору хлынул поток сообщений с вопросами. Лердорф начал 
      бесплатно раздавать свой инструментарий, названный Personal Home Page 
      (РНР) или Hypertext Processor (гипертекстовый процессор). </P>
      <P>Шумный успех инструментария РНР заставил Лердорфа приступить к 
      разработке расширений РНР. Одно из расширений преобразовывало данные, 
      введенные на форме HTML, в символические переменные, что позволяло 
      экспортировать их в другие системы. Чтобы добиться поставленной цели, 
      Лердорф решил в дальнейших разработках перейти с Perl на С. Расширение 
      существующего инструментария РНР привело к появлению РНР 2.0, или PHP-FI 
      (Personal Home Page — Form Interpretator). В усовершенствовании версии 2.0 
      принимали участие программисты со всего мира. </P>
      <P>Новая версия РНР пользовалась исключительной популярностью, и вскоре 
      образовалась основная команда разработчиков. Они сохранили исходную 
      концепцию внедрения программного кода прямо в HTML и переписали заново 
      механизм лексического анализа, что привело к появлению РНР 3.0. К моменту 
      выхода версии 3.0 в 1997 году свыше 50 000 пользователей применяли РНР для 
      улучшения своих web-страниц. </P>
      <P>В 1997 году было решено, что сокращение РНР должно означать не 
      «Personal Home page», а «РНР Hypertext Processor»&nbsp; </P>
      <P>В течение следующих двух лет стремительное развитие РНР продолжалось. В 
      язык добавлялись сотни новых функций, а количество пользователей 
      стремительно росло. В начале 1999 года служба Netcraft 
      (http://www.netcraft.com) сообщила о том, что, по минимальным оценкам, 
      число пользователей РНР превысило 1 000 000, в результате чего РНР стал 
      одним из самых популярных сценарных языков в мире.</P>
      <P>В начале 1999 года было объявлено о предстоящем выходе РНР 4.0. Хотя 
      одной из сильнейших сторон РНР была эффективность выполнения сценариев, 
      при первоначальных разработках не предполагалось, что на базе РНР будут 
      строиться крупномасштабные приложения. По этой причине была начата работа 
      над более устойчивым механизмом лексического анализа, больше известным под 
      названием Zend (http://www.zend.com). Работа шла быстро и завершилась 22 
      мая 2000 года выпуском РНР версии 4.0.</P>
      <P>Кроме лексического анализатора Zend, компания Zend Technologies 
      (Израиль) распространяет оптимизатор Zend, который повышает выигрыш в 
      быстродействии от применения лексического анализатора Zend. Тесты 
      показывают, что ускорение работы программы в результате использования 
      оптимизатора составляет от 40 до 100 %. За дополнительной информацией 
      обращайтесь на сайт Zend.</P>
      <P>На момент написания этой книги, по данным Netcraft 
      (http://www.netcraft.com), программное обеспечение РНР было установлено 
      более чем в 3,6 миллиона доменов. Будущее РНР выглядит светлым, поскольку 
      продукт продолжает активно использоваться как на крупных web-сайтах, так и 
      на компьютерах отдельных пользователей.</P>
      <P>РНР лучше всего охарактеризовать как работающий на стороне сервера 
      встроенный язык сценариев Web, позволяющий разработчикам быстро и 
      эффективно строить динамические web-приложения. С позиций грамматики и 
      синтаксиса РНР напоминает язык программирования С, хотя разработчики не 
      постеснялись включить в него средства из других языков, в том числе из 
      Perl, Java и C++. Среди ценных заимствованных возможностей — поддержка 
      регулярных выражений, мощные средства работы с массивами, 
      объектно-ориентированная методология и обширная поддержка работы с базами 
      данных. </P>
      <P>При написании приложений, выходящих за рамки традиционной, статической 
      методологии разработки web-страниц (то есть HTML), РНР также может 
      послужить ценным инструментом для создания и управления динамическим 
      содержанием, который используется наряду с JavaScript, стилями, WML 
      (Wireless Markup Language) и другими полезными языками. Благодаря наличию 
      сотен стандартных функций РНР в состоянии решить практически любую задачу, 
      которая может придти в голову разработчику. В нем имеется обширная 
      поддержка создания графики и операций с ней, математических вычислений, 
      средств электронной коммерции и таких популярных технологий, как XML 
      (Extensible Markup Language), ODBC (Open Database Connectivity) и 
      Macromedia Shockwave. Широкий выбор возможностей избавляет от 
      необходимости рутинной и непростой работы по подключению сторонних 
      модулей, поэтому многие разработчики со всего мира останавливают свой 
      выбор на РНР. </P>
      <P>Одним из главных достоинств РНР является тот факт, что он внедряется 
      прямо в HTML-код, поэтому программисту не приходится писать программу с 
      множеством команд для простого вывода HTML. Код HTML и РНР можно 
      чередовать по мере необходимости. РНР позволяет написать фрагмент 
      следующего вида: </P>
      <P><STRONG>&lt;html&gt;</STRONG></P>
      <P><STRONG>&lt;title&gt;&lt;? print "Hello world!"; 
      ?&gt;&lt;/title&gt;</STRONG></P>
      <P><STRONG>&lt;/html&gt;</STRONG></P>
      <P>Сообщение "Hello world!" выводится в заголовке web-страницы. Интересно 
      то, что команда print внутри конструкции, которая обычно называется 
      экранирующими последовательностями РНР (&lt;?...?&gt;), представляет собой 
      законченную программу. Ни длинного кода инициализации, ни включения 
      библиотек — программа состоит лишь из того кода, который непосредственно 
      решает поставленную задачу! </P>
      <P>Конечно, для выполнения сценариев РНР необходимо предварительно 
      установить и настроить программное обеспечение РНР на сервере. Этот 
      процесс описан в разделе «Загрузка и установка РНР/Apache» настоящей 
      главы. Разделу предшествуют фрагменты из отзывов нескольких пользователей, 
      выступающих в пользу РНР, с кратким обзором языка и его истории. Но прежде 
      чем браться за процесс установки, мы познакомимся с некоторыми 
      характеристиками РНР. Этой теме посвящен следующий раздел. </P>
      <P><A name=c></A>Характеристики РНР</P>
      <P>Как вы, вероятно, уже поняли, главным фактором при проектировании языка 
      РНР является практичность. РНР должен предоставить программисту средства 
      для быстрого и эффективного решения поставленных задач. Практический 
      характер РНР обусловлен пятью важными характеристиками: </P>
      <UL>
        <LI>традиционностью; 
        <LI>простотой; 
        <LI>эффективностью; 
        <LI>безопасностью; 
        <LI>гибкостью. </LI></UL>
      <P>Существует еще одна «характеристика», которая делает РНР особенно 
      привлекательным: он распространяется бесплатно! </P>
      <P><A name=d></A>Традиционность</P>
      <P>Язык РНР кажется знакомым программистам, работающим в разных областях. 
      Многие конструкции языка позаимствованы из Си Perl, а нередко код РНР 
      практически неотличим от того, что встречается в типичных программах С или 
      Pascal. Это заметно снижает начальные усилия при изучении РНР. </P>
      <P><A name=e></A>Простота</P>
      <P>Сценарий РНР может состоять из 10 000 строк или из одной строки — все 
      зависит от специфики вашей задачи. Вам не придется подгружать библиотеки, 
      указывать специальные параметры компиляции или что-нибудь в этом роде. 
      Механизм РНР просто начинает выполнять код после первой экранирующей 
      последовательности (&lt;?) и продолжает выполнение до того момента, когда 
      он встретит парную экранирующую последовательность (?&gt;). Если код имеет 
      правильный синтаксис, он исполняется в точности так, как указал 
      программист. </P>
      <P><A name=f></A>Эффективность</P>
      <P>Эффективность является исключительно важным фактором при 
      программировании для многопользовательских сред, к числу которых относится 
      и WWW. В РНР 4.0 был реализован механизм выделения ресурсов и обеспечена 
      улучшенная поддержка объектно-ориентированного программирования, а также 
      средства управления сеансом. В последней версии появился и механизм 
      подсчета ссылок (reference counting), предотвращающий выделение лишней 
      памяти. </P>
      <P><A name=g></A>Безопасность</P>
      <P>РНР предоставляет в распоряжение разработчиков и администраторов гибкие 
      и эффективные средства безопасности, которые условно делятся на две 
      категории: средства системного уровня и средства уровня приложения. </P>
      <P>Средства безопасности системного уровня</P>
      <P>В РНР реализованы механизмы безопасности, находящиеся под управлением 
      администраторов; при правильной настройке РНР это обеспечивает 
      максимальную свободу действий и безопасность. РНР может работать в так 
      называемом безопасном режиме (safe mode), который ограничивает возможности 
      применения РНР пользователями по ряду важных показателей. Например, можно 
      ограничить максимальное время выполнения и использование памяти 
      (неконтролируемый расход памяти отрицательно влияет на быстродействие 
      сервера). По аналогии с cgi-bin администратор также может устанавливать 
      ограничения на каталоги, в которых пользователь может просматривать и 
      исполнять сценарии РНР, а также использовать сценарии РНР для просмотра 
      конфиденциальной информации на сервере (например, файла passwd). </P>
      <P>Средства безопасности уровня приложения </P>
      <P>В стандартный набор функций РНР входит ряд надежных механизмов 
      шифрования. РНР также совместим с многими приложениями независимых фирм, 
      что позволяет легко интегрировать его с защищенными технологиями 
      электронной коммерции (e-commerce). Другое преимущество заключается в том, 
      что исходный текст сценариев РНР нельзя просмотреть в браузере, поскольку 
      сценарий компилируется до его отправки по запросу пользователя. Реализация 
      РНР на стороне сервера предотвращает похищение нетривиальных сценариев 
      пользователями, знаний которых хватает хотя бы для выполнения команды View 
      Source. </P>
      <P>Тема безопасности настолько важна, что ей посвящена целая глава. За 
      подробной информацией о средствах безопасности РНР обращайтесь к главе 16. 
      </P>
      <P><A href="http.html://doks.gorodok.net/1004" name=h></A>Гибкость</P>
      <P>Поскольку РНР является встраиваемым (embedded) языком, он отличается 
      исключительной гибкостью по отношению к потребностям разработчика. Хотя 
      РНР обычно рекомендуется использовать в сочетании с HTML, он с таким же 
      успехом интегрируется и в JavaScript, WML, XML и другие языки. Кроме того, 
      хорошо структурированные приложения РНР легко расширяются по мере 
      необходимости (впрочем, это относится ко всем основным языкам 
      программирования). </P>
      <P>Нет проблем и с зависимостью от браузеров, поскольку перед отправкой 
      клиенту сценарии РНР полностью компилируются на стороне сервера. В 
      сущности, сценарии РНР могут передаваться любым устройствам с браузерами, 
      включая сотовые телефоны, электронные записные книжки, пейджеры и 
      портативные компьютеры, не говоря уже о традиционных PC. Программисты, 
      занимающиеся вспомога-тельными утилитами, могут запускать РНР в режиме 
      командной строки. </P>
      <P>Поскольку РНР не содержит кода, ориентированного на конкретный 
      web-сервер, пользователи не ограничиваются определенными серверами 
      (возможно, незнакомыми для них). Apache, Microsoft IIS, Netscape 
      Enterprise Server, Stronghold и Zeus — РНР работает на всех перечисленных 
      серверах. Поскольку эти серверы работают на разных платформах, РНР в целом 
      является платформенно-незави-симым языком и существует на таких 
      платформах, как UNIX, Solaris, FreeBSD и Windows 95/98/NT. </P>
      <P>Наконец, средства РНР позволяют программисту работать с внешними 
      компонентами, такими как Enterprise Java Beans или СОМ-объекты Win32. 
      Благодаря </P>
      <P>этим новым возможностям РНР занимает достойное место среди современных 
      технологий и обеспечивает масштабирование проектов до необходимых 
      пределов. </P>
      <P><A name=i></A>Бесплатное распространение</P>
      <P>Стратегия Open Source наделала немало шуму в программной отрасли. 
      Распространение исходных текстов программ в массах оказало несомненно 
      благотворное влияние на многие проекты, в первую очередь — Linux, хотя и 
      успех проекта Apache сильно подкрепил позиции сторонников Open Source. 
      Сказанное относится и к истории создания РНР, поскольку поддержка 
      пользователей со всего мира оказалась очень важным фактором в развитии 
      проекта РНР. </P>
      <P>Принятие стратегии Open Source и бесплатное распространение исходных 
      текстов РНР оказало неоценимую услугу пользователям. Вдобавок, отзывчивое 
      сообщество пользователей РНР является своего рода «коллективной службой 
      поддержки», и в популярных электронных конференциях можно найти ответы 
      даже на самые сложные вопросы. </P>
      <P>В следующем разделе «Рекомендации пользователей» приведены 
      свидетельства трех видных профессионалов в области web-разработок. Из них 
      становится ясно, почему они считают РНР такой замечательной технологией. 
      </P>
      <P><A name=j></A>Рекомендации пользователей</P>
      <P>«Мы в течение долгого времени поддерживали личные контакты с некоторыми 
      разработчиками РНР и вели с ними обширную переписку. Когда у разработчиков 
      РНР возникали какие-то проблемы, относящиеся к MySQL, мы всегда были 
      готовы помочь им в поиске решения. Кроме того, мы включили в MySQL 
      несколько новых возможностей лишь для того, чтобы улучшить его интеграцию 
      с РНР. Результатом наших усилий стало то, что MySQL превосходно работает с 
      РНР, — и мы позаботимся о том, чтобы это положение сохранилось и в 
      будущем!» </P>
      <P align=right>Майкл «Монти» Видениус (Michael «Monty» Widenius), </P>
      <P align=right>разработчик MySQL </P>
      <P align=right><A href="http.html://www.mysql.com/">http://www.mysql.com/</A> 
      </P>
      <P>«Выбор РНР для реализации mp3.lycos.com был обусловлен несколькими 
      причинами. Главной причиной стали сжатые сроки работы над проектом — ведь 
      РНР ускоряет процесс разработки. Другой причиной была высокая 
      эффективность — мы перешли от 0 к 1,4 миллиона посещений в сутки, и РНР с 
      этим прекрасно справился. Третья причина заключалась в том, что я твердо 
      знал: если на стадии тестирования с повышенной нагрузкой в РНР обнаружатся 
      какие-либо ошибки, я смогу их самостоятельно исправить, поскольку РНР 
      распространяется вместе с исходными текстами». </P>
      <P align=right>Стиг Баккен (Stig Bakken), </P>
      <P align=right>FAST Search &amp; Transfer ASA </P>
      <P align=right><A href="http.html://www.fast.no/">http://www.fast.no/</A> </P>
      <P>«Я использовал РНР с первых дней, еще с версии PHP/FI 1.x. Мне 
      понравилось, что я могу обрабатывать формы и настраивать страницы «на 
      ходу» при помощи такого простого языка. Вместе с потребностями моей 
      компании развивался и РНР. </P>
      <P>В наши дни РНР обладает исключительно богатыми возможностями. Мы 
      используем его практически во всех создаваемых web-сайтах, включая 
      32bit.com и DevShed.com. Мы даже воспользовались им в Info West для 
      реализации службы поддержки, управления учетными записями и отслеживания 
      портов. </P>
      <P>Эволюция РНР и признание его мировым сообществом — классический пример 
      успешного ведения проекта с открытыми исходными текстами. Широта взглядов 
      создателей, поддержка сообщества и хорошее сопровождение кодовой базы 
      привели РНР к успеху, о котором многие коммерческие проекты могут лишь 
      мечтать. Я с оптимизмом смотрю в будущее РНР и рекомендую каждому 
      web-разработчику попробовать его в деле. Возможно, вы, как и я, уже не 
      расстанетесь с ним». </P>
      <P align=right>Рэнди Косби (Randy Cosby), </P>
      <P align=right>президент nGenuity, Inc. DevShed </P>
      <P align=right><A 
      href="http.html://www.devshed.com/">http://www.devshed.com/</A> </P>
      <P><A name=k></A>Вводный пример</P>
      <P>Пример, приведенный в листинге 1.1, наглядно показывает, как легко РНР 
      интегрируется с HTML-кодом. </P>
      <P>Листинг 1.1. Создание динамической страницы РНР &nbsp; </P>
      <P><STRONG>&lt;? </STRONG></P>
      <P><STRONG>// Присвоить значения нескольким переменным</STRONG> </P>
      <P><STRONG>$site_title = "РНР Recipes"; </STRONG></P>
      <P><STRONG>$bg_color = "white"; </STRONG></P>
      <P><STRONG>$user_name = "Chef Luigi"; </STRONG></P>
      <P><STRONG>?&gt; </STRONG></P>
      <P><STRONG>&lt;html&gt; </STRONG></P>
      <P><STRONG>&lt;head&gt; </STRONG></P>
      <P><STRONG>&lt;title&gt;&lt;? print $site_title; ?&gt;&lt;/title&gt; 
      </STRONG></P>
      <P><STRONG>&lt;/head&gt; </STRONG></P>
      <P><STRONG>&lt;body bgcolor="&lt;? print $bg color; ?&gt;" &gt; 
      </STRONG></P>
      <P><STRONG>&lt;? </STRONG></P>
      <P><STRONG>// Вывести приветствие с датой и именем пользователя. print " 
      </STRONG></P>
      <P><STRONG>РНР Recipes | ".dateC'F d. Y")." &lt;br&gt; Greetings, 
      $user_name! &lt;br&gt; </STRONG></P>
      <P><STRONG>"; </STRONG></P>
      <P><STRONG>?&gt; </STRONG></P>
      <P><STRONG>&lt;/body&gt; </STRONG></P>
      <P><STRONG>&lt;/html&gt; </STRONG></P>
      <P>На рис. 1.1 показано, как выглядит сценарий при выполнении в 
      браузере.</P>
      <P><IMG src="2_1_1.1Rus.jpg"></P>
      <P>Рис. 1.1. Результаты выполнения сценария в браузере</P>
      <P>Неплохо, правда? Я уверен, что читатель уже перебирает в уме новые 
      возможности. Но не будем торопиться — возможно, вам еще придется 
      установить и настроить РНР на своем компьютере. Этой теме посвящены 
      следующие разделы. </P>
      <P><A name=l></A>Загрузка РНР/Apache</P>
      <P>Прежде чем следовать дальше, я рекомендую потратить немного времени на 
      загрузку, установку и настройку РНР и web-сервера на вашем компьютере. 
      Хотя РНР совместим с разными web-серверами, я предполагаю, что вы 
      используете Apache — во-первых, это самый популярный web-сервер на 
      сегодняшний день, во-вторых, он чаще всего работает с РНР. Впрочем, в 
      целом процессы установки для разных web-серверов имеют много общего. </P>
      <P>Поставку РНР можно загрузить с официального сайта РНР или с любого из 
      «зеркальных» сайтов по всему миру. Самый свежий список «зеркальных» сайтов 
      находится по адресу <A href="http.html://www.php.net/">http://www.php.net/</A>. 
      При загрузке РНР можно выбрать один из двух форматов: </P>
      <UL>
        <LI>исполняемый формат Win32; 
        <LI>исходный текст. </LI></UL>
      <P>Исполняемый формат Win32 предназначен для пользователей Windows 95/98/ 
      NT/2000. Хотя исходный текст можно откомпилировать и на платформе Windows, 
      для большинства пользователей это необязательно. Впрочем, если вы 
      настаиваете на компиляции (кстати, в книге этот процесс не 
      рассматривается), вам понадобится компилятор Visual C++ одной из последних 
      версий. За подробностями компиляции обращайтесь по адресу 
      http://www.php.net/ version4/win32build.php. Установка исполняемых файлов 
      Win32 описана далее в этой главе. </P>
      <P>Пользователям других систем придется самостоятельно откомпилировать 
      исходный текст программы. Хотя многих новичков эта перспектива приводит в 
      ужас, на самом деле это довольно просто. Возможно, вас интересует, 
      распространяется ли РНР в формате RPM (RedHat Package Manager)? Да, 
      распространяется, хотя эти пакеты не представлены на официальном сайте 
      РНР. За инструкциями и дополнительной информацией о местонахождении 
      различных поставок обращайтесь к материалам электронных конференций. 
      Обобщенный процесс компиляции рассматривается далее. </P>
      <P>Зайдите на сайт http://www.php.net и загрузите с него ту поставку, 
      которая лучше всего отвечает вашим потребностям. Время загрузки зависит от 
      типа и скорости подключения. Кроме того, имеется возможность получить 
      документацию. Я настоятельно рекомендую выбрать самую новую версию. </P>
      <P>На 
      момент издания книги последней устойчиво работающей версией был РНР 4.0.3. 
      Конечно, пакет РНР постоянно развивается, и номер версии непременно 
      изменится. Я рекомендую загрузить самую свежую надежную версию 
      продукта.</P>
      <P>Если вы еще не установили сервер Apache, вам также следует выбрать его 
      последнюю версию. Пакеты находятся в каталоге 
      http://www.apache.org/dist/binaries, содержащем подкаталоги для разных 
      операционных систем. Загрузите вариант, соответствующий вашим 
      потребностям. Подробное описание настройки РНР для всех существующих 
      платформ и web-серверов выходит за рамки этой книги, поэтому я уделю 
      основное внимание серверу Apache. Независимо от того, какой web-сервер вы 
      собираетесь использовать, я рекомендую прочитать дальнейшие разделы, 
      посвященные настройке, — вы получите некоторое представление о тех общих 
      проблемах, с которыми можете столкнуться. </P>
      <P>Установка новых программ нередко превращается в непростое испытание для 
      новичков. Однако разработчики РНР предприняли дополнительные усилия для 
      того, чтобы установка РНР проходила относительно просто. В следующих 
      разделах перечислены действия, которые необходимо выполнить для установки 
      и настройки РНР в Win32 и на других платформах. </P>
      <P>В дальнейших главах вы познакомитесь с сервером баз данных MySQL, и на 
      примере этого популярного продукта будет продемонстрирован процесс 
      интеграции web-приложений с базами данных. Чтобы поэкспериментировать с 
      этими примерами, вам придется установить пакет MySQL 
      (http://www.mysql.com). MySQL, как и РНР, существует в версиях для Windows 
      и для других платформ. Хотя в документации MySQL приведены подробные 
      инструкции по установке, возможно, вам стоит предварительно просмотреть 
      начало главы 11, где приводится общая информация о сервере баз данных 
      MySQL.</P>
      <P><A name=m></A>Установка и настройка</P>
      <P>Предполагается, что к настоящему моменту вы успешно загрузили РНР и 
      Apache. Следующий шаг — выбор способа установки. Для компьютеров, не 
      использующих систему Windows, существует три варианта: двоичный файл CGI, 
      статический модуль Apache и динамический модуль Apache. Скорее всего, вы 
      не захотите строить РНР в виде двоичного файла CGI. Более того, построение 
      РНР в виде серверного модуля имеет некоторые преимущества, поэтому я уделю 
      внимание построению РНР в виде статического и динамического модуля. 
      Главное различие между этими двумя вариантами заключается в том, что при 
      любых изменениях в статическом модуле РНР придется заново компилировать и 
      Apache, и РНР, а изменения в динамическом модуле РНР потребуют компиляции 
      только РНР, без сервера. </P>
      <P>На компьютерах с системой Windows РНР может устанавливаться в виде либо 
      двоичного файла CGI, либо статического модуля Apache. На этот раз я опишу 
      построение двоичного файла CGI, потому что пользователи Windows обычно 
      используют вместо Apache другие web-серверы (например, Microsoft Internet 
      Information Server или Microsoft Personal Web Server). CGI-версия легко 
      интегрируется с этими серверами. Хотя описанный процесс установки 
      относится к РНР/Apache, установка для перечисленных выше web-серверов 
      выполняется практически так же. </P>
      <P>Как говорилось ранее, РНР4 поддерживает разнообразные web-серверы, в 
      том числе AOL Server, Netscape Enterprise Server, Microsoft IIS, Zeus и 
      многие другие. Впрочем, я ограничусь описанием установки для сервера 
      Apache. За подробными инструкциями о том, как установить РНР для других 
      серверов, обращайтесь к документации РНР по адресу <A 
      href="http.html://www.php.net/">http://www.php.net/</A>.</P>
      <P><A name=n></A>Системы, не входящие в семейство Windows</P>
      <P>Независимо от того, какой вариант был выбран, установка начинается с 
      распаковки архивов. Для распаковки выполните два простых действия: </P>
      <OL>
        <LI>Выполните следующие команды: </LI></OL>
      <BLOCKQUOTE>
        <P>gunzip apache_1.3.9.tar.gz </P>
        <P>gunzip php-4.0.0.tar.gz </P></BLOCKQUOTE>
      <P>После завершения распаковки остаются файлы с расширением *.tar. </P>
      <OL start=2>
        <LI>Извлеките файлы поставки из архивов: </LI></OL>
      <BLOCKQUOTE>
        <P>tar -zxvf apache_1.3.x.tar </P>
        <P>tar -zxvf php-4.0.x.tar </P></BLOCKQUOTE>
      <P>С этого момента начинается основной процесс установки. </P>
      <P>Модуль Apache </P>
      <P>Установка РНР в виде модуля Apache выполняется довольно просто. Ниже 
      подробно описаны все необходимые действия: </P>
      <OL>
        <LI>Перейдите в каталог Apache: 
        <P>cd apache_1.3.x</P>
        <LI>Настройте Apache. Выберите путь по своему усмотрению, но помните, 
        что за ним не должна следовать косая черта: 
        <P>./configure -prefix=[путь]</P>
        <LI>Перейдите в каталог РНР; настройте, соберите и установите поставку. 
        Параметр -with-config-file-path задает каталог, в котором будет 
        находиться файл конфигурации РНР. Обычно этот файл находится в каталоге 
        /usr/local/lib, но вы можете выбрать другой каталог по своему 
        усмотрению: 
        <P>./configure -with-apache=../apache_1.3.x 
        -with-config-file-path=[путь]</P>
        <P>make</P>
        <P>make install </P>
        <LI>Вернитесь в каталог Apache. Теперь вы можете изменить конфигурацию, 
        собрать и установить Apache. Параметр -other-configuration-options 
        относится к любым специальным параметрам конфигурации, которые вы хотели 
        бы передать web-серверу Apache. Данная тема выходит за рамки книги. 
        Полное описание параметров приведено в документации Apache: 
        <P>./configure -activate-module=src/modules/php4/libphp4.a</P>
        <P>-other-configuration-options</P>
        <P>make</P>
        <P>make install </P>
        <LI>На последнем этапе происходит редактирование файла Apache 
        httpd.conf. Одни модификации относятся к Apache, другие необходимы для 
        того, чтобы сценарии РНР распознавались и передавались web-серверу. 
        Сначала найдите такую строку: </LI></OL>
      <BLOCKQUOTE>
        <P>ServerName new.host.name </P></BLOCKQUOTE>
      <P>Приведите ее к следующему виду: </P>
      <P>ServerName localhost </P>
      <P>Затем найдите строки </P>
      <P>#AddType application/x-httpd-php .php .php4</P>
      <P>#AddType application/x-httpd-php-source .php .phps</P>
      <P>Чтобы файлы с поддержкой РНР правильно работали на сервере, эти строки 
      необходимо раскомментировать. Для этого достаточно удалить знак фунта (#) 
      в начале каждой строки. Сохраните файл и поднимитесь в иерархии каталогов 
      на один уровень вверх. Запустите сервер Apache следующей командой: </P>
      <P>./bin/apachectl start</P>
      <P>Voila! PHP и Apache готовы к работе. Для проверки сохраните приведенный 
      ниже фрагмент в файле phpinfo.php в корневом каталоге документов Apache — 
      каталоге htdocs, находящемся в установочном каталоге Apache: </P>
      <P>&lt;? </P>
      <P>php info();</P>
      <P>?&gt;</P>
      <P>Откройте файл в браузере на сервере. В окне появляется длинный перечень 
      сведений о конфигурации РНР. Вы успешно установили РНР в виде модуля 
      Apache. </P>
      <P>Динамический модуль Apache </P>
      <P>Динамические модули удобны тем, что они позволяют обновлять поставку 
      РНР без перекомпиляции web-сервера. Apache рассматривает поддержку РНР как 
      один </P>
      <P>из своих многочисленных модулей вроде ModuleRewrite или ModuleSpelling. 
      Этот вариант особенно хорош в ситуациях, когда в РНР позднее будет 
      добавляться поддержка новых возможностей — например, шифрования. Все, что 
      вам придется сделать — переконфигурировать/откомпилировать РНР с 
      поддержкой шифрования, и вы сможете немедленно использовать новую 
      возможность в web-приложениях. Процесс установки описан ниже: </P>
      <OL>
        <LI>Перейдите в каталог Apache: </LI></OL>
      <BLOCKQUOTE>
        <P>cd apache_1.3.x</P></BLOCKQUOTE>
      <OL start=2>
        <LI>Настройте Apache. Выберите путь по своему усмотрению, но помните, 
        что за ним не должна следовать косая черта. Параметр 
        -other-configuration-options относится к любым специальным параметрам 
        конфигурации, которые вы хотели бы передать web-серверу Apache. Данная 
        тема выходит за рамки книги. Полное описание параметров приведено в 
        документации Apache. </LI></OL>
      <BLOCKQUOTE>
        <P>./configure -prefix=[путь] -enable-module=so 
        -other-configuration-options</P></BLOCKQUOTE>
      <OL start=3>
        <LI>Соберите сервер Apache. После ввода команды make на экран выводится 
        серия сообщений: </LI></OL>
      <BLOCKQUOTE>
        <P>make</P></BLOCKQUOTE>
      <OL start=4>
        <LI>Установите сервер Apache. После ввода команды make install на экран 
        выводится следующая серия сообщений. После успешного завершения 
        установки на экране появляется соответствующее сообщение: </LI></OL>
      <BLOCKQUOTE>
        <P>make install</P></BLOCKQUOTE>
      <OL start=5>
        <LI>Если предыдущие действия прошли без ошибок, можно переходить к 
        редактированию файла httpd.conf. Этот файл находится в подкаталоге conf 
        каталога, указанного на шаге 2. Откройте файл в текстовом редакторе и 
        найдите строку </LI></OL>
      <BLOCKQUOTE>
        <P>ServerName new.host.name </P>
        <P>Приведите ее к следующему виду: </P>
        <P>ServerName local host </P></BLOCKQUOTE>
      <OL start=6>
        <LI>Перейдите в тот каталог, где находится пакет РНР. Настройте, 
        соберите и установите РНР. В параметрах указывается путь к каталогу, 
        содержащему файл apxs, — подкаталогу bin каталога, путь к которому был 
        указан на шаге 2: </LI></OL>
      <BLOCKQUOTE>
        <P>./configure -with-apxs=[путь/k/apxs] </P>
        <P>make </P>
        <P>make install </P></BLOCKQUOTE>
      <OL start=7>
        <LI>Откройте файл Apache httpd.conf для очередной модификации. Для 
        обеспечения правильного лексического анализа входящих запросов на файлы 
        с поддержкой РНР расширение должно совпадать с одним из расширений, 
        указанных в файле конфигурации сервера Apache, httpd.conf. Файл содержит 
        параметры, которые могут изменяться по усмотрению администратора; 
        некоторые из них имеют прямое отношение к РНР. Откройте файл httpd.conf 
        в своем текстовом редакторе. В конце файла присутствуют две строки 
        следующего вида: </LI></OL>
      <BLOCKQUOTE>
        <P>#AddType application/x-httpd-php .php .php4</P>
        <P>#AddType application/x-httpd-php-source .php .phps</P></BLOCKQUOTE>
      <OL start=8>
        <LI>Чтобы файлы с поддержкой РНР правильно работали на сервере, эти 
        строки необходимо раскомментировать. Для этого следует удалить'знак 
        фунта (#) в начале каждой строки. 
        <LI>Сохраните файл и перейдите на один уровень вверх в иерархии 
        каталогов (командой cd). Запустите Apache следующей командой: </LI></OL>
      <BLOCKQUOTE>
        <P>./bin/apachectl start </P></BLOCKQUOTE>
      <P>Voila! РНР и Apache готовы к работе. </P>
      <P>Для проверки сохраните приведенный ниже фрагмент в файле phpinfo.php в 
      корневом каталоге документов Apache — каталоге htdocs, находящемся в 
      установочном каталоге Apache: </P>
      <P>&lt;? </P>
      <P>php_info():&nbsp; </P>
      <P>?&gt; </P>
      <P>Откройте файл в браузере на сервере. В окне появляется длинный перечень 
      сведений о конфигурации РНР. Вы успешно установили РНР в виде 
      динамического модуля Apache. </P>
      <P><A href="http.html://doks.gorodok.net/19214" name=o></A>Установка в Windows 
      95/98/NT</P>
      <P>Если вам когда-нибудь приходилось устанавливать новые приложения в 
      операционной системе Windows, вероятно, это не вызывало у вас особых 
      трудностей. Вы щелкаете на нескольких кнопках, отвечаете на несколько 
      вопросов — и все готово. Так же обстоит дело и с установкой Apache и РНР 
      на компьютерах с системой Windows.</P>
      <OL>
        <LI>Дважды щелкните на значке исполняемого файла Apache. Запускается 
        процесс установки, и на экране появляется начальное окно программ 
        мастера (wizard) установки. Внимательно прочитайте текст лицензионного 
        соглашения и подтвердите его. 
        <LI>Мастер запрашивает каталог для установки и предлагает вариант по 
        умолчанию (C:\Program Files\Apache Group\Apache). Возможно, вам 
        захочется сократить его до C:\Apache — решайте сами. 
        <LI>Затем вам будет предложено указать имя, под которым программа будет 
        находиться в меню Пуск (Start). Введите имя по своему усмотрению или 
        подтвердите предложенный вариант. 
        <LI>Следующий вопрос относится к типу установки. Выберите вариант 
        Typical (Стандартная установка). После того как решение будет принято, 
        выполняется установка. 
        <LI>На следующем шаге редактируется файл httpd.conf, находящийся в 
        подкаталоге conf каталога, указанного на шаге 2. Откройте файл в 
        текстовом редакторе и найдите строку ServerAdmin yourname@yoursite.com 
        </LI></OL>
      <BLOCKQUOTE>
        <P>Замените yourname@yoursite.com правильными данными. Затем укажите 
        правильное имя сервера (если его нет, воспользуйтесь именем 
        localhost):</P>
        <P>ServerName localhost </P></BLOCKQUOTE>
      <OL start=6>
        <LI>Запустите Apache и убедитесь в том, что все работает правильно. 
        Конкретные действия зависят от того, в какой системе вы работаете. 
      </LI></OL>
      <P>Если вы используете Windows NT, выберите в меню Пуск (Start) команду 
      Install Apache as Service (NT Only). Затем вызовите панель управления, 
      откройте окно Службы (Services), выберите Apache и щелкните на кнопке Пуск 
      (Start). Apache запускается и будет запускаться автоматически при каждой 
      последующей загрузке системы. </P>
      <OL start=7>
        <LI>Запустите браузер, установленный на сервере, и введите адрес http: 
        /local host/. В окне открывается страница с сообщением о том, что 
        установка была выполнена успешно. 
        <LI>Следующий этап — установка РНР. Перейдите в каталог, где находится 
        пакет РНР, и распакуйте его в произвольный каталог. 
        <LI>Перейдите в каталог, в который были помещены распакованные файлы, и 
        найдите в нем файл php.ini-dist. Переименуйте его в php.ini и 
        переместите в каталог C:\Windows. 
        <LI>Вернитесь в каталог РНР и найдите два других файла, php4ts.dll и 
        Mscvrt.dll. Поместите эти файлы в каталог C:\Windows\System\. Возможно, 
        файл Mscvrt.dll уже существует — если вам будет предложено его 
        перезаписать, не соглашайтесь. 
        <LI>Вернитесь к файлу Apache http.conf и откройте его в текстовом 
        редакторе. Необходимо внести еще несколько изменений. Найдите строку 
        </LI></OL>
      <BLOCKQUOTE>
        <P>ScriptAlias /cgi-bin/ "C:/Apache/cgi-bin/"</P>
        <P>Непосредственно под этой строкой введите следующую: </P>
        <P>ScriptAlias /php4/ "C:/php4/"</P>
        <P>Найдите секцию AddType. Вы увидите две закомментированные строки: 
</P>
        <P>#AddType application/x-httpd-php3. phtml</P>
        <P>#AddType application/x-httpd-php3-source .phps</P>
        <P>Непосредственно под этими строками добавьте следующие: </P>
        <P>AddType application/x-httpd-php .phtml .php&nbsp;</P>
        <P>AddType application/x-httpd-php-source .phps</P>
        <P>Прокрутите содержимое файла и найдите следующий закомментированный 
        фрагмент: </P>
        <P>#</P>
        <P># Action lets you define media types that will execute a script 
        whenever</P>
        <P># a matching file is called. This eliminates the need for repeated 
        URL</P>
        <P># pathnames for oft-used CGI file processors.</P>
        <P># Format: Action media/type /cgi-script/location</P>
        <P># Format: Action handler-name /cgi-script/location&nbsp;</P>
        <P>#</P>
        <P>Добавьте под этим фрагментом следующую строку: </P>
        <P>Action application/x-httpd-php /php4/php.exe</P></BLOCKQUOTE>
      <OL start=12>
        <LI>РНР и Apache готовы к работе. </LI></OL>
      <P>Для проверки сохраните приведенный ниже фрагмент в файле phpinfo.php в 
      корневом каталоге документов Apache — каталоге htdocs. Он находится в том 
      каталоге, который был указан на шаге 2: </P>
      <P>&lt;? </P>
      <P>php_info();</P>
      <P>?&gt;</P>
      <P>Хотя 
      при успешном завершении действий, описанных выше, вы сможете использовать 
      web-сервер и РНР для тестирования, это еще не значит, что ваш web-сервер 
      будет доступен из World Wide Web. За информацией по этому вопросу 
      обращайтесь&nbsp; на официальный сайт Apache (<A 
      href="http.html://www.apache.org/">http://www.apache.org/</A>). Более того, 
      хотя описанная процедура позволяет работать с пакетом РНР, вероятно, вы 
      захотите изменить конфигурацию РНР так, чтобы она лучше соответствовала 
      вашим потребностям. Эта тема рассматривается в следующем разделе 
      «Конфигурация РНР».</P>
      <P>Откройте файл в браузере на сервере — в окне появляется длинный 
      перечень сведений о конфигурации РНР. </P>
      <P><A name=p></A>Конфигурация РНР</P>
      <P>РНР будет правильно работать и при конфигурации, выбранной по 
      умолчанию, однако вы можете внести некоторые изменения, чтобы работа 
      пакета лучше соответствовала вашим целям. Все параметры конфигурации 
      находятся в файле php.ini, который по умолчанию копируется в каталог 
      /usr/local/lib/ в процессе установки. </P>
      <P>Независимо от платформы и web-сервера, используемого в сочетании с РНР, 
      файл php.ini содержит одинаковый набор стандартных параметров, позволяющих 
      управлять важными аспектами работы РНР. Этот файл содержит все параметры, 
      определяющие поведение пакета при выполнении сценария РНР. Содержимое 
      файла php.ini читается при запуске РНР. </P>
      <P>В версии 3.0 файл конфигурации назывался php3.ini, но в версии 4.0 ему 
      было присвоено имя php.ini.</P>
      <P>&nbsp;</P>
      <P><A name=q></A>Общие параметры конфигурации</P>
      <P>Подробное описание всех конфигурационных параметров выходит за рамки 
      этой книги, но некоторые директивы используются особенно часто и 
      заслуживают отдельного упоминания. Другие параметры упоминаются в 
      соответствующих местах следующих глав. </P>
      <P>short_open_tag [on | off] </P>
      <P>Параметр short_open_tab [on | off] определяет возможность использования 
      коротких тегов &lt;?...?&gt; наряду со стандартными тегами. </P>
      <P>asp_tags [on | off]</P>
      <P>Параметр asp_tags [on | off] определяет возможность использования тегов 
      в стиле ASP наряду со стандартными тегами. При использовании тегов в стиле 
      ASP фрагменты кода РНР оформляются следующим образом: </P>
      <P>&lt;%</P>
      <P>print "This is РНР code.";</P>
      <P>%&gt;</P>
      <P>precision [integer]</P>
      <P>Параметр precision [integer] задает количество значащих цифр, 
      отображаемых в вещественных числах. </P>
      <P>safe_mode [on | off]</P>
      <P>Безопасный режим особенно удобен в случае, если в вашей системе 
      работают несколько пользователей. Включение безопасного режима 
      гарантирует, что пользователь не сможет применить сценарий РНР для 
      получения доступа к другому файлу в системе — например, файлу passwd на 
      компьютере Linux. Параметр safe_mode работает только в CGI-версии РНР. За 
      дополнительной информацией по этой теме обращайтесь к главе 16. </P>
      <P>max_execution_time [integer]</P>
      <P>Параметр max_execution_time [integer] определяет максимальную 
      продолжительность выполнения сценариев РНР в секундах. Такое ограничение 
      предотвращает поглощение ценных системных ресурсов сценариями, содержащими 
      ошибки. </P>
      <P>error_reporting [1-8]</P>
      <P>Параметр error_reporting [1-8] определяет уровень выдачи сообщений об 
      ошибках в РНР. Чем выше значение, тем «чувствительнее» РНР реагирует на 
      ошибки. </P>
      <P>
      <TABLE cellSpacing=0 cellPadding=0 width=350 border=1>
        <TBODY>
        <TR>
          <TD align=middle width="23%">Значение </TD>
          <TD align=middle width="77%">Чувствительность </TD></TR>
        <TR>
          <TD align=middle width="23%">1 </TD>
          <TD width="77%">Обычные ошибки</TD></TR>
        <TR>
          <TD align=middle width="23%">2 </TD>
          <TD width="77%">Обычные предупреждения </TD></TR>
        <TR>
          <TD align=middle width="23%">4</TD>
          <TD width="77%">Ошибки лексического анализатора </TD></TR>
        <TR>
          <TD align=middle width="23%">8</TD>
          <TD width="77%">Замечания </TD></TR></TBODY></TABLE></P>
      <P>display_errors [on | off]</P>
      <P>Параметр display_errors[on | off] управляет выводом информации об 
      ошибках в браузере. </P>
      <P>log_errors</P>
      <P>Параметр log_errors определяет, следует ли регистрировать ошибки в 
      файле. При включении параметра log_errors файл, в котором регистрируются 
      ошибки, назначается при помощи параметра error_log. </P>
      <P>error_log [filename]</P>
      <P>Параметр error_log определяет файл, в котором регистрируются ошибки при 
      включенном параметре log_errors. </P>
      <P>magic_quotes_gpc</P>
      <P>При активизации параметра magic_quotes_gpc все специальные символы, 
      содержащиеся в пользовательских данных или в базе, автоматически 
      экранируются обратной косой чертой. Кстати, сокращение gрс означает 
      «get/post/cookie». </P>
      <P>Лично я считаю, что параметр magic_quotes_gpc эффективнее отключить и 
      использовать явное экранирование специальных символов. Какой бы способ вы 
      ни выбрали, любые компромиссы приведут к порче данных. Если параметр 
      magic_quotes_gpc </P>
      <P>включен, никогда не экранируйте специальные символы обратной косой 
      чертой; в противном случае не забывайте делать это всегда. </P>
      <P>track_vars </P>
      <P>Параметр track_vars включает отслеживание нескольких важных массивов 
      сеансовых переменных, в том числе $HTTP_GET_VARS[], $HTTP_POST_VARS[], 
      $HTTP_POST_FILES, $HTTP_COOKIE_VARS[], $HTTP_ENV_VARS[] и 
      $HTTP_SERVER_VARS[]. Эти массивы подробно описаны в главе 13. </P>
      <P>Помните, что кроме перечисленных параметров существует множество 
      других. Выше перечислены лишь те параметры, которые часто применяются 
      большинством пользователей. Многие параметры будут упоминаться в 
      последующих главах. </P>
      <P><A name=r></A>Основные конструкции РНР</P>
      <P>Прежде чем переходить к изложению основного материала, занимающего 
      оставшуюся часть книги, я представлю несколько вспомогательных концепций, 
      относящихся к РНР. </P>
      <P><A name=s></A>Переход в РНР</P>
      <P>Механизм лексического анализа должен как-то отличать код РНР от других 
      элементов страницы. Идентификация кода РНР называется «переходом в РНР» 
      (escaping to РНР). Существуют четыре варианта оформления перехода в РНР: 
      </P>
      <UL>
        <LI>стандартные теги; 
        <LI>короткие теги; 
        <LI>теги script; 
        <LI>теги в стиле ASP. </LI></UL>
      <P>Стандартные теги</P>
      <P>Стандартные теги используются программистами РНР чаще остальных 
      способов, что объясняется наглядностью и удобством этой формы записи: </P>
      <P>&lt;?php print "Welcome to the world of PHP!": ?&gt;</P>
      <P>У стандартных тегов есть еще одно дополнительное преимущество: за 
      открывающей конструкцией &lt;? следуют символы php, однозначно 
      определяющие тип дальнейшего кода. Это удобно при использовании в одной 
      странице нескольких технологий — таких, как JavaScript, серверные 
      включения и РНР. Весь текст, расположенный до закрывающего тега ?&gt;, 
      интерпретируется как код РНР. </P>
      <P>Короткие теги</P>
      <P>Короткие теги обеспечивают наиболее компактную запись для перехода в 
      РНР: </P>
      <P>&lt;? print "Welcome to the world of PHP!"; ?&gt; </P>
      <P>По умолчанию короткие теги не используются, их нужно специально 
      активизировать. Это можно сделать двумя способами: </P>
      <UL>
        <LI>указать ключ -enable-short-tags при компиляции РНР; 
        <LI>включить параметр short_open_tag в файл php.ini. </LI></UL>
      <P>Теги script</P>
      <P>Некоторые текстовые редакторы ошибочно принимают код РНР за код HTML 
      (то есть визуально отображаемый текст), что нарушает работу над 
      web-страницей. Проблема решается использованием тегов script: </P>
      <P>&lt;script language="php"&gt;</P>
      <P>&lt;?php print "Welcome to the world of PHP!"; ?&gt;</P>
      <P>&lt;/script&gt;</P>
      <P>Теги в стиле ASP</P>
      <P>Четвертый и последний способ оформления внедренного кода РНР — теги в 
      стиле ASP (Active Server Page). Они похожи на короткие теги, описанные 
      выше, однако вместо вопросительного знака используется знак процента (%): 
      </P>
      <P>&lt;%php print "Welcome to the world of PHP!"; %&gt;</P>
      <P>У тегов в стиле ASP есть одна особенность, делающая запись более 
      компактной. Во внедренный код РНР не обязательно включать команду print — 
      знак равенства (=), расположенный сразу же после открывающего тега в стиле 
      ASP, приказывает лексическому механизму РНР вывести значение указанной 
      переменной: </P>
      <P>&lt;%=$variable %&gt; </P>
      <P>Этот удобный стиль позволяет использовать в страницах фрагменты вида 
      </P>
      <P>&lt;%</P>
      <P>// Присвоить значение переменной $recipe</P>
      <P>$recipe = "Lasagna":</P>
      <P>%&gt;</P>
      <P>Luigi's favorite recipe is &lt;%=$recipe;%&gt;</P>
      <P>Этот фрагмент содержит два разных сценария РНР. В первом сценарии 
      переменной $recipe присваивается значение "Lasagna". Позднее, когда 
      потребуется вывести значение $гесiре, специально для этой цели 
      используются теги в стиле ASP. Кстати, такая возможность существует и для 
      коротких тегов (&lt;?...?&gt;). </P>
      <P><A href="http.html://doks.gorodok.net/0" name=t></A>Внедрение HTML в код 
      РНР</P>
      <P>Одной из самых замечательных особенностей HTML является простота 
      использования в сочетании с другими языками — например, HTML и JavaScript 
      (см. листинг 1.2). </P>
      <P>Листинг 1.2. Вывод кода HTML средствами РНР</P>
      <P>&lt;html&gt;</P>
      <P>&lt;head&gt;</P>
      <P>&lt;title&gt;Basic PHP/HTML integration&lt;/title&gt;</P>
      <P>&lt;/head&gt;</P>
      <P>&lt;body&gt;</P>
      <P>&lt;?</P>
      <P>// Обратите внимание на присутствие тегов HTML в команде print.</P>
      <P>print "&lt;h3&gt;PHP/HTML integration is cool.&lt;/h3&gt;";</P>
      <P>?&gt;</P>
      <P>&lt;/body&gt;</P>
      <P>&lt;/html&gt;</P>
      <P><img src="2_1_1.2Rus.jpg"></P>
      <P>Рис. 1.2. Форматирование даты с использованием функции РНР date()</P>
      <P>В листинге 1.2 показано, как код HTML интегрируется прямо в команды 
      РНР. В данном примере в код РНР включаются теги заголовка третьего уровня 
      (&lt;h3&gt;...&lt;/h3&gt;). В итоговом документе эти теги ничем не 
      отличаются от обычного кода HTML. </P>
      <P>В листинге 1.3 продемонстрировано включение динамической информации в 
      web-страницу на примере вывода текущей даты в заголовке окна (рис. 1.2). 
      </P>
      <P>Листинг 1.3. Динамический вывод даты</P>
      <P>&lt;title&gt;PHP Recipes | &lt;? print (date("F d, Y")); 
      ?&gt;&lt;/title&gt;</P>
      <P>Простая функция РНР date() форматирует дату одним из нескольких 
      стандартных способов. Отформатированная дата вставляется в заголовок окна. 
      </P>
      <P>РНР также позволяет изменять формат конструкций HTML — для этого 
      соответствующая характеристика тега присваивается переменной, вставляемой 
      в файл. В листинге 1.4 эта возможность продемонстрирована на примере 
      присваивания характеристики шрифта (h3) переменной $big_font и ее 
      последующего использования при выводе текста. </P>
      <P>Листинг 1.4. Динамические теги HTML</P>
      <P>&lt;html&gt;</P>
      <P>&lt;head&gt;</P>
      <P>&lt;title&gt;PHP Recipes | &lt;? print (date("F d, Y")); 
      ?&gt;&lt;/title&gt;</P>
      <P>&lt;/head&gt;</P>
      <P>&lt;?</P>
      <P>$big_font = "h3";</P>
      <P>?&gt;</P>
      <P>&lt;body&gt;</P>
      <P>&lt;? print "&lt;$big_font&gt;PHP Recipes&lt;/$big_font&gt;"; ?&gt;</P>
      <P>&lt;/body&gt;</P>
      <P>&lt;/html&gt;</P>
      <P>Листинг 1.4 представляет собой разновидность листинга 1.3 — на этот раз 
      тег заголовка (&lt;h3&gt;...&lt;/h3&gt;) сначала присваивается переменной, 
      а затем эта переменная используется в команде print. В итоговом документе 
      эти теги ничем не отличаются от обычного кода HTML. </P>
      <P><A name=u></A>Включение нескольких сценариев РНР</P>
      <P>Для обеспечения необходимой гибкости при построении динамических 
      web-приложений можно внедрить в страницу несколько сценариев РНР (листинг 
      1.5). </P>
      <P>Листинг 1.5. Включение нескольких сценариев РНР в один документ</P>
      <P>&lt;html&gt; </P>
      <P>&lt;head&gt; </P>
      <P>&lt;title&gt; </P>
      <P>&lt;? </P>
      <P>print "Another PHP-enabled page"; </P>
      <P>Svariable = "Hello World!"; </P>
      <P>?&gt; </P>
      <P>&lt;/title&gt;&lt;/head&gt; </P>
      <P>&lt;body&gt; </P>
      <P>&lt;? print Svariable; ?&gt; </P>
      <P>&lt;/body&gt; </P>
      <P>&lt;/html&gt; </P>
      <P>Листинг 1.5 начинается как типичная (пусть несколько упрощенная) 
      страница </P>
      <P>HTML. При внедрении нескольких сценариев переменные, значения которых 
      были </P>
      <P>присвоены в одном сценарии, могут использоваться в другом сценарии той 
      же </P>
      <P>страницы. </P>
      <P><A name=v></A>Комментарии в коде РНР</P>
      <P>Комментарии следует использовать даже в относительно простых и 
      незамысловатых сценариях. В РНР существуют два формата комментариев: </P>
      <UL>
        <LI>Однострочные комментарии обычно используются для коротких пояснений 
        или примечаний, относящихся к локальному коду. 
        <LI>Многострочные комментарии обычно используются при оформлении 
        алгоритмов на псевдокоде и в более подробных объяснениях. </LI></UL>
      <P>Оба способа в конечном счете приводят к одинаковому результату и 
      совершенно не влияют на общее быстродействие сценария. Выбор варианта 
      остается за вами. </P>
      <P>Однострочные комментарии </P>
      <P>При оформлении однострочных комментариев используется два стиля 
      комментирования. Оба стиля работают абсолютно одинаково, но в них 
      используются разные служебные символы. В одном случае комментарий 
      начинается с двойного символа «косая черта» (//), а в другом — с символа 
      фунта (#). Ниже приведены примеры обоих стилей: </P>
      <P>&lt;?</P>
      <P>// Выбрать цвет роз $rose_color = "red";</P>
      <P># Выбрать цвет фиалок $violet_color = "blue";</P>
      <P>print "Roses are $rose_color, violets are $violet_color"</P>
      <P>?&gt;</P>
      <P>Конечно, оба стиля однострочных комментариев могут применяться для 
      построения искусственных многострочных комментариев, как показано в 
      следующем листинге: </P>
      <P>&lt;?</P>
      <P>// файл: example. php</P>
      <P>// автор: У.Дж.Гилмор</P>
      <P>// дата: 24 августа 2000 г.</P>
      <P>print "An example with comments";</P>
      <P>?&gt;</P>
      <P>Многострочные комментарии </P>
      <P>В РНР существует возможность построения подробных комментариев, 
      занимающих несколько строк. Такие комментарии оформляются в стиле языка С 
      — их начало и конец обозначаются символами /* и */. </P>
      <P>&lt;? </P>
      <P>/*</P>
      <P>&nbsp; Сценарий: multi_coramment_example.php</P>
      <P>&nbsp; Назначение : пример использования многострочных комментариев 
</P>
      <P>&nbsp; Автор: У.Дж.Гилмор</P>
      <P>&nbsp; Дата: 14 июня 2000 г. </P>
      <P>*/</P>
      <P>print "A multiline comment can be found at the top of this 
script!";</P>
      <P>?&gt;</P>
      <P>Как видите, многострочные комментарии особенно удобны для вывода 
      относительно длинной сводной информации обо всем сценарии или его части. 
      </P>
      <P><A href="http.html://doks.gorodok.net/1004" name=w></A>Итоги</P>
      <P>В этой главе мы рассмотрели некоторые ключевые аспекты РНР: </P>
      <UL>
        <LI>историю и особенности РНР; 
        <LI>установку и конфигурацию; 
        <LI>«переход» в РНР; 
        <LI>комментирование кода РНР. </LI></UL>
      <P>Эти вопросы закладывают основу для материала следующих глав, в которых 
      будут более подробно описаны проблемы программирования на языке РНР. В 
      конце следующей главы вы будете знать о РНР достаточно, чтобы писать 
      собственные программы. Новые знания будут применены на практике — мы 
      создадим календарь, который можно будет легко вставить в существующую 
      web-страницу. Этот проект подготовит вас к работе над web-приложением РНР 
      Recipes. </P></LI></DIV>
	  <center>
	  [ <a href="index.php">Содержание</a> | <a href="02.php">Вперед</a> ]
	  </center><br>
		<p style="color:#777777;">Другая полезная информация по языку PHP на портале <a href="http://www.php.su">PHP.SU</a></p>
		<? include_once '../../sys/inc/tfoot.php'; ?>
		</body>
		</html>