<?include'h.php';?>
<html><head>
		<title>Учебник PHP, Глава 3</title>
		<meta http-equiv="Content-type" content="text/html; charset=Windows-1251">
		</head>
		
      <DIV class=infotxt>
      <LI><A href="#a">Глава 3. Выражения, 
      операторы и управляющие конструкции </A>
      <UL>
        <LI><A href="#b">Выражения </A>
        <UL>
          <LI><A href="#c">Операнды</A> 
          <LI><A href="#d">Операторы</A> </LI></UL>
        <LI><A href="#e">Управляющие конструкции 
        </A>
        <UL>
          <LI><A href="#f">Проверка условий</A> 
          <LI><A href="#g">Альтернативное 
          ограничение блоков</A> 
          <LI><A href="#h">while</A> 
          <LI><A href="#i">do..while</A> 
          <LI><A href="#j">for</A> 
          <LI><A href="#k">foreach</A> 
          <LI><A href="#l">switch</A> 
          <LI><A href="#m">break</A> 
          <LI><A href="#n">continue</A> </LI></UL>
        <LI><A href="#o">Проект: календарь 
        событий</A> 
        <LI><A href="#p">Итоги</A> </LI></UL>
      <UL></UL><A name=a></A>
      <P>&nbsp;</P>
      <P>ГЛАВА 3</P>
      <P>Выражения, операторы и управляющие конструкции</P>
      <P>В этой главе представлены некоторые аспекты, играющие исключительно 
      важную роль в любом языке программирования, — а именно, выражения, 
      операторы и управляющие конструкции. Этот материал необходим в первую 
      очередь при создании больших и сложных приложений РНР. Если вы уже знакомы 
      с такими языками, как С и Java, эта глава всего лишь напомнит известные 
      вам понятия. Если же вы впервые встречаетесь с этими терминами и 
      понятиями, которые они обозначают, знание материала этой главы будет 
      безусловно необходимо для понимания остальных глав книги. </P>
      <P><A href="http.html://doks.gorodok.net/0" name=b></A>Выражения</P>
      <P>Выражение описывает некоторое действие, выполняемое в программе. Каждое 
      выражение состоит по крайней мере из одного операнда и одного или 
      нескольких операторов. Прежде чем переходить к примерам, демонстрирующим 
      использование выражений, необходимо поближе познакомиться с операторами и 
      операндами. </P>
      <P><A name=c></A>Операнды</P>
      <P>Операнд представляет собой некоторую величину, обрабатываемую в 
      программе. Операнды могут относиться к любому типу данных, представленному 
      в главе 2. Вероятно, вы уже знакомы с концепциями обработки и 
      использования операндов не только в повседневных математических 
      вычислениях, но и по прежнему опыту программирования. Примеры операндов: 
      </P>
      <P>$а++; // $а - операнд</P>
      <P>$sum = $val1 + $val2; // $sum. $val1 и $val2 - операнды</P>
      <P><A name=d></A>Операторы</P>
      <P>Оператор представляет собой символическое обозначение некоторого 
      действия, выполняемого с операндами в выражении. Многие операторы известны 
      любому программисту, но вы должны помнить, что РНР выполняет 
      автоматическое преобразование типов на основании типа оператора, 
      объединяющего два операнда, — в других языках программирования это 
      происходит не всегда. </P>
      <P>Приоритет и ассоциативность операторов являются важными 
      характеристиками языка программирования (см. раздел «Ассоциативность 
      операторов» этой главы). В табл. 3.1 приведен полный список всех 
      операторов, упорядоченных по убыванию приоритета. Приоритет, 
      ассоциативность и сами операторы подробно рассматриваются в разделах, 
      следующих за таблицей. </P>
      <P>Таблица 3.1. Операторы РНР</P>
      <TABLE cellSpacing=0 cellPadding=0 width="100%" border=1>
        <TBODY>
        <TR>
          <TD align=middle width=110>Оператор</TD>
          <TD align=middle width=127>Ассоциативность </TD>
          <TD align=middle width=241>Цель </TD></TR>
        <TR>
          <TD width=110>( )</TD>
          <TD align=middle width=127>-</TD>
          <TD width=241>Изменение приоритета</TD></TR>
        <TR>
          <TD width=110>new</TD>
          <TD align=middle width=127>-</TD>
          <TD width=241>Создание экземпляров объектов</TD></TR>
        <TR>
          <TD width=110>! ~</TD>
          <TD align=middle width=127>П</TD>
          <TD width=241>
            <P align=left>Логическое отрицание, поразрядное отрицание</P></TD></TR>
        <TR>
          <TD width=110>++ --</TD>
          <TD align=middle width=127>П</TD>
          <TD width=241>Инкремент, декремент</TD></TR>
        <TR>
          <TD width=110>@</TD>
          <TD align=middle width=127>П</TD>
          <TD width=241>Маскировка ошибок</TD></TR>
        <TR>
          <TD width=110>/ * %</TD>
          <TD align=middle width=127>Л</TD>
          <TD width=241>Деление, умножение, остаток</TD></TR>
        <TR>
          <TD width=110>+ - .</TD>
          <TD align=middle width=127>Л</TD>
          <TD width=241>Сложение, вычитание, конкатенация</TD></TR>
        <TR>
          <TD width=110>&lt;&lt;&nbsp; &gt;&gt;</TD>
          <TD align=middle width=127>Л</TD>
          <TD width=241>Сдвиг влево, сдвиг вправо (поразрядный)</TD></TR>
        <TR>
          <TD width=110>&lt; &lt;=&nbsp; &gt;&nbsp; &gt;=</TD>
          <TD align=middle width=127>-</TD>
          <TD width=241>Меньше, меньше или равно, больше, больше или 
        равно</TD></TR>
        <TR>
          <TD width=110>== !=&nbsp; ===&nbsp; &lt;&gt;</TD>
          <TD align=middle width=127>-</TD>
          <TD width=241>Равно, не равно, идентично, не равно</TD></TR>
        <TR>
          <TD width=110>&amp;&nbsp; ^&nbsp; |</TD>
          <TD align=middle width=127>Л</TD>
          <TD width=241>Поразрядные операции AND, XOR и OR</TD></TR>
        <TR>
          <TD width=110>&amp;&amp; ||</TD>
          <TD align=middle width=127>Л</TD>
          <TD width=241>Логические операции AND и OR</TD></TR>
        <TR>
          <TD width=110>?:</TD>
          <TD align=middle width=127>П</TD>
          <TD width=241>Тернарный оператор</TD></TR>
        <TR>
          <TD width=110>=&nbsp; +=&nbsp; *=&nbsp; /=&nbsp; .=</TD>
          <TD align=middle width=127>П</TD>
          <TD width=241>Операторы присваивания</TD></TR>
        <TR>
          <TD width=110>%=&nbsp; &amp;=&nbsp; |=&nbsp; ^=</TD>
          <TD align=middle width=127>&nbsp;</TD>
          <TD width=241>&nbsp;</TD></TR>
        <TR>
          <TD width=110>&lt;&lt;=&nbsp; &gt;&gt;=</TD>
          <TD align=middle width=127>&nbsp;</TD>
          <TD width=241>&nbsp;</TD></TR>
        <TR>
          <TD width=110>AND XOR OR</TD>
          <TD align=middle width=127>Л</TD>
          <TD width=241>Логические операции AND, XOR и OR</TD></TR></TBODY></TABLE>
      <P>После знакомства с концепциями операторов и операндов следующие примеры 
      выражений выглядят значительно понятнее: </P>
      <P>$а = 5;&nbsp;&nbsp; // Присвоить целое число 5 переменной $а</P>
      <P>$а = "5":&nbsp;&nbsp; // Присвоить строковую величину "5" переменной 
      $а</P>
      <P>$sum = 50 + $some_int;&nbsp; // Присвоить сумму 50 + $some_int 
      переменной $sum</P>
      <P>Swine = "Zinfandel";&nbsp;&nbsp; // Присвоить строку "Zinfandel" 
      переменной $wine</P>
      <P>$inventory++:&nbsp;&nbsp; // Увеличить значение $inventory на 1</P>
      <P>Объединяя операторы и операнды, вы получите более сложные выражения для 
      выполнения нетривиальных вычислений. Пример: </P>
      <P>$total_cost = $cqst + (Scost * 0.06): // прибавить к цене 6-процентный 
      налог</P>
      <P>Приоритет операторов</P>
      <P>Приоритет является характеристикой операторов, определяющей порядок 
      выполнения действий с окружающими операндами. В РНР используются те же 
      правила приоритета, что и в школьном курсе математики. Пример: </P>
      <P>$total_cost = $cost + $cost * 0.06;</P>
      <P>Приведенная команда эквивалентна следующей: </P>
      <P>$total cost = $cost + ($cost * 0.06);</P>
      <P>Это объясняется тем, что оператор умножения обладает более высоким 
      приоритетом по сравнению с оператором сложения. </P>
      <P>Ассоциативность операторов</P>
      <P>Ассоциативность оператора определяет последовательность выполнения 
      операторов с одинаковым приоритетом (см. табл. 3.1). Выполнение может 
      происходить в двух направлениях: либо слева направо, либо справа налево. 
      При ассоциативности первого типа операции, входящие в выражение, 
      выполняются слева направо. Например, команда</P>
      <P>$value = 3*4*5*7*2;</P>
      <P>эквивалентна следующей команде: </P>
      <P>$value = ((((3 * 4) * 5) * 7) * 2);</P>
      <P>Результат вычислений равен 840. Это объясняется тем, что оператор 
      умножения (*) обладает левосторонней ассоциативностью. Операторы с 
      правосторонней ассоциативностью и одинаковым приоритетом обрабатываются 
      справа налево. Например, фрагмент </P>
      <P>$с = 5;</P>
      <P>$value = $а - $b - $с;</P>
      <P>эквивалентен фрагменту </P>
      <P>$c = 5;</P>
      <P>$value = ($а - ($b - $с));</P>
      <P>При обработке этого выражения переменным $value, $a, $b и $с будет 
      присвоено значение 5. Это объясняется тем, что оператор присваивания (=) 
      обладает правосторонней ассоциативностью. </P>
      <P>Математические операторы</P>
      <P>Математические операторы (табл. 3.2) предназначены для выполнения 
      различных математических операций и часто применяются в большинстве 
      программ РНР. К счастью, их использование обходится без проблем. </P>
      <P>Таблица 3.2. Математические операторы</P>
      <TABLE cellSpacing=0 cellPadding=0 width="100%" border=1>
        <TBODY>
        <TR>
          <TD vAlign=top width=73 height=18>
            <P>Пример</P></TD>
          <TD vAlign=top width=96 height=18>
            <P>Название</P></TD>
          <TD vAlign=top width=220 height=18>
            <P>Результат</P></TD></TR>
        <TR>
          <TD vAlign=top width=73 height=17>
            <P>$а + $b</P></TD>
          <TD vAlign=top width=96 height=17>
            <P>Сложение</P></TD>
          <TD vAlign=top width=220 height=17>
            <P>Сумма $а и $b</P></TD></TR>
        <TR>
          <TD vAlign=top width=73 height=13>
            <P>$а-$b</P></TD>
          <TD vAlign=top width=96 height=13>
            <P>Вычитание</P></TD>
          <TD vAlign=top width=220 height=13>
            <P>Разность $а и $b</P></TD></TR>
        <TR>
          <TD vAlign=top width=73 height=14>
            <P>$а*$b</P></TD>
          <TD vAlign=top width=96 height=14>
            <P>Умножение</P></TD>
          <TD vAlign=top width=220 height=14>
            <P>Произведение $а и $b</P></TD></TR>
        <TR>
          <TD vAlign=top width=73 height=14>
            <P>$а/$b</P></TD>
          <TD vAlign=top width=96 height=14>
            <P>Деление</P></TD>
          <TD vAlign=top width=220 height=14>
            <P>Частное от деления $а на $b</P></TD></TR>
        <TR>
          <TD vAlign=top width=73 height=18>
            <P>$а % $b</P></TD>
          <TD vAlign=top width=96 height=18>
            <P>Остаток</P></TD>
          <TD vAlign=top width=220 height=18>
            <P>Остаток от деления $а на $b</P></TD></TR></TBODY></TABLE>
      <P>РНР содержит широкий ассортимент стандартных математических функций для 
      выполнения основных преобразований и вычисления логарифмов, квадратных 
      корней, геометрических величин и т. д. За обновленным списком таких 
      функций обращайтесь к документации. </P>
      <P>Операторы присваивания</P>
      <P>Операторы присваивания задают новое значение переменной. В простейшем 
      варианте оператор присваивания ограничивается изменением величины, в 
      других вариантах (называемых сокращенными операторами присваивания) перед 
      присваиванием выполняется некоторая операция. Примеры таких операторов 
      приведены в табл. 3.3. </P>
      <P>Таблица 3.3. Операторы присваивания</P>
      <TABLE cellSpacing=0 cellPadding=0 width="100%" border=1>
        <TBODY>
        <TR>
          <TD align=middle width=79>Пример</TD>
          <TD align=middle width=130>&nbsp;Название </TD>
          <TD align=middle width=269>Результат </TD></TR>
        <TR>
          <TD width=79>$а = 5;&nbsp; </TD>
          <TD width=130>&nbsp;Присваивание </TD>
          <TD width=269>Переменная $а равна 5&nbsp; </TD></TR>
        <TR>
          <TD width=79>$а += 5;&nbsp; </TD>
          <TD width=130>&nbsp;Сложение с присваиванием </TD>
          <TD width=269>&nbsp;Переменная $а равна сумме $а и 5 </TD></TR>
        <TR>
          <TD width=79>$а *= 5;&nbsp; </TD>
          <TD width=130>Умножение с присваиванием </TD>
          <TD width=269>Переменная $а равна произведению $а и 5 </TD></TR>
        <TR>
          <TD width=79>$а/=5; </TD>
          <TD width=130>Деление с присваиванием </TD>
          <TD width=269>Переменная $а равна частному отделения $а на 5 </TD></TR>
        <TR>
          <TD width=79>$а .= 5;&nbsp; </TD>
          <TD width=130>&nbsp;Конкатенация с присваиванием </TD>
          <TD width=269>Переменная $а равна конкатенации $а и 5 
      </TD></TR></TBODY></TABLE>
      <P>Умеренное использование операторов присваивания обеспечивает более 
      наглядный и компактный код. </P>
      <P>Строковые операторы </P>
      <P>Строковые операторы РНР (табл. 3.4) обеспечивают удобные средства 
      конкатенации (то есть слияния) строк. Существует два строковых оператора: 
      оператор конкатенации (.) и оператор конкатенации с присваиванием (.=), 
      описанный в предыдущем разделе «Операторы присваивания». </P>
      <P>Конкатенацией называется объединение двух и более объектов в единое 
      целое.</P>
      <P>Таблица 3.4. Строковые операторы</P>
      <TABLE height=148 cellSpacing=0 cellPadding=0 width="100%" border=1>
        <TBODY>
        <TR>
          <TD vAlign=top align=middle width=134 height=19>
            <P>Пример</P></TD>
          <TD vAlign=top align=middle width=122 height=19>
            <P>Название</P></TD>
          <TD vAlign=top align=middle width=258 height=19>
            <P>Результат</P></TD></TR>
        <TR>
          <TD vAlign=top width=134 height=47>$a = "abc"."def"</TD>
          <TD vAlign=top width=122 height=47>
            <P align=left>Конкатенация</P></TD>
          <TD vAlign=top width=258 height=47>Переменной $а присваивается 
            результат конкатенации $а и $b</TD></TR>
        <TR>
          <TD vAlign=top width=134 height=76>
            <P>&nbsp;$а - "ghijkl"</P></TD>
          <TD vAlign=top width=122 height=76>
            <P>&nbsp;Конкатенация с присваиванием</P></TD>
          <TD vAlign=top width=258 height=76>
            <P>Переменной $а присваивается результат конкатенации ее текущего 
            значения со строкой "ghijkl"</P></TD></TR></TBODY></TABLE>
      <P>Пример использования строковых операторов: </P>
      <P>// $а присваивается строковое значение "Spaghetti &amp; Meatballs" $а = 
      "Spaghetti" . "&amp; Meatballs"</P>
      <P>// $а присваивается строковое значение "Spaghetti &amp; Meatballs are 
      delicious" $a .= "are delicious";</P>
      <P>Конечно, два строковых оператора не исчерпывают всех возможностей РНР 
      по обработке строк. За полной информацией об этих возможностях обращайтесь 
      к главе 8. </P>
      <P>Операторы инкремента и декремента</P>
      <P>Удобные вспомогательные операторы инкремента (++) и декремента (--), 
      приведенные в табл. 3.5, делают программу более наглядной и обеспечивают 
      укороченную запись для увеличения или уменьшения текущего значения 
      переменной на 1. </P>
      <P>Таблица 3.5. Операторы инкремента и декремента</P>
      <TABLE cellSpacing=0 cellPadding=0 width="100%" border=1>
        <TBODY>
        <TR>
          <TD align=middle width="33%">Пример</TD>
          <TD align=middle width="33%">Название</TD>
          <TD align=middle width="34%">Результат</TD></TR>
        <TR>
          <TD width="33%">++$а, $а++</TD>
          <TD width="33%">Инкремент</TD>
          <TD width="34%">Переменная $а увеличивается на 1</TD></TR>
        <TR>
          <TD width="33%">--$а, $а--</TD>
          <TD width="33%">Декремент</TD>
          <TD width="34%">Переменная $а уменьшается на 1</TD></TR></TBODY></TABLE>
      <P>Интересный факт: эти операторы могут располагаться как слева, так и 
      справа от операнда. Действия, выполняемые оператором, зависят от того, с 
      какой стороны от операнда он находится. Рассмотрим следующий пример: </P>
      <P>$inventory = 15;&nbsp; // Присвоить Sinventory целое число 15</P>
      <P>$old_inv = Sinventory--;&nbsp; // СНАЧАЛА присвоить $old_inv 
      значение</P>
      <P>// Sinventory. а ЗАТЕМ уменьшить Sinventory.</P>
      <P>$orig_iinventory = ++inventory;// СНАЧАЛА увеличить Sinventory. а 
      ЗАТЕМ</P>
      <P>// присвоить увеличенное значение Sinventory</P>
      <P>// переменной $orig_inventory.</P>
      <P>Как видите, расположение операторов инкремента и декремента оказывает 
      сильное влияние на результат вычислений. </P>
      <P>Логические операторы</P>
      <P>Логические операторы (табл. 3.6) наряду с математическими операторами 
      играют важную роль в любом приложении РНР, обеспечивая средства для 
      принятия решений в зависимости от значения переменных. Логические 
      операторы позволяют управлять порядком выполнения команд в программе и 
      часто используются в управляющих конструкциях (таких, как условная команда 
      i f, а также циклы for и while). </P>
      <P>Таблица 3.6. Логические операторы</P>
      <TABLE cellSpacing=0 cellPadding=0 width="100%" border=1>
        <TBODY>
        <TR>
          <TD vAlign=top align=middle width=88 height=19>
            <P>Пример </P></TD>
          <TD vAlign=top align=middle width=114 height=19>
            <P>Название </P></TD>
          <TD vAlign=top align=middle width=293 height=19>
            <P>Результат </P></TD></TR>
        <TR>
          <TD vAlign=top width=88 height=16>
            <P>$а &amp;&amp; $b</P></TD>
          <TD vAlign=top width=114 height=16>
            <P>Конъюнкция </P></TD>
          <TD vAlign=top width=293 height=16>
            <P>Истина, если истинны оба операнда , </P></TD></TR>
        <TR>
          <TD vAlign=top width=88 height=14>
            <P>$aAND$b </P></TD>
          <TD vAlign=top width=114 height=14>
            <P>Конъюнкция </P></TD>
          <TD vAlign=top width=293 height=14>
            <P>Истина, если истинны оба операнда </P></TD></TR>
        <TR>
          <TD vAlign=top width=88 height=14>
            <P>$а И $b</P></TD>
          <TD vAlign=top width=114 height=14>
            <P>Дизъюнкция </P></TD>
          <TD vAlign=top width=293 height=14>
            <P>Истина, если истинен хотя бы один из операндов </P></TD></TR>
        <TR>
          <TD vAlign=top width=88 height=12>
            <P>$а OR $b </P></TD>
          <TD vAlign=top width=114 height=12>
            <P>Дизъюнкция </P></TD>
          <TD vAlign=top width=293 height=12>
            <P>Истина, если истинен хотя бы один из операндов </P></TD></TR>
        <TR>
          <TD vAlign=top width=88 height=16>
            <P>!$а </P></TD>
          <TD vAlign=top width=114 height=16>
            <P>Отрицание </P></TD>
          <TD vAlign=top width=293 height=16>
            <P>Истина, если значение $а ложно </P></TD></TR>
        <TR>
          <TD vAlign=top width=88 height=14>
            <P>NOT !$a </P></TD>
          <TD vAlign=top width=114 height=14>
            <P>Отрицание </P></TD>
          <TD vAlign=top width=293 height=14>
            <P>Истина, если значение $а ложно </P></TD></TR>
        <TR>
          <TD vAlign=top width=88 height=14>
            <P>$а XOR $b</P></TD>
          <TD vAlign=top width=114 height=14>
            <P>Исключающая дизъюнкция</P></TD>
          <TD vAlign=top width=293 height=14>
            <P>Истина, если истинен только один из операндов 
      </P></TD></TR></TBODY></TABLE>
      <P>Логические операторы часто используются для проверки результата вызова 
      функций: </P>
      <P>file_exists("filename.txt") OR print "File does not exist!";</P>
      <P>Возможен один из двух вариантов: </P>
      <UL>
        <LI>файл filename.txt существует; 
        <LI>будет выведено сообщение: «File does not exist!». </LI></UL>
      <P>Операторы равенства</P>
      <P>Операторы равенства (табл. 3.7) предназначены для сравнения двух 
      величин и проверки их эквивалентности. </P>
      <P>Таблица 3.7. Операторы равенства</P>
      <TABLE height=121 cellSpacing=0 cellPadding=0 width="100%" border=1>
        <TBODY>
        <TR>
          <TD vAlign=top align=middle width=69 height=19>
            <P>Пример </P></TD>
          <TD vAlign=top align=middle width=182 height=19>
            <P>Название </P></TD>
          <TD vAlign=top align=middle width=213 height=19>
            <P>Результат&nbsp;</P></TD></TR>
        <TR>
          <TD vAlign=top width=69 height=9>$a==$b </TD>
          <TD vAlign=top width=182 height=16>Проверка равенства </TD>
          <TD vAlign=top width=219 height=9>Истина, если $а и $b равны </TD></TR>
        <TR>
          <TD vAlign=top width=69 height=24>$а != $b </TD>
          <TD vAlign=top width=182 height=1>Проверка неравенства </TD>
          <TD vAlign=top width=219 height=24>Истина, если $а и $b не равны 
        </TD></TR>
        <TR>
          <TD vAlign=top width=69 height=45>
            <P>$а === $b</P></TD>
          <TD vAlign=top width=182 height=45>
            <P>Проверка идентичности </P></TD>
          <TD vAlign=top width=219 height=45>
            <P>Истина, если $а и $b равны и имеют одинаковый тип 
        </P></TD></TR></TBODY></TABLE>
      <P>Даже опытные программисты часто допускают одну распространенную ошибку 
      — они пытаются проверять равенство двух величин, используя всего один знак 
      равенства (например, $а = $b). Помните, при такой записи значение $b 
      присваивается $а, и желаемый результат не будет достигнут. </P>
      <P>Операторы сравнения</P>
      <P>Операторы сравнения (табл. 3.8), как и логические операторы, позволяют 
      управлять логикой программы и принимать решения при сравнении двух и более 
      переменных. </P>
      <P>Таблица 3.8. Операторы сравнения</P>
      <TABLE height=141 cellSpacing=0 cellPadding=0 width="100%" border=1>
        <TBODY>
        <TR>
          <TD vAlign=top align=middle width=88 height=19>
            <P>Пример </P></TD>
          <TD vAlign=top align=middle width=101 height=19>
            <P>Название </P></TD>
          <TD vAlign=top align=middle width=289 height=19>
            <P>Результат </P></TD></TR>
        <TR>
          <TD vAlign=top width=88 height=19>
            <P>$a&lt;$b </P></TD>
          <TD vAlign=top width=101 height=19>
            <P>Меньше </P></TD>
          <TD vAlign=top width=289 height=19>
            <P>Истина, если переменная $а меньше $b</P></TD></TR>
        <TR>
          <TD vAlign=top width=88 height=19>
            <P>$a&gt;$b </P></TD>
          <TD vAlign=top width=101 height=19>
            <P>Больше </P></TD>
          <TD vAlign=top width=289 height=19>
            <P>Истина, если переменная $а больше $b</P></TD></TR>
        <TR>
          <TD vAlign=top width=88 height=38>
            <P>$a &lt;= $b </P></TD>
          <TD vAlign=top width=101 height=38>
            <P>Меньше или равно </P></TD>
          <TD vAlign=top width=289 height=38>
            <P>Истина, если переменная $а меньше или равна $b</P></TD></TR>
        <TR>
          <TD vAlign=top width=88 height=38>
            <P>$a &gt;= $b </P></TD>
          <TD vAlign=top width=101 height=38>
            <P>Больше или равно </P></TD>
          <TD vAlign=top width=289 height=38>
            <P>Истина, если переменная $а больше или равна $b</P></TD></TR>
        <TR>
          <TD vAlign=top width=88 height=1>
            <P>($a-12)?5: -1 </P></TD>
          <TD vAlign=top width=101 height=1>
            <P>Тернарный оператор </P></TD>
          <TD vAlign=top width=289 height=1>
            <P>Если переменная $а равна 12, возвращается значение 5, а если не 
            равна — возвращается 1 </P></TD></TR></TBODY></TABLE>
      <P>Обратите внимание: операторы сравнения предназначены для работы только 
      с числовыми значениями. Хотя возникает искушение воспользоваться ими для 
      сравнения строк, результат, скорее всего, окажется неверным. В РНР 
      существуют стандартные функции для сравнения строковых величин. Эти 
      функции подробно рассматриваются в главе 8. </P>
      <P>Поразрядные операторы</P>
      <P>Поразрядные операторы выполняют операции с целыми числами на уровне 
      отдельных битов, составляющих число. Чтобы лучше понять принцип их работы, 
      необходимо иметь хотя бы общее представление о двоичном представлении 
      десятичных чисел. В табл. 3.9 приведены примеры десятичных чисел и 
      соответствующих им двоичных представлений. </P>
      <P>Таблица 3.9. Десятичные числа и их двоичные представления</P>
      <TABLE cellSpacing=0 cellPadding=0 width="100%" border=1>
        <TBODY>
        <TR>
          <TD align=middle width=151>Десятичное целое </TD>
          <TD align=middle width=333>Двоичное представление </TD></TR>
        <TR>
          <TD width=151>2</TD>
          <TD width=333>10</TD></TR>
        <TR>
          <TD width=151>5</TD>
          <TD width=333>101</TD></TR>
        <TR>
          <TD width=151>10</TD>
          <TD width=333>1010</TD></TR>
        <TR>
          <TD width=151>12</TD>
          <TD width=333>1100</TD></TR>
        <TR>
          <TD width=151>145</TD>
          <TD width=333>10010001</TD></TR>
        <TR>
          <TD width=151>1 452 012</TD>
          <TD width=333>1011000100111111101100</TD></TR></TBODY></TABLE>
      <P>Поразрядные операторы, перечисленные в табл. 3.10, представляют собой 
      особый случай логических операторов, однако они приводят к совершенно иным 
      результатам. </P>
      <P>Таблица 3.10. Поразрядные операторы</P>
      <TABLE height=265 cellSpacing=0 cellPadding=0 width="100%" border=1>
        <TBODY>
        <TR>
          <TD vAlign=top align=middle width=60 height=19>
            <P>Пример</P></TD>
          <TD vAlign=top align=middle width=101 height=19>
            <P>Название</P></TD>
          <TD vAlign=top align=middle width=335 height=19>
            <P>Результат</P></TD></TR>
        <TR>
          <TD vAlign=top width=60 height=40>
            <P>$а&amp;$b </P></TD>
          <TD vAlign=top width=101 height=40>
            <P>Конъюнкция </P></TD>
          <TD vAlign=top width=335 height=40>
            <P>С битами, находящимися в одинаковых разрядах $а и $b, выполняется 
            операция конъюнкции</P></TD></TR>
        <TR>
          <TD vAlign=top width=60 height=36>
            <P>$а|$Ь </P></TD>
          <TD vAlign=top width=101 height=36>
            <P>Дизъюнкция </P></TD>
          <TD vAlign=top width=335 height=36>
            <P>С битами, находящимися в одинаковых разрядах $а и $b, выполняется 
            операция дизъюнкции </P></TD></TR>
        <TR>
          <TD vAlign=top width=60 height=55>
            <P>$а^$b </P>
            <P>&nbsp;</P></TD>
          <TD vAlign=top width=101 height=55>
            <P>Исключающая </P></TD>
          <TD vAlign=top width=335 height=55>
            <P>С битами, находящимися в одинаковых разрядах $а и $b, выполняется 
            операция исключающей дизъюнкции </P></TD></TR>
        <TR>
          <TD vAlign=top width=60 height=19>
            <P>~$b </P></TD>
          <TD vAlign=top width=101 height=19>
            <P>Отрицание </P></TD>
          <TD vAlign=top width=335 height=19>
            <P>Все разряды переменной $b инвертируются </P></TD></TR>
        <TR>
          <TD vAlign=top width=60 height=38>
            <P>$а &lt;&lt; $b </P></TD>
          <TD vAlign=top width=101 height=38>
            <P>Сдвиг влево </P></TD>
          <TD vAlign=top width=335 height=38>
            <P>Переменной $а присваивается значение $b, сдвинутое влево на два 
            бита </P></TD></TR>
        <TR>
          <TD vAlign=top width=60 height=38>
            <P>$а &gt;&gt; $b </P></TD>
          <TD vAlign=top width=101 height=38>
            <P>Сдвиг вправо </P></TD>
          <TD vAlign=top width=335 height=38>
            <P>Переменной $а присваивается значение $b, сдвинутое вправо на два 
            бита </P></TD></TR></TBODY></TABLE>
      <P>Если вам захочется больше узнать о двоичном представлении и поразрядных 
      операторах, я рекомендую обратиться к обширному электронному справочнику 
      Рэндалла Хайда (Randall Hyde) «The Art of Assembly Language Programming», 
      доступному по адресу <A 
      href="http.html://webster.cs.ucr.edu/Page_asm/Page_asm.html">http://webster.cs.ucr.edu/Page_asm/Page_asm.html</A>. 
      Это лучший из ресурсов, которые мне когда-либо встречались в Web. </P>
      <P><A name=e></A>Управляющие конструкции</P>
      <P>Управляющие конструкции предоставляют в распоряжение программиста 
      средства для построения сложных программ, способных проверять условия и 
      реагировать на изменения значений входных данных во время работы. Короче 
      говоря, эти структуры управляют выполнением программы. </P>
      <P><A name=f></A>Проверка условий</P>
      <P>Управляющие конструкции обычно проверяют условия на истинность или 
      ложность, и в зависимости от результата проверки выполняется то или иное 
      действие. Рассмотрим выражение $а == $b. Это выражение истинно, если $а 
      равно $b, и ложно в противном случае. Результат истинного выражения 
      считается равным 1, а результат ложного выражения равен 0. Рассмотрим 
      следующий фрагмент: </P>
      <P>$а = 5;</P>
      <P>$b = 5;</P>
      <P>print $а == $b;</P>
      <P>В результате выводится значение 1. Если изменить $а или $Ь и присвоить 
      переменной значение, отличное от 5, выводится 0. </P>
      <P>if</P>
      <P>Команда if представляет собой разновидность команды выбора, которая 
      вычисляет значение выражения и в зависимости от того, будет ли полученный 
      результат истинным или ложным, выполняет (или не выполняет) блок 
      программного кода. Существует две общих формы команды i f: </P>
      <P>if (выражение) {</P>
      <P>блок</P>
      <P>}</P>
      <P>и</P>
      <P>if (выражение) {</P>
      <P>блок</P>
      <P>}</P>
      <P>else {</P>
      <P>блок</P>
      <P>}</P>
      <P>Как упоминалось в предыдущем разделе, проверка условий дает либо 
      истинный, либо ложный результат. Выполнение блоков зависит от результата 
      проверки, причем блок может состоять как из одной, так и из нескольких 
      команд. В следующем примере после проверки условия выбирается и выводится 
      одно из двух утверждений: </P>
      <P>if ($cooking_weight &lt; 200) {</P>
      <P>print "This is enough pasta (&lt; 200g) for 1-2 people";</P>
      <P>}</P>
      <P>else {</P>
      <P>print "That's a lot of pasta. Having a party perhaps?";</P>
      <P>}</P>
      <P>Если в результате проверки условия выполняется всего одна команда, 
      фигурные скобки не обязательны: </P>
      <P>if ($cooking_weight &lt; 100) print "Are you sure this is enough?";</P>
      <P>elseif</P>
      <P>Команда elseif добавляет в управляющую конструкцию if дополнительный 
      уровень проверки и увеличивает количество условий, на основании которых 
      принимается решение: </P>
      <P>if (выражение) {</P>
      <P>блок</P>
      <P>}</P>
      <P>elseif (выражение) {</P>
      <P>блок</P>
      <P>}</P>
      <P>В РНР существует альтернативное представление команды elself — в виде 
      двух отдельных слов else if. Оба варианта приводят к одинаковым 
      результатам, а альтернативное представление поддерживается исключительно 
      для удобства. Команда elself особенно полезна в тех случаях, когда 
      происходит последовательное уточнение проверяемых условий. Обратите 
      внимание: условие elself вычисляется лишь в том случае, если все 
      предшествующие условия if и elself оказались ложными.</P>
      <P>if ($cooking_weight &lt; 200) {</P>
      <P>print "This is enough pasta (&lt; 200g) for 1-2 people";</P>
      <P>}</P>
      <P>elseif ($cooking_weight &lt; 500) {</P>
      <P>print "That's a lot of pasta. Having a party perhaps?"; }</P>
      <P>}</P>
      <P>else {</P>
      <P>print "Whoa! Who are you cooking for, a football team?";</P>
      <P>}</P>
      <P>Вложенные команды if</P>
      <P>Вложение команд i f обеспечивает максимальный контроль над проверкой 
      условий. Давайте исследуем эту возможность, усовершенствовав пример из 
      предыдущих разделов. Предположим, вес продукта должен проверяться лишь в 
      том случае, если речь идет о пасте (макаронных изделиях): </P>
      <P>// Проверить значение $pasta</P>
      <P>if ($food == "pasta") {</P>
      <P>// Проверить значение $cooking_weight</P>
      <P>if ($cooking_weight &lt; 200) {</P>
      <P>print "This is enough pasta (&lt; 200g) for 1-2 people";</P>
      <P>}</P>
      <P>elseif ($cooking_weight &lt; 500) {</P>
      <P>print "That's a lot of pasta. Having a party perhaps?";</P>
      <P>}</P>
      <P>else {</P>
      <P>print "Whoa! Who are you cooking for. a football team?";</P>
      <P>} </P>
      <P>}</P>
      <P>Как видно из приведенного кода, вложенные команды if позволяют лучше 
      управлять логикой работы программы. Вскоре, с увеличением объемов и 
      сложности ваших программ, вы убедитесь, что вложение управляющих 
      конструкций является неоценимым приемом в арсенале программиста. </P>
      <P>Вычисление нескольких условий</P>
      <P>При выборе логики работы программы в управляющей структуре можно 
      проверять комбинацию сразу нескольких условий: </P>
      <P>if ($cooking_weight &lt; 0) {</P>
      <P>&nbsp;&nbsp;&nbsp; print "Invalid cooking weight!";</P>
      <P>} </P>
      <P>if ( ($cooking_weight &gt; 0) &amp;&amp; ($cooking_weight &lt; 200) ) 
      {</P>
      <P>&nbsp;&nbsp; print "This is enough pasta (&lt; 200g) for 1-2 
      people";</P>
      <P>}</P>
      <P>elseif ( ($cooking_weight &gt; 200) &amp;&amp; ($cooking_weight &lt; 
      500) ) {</P>
      <P>&nbsp;&nbsp; print "That's a lot of pasta. Having a party 
perhaps?";</P>
      <P>}</P>
      <P>else {</P>
      <P>&nbsp;&nbsp; print "Whoa! Who are you cooking for, a football 
      team?";</P>
      <P>}</P>
      <P>Проверка сложных условий позволяет устанавливать интервальные 
      ограничения, обеспечивающие более четкий контроль над логикой выполнения 
      программы и уменьшающие количество лишних управляющих конструкций, в 
      результате чего программа становится более понятной. </P>
      <P><A name=g></A>Альтернативное ограничение блоков</P>
      <P>В управляющих структурах используются специальные ограничители, 
      определяющие границы блоков. Фигурные скобки ({ }) уже упоминались выше. 
      Для удобства программистов в РНР поддерживается альтернативный формат 
      ограничения блоков: </P>
      <P>if (выражение) : </P>
      <P>блок </P>
      <P>else : </P>
      <P>блок </P>
      <P>endif; </P>
      <P>Следовательно, две приведенных ниже команды if полностью эквивалентны: 
      </P>
      <P>if ($а== $b) {</P>
      <P>print "Equivalent values!";</P>
      <P>}</P>
      <P>if ($a == $b) :</P>
      <P>print "Equivalent values!";</P>
      <P>endif;</P>
      <P><A href="http.html://doks.gorodok.net/996" name=h></A>while</P>
      <P>Конструкция while предназначена для многократного (циклического) 
      выполнения блока команд. Блок команды while выполняется до тех пор, пока 
      условие цикла остается истинным. Общая форма цикла while выглядит так: 
</P>
      <P>while (выражение) :</P>
      <P>блок</P>
      <P>endwhile;</P>
      <P>Рассмотрим использование цикла while на примере вычисления факториала 
      (n!), где n = 5: </P>
      <P>$n = 5;</P>
      <P>$nсору = $n;</P>
      <P>$factorial = 1; // Установить начальное значение факториала</P>
      <P>while ($n &gt; 0) :</P>
      <P>$factorial - $n * $factorial;</P>
      <P>$n--; // Уменьшить $n на 1&nbsp;</P>
      <P>endwhile;</P>
      <P>print "The factorial of $ncopy is $factorial.";</P>
      <P>Программа выводит следующий результат: </P>
      <P>The factorial of 5 is 120.</P>
      <P>В этом примере $n уменьшается в конце каждой итерации. Условие цикла не 
      должно быть истинным в тот момент, когда переменная $n станет равна 0, 
      поскольку величина $factorial умножится на 0 — конечно, этого быть не 
      должно. </P>
      <P>В приведенном примере условие цикла следовало бы оптимизировать и 
      привести его к виду $n &gt; 1, поскольку умножать $factorial на 1 
      бессмысленно — число от этого не изменится. Хотя ускорение работы 
      программы будет ничтожно малым, такие факторы всегда принимаются во 
      внимание с ростом объема и сложности программ.</P>
      <P><A name=i></A>do. .while</P>
      <P>Цикл do. .while работает почти так же, как и цикл while, описанный в 
      предыдущем разделе, однако в do. .while условие проверяется не в начале, а 
      в конце каждой итерации. Учтите, что цикл do. .while всегда выполняется 
      хотя бы один раз, а цикл while может вообще не выполняться, если перед 
      входом в цикл условие окажется ложным: </P>
      <P>do:</P>
      <P>блок</P>
      <P>while (выражение);</P>
      <P>Давайте пересмотрим пример с вычислением факториала и перепишем его с 
      использованием конструкции do. .while: </P>
      <P>$n = 5: </P>
      <P>$ncopy = $n; </P>
      <P>$factorial = 1; // Установить начальное значение факториала</P>
      <P>do {</P>
      <P>$factorial = $n * $factorial;</P>
      <P>$n--: // Уменьшить Sn на 1</P>
      <P>} while (Sn &gt; 0);</P>
      <P>print "The factorial of Sncopy is $factorial.";</P>
      <P>При выполнении этого примера будет получен тот же результат, что и при 
      выполнении его прототипа из предыдущего раздела. </P>
      <P>В цикле do. .while не поддерживается альтернативный синтаксис 
      (ограничение блоков при помощи : и завершающего ключевого слова), поэтому 
      блок может заключаться только в фигурные скобки. </P>
      <P><A name=j></A>for</P>
      <P>Цикл for обеспечивает еще одну возможность многократного выполнения 
      блоков. Он отличается от цикла while только тем, что условие изменяется в 
      самой </P>
      <P>управляющей конструкции, а не где-то внутри блока команд. Как и в 
      случае с циклом while, цикл выполняется до тех пор, пока проверяемое 
      условие остается истинным. Общая форма конструкции for выглядит так: </P>
      <P>for (инициализация: условие; приращение) {</P>
      <P>блок</P>
      <P>} </P>
      <P>Условная часть цикла for в действительности состоит из трех 
      компонентов. Инициализация выполняется всего один раз и определяет 
      начальное значение управляющей переменной цикла. Условие проверяется в 
      начале каждой итерации и определяет, должна ли выполняться текущая 
      итерация или нет. Наконец, приращение определяет изменение управляющей 
      переменной при каждой итерации. Возможно, термин «приращение» в данном 
      случае неточен, поскольку переменная может как увеличиваться, так и 
      уменьшаться в соответствии с намерениями программиста. Следующий пример 
      демонстрирует простейший случай применения цикла for:</P>
      <P>for ($i = 10; $1 &lt;- 100: $1 +=10) : // Обратная косая черта 
      предотвращает</P>
      <P>print "\$i = $i &lt;br&gt;"; endfor;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; // 
      возможную интерполяцию переменной $1</P>
      <P>Выполнение этого фрагмента дает следующий результат: </P>
      <P>$i = 10</P>
      <P>$i = 20</P>
      <P>$i = 30</P>
      <P>$i = 40</P>
      <P>$i - 50</P>
      <P>$i = 60</P>
      <P>$i = 70</P>
      <P>$i = 80</P>
      <P>$i = 90</P>
      <P>$i = 100</P>
      <P>В этом примере управляющая переменная $i инициализируется значением 10. 
      Условие заключается в том, что цикл продолжается до тех пор, пока $i не 
      достигнет или не превысит пороговую величину 100. Наконец, при каждой 
      итерации значение $i увеличивается на 10. В результате команда print 
      выполняется 10 раз, каждый раз выводя текущее значение $i. Обратите 
      внимание: для увеличения $i на 10 используется оператор сложения с 
      присваиванием. Для этого есть веские причины, поскольку циклы for в РНР не 
      поддерживают более традиционной записи $i = $i + 10. </P>
      <P>Кстати, этот пример можно записать и в другом виде, но с теми же 
      результатами: </P>
      <P>for ($i = 10; $i &lt;= 100; print "\$i - $i &lt;br&gt;". $i+=10);</P>
      <P>Многие новички не понимают, зачем создавать несколько разновидностей 
      циклов в языке программирования, будь то РНР или какой-нибудь другой язык. 
      Почему нельзя обойтись одной циклической конструкцией? Дело в том, что у 
      цикла for существует несколько специфических особенностей. </P>
      <P>Например, вы можете инициализировать несколько переменных одновременно, 
      разделяя команды инициализации запятыми: </P>
      <P>for ($x=0,$y=0: $x+$y&lt;10; $x++) :</P>
      <P>$У += 
      2;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
      // Увеличить $у на 2&nbsp;</P>
      <P>print "\$y = $y &lt;BR&gt;";&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; // Вывести 
      значение $у</P>
      <P>$sum = $x + $y;</P>
      <P>print "\surn = $sum&lt;BR&gt;";&nbsp;&nbsp; // Вывести значение 
$sum</P>
      <P>endfor;</P>
      <P>Результат:</P>
      <P>$y = 2&nbsp;</P>
      <P>$sum = 2&nbsp;</P>
      <P>Sy = 4&nbsp;</P>
      <P>$sum = 5&nbsp;</P>
      <P>$y = 6&nbsp;</P>
      <P>$sum = 8&nbsp;</P>
      <P>$y = 8&nbsp;</P>
      <P>$sum = 11</P>
      <P>Этот пример выводит текущие значения $y и суммы $х и $у. Как видно из 
      приведенных результатов, выводится значение $sum = 11, хотя эта сумма 
      выходит за границы условия цикла ($х + $у &lt; 10). Это происходит из-за 
      того, что при входе в данную итерацию переменная $у была равна 6, а 
      переменная $х была равна 2. Значения переменных соответствовали условию 
      цикла, поэтому $х и $у были присвоены новые значения, в результате чего 
      была выведена сумма И. При очередной проверке условия сумма 11 превысила 
      пороговое значение 10 и цикл завершился.</P>
      <P>В управляющих выражениях циклов for могут отсутствовать любые 
      компоненты. Например, вы можете передать ранее инициализированную 
      переменную прямо в цикл, не присваивая ей определенного начального 
      значения. Возможны и другие ситуации — например, приращение переменной 
      цикла может осуществляться в зависимости от некоторого условия, 
      определяемого в цикле. В этом случае приращение не должно указываться в 
      управляющем выражении. Пример:</P>
      <P>$х = 5:</P>
      <P>for (: : $х +=2) :</P>
      <P>print " $х ";</P>
      <P>if ($x == 15) :</P>
      <P>break; // Выйти из цикла for</P>
      <P>endif;</P>
      <P>endfor;</P>
      <P>Результат выглядит так: </P>
      <P>5 7 9 11 13 15</P>
      <P>Хотя циклические конструкции for и while выполняют практически 
      одинаковые функции, считается, что цикл for делает программу более 
      наглядной. Это объясняется тем, что программист при виде команды for 
      немедленно получает всю необходимую информацию о механике и 
      продолжительности цикла. С другой стороны, в командах while приходится 
      тратить лишнее время на поиск обновлений управляющих переменных — в 
      больших программах это может занимать немало времени. </P>
      <P><A name=k></A>foreach</P>
      <P>Конструкция foreach представляет собой разновидность for, включенную в 
      язык для упрощения перебора элементов массива. Существуют две 
      разновидности команды foreach, предназначенные для разных типов массивов: 
      </P>
      <P>foreach (массив as $элемент) {</P>
      <P>блок</P>
      <P>}</P>
      <P>foreach (массив as $ключ =&gt; $элемент) {</P>
      <P>блок</P>
      <P>}</P>
      <P>Например, при выполнении следующего фрагмента:</P>
      <P>$menu = аrrау("pasta", "steak", "potatoes", "fish", "fries");</P>
      <P>foreach ($menu as $item) {</P>
      <P>print "$item &lt;BR&gt;";</P>
      <P>}</P>
      <P>будет выведен следующий результат: </P>
      <P>pasta</P>
      <P>steak</P>
      <P>potatoes</P>
      <P>fish</P>
      <P>fries</P>
      <P>В этом примере следует обратить внимание на два обстоятельства. 
      Во-первых, конструкция foreach автоматически возвращается в начало массива 
      (в других циклических конструкциях этого не происходит). Во-вторых, нет 
      необходимости явно увеличивать счетчик или иным способом переходить к 
      следующему элементу массива — это происходит автоматически при каждой 
      итерации foreach. </P>
      <P>Второй вариант используется при работе с ассоциативными массивами: </P>
      <P>$wine_inventory = array {</P>
      <P>"merlot" =&gt; 15,</P>
      <P>"zinfandel" =&gt; 17,</P>
      <P>"sauvignon" =&gt; 32</P>
      <P>}</P>
      <P>foreach ($wine_inventory as $i =&gt; $item_count) {</P>
      <P>print "$item_count bottles of $i remaining&lt;BR&gt;";</P>
      <P>} </P>
      <P>В этом случае результат выглядит так: </P>
      <P>15 bottles of merlot remaining</P>
      <P>17 bottles of zinfandel remaining</P>
      <P>32 bottles of sauvignon remaining</P>
      <P>Как видно из приведенных примеров, конструкция foreach заметно упрощает 
      работу с массивами. За дополнительной информацией о массивах обращайтесь к 
      главе 5. </P>
      <P><A name=l></A>switch</P>
      <P>Принцип работы конструкции switch отчасти напоминает if — результат, 
      полученный при вычислении выражения, проверяется по списку потенциальных 
      совпадений.</P>
      <P>Это особенно удобно при проверке нескольких значений, поскольку 
      применение switch делает программу более наглядной и компактной. Общий 
      формат команды switch:</P>
      <P>switch (выражение) {</P>
      <P>case (условие):</P>
      <P>блок</P>
      <P>case (условие):</P>
      <P>блок</P>
      <P>...</P>
      <P>default:</P>
      <P>блок</P>
      <P>}</P>
      <P>Проверяемое условие указывается в круглых скобках после ключевого слова 
      switch. Результат его вычисления последовательно сравнивается с условиями 
      в секциях case. При обнаружении совпадения выполняется блок 
      соответствующей секции. Если совпадение не будет обнаружено, выполняется 
      блок необязательной секции default.</P>
      <P>Как будет показано в следующих главах, одной из сильнейших сторон РНР 
      является обработка пользовательского ввода. Допустим, программа отображает 
      раскрывающийся список с несколькими вариантами и каждая строка списка 
      соответствует некоторой команде, выполняемой в отдельной конструкции case. 
      Реализацию очень удобно построить на использовании команды switch:</P>
      <P>$user_input = "recipes"; // Команда,выбранная пользователем</P>
      <P>switch ($user_input) :</P>
      <P>case("search") :</P>
      <P>print "Let's perform a search!";</P>
      <P>break;</P>
      <P>case("dictionary") :</P>
      <P>print "What word would you like to look up?";</P>
      <P>break;</P>
      <P>case("recipes") :</P>
      <P>print "Here is a list of recipes...";</P>
      <P>break;</P>
      <P>default :</P>
      <P>print "Here is the menu...";</P>
      <P>break;</P>
      <P>endswitch;</P>
      <P>Как видно из приведенного фрагмента, команда switch обеспечивает четкую 
      и наглядную организацию кода. Переменная, указанная в условии switch (в 
      данном примере — $user_input), сравнивается с условиями всех последующих 
      секций case. Если значение, указанное в секции case, совпадает Со 
      значением сравниваемой переменной, выполняется блок этой секции. Команда 
      break предотвращает проверку дальнейших секций case и завершает выполнение 
      конструкции switch. Если ни одно из проверенных условий не выполняется, 
      активизируется необязательная секция default. Если секция default 
      отсутствует и ни одно из условий не выполняется, команда switch просто 
      завершается и выполнение программы продолжается со следующей команды. </P>
      <P>Вы должны помнить, что при отсутствии в секции case команды break (см. 
      следующий раздел) выполнение switch продолжается со следующей команды до 
      тех пор, </P>
      <P>пока не встретится команда break или не будет достигнут конец 
      конструкции switch. Следующий пример демонстрирует последствия отсутствия 
      забытой команды break: $value = 0.4;</P>
      <P>switch($value) :</P>
      <P>case (0.4) :</P>
      <P>print "value is 0.4&lt;br&gt;";</P>
      <P>case (0.6) :</P>
      <P>print "value is 0.6&lt;br&gt;";</P>
      <P>break;</P>
      <P>case (0.3) :</P>
      <P>print "value is 0.3&lt;br&gt;";</P>
      <P>break;</P>
      <P>default :</P>
      <P>print "You didn't choose a value!";</P>
      <P>break;</P>
      <P>endswitch;</P>
      <P>Результат выглядит так: </P>
      <P>value is 0.4</P>
      <P>value is 0.6</P>
      <P>Отсутствие команды break привело к тому, что была выполнена не только 
      команда print в той секции, где было найдено совпадение, но и команда 
      print в следующей секции. Затем выполнение команд конструкции switch 
      прервалось из-за команды switch, следующей за второй командой print. </P>
      <P>Выбор между 
      командами switch и if практически не влияет на быстродействие про-граммы. 
      Решение об использовании той или иной конструкции является скорее личным 
      делом программиста.</P>
      <P><A name=m></A>break</P>
      <P>Команда break немедленно прерывает выполнение той конструкции while, 
      for или switch, в которой она находится. Эта команда уже упоминалась в 
      предыдущем разделе, однако прерывание текущего цикла не исчерпывает 
      возможностей команды break. В общем виде синтаксис break выглядит так: 
</P>
      <P>break n;</P>
      <P>Необязательный параметр n определяет количество уровней управляющих 
      конструкций, завершаемых командой break. Например, если команда break 
      вложена в две команды while и после break стоит цифра 2, происходит 
      немедленный выход из обоих циклов. По умолчанию значение n равно 1; выход 
      на один уровень может обозначаться как явным указанием 1, так и указанием 
      команды break без параметра. Обратите внимание: команда i f не относится к 
      числу управляющих конструкций, прерываемых командой break. Об этом следует 
      помнить при использовании необязательного параметра п. </P>
      <P>Рассмотрим пример использования команды break в цикле foreach: </P>
      <P>$arr = array(14, 12, 128, 34, 5);</P>
      <P>$magic number = 128:</P>
      <P>foreach ($arr as $val) :</P>
      <P>if (Sval == $magic_number) :</P>
      <P>print "The magic number is in the array!";</P>
      <P>break;</P>
      <P>endif;</P>
      <P>print "val is Sval &lt;br&gt;";</P>
      <P>endforeach;</P>
      <P>Если значение $magic_number присутствует в массиве $аrr (как в 
      приведенном примере), поиск прерывается. Результат выглядит так: </P>
      <P>val is 14</P>
      <P>val is 12</P>
      <P>The magic number is in the array!</P>
      <P>Приведенный пример всего лишь демонстрирует использование команды 
      break. В РНР существует стандартная функция in_array( ), предназначенная 
      для поиска заранее заданной величины в массиве; эта функция подробно 
      описана в главе 5. </P>
      <P><A name=n></A>continue</P>
      <P>Остается рассмотреть еще одну управляющую конструкцию РНР — continue. 
      При выполнении команды continue в цикле пропускаются все оставшиеся 
      команды текущей итерации и немедленно начинается новая итерация. Синтаксис 
      команды continue в общем виде: </P>
      <P>continue n;</P>
      <P>Необязательный параметр n указывает, на сколько уровней внешних циклов 
      распространяется действие continue. </P>
      <P>Рассмотрим пример использования команды continue. Допустим, вы хотите 
      сосчитать простые числа в интервале от 0 до некоторой заданной границы. 
      Простоты ради предположим, что у нас имеется функция is_prime(), которая 
      проверяет, является число простым или нет: </P>
      <P>$boundary = 558;</P>
      <P>for ($i = 0; $i &lt;= $boundary: $i++) :</P>
      <P>if (! is_prime($i)) :</P>
      <P>continue;</P>
      <P>endif;</P>
      <P>$prime_counter++;</P>
      <P>endfor;</P>
      <P>Если проверяемое число является простым, блок команды if обходится и 
      переменная $prime_counter увеличивается. В противном случае выполняется 
      команда continue, в результате чего происходит немедленный переход в 
      начало следующей итерации. </P>
      <P>Использование continue в длинных и сложных алгоритмах приводит к 
      появлению запу- танного и невразумительного кода. В подобных случаях 
      использовать continue не рекомендуется.</P>
      <P>Команда continue не является безусловно необходимой в программах, 
      поскольку аналогичного эффекта можно добиться при помощи команды if. </P>
      <P><A href="http.html://doks.gorodok.net/21834" name=o></A>Проект: календарь 
      событий</P>
      <P>Для практической демонстрации многих концепций, рассмотренных ранее, я 
      завершаю эту главу описанием программы-календаря. В календаре хранится 
      информация о последних кулинарных мероприятиях, семинарах по дегустации 
      вин и любых других событиях, которые вы сочтете нужным в него включить. В 
      этом проекте задействованы многие концепции, описанные в этой главе, а 
      также представлен ряд новых концепций, которые будут рассматриваться в 
      следующих главах. </P>
      <P>Информация о событиях хранится в обычном текстовом файле и выглядит 
      примерно так: </P>
      <P>July 21, 2000|8 p. m.|Cooking With Rasmus|PHP creator Rasmus Lerdorf 
      discusses the wonders of cheese.</P>
      <P>July 23, 2000|11 a. m.|Boxed Lunch|Valerie researches the latest ham 
      sandwich making techniques (documentary)</P>
      <P>July 31, 2000|2:30p.m.|Progressive Gourmet|Forget the Chardonnay: iced 
      tea is the sophisticated gourmet's beverage of choice.</P>
      <P>August 1, 2000|7 p.m.|Coder's Critique|Famed Food Critic Brian rates 
      NYC's hottest new Internet cafes.</P>
      <P>August 3, 2000|6 p.m.|Australian Algorithms|Matt studies the 
      alligator's diet.</P>
      <P>На рис. 3.1 изображен результат работы сценария РНР, приведенного в 
      листинге 3.1. </P>
      <P><IMG src="2_1_3.1Rus.jpg"></P>
      <P>Рис. З.1. Примерный вид календаря</P>
      <P>Прежде чем переходить к подробному анализу кода, потратьте немного 
      времени на изучение алгоритма: </P>
      <OL>
        <LI>Открыть файл, содержащий информацию о событиях. 
        <LI>Разделить каждую строку на 4 элемента: дату, время, название и 
        краткое описание мероприятия. 
        <LI>Отформатировать и вывести данные. 
        <LI>Закрыть файл. </LI></OL>
      <P>Листинг 3.1. Сценарий для вывода содержимого events.txt в браузере </P>
      <P>&lt;?</P>
      <P>// Приложение: календарь</P>
      <P>// Назначение: чтение и анализ содержимого файла</P>
      <P>// с последующим форматированием для вывода в браузере</P>
      <P>// Открыть файловый манипулятор Sevents для файла events.txt</P>
      <P>$events - fopen ("events.txt". "r");</P>
      <P>print "&lt;table border = 0 width = 250&gt;"</P>
      <P>print""&lt;tr&gt;&lt;td valign=top";</P>
      <P>print "&lt;h3&gt;Events Calendar:&lt;/h3&gt;";</P>
      <P>// Читать, пока не будет найден конец файла</P>
      <P>while (! feof(Sevents)) :</P>
      <P>// Прочитать следующую строку файла</P>
      <P>events.txt $event = fgets($events. 4096);</P>
      <P>// Разделить компоненты текущей строки на элементы массива</P>
      <P>$event_info = explode("|". Jevent);</P>
      <P>// Отформатировать и вывести информацию о событии</P>
      <P>print "$event_info[0] ( $event_info[1] ) &lt;br&gt;";</P>
      <P>print "&lt;b&gt;$event_info[2]&lt;/b&gt; &lt;br&gt;";</P>
      <P>print "$event_info[3] &lt;br&gt; &lt;br&gt;";</P>
      <P>endwhile;</P>
      <P>// Завершить таблицу</P>
      <P>print "&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;";</P>
      <P>fclose ($events); </P>
      <P>?&gt; </P>
      <P>Этот короткий пример убедительно доказывает, что РНР позволяет даже 
      неопытным программистам создавать реальные приложения с минимальными 
      усилиями и затратами времени. Если какие-нибудь из представленных 
      концепций покажутся непонятными, не огорчайтесь — на самом деле они очень 
      просты и будут подробно описаны в следующих главах. А если вам не терпится 
      узнать побольше об этих вопросах, обратитесь к главе 7 «Файловый 
      ввод/вывод и файловая система» и главе 8 «Строки и регулярные выражения» 
      поскольку большая часть незнакомого синтаксиса описана именно там. </P>
      <P><A name=p></A>Итоги</P>
      <P>В этой главе были представлены выражения и управляющие конструкции — 
      средства языка РНР, которые, вероятно, в той или иной форме присутствуют 
      практически в любом сценарии. Мы рассмотрели некоторые вопросы 
      использования этих средств, а именно: </P>
      <UL>
        <LI>операторы; 
        <LI>операнды; 
        <LI>приоритет операторов; 
        <LI>ассоциативность операторов; 
        <LI>управляющие структуры (If, while, do. .while, for, foreach, switch, 
        break, continue). </LI></UL>
      <P>В первых трех главах книги вы познакомились с базовыми компонентами 
      языка РНР. Остальные пять глав первой части расширяют этот материал; в них 
      вы найдете дополнительную информацию о работе с массивами, 
      объектно-ориентированных возможностях, файловом вводе/выводе и строковых 
      операциях РНР. Весь этот материал готовит читателя ко второй части книги, 
      причем особое внимание уделяется средствам РНР, часто используемым при 
      построении приложений. Итак, держитесь покрепче и не сходите с дистанции! 
      </P></LI></DIV>
<center>
[ <a href="02.php">Назад</a> | <a href="index.php">Содержание</a> | <a href="04.php">Вперед</a> ]
</center><br>
		</html>
<? include_once '../../sys/inc/tfoot.php'; ?>