<?include'h.php';?>
<html><head>
		<title>Учебник PHP, Глава 14</title>
		<meta http-equiv="Content-type" content="text/html; charset=Windows-1251">
		</head>
		
      <DIV class=infotxt>
      <LI><A href="#a">Глава 14. PHP и XML</A> 
      <UL>
        <LI><A href="#b">Разметка текста</A> 
        <UL>
          <LI><A href="#c">Язык SGML</A> 
          <LI><A href="#d">Пришествие HTML</A> 
          <LI><A href="#e">XML как неопровержимое 
          свидетельство эволюции</A> </LI></UL>
        <LI><A href="#f">Знакомство с синтаксисом 
        XML</A> 
        <UL>
          <LI><A href="#g">Определение типа 
          документа(DTD)</A> </LI></UL>
        <LI><A href="#h">PHP и XML</A> 
        <UL>
          <LI><A href="#i">Подключение 
          пользовательских функций к обработке XML</A> 
          <LI><A href="#j">Функции обработки кода 
          XML</A> 
          <LI><A href="#k">Другие полезные 
          функции</A> 
          <LI><A href="#l">Параметры анализатора 
          XML</A> 
          <LI><A href="#m">Преобразование XML в 
          HTML</A> </LI></UL>
        <LI><A href="#n">Несколько слов о PHP и 
        XML</A> 
        <LI><A href="#o">Итоги</A> </LI></UL>
      <UL></UL>
      <P>&nbsp;</P>
      <P><A name=a></A>ГЛАВА 14</P>
      <P>РНР и XML</P>
      <P>Бесспорно, развитие World Wide Web оказало заметное влияние на способы 
      обмена информацией. Вследствие огромных размеров этой электронной сети 
      соблюдение стандартов превратилось из простого удобства в обязательное 
      требование — конечно, если ваша организация собирается в полной мере 
      использовать потенциал Web. Одним из таких стандартов является язык XML 
      (extensible Markup Language) — удобное средство обмена данными между 
      организациями и приложениями.</P>
      <P>В начале этой главы приведены общие сведения о XML, при этом особое 
      внимание уделяется общему синтаксису языка. Второй раздел посвящен 
      средствам РНР для работы с XML. Мы рассмотрим стандартные функции 
      поддержки XML, а также схему общего процесса обработки файлов в формате 
      XML. Этот материал позволит вам лучше понять, чем же так ценен XML и как 
      РНР может применяться для разработки полезных и интересных приложений на 
      базе XML.</P>
      <P>Но прежде чем переходить к непосредственному описанию XML, я расскажу о 
      том, как же развивались концепции, в конечном счете приведшие к 
      возникновению формата XML.</P>
      <P><A href="http.html://doks.gorodok.net/0" name=b></A>Разметка текста</P>
      <P>Как нетрудно предположить по его названию, язык HTML (HyperText MarkUp 
      Language) относится к числу так называемых языков разметки текста (markup 
      languages). Под термином «разметка» понимается общая служебная информация, 
      которая не выводится вместе с документом, но определяет; как должны 
      выглядеть те или иные фрагменты документа. Например, вы можете 
      потребовать, чтобы какое-либо слово выводилось жирным или курсивным 
      шрифтом, вывести отдельный абзац особым шрифтом или оформлять заголовки 
      увеличенным шрифтом. Текстовый редактор, в котором я ввожу этот абзац, 
      тоже использует особую форму разметки для представления тех атрибутов 
      форматирования, которые я выбираю. Таким образом, в нем тоже используется 
      особая разновидность языка разметки. Короче говоря, язык разметки, 
      используемый моим текстовым редактором, представляет собой средство для 
      описания визуального оформления текста в моих документах.</P>
      <P>В наши дни существует множество разных языков разметки. Например, в 
      коммуникационных программах особая форма разметки определяет смысл каждого 
      пакета из нулей и единиц, пересылаемого в Интернете. Когда мы подчеркиваем 
      слова в книге, это тоже можно считать своего рода разметкой. Впрочем, 
      любой язык разметки должен решать две важные задачи:</P>
      <OL>
        <LI>Язык определяет синтаксис разметки. Например, в соответствии со 
        спецификацией HTML конструкция &lt;b&gt;text&lt;/b&gt; определяет 
        синтаксически правильную разметку текста, а конструкция 
        &lt;xR5t&gt;text&lt;/x4rt&gt; считается неправильной из-за несовпадения 
        открывающего и закрывающего тегов. 
        <LI>Язык определяет смысл разметки. Конечно, вы знаете, что команда 
        &lt;b&gt;text&lt;/b&gt; выводит слово text жирным шрифтом. В данном 
        случае определяется смысл, связанный с объявлением некоторого компонента 
        документа. </LI></OL>
      <P>Стремительное развитие Web за последние несколько лет наглядно 
      показывает, что самым популярным языком разметки текста является HTML. Но 
      как появился этот язык? Кто закрепил за тегами &lt;b&gt; и &lt;/b&gt; 
      определенный смысл в документе? Чтобы ответить на этот вопрос, необходимо 
      познакомиться с предшественником HTML — SGML (Standard Generalized Markup 
      Language).</P>
      <P><A name=c></A>Язык SGML</P>
      <P>SGML представляет собой международный стандарт обмена электронной 
      информацией между различными аппаратными и программными компонентами. По 
      названию можно предположить, что SGML — это язык. На самом деле это не 
      совсем так, поскольку SGML в действительности определяет формализованный 
      набор правил для создания языков. На базе SGML были созданы два самых 
      популярных языка разметки — HTML и XML. Как вы уже знаете, HTML — 
      плат-форменно- и аппаратно-независимый язык, предназначенный для 
      форматирования и отображения текста. То же самое можно сказать и о 
XML.</P>
      <P>Появление стандарта SGML было обусловлено необходимостью совместного 
      использования данных разными приложениями и операционными системами. Даже 
      в далеких 60-х годах у пользователей компьютеров возникало немало проблем 
      с совместимостью. Проанализировав недостатки многих нестандартных языков 
      разметки, трое ученых из IBM — Чарльз Гольдфарб (Charles Goldfarb), Эд 
      Мо-шер (Ed Mosher) и Рэй Лори (Ray Lorie) — сформулировали три общих 
      принципа, обеспечивающих возможность совместной работы с документами в 
      разных операционных системах:</P>
      <UL>
        <LI>Использование единых принципов форматирования во всех программах, 
        выполняющих обработку документов. Вполне логичное требование — всем нам 
        хорошо известно, как трудно договориться между собой людям, говорящим на 
        разных языках. Наличие единого набора синтаксических конструкций и общей 
        семантики заметно упрощает взаимодействие между программами. 
        <LI>Специализация языков форматирования. Благодаря возможности 
        построения специализированного языка на базе набора стандартных правил 
        программист 
        <LI>перестает зависеть от внешних реализаций и их представлений о 
        потребностях конечного пользователя 
        <LI>Четкое определение формата документа. Правила, определяющие формат 
        документа, задают количество и маркировку языковых конструкций, 
        используемых в документе. Применение стандартного формата гарантирует, 
        что пользователь будет точно знать структуру содержимого документа. 
        Обратите внимание: речь идет не о формате отображения документа, а о его 
        структурном формате. Набор правил, описывающих этот формат, называется 
        «определением типа документа» (document type definition, DTD). </LI></UL>
      <P>Эти три правила были заложены в основу предшественника SGML — GML 
      (Generalized Markup Language). Исследования и разработка GML продолжались 
      около десяти лет, пока в результате соглашения, заключенного международной 
      группой разработчиков, не появился стандарт SGML.</P>
      <P>В 1980-х годах необходимость в общих средствах обмена информацией 
      непрерывно возрастала, и SGML вскоре превратился в отраслевой стандарт (в 
      1986 году он был принят в качестве стандарта ISO). Даже в наши дни этот 
      стандарт занимает достаточно сильные позиции, поскольку многие 
      организации, работающие с огромными объемами информации, полагаются на 
      SGML как на удобное и надежное средство хранения данных. Чтобы подкрепить 
      сказанное, замечу, что Бюро патентов и товарных знаков США (<A 
      href="http.html://www.uspto.gov/">http://www.uspto.gov/</A>), Служба внутренних 
      сборов США (<A href="http.html://www.irs.gov/">http://www.irs.gov/</A>) и 
      Библиотека Конгресса (<A 
      href="http.html://lcweb.loc.gov/">http://lcweb.loc.gov/</A>) используют SGML в 
      своих основных приложениях. Только представьте, какой объем документации 
      проходит через эти организации за год!</P>
      <P>Одним из лучших ресурсов Интернета, посвященных SGML, XML и другим 
      языкам раз-метки, является сайт Robin Cover/OASIS XML Cover Pages (<A 
      href="http.html://www.oasis-open.org/cover">http://www.oasis-open.org/cover</A>).</P>
      <P>Идея передачи гипертекстовых документов через web-браузер, предложенная 
      Тимом Бернерсом-Ли (Tim Berners-Lee), не требовала многих возможностей, 
      поддерживаемых полной реализацией SGML. В результате появился известный 
      язык разметки HTML.</P>
      <P><A name=d></A>Пришествие HTML</P>
      <P>Концепция World Wide Web идеально соответствовала идее применения 
      обобщенного языка разметки для упрощения обмена информацией в среде, 
      содержащей множество разных аппаратных конфигураций, операционных систем и 
      программных реализаций. Несомненно, Бернерс-Ли учитывал это 
      обстоятельство, поскольку он смоделировал первую версию HTML на основе 
      стандарта SGML. HTML унаследовал некоторые характеристики SGML, в том 
      числе простой обобщенный набор тегов и особую роль угловых скобок. Простые 
      документы в формате HTML можно прочитать в любой компьютерной системе, в 
      которой предусмотрены средства для просмотра текстовых документов. Все 
      остальное — история.</P>
      <P>Тем не менее, у HTML имеется существенный недостаток: он не позволяет 
      разработчику создавать собственные типы документов. Результатом стала 
      «война браузеров», в ходе которой разработчики браузеров начали создавать 
      свои собственные усовершенствования языка HTML. Эти модификации 
      существенно отклонялись от идеи работы с единым стандартом HTML и вызвали 
      настоящий хаос среди разработчиков, которые хотели создавать web-сайты, не 
      зависящие от браузера. Более того, долгий период неопределенности в 
      области стандартов привел к тому, что разработчики вывели язык из 
      первоначально задуманных границ. Думаю, подавляющее большинство 
      web-страниц современного Интернета вообще не соответствуют текущей 
      спецификации HTML.</P>
      <P>Реакцией консорциума W3 (http://www.w3.org) на быстро ухудшающуюся 
      ситуацию стала попытка вернуть развитие HTML на правильный путь — другими 
      словами, вернуться к истокам SGML. Результатом этих усилий стал XML.</P>
      <P><A name=e></A>XML как неопровержимое свидетельство эволюции</P>
      <P>XML воплощает все усилия, предпринятые W3 в области выработки 
      Интернет-стандарта, который бы соответствовал трем главным принципам SGML 
      (см. предыдущий раздел). XML, как и SGML, не является языком; он также 
      представляет собой набор рекомендаций, на базе которых создаются другие 
      языки. Точнее говоря, XML является конгломератом из трех отдельных 
      спецификаций:</P>
      <UL>
        <LI>XML (Extensible Markup Language) — спецификация, определяющая 
        базовый синтаксис XML; 
        <LI>XSL (Extensible Style Language) — спецификация, направленная на 
        отделение визуального оформления страницы от ее содержимого за счет 
        применения к документу стилей (style sheets), определяющих конкретные 
        атрибуты форматирования; 
        <LI>XLL (Extensible Linking Language) — спецификация, определяющая 
        представление ссылок на другие ресурсы. </LI></UL>
      <P>XML не только позволяет разработчикам создавать специализированные 
      языки для Интернет-приложений; он также обеспечивает возможность проверки 
      этих документов на соответствие спецификации XML. Более того, XML 
      действительно реализует концепцию данных, не зависящих от реализации, 
      поскольку формат отображаемого документа можно точно описать при помощи 
      XSL. Допустим, вы переформатировали свой web-сайт, чтобы он хранился в 
      формате XML. После этого' вы сможете использовать один стиль для 
      форматирования исходного текста XML на портативном компьютере типа Palm 
      Pilot, а другой — для форматирования на мониторе обычного компьютера. В 
      обоих случаях код XML остается одним и тем же, изменяется только его 
      форматирование в соответствии с используемым устройством.</P>
      <P>Примером популярного языка, созданного на базе XML, является WML 
      (Wireless Markup Language).</P>
      <P><A name=f></A>Знакомство с синтаксисом XML</P>
      <P>Для большинства читателей, знакомых с SGML или HTML, структура 
      документов XML не содержит ничего нового. Пример простого документа XML 
      приведен в листинге 14.1.</P>
      <P>Листинг 14.1. Пример документа XML</P>
      <P>&lt;?xml version="1.0"?&gt;</P>
      <P>&lt;!DOCTYPE cookbook SYSTEM "cookbook.dtd"&gt;</P>
      <P>&lt;cookbook&gt;</P>
      <P>&lt;recipe category="italian"&gt;</P>
      <P>&lt;title&gt;Spaghetti alla Carbonara&lt;/title&gt;</P>
      <P>&lt;description&gt;This traditional Italian dish is sure to please even 
      the most discriminating</P>
      <P>critic.&lt;/description&gt;</P>
      <P>&lt;ingredients&gt;</P>
      <P>&lt;ingredient&gt;2 large eggs&lt;/ingredient&gt;</P>
      <P>&lt;ingredient&gt;4 strips of bacon&lt;/ingredient&gt;</P>
      <P>&lt;ingredient&gt;l clove garlic&lt;/ingredient&gt;</P>
      <P>&lt;ingredient&gt;12 ounces spaghetti&lt;/ingredient&gt;</P>
      <P>&lt;ingredient&gt;3 tablespoons olive oil&lt;/ingredient&gt;</P>
      <P>&lt;/ingredients&gt;</P>
      <P>&lt;process&gt;</P>
      <P>&lt;step&gt;Combine oil and bacon in large skillet over medium heat. 
      Cook until bacon is</P>
      <P>brown and crisp.&lt;/step&gt;</P>
      <P>&lt;step&gt;whisk eggs in bowl. Set aside.&lt;/step&gt;</P>
      <P>&lt;step&gt;Cook pasta in large pot of boiling water to taste, stirring 
      occasionally.</P>
      <P>Add salt as necessary.&lt;/step&gt;</P>
      <P>&lt;step&gt;Drain pasta and return to pot. adding whisked eggs. Stir 
      over medium-low</P>
      <P>heat for 2-3 minutes.&lt;/step&gt;</P>
      <P>&lt;step&gt;Mix in bacon. Season with salt and pepper to 
      taste.&lt;/step&gt;</P>
      <P>&lt;/process&gt;</P>
      <P>&lt;/recipe&gt;</P>
      <P>&lt;/cookbook&gt;</P>
      <P>Обратите внимание на основные компоненты, из которых состоит документ 
      XML:</P>
      <UL>
        <LI>пролог XML; 
        <LI>теги; 
        <LI>атрибуты; 
        <LI>ссылки на сущности; 
        <LI>инструкции по обработке; 
        <LI>комментарии. </LI></UL>
      <P>Пролог XML</P>
      <P>Все документы XML начинаются с пролога (prolog). Пролог сообщает, что 
      документ написан на XML, а также указывает, какая версия XML при этом 
      использовалась.</P>
      <P>Поскольку текущая версия XML имеет номер 1.0, все ваши документы XML 
      должны начинаться со строки</P>
      <P>&lt;?xml version="1.0"&gt;</P>
      <P>Следующая строка в листинге 14.1 указывает на внешний DTD. Пока не 
      обращайте на нее внимания — DTD подробно рассматриваются в следующем 
      разделе «Определение типа документа (DTD)»:</P>
      <P>&lt;!DOCTYPE cookbook SYSTEM "cookbook.dtd"&gt;</P>
      <P>Оставшаяся часть листинга 14.1 состоит из элементов, очень похожих на 
      элементы документов HTML. Первый элемент, cookbook, называется корневым 
      элементом (root element), поскольку в эту пару тегов заключены все 
      остальные теги документа. Конечно, вы можете присвоить корневому элементу 
      любое имя по своему усмотрению. Главное, о чем следует помнить, — все 
      остальные элементы должны находиться внутри пары корневых тегов.</P>
      <P>Пролог может содержать другие инструкции. Например, объявление можно 
      расширить, указав, что документ является автономным:</P>
      <P>&lt;?xml version="1.0" standalone="yes"&gt;</P>
      <P>Присваивание yes атрибуту standalone сообщает механизму обработки 
      XML-кода о том, что документ не импортирует других файлов (например, 
      DTD).</P>
      <P>Хотя это расширение, как и многие другие, приносит несомненную пользу, 
      я сокращаю описание синтаксиса до минимума, чтобы лучше выделить основную 
      тему этой главы — совместное использование РНР и XML.</P>
      <P>Элементы</P>
      <P>Оставшаяся часть документа состоит в основном из различных служебных 
      элементов и соответствующих данных. Служебные элементы легко узнать по 
      угловым скобкам (как в разметке HTML). Элемент может быть пустым или 
      содержащим информацию; в этом случае элемент содержит открывающий и 
      закрывающий теги. Если элемент не пуст, то в теги включаются имена, 
      описывающие природу данных. Как видно из листинга 14.1, эти теги очень 
      похожи на теги документов HTML. Впрочем, следует помнить о некоторых 
      важных различиях:</P>
      <UL>
        <LI>Непустые элементы должны содержать как открывающий, так и 
        закрывающий тег. В элементах, которые логически не могут иметь 
        закрывающего тега, используется альтернативная форма синтаксиса 
        &lt;элемент /&gt;. Возникает вопрос — у каких элементов нет закрывающего 
        тега? Достаточно вспомнить некоторые теги форматирования HTML — 
        например, &lt;br&gt;, &lt;hr&gt; и &lt;img&gt;, у них нет парных тегов. 
        Теги этого формата могут создаваться и в документах XML 
        <LI>Элементы XML должны находиться на правильном уровне вложенности. 
        Документ XML, приведенный в листинге 14.1, синтаксически правилен; 
        другими словами, теги элементов не встречаются там, где их быть не 
        должно. Например, следующий фрагмент недопустим: </LI></UL>
      <P>&lt;title&gt;Spaghetti alia Carbonara</P>
      <P>&lt;ingredients&gt;&lt;/title&gt;</P>
      <UL>
        <LI>В элементах XML различается регистр символов. Некоторым читателям 
        это наверняка не понравится. Например, в XML теги &lt;tag&gt;, 
        &lt;Tag&gt; и &lt;TAG&gt; считаются разными тегами. Привыкайте поскорее 
        — с непривычки это может свести вас с ума. </LI></UL>
      <P>Атрибуты</P>
      <P>Теги XML, по аналогии с тегами HTML, могут обладать атрибутами. 
      Атрибуты содержат дополнительную информацию о содержании, которая в 
      дальнейшем используется при форматировании или обработке XML. Значения 
      атрибутов присваиваются в формате «имя=значение», и, в отличие от HTML, 
      атрибуты XML должны быть заключены в апострофы или кавычки. В листинге 
      14.1 встречается пример использования атрибута:</P>
      <P>&lt;recipe category="italian"&gt;</P>
      <P>Атрибут сообщает, что данный рецепт (recipe) относится к категории 
      «итальянской кухни» (italian). Наличие такой информации упрощает 
      дальнейшую группировку и обработку данных.</P>
      <P>Ссылки на сущности</P>
      <P>Концепция сущности (entity) упрощает сопровождение документа, 
      обеспечивая возможность ссылки на некоторое содержание по ключевым словам. 
      Ключевое слово может относиться как к простейшему фрагменту вроде 
      расширения аббревиатуры, так и к совершенно новому фрагменту кода XML. 
      Сущности удобны тем, что они могут многократно использоваться в документах 
      XML. При последующей обработке документа все ссылки на сущность заменяются 
      конкретным содержанием, указанным при объявлении сущности. Объявление 
      сущности включается в DTD документа XML.</P>
      <P>Чтобы сослаться на некоторую сущность в документе HTML, следует указать 
      ее имя с префиксом «амперсанд» (&amp;) и суффиксом «точка с запятой» (;). 
      Допустим, вы объявили сущность с информацией об авторских правах. После 
      этого на данную сущность можно ссылаться следующим образом:</P>
      <P>&amp;Соруright:</P>
      <P>При этом строка документа XML может выглядеть так:</P>
      <P>&lt;footer&gt;</P>
      <P>...прочие данные колонтитула...</P>
      <P>&amp;Copyright:</P>
      <P>&lt;/footer&gt;</P>
      <P>Сущности, как и переменные и шаблоны, часто применяются в ситуациях, 
      когда некоторая информация может измениться в будущем или документ 
      содержит множество повторяющихся ссылок. Мы вернемся к проблемам 
      объявления ссылок в разделе «Определение типа документа (DTD)».</P>
      <P>Инструкции по обработке</P>
      <P>Инструкции по обработке (processing instructions, PI) представляют 
      собой внешние команды, которые выполняются приложением, работающим с 
      документом XML.</P>
      <P>В общем случае синтаксис PI выглядит так:</P>
      <P>&lt;?приложение инструкции?&gt;</P>
      <P>Атрибут приложение указывает, какой программе адресованы последующие 
      инструкции. Например, для выполнения команды РНР в документе XML можно 
      воспользоваться следующей конструкцией:</P>
      <P>&lt;?php print "Today's date is:".date("m-d-Y");?&gt;</P>
      <P>Инструкции по обработке удобны тем, что они позволяют нескольким 
      приложениям совместно работать с одним документом.</P>
      <P>Комментарии</P>
      <P>Комментарии принадлежат к числу основных возможностей любого языка. В 
      XML используется тот же синтаксис комментариев, что и в HTML:&nbsp;</P>
      <P>&lt;!-комментарии -&gt;</P>
      <P>Итак, мы проанализировали структуру типичного документа XML. Но у 
      документов XML существует еще один важный аспект — определение типа 
      документа (DTD).</P>
      <P><A name=g></A>Определение типа документа (DTD)</P>
      <P>DTD представляет собой совокупность синтаксических правил, на основе 
      которых проверяется структура документа XML. В DTD явно определяется 
      структура документа XML, указываются элементы и их атрибуты, а также 
      приводится другая информация, распространяющаяся на все документы XML, 
      созданные на основе данного DTD.</P>
      <P>Учтите, что наличие DTD не является обязательным. Если DTD существует, 
      система XML руководствуется им при интерпретации документа XML. Если DTD 
      отсутствует, предполагается, что система XML должна интерпретировать 
      документ по собственным правилам. Впрочем, для документов XML все же 
      рекомендуется создавать DTD, поскольку это упрощает их интерпретацию и 
      проверку структуры.</P>
      <P>DTD можно включить непосредственно в документ XML, сослаться на него по 
      URL или использовать комбинацию этих двух способов. При непосредственном 
      включении DTD в документ XML определение DTD располагается сразу же после 
      пролога:</P>
      <P>&lt;!DOCTYPE имя_корневого_элемента [&nbsp;</P>
      <P>...прочие объявления...</P>
      <P>] &gt;</P>
      <P>Атрибут имя_корневого_элемента соответствует имени корневого элемента в 
      тегах, содержащих весь документ XML. В секции «прочих объявлений» 
      находятся определения элементов, атрибутов и т. д.</P>
      <P>Возможно, вы предпочитаете разместить DTD в отдельном файле, чтобы 
      обеспечить модульную структуру программы. Давайте посмотрим, как выглядит 
      ссылка на внешний DTD в документе XML. Задача решается одной простой 
      командой:</P>
      <P>&lt;!DOCTYPE имя_корневого_элемента SYSTEM "some_dtd.dtd"&gt;</P>
      <P>Как и в случае с внутренним объявлением DTD, имя_корневого_элемента 
      должно соответствовать имени корневого элемента в тегах, содержащих весь 
      документ XML. Атрибут SYSTEM указывает на то, что some_dtd.dtd находится 
      на локальном сервере. Впрочем, на файл some_dtd.dtd также можно сослаться 
      по его абсолютному URL. Наконец, в кавычках указывается URL внешнего DTD, 
      расположенного на локальном или на удаленном сервере.</P>
      <P>Как же создать DTD для листинга 14.1? Во-первых, мы собираемся создать 
      в документе XML ссылку на внешний DTD. Как упоминалось в предыдущем 
      разделе, ссылка на DTD выглядит так:</P>
      <P>&lt;!DOCTYPE cookbook SYSTEM "cookbook.dtd"&gt;</P>
      <P>Возвращаясь к листингу 14.1, мы видим, что cookbook является именем 
      корневого элемента, a cookbook.dtd — именем DTD-файла. Содержимое DTD 
      показано в листинге 14.2, а ниже приведены подробные описания всех 
      строк.</P>
      <P>Листинг 14.2. DTD для листинга 14.1 (cookbook.dtd)</P>
      <P>&lt;?xml version="1.0"?&gt;</P>
      <P>&lt;!DOCTYPE cookbook [</P>
      <P>&lt;!ELEMENT cookbook (recipe+)&gt;</P>
      <P>&lt;!ELEMENT recipe (title, description, ingredients, process)&gt;</P>
      <P>&lt;!ELEMENT title (#PCDATA)&gt;</P>
      <P>&lt;!ELEMENT description (#PCDATA)&gt;</P>
      <P>&lt;!ELEMENT ingredients (ingredient+)&gt;</P>
      <P>&lt;!ELEMENT ingredient (#PCDATA)&gt;</P>
      <P>&lt;!ELEMENT process Cstep+)&gt;</P>
      <P>&lt;!ELEMENT step (#PCDATA)&gt;</P>
      <P>&lt;!ATTLIST recipe category CDATA #REQUIRED&gt;</P>
      <P>] &gt;</P>
      <P>Что же означает этот загадочный документ? Несмотря на внешнюю 
      сложность, в действительности он довольно прост. Давайте переберем все 
      содержимое листинга 14.2:</P>
      <P>&lt;?xml version="1.0"?&gt;</P>
      <P>Перед нами пролог XML, о котором уже говорилось выше.</P>
      <P>&lt;!DOCTYPE cookbook [</P>
      <P>Вторая строка сообщает, что далее следует DTD с именем cookbook.</P>
      <P>&lt;!ELEMENT cookbook (recipe+)&gt;</P>
      <P>Третья строка описывает элемент XML, в данном случае — корневой элемент 
      cookbook. После него следует слово recipe, заключенное в круглые скобки. 
      Это означает, что в теги cookbook заключается вложенный тег с именем 
      recipe. Знак + говорит о том, что в родительских тегах cookbook находится 
      одна или несколько пар тегов recipe.&nbsp;</P>
      <P>&lt;!ELEMENT recipe (title, description, ingredients. process)&gt;</P>
      <P>Четвертая строка описывает тег recipe. В ней сообщается, что в тег 
      recipe входят четыре вложенных тега: title, description, ingredients и 
      process. Поскольку после имен тегов не указываются признаки повторения 
      (см. следующий раздел), внутри тегов recipe должна быть заключена ровно 
      одна пара каждого из перечисленных тегов.</P>
      <P>&lt;! ELEMENT title (#PCDATA)&gt;</P>
      <P>Перед нами первое определение тега, который не содержит вложенных 
      тегов. В соответствии с определением он содержит #PCDATA, то есть 
      произвольные символьные данные, не считающиеся частью разметки.</P>
      <P>&lt;!ELEMENT ingredients (ingredient+)&gt;</P>
      <P>В соответствии с определением элемент ingredients содержит один или 
      несколько тегов с именем ingredient. Обратитесь к листингу 14.1, и вы все 
      поймете.</P>
      <P>&lt;! ELEMENT ingredient (#PCDATA)&gt;</P>
      <P>Поскольку элемент ingredient соответствует отдельному ингредиенту, 
      вполне логично, что этот элемент содержит простые символьные данные.</P>
      <P>&lt;! ELEMENT process (step+)&gt;</P>
      <P>Элемент process содержит один или несколько экземпляров элемента 
      step.&nbsp;</P>
      <P>&lt;! ELEMENT step (#PCDATA)&gt;</P>
      <P>Элемент step, как и элемент ingredient, соответствует отдельному пункту 
      в списке более высокого уровня. Следовательно, он должен содержать 
      символьные данные.</P>
      <P>&lt;!ATTLIST recipe category CDATA #REQUIRED&gt;</P>
      <P>Обратите внимание: элемент recipe в листинге 14.1 содержит атрибут. 
      Этот атрибут, category, определяет общую категорию, к которой относится 
      рецепт — в приведенном примере это категория «итальянская кухня» 
      (Italian). В определении ATTLIST указывается как имя элемента, так и имя 
      атрибута. Кроме того, отнесение каждого рецепта к определенной категории 
      упрощает классификацию, поэтому атрибут объявляется обязательным 
      (#REQUIRED).</P>
      <P>]&gt;</P>
      <P>Последняя строка просто завершает определение DTD. Определение всегда 
      должно быть должным образом завершено, иначе произойдет ошибка.</P>
      <P>В завершение этого раздела я приведу сводку основных компонентов 
      типичного DTD-файла:</P>
      <UL>
        <LI>объявления типов элементов; 
        <LI>объявления атрибутов; 
        <LI>ID, IDREF и IDREFS; 
        <LI>объявления сущностей. </LI></UL>
      <P>Некоторые из этих компонентов уже встречались нам в описании листинга 
      14.2. Далее каждый компонент будет описан более подробно.</P>
      <P>Объявления элементов</P>
      <P>Все элементы, используемые в документе XML, должны быть определены в 
      DTD, прилагаемом к документу. Мы уже встречались с двумя распространенными 
      разновидностями определений: для элемента, содержащего другие элементы, и 
      элемента, содержащего символьные данные. Данное определение 
      свидетельствует, что элемент содержит только символьные данные:&nbsp; </P>
      <P>&lt;! ELEMENT описание (#РСDАТА)&gt;</P>
      <P>Следующее определение элемента process говорит о том, что он содержит 
      ровно один вложенный элемент с именем step:&nbsp;</P>
      <P>&lt;!ELEMENT process (step)&gt;</P>
      <P>Впрочем, процессы (process) из одного шага (step) встречаются довольно 
      редко — скорее всего, шагов будет несколько. Чтобы указать, что элемент 
      содержит один или несколько экземпляров вложенного элемента step, следует 
      воспользоваться признаком повторения:</P>
      <P>&lt;!ELEMENT process (step+)&gt;</P>
      <P>Количество вложенных элементов можно задать несколькими способами. 
      Полный список операторов элементов приведен в табл. 14.1.</P>
      <P>Таблица 14.1. Операторы элементов </P>
      <TABLE width="100%" border=1>
        <TBODY>
        <TR>
          <TD align=middle width=115>Признак&nbsp;&nbsp;</TD>
          <TD align=middle width=277>Значение </TD></TR>
        <TR>
          <TD align=middle width=115>?</TD>
          <TD width=277>Ноль или ровно один экземпляр&nbsp;</TD></TR>
        <TR>
          <TD align=middle width=115>*</TD>
          <TD width=277>Ноль или несколько экземпляров&nbsp;</TD></TR>
        <TR>
          <TD align=middle width=115>+</TD>
          <TD width=277>Один или несколько экземпляров</TD></TR>
        <TR>
          <TD align=middle width=115>&nbsp;</TD>
          <TD width=277>Ровно один экземпляр&nbsp;</TD></TR>
        <TR>
          <TD align=middle width=115>|</TD>
          <TD width=277>Один из элементов&nbsp;</TD></TR>
        <TR>
          <TD align=middle width=115>,</TD>
          <TD width=277>Перечисление элементов</TD></TR></TBODY></TABLE>
      <P>Если элемент будет содержать несколько вложенных элементов, их следует 
      перечислить через запятую в определении родительского элемента:</P>
      <P>&lt;!ELEMENT recipe (title, description, ingredients, process)&gt;</P>
      <P>Поскольку признаки повторения не указаны, каждый тег должен встречаться 
      ровно один раз.</P>
      <P>Определение элемента уточняется при помощи логических операторов. 
      Предположим, вы работаете с рецептами, в которые всегда входят макароны 
      (pasta) с одним или несколькими типами сыра (cheese) или мяса (meat). В 
      этом случае элемент ingredient определяется следующим образом:</P>
      <P>&lt;!ELEMENT ingredient (pasta+, (cheese | meat)+)&gt;</P>
      <P>Поскольку элемент pasta обязательно должен присутствовать в элементе 
      ingredient, он указывается с признаком повторения +. Затем следует либо 
      элемент cheese, либо элемент meat; мы разделяем альтернативы вертикальной 
      чертой и заключаем их в круглые скобки со знаком +, поскольку в рецепт 
      всегда входит либо одно, либо другое.</P>
      <P>Существуют и другие разновидности определений элементов. Мы рассмотрели 
      лишь простейшие случаи. Тем не менее, приведенного материала вполне 
      достаточно для понимания примеров, приведенных в оставшейся части этой 
      главы.</P>
      <P>Объявления атрибутов</P>
      <P>Атрибуты элементов описывают значения, связываемые с элементами. 
      Элементы XML, как и элементы HTML, могут иметь ноль, один или несколько 
      атрибутов. Общий синтаксис объявления атрибутов выглядит следующим 
      образом:</P>
      <P>&lt;!ATTLIST имя_элемента имя_атри6ута1 тип_данных1 флаг1</P>
      <P>Имя_элемента определяет имя элемента, включаемое в тег. Затем 
      перечисляются атрибуты, связанные с данным элементом. Объявление каждого 
      атрибута состоит из трех основных компонентов: имени, типа данных и флага, 
      определяющего особенности данного атрибута. Вместо многоточия (...) могут 
      быть расположены объявления других атрибутов.</P>
      <P>Простое объявление атрибута уже встречалось нам в листинге 14.2:</P>
      <P>&lt;!ATTLIST recipe category CDATA #REQUIRED&gt;</P>
      <P>Тем не менее, как видно из приведенного общего определения, допускается 
      одновременное объявление нескольких атрибутов. Допустим, в дополнение к 
      атрибуту category вы хотите связать с элементом recipe дополнительный 
      атрибут difficulty (сложность приготовления). Оба атрибута объявляются в 
      одном списке:</P>
      <P>&lt;!ATTLIST recipe category CDATA #REQUIRED difficulty CDATA 
      #REQUIRED&gt;</P>
      <P>Форматировать объявления подобным образом необязательно; тем не менее, 
      многострочные объявления нагляднее однострочных. Кроме того, поскольку оба 
      атрибута являются обязательными, тег reci ре не может ограничиться 
      каким-нибудь одним атрибутом, он должен включать в себя оба атрибута 
      сразу. Например, следующий тег будет считаться неверным: &lt;recipe 
      difficulty="hard"&gt;</P>
      <P>Почему? Потому что в нем отсутствует атрибут category. Правильный тег 
      должен содержать оба атрибута:</P>
      <P>&lt;recipe category="Italian" difficulty="hard"&gt;</P>
      <P>Особые условия обработки атрибута описываются тремя флагами, 
      перечисленными в табл. 14.2.</P>
      <P>Таблица 14.2. Флаги атрибутов </P>
      <TABLE width="100%" border=1>
        <TBODY>
        <TR>
          <TD align=middle width=117>
            <P>Флаг</P></TD>
          <TD align=middle width=417>Описание</TD></TR>
        <TR>
          <TD width=117>#FIXED</TD>
          <TD width=417>
            <P>&nbsp;Во всех экземплярах элемента в документе атрибуту может 
            присваиваться только одно конкретное значение</P></TD></TR>
        <TR>
          <TD width=117>#IMPLIED</TD>
          <TD width=417>
            <P>&nbsp; Если атрибут не указан в элементе, используется значение 
            по умолчанию&nbsp;</P></TD></TR>
        <TR>
          <TD width=117>#REQUIRED</TD>
          <TD width=417>
            <P>&nbsp;Атрибут является обязательным и должен присутствовать во 
            всех экземплярах элемента в документе</P></TD></TR></TBODY></TABLE>
      <P>Типы атрибутов</P>
      <P>Атрибут элемента может объявляться с определенным типом. Типы атрибутов 
      описаны далее.</P>
      <P>Атрибуты CDATA</P>
      <P>Очень часто атрибуты содержат общие символьные данные. Такие атрибуты 
      называются атрибутами CDATA. Следующий пример уже встречался в начале 
      этого раздела:</P>
      <P>&lt;!ATTLIST recipe category COATA #REQUIRED&gt;</P>
      <P>Атрибуты ID, IDREF и IDREFS</P>
      <P>Идея однозначного представления данных (например, информации о 
      пользователе или товаре, хранящейся в базе данных) посредством 
      идентификаторов неоднократно встречалась в предыдущих главах книги. 
      Идентификаторы также часто используются в XML, поскольку перекрестные 
      ссылки между документами применяются не только в общих задачах обработки 
      данных, но и в World Wide Web (гиперссылки).</P>
      <P>Идентификаторы элементов присваиваются атрибуту ID. Допустим, вы хотите 
      связать с каждым рецептом уникальный идентификатор. Соответствующий 
      фрагмент DTD может выглядеть так:</P>
      <P>&lt;!ELEMENT recipe (title, description, ingredients, process)&gt;</P>
      <P>&lt;!ATTLIST recipe recipe-id ID #REQUIRED&gt;</P>
      <P>&lt;!ELEMENT recipe-ref EMPTY&gt;</P>
      <P>&lt;!ATTLIST recipe-ref go IDREF #REQUIRED&gt;</P>
      <P>После этого объявление элемента recipe в документе может выглядеть 
      так:</P>
      <P>&lt;recipe recipe-id="ital003"&gt;&nbsp;</P>
      <P>&lt;title&gt;Spaghetti alla Carbonara&lt;/title&gt;</P>
      <P>Рецепт однозначно определяется идентификатором ital003. Следует 
      помнить, что атрибут redpe-id относится к типу ID, поэтому ital003 не 
      может использоваться в качестве значения атрибута recipe-id другого 
      элемента, в противном случае документ будет считаться синтаксически 
      неверным. Теперь допустим, что позднее вы захотели сослаться на этот 
      рецепт из другого документа — скажем, из списка любимых рецептов 
      пользователя. Именно здесь в игру вступают перекрестные ссылки и атрибут 
      IDREF. Атрибуту IDREF присваивается идентификатор, используемый для ссылок 
      на элемент, — по аналогии с тем, как URL используется для идентификации 
      страницы в гиперссылке. Рассмотрим следующий фрагмент кода XML:</P>
      <P>&lt;favoriteRecipes&gt;&nbsp;</P>
      <P>&lt;recipe-ref go="ital003"&gt;&nbsp;</P>
      <P>&lt;/favoriteRecipes&gt;</P>
      <P>В процессе обработки документа XML элемент заменяется более наглядной 
      ссылкой на рецепт с указанным идентификатором (например, названием 
      рецепта). Вероятно, он будет отформатирован в виде гиперссылки, чтобы 
      упростить переход к указанному рецепту.</P>
      <P>Перечисляемые атрибуты</P>
      <P>При объявлении атрибута можно перечислить все допустимые значения, 
      принимаемые атрибутом. В нашем примере это было бы удобно, поскольку вы 
      можете сразу определить список допустимых категорий. Приведенное выше 
      объявление записывается в следующем виде:</P>
      <P>&lt;!ATTLIST recipe category (Italian | French | Japanese | Chinese) 
      #REQUIRED difficulty (easy | medium | hard) #REQUIRED)</P>
      <P>Обратите внимание: при использовании списков допустимых значений 
      включать в объявление тип CDATA не нужно, поскольку все перечисленные 
      значения относятся к формату CDATA.</P>
      <P>Перечисляемые атрибуты со значением по умолчанию</P>
      <P>Иногда бывает удобно объявить для атрибута значение по умолчанию. 
      Скорее всего, вам уже приходилось делать это раньше при построении форм с 
      раскрывающимися списками. Например, если большинство рецептов в вашей 
      поваренной книге относится к итальянской кухне, атрибут recipe будет часто 
      относиться к категории Italian. В этом случае категорию Italian можно 
      назначить по умолчанию:&nbsp;</P>
      <P>&lt;!ATTLIST recipe category (Italian | French | Japanese | Chinese) 
      "Itaian"&gt;</P>
      <P>Если атрибут category не задан явно, по умолчанию ему присваивается 
      значение Italian.</P>
      <P>Атрибуты ENTITY и ENTITIES</P>
      <P>Данные в документах XML не всегда являются текстовыми — документ может 
      содержать и двоичную информацию (например, графику). На такие данные можно 
      ссылаться при помощи атрибута entity. Например, в описании элемента 
      description можно указать атрибут recipePicture с графическим 
      изображением:</P>
      <P>&lt;!ATTLIST description recipePicture ENTITY #IMPLIED&gt;</P>
      <P>Также можно объявить сразу несколько сущностей, заменив ENTITY на 
      ENTITIES. Значения разделяются пробелами.</P>
      <P>Атрибуты NMTOKEN и NMTOKENS</P>
      <P>Атрибуты NMTOKEN представляют собой строки из символов, входящих в 
      ограниченный набор. Объявление атрибута с типом NMTOKEN предполагает, что 
      значение атрибута соответствует установленным ограничениям. Как правило, 
      значение атрибута NMTOKEN состоит из одного слова:</P>
      <P>&lt;!ATTLIST recipe category NMTOKEN #REQUIRED&gt;</P>
      <P>Можно объявить сразу несколько атрибутов, заменив NMTOKEN на NMTOKENS. 
      Значения разделяются пробелами.</P>
      <P>Объявления сущностей</P>
      <P>Объявление сущности напоминает команду define в некоторых языках 
      программирования, включая РНР. Ссылки на сущности кратко упоминались в 
      предыдущем разделе «Знакомство с синтаксисом XML». На всякий случай 
      напомню, что ссылка на сущность используется в качестве замены для другого 
      фрагмента содержания. В процессе обработки документа XML все вхождения 
      сущности заменяются содержанием, которое она представляет. Существует два 
      вида сущностей: внутренние и внешние.</P>
      <P>Внутренние сущности</P>
      <P>Внутренние сущности напоминают строковые переменные, связывающие имя с 
      фрагментом текста. Например, если вы хотите определить имя для ссылки на 
      информацию об авторских правах, можно объявить сущность следующего 
      вида:</P>
      <P>&lt;!ENTITY Copyright "Copyright 2000 YourCompanyName. All Rights 
      Reserved."&gt;</P>
      <P>В процессе обработки документа все экземпляры &amp;Соруright заменяются 
      текстом «Copyright 2000 YourCompanyName. All Rights Reserved». Весь код 
      XML в заменяющем тексте обрабатывается так, словно он присутствовал в 
      исходном документе.</P>
      <P>Внутренние сущности удобны в ситуациях, когда вы планируете 
      использовать сущность в относительно небольшом количестве документов XML. 
      При большом количестве документов лучше воспользоваться внешними 
      сущностями.</P>
      <P>Внешние сущности</P>
      <P>Внешние сущности используются для ссылок на содержание, находящееся в 
      другом файле. Сущности этого типа могут содержать текстовую информацию, но 
      также могут ссылаться и на двоичные данные (например, графику). 
      Возвращаясь к предыдущему примеру, допустим, что вы решили сохранить 
      информацию об авторских правах в отдельном файле, чтобы упростить ее 
      редактирование в будущем. Ссылка на созданный файл выглядит следующим 
      образом:&nbsp;</P>
      <P>&lt;!ENTITY Copyright SYSTEM 
      "http://yoursite.com/administer/copyright.xml"&gt;</P>
      <P>При последующей обработке документа XML все ссылки &amp;Соруright 
      заменяются содержимым документа copyright.xml. Весь код XML в заменяющем 
      тексте обрабатывается так, словно он присутствовал в исходном 
      документе.</P>
      <P>Внешние сущности также удобно использовать для ссылок на графические 
      изображения. Например, если вы хотите включить в документ XML графический 
      логотип, создайте внешнюю сущность:</P>
      <P>&lt;!ENTITY food_picture SYSTEM 
      http://yoursite.com/food/logo.gif&gt;</P>
      <P>Как и в предыдущем примере, все ссылки &amp;food_picture заменяются 
      графическим изображением, на которое указывает ссылка. Поскольку данные 
      являются двоичными, а не текстовыми, они не интерпретируются.</P>
      <P>Ресурсы, посвященные XML</P>
      <P>Хотя приведенного выше материала вполне достаточно для понимания 
      базовой структуры документов XML, данное описание не является полным. Ниже 
      приведены ссылки на ресурсы Интернета, содержащие более подробную 
      информацию:</P>
      <UL>
        <LI><A href="http.html://www.w3.org/XML">http://www.w3.org/XML</A>; 
        <LI><A 
        href="http.html://www.xml.com/pub/ArticlesByTopic">http://www.xml.com/pub/ArticlesByTopic</A>; 

        <LI><A 
        href="http.html://ww.ibm.com/developer/xml">http://ww.ibm.com/developer/xml</A>; 

        <LI><A 
        href="http.html://www.oasis-open.org.cover/">http://www.oasis-open.org.cover/</A>. 
        </LI></UL>
      <P>В оставшейся части главы рассказано о том, как использовать РНР для 
      обработки документов XML. На первый взгляд задача кажется очень сложной 
      (лексический анализ любых документов любого типа вызывает немало 
      затруднений).</P>
      <P>Но стоит познакомиться с базовой стратегией работы с XML в РНР, и все 
      оказывается на удивление просто.</P>
      <P><A href="http.html://doks.gorodok.net/996" name=h></A>РНР и ХМL</P>
      <P>Для работы с XML в РНР используется пакет Джеймса Кларка (James Clark) 
      Expat (XML Parser Toolkit) — cm. http://www.jclark.com/xml. Expat 
      включается в поставку Apache 1.3.7 и более поздних версий, поэтому вам не 
      придется специально загружать его, если вы используете свежую версию 
      Apache. Чтобы воспользоваться функциональными возможностями XML в РНР, 
      необходимо настроить РНР с ключом -with-xml.</P>
      <P>Разработку Expat 2.0 в настоящее время ведет Кларк Купер (Clark 
      Cooper). За дополни- тельной информацией обращайтесь по адресу <A 
      href="http.html://expat.sourceforge.net/">http://expat.sourceforge.net/</A>. 
      </P>
      <P>На первый взгляд задача обработки данных XML на РHР (или на любом 
      другом языке) выглядит устрашающе, но на самом деле большая часть работы 
      выполняется за вас стандартными средствами РНР. Вам остается лишь 
      определить новые функции для своих DTD и затем применить их в несложном 
      процессе обработки кода XML.</P>
      <P>Прежде чем переходить к рассмотрению функций РНР, предназначенных для 
      работы с XML, необходимо познакомиться с основными компонентами документа 
      XML. Это поможет вам лучше понять, почему эти функции являются незаменимой 
      частью любой программы обработки XML-кода. На самом общем уровне документ 
      XML содержит компоненты девяти видов:</P>
      <UL>
        <LI>открывающие теги; 
        <LI>атрибуты; 
        <LI>символьные данные; 
        <LI>закрывающие теги; 
        <LI>инструкции по обработке; 
        <LI>синтаксические объявления; 
        <LI>внешние ссылки на сущности; 
        <LI>необработанные сущности; 
        <LI>прочие компоненты (комментарии, объявления XML и т. д.). </LI></UL>
      <P>Для эффективной обработки документов XML необходимо определить 
      пользовательские функции-обработчики (handlers), обрабатывающие каждый из 
      перечисленных компонентов. Определенные функции подключаются к процессу 
      обработки XML стандартными средствами РНР. Общий процесс обработки кода 
      XML в РНР состоит из пяти этапов:</P>
      <OL>
        <LI>Определите пользовательские функции. Разумеется, если вы собираетесь 
        постоянно работать с документами XML, эти функции достаточно написать 
        всего один раз и в дальнейшем лишь вносить в них необходимые изменения. 
        <LI>Создайте анализатор (parser) кода XML, который будет использоваться 
        для обработки документа. Анализатор создается вызовом функции 
        xml_parser_create( ). 
        <LI>При помощи стандартных функций зарегистрируйте свои функции в 
        анализаторе XML. 
        <LI>Откройте файл XML, прочитайте содержащиеся в нем данные и передайте 
        их анализатору XML. Обработка данных выполняется простым вызовом 
        xml_parse( )! В процессе своей работы эта функция обеспечивает косвенный 
        вызов всех определенных вами обработчиков. 
        <LI>Уничтожьте анализатор XML, чтобы освободить задействованные им 
        ресурсы. </LI></OL>
      <P>Задача решается функцией xml_parser_free( ). Смысл всех перечисленных 
      этапов разъясняется в следующем разделе.</P>
      <P><A name=i></A>Подключение пользовательских функций к обработке XML</P>
      <P>В РНР существует восемь стандартных функций для регистрации 
      пользовательских функций, обрабатывающих различные компоненты документов 
      XML.</P>
      <P>Следует помнить, что вы обязательно должны определить все 
      пользовательские функции; в противном случае произойдет ошибка. В этом 
      разделе перечислены все стандартные функции регистрации и приведены 
      спецификации всех пользовательских функций.</P>
      <P>xml_set_character_data_handler()</P>
      <P>Функция регистрирует пользовательскую функцию для работы с символьными 
      данными. Синтаксис:</P>
      <P>int xml_set_character data_handler(int анализатор, string 
      обработчик_символьных_данных)</P>
      <P>Первый параметр определяет анализатор XML, а второй — имя 
      пользовательской функции, используемой при обработке символьных данных. 
      Определение функции-обработчика должно выглядеть так:</P>
      <P>function обработчик_символьных_данных (int анализатор, string данные) { 
      </P>
      <P>...</P>
      <P>}</P>
      <P>Первый параметр определяет анализатор XML, а второй — символьные 
      данные, подлежащие обработке.</P>
      <P>xml_set_default_handler( )</P>
      <P>Функция регистрирует пользовательскую функцию для всех 
      незарегистрированных компонентов документа XML. В частности, к числу таких 
      компонентов относятся пролог XML и комментарии. Синтаксис:</P>
      <P>int xml_set_default_handler(int анализатор, string 
      обработчик_по_умолчанию)</P>
      <P>Первый параметр определяет анализатор XML, а второй — имя 
      пользовательской функции, используемой по умолчанию. Определение 
      функции-обработчика должно выглядеть так:</P>
      <P>function обработчик_по_умолчанию (int анализатор, string данные) { </P>
      <P>...</P>
      <P>}</P>
      <P>Первый параметр определяет анализатор XML, а второй — символьные 
      данные, подлежащие обработке.</P>
      <P>xml_set_element_handler( )</P>
      <P>Функция регистрирует пользовательские функции для обработки открывающих 
      и закрывающих тегов элементов. Синтаксис:</P>
      <P>int xml_set_element_handler(int анализатор, string 
      обработчик_открывающих_тегов, string обработчик_закрывающих_тегов) </P>
      <P>Первый параметр определяет анализатор XML. Второй и третий параметры 
      определяют имена функций, используемых для обработки, соответственно, 
      открывающих и закрывающих тегов. Определение обработчика открывающих тегов 
      должно выглядеть так:</P>
      <P>function обработчик_открывающих_тегов (int анализатор, string 
      имя_тега,&nbsp; </P>
      <P>string атрибуты[ ]) {</P>
      <P>...</P>
      <P>}</P>
      <P>Первый параметр определяет анализатор XML, второй — имя открывающего 
      тега для анализируемого элемента, а третий содержит массив атрибутов 
      соответствующего тега.</P>
      <P>Обработчик закрывающих тегов определяется следующим образом:</P>
      <P>function обработчик_закрывающих_тегов (int анализатор, string имя_тега) 
      { </P>
      <P>...</P>
      <P>}</P>
      <P>Первый параметр определяет анализатор XML, второй — имя закрывающего 
      тега для анализируемого элемента.</P>
      <P>xml_set_external_entity_ref_handler( )</P>
      <P>Функция регистрирует пользовательскую функцию для обработки внешних 
      ссылок на сущности. Синтаксис:</P>
      <P>int xml_set_external_entity_ref_handler(int анализатор, string 
      обработчик_внешних_ссылок) </P>
      <P>Первый параметр определяет анализатор XML, а второй — имя 
      пользовательской функции, используемой при обработке внешних ссылок. 
      Определение функции-обработчика должно выглядеть так:</P>
      <P>function обработчик_внешних_ссылок (int анализатор, string ссылка, 
      string база. string системный_идентификатор, string 
      открытый_идентификатор) { </P>
      <P>...</P>
      <P>}</P>
      <P>Первый параметр определяет анализатор XML. Второй параметр определяет 
      имя ссылки, четвертый — системный идентификатор ссылки на сущность, а 
      пятый — открытый идентификатор ссылки. Третий параметр, база, в настоящее 
      время не используется, однако его объявление все равно обязательно.</P>
      <P>xml_set_notation_decl_handler ( )</P>
      <P>Функция регистрирует пользовательскую функцию для обработки 
      синтаксических объявлений. Синтаксис:</P>
      <P>int xml_set_notation_decl_handler(int анализатор, string 
      обработчик_синтаксических_обьявлений)</P>
      <P>Первый параметр определяет анализатор XML, а второй — имя 
      пользовательской функции, используемой при обработке синтаксических 
      объявлений. Определение функции-обработчика должно выглядеть так:</P>
      <P>function обработчик_синтаксических_обьявлений (int анализатор, string 
      ссылка, string база, string системный_идентификатор, string 
      открытый_идентификатор) { </P>
      <P>...</P>
      <P>}</P>
      <P>Первый параметр определяет анализатор XML. Второй параметр определяет 
      имя объявления, четвертый — системный идентификатор, а пятый — открытый 
      идентификатор объявления. Третий параметр, база, в настоящее время не 
      используется, однако его объявление все равно обязательно.</P>
      <P>xml_set_object( )</P>
      <P>Функция ассоциирует анализатор XML с некоторым объектом. Синтаксис:</P>
      <P>void xml_set_object(int анализатор, object &amp;о6ъект) </P>
      <P>Первый параметр определяет анализатор XML, а второй содержит ссылку на 
      объект, методы которого будут использоваться для обработки компонентов 
      XML. Таким образом, функция xml_set_object связывает анализатор с 
      объектом. Как правило, она вызывается в конструкторе объекта перед 
      определениями функций-обработчиков:</P>
      <P>class xmlDB {&nbsp;</P>
      <P>VAR $xmlparser:</P>
      <P>function xmlDB( ) {&nbsp;</P>
      <P>$this-&gt;xmlparser = xml_parser_create();&nbsp;</P>
      <P>// Связать анализатор с объектом&nbsp;</P>
      <P>xml_set_object($this-&gt;xmlparser. &amp;$this);&nbsp;</P>
      <P>// Определить функции-обработчики</P>
      <P>xml_set_element_handler($this-&gt;xmlparser,</P>
      <P>"startTag","endTag");</P>
      <P>xml_set_character_data($this-&gt;xmlparser,"characterData");</P>
      <P>}</P>
      <P>... Определения функций-обработчиков startTag. endTag. characterData и 
      т.д. ...</P>
      <P>} // class xmlDB</P>
      <P>В порядке эксперимента попробуйте закомментировать вызов 
      xml_set_object( ). Вы увидите, что при выполнении этого фрагмента 
      выводятся сообщения об ошибках, в которых говорится о невозможности 
      обращения к методам объекта.</P>
      <P>xml_set_processing_instruction_handler( )</P>
      <P>Функция регистрирует пользовательскую функцию для работы с 
      Pi-инструкциями.</P>
      <P>Синтаксис:</P>
      <P>int xml_set_processing_instruction_handler(int анализатор, string 
      обработчик_инструкций) </P>
      <P>Первый параметр определяет анализатор XML, а второй — имя 
      пользовательской функции, используемой при обработке Pi-инструкций. 
      Определение функции-обработчика должно выглядеть так:</P>
      <P>function обработчик_инструкций (int анализатор, string приложение, 
      string инструкция) { </P>
      <P>...</P>
      <P>}</P>
      <P>Первый параметр определяет анализатор XML, второй — имя приложения, 
      выполняющего инструкции, а третий — инструкцию, передаваемую 
      приложению.</P>
      <P>xml_set_unparsed_entity_decl_handler( )</P>
      <P>Функция регистрирует пользовательскую функцию для необработанных 
      внешних ссылок на сущности. Синтаксис:</P>
      <P>int xml_set_external_entity_ref_handler(int анализатор, string 
      обработчик_внешних_ссылок) </P>
      <P>Первый параметр определяет анализатор XML, а второй — имя 
      пользовательской функции, используемой для обработки необработанных 
      внешних ссылок. Определение функции-обработчика должно выглядеть так:</P>
      <P>function обработчик_внешних_ссылок (int анализатор, string сущность, 
      string база, string системный_идентификатор. string 
      открытый_идентификатор, string имя_объявления) { </P>
      <P>...</P>
      <P>}</P>
      <P>Первый параметр определяет анализатор XML. Второй параметр определяет 
      имя ссылки, четвертый — системный идентификатор ссылки на сущность, а 
      пятый — открытый идентификатор ссылки. Третий параметр, база, в настоящее 
      время не используется, однако его объявление все равно обязательно. 
      Наконец, последний параметр определяет имя синтаксического объявления.</P>
      <P>На этом завершается наше краткое знакомство с обработчиками и функциями 
      регистрации. Впрочем, для эффективной обработки документов XML вам 
      понадобятся и другие функции. В следующем разделе представлены остальные 
      функции РНР, связанные с обработкой кода XML.</P>
      <P><A name=j></A>Функции обработки кода XML</P>
      <P>Хотя реализация всех функций-обработчиков не обязательна (документы XML 
      не обязаны содержать элементы всех типов), по крайней мере три функции 
      должны присутствовать во всех сценариях, работающих с XML.</P>
      <P>xml_parser_create( )</P>
      <P>Перед обработкой документа XML необходимо предварительно создать 
      анализатор. Синтаксис:</P>
      <P>int xml_parser_create([stnng кодировка]) </P>
      <P>Необязательный параметр определяет кодировку исходного текста. В 
      настоящее время поддерживаются три варианта кодировки:</P>
      <UL>
        <LI>UTF-8; 
        <LI>US-ASCII; 
        <LI>ISO-8859-1 (используется по умолчанию). </LI></UL>
      <P>По аналогии с тем, как функция fopen( ) возвращает манипулятор 
      открытого файла, функция xml_parser_create( ) также возвращает 
      манипулятор, используемый для вызова различных функций в процессе 
      обработки XML. При одновременной обработке нескольких документов можно 
      создать сразу несколько анализаторов.</P>
      <P>xml_parse()</P>
      <P>Функция xml_parse( ) выполняет обработку документа XML. Синтаксис:</P>
      <P>int xml_parse(int анализатор, string данные [int завершение]) </P>
      <P>Первый параметр определяет анализатор XML (используется значение, 
      возвращаемое при вызове xml_parser_create( )). Если необязательный 
      параметр завершение равен TRUE, передаваемый фрагмент данных является 
      последним. Как правило, это происходит при достижении конца 
      обрабатываемого файла.</P>
      <P>xml_parser_free( )</P>
      <P>Функция освобождает ресурсы, выделенные для работы анализатора. 
      Синтаксис:</P>
      <P>int xml_parser_free(int анализатор) </P>
      <P>Параметр функции определяет анализатор XML.</P>
      <P><A name=k></A>Другие полезные функции</P>
      <P>В РНР также существуют другие функции, упрощающие процесс обработки 
      кода XML.</P>
      <P>utf8_decode( )</P>
      <P>Функция преобразует данные в кодировку ISO-8859-1. Предполагается, что 
      преобразуемые данные находятся в кодировке UTF-8. Синтаксис:</P>
      <P>string utf8_decode(string данные) </P>
      <P>Параметр данные содержит преобразуемые данные в кодировке UTF-8.</P>
      <P>utf8_encode( )</P>
      <P>Функция преобразует данные из кодировки ISO-8859-1 в кодировку UTF-8. 
      Синтаксис:</P>
      <P>string utf8_decode(string данные) </P>
      <P>Параметр данные содержит преобразуемые данные в кодировке 
      ISO-8859-1.</P>
      <P>xml_get_error_code( )</P>
      <P>Функция xm1_get_error_code( ) получает код ошибки, возникшей в процессе 
      обработки XML. Код ошибки передается функции xml_error_string( ) (см. 
      ниже) для интерпретации. Синтаксис:</P>
      <P>int xml_error_code(int анализатор) </P>
      <P>Параметр функции определяет анализатор XML. Пример использования 
      приведен ниже, в описании функции xml_get_current_line_number( ).</P>
      <P>xml_error_string( )</P>
      <P>Ошибкам, возникающим в процессе анализа кода XML, присваиваются 
      числовые коды. Функция xml_error_string( ) возвращает текстовое описание 
      ошибки по ее коду. Синтаксис:</P>
      <P>string xml_error_string(int код) </P>
      <P>В параметре функции передается код ошибки (вероятно, полученный при 
      вызове функции xml_get_error_code( )). Пример использования функции 
      приведен ниже, в описании функции xml_get_current_line_number( ).</P>
      <P>xml_get_current_line_number( )</P>
      <P>Функция возвращает номер текущей строки, обрабатываемой анализатором 
      XML. Синтаксис:</P>
      <P>int xml_get_current_line_number(int анализатор) </P>
      <P>Параметр функции определяет анализатор XML. Пример использования 
      функции:</P>
      <P>while ($line - fread($fh. 4096)) :</P>
      <P>if (! xml_parse($xml_parser. $line. feof($fh)));</P>
      <P>$err_string - 
      xml_error_string(xml_get_error_code($xml_parser));&nbsp;</P>
      <P>$line_number - xml_get_current_line_number($xml_parser);&nbsp;</P>
      <P>print "Error! [Line Sline_number]: $err_string";</P>
      <P>endif;&nbsp;</P>
      <P>endwhile;</P>
      <P>Например, если ошибка была обнаружена в шестой строке файла, 
      определяемого манипулятором $fh, сообщение будет выглядеть примерно 
      так:</P>
      <P>Error! [Line 6]:mi snatched tag</P>
      <P>xml_get_current_column_number( )</P>
      <P>Функция xml_get_current_colunin_number( ) может использоваться в 
      сочетании с xml_get_current_line_number( ) для определения точного 
      местонахождения ошибки в документе XML. Синтаксис:</P>
      <P>int xml_get_current_column_number(int анализатор) </P>
      <P>Параметр функции определяет анализатор XML. Давайте усовершенствуем 
      предыдущий пример:</P>
      <P>while ($line = fread($fh. 4096)) :</P>
      <P>if (! xml_parse($xml_parser, $line, feof($fh))):</P>
      <P>$err_string = 
      xml_error_string(xml_get_error_code($xml_parser));&nbsp;</P>
      <P>$line_number = xml_get_current_line_number($xml_parser);&nbsp;</P>
      <P>$column_number = xml_get_current_column_number($xml_parser)&nbsp;</P>
      <P>print "Error! [Line $line_nuimber, Column $column_number]: 
      $err_string";&nbsp;</P>
      <P>endif;&nbsp;</P>
      <P>endwhile;</P>
      <P>Например, если ошибка была обнаружена в шестой строке файла, 
      определяемого манипулятором $fh, сообщение будет выглядеть примерно 
      так:</P>
      <P>Error! [Line 6 Column 2]:mismatched tag</P>
      <P><A name=l></A>Параметры анализатора XML</P>
      <P>В настоящее время в РНР поддерживаются два параметра, влияющих на 
      работу анализатора XML:</P>
      <UL>
        <LI>XML_OPTION_CASE_FOLDING — автоматическое преобразование имен тегов к 
        верхнему регистру; 
        <LI>XML_OPTION_TARGET_ENCODING — кодировка документа на выходе 
        анализатора XML. В настоящее время поддерживаются кодировки UTF-8, 
        ISO-8859-1 и US-ASCII. </LI></UL>
      <P>Для получения текущих значений и модификации этих параметров 
      применяются, соответственно, функции xml_parser_get_option( ) и 
      xml_parser_set_option( ).</P>
      <P>xml_parser_get_option( )</P>
      <P>Функция xml_parser_get_option( ) получает текущее значение параметра 
      анализатора XML. Синтаксис:</P>
      <P>int xml_parser_get_option(int анализатор, int параметр) </P>
      <P>Первый параметр функции определяет анализатор XML, а второй — имя 
      интересующего вас параметра. Пример:</P>
      <P>$setting = xml_parser_get_option($xml_parser, 
      XML_OPTION_CASE_FOLDING);&nbsp;</P>
      <P>print "Case Folding: $setting";</P>
      <P>Если параметру XML_OPTION_CASE_FOLDING не присваивалось другое 
      значение, функция вернет значение по умолчанию. В этом случае будет 
      выведен следующий результат:</P>
      <P>Case Folding: 1</P>
      <P>xml_parser_set_option( )</P>
      <P>Функция xml_parser_set_option() задает значение параметра анализатора 
      XML. Синтаксис:</P>
      <P>int xml_parser_set_option(int анализатор, int параметр, mixed значение) 
      </P>
      <P>Первый параметр функции определяет анализатор XML, второй — имя 
      интересующего вас параметра, а третий — его новое значение. Пример:</P>
      <P>$setting = xml_parser_set_option($xml_parser, 
      XML_OPTION_TARGER_ENCODING."UTF-8"):</P>
      <P>В результате выполнения этой команды выходная кодировка документа 
      изменяется с ISO-8859-1 на UTF-8.</P>
      <P><A name=m></A>Преобразование XML в HTML</P>
      <P>Предположим, у вас имеется документ XML bookmarks.xml, содержащий 
      список ссылок. Он выглядит примерно так:</P>
      <P>&lt;?xml version="1.0"?&gt;</P>
      <P>&lt;website&gt;</P>
      <P>&lt;title&gt;Epicurious&lt;/title&gt;</P>
      <P>&lt;url&gt;http://www.epicurious.com&lt;/url&gt;</P>
      <P>&lt;description&gt;</P>
      <P>Epicurious is a great online cooking resource, providing tutorials.</P>
      <P>recipes, forums and more.</P>
      <P>&lt;/description&gt; &lt;/website&gt;</P>
      <P>Допустим, вы хотите преобразовать bookmarks.xml и вывести его 
      содержимое в формате, совместимом с форматом браузера вашего компьютера. 
      Программа, приведенная в листинге 14.3, преобразует файл к нужному 
      формату.</P>
      <P>Листинг 14.3. Преобразование XML в HTML</P>
      <P>Class XMLHTML {</P>
      <P>VAR $xmlparser: VAR $tagcolor ="#800000";</P>
      <P>VAR $datacolor ="#0000ff";</P>
      <P>function XMLHTML( ) {</P>
      <P>$this-&gt;xmlparser = xml_parser_create();</P>
      <P>xml_set_object($this-&gt;xmlparser. &amp;$this);&nbsp;</P>
      <P>xml_set_element_handler($this-&gt;xmlparser, "startTag", 
      "endTag");&nbsp;</P>
      <P>xml_set_character_data_handler($this-&gt;xmlparser. 
      "characterData");</P>
      <P>}</P>
      <P>// Функция отвечает за обработку всех открывающих тегов.</P>
      <P>function startTag($parser, $tagname, $attributes) {</P>
      <P>GLOBAL $tagcolor;</P>
      <P>print "&lt;font size=\"-2\" color=\"$this-&gt;tagcolor\" 
      face=\"arial,&nbsp;</P>
      <P>verdana\ "&gt;&amp;1 t ; $tagname&amp;gt ; &lt;/f ont&gt; &lt;br&gt;" 
      ;</P>
      <P>// Функция отвечает за обработку всех символьных данных.</P>
      <P>function characterData($parser. $characterData) {&nbsp;</P>
      <P>GLOBAL $datacplor;</P>
      <P>print "&lt;font size=\"-2\" color=\"$this-&gt;datacolor\" 
      face=\"arial,</P>
      <P>verdana\ "&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; 
      $characterData&lt;/font&gt; &lt;br&gt;";</P>
      <P>// Функция отвечает за обработку всех закрывающих тегов.</P>
      <P>function endTag(Sparser, $tagname) {</P>
      <P>GLOBAL Stagcolor;</P>
      <P>print "&lt;font size=\"-2\" color=\"$this-&gt;tagcolor\" face=\"arial, 
      verdana\"&gt;&amp;lt;/&nbsp;</P>
      <P>$tagname&amp;gt;&lt;/font&gt; &lt;br&gt;";</P>
      <P>}</P>
      <P>function.parse($fp) {</P>
      <P>// xml_parse($this-&gt;xm1parser,$data);</P>
      <P>// Обработать файл XML</P>
      <P>while ( $line = fread($fp. 4096) ) :</P>
      <P>// При возникновении ошибки прервать обработку // и вывести сообщение 
      об ошибке.</P>
      <P>if ( ! xml_parse($this-&gt;xmlparser, $line, feof($fp))) :</P>
      <P>die(sprintf("XML error: %s at line %d",&nbsp;</P>
      <P>xml_error_sthng(xml_get_error_code($this-&gt;xmlparser)),&nbsp;</P>
      <P>xml_get_curren_line_number($this-&gt;xml parser)));&nbsp;</P>
      <P>endif;</P>
      <P>endwhile;</P>
      <P>}</P>
      <P>}</P>
      <P>// Открыть файл XML для обработки&nbsp;</P>
      <P>$xml_file = "bookmarks. xml";&nbsp;</P>
      <P>$fp = f open ($xml_flie, "r");</P>
      <P>// Создать новый объект&nbsp;</P>
      <P>$xml_parser = new XMLHTML;</P>
      <P>// Обработать $xml_file&nbsp;</P>
      <P>$xml_parser-&gt;parse($fp);</P>
      <P>?&gt;</P>
      <P>В результате преобразования файл bookmarks.xml выводится в браузере в 
      следующем виде:</P>
      <P>&lt;WEBSITE&gt;&nbsp;</P>
      <P>&lt;TITLE&gt;</P>
      <P>Epicurious&nbsp;</P>
      <P>&lt;/TITLE&gt;&nbsp;</P>
      <P>&lt;URL&gt;</P>
      <P>http : //www.epicurious.com&nbsp;</P>
      <P>&lt;/URL&gt;</P>
      <P>&lt;DESCRIPTION&gt;</P>
      <P>Epicurious is a great online cooking resource,</P>
      <P>providing tutorials, recipes, forums and more.&nbsp;</P>
      <P>&lt;/DESCRIPTION&gt;&nbsp;</P>
      <P>&lt;/WEBSITE&gt;</P>
      <P>Конечно, результат не такой уж впечатляющий — мы всего лишь добились, 
      чтобы файл XML отображался в браузере. Внеся небольшие изменения в листинг 
      14.3, можно преобразовать URL в работающие гиперссылки, оформить данные 
      между парой тегов &lt;TITLE&gt;...&lt;/TITLE&gt; жирным шрифтом и т. д. 
      Как видно из листинга 14.3, я использую шрифт двух разных цветов, чтобы 
      продемонстрировать возможность форматирования текста в браузере.</P>
      <P><A name=n></A>Несколько слов о РНР и XML</P>
      <P>В этой главе мы познакомились с XML и различными функциями РНР, 
      предназначенными для обработки документов в формате XML. Поскольку 
      основной темой книги является РНР, я описал лишь одну из трех спецификаций 
      стандарта XML и не упомянул о том, как работают XSL и XLL. Конечно, 
      полноценное отделение содержания от представления требует использования 
      всех трех компонентов или по меньшей мере XML и XSL.</P>
      <P>К сожалению, на момент написания книги РНР еще не обладал 
      возможностями, которые бы позволяли работать с XML исключительно 
      средствами РНР. Конечно,</P>
      <P>возможности РНР продолжают расширяться, и в будущем эта проблема 
      обязательно будет решена.</P>
      <P>Особого внимания в 
      этой области заслуживает XSL-процессор Sablotron, разработанный компанией 
      Ginger Alliance Lts. (http://www.gingerall.com). 12 октября 2000 года было 
      объявлено о том, что РНР 4.03 отныне распространяется с модулем расширения 
      Sablotron для платформ Linux и Windows. Обязательно проследите за 
      дальнейшим развитием событий.</P>
      <P><A href="http.html://doks.gorodok.net/24625" name=o></A>Итоги</P>
      <P>В этой главе был изложен довольно обширный материал, касающийся XML и 
      возможностей обработки кода XML в РНР. Глава начинается с краткой истории 
      языков разметки. Читатель знакомится с XML и его основными преимуществами, 
      после чего приводится сводка синтаксических конструкций языка. Оставшаяся 
      часть главы посвящена стандартным функциям РНР для работы с кодом XML. В 
      завершение приводятся примеры использования РНР для обработки и вывода 
      данных XML. В частности, рассматриваются следующие вопросы:</P>
      <UL>
        <LI>краткое описание языков разметки текста; 
        <LI>SGML; 
        <LI>общие сведения о XML; 
        <LI>синтаксис XML; 
        <LI>описание типа документа (DTD); 
        <LI>РНР и XML. </LI></UL>
      <P>В главе 15 рассматриваются две перспективные технологии, JavaScript и 
      СОМ (Component Object Model), и возможности их использования в 
      РНР.</P></LI></DIV>
<center>
[ <a href="13.php">Назад</a> | <a href="index.php">Содержание</a> | <a href="15.php">Вперед</a> ]
</center><br>
<? include_once '../../sys/inc/tfoot.php'; ?>