<? include 'head.php' ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html><head>
<link rel="stylesheet" href="css.css" type="text/css">
<meta http-equiv="Content-Type" content="text/html; charset=windows-1251">
<meta http-equiv="Content-Language" content="ru">
<title>Глава 10.</title></head>
<body>
<h1>Глава 10. ВСТАВКА ОДНОГО ЗАПРОСА ВНУТРЬ ДРУГОГО</h1>
<hr width="50%">
<p>В конце <a href="ch9.php">Главы 9</a> мы говорили, что запросы могут 
управлять другими запросами. В этой главе вы узнаете, как это делается (большей 
частью) путём помещения запроса внутрь предиката другого запроса и 
использования вывода внутреннего запроса в верном или неверном условии 
предиката.</p>
<p>Вы сможете выяснить, какие виды операторов могут использовать 
подзапросы, и посмотреть, как подзапросы работают со средствами SQL, такими как DISTINCT, с составными функциями и выводимыми выражениями.</p>
<p>Вы узнаете, как 
использовать подзапросы с предложением HAVING, и получите некоторые наставления, 
как правильно использовать подзапросы.</p>
<h3><a name="10.1">К</a>АК РАБОТАЕТ ПОДЗАПРОС?</h3>
<p>С помощью SQL вы можете вкладывать запросы друга в друга. Обычно внутренний 
запрос генерирует значение, которое проверяется в предикате внешнего запроса, 
определяющего, верно оно или нет. Например, предположим, что мы знаем имя 
продавца: Motika, но не знаем значение его поля snum и хотим извлечь все заказы 
из таблицы Заказов. Вот способ сделать это (вывод показан на Рис. 10.1 
):</p>
<pre>	SELECT *
       		FROM Orders
       		WHERE snum =
           		(SELECT snum
                		FROM Salespeople
                		WHERE sname = 'Motika');</pre>
<p>Чтобы оценить внешний (основной) запрос, SQL сначала должен оценить 
внутренний запрос (или подзапрос) внутри предложения WHERE. Он делает это так, 
как и должен делать запрос, имеющий единственную цель - отыскать через таблицу 
Продавцов все строки, где поле sname равно значению Motika, а затем извлечь 
значения поля snum этих строк.</p>
<p>Единственной найденной строкой, естественно, будет snum = 1004. Однако SQL не 
просто выдает это значение, а помещает его в предикат основного запроса вместо 
самого подзапроса, так чтобы предикат прочитал, что</p>
<pre>			WHERE snum = 1004


               ===============  SQL Execution Log ==============
              |                                                 |
              | SELECT *                                        |
              | FROM  Orders                                    |
              | WHERE snum =                                    |
              | (SELECT snum                                    |
              | FROM Salespeople                                |
              | WHERE sname = 'Motika');                        |
              |=================================================|
              |   onum       amt      odate      cnum     snum  |
              |  -----     -------  ----------  -----    -----  |
              |   3002     1900.10  10/03/1990   2007     1004  |
              |                                                 |
               =================================================</pre>
<pre>	<span lang="en-us">	    </span>Рисунок 10.1 Использование подзапроса</pre>
<p>Основной запрос затем выполняется как обычно с вышеупомянутыми результатами. 
Разумеется, подзапрос должен выбрать один, и только один, столбец, а тип данных 
этого столбца должен совпадать с тем значением, с которым он будет сравниваться 
в предикате.<br>
Часто, как показано выше, выбранное поле и его значение будут иметь 
одинаковые имена (в данном случае snum), но это не обязательно. Конечно, если бы 
мы уже знали номер продавца Motika, мы могли бы просто напечатать WHERE snum = 
1004 и работать далее с подзапросом в целом, но это было бы не так 
универсально. Этот же запрос будет продолжать работать, даже если номер Motika изменился, а 
с помощью простого изменения имени в подзапросе вы можете использовать его для 
чего угодно.</p>
<h3><a name="10.2">З</a>НАЧЕНИЯ, КОТОРЫЕ ПОДЗАПРОС МОЖЕТ ВЫВОДИТЬ</h3>
<p>Скорее всего, было бы удобнее, чтобы наш подзапрос в предыдущем примере 
возвращал одно, и только одно, значение.</p>
<p>Имея выбранное поле snum &quot; WHERE city = &quot;London&quot; вместо &quot;WHERE sname = 'Motika&quot;, 
можно получить несколько различных значений. Это может сделать в предикате 
основного запроса невозможным оценку верности или неверности, и команда выдаст 
ошибку.</p>
<p>При использовании подзапросов в предикатах, основанных на реляционных 
операциях (уравнениях или неравенствах, как объяснено в <a href="ch4.php">
Главе 4</a>), вы должны убедиться, что использовали подзапрос, который будет 
выдавать одну, и только одну, строку вывода. Если вы используете подзапрос, 
который не выводит никаких значений вообще, команда не потерпит неудачи, но 
основной запрос не выведет никаких значений. Подзапросы, которые не производят 
никакого вывода (или нулевой вывод), вынуждают рассматривать предикат ни как 
верный, ни как неверный, а как неизвестный. Однако неизвестный предикат имеет 
тот же самый эффект, что и неверный: никакие строки не выбираются основным 
запросом (смотри в <a href="ch5.php">Главе 5</a> подробную информацию о 
неизвестном предикате).</p>
<p>Вот пример плохой стратегии:</p>
<pre>                 SELECT *
                    FROM Orders
                    WHERE snum =
                      (SELECT snum
                           FROM Salespeople
                           WHERE city = Barcelona);
</pre>
<p>Поскольку мы имеем только одного продавца в Barcelona - Rifkin, то подзапрос 
будет выбирать одиночное значение snum, и, следовательно, будет принят. Но это 
только в данном случае. Большинство БД SQL имеют многочисленных пользователей, 
и, если другой пользователь добавит нового продавца из Barcelona в таблицу, 
подзапрос выберет два значения, и ваша команда потерпит неудачу.</p>
<h3><a name="10.3">D</a>ISTINCT С ПОДЗАПРОСАМИ</h3>
<p>В некоторых случаях вы можете использовать DISTINCT чтобы вынудить 
подзапрос генерировать одиночное значение. Предположим что мы хотим найти все 
порядки кредитования для тех продавцов, которые обслуживают Hoffman'а (cnum = 
2001).</p>
<p>Вот способ сделать это (вывод показан на Рисунке 10.2):</p>
<pre>            SELECT *
               FROM Orders
               WHERE snum =
                  (SELECT DISTINCT snum
                       FROM Orders
                       WHERE cnum = 2001);


               ===============  SQL Execution Log ==============
              |                                                 |
              | SELECT *                                        |
              | FROM  Orders                                    |
              | WHERE snum =                                    |
              | (SELECT DISTINCT snum                           |
              | FROM Orders                                     |
              | Where cnum = 2001);                             |
              | =============================================== |
              |   onum       amt      odate      cnum     snum  |
              |  -----   ---------  ---------   ------  ------- |
              |   3003      767.19  10/03/1990   2001     1001  |
              |   3008     4723.00  10/05/1990   2006     1001  |
              |   3011     9891.88  10/06/1990   2006     1001  |
                ================================================


  Рисунок 10.2 Использование DISTINCT для получения одного значения из подзапроса
</pre>
<p>Подзапрос установил, что значение поля snum совпало с Hoffman - 1001, а затем 
основной запрос выделил все заказы с этим значением snum из таблицы Заказов (не 
разбирая, относятся они к Hoffman или нет). Так как каждый заказчик назначен 
продавцу, мы знаем, что каждая строка в таблице Заказов с данным значением cnum 
должна иметь такое же значение snum. Однако, поскольку там может быть любое 
число таких строк, подзапрос мог бы вывести много (хотя и идентичных) значений 
snum для данного поля cnum. Аргумент DISTINCT предотвращает это. Если наш 
подзапрос возвратит более одного значения, это будет указывать на ошибку в наших 
данных - хорошая вещь для знающих об этом.<br>
Должен быть и альтернативный подход, 
чтобы ссылаться к таблице Заказчиков, а не к таблице Заказов в подзапросе. Так 
как поле cnum это первичный ключ таблицы Заказчиков, запрос, выбирающий его, 
должен выдать только одно значение. Это рационально, только если вы как 
пользователь имеете доступ к таблице Заказов, но не к таблице Заказчиков. В этом 
случае вы можете использовать решение, которое мы показали выше. (SQL имеет 
механизмы, которые определяют, кто имеет привилегии на выполнение действий в 
определённой таблице. Это будет объясняться в <a href="ch22.php">Главе 22</a>.)</p>
<p>Пожалуйста, учтите, что методика, используемая в предшествующем примере, 
применима, только когда вы знаете, что два различных поля в таблице должны 
всегда совпадать, как в нашем случае. Эта ситуация не является типичной в 
реляционных базах данных (РБД), она является исключением из правил.</p>
<h3><a name="10.4">П</a>РЕДИКАТЫ С ПОДЗАПРОСАМИ ЯВЛЯЮТСЯ НЕОБРАТИМЫМИ</h3>
<p>Вы должны обратить внимание что предикаты, включающие подзапросы, используют 
выражение</p>
<pre>            &lt;скалярная форма&gt; &lt;оператор&gt; &lt;подзапрос&gt;,</pre>
<p>а не</p>
<pre>           &lt;подзапрос&gt; &lt;оператор&gt; &lt;скалярное выражение&gt;</pre>
<p>или</p>
<pre>           &lt;подзапрос&gt; &lt;оператор&gt; &lt;подзапрос&gt;.</pre>
<p>Другими словами, вы не должны записывать предыдущий пример так:</p>
<pre>                   SELECT *
                      FROM Orders
                      WHERE (SELECT DISTINCT snum
                           FROM Orders
                           WHERE cnum = 2001)
                      = snum;</pre>
<p>В строгой ANSI-реализации это приведет к неудаче, хотя некоторые программы и 
позволяют делать такие вещи. ANSI также предохраняет  от появления в выводе 
подзапроса обоих 
значений при сравнении.</p>
<h3><a name="10.5">И</a>СПОЛЬЗОВАНИЕ АГРЕГАТНЫХ ФУНКЦИЙ В ПОДЗАПРОСАХ</h3>
<p>Тип функций, который автоматически может производить одиночное значение для 
любого числа строк, конечно же - агрегатная функция.</p>
<p>Любой запрос, использующий одиночную функцию агрегата без предложения GROUP 
BY, будет выбирать одиночное значение для использования в основном предикате. 
Например, вы хотите увидеть все заказы, имеющие сумму выше средней на 4-е 
октября (вывод показан на Рисунке 10.3):</p>
<pre>             SELECT *
                 FROM Orders
                 WHERE amt &gt;
                    (SELECT AVG (amt)
                         FROM Orders
                         WHERE odate = 10/04/1990);

               ===============  SQL Execution Log ==============
              |                                                 |
              | SELECT *                                        |
              | FROM  Orders                                    |
              | WHERE amt &gt;                                     |
              | (SELECT AVG (amt)                               |
              | FROM Orders                                     |
              | WHERE odate = 01/04/1990);                      |
              | =============================================== |
              |   onum       amt      odate      cnum     snum  |
              |  -----    --------  ----------  -----    -----  |
              |   3002     1900.10  10/03/1990   2007     1004  |
              |   3005     2345.45  10/03/1990   2003     1002  |
              |   3006     1098.19  10/03/1990   2008     1007  |
              |   3009     1713.23  10/04/1990   2002     1003  |
              |   3008     4723.00  10/05/1990   2006     1001  |
              |   3010     1309.95  10/06/1990   2004     1002  |
              |   3011     9891.88  10/06/1990   2006     1001  |
                ================================================

	Рисунок 10.3 Выбор всех сумм со значением выше среднего на 10/04/1990</pre>
<p>Средняя сумма приобретений на 4 октября - 1788.98 (1713.23 + 75.75) делится 
пополам, что в целом равняется 894.49. Все строки со значением в поле amt выше 
этого являются выбранными. Имейте в виду, что сгруппированные агрегатные функции, 
которые являются агрегатными функциями, определёнными в терминах предложения GROUP BY, могут производить многочисленные значения. Они, следовательно, 
недопустимы в подзапросах такого характера. Даже если GROUP BY и HAVING 
используются таким способом, что только одна группа выводится с помощью 
подзапроса, команда будет отклонена в принципе. Вы должны использовать одиночную 
агрегатную функцию с предложением WHERE, что устранит нежелательные группы.</p>
<p>Например, следующий запрос который должен найти среднее значение комиссионных 
продавца в Лондоне,</p>
<pre>                SELECT AVG (comm)
                    FROM Salespeople
                    GROUP BY city
                    HAVlNG city = &quot;London&quot;;</pre>
<p>не может использоваться в подзапросе! Во всяком случае, это не лучший способ 
формировать запрос.</p>
<p>Другим способом может быть</p>
<pre>                 SELECT AVG (comm)
                    FROM Salespeople
                    WHERE city = &quot;London&quot;;</pre>
<h3><a name="10.6">И</a>СПОЛЬЗОВАНИЕ ПОДЗАПРОСОВ, КОТОРЫЕ ВЫДАЮТ МНОГО СТРОК С ПОМОЩЬЮ ОПЕРАТОРА IN</h3>
<p>Вы можете использовать подзапросы, которые производят любое число строк, если 
вы применяете специальный оператор IN (операторы BETWEEN, LIKE и IS NULL не 
могут использоваться с подзапросами). Как вы помните, IN определяет набор 
значений, одно из которых должно совпадать с другим термином уравнения предиката 
в заказе, чтобы предикат был верным.<br>
Когда вы используете IN с подзапросом, SQL 
просто формирует этот набор из вывода подзапроса. Мы можем, следовательно, 
использовать IN чтобы выполнить такой  подзапрос, который не будет работать с 
реляционным оператором, и найти все атрибуты таблицы Заказов для продавца в 
Лондоне (вывод показан на Рисунке 10.4):</p>
<pre>            SELECT *
                FROM Orders
                WHERE snum IN
                     (SELECT snum
                         FROM Salespeople
                         WHERE city = &quot;LONDON&quot;);


               ===============  SQL Execution Log ==============
              |                                                 |
              | SELECT *                                        |
              | FROM  Orders                                    |
              | WHERE snum IN                                   |
              | (SELECT snum                                    |
              | FROM Salespeople                                |
              | WHERE city = 'London');                         |
              | =============================================== |
              |   onum       amt      odate      cnum     snum  |
              |  -----    --------  ----------  -----   ------  |
              |   3003      767.19  10/03/1990   2001     1001  |
              |   3002     1900.10  10/03/1990   2007     1004  |
              |   3006     1098.19  10/03/1990   2008     1007  |
              |   3008     4723.00  10/05/1990   2006     1001  |
              |   3011     9891.88  10/06/1990   2006     1001  |
                ================================================

		  Рисунок 10.4 Использование подзапроса с IN</pre>
<p>В ситуации, подобной этой, подзапрос  проще для понимания пользователем и  проще для 
выполнения компьютером,  чем если бы вы 
использовали объединение:</p>
<pre>		SELECT onum, amt, odate, cnum, Orders.snum
			FROM Orders, Salespeople
			WHERE Orders.snum = Salespeople.snum
				AND Salespeople.city = &quot;London&quot;;</pre>
<p>Хотя это и произведёт тот же самый вывод, что в примере с подзапросом, SQL 
должен будет просмотреть каждую возможную комбинацию строк из двух таблиц и 
проверить их снова по составному предикату. Проще и эффективнее извлекать из 
таблицы Продавцов значения поля snum, где city = &quot;London&quot;, а затем искать эти 
значения в таблице Заказов, как это делается в варианте с подзапросом. 
Внутренний запрос даёт нам snums=1001 и snum=1004. Внешний запрос затем даёт нам 
строки из таблицы Заказов, где эти поля snum найдены.<br>
Строго говоря, то, быстрее или нет работает вариант подзапроса, практически 
зависит от реализации - в какой программе вы это используете. Часть вашей 
программы, называемая оптимизатор, 
пытается найти наиболее эффективный способ выполнения ваших запросов. Хороший 
оптимизатор в любом случае преобразует вариант объединения в подзапрос, но нет 
достаточно простого способа, чтобы выяснить, выполнено это или нет. 
Лучше сохранить ваши запросы в памяти, нежели полагаться полностью на 
оптимизатор.<br>
Конечно, вы можете также использовать оператор IN, даже когда вы 
уверены, что подзапрос произведет одиночное значение. В любой ситуации, где вы 
можете использовать реляционный оператор сравнения (=), вы можете использовать 
IN. В отличие от реляционных операторов, IN не может заставить команду потерпеть 
неудачу, если больше чем одно значение выбрано подзапросом. Это может быть или 
преимуществом или недостатком. Вы не увидите непосредственно вывода из 
подзапросов, если вы полагаете, что подзапрос собирается произвести только одно 
значение, а он производит несколько. Вы не сможете объяснить различия в выводе 
основного запроса. Например, рассмотрим команду, которая похожа на предыдущую:</p>
<pre>              SELECT onum, amt, odate
                  FROM Orders
                  WHERE snum =
                      (SELECT  snum
                      FROM Orders
                      WHERE cnum = 2001);</pre>
<p>Вы можете устранить потребность в DISTINCT, используя IN вместо (=):</p>
<pre>              SELECT onum, amt, odate
                  FROM Orders
                  WHERE snum IN
                      (SELECT snum
                      FROM Orders
                      WHERE cnum = 2001);</pre>
<p>Что случится, если есть ошибка и один из заказов был аккредитован различным 
продавцам? Версия, использующая IN, будет выдавать вам все заказы для обоих 
продавцов. Нет никакого очевидного способа наблюдения за ошибкой, и поэтому 
сгенерированные отчеты или решения, сделанные на основе этого запроса, не будут 
содержать ошибки. Вариант, использующий (=), просто потерпит неудачу. Это, по 
крайней мере, позволило вам узнать, что имеется такая проблема. Вы должны затем 
выполнять поиск неисправности, выполнив этот подзапрос отдельно и наблюдая 
значения, которые он производит. В принципе, если вы знаете, что подзапрос должен 
(по логике) вывести только одно значение, вы должны использовать =.<br>
IN является 
подходящим, если запрос может ограниченно производить одно или более значений, 
независимо от того, ожидаете вы их или нет. Предположим, мы хотим знать 
комиссионные всех продавцов, обслуживающих заказчиков в Лондоне:</p>
<pre>           SELECT comm
              FROM Salespeople
              WHERE snum IN
                (SELECT snum
                    FROM Customers
                    WHERE city = &quot;London&quot;);</pre>
<p>Выводимыми для этого запроса, показанного в Рисунке 10.5, являются значения 
комиссионных продавца Peel (snum = 1001), который имеет обоих заказчиков в 
Лондоне. Но это только для данного случая. Нет никакой причины, чтобы некоторые 
заказчики в Лондоне не могли быть назначены кому-то ещё. Следовательно, IN - это 
наиболее логичная форма для использования в запросе.</p>
<pre>                   ===============  SQL Execution Log ==============
                  |                                                 |
                  | SELECT comm                                     |
                  | FROM  Salespeople                               |
                  | WHERE snum IN                                   |
                  | (SELECT snum                                    |
                  | FROM Customers                                  |
                  | WHERE city = 'London');                         |
                  | =============================================== |
                  |    comm                                         |
                  |  -------                                        |
                  |    0.12                                         |
                  |                                                 |
                  |                                                 |
                    ================================================


	Рисунок 10.5 Использование IN с подзапросом для вывода одного значения</pre>
<p>Между прочим, префикс таблицы для поля city в предыдущем примере не 
обязателен, несмотря на возможную неоднозначность между полями city таблицы 
Заказчика и таблицы Продавцов. SQL всегда ищет первое поле в таблице, 
обозначенной в предложении FROM текущего подзапроса. Если поле с данным именем 
там не найдено, проверяются внешние запросы. В вышеупомянутом примере, &quot;city&quot; в 
предложении WHERE означает, что имеется ссылка на Customer.city (поле city 
таблицы Заказчиков). Так как таблица Заказчиков указана в предложении FROM 
текущего запроса, SQL предполагает что это правильно. Это предположение может 
быть отменено полным именем таблицы или префиксом псевдонима, о которых мы 
поговорим позже, когда будем говорить о соотнесенных подзапросах. Если возможен 
беспорядок, конечно же, лучше всего использовать префиксы.</p>
<h4>ПОДЗАПРОСЫ ВЫБИРАЮТ ОДИНОЧНЫЕ СТОЛБЦЫ</h4>
<p>Смысл всех подзапросов, обсуждённых в этой главе, в том, что все они выбирают 
одиночный столбец. Это обязательно, поскольку полученный вывод сравнивается с 
одиночным значением. Подтверждением этому является то, что SELECT * не может 
использоваться в подзапросе. Имеется исключение из этого, когда подзапросы 
используются с оператором EXISTS, о котором мы будем говорить в
<a href="ch12.php">Главе 12</a>.</p>
<h4>ИСПОЛЬЗОВАНИЕ ВЫРАЖЕНИЙ В ПОДЗАПРОСАХ</h4>
<p>Вы можете использовать выражение, основанное на столбце, а не просто сам 
столбец, в предложении SELECT подзапроса. Это может быть выполнено или с помощью 
реляционных операторов, или с IN. Например, следующий запрос использует 
реляционный оператор = (вывод показан на Рисунке 10.6):</p>
<pre>             SELECT *
             FROM Customers
             WHERE cnum =
                 (SELECT snum + 1000
                      FROM Salespeople
                      WHERE sname = Serres);</pre>
<p>Он находит всех заказчиков, чьё значение поля cnum, равное 1000, выше поля 
snum Serres. Мы предполагаем, что столбец sname не имеет никаких двойных 
значений (это может быть предписано или UNIQUE INDEX, обсуждаемым в
<a href="ch17.php">Главе 17</a>, или ограничением UNIQUE, обсуждаемым в
<a href="ch18.php">Главе 18</a>); иначе</p>
<pre>            ===============  SQL Execution Log ============
           |                                               |
           | SELECT *                                      |
           | FROM  Customers                               |
           | WHERE cnum =                                  |
           | (SELECT snum + 1000                           |
           | WHERE Salespeople                             |
           | WHERE sname = 'Serres'                        |
           | ============================================= |
           |   cnum     cname     city    rating    snum   |
           |  -----    --------   ----    ------   -----   |
           |   2002    Giovanni   Rome       200    1003   |
             =============================================

	    Рисунок 10.6 Использование подзапроса с выражением</pre>
<p>подзапрос может произвести несколько значений. Когда поля snum и сnum не 
имеют такого простого функционального значения как, например, первичный ключ, 
что не всегда хорошо, запрос типа вышеупомянутого невероятно полезен.</p>
<h3><a name="10.7">П</a>ОДЗАПРОСЫ В ПРЕДЛОЖЕНИИ HAVING</h3>
<p>Вы можете также использовать подзапросы внутри предложения HAVING. Эти 
подзапросы могут использовать свои собственные агрегатные функции, если они не 
производят нескольких значений, или использовать GROUP BY или HAVING. 
Следующий запрос является примером этого (вывод показан на Рисунке 10.7):</p>
<pre>        SELECT rating, COUNT (DISTINCT cnum)
            FROM Customers
            GROUP BY rating
            HAVING rating &gt;
             (SELECT AVG (rating)
                  FROM Customers
                  WHERE city = &quot; San Jose');


            ===============  SQL Execution Log =============
           |                                                 |
           | SELECT rating,count (DISTINCT cnum)             |
           | FROM  Customers                                 |
           | GROUP BY rating                                 |
           | HAVING rating &gt;                                 |
           | (SELECT AVG (rating)snum + 1000                 |
           | FROM Custimers                                  |
           | WHERE city = 'San Jose');                       |
           |================================================ |
           |  rating                                         |
           | --------    --------                            |
           |   200             2                             |
            ================================================</pre>
<pre>	Рисунок 10.7 Поиск в San Jose заказчиков с оценкой выше среднего</pre>
<p>Эта команда подсчитывает заказчиков в San Jose с рейтингами выше среднего. Так 
как имеются другие оценки, отличные от 300, они должны быть выведены с числом 
номеров заказчиков, которые имели эту оценку.</p>
<h3><a name="10.8">Р</a>ЕЗЮМЕ</h3>
<p>Теперь вы используете запросы в иерархической манере. Вы видели, что 
использование результата одного запроса для управления другим расширяет 
возможности, позволяя выполнить большее количество функций.</p>
<p>Вы теперь понимаете, 
как использовать подзапросы с реляционными операциями и со специальным 
оператором IN, или в предложении WHERE, или в предложении HAVING внешнего 
запроса.</p>
<p>В следующих главах мы будем рассматривать подзапросы. Сначала, в
<a href="ch11.php">Главе 11</a>, мы обсудим другой вид подзапроса, который 
выполняется отдельно для каждой строки таблицы, вызываемой во внешнем запросе. 
Затем, в Главах <a href="ch12.php">12</a> и <a href="ch13.php">13</a>, мы 
представим вам несколько специальных операторов, которые функционируют на всех 
подзапросах, как это делает IN, за исключением случаев, когда эти операторы 
могут использоваться только в подзапросах.</p>
<h3><a name="10.9">Р</a>АБОТА СО SQL</h3>
<pre>1. Напишите запрос, который использовал бы подзапрос для получения
   всех заказов для заказчика с именем Cisneros.
   Предположим, что вы не знаете номера этого заказчика, указываемого в поле cnum.

2. Напишите запрос, который вывел бы имена и оценки всех заказчиков,
   имеющих усреднённые заказы.

3. Напишите запрос, который выбрал бы общую сумму всех приобретений
   в заказах для каждого продавца, у которого эта общая сумма больше,
   чем сумма наибольшего заказа в таблице.

(См. ответы в<a href="a.php"> Приложении A</a>.)</pre></body></html>
<? include 'foot.php' ?>