<? include 'head.php' ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html><head>
<link rel="stylesheet" href="css.css" type="text/css">
<meta http-equiv="Content-Type" content="text/html; charset=windows-1251">
<meta http-equiv="Content-Language" content="ru">
<title>Глава 14.</title></head>
<body>
<h1>Глава 14. ИСПОЛЬЗОВАНИЕ ПРЕДЛОЖЕНИЯ UNION</h1>
<hr width="50%">
<p>В предшествующих главах мы обсуждали различные способы вложения запросов 
друг в друга. Имеется другой способ объединения нескольких запросов - 
формирование их в объединение.<br>
В этой главе вы научитесь использовать 
предложение UNION в SQL. UNION отличается от подзапросов тем, что в нём ни один 
из двух (или более) запросов не управляется другим запросом. Все запросы 
выполняются независимо друг от друга, а уже вывод их объединяется.</p>
<h3><a name="14.1">О</a>БЪЕДИНЕНИЕ НЕСКОЛЬКИХ ЗАПРОСОВ В ОДИН</h3>
<p>Вы можете поместить несколько запросов вместе и объединить их вывод, 
используя предложение UNION. Предложение UNION объединяет вывод двух или более 
SQL-запросов в единый набор строк и столбцов. Например, чтобы получить всех 
продавцов и заказчиков, размещённых в Лондоне, и вывести их как единое целое, вы 
могли бы ввести:</p>
<pre>                  SELECT snum, sname
                     FROM Salespeople
                     WHERE city = 'London'

                     UNION

                  SELECT cnum, cname
                     FROM Customers
                     WHERE city = 'London';</pre>
<p>и получить вывод, показанный в Рисунке 14.1.</p>
<p>Как  видите, столбцы, выбранные двумя командами, выведены так, как 
если бы это была одна команда. Заголовки столбца исключены, потому что ни один из 
столбцов, выведённых объединением, не был извлечён непосредственно из одной 
таблицы. Следовательно, все эти столбцы вывода не имеют никаких имён (смотрите
<a href="ch7.php">Главу 7</a>, в которой&nbsp; обсуждается вывод столбцов).</p>
<p>Кроме того, обратите внимание, что только последний запрос заканчивается 
точкой с запятой.</p>
<p>Отсутствие точки с запятой дает понять SQL, что имеется ещё один или более 
запросов.</p>
<pre>                ===============  SQL Execution Log ============
               |                                               |
               | SELECT snum, sname                            |
               | FROM  Salespeople                             |
               | WHERE city = 'London'                         |
               | UNION                                         |
               | SELECT cnum, cname                            |
               | FROM Customers                                |
               | WHERE city = 'London';                        |
               | ============================================= |
               |                                               |
               |  -----    --------                            |
               |   1001    Peel                                |
               |   1004    Motika                              |
               |   2001    Hoffman                             |
               |   2006    Climens                             |
               |                                               |
                 =============================================

		Рисунок 14.1 Формирование объединения из двух запросов</pre>
<h3><a name="14.2">К</a>ОГДА ВЫ МОЖЕТЕ ДЕЛАТЬ ОБЪЕДИНЕНИЕ ЗАПРОСОВ?</h3>
<p>Когда два (или более) запроса подвергаются объединению, их столбцы вывода 
должны быть совместимы для объединения. Это означает, что каждый запрос должен 
указывать одинаковое количество столбцов и в том же порядке и каждый должен иметь тип, совместимый с каждым. Значение 
совместимости типов меняется. ANSI следит за этим очень строго, и поэтому 
числовые поля должны иметь одинаковый числовой тип и размер, хотя некоторые 
имена, используемые ANSI для этих типов, являются синонимами. (Смотрите в 
Приложении B подробности о числовых типах ANSI.) Кроме того, символьные поля 
должны иметь одинаковое количество символов (значение предназначенного числа - 
не обязательно такое же, как используемое число).</p>
<p>Хорошо, что некоторые SQL-программы обладают большей гибкостью, чем это 
определяется ANSI. Типы, не определённые ANSI, такие как DATA и BINARY, обычно 
должны совпадать с другими столбцами такого же нестандартного типа.</p>
<p>Длина строки 
также может стать проблемой. Большинство программ разрешают поля переменной 
длины, но они не обязательно будут использоваться с UNION. С другой стороны, 
некоторые программы (и ANSI тоже) требуют, чтобы символьные поля были точно 
одинаковой длины. В этих вопросах вы должны проконсультироваться с документацией 
вашей собственной программы.</p>
<p>Другое ограничение на совместимость: пустые значения (NULL) запрещены в любом 
столбце объединения, причем эти значения необходимо запретить и для всех 
соответствующих столбцов в других запросах объединения. Пустые значения (NULL) 
запрещены ограничением NOT NULL, которое будет обсуждаться в <a href="ch18.php">
Главе 18</a>. Кроме того, вы не можете использовать UNION в подзапросах, а также 
не можете использовать агрегатные функции в предложении SELECT-запроса в 
объединении. (Большинство программ пренебрегают этими ограничениями.)</p>
<h3><a name="14.3">U</a>NION И УСТРАНЕНИЕ ДУБЛИКАТОВ</h3>
<p>UNION будет автоматически исключать дубликаты строк из вывода. Это нечто, не 
свойственное SQL, так как одиночные запросы обычно содержат DISTINCT для 
устранения дубликатов.</p>
<p>Например, запрос, вывод которого показан на Рисунке 14.2,</p>
<pre>                 SELECT snum, city
                    FROM Customers;</pre>
<p>имеет двойную комбинацию значений (snum=1001, city=London), потому что мы не 
указали, чтобы SQL устранил дубликаты. Однако, если мы используем</p>
<pre>                ===============  SQL Execution Log ============
               |                                               |
               | SELECT snum, city                             |
               | FROM Customers;                               |
               | ============================================= |
               |  snum     city                                |
               |  -----    --------                            |
               |   1001    London                              |
               |   1003    Rome                                |
               |   1002    San Jose                            |
               |   1002    Berlin                              |
               |   1001    London                              |
               |   1004    Rome                                |
               |   1007    San Jose                            |
               |                                               |
                 =============================================

	    Рисунок 14.2 Одиночный запрос с дублированным выводом</pre>
<p>UNION в комбинации этого запроса с ему подобным в таблице Продавцов, то эта 
избыточная комбинация будет устранена. Рисунок 14.3&nbsp; показывает вывод следующего 
запроса.</p>
<pre>             SELECT snum, city
                FROM Customers

                UNION

             SELECT snum, city
                FROM Salespeople.;


                ===============  SQL Execution Log ============
               |                                               |
               | FROM Customers                                |
               | UNION                                         |
               | SELECT snum, sity                             |
               | FROM Salespeople;                             |
               | ============================================= |
               |                                               |
               |  -----    --------                            |
               |   1001    London                              |
               |   1002    Berlin                              |
               |   1007    San Jose                            |
               |   1007    New York                            |
               |   1003    Rome                                |
               |   1001    London                              |
               |   1003    Rome                                |
               |   1002    Barcelona                           |
               |   1007    San Jose                            |
               |                                               |
                -----------------------------------------------

		Рисунок 14.3 UNION устраняет вывод дубликатов</pre>
<p>Вы можете получить нечто похожее (в некоторых программах SQL), используя UNION 
ALL вместо просто UNION, наподобие этого:</p>
<pre>             SELECT snum, city
                FROM Customers

                UNION ALL

             SELECT snum, city
                FROM Salespeople;</pre>
<h3><a name="14.4">И</a>СПОЛЬЗОВАНИЕ СТРОК И ВЫРАЖЕНИЙ С UNION</h3>
<p>Иногда вы можете вставлять константы и выражения в предложения SELECT, 
используемые с UNION. Это не следует строго указаниям ANSI, но это полезная и 
необычно используемая возможность. Константы и выражения, используемые вами, 
должны соответствовать совместимым стандартам, как мы говорили ранее. Эта 
свойство полезно, например, чтобы устанавливать комментарии, указывающие, какой 
запрос вывел данную строку. Предположим, что вы должны сделать отчёт о том, 
какие продавцы выполняют наибольшие и наименьшие заказы по датам. Мы можем 
объединить два запроса, вставив туда текст, чтобы различать вывод  каждого из 
них.</p>
<pre>     SELECT a.snum, sname, onum, 'Highest on', odate
        FROM (Salespeople a, Orders b
        WHERE a.snum = b.snum
        AND b.amt =
          (SELECT MAX (amt)
               FROM Orders c
               WHERE c.odate = b.odate)

        UNION

     SELECT a.snum, (sname, (onum ' Lowest on', odate
        FROM (Salespeople a, Orders b
        WHERE a.snum = b.snum
        AND b.amt =
           (SELECT  MIN (amt)
                FROM Orders c
                WHERE c.odate = b.odate);</pre>
<p>Вывод этой команды&nbsp; показан на Рисунке 14.4. Мы должны были добавить 
дополнительный пробел в строку 'Lowest on', чтобы сделать её совпадающей по 
длине со строкой 'Highest on'. Обратите внимание, что Peel выбран при наличии и 
самого высокого, и самого низкого (фактически он единственный) заказов на 5 
октября. Так как вставляемые строки двух этих запросов различны, строки не будут 
устранены как дубликаты.</p>
<pre>                ===============  SQL Execution Log ============
               |                                               |
               | AND b.amt =                                   | 
               | (SELECT min (amt)                             |
               | FROM Orders c                                 |
               | WHERE c.odate = b.odate);                     |
               | ============================================= |
               |                                               |
               | -----  ------- ------  ---------- ----------- |
               |  1001  Peel     3008   Highest on  10/05/1990 |
               |  1001  Peel     3008   Lowest  on  10/05/1990 |
               |  1001  Peel     3011   Highest on  10/06/1990 |
               |  1002  Serres   3005   Highest on  10/03/1990 |
               |  1002  Serres   3007   Lowest  on  10/04/1990 |
               |  1002  Serres   3010   Lowest  on  10/06/1990 |
               |  1003  Axelrod  3009   Highest on  10/04/1990 |
               |  1007  Rifkin   3001   Lowest  on  10/03/1990 |
                ===============================================

	Рисунок 14.4 Выбор наивысших и наинизших заказов, определяемых с помощью строк</pre>
<h3><a name="14.5">И</a>СПОЛЬЗОВАНИЕ UNION С ORDER BY</h3>
<p>До сих пор мы не оговаривали, что данные нескольких запросов будут 
выводиться в каком-то особом порядке. Мы просто показывали вывод сначала из 
одного запроса, а затем из другого. Конечно, вы не можете полагаться на вывод, 
приходящий в произвольном порядке. Мы как раз сделаем так, чтобы этот способ  выполнения примеров был более простым. Вы можете использовать предложение ORDER 
BY, чтобы упорядочить вывод из объединения, точно так же, как это делается в 
индивидуальных запросах. Давайте пересмотрим наш последний пример, чтобы 
упорядочить имена с помощью их порядковых номеров. Это может внести 
противоречие, такое как повторение имени Peel в последней команде, как вы 
сможете увидеть из вывода показанного в Рисунке 14.5.</p>
<pre>SELECT a.snum, sname, onum, 'Highest on', odate
   FROM Salespeople a, Orders b
   WHERE a.snum = b.snum
   AND b.amt =
     (SELECT MAX (amt)
	  FROM Orders c
	  WHERE c.odate = b.odate)

   UNION

SELECT a.snum, sname, onum, 'Lowest on', odat
   FROM Salespeople a, Orders b
   WHEREa.snum = b.snu 
   AND b.amt =
      (SELECT MIN (amt)
	   FROM Orders c
	   WHERE c.odate = b.odate)

ORDER BY 3;

        ===============  SQL Execution Log ============
       | (SELECT min (amt)                             |
       | FROM Orders c                                 |
       | WHERE c.odate = b.odate)                      |
       | ORDER BY 3;                                   |
       | ============================================= |
       |                                               |
       | -----  ------- ------  ---------- ----------- |
       |  1007  Rifkin   3001   Lowest  on  10/03/1990 |
       |  1002  Serres   3005   Highest on  10/03/1990 |
       |  1002  Serres   3007   Lowest  on  10/04/1990 |
       |  1001  Peel     3008   Highest on  10/05/1990 |
       |  1001  Peel     3008   Lowest  on  10/05/1990 |
       |  1003  Axelrod  3009   Highest on  10/04/1990 |
       |  1002  Serres   3010   Lowest  on  10/06/1990 |
       |  1001  Peel     3011   Highest on  10/06/1990 |
	===============================================

 Рисунок 14.5 Формирование объединения с использованием ORDER BY</pre>
<p>Пока ORDER BY используется по умолчанию, мы не должны его указывать. Мы можем 
упорядочить наш вывод с помощью нескольких полей, одно внутри другого, и указать 
ASC или DESC для каждого, точно так же, как мы делали это для одиночных 
запросов. Заметьте, что номер 3 в предложении ORDER BY указывает, какой столбец 
из предложения SELECT будет упорядочен. Так как столбцы объединения это столбцы 
вывода, они не имеют имён, и, следовательно, должны определяться по номеру. Этот 
номер указывает  их место среди других столбцов вывода. (Смотрите
<a href="ch7.php">Главу 7</a>, обсуждающую столбцы вывода.)</p>
<h3><a name="14.6">В</a>НЕШНЕЕ ОБЪЕДИНЕНИЕ</h3>
<p>Операция, которая бывает часто полезна, это объединение  двух запросов, в 
котором второй запрос выбирает строки, исключённые первым. Наиболее часто вы 
будете делать это, чтобы не исключать строки, которые не удовлетворили 
предикату при объединении таблиц. Это называется внешним объединением.</p>
<p>Предположим, что некоторые из ваших заказчиков ещё не были назначены  
продавцам. Вы можете захотеть увидеть имена и города всех ваших заказчиков, с 
именами  продавцов, не учитывая тех, кто ещё не был назначен. Вы можете 
достичь этого, формируя объединение из двух запросов, один из которых выполняет 
объединение, а другой выбирает заказчиков с пустыми (NULL) значениями поля snum. 
Этот последний запрос должен вставлять пробелы в поля, соответствующие полю 
sname в первом запросе. Как и раньше, вы можете вставлять текстовые строки в ваш 
вывод чтобы идентифицировать запрос, который вывел данную строку.<br>
Использование 
этой методики во внешнем объединении дает возможность использовать предикаты для 
классификации, а не для исключения. Мы и раньше использовали пример нахождения продавцов 
с заказчиками, размещёнными в их городах. Однако, вместо просто выбора 
только этих строк, вы, возможно, захотите, чтобы ваш вывод перечислял всех 
продавцов и указывал тех, кто не имел заказчиков в их городах, и кто имел. 
Следующий запрос, чей вывод показан на Рисунке 14.6, выполнит это:</p>
<pre>     SELECT Salespeople.snum, sname, cname, comm
	FROM Salespeople, Customers
	WHERE Salespeople.city = Customers.city.

	UNION

     SELECT snum, sname, ' NO MATCH ', comm
	FROM Salespeople
	WHERE NOT city = ANY
	   (SELECT city
		FROM Customers)

	ORDER BY 2 DESC;


	===============  SQL Execution Log ============
       |                                               |
       | FROM Salespeople                              |
       | WHERE NOT city = ANYate)                      |
       | (SELECT city                                  |
       | FROM Customers)                               |
       | ORDER BY 2 DESC;                              |
       | ============================================= |
       |                                               |
       | -----  -------  ---------     ------------    |
       |  1002  Serres   Cisneros           0.1300     |
       |  1002  Serres   Liu                0.1300     |
       |  1007  Rifkin   NO MATCH           0.1500     |
       |  1001  Peel     Clemens            0.1200     |
       |  1001  Peel     Hoffman            0.1200     |
       |  1004  Motika   Clemens            0.1100     |
       |  1004  Motika   Hoffman            0.1100     |
       |  1003  Axelrod  NO MATCH           0.1000     |
       |                                               |
	===============================================

		Рисунок 14.6 Внешнее объединение</pre>
<p>Строка ' NO MATCH ' была дополнена пробелами, чтобы получить совпадение поля 
cname по длине (не во всех реализациях SQL). Второй запрос выбирает даже те 
строки, которые исключил первый. Вы можете также добавить комментарий или 
выражение в ваш запрос в виде дополнительного поля. Если вы сделаете это, вы 
должны будете добавить некоторый дополнительный комментарий или выражение в той 
же самой позиции среди выбранных полей для каждого запроса в операции 
объединения. Совмещение UNION предотвращает добавление дополнительного поля 
для первого запроса, но не для второго. Вот запрос, который добавляет строки 
к выбранным полям и указывает, совпадает ли данный продавец с его заказчиком в 
его городе:</p>
<pre>  SELECT a.snum, sname, a.city, ' MATCHED '
     FROM Salespeople a, Customers b
     WHERE a.city = b.city

     UNION

  SELECT snum, sname, city, 'NO MATCH'
     FROM Salespeople 
     WHERE NOT city = ANY
	(SELECT city
	    FROM Customers)

     ORDER BY 2 DESC;</pre>
<p>Рисунок 14.7&nbsp; показывает вывод этого запроса.</p>
<pre>	===============  SQL Execution Log ============
       |                                               |
       | WHERE a.city = b.city                         |
       | UNION                                         |
       | SELECT snum,sname,city, 'NO MATCH'            |
       | FROM Salespeople                              |
       | WHERE NOT city = ANYate)                      |
       | (SELECT city                                  |
       | FROM Customers)                               |
       | ORDER BY 2 DESC;                              |
       | ============================================= |
       |                                               |
       | -----  -------   ------------  ---------      |
       |  1002  Serres     San Jose     MATCHED        |
       |  1007  Rifkin     Barselona    NO MATCH       |
       |  1001  Peel       London       MATCHED        |
       |  1004  Motika     London       MATCHED        |
       |  1003  Axelrod    New York     NO MATCH       |
       |                                               |
	===============================================

     Рисунок 14.7 Внешнее объединение с полем комментария</pre>
<p>Это неполное внешнее объединение, так как оно включает только несовпадающие 
поля одной из объединяемых таблиц. Полное внешнее объединение должно включать 
всех заказчиков, имеющих и не имеющих продавцов в их городах. Такое условие 
будет более полным, как вы это сможете увидеть (вывод следующего запроса показан 
на Рисунке 14,8):</p>
<pre>SELECT snum, city, 'SALESPERSON - MATCH'
 FROM Salespeople
 WHERE NOT city = ANY
   (SELECT city
	FROM Customers)

 UNION


SELECT snum, city, 'SALESPERSON - NO MATCH'
 FROM Salespeople
 WHERE NOT city = ANY
   (SELECT city
	FROM Customers))

 UNION

(SELECT cnum, city, 'CUSTOMER - MATCHED'
 FROM Customers
 WHERE city = ANY
    (SELECT city
	 FROM Salespeople)

 UNION

SELECT cnum, city, 'CUSTOMER - NO MATCH'
 FROM Customers
 WHERE NOT city = ANY
   (SELECT city
       FROM Salespeople))

 ORDER BY 2 DESC;


   ===============  SQL Execution Log ===============
  |                                                  |
  | FROM  Salespeople)                               |
  | ORDER BY 2 DESC;                                 |
  |                                                  |
  | ================================================ |
  |                                                  |
  |  ----   --------     ------------------------    |
  |  2003   San Jose     CUSTOMER     -   MATCHED    |
  |  2008   San Jose     CUSTOMER     -   MATCHED    |
  |  2002   Rome         CUSTOMER     -   NO MATCH   |
  |  2007   Rome         CUSTOMER     -   NO MATCH   |
  |  1003   New York     SALESPERSON  -   MATCHED    |
  |  1003   New York     SALESPERSON  -   NO MATCH   |
  |  2001   London       CUSTOMER     -   MATCHED    |
  |  2006   London       CUSTOMER     -   MATCHED    |
  |  2004   Berlin       CUSTOMER     -   NO MATCH   |
  |  1007   Barcelona    SALESPERSON  -   MATCHED    |
  |  1007   Barcelona    SALESPERSON  -   NO MATCH   |
  |                                                  |
   ==================================================

	Рисунок 14.8 Полное внешнее объединение</pre>
<p>(Понятно, что эта формула, использующая ANY, эквивалентна объединению в 
предыдущем примере.) Сокращённое внешнее объединение, с которого мы начинали, 
используется чаще, чем  последний пример. Этот пример, однако, имеет другой 
смысл. Всякий раз, когда вы выполняете объединение более чем двух запросов, вы 
можете использовать круглые скобки, чтобы определить порядок оценки. Другими 
словами, вместо</p>
<pre>    query X UNION query Y UNION query Z;</pre>
<p>вы должны указать, или</p>
<pre>   (query X UNION query Y)UNION query Z;</pre>
<p>или</p>
<pre>    query X UNION (query Y UNION query Z);</pre>
<p>Это потому, что UNION и UNION ALL могут быть скомбинированы, чтобы удалять 
одни дубликаты, не удаляя другие.</p>
<p>Предложение</p>
<pre>   (query X UNION ALL query Y)UNION query Z;</pre>
<p>не обязательно воспроизведёт те же результаты, что и предложение</p>
<pre>    query X UNION ALL(query Y UNION query Z);</pre>
<p>если дублирующие строки в нём, будут удалены.</p>
<h3><a name="14.7">Р</a>ЕЗЮМЕ</h3>
<p>Теперь вы знаете, как использовать предложение UNION, которое даёт 
возможность объединять любое число запросов в единое тело вывода. Если вы имеете 
ряд подобных таблиц - таблиц, содержащих похожую информацию, но принадлежащих 
разным пользователям и охватывающих различные особенности, - возможно, что 
объединение сможет обеспечить простой способ для слияния и упорядочивания 
вывода. Аналогично внешние объединения дают вам новый способ использования 
условий не для исключения вывода, а для его маркировки или обработки его частей, 
когда встречается условие, отличающееся от того, которое не выполняется.</p>
<p>Этим 
заканчиваются наши главы о запросах. Вы теперь имеете довольно полное 
представление о поиске данных в SQL. Следующий шаг - изучение того, как значения 
вводятся в таблицы и как таблицы создаются &quot;с нуля&quot;. Как вы увидите, запросы 
иногда используются внутри других типов команд так же хорошо, как и сами по 
себе.</p>
<h3><a name="14.8">Р</a>АБОТА СО SQL</h3>
<pre>1. Создайте объединение из двух запросов, которое показало бы имена,
   города и оценки всех заказчиков. Те из них, которые имеют поле
   rating=200 и более, должны, кроме того, иметь слова - &quot;Высокий
   Рейтинг&quot;, а остальные должны иметь слова &quot;Низкий Рейтинг&quot;.

2. Напишите команду, которая вывела бы имена и номера каждого продавца и
   каждого заказчика, которые имеют больше чем один текущий
   заказ. Результат представьте в алфавитном порядке.

3. Сформируйте объединение из трех запросов. Первый выбирает поля
   snum всех продавцов в San Jose; второй, поля cnum всех заказчиков в
   San Jose; и третий - поля onum всех заказов на 3 октября.
   Сохраните дубликаты между последними двумя запросами, но
   устраните любую избыточность вывода между каждым из них и самым первым.

 (Примечание: в данных типовых таблицах не содержится никакой избыточности.
  Это только пример.)

(См. ответы в <a href="a.php">Приложении A</a>.)</pre></body></html>
<? include 'foot.php' ?>