<? include 'head.php' ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html><head>
<link rel="stylesheet" href="css.css" type="text/css">
<meta http-equiv="Content-Type" content="text/html; charset=windows-1251">
<meta http-equiv="Content-Language" content="ru">
<title>Глава 20.</title></head>
<body>
<h1>Глава 20. ПРЕДСТАВЛЕНИЕ. ВВЕДЕНИЕ.</h1>
<hr width="50%">
<p>ПРЕДСТАВЛЕНИЕ (VIEW) (я называю его также &quot;просмотр&quot; - <i>прим. ред.) </i>это 
объект данных, который не содержит никаких данных его владельца. Это тип 
таблицы, чьё содержание выбирается из других таблиц с помощью выполнения 
запроса. По мере изменения значений в  таблицах, эти изменения автоматически 
отражаются представлением.</p>
<p>В этой главе вы узнаете, что такое представления, как они создаются, и немного 
о их возможностях и ограничениях. Использование представлений, основанных на 
улучшенных средствах запросов, таких как объединение и подзапрос, разработанных 
очень тщательно, в некоторых случаях даст больший выигрыш по сравнению с запросами.</p>
<h3><a name="20.1">Ч</a>ТО ТАКОЕ ПРЕДСТАВЛЕНИЕ?</h3>
<p>Таблицы, с которыми вы имели дело до сих пор, назывались базовыми таблицами. 
Это таблицы, которые содержат данные. Однако имеется другой вид таблиц - 
представления. Представления это таблицы, чьё содержание выбирается или 
получается из других таблиц. Они работают в запросах и операторах DML точно так 
же, как и основные таблицы, но не содержат никаких собственных данных.</p>
<p>Представления подобны окнам, через которые вы просматриваете информацию (как 
она есть, или в другой форме, как вы потом увидите), которая реально хранится в 
базовой таблице. Представление это фактически запрос, который выполняется всякий 
раз, когда представление становится темой команды. Вывод запроса при этом в 
каждый момент становится содержанием представления.</p>
<h3><a name="20.2">К</a>ОМАНДА CREATE VIEW</h3>
<p>Вы создаёте представление командой CREATE VIEW. Она состоит из слов CREATE 
VIEW (СОЗДАТЬ ПРЕДСТАВЛЕНИЕ), имени представления, которое нужно создать, сл&#x0301;ова AS (КАК) и запроса, как в следующем примере:</p>
<pre>       CREATE VIEW Londonstaff
          AS SELECT *
          FROM Salespeople
          WHERE city = 'London';</pre>
<p>Теперь у вас есть представление Londonstaff. Вы можете 
использовать это представление точно так же, как и любую другую таблицу. Может 
быть выполнен запрос, модификация, вставка в, удаление из и соединение с другими 
таблицами и представлениями.</p>
<p>Давайте сделаем запрос  представления (вывод 
показан на Рисунке 20.1):</p>
<pre>            SELECT *
               FROM Londonstaff;


         ===============  SQL Execution Log ============
        |                                               |
        | SELECT *                                      |
        | FROM  Londonstaff;                            |
        |                                               |
        | ==============================================|
        |   snum      sname         city         comm   |
        | ------    ----------   -----------   -------  |
        |   1001      Peel         London       0.1200  |
        |   1004      Motika       London       0.1100  |
        |                                               |
         ===============================================

	     Рисунок 20.1 Представление Londonstaff</pre>
<p>Когда вы приказываете SQL выбрать (SELECT) все строки (*) из представления, 
он выполняет запрос, содержащий в определении Loncfonstaff,&nbsp; и возвращает всё из 
его вывода. Имея предикат в запросе представления, можно вывести только те 
строки представления, которые будут удовлетворять этому предикату. Вы можете вспомнить, что в <a href="ch15.php">Главе 15</a> вы имели таблицу Londonstaff, в которую вы вставляли это же самое содержимое (конечно, мы 
понимаем, что таблица не слишком велика. Если это так, вы должны будете выбрать 
другое имя для вашего представления).</p>
<p>Преимущество использования представления, 
по сравнению с основной таблицей, в том, что представление будет модифицировано 
автоматически всякий раз, когда изменится таблица, лежащая в его основе.</p>
<p>Содержание представления не фиксировано и переназначается каждый раз, когда 
вы ссылаетесь на представление в команде. Если вы добавите завтра другого 
живущего в Лондоне продавца, он автоматически появится в представлении.</p>
<p>Представления значительно расширяют управление вашими данными. Это 
превосходный способ дать публичный доступ к некоторой, но не всей, информации в 
таблице. Если вы хотите, чтобы ваш продавец был показан в таблице Продавцов, но 
при этом не были показаны комиссионные других продавцов, вы могли бы создать 
представление с использованием следующего оператора (вывод показан на Рисунке 
20.2):</p>
<pre>       CREATE VIEW Salesown
          AS SELECT snum, sname, city
          FROM Salespeople:

             ===============  SQL Execution Log ============
            |                                               |
            | SELECT *                                      |
            | FROM  Salesown;                               |
            |                                               |
            | ==============================================|
            |   snum      sname         city                |
            | ------    ----------   -----------            |
            |   1001      Peel         London               |
            |   1002      Serres       San Jose             |
            |   1004      Motika       London               |
            |   1007      Rifkin       Barcelona            |
            |   1003      Axelrod      New York             |
             ===============================================

		 Рисунок 20.2 Представление Salesown</pre>
<p>Другими словами, это представление - такое же, как для таблицы Продавцов, за 
исключением того что поле comm не упоминалось в запросе и, следовательно, не 
было включено в представление.</p>
<h3><a name="20.3">М</a>ОДИФИЦИРОВАНИЕ ПРЕДСТАВЛЕНИЙ</h3>
<p>Представление может теперь изменяться командами модификации DML, но 
модификация не будет воздействовать на само представление. Команды будут на 
самом деле перенаправлены в базовую таблицу:</p>
<pre>         UPDATE Salesown
            SET city = 'Palo Alto'
            WHERE snum = 1004;</pre>
<p>Его действие идентично выполнению той же команды в таблице Продавцов. Однако, 
если значение комиссионных продавца будет обработано командой UPDATE</p>
<pre>         UPDATE Salesown
            SET comm = .20
            WHERE snum = 1004;</pre>
<p>она будет отвергнута, так как поле comm отсутствует в представлении Salesown. 
Это важное замечание, показывающее, что не все представления могут быть 
модифицированы. Мы будем исследовать проблемы модификации представлений в
<a href="ch21.php%22">Главе 21</a>.</p>
<h3><a name="20.4">И</a>МЕНОВАНИЕ СТОЛБЦОВ</h3>
<p>В нашем примере поля наших представлений имеют свои имена, полученные прямо 
из имён полей основной таблицы. Это удобно. Однако  вам нужно снабдить 
ваши столбцы новыми именами:</p>
<ul><li>когда некоторые столбцы являются выводимыми, и поэтому не имеющими имен.</li>
<li>когда два или более столбцов в объединении имеют те же имена, что в их базовой таблице.</li></ul>
<p>Имена, которые могут стать именами полей, даются в круглых скобках () после 
имени таблицы. Они не будут запрошены, если совпадают с именами полей 
запрашиваемой таблицы. Тип данных и размер этих полей будут отличаться от 
запрашиваемых полей, которые &quot;передаются&quot; в них. Обычно вы не указываете новых 
имен полей, но если вы всё-таки сделали это, вы должны делать это для каждого 
поля в представлении.</p>
<h3><a name="20.5">К</a>ОМБИНИРОВАНИЕ ПРЕДИКАТОВ ПРЕДСТАВЛЕНИЙ И ОСНОВНЫХ ЗАПРОСОВ В ПРЕДСТАВЛЕНИЯХ</h3>
<p>Когда вы делаете запрос представления, вы, собственно, выполняете запрос. 
Основной способ для SQL обойти это - объединить предикаты двух запросов в один. 
Давайте посмотрим ещё раз на наше представление Londonstaff:</p>
<pre>         CREATE VIEW Londonstaff
            AS SELECT *
            FROM Salespeople
            WHERE city = 'London';</pre>
<p>Если мы выполняем следующий запрос в этом представлении</p>
<pre>         SELECT *
           FROM Londonstaff
           WHERE comm &gt; .12;</pre>
<p>он будет такой же, как если бы мы выполнили следующее в таблице Продавцов:</p>
<pre>       SELECT *
          FROM Salespeople
          WHERE city = 'London'
          AND comm &gt; .12;</pre>
<p>Это прекрасно, за исключением того что появляется возможная проблема с 
представлением. Имеется возможность комбинации из двух полностью допустимых 
предикатов и получения предиката, который не будет работать. Например, 
предположим, что мы создаем (CREATE) следующее представление:</p>
<pre>       CREATE VIEW Ratingcount (rating, number)
          AS SELECT rating, COUNT (*)
          FROM Customers
          GROUP BY rating;</pre>
<p>Это даёт нам число заказчиков, которое мы имеем для каждого уровня оценки 
(rating). Вы можете затем сделать запрос этого представления, чтобы выяснить, 
имеется ли какая-нибудь оценка в настоящее время, назначенная для трёх 
заказчиков:</p>
<pre>       SELECT *
          FROM Ratingcount
          WHERE number = 3;</pre>
<p>Посмотрим, что случится если мы скомбинируем два предиката:</p>
<pre>       SELECT rating, COUNT (*)
          FROM Customers
          WHERE COUNT (*) = 3
          GROUP BY rating;</pre>
<p>Это недопустимый запрос. Агрегатные функции, такие как COUNT (СЧЕТ), не могут 
использоваться в предикате. Правильным способом при формировании вышеупомянутого 
запроса, конечно же, будет следующий:</p>
<pre>        SELECT rating, COUNT (*)
           FROM Customers
           GROUP BY rating;
           HAVING COUNT (*) = 3;</pre>
<p>Но SQL может не выполнить превращения. Может ли равноценный запрос вместо 
запроса Ratingcount потерпеть неудачу? Да может! Это неоднозначная область SQL, 
где методика использования представлений может дать хорошие результаты. Самое 
лучшее, что можно сделать в случае, когда об этом ничего не сказано в вашей 
системной документации, это попытаться  разобраться.</p>
<p>Если команда 
допустима, вы можете использовать представления, чтобы установить некоторые 
ограничения SQL в синтаксисе запроса.</p>
<h3><a name="20.6">Г</a>РУППОВЫЕ ПРЕДСТАВЛЕНИЯ</h3>
<p>Групповые представления это представления, наподобие запроса Ratingcount в 
предыдущем примере, которые содержат предложение GROUP BY или которые 
основываются на других групповых представлениях.</p>
<p>Групповые представления могут стать превосходным способом непрерывной обработки 
полученной информации. Предположим, что каждый день вы должны следить 
за порядком номеров заказчиков, номерами продавцов принимающих заказы, номерами 
заказов, средним количеством заказов и общей суммой приобретений в заказах.</p>
<p>Чем конструировать каждый раз сложный запрос, вы можете просто создать 
следующее представление:</p>
<pre>   CREATE VIEW Totalforday
        AS SELECT odate, COUNT (DISTINCT cnum), COUNT
                (DISTINCT snum), COUNT (onum), AVG
                (amt), SUM (amt)
                FROM Orders
        GROUP BY odate;</pre>
<p>Теперь вы сможете увидеть всю эту информацию с помощью простого запроса:</p>
<pre>         SELECT *
            FROM Totalforday;</pre>
<p>Как мы видели, SQL-запросы могут дать вам полный комплекс возможностей, так 
что представления обеспечивают вас чрезвычайно гибким и мощным инструментом 
чтобы определить точно, как ваши данные могут быть использованы.</p>
<p>Они могут также делать вашу работу более простой, переформатируя данные 
удобным для вас способом и исключив двойную работу.</p>
<h3><a name="20.7">П</a>РЕДСТАВЛЕНИЯ И ОБЪЕДИНЕНИЯ</h3>
<p>Представления не требуют, чтобы их вывод осуществлялся из одной базовой 
таблицы. Так как почти любой допустимый запрос SQL может быть использован в 
представлении, оно может выводить информацию из любого числа базовых таблиц или 
из других представлений. Мы можем, например, создать представление, которое 
показывало бы заказы продавца и заказчика по имени:</p>
<pre>       CREATE VIEW Nameorders
          AS SELECT onum, amt, a.snum, sname, cname
             FROM Orders a, Customers b, Salespeople c
             WHERE a.cnum = b.cnum
               AND a.snum = c.snum;</pre>
<p>Теперь вы можете выбрать (SELECT) все заказы заказчика или продавца (*), или 
можете увидеть эту информацию для любого заказа.</p>
<p>Например, чтобы увидеть все заказы продавца Rifkin, вы должны ввести 
следующий запрос (вывод показан на Рисунке 20.3):</p>
<pre>          SELECT *
             FROM Nameorders
             WHERE sname = 'Rifkin';


            ===============  SQL Execution Log ==============
           |                                                 |
           | SELECT *                                        |
           | FROM  Nameorders                                |
           | WHERE sname = 'Rifkin';                         |
           | =============================================== |
           |   onum       amt       snum   sname     cname   |
           |  ------   --------    -----  -------   -------  |
           |   3001       18.69     1007  Rifkin    Cisneros |
           |   3006     1098.16     1007  Rifkin    Cisneros |
           |                                                 |
             ================================================

	  Рисунок 20.3 Заказы Rifkin, показанные в Nameorders</pre>
<p>Вы можете также объединять представления с другими таблицами,  базовыми 
таблицами или представлениями, поэтому вы можете увидеть все заказы продавца Axelrod и значения его комиссионных в каждом порядке:</p>
<pre>           SELECT a.sname, cname, amt  comm
              FROM Nameorders a, Salespeople b
              WHERE a.sname = 'Axelrod'
                AND b.snum = a.snum;</pre>
<p>Вывод для этого запроса показан на Рисунке 20.4. В предикате мы могли бы 
написать: &quot;WHERE a.sname = 'Axelrod' AND b.sname = 'Axelrod'&quot;, но предикат, 
который мы использовали здесь, более общеупотребителен. Кроме того, поле snum 
это первичный ключ таблицы Продавцов, и, следовательно, должно, по определению, 
быть уникальным.</p>
<pre>            ===============  SQL Execution Log ==============
           |                                                 |
           | SELECT a.sname, cname, amt * comm               |
           | FROM  Nameorders a, Salespeople b               |
           | WHERE a.sname = 'Axelrod'                       |
           | AND b.snum = a.snum;                            |
           | =============================================== |
           |   onum       amt       snum   sname     cname   |
           |  ------   --------    -----  -------   -------  |
           |   3001       18.69     1007  Rifkin    Cisneros |
           |   3006     1098.16     1007  Rifkin    Cisneros |
           |                                                 |
             ================================================

	Рисунок 20.4 Объединение основной таблицы с представлением</pre>
<p>Если бы там, например, было два Axelrod, вариант с именем будет объединять 
вместе их данные. Более предпочтительный вариант - использовать поле snum, чтобы 
хранить его отдельно.</p>
<h3><a name="20.8">П</a>РЕДСТАВЛЕНИЯ И ПОДЗАПРОСЫ</h3>
<p>Представления могут также использовать и подзапросы, включая соотнесённые 
подзапросы. Предположим, ваша компания предусматривает премию для тех продавцов, 
которые имеют заказчика с самым высоким заказом для любой указанной даты. Вы 
можете проследить эту информацию с помощью представления:</p>
<pre>           CREATE VIEW Elitesalesforce
              AS SELECT b.odate, a.snum, a.sname,
                 FROM Salespeople a, Orders b
                 WHERE a.snum = b.snum
                   AND b.amt =
                     (SELECT MAX (amt)
                         FROM Orders c
                         WHERE c.odate = b.odate);</pre>
<p>Если, с другой стороны, премия будет назначаться только продавцу, который 
имел самый высокий заказ за последние десять лет, вам необходимо будет 
проследить их в другом представлении, основанном на первом:</p>
<pre>            CREATE VIEW Bonus
               AS SELECT DISTINCT snum, sname
                  FROM Elitesalesforce a
                  WHERE 10 &lt; =
                     (SELECT COUNT (*)
                         FROM Elitesalestorce b
                         WHERE a.snum = b.snum);</pre>
<p>Извлечение из этой таблицы продавца, который будет получать премию, 
выполняется простым запросом:</p>
<pre>               SELECT *
                  FROM Bonus;</pre>
<p>Теперь мы видим истинную мощность SQL. Извлечение той же полученной 
информации программами RPG или COBOL будет более длительной процедурой. В SQL 
это - только вопрос из двух комплексных команд, сохранённых как представление 
совместно с простым запросом. При самостоятельном запросе мы должны заботится об 
этом каждый день, потому что информация которую извлекает запрос, непрерывно 
меняется, чтобы отражать текущее состояние базы данных.</p>
<h3><a name="20.9">Ч</a>ТО НЕ МОГУТ ДЕЛАТЬ ПРЕДСТАВЛЕНИЯ?</h3>
<p>Имеется большое количество типов представлений (включая многие из наших 
примеров в этой главе), которые являются доступными только для чтения. Это 
означает, что их можно запрашивать, но они не могут подвергаться действиям 
команд модификации. (Мы будем рассматривать эту тему в <a href="ch21.php">Главе 
21</a>.) Имеются также некоторые виды запросов, которые недопустимы в 
определениях представлений.</p>
<p>Одиночное представление должно основываться на одиночном запросе.</p>
<p>ОБЪЕДИНИТЬ (UNION) и ОБЪЕДИНИТЬ ВСЁ (UNION ALL) не 
разрешаются.</p>
<p>УПОРЯДОЧИТЬ ПО (ORDER BY) никогда не используется в определении 
представлений.</p>
<p>Вывод запроса формирует содержание представления, которое 
напоминает базовую таблицу и является - по определению - неупорядоченным.</p>
<h3><a name="20.10">У</a>ДАЛЕНИЕ ПРЕДСТАВЛЕНИЙ</h3>
<p>Синтаксис удаления представления из базы данных подобен синтаксису удаления 
базовых таблиц:</p>
<pre>DROP VIEW &lt;имя представления&gt;</pre>
<p>В этом нет необходимости, потому что содержимое представления не является 
созданным и сохраняется на период действия определенной команды. Базовая таблица, из 
которой представление выводится, не задействуется, когда представление удалено. 
Помните, вы должны являться владельцем представления, чтобы иметь возможность удалить его.</p>
<h3><a name="20.11">Р</a>ЕЗЮМЕ</h3>
<p>Теперь, когда вы можете использовать представления, ваша способность 
отслеживать и обрабатывать содержание  БД значительно расширилась. Всё, что вы можете создать запросом, вы всегда сможете определить как 
представление. Запросы этих представлений это, фактически, запрос запроса. 
Использование представлений и для удобства, и для защиты также удобно, как и 
многие возможности представлений для форматирования и получения значений из 
постоянно меняющегося содержания вашей БД.</p>
<p>Имеется один главный вывод 
относительно представлений: это способность к модификации.</p>
<p>Как показано, вы можете модифицировать представления так же, как и базовую 
таблицу, с помощью изменений, применяемых к таблице, из которой получается 
представление, но это не всегда возможно.</p>
<h3><a name="20.12">Р</a>АБОТА СО SQL</h3>
<pre>1. Создайте представление, которое показывало бы всех заказчиков, имеющих
   самые высокие рейтинги.

2. Создайте представление, которое показывало бы номер продавца в каждом городе.

3. Создайте представление, которое показывало бы усреднённый и общий заказы для каждого
   продавца после его имени. Предполагается, что все имена уникальны.

4. Создайте представление, которое показывало бы каждого продавца с несколькими заказчиками.

(См. ответы в <a href="a.php#20">Приложении A</a>.)</pre></body></html>
<? include 'foot.php' ?>