<? include 'head.php' ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html><head>
<link rel="stylesheet" href="css.css" type="text/css">
<meta http-equiv="Content-Type" content="text/html; charset=windows-1251">
<meta http-equiv="Content-Language" content="ru">
<title>Глава 3.</title></head>
<body>
<h1>Глава 3. ИСПОЛЬЗОВАНИЕ SQL ДЛЯ ИЗВЛЕЧЕНИЯ ИНФОРМАЦИИ ИЗ ТАБЛИЦ</h1>
<hr width="50%">
<p>В этой главе мы покажем вам, как извлекать информацию из таблиц. Вы узнаете, 
как пропускать или переупорядочивать столбцы и как автоматически устранять 
избыточность данных в вашем выводе. В заключение вы узнаете, как устанавливать 
условие (проверку), которую вы можете использовать, чтобы определить, какие строки 
таблицы используются в выводе. Эта последняя особенность будет далее описана в 
более поздних главах и является одной из наиболее изящных и мощных в SQL.</p>
<a name="3.1"></a>
<h3>СОЗДАНИЕ ЗАПРОСА</h3>
<p>Как мы говорили ранее, SQL это Структурированный Язык 
Запросов. Запросы, вероятно, наиболее часто используемый аспект SQL. Фактически 
маловероятно, для категории SQL-пользователей, чтобы этот 
язык использовался для чего-то другого. По этой причине мы будем начинать наше обсуждение SQL 
с обсуждения запроса и того, как он выполняется на этом языке.</p>
<h5>ЧТО ТАКОЕ ЗАПРОС?</h5>
<p>Запрос это команда, которую вы даёте вашей программе базы данных и которая 
сообщает ей, что нужно вывести определённую информацию из таблиц в память. Эта 
информация обычно посылается непосредственно на экран компьютера или терминала, 
которым вы пользуетесь, хотя в большинстве случаев её можно также послать 
на принтер, сохранить в файле (как объект в памяти компьютера) или предоставить 
как вводную информацию для другой команды или процесса.</p>
<a name="3.2"></a>
<h3>ГДЕ ПРИМЕНЯЮТСЯ ЗАПРОСЫ?</h3>
<p>Запросы обычно рассматриваются как часть языка DML. Однако, так как запрос не 
меняет информацию в таблицах, а просто показывает её пользователю, мы будем 
рассматривать запросы как самостоятельную категорию среди команд DML, которые 
производят действия, а не просто показывают содержание базы данных (БД).</p>
<p>Любой запрос SQL имеет в своём составе одну команду. Структура этой команды 
обманчиво проста, потому что вы можете расширять её так, чтобы выполнить  сложные оценки и обработку 
данных. Эта команда называется SELECT (ВЫБРАТЬ).</p>
<a name="3.3"></a>
<h3>КОМАНДА SELECT</h3>
<p>В самой простой форме команда SELECT просто инструктирует БД, чтобы 
извлечь информацию из таблицы. Например, вы могли бы вывести таблицу Продавцов, 
напечатав следующее:</p>
<pre>       SELECT snum, sname, city, comm
          FROM  Salespeople;</pre>
<p>Вывод для этого запроса показан на Рисунке 3.1.</p>
<pre>           ===============  SQL Execution Log ============
          |                                               |
          | SELECT snum, sname, city, comm                |
          | FROM  Salespeople;                            |
          |                                               |
          | ==============================================|
          |   snum      sname        city          comm   |
          | ------    ----------   -----------   -------  |
          |   1001      Peel         London        0.12   |
          |   1002      Serres       San Jose      0.13   |
          |   1004      Motika       London        0.11   |
          |   1007      Rifkin       Barcelona     0.15   |
          |   1003      Axelrod      New York      0.10   |
           ===============================================

		   Рисунок 3.1 Команда SELECT</pre>
<p>Другими словами, эта команда просто выводит все данные из таблицы. 
Большинство программ будут также давать заголовки столбца, как выше, а некоторые 
позволяют определить детальное форматирование вывода, но это уже вне стандартной 
спецификации.</p>
<p>Вот объяснение каждой части этой команды:</p>
<dl>
<dt>SELECT</dt>
<dd>Ключевое слово, которое сообщает базе данных, что эта команда - запрос. Все запросы начинаются этим словом с последующим пробелом.</dd>
<dt>snum, sname</dt>
<dd>Это список столбцов из таблицы, которые выбираются запросом. Любые столбцы, не перечисленные здесь, не будут включены в вывод команды. Это, 
конечно, не значит, что они будут удалены или их информация будет стёрта из 
таблиц, ведь запрос не воздействует на информацию в таблицах; он только показывает данные.</dd>
<dt>FROM Salespeople</dt>
<dd>FROM - ключевое слово, подобное SELECT, которое должно быть представлено в каждом запросе. Оно сопровождается пробелом и  именем таблицы, 
используемой в качестве источника информации. В данном случае это таблица Продавцов (Salespeople).</dd>
<dt>;</dt>
<dd>Точка с запятой используется во всех интерактивных командах SQL, чтобы сообщать базе данных, что команда записана и готова к выполнению. В некоторых 
системах индикатором конца команды является обратный слэш (\) в строке.</dd></dl>
<p>Естественно, запрос такого характера не обязательно будет упорядочивать вывод любым указанным способом. Та же самая команда, выполненная с теми же самыми 
данными, но в другое время, не сможет вывести тот же самый заказ. Обычно строки обнаруживаются в том порядке, в котором они найдены в таблице, поскольку, как мы 
установили в предыдущей главе, этот порядок произволен. Это не обязательно будет тот порядок, в котором данные вводились или сохранялись. Вы можете упорядочивать 
вывод непосредственно командами SQL с помощью специального предложения. Позже мы покажем, как это делается. А сейчас просто 
запомните, что, в отсутствие 
явного упорядочивания, в вашем выводе нет никакого определенного порядка.</p><p>
Использование возврата каретки (клавиша ENTER) является произвольным. Мы 
должны точно установить, как удобнее составить запрос - в несколько строк или в одну строку 
- следующим образом:</p>
<pre>      SELECT snum, sname, city, comm FROM Salespeople;</pre>
<p>С тех пор как SQL использует точку с запятой, чтобы указывать конец команды, 
большинство программ SQL обрабатывают возврат каретки (через нажатие Возврат или клавиши ENTER ) как пробел. 
Хорошая идея - использовать возвраты каретки и выравнивание, как мы делали  ранее, чтобы сделать ваши команды более лёгкими для чтения и более 
понятными.</p>
<a name="3.4"></a>
<h3>ВЫБИРАЙТЕ ВСЕГДА САМЫЙ ПРОСТОЙ СПОСОБ</h3>
<p>Если вы хотите видеть все столбцы таблицы, имеется необязательное сокращение, которое вы можете использовать. Звёздочка (*) может применяться для 
вывода полного списка столбцов следующим образом:</p>
<pre>      SELECT *
      FROM Salespeople;</pre>
<p>Это приведет к тому же результату, что и наша предыдущая команда.</p>
<a name="3.5"></a>
<h3>ОПИСАНИЕ SELECT</h3>
<p>В общем случае команда SELECT начинается с ключевого слова SELECT, сопровождаемого пробелом. После этого должен следовать список имён столбцов, 
которые вы хотите видеть, отделяемых запятыми. Если вы хотите видеть все столбцы таблицы, вы можете заменить этот список звездочкой (*). Ключевое слово FROM, 
следующее далее, сопровождается пробелом и именем таблицы, запрос к которой делается. В конце должна использоваться точка с запятой (;) для окончания запроса 
и указания на то, что команда готова к выполнению.</p>
<a name="3.6"></a>
<h3>ПРОСМОТР ТОЛЬКО ОПРЕДЕЛЕННЫХ СТОЛБЦОВ ТАБЛИЦЫ</h3>
<p>Команда SELECT способна извлечь строго определенную информацию из таблицы. Сначала мы можем предоставить возможность увидеть только опредёленные столбцы 
таблицы. Это выполняется легко: простым исключением столбцов, которые вы не хотите видеть, из  команды SELECT. Например, запрос</p>
<pre>   SELECT sname, comm
      FROM Salespeople;</pre>
<p>будет производить вывод, показанный на Рисунке 3.2.</p>
<pre>         ===============  SQL Execution Log ============
        |                                               |
        | SELECT snum, comm                             |
        | FROM  Salespeople;                            |
        |                                               |
        | ==============================================|
        |        sname             comm                 |
        |   -------------      ---------                |
        |        Peel              0.12                 |
        |        Serres            0.13                 |
        |        Motika            0.11                 |
        |        Rifkin            0.15                 |
        |        Axelrod           0.10                 |
         ===============================================

	     Рисунок 3.2 Выбор определенных столбцов</pre>
<p>Могут иметься таблицы, которые имеют большое количество столбцов, содержащих данные, не все из которых 
нужны для выполнения поставленной задачи. 
Следовательно, вы можете найти способ подбора и выбора только полезных для вас столбцов.<a name="3.7"></a></p>
<h3>ПЕРЕУПОРЯДОЧИВАНИЕ СТОЛБЦА</h3>
<p>Даже если столбцы таблицы, по определению, упорядочены, это не означает, что вы будете восстанавливать их в том же порядке. Конечно, звёздочка (*) покажет 
все столбцы в их естественном порядке, но если вы укажете столбцы отдельно, вы можете получить их в том порядке, в котором хотите. Давайте рассмотрим таблицу 
Заказов, содержащую дату приобретения (odate), номер продавца (snum), номер заказа (onum) и суммы приобретения (amt):</p>
<pre>   SELECT odate, snum, onum, amt
      FROM Orders;</pre>
<p>Вывод этого запроса показан на Рисунке 3.3.</p>
<pre>     =============  SQL Execution Log  ==============
    |                                                 |
    |  SELECT odate, snum, onum, amt                  |
    |  FROM Orders;                                   |
    |                                                 |
    | ------------------------------------------------|
    |     odate        snum        onum           amt |
    | -----------   -------      ------     --------- |
    | 10/03/1990       1007        3001         18.69 |
    | 10/03/1990       1001        3003        767.19 |
    | 10/03/1990       1004        3002       1900.10 |
    | 10/03/1990       1002        3005       5160.45 |
    | 10/03/1990       1007        3006       1098.16 |
    | 10/04/1990       1003        3009       1713.23 |
    | 10/04/1990       1002        3007         75.75 |
    | 10/05/1990       1001        3008       4723.00 |
    | 10/06/1990       1002        3010       1309.95 |
    | 10/06/1990       1001        3011       9891.88 |
    |                                                 |
      ===============================================

	  Рисунок 3.3 Реконструкция столбцов</pre>
<p>Как  видите, структура информации в таблицах это просто основа для активной перестройки структуры в SQL.<a name="3.8"></a></p>
<h3>УДАЛЕНИЕ ИЗБЫТОЧНЫХ ДАННЫХ</h3>
<p>DISTINCT (ОТЛИЧИЕ) - аргумент, который обеспечивает вас способом устранять 
дублирующие значения из вашего предложения SELECT. Предположим, что вы хотите 
знать, какие продавцы в настоящее время имеют свои заказы в таблице Заказов. Под 
заказом (здесь и далее) будет пониматься запись в таблицу Заказов, 
регистрирующая приобретения, сделанные в определённый день определённым заказчиком у определённого продавца на определённую сумму. Вам не нужно знать, 
сколько заказов имеет каждый; вам нужен только список номеров продавцов (snum). Поэтому 
вы можете ввести:</p>
<pre>     SELECT snum
       FROM Orders;</pre>
<p>для получения вывода показанного в Рисунке 3.4</p>
<pre>               ===============  SQL Execution Log ============
              |                                               |
              | SELECT snum                                   |
              | FROM  Orders;                                 |
              |                                               |
              | ============================================= |
              |   snum                                        |
              | -------                                       |
              |   1007                                        |
              |   1001                                        |
              |   1004                                        |
              |   1002                                        |
              |   1007                                        |
              |   1003                                        |
              |   1002                                        |
              |   1001                                        |
              |   1002                                        |
              |   1001                                        |
                =============================================

	    Рисунок 3.4 SELECT с дублированием номеров продавцов</pre>
<p>Для получения списка без дубликатов, для удобочитаемости, вы можете ввести следующее:</p>
<pre>       SELECT DISTINCT snum
          FROM Orders;</pre>
<p>Вывод для этого запроса показан на Рисунке 3.5.</p>
<p>Другими словами, DISTINCT следит за тем, какие значения были ранее, чтобы они 
не дублировались в списке. Это полезный способ избежать 
избыточности данных, но важно, чтобы при этом вы понимали, что вы делаете. Если вы не хотите потерять некоторые данные, вы не должны безоглядно использовать DISTINCT, потому что это может скрыть какую-то проблему или какие-то важные 
данные. Например, вы могли бы предположить, что имена всех ваших заказчиков различны. Если кто-то помещает второго Clemens в таблицу Заказчиков, а вы 
используете SELECT DISTINCT cname, вы не будете даже знать о существовании двойника. Вы можете получить не того Clemens и даже не знать об этом. Так как вы 
не ожидаете избыточности, в этом случае вы не должны использовать DISTINCT.</p>
<h4>ПАРАМЕТРЫ DISTINCT</h4>
<p>DISTINCT может указываться только один раз в данном предложении SELECT. Если предложение выбирает несколько полей,</p>
<pre>               ===============  SQL Execution Log ===========
              |                                               |
              | SELECT DISTINCT snum                          |
              | FROM  Orders;                                 |
              |                                               |
              | ============================================= |
              |   snum                                        |
              | -------                                       |
              |   1001                                        |
              |   1002                                        |
              |   1003                                        |
              |   1004                                        |
              |   1007                                        |
                =============================================

		   Рисунок 3.5 SELECT без дублирования</pre>
<p>DISTINCT опускает строки, где все выбранные поля идентичны. Строки, в которых некоторые значения одинаковы, а некоторые 
- различны, будут сохранены. DISTINCT 
фактически приводит к показу всей строки вывода, не указывая полей (за исключением 
случав, когда он используется внутри агрегатных функций, как описано в Главе 
6), так что нет никакого смысла  его повторять.</p>
<h4>ALL ВМЕСТО DISTINCT</h4>
<p>Вместо DISTINCT вы можете указать ALL. Это будет иметь противоположный эффект, дублирование строк вывода сохранится. Так как это - тот  самый случай, 
когда вы не указываете ни DISTINCT ни ALL, то ALL - по существу скорее пояснительный, а не действующий аргумент.</p>
<a name="3.9"></a>
<h3>КВАЛИФИЦИРОВАННЫЙ ВЫБОР ПРИ ИСПОЛЬЗОВАНИИ ПРЕДЛОЖЕНИЙ</h3>
<p>Таблица имеет тенденцию становиться очень большой, поскольку с течением времени всё большее и большее количество строк в неё добавляется. Поскольку 
обычно  только определённые строки интересуют вас в данное время, SQL дает возможность  устанавливать критерии, чтобы определить, какие строки будут 
выбраны для вывода.</p><p>WHERE - предложение команды SELECT, которое позволяет  устанавливать 
предикаты, условие которых может быть или верным (true), или неверным (false) для любой строки таблицы. Команда извлекает только те строки из таблицы, для которых такое 
утверждение верно. Например, предположим, вы хотите видеть имена и комиссионные всех продавцов в Лондоне. Вы можете ввести такую команду:</p>
<pre>      SELECT sname, city
        FROM Salespeople;
        WHERE city = &quot;LONDON&quot;;</pre>
<p>Когда предложение WHERE предоставлено, программа базы данных просматривает всю таблицу построчно и исследует каждую строку, чтобы определить, верно ли 
утверждение. Следовательно, для записи Peel программа рассмотрит текущее значение столбца city, определит, что оно равно &quot;London&quot;, и включит эту строку в 
вывод. Запись для Serres не будет включена, и так далее. Вывод для вышеупомянутого запроса показан на Рисунке 3.6.</p>
<pre>               ===============  SQL Execution Log ============
              |                                               |
              | SELECT sname, city                            |
              | FROM  Salespeople                             |
              | WHERE city = 'London'                         |
              | ============================================= |
              |   sname           city                        |
              |  -------       ----------                     |
              |   Peel            London                      |
              |   Motika          London                      |
                =============================================

		  Рисунок 3.6 SELECT с предложением WHERE</pre>
<p>Давайте попробуем пример с числовым полем в предложении WHERE. Поле rating таблицы Заказчиков предназначено для того, чтобы разделять заказчиков на группы, основанные 
на некоторых критериях, которые могут быть получены в итоге через этот номер. Возможно это - форма оценки кредита или оценки, основанной на 
объёме предыдущих 
приобретений. Такие числовые коды могут быть полезны в реляционных базах данных как способ подведения итогов сложной информации. Мы можем выбрать всех 
заказчиков с рейтингом 100 следующим образом:</p>
<pre>     SELECT *
        FROM Customers
        WHERE rating = 100;</pre>
<p>Одиночные кавычки не используются здесь, потому что оценка это числовое поле. Результаты запроса показаны на Рисунке 3. 7.</p>
<p>Предложение WHERE совместимо с предыдущим материалом в этой главе. Другими словами, вы можете использовать номера столбцов, устранять дубликаты или 
переупорядочивать столбцы в команде SELECT, которая использует WHERE. Однако вы можете изменять порядок столбцов для имён только в предложении SELECT, но не в предложении WHERE.</p>
<pre>               ============  SQL Execution Log ==============
              |                                               |
              | SELECT *                                      |
              | FROM  Customers                               |
              | WHERE rating = 100;                           |
              | ============================================= |
              |   сnum     cname    city       rating  snum   |
              |  ------   --------  ------     ----    ------ |
              |   2001     Hoffman  London     100     1001   |
              |   2006     Clemens  London     100     1001   |
              |   2007     Pereira  Rome       100     1001   |
                =============================================

	      Рисунок 3.7 SELECT с числовым полем в предикате</pre>
<a name="3.10"></a>
<h3>РЕЗЮМЕ</h3>
<p>Теперь вы знаете несколько способов, как заставить таблицу выдавать вам ту информацию, какую вы хотите, а не просто вываливать наружу всё её содержание. Вы 
можете переупорядочивать столбцы таблицы или отбрасывать любой из них. Вы можете решать, хотите вы видеть дублированные значения, или нет.</p>
<p>Наиболее важно то, что вы можете устанавливать условие, называемое предикатом, которое определяет или не определяет,  из тысяч таких же 
строк, будет ли  выбрана для вывода указанная строка.</p><p>Предикаты могут становиться очень сложными, предоставляя вам высокую точность 
в решении того, какие строки вам выбирать с помощью запроса. Именно эта способность решать точно, что вы хотите видеть, делает запросы SQL такими мощными. Следующие 
несколько глав будут посвящены в большей мере особенностям, которые расширяют мощность предикатов. В Главе 4 вам будут представлены операции, иные, нежели те, 
которые используются в условиях предиката, а также способы объединения многочисленных условий в единый предикат.</p>
<a name="3.11"></a>
<h3>РАБОТА СО SQL</h3>
<ol><li><pre>Напишите команду SELECT, которая вывела бы номер заказа, сумму и дату для всех
строк из таблицы Заказов.</pre></li>
<li><pre>Напишите запрос, который вывел бы все строки из таблицы Заказчиков, для которых
номер продавца = 1001.</pre></li>
<li><pre>Напишите запрос, который вывел бы таблицу со столбцами в следующем порядке:
city, sname, snum, comm.</pre></li>
<li><pre>Напишите команду SELECT, которая вывела бы оценку (rating), сопровождаемую именем
каждого заказчика в San Jose.</pre></li>
<li><pre>Напишите запрос, который вывел бы значения snum всех продавцов в текущем заказе
из таблицы Заказов без каких бы то ни было повторений.</pre></li></ol>
<pre>(См. ответы в<a href="a.php#3"> Приложении A</a>.)</pre></body></html>
<? include 'foot.php' ?>