<? include 'head.php' ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html><head>
<link rel="stylesheet" href="css.css" type="text/css">
<meta http-equiv="Content-Type" content="text/html; charset=windows-1251">
<meta http-equiv="Content-Language" content="ru">
<title>Приложение D.</title></head>
<body>
<h1>Приложение D</h1><hr width="50%">
<h3>СИНТАКСИС И СПРАВКА ПО КОМАНДАМ</h3>
<p>В этом приложении содержатся сокращённые описания различных команд SQL. Цель 
состоит в том, чтобы дать вам быструю и точную справку и определение SQL.</p>
<p>Первый раздел этого приложения определяет элементы, используемые для создания команд 
SQL; второй - подробности синтаксиса и предложения с кратким описанием самих команд.</p>
<p>Вот стандартные условные обозначения (они называются BNF-условиями):</p>
<li>Ключевые слова набираются в верхнем регистре.</li>
<li>SQL и другие специальные условия заключаются в угловые скобки и набираются 
курсивом.(&lt;<i>и</i>&gt;)</li>
<li>Необязательные части команд находятся в квадратных скобках ( [ и ] ).</li>
<li>Многоточие ( .... ) указывает на то, что предшествующая часть команды может повторяться любое число раз.</li>
<li>Вертикальная полоса ( | ) означает: то, что ей предшествует, может быть заменено на то, что следует за ней.</li>
<li>Фигурные Скобки ( { и } ) указывают: всё, что внутри них, должно быть расценено как целое, для оценки других символов (например, вертикальных полос или эллипсов).</li>
<li>Двойное двоеточие и знак равенства (:: = ) означают: то, что следует за ними, 
является определением того, что им предшествует.<p>Кроме того, мы будем использовать следующую последовательность ( .,.. ) чтобы указывать, что предшествующее этому может повторяться любое число раз, с 
индивидуальными событиями, отделяемыми запятыми. Атрибуты, которые не являются частью официального стандарта, будут отмечены в описании как (*нестандартные*).</p>
<h5>ОБРАТИТЕ ВНИМАНИЕ: Терминология которую мы используем здесь - не является официальной 
терминологией ANSI. Официальная терминология может вас сильно запутать, поэтому мы несколько ее упростили.</h5>
<h5>По этой причине мы иногда используем условия, отличающиеся от ANSI, или используем те же самые условия, но несколько по-иному. Например, наше 
определение &lt;predicate&gt; отличается от используемой в ANSI комбинации стандартного определения &lt;predicate&gt; с &lt;search condition&gt;<span style="font-weight: 400">.</span></h5>
<hr width="50%">
<h3>ЭЛЕМЕНТЫ SQL</h3>
<p>Этот раздел определяет элементы команд SQL.</p>
<p>Они разделены на две категории:
<b>Основные элементы языка</b> и <b>Функциональные элементы языка</b>.</p>
<p><b>Основные элементы</b> - это создаваемые блоки языка; когда SQL исследует команду, то он сначала оценивает каждый символ в тексте команды в терминах 
этих элементов. Разделитель &lt;separator&gt; отделяет одну часть команды от другой; всё, что находится между разделителями &lt;separator&gt;, обрабатывается как модуль. 
Основываясь на этом разделении, SQL интерпретирует команду.</p>
<p><b>Функциональные элементы</b> - это разнообразные элементы, отличающиеся от ключевых слов, которые могут интерпретироваться как модули. Это части команды, 
отделяемые с помощью разделителей &lt;separator&gt;, имеющие специальное значение в SQL. Некоторые из них являются специальными для определенных команд и 
будут описаны вместе с этими командами позже в этом приложении.</p>
<p>Перечисленные здесь являются общими элементами для всех описываемых команд.</p>
<p>Функциональные элементы могут определяться в терминах друг друга или даже в собственных терминах. Например, предикат &lt;predicate&gt;, наш последний и наиболее сложный 
случай, содержит предикат &lt;predicate&gt; внутри собственного определения. Это потому, что предикат &lt;predicate&gt;, использующий AND или OR, может содержать любое число предикатов &lt;predicate&gt;, которые могут работать автономно. Мы представляли вам предикат &lt;predicate&gt; в отдельной секции в этом приложении из-за разнообразия и сложности 
этого функционального элемента языка. Он будет постоянно присутствовать при обсуждении других функциональных частей команд.</p>
<center><p><b>БАЗОВЫЕ ЭЛЕМЕНТЫ ЯЗЫКА</b></p></center>
<pre>ЭЛЕМЕНТ           ОПРЕДЕЛЕНИЕ

&lt;separator&gt;     &lt;comment&gt; | &lt;space&gt; | &lt;newline&gt;

&lt;comment&gt;       --&lt;string&gt; &lt;newline&gt;

&lt;space&gt;         пробел

&lt;newline&gt;       определяемый реализацией конец символьной строки

&lt;identifier&gt;    &lt;letter&gt;[{&lt;letter or digit&gt; | &lt;underscore}... ]
                  ИМЕЙТЕ В ВИДУ: Следуя строгому стандарту ANSI, символы
                  должны быть набраны в верхнем регистре, а идентификатор
		  &lt;identifier&gt; не должен быть длиннее 18-ти символов.


ЭЛЕМЕНТ            ОПРЕДЕЛЕНИЕ
&lt;underscore&gt;     -

&lt;percent sign&gt;   %

&lt;delimiter&gt;      любое из следующих: , ( ) &lt;&gt; . : = + &quot; - | &lt;&gt;
		  &gt;= &lt;= или &lt;string&gt;

&lt;string&gt;         [любой печатаемый текст в одинарных кавычках]
                   Примечание: В &lt;string&gt;, две последовательных одинарных
                   кавычки ( ' ' ) интерпретируются как одна ( ' ).

&lt;SQL term&gt;       окончание/терминатор, зависящее от главного языка.
(*только вложенный SQL*)</pre>
<h4>ФУНКЦИОНАЛЬНЫЕ ЭЛЕМЕНТЫ</h4>
<pre>Следующая таблица  показывает функциональные элементы команд SQL и их определения:

ЭЛЕМЕНТ                  ОПРЕДЕЛЕНИЕ 

&lt;query&gt;                Предложение SELECT 

&lt;subquery&gt;             Заключённое в круглые скобки предложение
		         SELECT внутри другого условия, которое фактически
		         оценивается отдельно для каждой строки-кандидата
		         другого предложения.

&lt;value expression&gt;      &lt;primary&gt;
			 | &lt;primary&gt; &lt;operator&gt; &lt;primary&gt;
			 | &lt;primary&gt; &lt;operator&gt; &lt;value expression&gt;

&lt;operator&gt;             любое из следующих:  +  -  /  *

&lt;primary&gt;              &lt;column name&gt;
			 | &lt;literal&gt;
			 | &lt;aggregate function&gt;
			 | &lt;built-in constant&gt;
			 | &lt;nonstandard function&gt;

&lt;literal&gt;              &lt;string&gt; | &lt;mathematical expressio&gt;


ЭЛЕМЕНТ                    ОПРЕДЕЛЕНИЕ

&lt;built-in constant&gt;     USER | &lt;implementation-defined constant&gt;

&lt;table name&gt;            &lt;identifier&gt;

&lt;column spec&gt;           [&lt;table name&gt; | &lt;alias&gt;.]&lt;column name&gt;

&lt;grouping column&gt;   	  &lt;column spec&gt; | &lt;integer&gt;

&lt;ordering column&gt;       &lt;column spec&gt; | &lt;integer&gt;

&lt;colconstraint&gt;         NOT NULL | UNIQUE
			  | CHECK (&lt;predicate&gt;) 
			  | PRIMARY KEY
			  | REFERENCES &lt;table name&gt;[(&lt;column name&gt;)]

&lt;tabconstraint&gt;         UNIQUE (&lt;column list&gt;)
			  | CHECK (&lt;predicate&gt;)
			  | PRIMARY KEY (&lt;column list&gt;)
			  | FOREIGN KEY (&lt;column list&gt;)
			  | REFERENCES &lt;table name&gt;[(&lt;column list&gt;)]

&lt;defvalue&gt;          	  ЗНАЧЕНИЕ ПО УМОЛЧАНИЮ = &lt;value expression&gt;

&lt;data type&gt;         	  Допустимый тип данных (См. в <a href="b.php">Приложении B</a>
	       		  описание типов, обеспечиваемых ANSI, или в
	       		  <a href="c.php">Приложении C</a> - другие общие типы.)

&lt;size&gt;                  Значение зависит от &lt;data type&gt;(См. <a href="b.php">Приложение B</a>.)

&lt;cursor name&gt;           &lt;identifier&gt;

&lt;index name&gt;            &lt;identifier&gt;

&lt;synonym&gt;               &lt;identifier&gt;(*нестандартный*)

&lt;owner&gt;                 &lt;Authorization ID&gt;

&lt;column list&gt;           &lt;column spec&gt; .,..

&lt;value list&gt;            &lt;value expression&gt; .,..

&lt;table reference&gt;       { &lt;table name&gt; [&lt;alias&gt;] } .,..

</pre>
<hr width="50%">
<h4>ПРЕДИКАТЫ</h4>
<p>Здесь определён список различных типов предиката &lt;predicate&gt;, описанных 
на следующих страницах:</p>
<p><b>&lt;predicate&gt; ::= [NOT]</b></p>
<pre>	     { &lt;comparison predicate&gt;
	     | &lt;in predicate&gt;
	     | &lt;null predicate&gt;
	     | &lt;between predicate&gt;
	     | &lt;like predicate&gt;
	     | &lt;quantified predicate&gt;
	     | &lt;exists predicate&gt; }
	       [ANDI OR &lt;predicate&gt; ]</pre>
<p>&lt;predicate&gt; - это выражение, которое может быть true, false или неизвестным, за исключением<br>
&lt;exists predicate&gt; и &lt;null predicate&gt;, которые могут быть только верными или неверными.</p>
<p>Будет получено &quot;неизвестно&quot;, если NULL-значения предотвращают вывод полученного ответа. Это будет случаться всякий раз, когда NULL-значение сравнивается с любым 
значением. Стандартные булевы операторы - AND, OR и NOT - могут использоваться с предикатом<predicate />. NOT true = false, NOT false = true, а NOT 
неизвестно = неизвестно. Результаты AND и OR в комбинации с предикатами, показаны в следующих таблицах:</p>
<pre>		  AND

AND              True           False           Неизвестно

True             true           false           неизвестно
False            false          false           false
Неизвестно       неизвестно     false           неизвестно


		  OR

OR               True          False           Неизвестно

True             true          true            true
False            true          false           неизвестно
Неизвестно       true          неизвестно      неизвестно</pre>
<p>Эти таблицы читаются способом, наподобие таблицы умножения: вы объединяете верные, неверные, или неизвестные значения из строк с их столбцами, чтобы на 
перекрестье получить результат. В таблице AND, например, третий столбец (Неизвестно) и первая строка (Тrue) на пересечении в верхнем правом углу дают 
результат - неизвестно, другими словами: Верно AND Неизвестно = неизвестно. Порядок вычислений определяется круглыми скобками. Они не представляются каждый 
раз. NOT оценивается первым, далее AND и OR. Различные типы предикатов &lt;predicate&gt; рассматриваются отдельно в следующем разделе.</p>
<hr width="40%">
<p><b>&lt;comparison predicate&gt; (предикат сравнения)</b></p>
<p><b><i>Синтаксис</i></b></p>
<p>&lt;value expresslon&gt; &lt;relational op&gt; &lt;value expresslon&gt; |<br>
&lt;subquery&gt;<br>
<br>
&lt;relatlonal op&gt; :: =<br>
=<br>
| &lt;<br>
|&gt;<br>
| &lt;<br>
|&gt;=<br>
| &lt;&gt;<br>
</p>
<p>Если либо &lt;value expression&gt; = NULL, либо &lt;comparison predicate&gt; 
= неизвестно;<br>
другими словами, это true, если сравнение true, или false, если сравнение false.<br><br>
&lt;relational op&gt; имеет стандартные математические значения для числовых 
значений; для других типов значений эти значения определяются конкретной реализацией.</p>
<p>Оба &lt;value expression&gt; должны иметь сравнимые типы данных. Если подзапрос &lt;subquery&gt; используется, он должен содержать одно выражение 
&lt;value expression&gt; 
в предложении SELECT, чьё значение будет заменять второе выражение &lt;value expression&gt; 
в предикате сравнения &lt;comparision predicate&gt; каждый раз, когда &lt;subquery&gt; действительно выполняется.</p>
<hr width="40%">
<p><b>&lt;between predicate&gt;</b></p>
<p><b><i>Синтаксис</i></b></p>
<p>&lt;value expression&gt; [NOT] BETWEEN &lt;value expression&gt;<br>AND &lt;value expression&gt;</p>
<p>&lt;between predicate&gt; - A BETWEEN B AND C имеет такое же значение, что и &lt;predicate&gt; - ( A&gt;= B AND 
&lt;= C). &lt;between predicate&gt;, для которого A NOT 
BETWEEN B AND C, имеет такое же значение, что и NOT (BETWEEN B AND C).<br>
&lt;value expression&gt; может быть выведено с помощью нестандартного запроса &lt;subquery&gt; (*nonstandard*).</p>
<hr width="40%">
<p><b>&lt;in prediicate&gt;</b></p>
<p><b><i>Синтаксис</i></b></p>
<p>&lt;value expression&gt; [NOT] IN &lt;value list&gt; | &lt;subquery&gt;</p>
<p>Список значений &lt;value list&gt; будет состоять из одного или более 
значений в круглых скобках с разделением запятыми, которые имеют сравнимый с &lt;value expression&gt; 
тип данных. Если используется подзапрос &lt;subquery&gt;, он должен содержать только одно выражение 
&lt;value expression&gt; в предложении SELECT (возможно и больше, но это уже будет вне стандарта ANSI).<br>
Подзапрос &lt;subquery&gt; фактически выполняется отдельно для каждой строки-кандидата основного запроса, и значения, которые он выведет, будут 
составлять список значений &lt;value list&gt; для этой строки. В любом случае предикат 
&lt;in predicate&gt; будет верен, если выражение &lt;value expression&gt; 
представленное в списке значений &lt;value list&gt;, если не указан NOT.<br>
Фраза A NOT IN (B, C) является эквивалентом фразы NOT (A IN (B, C)).</p>
<hr width="40%">
<p><b>&lt;like predicate&gt;</b></p>
<p><b><i>Синтаксис</i></b></p>
<p>&lt;charvalue&gt; [NOT] LIKE &lt;pattern&gt; [ESCAPE<br>
&lt;escapechar&gt;]</p>
<p>&lt;charvalue&gt;  это любое *нестандартное* выражение &lt;value expression&gt; алфавитно-цифрового типа.<br>
&lt;charvalue&gt; может быть, в соответствии со стандартом, только определенным 
столбцом &lt;column spec&gt;. Образец &lt;pattern&gt; 
состоит из строки,<string /> которая будет проверена на совпадение с &lt;charvalue&gt;. 
Символ окончания &lt;escapechar&gt;  это одиночный алфавитно-цифровой символ. 
Совпадение произойдет, если верны следующие условия:</p></li>
<li>Для каждого символа подчёркивания &lt;underscore&gt; в образце &lt;pattern&gt;, который 
не предшествует символу окончания &lt;escapechar&gt;, имеется один соответствующий ему 
символ &lt;charvalue&gt;.</li>
<li>Для каждого &lt;percent sign&gt; в образце &lt;pattern&gt;, который не предшествует &lt;escapechar&gt;, 
имеются нуль или более соответствующих символов в &lt;charvalue&gt;.</li>
<li>Для каждого &lt;escapechar&gt; в &lt;pattern&gt;, который не предшествует другому &lt;escapechar&gt;, 
нет никакого соответствующего символа в &lt;charvalue&gt;.</li>
<li>Для каждого иного символа в &lt;pattern&gt;, один и тот же символ устанавливается 
у соответствующей отметке в &lt;charvalue&gt;.<p>Если совпадение произошло, &lt;like predicate&gt; верен, если не был указан NOT. Фраза NOT LIKE 'текст' - эквивалентна NOT (A LIKE 'текст').</p>
<hr width="40%">
<p><b>&lt;null predicate&gt;</b></p>
<p><b><i>Синтаксис</i></b></p>
<p>&lt;column spec&gt; IS [NOT] NULL</p>
<p>&lt;column spec&gt; = IS NULL, если NULL значение представлено в этом столбце. Это 
сделает &lt;null predicate&gt; верным, если не указан NULL. Фраза &lt;column spec&gt; IS NOT NULL, имеет тот же результат что и NOT 
(&lt;column spec&gt; IS NULL).</p>
<hr width="40%">
<p><b>&lt;quantified predicate&gt;</b></p>
<p><b><i>Синтаксис</i></b></p>
<p>&lt;value expression&gt; &lt;relational op&gt;<br>&lt;quantifier&gt; &lt;subquery&gt;<br>&lt;quantifier&gt; :: = ANY | ALL | SOME</p>
<p>Предложение SELECT подзапроса &lt;subquery&gt; должно содержать одно, и только одно, выражение значения 
&lt;value expression&gt;. Все значения, выведенные подзапросом &lt;subquery&gt;, составляют 
набор результатов &lt;result set&gt;. &lt;value expression&gt; сравнивается, используя 
оператор связи &lt;relational operator&gt;, с каждым членом набора результатов &lt;result set&gt;. Это сравнение оценивается следующим образом:</p></li>
<li>Если &lt;quantifier&gt; = ALL и каждый член набора результатов &lt;result set&gt; делает 
это сравнение верным, &lt;quantified predicate&gt;  верен.</li>
<li>Если &lt;quantifier&gt; = ANY и имеется по крайней мере один член из набора 
результатов &lt;result set&gt;, который делает верным это сравнение, то &lt;quantified predicate&gt; является верным.</li>
<li>Если набор результатов &lt;result set&gt; пуст, то &lt;quantified predicate&gt; верен, 
если &lt;quantifier&gt; = ALL , и неверен а ином случае.</li>
<li>Если &lt;quantifier&gt; = SOME, эффект - тот же, что и для ANY.</li>
<li>Если &lt;quantified predicate&gt; неверен и не неверен, он  неизвестен.<p>&nbsp;</p>
<hr width="40%"><p><b>&lt;exists predicate&gt;</b></p><p><b><i>Синтаксис:</i></b></p><p>EXISTS 
(&lt;subquery&gt;)</p>
<p>Если подзапрос &lt;subquery&gt; выводит одну или более строк вывода, &lt;exists predicate&gt; верен; и неверен в ином случае.</p>
<hr width="70%">
<h3>SQL КОМАНДЫ</h3>
<p>Этот раздел подробно описывает синтаксис различных команд SQL. Это даст вам возможность быстро отыскивать команду, находить синтаксис и краткое описание её работы.</p>
<p><b>ИМЕЙТЕ ВВИДУ:</b> команды, которые начинаются словами - EXEC SQL, а также 
команды или предложения, заканчивающиеся словом, &lt;sql term&gt; могут использоваться только во вложенном SQL.</p>
<hr width="40%">
<h5>BEGIN DECLARE SECTION (НАЧАТЬ РАЗДЕЛ ОБЪЯВЛЕНИЙ)</h5>
<p><b><i>Синтаксис</i></b></p>
<p>EXEC SQL BEGIN DECLARE SECTION &lt;SQL term&gt; &lt;host-language variable declarations&gt; EXEC SQL END DECLARE SECTION 
&lt;SQL term&gt;</p>
<p>Эта команда создает главный раздел программы  для объявления в ней главных переменных, которые будут использоваться во вкладываемых операторах SQL. 
Переменная SQLCODE должна быть включена как одна из объявляемых переменных главного языка.</p>
<hr width="40%">
<h5>CLOSE CURSOR (ЗАКРЫТЬ КУРСОР)</h5>
<p><b><i>Синтаксис</i></b></p>
<p>EXEC SQL CLOSE CURSOR &lt;cursor name&gt; &lt;SQL term&gt;;</p>
<p>Эта команда указывает курсору закрыться, после чего ни одно значение не сможет быть выбрано из него до тех пор, пока он не будет снова открыт.</p>
<hr width="40%">
<h5>COMMIT (WORK) (ПОДТВЕРДИТЬ (ТРАНЗАКЦИИ))</h5>
<p><b><i>Синтаксис</i></b></p>
<p>COMMIT WORK;</p>
<p>Эта команда оставляет неизменными все изменения, сделанных в базе данных, до тех пор, пока начавшаяся транзакция не закончится и не начнется новая транзакция.</p>
<hr width="40%">
<h5>CREATE INDEX (СОЗДАТЬ ИНДЕКС)</h5>
<p>(*NONSTANDARD*) (НЕСТАНДАРТНАЯ)</p>
<p><b><i>Синтаксис</i></b></p>
<p>CREATE [UNIQUE] INDEX &lt;Index name&gt;<br>ON &lt;table name&gt; (&lt;column list&gt;);<br></p>
<p>Эта команда создает эффективный маршрут с быстрым доступом для поиска строк, содержащих указанные столбцы. Если UNIQUE указана, таблица не сможет содержать дубликаты (двойники) значений в этих столбцах.</p>
<hr width="40%">
<h5>CREATE SYNONYM (*NONSTANDARD*)<br>
(СОЗДАТЬ СИНОНИМ) (*НЕСТАНДАРТНЫЙ*)</h5>
<p><b><i>Синтаксис</i></b></p>
<p>CREATE IPUBLICl SYNONYM &lt;synonym&gt; FOR<br>&lt;owner&gt;.&lt;table name&gt;;</p>
<p>Эта команда создает альтернативное (синоним) имя таблицы. Синоним принадлежит его создателю, а сама таблица - обычно другому пользователю. 
Используя синоним, его владелец может не ссылаться на таблицу её полным (с включением имени владельца) именем. Если PUBLIC указан, синоним принадлежит каталогу SYSTEM и, следовательно, доступен всем пользователям.</p>
<hr width="40%">
<h5>CREATE TABLE (СОЗДАТЬ ТАБЛИЦУ)</h5>
<p><b><i>Синтаксис</i></b></p>
<p>CREATE TABLE &lt;table name&gt;<br>({&lt;column name&gt; &lt;data type&gt;[&lt;size&gt;]<br>
[&lt;colconstralnt&gt; . . .]<br>[&lt;defvalue&gt;]} . , . . &lt;tabconstraint&gt; . , . .);</p>
<p>Команда создает таблицу в базе данных. Эта таблица будет принадлежать её создателю. Столбцы будут рассматриваться в поимённом порядке.<br>
&lt;data type&gt; определяет тип данных, которые столбец будет содержать. Стандарт &lt;data type&gt; описывается в
<a href="b.php">Приложении B</a>; все прочие используемые типы данных &lt;data type&gt; обсуждались 
в <a href="c.php">Приложении C</a>. Значение размера &lt;size&gt; зависит от типа 
данных &lt;data type&gt;.<br>
&lt;colconstraint&gt; и &lt;tabconstraint&gt; налагают ограничения на значения, которые могут быть введены в столбце.<br>
&lt;defvalue&gt; определяет значение (по умолчанию), которое будет вставлено автоматически, если никакого другого значения не указано для этой строки. (См. в
<a href="ch17.php">Главе 17</a> подробности о самой команде CREATE TABLE и в Главах <a href="ch18.php">18</a> И
<a href="ch19.php">19</a> - подробности об ограничениях и о &lt;defvalue&gt;).</p>
<hr width="40%">
<h5>CREATE VIEW (СОЗДАТЬ ПРОСМОТР)</h5>
<p><b><i>Синтаксис</i></b></p>
<p>CREATE VIEW &lt;table name&gt;<br>
AS &lt;query&gt;<br>
[WITH CHECK OPTION];</p>
<p>Просмотр обрабатывается как любая таблица в командах SQL. Когда команда 
ссылается на имя таблицы &lt;table name&gt;, запрос &lt;query&gt; выполняется, и его 
вывод соответствует содержанию таблицы, указанной в этой команде.<br>Некоторые 
просмотры могут модифицироваться, что означает, что команды модификации могут 
выполняться в этих просмотрах и передаваться в таблицу, на которую была ссылка в 
запросе &lt;query&gt;. Если указано предложение WITH CHECK 
OPTION, эта модификация должны также удовлетворять условию предиката &lt;predicate&gt; 
в запросе &lt;query&gt;.</p>
<hr width="40%">
<h5>DECLARE CURSOR (ОБЪЯВИТЬ КУРСОР)</h5>
<p><i><b>Синтаксис</b></i></p>
<p>EXEC SQL DECLARE &lt;cursor name&gt; CURSOR FOR<br>&lt;query&gt;&lt;SQL term&gt;</p>
<p>Эта команда связывает имя курсора &lt;cursor name&gt; с запросом &lt;query&gt;. Когда 
курсор открыт (см. OPEN CURSOR ), запрос &lt;query&gt; выполняется, и его результат может быть выбран (командой FETCH) 
для вывода. Если курсор - модифицируемый, таблица, на которую ссылается запрос &lt;query&gt;, может получить изменение содержания с помощью операции модификации в курсоре (См. в
<a href="ch25.php">Главе 25</a> о модифицируемых курсорах).</p>
<hr width="40%">
<h5>DELETE (УДАЛИТЬ)</h5>
<p><b><i>Синтаксис</i></b></p>
<p>DELETE FROM &lt;table name&gt;<br>
{ [WHERE &lt;predicate&gt;]; }<br>
| WHERE CURRENT OF &lt;cursorname&gt;&lt;SQL term&gt;</p>
<p>Если предложение WHERE отсутствует, ВСЕ строки таблицы удаляются. Если предложение WHERE 
использует предикат &lt;predicate&gt;, строки, которые удовлетворяют условию этого 
предиката &lt;predicate&gt;, удаляются. Если предложение WHERE имеет аргумент CURRENT OF 
(ТЕКУЩИЙ) в имени курсора &lt;cursor name&gt;, строка из таблицы &lt;table name&gt;, на 
которую в данный момент имеется ссылка с помощью имени курсора &lt;cursor name&gt;, будет удалена. Форма WHERE CURRENT может 
использоваться только во вложенном SQL и только с модифицируемыми курсорами.</p>
<hr eidth="40%" color="#000000" width="40%">
<h5>EXEC SQL (ВЫПОЛНИТЬ SQL)</h5>
<p><b><i>Синтаксис</i></b></p>
<p>EXEC SQL &lt;embedded SQL command&gt; &lt;SQL term&gt;</p>
<p>EXEC SQL используется, чтобы указывать начало всех команд SQL, вложенных в другой язык.</p>
<hr width="40%">
<h5>FETCH (ВЫБОРКА/ИЗВЛЕЧЕНИЕ)</h5>
<p><b><i>Синтаксис</i></b></p>
<p>EXEC SQL FETCH &lt;cursorname&gt;<br>
INTO &lt;host-varlable llst&gt;&lt;SQL term&gt;</p>
<p>FETCH принимает вывод из текущей строки запроса &lt;query&gt;, вставляет её в 
список главных переменных &lt;host-variable list&gt;, и перемещает курсор на следующую 
строку. Список &lt;host-variable list&gt; может включать переменную indicator в качестве целевой переменной (См.
<a href="ch25.php">Главу 25</a>).</p>
<hr width="40%">
<h5>GRANT (ПЕРЕДАТЬ ПРАВА)</h5>
<p><b><i>Синтаксис (стандартный)</i></b></p>
<p>GRANT ALL [PRIVILEGES]<br>
| {SELECT<br>
| INSERT<br>
| DELETE<br>
| UPDATE [(&lt;column llst&gt;)]<br>
| REFERENCES [(&lt;column llst&gt;)l } . , . .<br>
ON &lt;table name&gt; . , . .<br>
TO PUBLIC | &lt;Authorization ID&gt; . , . .<br>
[WITH GRANT OPTION];</p>
<p>Аргумент ALL (ВСЕ), с или без PRIVILEGES (ПРИВИЛЕГИИ), включает каждую привилегию в список привилегий. PUBLIC (ОБЩИЙ) включает всех существующих 
пользователей и всех созданных в будущем. Эта команда даёт возможность передать права для выполнения действий в таблице с указанным именем. REFERENCES 
позволяет дать права на использование столбцов в списке столбцов &lt;column list&gt; как родительский ключ для внешнего ключа. Другие привилегии состоят из права 
выполнять команды, для которых привилегии указаны их именами в таблице. UPDATE подобен REFERENCES и может накладывать ограничения на определенные столбцы. GRANT OPTION даёт возможность передавать эти привилегии другим пользователям.</p>
<p><b><i>Синтаксис (нестандартный)</i></b></p>
<p>GRANT DBA<br>
| RESOURCE<br>
| CONNECT ... .<br>
TO &lt;Authorization ID&gt; . , . .<br>
[IDENTIFIED BY&gt; password&gt;</p>
<p>CONNECT дает возможность передавать право на регистрацию и некоторые другие ограниченные права.<br>
RESOURCE дает пользователю право создавать таблицы.<br>DBA дает возможность передавать почти все права.<br>
IDENTIFIED BY используется вместе с CONNECT для создания или изменения пароля пользователя.</p>
<hr width="40%">
<h5>INSERT (ВСТАВИТЬ)</h5>
<p><b><i>Синтаксис</i></b></p>
<p>INSERT INTO &lt;table name&gt; (&lt;column llst&gt;)<br>
VALUES (&lt;value llst&gt;) I &lt;query&gt;;</p>
<p>INSERT создает одну или больше новых строк в таблице &lt;table name&gt;. 
Если используется предложение VALUES, значения строк вставляются в таблицу &lt;table name&gt;. 
Если запрос &lt;query&gt; указан, каждая строка вывода будет вставлена в таблицу &lt;table name&gt;. 
Если список столбцов &lt;column list&gt; отсутствует, все столбцы таблицы &lt;table name , принимаются в упорядоченном виде.</p>
<hr width="40%">
<h5>OPEN CURSOR (ОТКРЫТЬ КУРСОР)</h5>
<p><b><i>Синтаксис</i></b></p>
<p>EXEC SQL OPEN CURSOR &lt;cursorname&gt;&lt;SQL term&gt;</p>
<p>OPEN CURSOR выполняет запрос, связанный с курсором &lt;cursor name&gt;. Вывод может теперь извлекать по одной строке для каждой команды FETCH.</p>
<hr width="40%">
<h5>REVOKE (*NONSTANDARD*)<br>
(ОТМЕНИТЬ ПОЛНОМОЧИЯ) (НЕСТАНДАРТНАЯ)</h5>
<p><b><i>Синтаксис</i></b></p>
<p>REVOKE { ALL [PRIVILEGES]<br>
| &lt;privilege&gt; . , . . } [ON &lt;table name&gt;]<br>
FROM { PUBLIC<br>
| &lt;Authorization ID&gt; . , . . };</p>
<p>Привилегия &lt;privelege&gt; может быть любой из указанных в команде GRANT. 
Пользователь, дающий REVOKE, должен иметь те же привилегии, что и пользователь, 
который давал GRANT. Предложение ON может быть использовано, если применяется привилегия специального типа для особого объекта.</p>
<hr width="40%">
<h5>ROLLBACK (WORK)<br>
(ОТКАТ) (ТРАНЗАКЦИИ)</h5>
<p><b><i>Синтаксис</i></b></p>
<p>ROLLBACK WORK;</p>
<p>Команда отменяет все изменения в базе данных, сделанные в течение текущей транзакции. Она, кроме того, заканчивается текущую и начинает новую транзакцию.</p>
<hr width="40%">
<h5>SELECT (ВЫБОР)</h5>
<p><b><i>Синтаксис</i></b></p>
<p>SELECT { IDISTINCT | ALL] &lt;value expression&gt; . , . . } / *<br>
[INTO &lt;host variable list&gt; (*только внедрённый*)]<br>
FROM &lt;table reference&gt; . , . .<br>
[WHERE &lt;predicate&gt;]<br>
[GROUP BY &lt;grouping column&gt; . , . .]<br>
[HAVING &lt;predicate&gt;]<br>
[ORDER BY &lt;ordering column&gt; [ASC | DESC] . , . . ];</p>
<p>Это предложение организует запрос и выводит значения из базы данных (см. 
Главы 3 -  14 ).</p>
<p>Применяются следующие правила:</p>
<p></li>
<li>Если ни ALL, ни DISTINCT не указаны, принимается ALL.</li>
<li>Выражение &lt;value expression&gt; состоит из &lt;column spec&gt;, агрегатной функции &lt;aggregate funct&gt;, 
нестандартной функции &lt;nonstandard function&gt;, постоянной &lt;constant&gt; или любой их комбинации с операторами в допустимых 
выражениях.</li>
<li>Таблица, на которую ссылаются, &lt;table reference&gt;, состоит из имени таблицы, 
включая префикс владельца, если текущий пользователь не владелец, или синоним 
(нестандартно) таблицы. Таблица может быть или базовой таблицей, или просмотром. 
В принципе псевдоним может указать, какой синонимом используется для таблицы, 
только на время текущей команды. Имя таблицы или синоним должны отделяться от 
псевдонима одним или более разделителями &lt;separator&gt;.</li>
<li>Если используется GROUP BY, все столбцы &lt;column spec&gt;, используемые в 
предложении SELECT, должны будут использоваться как группа столбцов &lt;grouping 
column&gt;, если они не содержатся в агрегатной функции &lt;aggregate funct&gt;. Вся 
группа столбцов &lt;grouping column&gt; должна быть представлена среди выражений &lt;value expressions&gt;, указанных в предложении SELECT. 
Для каждой отдельной комбинации значений группы столбцов &lt;grouping column&gt; будет иметься одна, и 
только одна, строка вывода.</li>
<li>Если HAVING используется, предикат &lt;predicate&gt; применяется к каждой строке, 
произведённой предложением GROUP BY, и те строки, которые сделают этот предикат 
верным, будут выведены.</li>
<li>Если ORDER BY используется, вывод имеет определенную последовательность. 
Каждый идентификатор столбца &lt;column identifer&gt; ссылается на указанное &lt;value expression&gt; в предложении SELECT. Если это 
&lt;value expression&gt; является указанным столбцом &lt;column spec&gt;, &lt;column identifier&gt; 
может быть таким же, как &lt;column spec&gt;. Иначе &lt;column identifier&gt; может быть положительным целым 
числом, указывающим место, где находится &lt;value expression&gt; в 
последовательности предложения SELECT. Вывод будет сформирован так, чтобы 
помещать значения, содержащиеся в &lt;column identifier&gt;, в порядке возрастания, 
если DESC не указан. Имя идентификатора столбца &lt;column identifier&gt;, стоящее 
первым в предложении ORDER BY, будет предшествовать позже стоящим именам в 
определении последовательности вывода.<p>Предложение SELECT оценивает каждую строку-кандидат таблицы, в которой строки 
показаны независимо.</p>
<p>Строка-кандидат определяется следующим образом:</p></li>
<li>Если только одна ссылаемая таблица &lt;table reference&gt; включена, каждая 
строка этой таблица в свою очередь является строкой-кандидатом.</li>
<li>Если более одной ссылаемой таблицы &lt;table reference&gt; включено, каждая 
строка каждой таблицы должна быть скомбинирована, в свою очередь, с каждой 
комбинацией строк из всех других таблиц. Каждая такая комбинация будет, в свою 
очередь, строкой-кандидатом.<p>Каждая строка-кандидат производит значения, 
которые делают предикат &lt;predicate&gt; в предложении WHERE верным, неверным, или неизвестным. Если GROUP BY 
не используется, каждое &lt;value expression&gt; применяется, в свою очередь, для 
каждой строки-кандидата, чьё значение делает предикат верным, и результатом этой 
операции является вывод.<br>
Если GROUP BY используется, строки-кандидаты комбинируются, используя агрегатные 
функции. Если никакого предиката &lt;predicate&gt; не установлено, каждое выражение &lt;value expression&gt; применяется к каждой строке-кандидату или к каждой группе. 
Если указан DISTINCT, дубликаты (двойники) строк будут удалены из вывода.</p>
<hr width="40%">
<h5>UNION (ОБЪЕДИНЕНИЕ)</h5>
<p><b><i>Синтаксис</i></b></p>
<p>&lt;query&gt; {UNION [ALL] &lt;query&gt; } . . . ;</p>
<p>Вывод двух или более запросов &lt;query&gt; будет объединён. Каждый запрос &lt;query&gt; должен содержать один и тот же номер 
&lt;value expression&gt; в предложении SELECT и в таком порядке, что 1.. n каждого 
совместим по типу данных &lt;data type&gt; и размеру &lt;size&gt; с 1.. n всех других.</p>
<hr width="40%">
<h5>UPDATE (МОДИФИКАЦИЯ)</h5>
<p><b><i>Синтаксис</i></b></p>
<p>UPDATE &lt;table name&gt;<br>
SET { &lt;column name&gt; = &lt;value expression&gt; } . , . .<br>
{[ WHERE &lt;predlcate&gt;]; }<br>
| {[WHERE CURRENT OF &lt;cursorname&gt;]<br>
&lt;SQL term&gt;]}</p>
<p>UPDATE изменяет значения в каждом столбце &lt;column name&gt; на 
соответствующее значение &lt;value expression&gt;. Если предложение WHERE использует 
предикат &lt;predicate&gt;, то только строки таблиц, чьи текущие значения делают этот 
предикат &lt;predicate&gt; верным, могут быть изменены. Если WHERE использует 
предложение CURRENT OF, то значения в строке таблицы &lt;table name&gt;, находящиеся в 
курсоре &lt;cursor name&gt;, меняются. WHERE CURRENT OF 
пригодно для использования только во вложенном SQL, и только с модифицируемыми 
курсорами. При отсутствии предложения WHERE, все строки меняются.</p>
<hr width="40%">
<h5>WHENEVER (ВСЯКИЙ РАЗ КАК)</h5>
<p><b><i>Синтаксис</i></b></p>
<p>EXEC SQL WHENEVER &lt;SQLcond&gt; &lt;actlon&gt; &lt;SQL term&gt;<br>
&lt;SQLcond&gt; :: = SQLERROR | NOT FOUND | SQLWARNING<br>
(последнее - нестандартное)<br>
&lt;action&gt; :: = CONTINUE | GOTO &lt;target&gt; | GOTO &lt;target&gt;<br>
&lt;target&gt; :: = зависит от главного языка</li>
</body></html>
<? include 'foot.php' ?>