<?
include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/user.php';
$set['title']='Учебник XML';
include_once '../../sys/inc/thead.php';
title();
err();
//aut();
?>
<h3 align="center">3. Стилевые таблицы XSL</h3>
<p align=justify>В предыдущем разделе для вывода элементов XML- документа на экран броузера мы применяли Java Script-сценарии  Однако, как уже отмечалось, для этих целей предпочтительней использование специально предназначенного для этого средства - стилевых таблиц XSL(Extensible Stylesheet Language).
<p align=justify>Стилевыми таблицами (стилевыми листами) принято называть специальные инструкции, управляющие процессом отображения элемента в окне программы-клиента(например, в окне броузера). Предложенные в качестве рекомендация W3C, каскадные стилевые таблицы(CSS- Cascading Style Sheets [<a href="LINKS.php">7</a>])  уже больше года используются Web- разработчиками для оформления Web- страниц. Поддержка CSS наиболее известными на сегодняшний день броузерами Netscape Navigator(начиная с версии 4.0) и Microsoft Explorer(начиная с версии 3.0), позволила использовать стилевые таблицы для решения самого широкого спектра задач - от оформления домашней странички до создания крупного корпоративного Web-узла. Слово каскадные в определении CSS означает возможность объединения отдельных элементов форматирования путем вложенных описаний стиля. Например, атрибуты текста, заданные в тэге &lt;body&gt;, будут распространяться на вложенные тэги до тех пор, пока в них не встретятся стилевые описания, отменяющие или дополняющие текущие параметры. Таким образом, использование таблиц CSS в phpL было весьма эффективно - отпадала необходимость явного задания тэгов форматирования для каждого из элементов документа.
<p align=justify>Являясь очень мощным средством оформления phpL- страниц, CSS- таблицы, тем не менее, не могут применяться в XML-документах, т.к. набор тэгов в этом языке не ограничен и использование статических ссылок на форматируемые объекты документа в этом случае невозможно.
<p align=justify>Поэтому для форматирования XML- элементов был разработан новый язык разметки, являющийся подмножеством XML, и специально был предназначен для форматирования XML- элементов. 
<p align=justify>Некоторые его отличия от CSS:
<br>
Во-первых, стилевые таблицы XSL позволяют определять оформление элемента в зависимости от его месторасположения внутри документа, т.е. к двум элементам с одинаковым названием могут применяться различные правила форматирования.
<br>
Во-вторых, языком, лежащем в основе XSL, является XML, а это означает, что XSL более гибок, универсален и у разработчиков появляется возможность использования средства для контроля за корректностью составления таких стилевых списков(используя DTD или схемы данных) 
<br>
В-третьих, таблицы XSL не являются каскадными, подобно CSS, т.к. чрезвычайно сложно обеспечить "каскадируемость" стилевых описаний, или, другими словами, возможность объединения отдельных элементов форматирования путем вложенных описаний стиля, в ситуации, когда структура выходного документа заранее неизвестна и он создается в процессе самого разбора. Однако в XSL существует возможность задавать правила для стилей, при помощи которых можно изменять свойства стилевого оформления, что позволяет использовать довольно сложные приемы форматирования
<br>
<p align=justify>В настоящий момент язык XSL находится  на стадии разработки в W3C[3] и в будущем, видимо, станет частью стандарта XML. Это означает, что использование этого механизма является наиболее перспективным способом оформления XML- документов. В текущем рабочем варианте W3C, XSL рассматривается не только как язык разметки, определяющий стилевые таблицы - в него заложены средства, необходимые для выполнения действий по фильтрации информации, выводимой в окно клиента, поиска элементов, сложного поиска, основанного на зависимостях между элементами и т.д. На сегодняшний день единственным броузером, поддерживающим некоторые из этих возможностей, является бэта-версия  Internet Explorer 5.0, однако в самом ближайшем будущем, безусловно, XSL будет использоваться также широко, как сегодня стандартные тэги phpL
<p align=justify>В этом разделе мы рассмотрим упрощенную объектную модель XSL- документа, используемую в текущей версии XSL-конвертора Microsoft msxsl, и поэтому информацию, изложенную далее, нельзя считать описанием стандарта языка. Полный рабочий вариант спецификации XSL в последней его редакции доступен на сервере [<a href="LINKS.php#3">3</a>].
<p align=justify>Все примеры, приводимые далее, могут быть проверены при помощи XSL- конвертора, свободно доступного на странице Mcrosoft [ <a href="http://www.microsoft.com/xml/xsl/">www.microsoft.com/xml/xsl/</a> ]
<h4><i>С чего начать</i></h4>
<p align=justify></i></b>Принцип обработки XML- документов стилевыми таблицами заключается в следующем: при разборе XSL-документа программа-анализатор обрабатывает инструкции этого языка и каждому элементу, найденному в XML- дереве ставит в соответствие набор тэгов, определяющих форматирование этого элемента. Другими словами, мы задаем шаблон форматирования для XML- элементов, причем сам этот шаблон может иметь структуру соответствующего фрагмента XML-документа. Инструкции XSL определяют точное месторасположение элемента XML в дереве, поэтому существует возможность применять различные стили оформления к одинаковым элементам, в зависимости от контекста их использования. На рисунке 3.1 представлена схема, иллюстрирующая этот процесс.
<p align="center">
<img src="../../PICTURES/IT/XML/IMG1.GIF" border=0 alt="Схема обработки XSL-документа">
<p align="center"><i>Рис 1</i>
<p align=justify>В общем случае, XSL позволяет автору задавать параметры отображения элемента XML, используя любые языки, предназначенные для форматирования - phpL, RTF и т.д. В этом разделе мы будем использовать в качестве такого языка phpL, т.к. документы, созданные при помощи этого языка разметки могут просматриваться любой подходящей программой просмотра Web-страниц
<h4><i>Структура XSL- таблиц</i></h4>
<p align=justify>Рассмотрим основные структурные элементы XSL, используемые, в частности, в конверторе <b>msxsl, </b>для создания оформления XML-документов.
<h4>Правила XSL </h4>
<p align=justify>XSL- документ представляет собой совокупность правил построения, каждое из которых выделено в отдельный блок, ограниченный тэгами <b>&lt;rule&gt; </b>и <b>&lt;/rule&gt</b>;. </b>Правила определяют шаблоны, по которым каждому элементу XML ставится в соответствие последовательность phpL- тэгов, т.е. внутри них содержатся инструкции, определяющие элементы XML- документа и тэги форматирования, применяемые к ним. 
<p align=justify>Элементы XML, к которым будет применяться форматирование, обозначаются в XSL дескриптором <b>&lt;target-element/&gt</b>;. </b>Для указания  элемента с конкретным названием (название элемента определяется тэгами, его обозначающими), т.е. определения класса элемента, можно использовать атрибут <b>type</b>="&lt;имя_элемента&gt;" 
<p align=justify>Вот пример простейшего XSL-документа, определяющего форматирование для фрагмента <i>&lt;flower&gt;rose&lt;/flower&gt;</i> :
<pre>
&lt;xsl&gt;
&lt;rule&gt;
&lt;target-element type="flower"/&gt;
&lt;p color="red" font-size="12"&gt;
&lt;children/&gt;
&lt;/p&gt;
&lt;/rule&gt;
&lt;/xsl&gt; 
</pre>
<p align=justify></i>Уже на этом примере можно проследить особенность использования стилевых таблиц: в любых правилах при помощи соответствующих элементов декларативно задается область, которая определяет фрагмент XML-документа, как мы чуть позже увидим, программа-анализатор заново проходит все элементы, начиная с текущего, всякий раз, когда в структуре XML- документа обнаруживаются новые  вложенные элементы.
<p align=justify>Инструкция &lt;target-element&gt; указывает на то, что данное правило определяет элемент. Параметром type="flower" задается название XML-элемента, для которого будет использоваться это правило. Программа-конвертор будет использовать phpL-тэги, помещенные внутри блока &lt;rule&gt;&lt;/rule&gt; для форматирования XML-элемента, которому "предназначался" текущий блок. В том случае, если для какого-то элемента XML шаблон не определяется, в выходной документ будут добавлены тэги форматирования по умолчанию (например, &lt;DIV&gt;&lt;/DIV&gt; )
<p align=justify>Процесс разбора XSL-правил является рекурсивным, т.е. если у элемента есть дочерние элементы, то программа будет искать определения этих элементов, расположенных "глубже" в дереве документа. Указанием на то, что необходимо повторить процесс разбора XML документа, теперь уже для  дочерних элементов, является инструкция <b>&lt;children/&gt;. </b>Дойдя до нее, анализатор выберет из иерархического дерева XML- элементов нужную ветвь и найдет в XSL-шаблонах правила, определяющие форматирование этих нижележащих элементов. В том случае, если вместо &lt;children&gt; мы укажем инструкцию <b>&lt;empty/&gt</b>;, </b>программа закончит движение по данной ветви и возвратится назад, в родительское правило.  При этом текущее правило никакой информации в выходном phpL-документе  изменять не будет, т.к. &lt;empty/&gt; в данном случае означает, что содержимое элемента отсутствует.
<p align=justify>Если в одном правиле &lt;target-element&gt; используется несколько раз, то инструкции по форматированию будут распространены на все описываемые внутри него XML-элементы, т.е. можно задавать единый шаблон форматирования для нескольких элементов одновременно:
<pre>
&lt;xsl&gt;
&lt;rule&gt;
&lt;target-element type="item1"/&gt;
&lt;target-element type="item2"/&gt;
&lt;target-element type="item3"/&gt;
&lt;hr&gt;
&lt;children/&gt;
&lt;hr&gt;
&lt;/rule&gt;
&lt;/xsl&gt; 
</pre>
<p align=justify>Ниже приведен пример более сложного XSL- описания, некоторые фрагменты которого будут пояснены позже.
<p align=justify>XML-документ:
<pre>
&lt;?XML Version="1.0"?&gt;
&lt;documents&gt;
&lt;books&gt;
&lt;book id="Book1"&gt;
&lt;title&gt;Макроэномические показатели экономики Римской Империи в период ее расцвета&lt;/title&gt;
&lt;author&gt;Иван Петров&lt;/author&gt;
&lt;date&gt;21.08.98&lt;/date&gt;
&lt;/book&gt;
&lt;book id="Book2"&gt;
&lt;title&gt;Цветоводство и животноводство. Практические советы&lt;/title&gt;
&lt;author&gt;Петр Сидоров&lt;/author&gt;
&lt;date&gt;10.10.98&lt;/date&gt;
&lt;/book&gt;
&lt;/books&gt;
&lt;articles&gt;
&lt;article id="Article1"&gt;
&lt;author&gt;Петр Иванов&lt;/author&gt;
&lt;title&gt;Влияние повышения тарифов оплаты за телефон на продолжительность жизни населения&lt;/title&gt;
&lt;date&gt;12.09.98&lt;/date&gt;
&lt;/article&gt;
&lt;/articles&gt;
&lt;/documents&gt;
</pre>
<p align=justify>Содержимое XSL-документа:
<pre>
&lt;xsl&gt;
  &lt;rule&gt;
    &lt;root/&gt;      
    &lt;phpL&gt;       
    &lt;BODY bgcolor="white"&gt;
    &lt;center&gt;&lt;hr width="80%"/&gt;&lt;b&gt;Library&lt;/b&gt;&lt;hr width="80%"/&gt;&lt;br/&gt; 
    &lt;table width="80%" border="2"&gt;
    &lt;children/&gt;  
    &lt;/table&gt;&lt;/center&gt;
    &lt;/BODY&gt;
    &lt;/phpL&gt;	   
  &lt;/rule&gt;
    &lt;rule&gt;
	 &lt;element type="book"&gt;
	    &lt;target-element type="author"/&gt;
             &lt;/element&gt;
            &lt;td align="center"&gt;
	    &lt;p color="red" font-size="14"&gt; &lt;b&gt; 
&lt;children/&gt; 
&lt;/b&gt;&lt;/p&gt;&lt;/td&gt;
    &lt;/rule&gt;
    &lt;rule&gt;
	 &lt;element type="article"&gt;
	    &lt;target-element type="author"/&gt;
         &lt;/element&gt;
            &lt;td align="center"&gt;
	    &lt;p color="red" font-size="14" font-style="italic"&gt;&lt;children/&gt;&lt;/p&gt;&lt;/td&gt;
    &lt;/rule&gt;
    &lt;rule&gt;
	    &lt;target-element type="book"/&gt;
            &lt;tr&gt;&lt;children/&gt;&lt;/tr&gt;
    &lt;/rule&gt;
    &lt;rule&gt;
	    &lt;target-element type="article"/&gt;
            &lt;tr&gt;&lt;children/&gt;&lt;/tr&gt;
    &lt;/rule&gt;
    &lt;rule&gt;
	    &lt;target-element/&gt;
            &lt;td align="center"&gt;&lt;p&gt;&lt;children/&gt;&lt;/p&gt;&lt;/td&gt;
    &lt;/rule&gt;
    &lt;rule&gt;
	    &lt;target-element type="books"/&gt;
            &lt;tr&gt;&lt;td colspan="3" bgcolor="silver" &gt;Books&lt;/td&gt;&lt;/tr&gt;
            &lt;children/&gt;
    &lt;/rule&gt;
    &lt;rule&gt;
	    &lt;target-element type="articles"/&gt;
            &lt;tr&gt;&lt;td colspan="3" bgcolor="silver" &gt;Articles&lt;/td&gt;&lt;/tr&gt;
            &lt;children/&gt;
    &lt;/rule&gt;
&lt;/xsl&gt; 
</pre>
<h4>Корневое правило</h4>
<p align=justify>Разбор любого XSL- документа всегда начинается с правила для корневого элемента, в котором определяется область всего разбираемого XML документа и поэтому тэги форматирования, помещенные сюда, будут действовать на весь документ в целом. Для обозначения корневого правила необходимо включить в него элемент <b>&lt;root/&gt</b>;. </b>Например, для того, чтобы задать тэг &lt;body&gt; для формируемой нами выходной phpL- страницы, мы можем  использовать следующий фрагмент:
<pre>
&lt;xsl&gt;
&lt;rule&gt;
&lt;root/&gt;
&lt;phpl&gt;&lt;head&gt;&lt;title&gt; Flowers&lt;/title&gt;&lt;/head&gt;
&lt;body bgcolor="white" link="blue" alink="darkblue" vlink="darckblue"&gt;
&lt;children/&gt;
&lt;/body&gt;
&lt;/phpl&gt;
&lt;/rule&gt;
&lt;/xsl&gt;
</pre>
<p align=justify>В этом примере при помощи инструкций &lt;root/&gt; и &lt;children/&gt; мы определили ряд начальных и конечных phpL-тэгов для нашей страницы, между которыми затем в процессе рекурсивного обхода XSL- анализатора будут помещены остальные элемента документа. 
<p align=justify>В том случае, если мы не определяем правило для корневого элемента, разбор документа начнется с первого правила с инструкцией &lt;target-element&gt;(для оформления же заголовка документа будет использован образец форматирования, применяющийся по умолчанию).
<h4>Отношения между элементами</h4>
<p align=justify>Дочерние элементы в XML-документе всегда находятся внутри области, определяемой тэгами родительского по отношению к ним элемента. Для того, чтобы точно указать месторасположение обрабатываемого элемента в дереве XML, в XSL  используется дополнительный тэг <b>&lt;element&gt</b>;. </b>При помощи него можно указать, какие элементы должны предшествовать текущему, а какие  - следовать после него. Например, в следующем фрагменте определяется, что форматирование элемента &lt;title&gt; будет зависеть от его месторасположения внутри XML-документа:
<pre>
&lt;xsl&gt;
&lt;rule&gt;
&lt;element type="journal"&gt;
	    &lt;target-element type="title"/&gt;
         	&lt;/element&gt;
&lt;center&gt;
&lt;hr width=80%&gt;
&lt;children/&gt;
&lt;hr width=80%&gt;
&lt;/center&gt;    
&lt;/rule&gt;
&lt;rule&gt;
&lt;element type="article"&gt;
	    &lt;target-element type="title"/&gt;
         	&lt;/element&gt;
&lt;td align="center"&gt;&lt;p color="blue" font-size="14" font-style="italic"&gt;&lt;children/&gt;
&lt;/td&gt;
&lt;/rule&gt;
&lt;/xsl&gt;
</pre>
<p align=justify>Как видно из примера, если в XML- документе будет найден элемент &lt;title&gt;, являющийся дочерним по отношению к элементу &lt;article&gt; (название статьи), то его форматирование будет несколько отличаться от элемента &lt;title&gt;, расположенного внутри тэгов &lt;journal&gt;
<h4>Приоритеты правил</h4>
<p align=justify>В том случае, если внутри XSL- документа встречается несколько правил для одного и того же элемента, то msxsl будет использовать то из них, которое более точно определяет позицию данного элемента. Т.е. если XSL- документ содержит следующие правила:
<pre>
&lt;rule&gt;
&lt;element type="journal"&gt;
	    &lt;target-element type="title"/&gt;
         	&lt;/element&gt;
&lt;center&gt;
&lt;hr width=80%&gt;
&lt;children/&gt;
&lt;hr width=80%&gt;
&lt;/center&gt;
&lt;/rule&gt;
&lt;rule&gt;
	&lt;target-element type="title"/&gt;
&lt;b&gt;
&lt;children/&gt;
&lt;/b&gt;    
&lt;/rule&gt;
</pre>
<p align=justify>, то при использовании этой стилевой таблицы в случае, когда элемент &lt;title&gt; является потомком &lt;journal&gt;, к нему будет применено первое правило. Для любых же других элементов будет действовать правило без тэга &lt;element&gt;
<p align=justify>В общем случае приоритет правил определяется следующим образом (в порядке убывания приоритета):
<UL>
<LI>правила, помеченные специальным тэгом &lt;importance&gt;
<LI>правила с наибольшим значением атрибута id, если он определен
<LI>правила с наибольшим значением атрибута class, если он определен
<LI>правила, имеющие наибольшую вложенность, определяемую тэгом &lt;element&gt;
<LI>правила, использующие атрибут type совместно с &lt;target-element&gt;
<LI>правила, в которых отсутствует атрибут type в &lt;target-element&gt; или &lt;element&gt;
<LI>правила с более высоким приоритетом, задаваемым атрибутом priority тэга &lt;rule&gt;
<LI>правила с наибольшим значением квалификаторов &lt;only&gt;, &lt;position&gt;, &lt;attribute&gt;
</UL>
<h4>Использование атрибутов элементов</h4>
<p align=justify>Применительно к &lt;target-element&gt; и &lt;element&gt; в правилах также могут использоваться специальные элементы <b>&lt;attribute&gt</b>;, </b>при помощи которых можно уточнять характеристики обрабатываемых элементов, задавая различные инструкции форматирования для одинаковых  элементов с различными атрибутами. Указываемые в <i>&lt;attribute&gt; </i>параметры <i>name </i>и <i>value </i>определяют атрибут XML, который должен иметь текущий обрабатываемый элемент. Например, в следующем фрагменте все элементы с атрибутом free_lance ="true" будут выделены в выходном phpL- документе серым цветом
<pre>
&lt;rule&gt;
&lt;target-element type="author"&gt;
 &lt;attribute name="free_lance" value="true"&gt;
	&lt;/target-element&gt;
&lt;p color="gray"&gt;
&lt;children/&gt;
&lt;/p&gt;
 &lt;/rule&gt;
</pre>
<h4>Фильтрация элементов</h4>
<p align=justify>Одним из самых мощных средств XSL является возможность сортировки  и выборки элементов, выделяемых из общего дерева элементов документа. Для этого используется элемент <b>&lt;select-elements&gt</b>;, </b>который заменяет &lt;children/&gt; в правилах, определяя те элементы, которые следует обработать в процессе рекурсивного обхода. Например, в следующем примере будут обработаны только элементы &lt;author&gt;:
<pre>
&lt;rule&gt;
&lt;target-element type=" staff"/&gt;
&lt;div&gt;
&lt;select-elements&gt;
&lt;target-element type = "author"/&gt;
&lt;/select-elements&gt;
&lt;/div&gt;
&lt;/rule&gt;
</pre>
<p align=justify>Элемент &lt;select-elements&gt; сам по себе не определяет шаблон форматирования, он лишь управляет работой анализатора, обозначая, подобно &lt;children/&gt;, "нижележащие" элементы. В приведенном примере элемент &lt;author&gt; должен быть расположен внутри элемента &lt;staff&gt;
<p align=justify>Для того, чтобы в шаблоне выделить не только собственные дочерние элементы, но и дочерние элементы потомков, т.е. использовать несколько уровней вложенности, необходимо задать параметр from = "descendants".  Если параметр имеет значение "children", что указывает на то, что выбор должен производится из списка собственных дочерних элементов, то атрибут from может опускаться, т.к. "children" является значением по умолчанию.
<h4>Правила стилей</h4>
<p align=justify>В отличие от CSS, в XSL невозможно использование каскадных стилевых определений(т.е. нельзя использовать несколько правил для определения стиля одного того же элемента), т.к. такие ограничения вводит рекурсивный алгоритм работы программы - анализатора. Однако использование правил определения стиля(Style Rules) элемента позволяет каким-то образом скомпенсировать этот недостаток.
<p align=justify>Для определения правила стилевого оформления необходимо воспользоваться элементом <b>&lt;style-rule&gt</b>;, </b>который используется точно также, как и &lt;rule&gt;, но инструкции, содержащиеся в нем, никак не влияют на структуру выходного документа. Поэтому все команды внутри этого правила должны описываться в рамках элемента &lt;apply&gt;. Вот как будет выглядеть, например, определение стиля для элемента <i>&lt;flower&gt;rose&lt;/flower&gt</i>;:</i>
<pre>
&lt;style-rule&gt;
&lt;target-element type ="flower"/&gt;
&lt;apply color ="red"/&gt;
&lt;/style-rule&gt; 
&lt;rule&gt;
&lt;target-element type="flower"/&gt;
&lt;div font-style="italic";&gt;
&lt;children/&gt;
&lt;/div&gt;
&lt;/rule&gt;
</pre>
<p align=justify>Если бы мы не определили правила &lt;rule&gt;, то в выходной документ не было бы помещено никакой информации, т.к. элемент &lt;style-rule&gt; только определяет параметры стилевого оформления, не предпринимая никаких других действий.
<p align=justify>Также надо учитывать, что XSL- анализатор использует CSS для определения задаваемого правилами &lt;style-rule&gt; стиля в выходном phpL-документе, тем самым предоставляя нам возможность использования этого мощного средства при оформлении phpL-страниц После обработки приведенного в примере фрагмента в выходной документ будут помещены следующие элементы:
<pre>
&lt;div style= "font-style: italic; color : red;"&gt;rose&lt;/div&gt;
</pre>
Еще один пример:
<p align=justify>Стили в формате CSS:
<pre>
issue {font-weight=bold; color=blue;}
.new {font-weight=bold; color=red;}
</pre>
<p align=justify>Фрагмент XSL- документа, позволяющего использовать подобные стилевые определения:
<pre>
&lt;style-rule&gt;
&lt;target-element type ="issue"/&gt;
&lt;apply color ="blue"/&gt;
&lt;/style-rule&gt; 
&lt;style-rule&gt;
&lt;target-element type ="issue"&gt;
&lt;attribute name ="class" value ="new" /&gt;
&lt;/target-element&gt;
&lt;apply color ="red"/&gt;
&lt;/style-rule&gt; 
&lt;rule&gt;
&lt;target-element type="issue"/&gt;
&lt;div&gt;
&lt;children/&gt;
&lt;/div&gt;
&lt;/rule&gt;
</pre>
<h4>Сценарии</h4>
<p align=justify>Сценарии могут использоваться в документах  XSL точно также, как и в phpL. Кроме того, сценарии, содержащиеся внутри XSL-документа и запускаемые броузером в процессе обработки документа могут динамически создавать phpL-документы, извлекая необходимую для этого информацию непосредственно из элементов XSL-документа.
<p align=justify>Для написания сценариев XSL использует специальный скриптовый язык - ECMAScript. Однако в msxsl для этих целей можно применять Microsoft JavaScript,- язык, который объединил в себе некоторые элементы стандартного JavaScript и ECMAScript.
<h4>Вычисление выражений</h4>
<p align=justify>Наиболее простым примером использования сценариев в XSL -документе является вычисление значений параметров описываемых элементов. Для этого надо просто поставить знак равенства в качестве первого символа параметра, что заставит XSL-процессор вычислить значение выражения(синтаксис этого выражения должен отвечать требованиям JavaScript). Например, после разбора этого правила:
<pre>
&lt;rule&gt;
&lt;target-element type="header"&gt;
&lt;hr width="=100-20+'%'"&gt;
&lt;children/&gt;
&lt;hr width="80%"&gt;
&lt;/rule&gt;
</pre>
<p align=justify>, в выходном документе окажутся следующие инструкции:
<pre>
&lt;hr width=80%&gt;
...
&lt;hr width=80%&gt;
</pre>
<p align=justify>Очень часто в правилах XSL необходимо использовать атрибуты описываемого в них элемента. Для этого мы должны воспользоваться методом getAttribute(), описанным в объектной модели XML (мы рассматриваем объектную модель XML-документов, предложенную Microsoft, список этих функций приведен в конце раздела). Т.к. каждому элементу XSL доступен указатель на соответствующий ему объект, сценарий может обращаться к внутренним функциям и свойствам этих элементов, при помощи которых и осуществляются необходимые действия. 
<p align=justify>В следующем фрагменте XML- документа определяется элемент &lt;article&gt;, в котором атрибут src используется для задания адреса файла, содержащего текст статьи. 
<pre>
&lt;articles&gt;
&lt;article src="http://server/pages/article.phpl"&gt;Bugs report&lt;/article&gt;
&lt;/articles&gt;
</pre>
<p align=justify>Для того, чтобы использовать этот атрибут в выходном phpL-документе, необходимо определить следующее правило:
<pre>
&lt;rule&gt;
&lt;target-element type="article"&gt;
&lt;a href='=getAttribute("src")'&gt;
&lt;children/&gt;
&lt;/a&gt;
&lt;/rule&gt;
</pre>
<p align=justify>После обработки этого фрагмента в выходной документ будет помещен элемент:
<pre>
&lt;a href="http://server/pages/article.phpl"&gt;Bugs report&lt;/a&gt;
</pre>
<h4>Выполнение инструкций</h4>
<p align=justify>Другим способом помещения в выходной phpL- документ информации, являющейся результатом выполнения каких-либо операций JavaScript – сценариев является использовнаие  инструкции <b>&lt;eval&gt</b>;:</b>
<pre>
&lt;rule&gt;
&lt;element type="articles"&gt;
&lt;target-element type="article"&gt;
&lt;/element&gt;
&lt;tr&gt;&lt;td&gt;&lt;eval&gt;childNumber(this)&lt;/eval&gt;&lt;/td&gt;&lt;td&gt;
&lt;children/&gt;
&lt;/td&gt;&lt;tr&gt;
&lt;/rule&gt;
</pre>
<p align=justify>Метод childNumber в данном случае возвращает текущий номер дочернего элемента.
<h4>Определение функций и глобальных переменных</h4>
<p align=justify>Аналогично тэгу &lt;SCRIPT&gt; в phpL, элемент <b>&lt;define-script&gt; </b>содержит функции и определения глобальных переменных. Обычно в XSL-документе определяется один элемент &lt;define-script&gt;, расположенный в самом начале.
<pre>
&lt;xsl&gt;
&lt;define-script&gt;
&lt;![CDATA[
var fontSize=12;
function getColor(elem){
return elem.children.item("color",0).text; 
		// Возвращает содержимое дочернего элемента &lt;color&gt;
}]]&gt;
&lt;/define-script&gt;
&lt;rule&gt;
&lt;target-element type = "flower"&gt;
&lt;div background-color="=getColor(this)"; font-size="=fontSize"&gt;
&lt;children/&gt;
&lt;/div&gt;
&lt;/rule&gt;
&lt;/xsl&gt;
</pre>
<p align=justify>Если применить эти правила к такому фрагменту XML- документу:
<pre>
&lt;xml&gt;
&lt;flower&gt;
rose
&lt;color&gt;red&lt;/color&gt; 
&lt;/flower&gt;
</pre>
, то на выходе phpL -документ будет содержать следующие элементы:
<pre>
&lt;div background-color="red"; font-size="12"&gt;
</pre>
<p align=justify>Необходимо отметить, что использование глобальных переменных в некоторых случаях может приводить к серьезным ошибкам, вызванным попытками одновременного к ним доступа. Поэтому рекомендуется использовать такие переменные только в качестве констант.
<h4>Использование Java Script для phpL</h4>
<p align=justify>Создавая шаблон phpL-документа, Вы можете указывать в нем практически любые элементы phpL, в том числе и блоки &lt;SCRIPT&gt;, внутри которых можно задавать любые конструкции Java Script, используя для этого область CDATA:
<pre>
&lt;xsl&gt;
  &lt;rule&gt;
    &lt;root/&gt;
    &lt;phpL&gt;
      &lt;HEAD&gt;
        &lt;SCRIPT LANGUAGE="JSCRIPT"&gt;&lt;![CDATA[
var ie4=((navigator.appName=="Microsoft Internet Explorer")&&(parseInt(navigator.appVersion)  &gt;= 4 ));
       function msover(){
if (ie4){
  		event.srcElement.style.color="red";
  		event.srcElement.style.cursor = "hand";
  	}
}
       function msout(){
	if (ie4){
  		event.srcElement.style.color="black";
  		event.srcElement.style.cursor = "auto";
  	}
}        ]]&gt;&lt;/SCRIPT&gt;
      &lt;/HEAD&gt;
      &lt;BODY&gt;
        &lt;children/&gt;
      &lt;/BODY&gt;
    &lt;/phpL&gt;
  &lt;/rule&gt;
  &lt;rule&gt;
    &lt;target-element type="chapter"/&gt;
    &lt;DIV id='=tagName + formatNumber(childNumber(this),"1")'
         background-color="marron"
    onmouseover='="msover("+ tagName + formatNumber(childNumber(this),"1")+")"'
    onmouseout='="msout("+ tagName + formatNumber(childNumber(this),"1")+")"'
      &lt;children/&gt;
    &lt;/DIV&gt;
  &lt;/rule&gt;
&lt;/xsl&gt;
</pre>
Если использовать эти правила для следующего XML- документа:
<pre>
&lt;contents&gt;
  &lt;chapter&gt;Part1&lt;/chapter&gt;
  &lt;chapter&gt;Part2&lt;/chapter&gt;
  &lt;chapter&gt;Part3&lt;/chapter&gt;
&lt;/contents&gt;
</pre>
то в результате мы получим такой phpL-файл:
<pre>
&lt;phpL&gt;
&lt;HEAD&gt;
&lt;SCRIPT LANGUAGE="JSCRIPT"&gt;
var ie4=((navigator.appName=="Microsoft Internet Explorer")&&(parseInt(navigator.appVersion)  &gt;= 4 ));
function msover(){
if (ie4){
  		event.srcElement.style.color="red";
  		event.srcElement.style.cursor = "hand";
 	}
}
function msout(){
	if (ie4){
  		event.srcElement.style.color="black";
  		event.srcElement.style.cursor = "auto";
  	}
  }
&lt;/SCRIPT&gt;
&lt;/HEAD&gt;
&lt;BODY&gt;
&lt;DIV id=''chapter1"    onmouseover="msover("chapter1")"'
			  onmouseout="msout("chapter1")"'
      Part 1
       &lt;/DIV&gt;
&lt;DIV id=''chapter2"    onmouseover="msover("chapter2")"'
			  onmouseout="msout("chapter2")"'
      Part 2
       &lt;/DIV&gt;
&lt;DIV id=''chapter3"    onmouseover="msover("chapter3")"'
			  onmouseout="msout("chapter3")"'
      Part 3
       &lt;/DIV&gt;
&lt;/BODY&gt;
&lt;/phpL&gt;
</pre>
<h4>Встроенные функции XSL</h4>
<p align=justify>В завершении приведем список внутренних функций, которые можно использовать в JavaScript –сценариях, предназначенных для  анализатора <b>msxsl</b>:
<TABLE BORDER=1 WIDTH=100%>
<tr valign=top><td><b>Ancestor(elementType, elem)</B></TD>
<td>Возвращает для текущего элемента ссылку на ближайший родительский элемент заданного типа. Если такого элемента нет или текущий элемент пустой, то возвращает null </TD>
</TR>
<tr valign=top><td><b>ChildNumber(elem)</B></TD>
<td>Возвращает индекс текущего элемента в списке других дочерних элементов данного типа.</TD>
</TR>
<tr valign=top><td><b>AncestorChildNumber()</B></TD>
<td>Возвращает номер ближайшего предка текущего элемента или null, если такового не существует</TD>
</TR>
<tr valign=top><td><b>path(xsl)</B></TD>
<td>Возвращает массив, содержащий "путь" к текущему элементу - в каждую ячейку этого массива помещается цифровое значение, указывающее на количество элементов одинакового типа, находящихся на текущем уровне вложенности. Первым значением этого массива будет представлен корневой элемент,  последним - текущий. Размер массива определяет глубину вложенности текущего элемента.</TD>
</TR>
<tr valign=top><td><b>HierarchicalNumberRecursive(elementType,elem)</B></TD>
<td>Метод, похожий на метод path, но возвращает только дочерние элементы  </TD>
</TR>
<tr valign=top><td><b>FormatNumber(n,format)</B></TD>
<td>Возвращает строку - символьное представление номера(т.е. "один", "два" и т.д.). Возможно определение следующих форматов:
<br>"1" - 0,1,2,..
<br>"01" - 01,02,03,...
<br>"a" - a,b,c,..z, aa, ab,..zz
<br>"A" - A,..,Z,AA, .. ZZ</TD>
</TR>
<tr valign=top><td><b>FormatNumberList(list,format,separator)</B></TD>
<td>Возвращает строку, представляющую список, элементами которого являются символьные представления чисел</TD>
</TR>
</TABLE>
<p><center><p>
<font size=-1>
<a href="PART2.php">Назад</a> | <a href="index.php">Содержание</a> | <a href="PART4.php">Вперед</a></font></center></p>
</body></html>
<?
include_once '../../sys/inc/tfoot.php';
?>