<?
include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/user.php';
$set['title']='Учебник JavaScript';
include_once '../../sys/inc/thead.php';
title();
err();
//aut();
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<phpl<TITLE>Работа с Объектами</TITLE>
<BODY>
<h5><a href="contents.php">Оглавление</a> | <a href="fcns.php">Назад</a>
| <a href="obj2.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5>
<HR><h1>Глава 7<BR><a name="1008302"></a>Работа с Объектами</h1><p><A NAME="1008307"></a>
JavaScript разработан на основе простой объектной парадигмы. Объект это 
конструкция со свойствами, которые являются переменными JavaScript или другими 
объектами. Объект также может иметь ассоциированные с ним функции, которые 
известны как <I>methods\методы</I> объекта. Помимо предопределённых серверных и 
клиентских объектов Navigator'а, можно создавать пользовательские объекты.</p><p><A NAME="1008309"></a>
В главе рассматривается, как использовать объекты, свойства, функции и методы и как создавать Ваши собственные объекты. </p>
<p><A NAME="1010098"></a>В главе имеются следующие разделы:</p><ul><LI><A NAME="1010099"></a>
<a href="#1008312">Объекты и свойства</a></LI><LI><A NAME="1010100"></a>
<a href="#1008327">Создание новых объектов</a></LI><LI><A NAME="1010136"></a>
<a href="#1010352">Предопределённые объекты ядра</a></LI></ul><H2><A NAME="Objects and Properties">
<a name="1008312"></a>Объекты и свойства</H2><hr><p><A NAME="1008313"></a>
Объект в JavaScript имеет ассоциированные с ним свойства. Вы получаете доступ к 
этим свойствам объектов с помощью простой нотации:</p>
<PRE><A NAME="1008314"></a><I>objectName</I>.<I>propertyName</I></PRE><p><A NAME="1008316"></a>
И имя объекта, и имя свойства чувствительны к регистру символов. Вы определяете 
свойство, присваивая ему значение. Например, имеется объект <CODE>myCar</CODE> (для 
упрощения будем всё время предполагать, что объект уже существует). Вы можете 
создать его свойства <CODE>make</CODE>, <CODE>model</CODE> и <CODE>year</CODE>:</p>
<PRE><A NAME="1008317"></a>myCar.make = "Ford"<br>myCar.model = "Mustang"<br>myCar.year = 1969;</PRE>
<p><A NAME="1008319"></a>Массив это упорядоченный набор значений, ассоциированных с одним именем 
переменной. Свойства и массивы в JavaScript тесно связаны; фактически это два 
разных интерфейса для одной структуры данных. Так, например, Вы можете получить 
доступ к свойствам объекта <CODE>myCar</CODE> так:</p>
<PRE><A NAME="1008320"></a>myCar["make"] = "Ford"<br>myCar["model"] = "Mustang"<br>myCar["year"] = 1967</PRE>
<p><A NAME="1008321"></a>Массив этого типа известен как <i>ассоциативный массив</i>, поскольку индекс 
каждого элемента также ассоциирован со строковым значением. В качестве 
иллюстрации: следующая функция отображает свойства объекта, когда Вы передаёте 
объект и имя объекта в качестве аргументов этой функции:</p>
<PRE><A NAME="1008322"></a>function show_props(obj, obj_name) {<br>&nbsp;&nbsp;&nbsp;var result = ""<br>&nbsp;&nbsp;&nbsp;for (var i in obj)<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;result += obj_name + "." + i + " = " + obj[i] + "\n"<br>&nbsp;&nbsp;&nbsp;return result<br>}</PRE>
<p><A NAME="1008323"></a>Так, вызов функции <CODE>show_props(myCar, "myCar")</CODE> возвратит:</p>
<PRE><A NAME="1008324"></a>myCar.make = Ford<br>myCar.model = Mustang<br>myCar.year = 1967</PRE>
<H2><A NAME="Creating New Objects"><A NAME="1008327"></a>Создание новых объектов</H2><hr><p><A NAME="1010155"></a>
В JavaScript имеются предопределённые объекты. Кроме того, Вы можете создавать 
Ваши собственные объекты. В JavaScript&nbsp;1.2 Вы можете создавать объект с 
использованием инициализатора объекта. Альтернативно, Вы можете сначала создать 
функцию-конструктор, а затем инстанциировать объект с использованием этой 
функции и операции <CODE>new</CODE>.</p>
<H3><A NAME="Head2;"></a><A NAME="1008330"></a>Использование инициализаторов объектов</H3><hr><p><A NAME="1016607"></a>
Помимо создания объектов с использованием функции-конструктора, Вы можете 
создавать объекты с использованием инициализатора объекта. Использование 
инициализаторов объектов иногда называют созданием объектов с помощью 
литеральной нотации. "Инициализатор объекта" составлен в терминологии C++.</p><p><A NAME="1016611"></a>
Синтаксис объекта, использующего инициализатор объекта, таков:</p>
<PRE><A NAME="1016612"></a>objectName = {property1:value1, property2:value2,..., property<I>N</I>:value<I>N</I>}</PRE>
<p><A NAME="1008340"></a>где <CODE>objectName</CODE> это имя нового объекта, каждое <CODE>property</CODE><I><CODE>I</CODE></I>&nbsp; 
это идентификатор (имя, число или строковой литерал), а каждое <CODE>value</CODE><I><CODE>I</CODE></I>&nbsp; 
это выражение, значение которого присваивается свойству <CODE>property</CODE><I><CODE>I</CODE></I>.<br>
<CODE>objectName</CODE> и присвоение не обязательны. Если Вам не нужно ссылаться 
на данный объект, Вы можете не присваивать его переменной.</p><p><A NAME="1008341"></a>
Если объект создаётся инициализатором в скрипте верхнего уровня, JavaScript 
интерпретирует этот объект всякий раз при вычислении выражения, содержащего 
литерал объекта. К тому же инициализатор, используемый в функции, создаётся при каждом вызове функции.</p><p><A NAME="1016636"></a>
Этот оператор создаёт объект и присваивает его переменной <CODE>x</CODE>, если, и только если, выражение <CODE>cond</CODE> - true.</p>
<PRE><A NAME="1010172"></a>if (cond) x = {hi:"there"}</PRE><p><A NAME="1008345"></a>
Следующий пример создаёт <CODE>myHonda</CODE> с тремя свойствами. Заметьте, что 
свойство <CODE>engine</CODE> является также объектом со своими собственными свойствами. </p>
<PRE><A NAME="1008346"></a>myHonda = {color:"red",wheels:4,engine:{cylinders:4,size:2.2}}</PRE>
<p><A NAME="1016639"></a>Вы можете также использовать инициализаторы объектов для создания массивов. См. <A HREF="ident.php#1011655">"Литералы 
Массива"</a>.</p><p><B><A NAME="HeadRunIn;"></a><A NAME="1016568"></a>
JavaScript 1.1 и предыдущие версии. </B><A NAME="1016569"></a>
Вы не можете использовать инициализаторы объектов. Вы можете создавать объекты 
только путём использования функций-конструкторов или функцией, предоставляемой 
другим объектом для этой цели. См. <A HREF="#1008361">"Использование Функции-Конструктора&quot;</a>.</p>
<H3><A NAME="Head2;"></a><A NAME="1008361"></a>Использование функции-конструктора</H3><hr><p><A NAME="1008362"></a>
Альтернативно можно создавать объект в два этапа:</p><OL><LI><A NAME="1008363"></a>
Определить тип объекта, написав функцию-конструктор.</LI><LI><A NAME="1008365"></a>
  Создать экземпляр объекта с помощью операции <CODE>new</CODE>.</LI></OL><p><A NAME="1008366"></a>
Для того чтобы определить тип объекта, создайте функцию для типа объекта, 
которая специфицирует имя, свойства и методы. Например, Вы хотите создать тип 
объекта для автомобилей/cars. Вы называете тип объекта <CODE>car</CODE> и 
хотите, чтобы у него были свойства make, model, year и color. Для реализации 
этого Вы должны написать следующую функцию:</p>
<PRE><A NAME="1008367"></a>function car(make, model, year) {<br>&nbsp;&nbsp;&nbsp;this.make = make<br>&nbsp;&nbsp;&nbsp;this.model = model<br>&nbsp;&nbsp;&nbsp;this.year = year<br>}</PRE>
<p><A NAME="1008369"></a>Обратите внимание на использование <CODE>this</CODE> для присвоения значений 
свойствам объекта на основе значений, передаваемых в функцию.</p><p><A NAME="1008370"></a>
Теперь Вы можете создать объект <CODE>mycar</CODE>:</p>
<PRE><A NAME="1008371"></a>mycar = new car("Eagle", "Talon TSi", 1993)</PRE>
<p><A NAME="1008372"></a>Этот оператор создаёт объект <CODE>mycar</CODE> и присваивает специфицированные 
значения его свойствам. Тогда значением <CODE>mycar.make</CODE> будет строка &quot;Eagle", <CODE>mycar.year</CODE> 
это целое число 1993 и так далее.</p><p><A NAME="1008373"></a>
Вы можете создать любое количество объектов <CODE>car</CODE> через вызов <CODE>new</CODE>. Например,</p>
<PRE><A NAME="1008374"></a>kenscar = new car("Nissan", "300ZX", 1992)<br>vpgscar = new car("Mazda", "Miata", 1990)</PRE>
<p><A NAME="1008375"></a>Объект может иметь свойство, которое само является объектом. Например, Вы 
определяете объект <CODE>person</CODE>:</p>
<PRE><A NAME="1008376"></a>function person(name, age, sex) {<br>&nbsp;&nbsp;&nbsp;this.name = name<br>&nbsp;&nbsp;&nbsp;this.age = age<br>&nbsp;&nbsp;&nbsp;this.sex = sex<br>}</PRE>
<p><A NAME="1008377"></a>и инстанциируете два новых <CODE>person</CODE>-объекта:</p>
<PRE><A NAME="1008378"></a>rand = new person("Rand McKinnon", 33, "M")<br>ken = new person("Ken Jones", 39, "M")</PRE>
<p><A NAME="1008379"></a>Затем Вы можете переписать определение <CODE>car</CODE> и включить в него 
свойство <CODE>owner</CODE>, которое принимает <CODE>person</CODE>-объект:</p>
<PRE><A NAME="1008380"></a>function car(make, model, year, owner) {<br>&nbsp;&nbsp;&nbsp;this.make = make<br>&nbsp;&nbsp;&nbsp;this.model = model<br>&nbsp;&nbsp;&nbsp;this.year = year<br>&nbsp;&nbsp;&nbsp;this.owner = owner<br>}</PRE>
<p><A NAME="1008381"></a>Теперь можно инстанциировать новые объекты:</p>
<PRE><A NAME="1008382"></a>car1 = new car("Eagle", "Talon TSi", 1993, rand)<br>car2 = new car("Nissan", "300ZX", 1992, ken)</PRE>
<p><A NAME="1008383"></a>Обратите внимание, что вместо передачи литеральной строки или целочисленного 
значения при создании новых объектов, эти операторы передают объекты <CODE>rand</CODE> 
и <CODE>ken</CODE> как аргументы для owner. Затем, если Вы хотите вычислить имя 
владельца автомобиля car2, Вы можете получить доступ к следующему свойству:</p>
<PRE><A NAME="1008384"></a>car2.owner.name</PRE><p><A NAME="1008386"></a>
Заметьте, что Вы всегда можете добавить свойство к ранее определённому объекту. Например, оператор</p>
<PRE><A NAME="1008387"></a>car1.color = "black"</PRE><p><A NAME="1008388"></a>
добавляет свойство <CODE>color</CODE> объекту car1 и присваивает ему значение "black." 
Однако это не влияет на все другие объекты. Для добавления свойства всем 
объектам данного типа Вы должны добавить свойство в определение типа объекта <CODE>car</CODE>.</p>
<H3><A NAME="Head2;"></a><A NAME="1008392"></a>Индексирование свойств объекта</H3><hr><p><A NAME="1008393"></a>
В JavaScript 1.0 Вы можете обратиться к свойствам объекта по имени или по 
индексу. В JavaScript 1.1 или позднее, однако, если Вы первоначально определили 
свойство по имени, Вы обязаны всегда обращаться к нему по имени и, если Вы 
первоначально определили свойство по индексу, Вы обязаны всегда обращаться к нему по индексу.</p><p><A NAME="1008394"></a>
Это применяется при создании объекта и его свойств функцией-конструктором, как в 
предыдущем примере с типом объектов <CODE>сar</CODE>, и при определении 
индивидуальных свойств явным образом (например, <CODE>myCar.color = "red"</CODE>). 
Так, если Вы определяет первоначально свойства объекта индексированием, как <CODE>myCar[5] = "25 mpg"</CODE>, Вы 
в дальнейшем обращаетесь к свойству <CODE>myCar[5]</CODE>.</p><p><A NAME="1008395"></a>
Исключением из этого правила является объект, отражённый из HTML, такой как 
массив <CODE>forms</CODE>. Вы можете всегда обратиться к объектам в этих 
массивах по порядковому номеру (в зависимости от места в документе) или по 
именам (если определены). Например, если второй тэг <CODE>&lt;FORM&gt;</CODE> в 
документе имеет в атрибуте <CODE>NAME</CODE> значение "myForm", Вы можете 
обратиться к форме <CODE>document.forms[1]</CODE> or <CODE>document.forms["myForm"]</CODE> 
или <CODE>document.myForm</CODE>.</p><H3><A NAME="Head2;"></a><A NAME="1008397"></a>Определение свойств для типа объектов</H3>
<hr><p><A NAME="1008398"></a>Вы можете добавить свойство к ранее определённому типу объектов, используя 
свойство <CODE>prototype</CODE>. Оно определяет свойство, которое используется 
всеми объектами специфицированного типа, а не только одним экземпляром объекта. Следующий код 
добавляет свойство <CODE>color</CODE> всем объектам типа <CODE>car</CODE> и 
присваивает значение свойства <CODE>color</CODE> объекту <CODE>car1</CODE>.</p>
<PRE><A NAME="1008404"></a>Car.prototype.color=null<br>car1.color="black"</PRE>
<p><A NAME="1009697"></a>См. свойство <CODE>prototype</CODE> объекта <CODE>Function</CODE> в книге <I>
<a TARGET="_top" href="index.php">Клиентский JavaScript. Справочник.</a></I></p>
<H3><A NAME="Head2;"></a><A NAME="1008406"></a>Определение методов</H3><hr><p><A NAME="1008407"></a>
<i>Метод</i> это функция, ассоциированная с объектом. Вы определяете метод так 
же, как и стандартную функцию. Затем Вы используете для ассоциирования функции с 
существующим объектом следующий синтаксис:</p>
<PRE><A NAME="1008408"></a>object.methodname = function_name</PRE><p><A NAME="1008409"></a>
где <CODE>object</CODE> это существующий объект, <CODE>methodname</CODE> это 
имя, присвоенное Вами методу, а <CODE>function_name</CODE> это имя функции.</p><p><A NAME="1008410"></a>
Вы можете затем вызвать метод в контексте объекта:</p><PRE><A NAME="1008411"></a>object.methodname(params);</PRE>
<p><A NAME="1008412"></a>Вы можете определить методы для типа объектов, включив определение метода в 
функцию-конструктор. Например, Вы могли бы определить функцию форматирования и 
отображения свойств ранее определённых объектов <CODE>car</CODE>; например,</p>
<PRE><A NAME="1008413"></a>function displayCar() {<br>&nbsp;&nbsp;&nbsp;var result = "A Beautiful " + this.year + " " + this.make <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;+ " " + this.model<br>&nbsp;&nbsp;&nbsp;pretty_print(result)<br>}</PRE>
<p><A NAME="1008417"></a>где <CODE>pretty_print</CODE> это функция для отображения горизонтальной линии и 
строки. Обратите внимание на использование <CODE>this</CODE> для обращения к объекту, которому принадлежит данный метод.</p>
<p><A NAME="1008419"></a>Вы можете сделать эту функцию методом объектов типа <CODE>car</CODE>, добавив оператор</p>
<PRE><A NAME="1008420"></a>this.displayCar = displayCar;</PRE><p><A NAME="1008421"></a>
к определению типа объектов. Так, полное определение <CODE>car</CODE> теперь будет выглядеть:</p>
<PRE><A NAME="1008422"></a>function car(make, model, year, owner) {<br>&nbsp;&nbsp;&nbsp;this.make = make<br>&nbsp;&nbsp;&nbsp;this.model = model<br>&nbsp;&nbsp;&nbsp;this.year = year<br>&nbsp;&nbsp;&nbsp;this.owner = owner<br>&nbsp;&nbsp;&nbsp;this.displayCar = displayCar<br>}</PRE>
<p><A NAME="1008423"></a>Затем можно вызвать метод <CODE>displayCar</CODE> для каждого объекта:</p>
<PRE><A NAME="1008424"></a>car1.displayCar()<br>car2.displayCar()</PRE><p><A NAME="1008428"></a>
Это даст вывод показанный на рисунке.</p><h6><A NAME="1008433"></a>Рисунок 7.1&nbsp;&nbsp;&nbsp;Вывод метода</h6>
<P><IMG SRC="graphics/obj.gif" width="367" height="191"></a></P><H3><A NAME="Head2;"></a>
<A NAME="1008434"></a>Использование this для ссылок на объект</H3><hr><p><A NAME="1008436"></a>В
JavaScript имеется специальное слово <CODE>this</CODE>, которое можно 
использовать в методе для обращения к текущему объекту. Например, у Вас имеются: 
функция <CODE>validate</CODE> для проверки свойства <CODE>value</CODE> объекта, объект и значения high и low:</p>
<PRE><A NAME="1008437"></a>function validate(obj, lowval, hival) {<br>&nbsp;&nbsp;&nbsp;if ((obj.value &lt; lowval) || (obj.value &gt; hival))<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;alert("Invalid Value!")<br>}</PRE>
<p><A NAME="1008438"></a>Затем Вы можете вызывать <CODE>validate</CODE> в обработчике события <CODE>onChange</CODE> 
каждого элемента формы, используя <CODE>this</CODE> для передачи ему элемента формы, как в следующем примере:</p>
<PRE><A NAME="1008439"></a>&lt;INPUT TYPE="text" NAME="age" SIZE=3 <br>&nbsp;&nbsp;&nbsp;onChange="validate(this, 18, 99)"&gt;</PRE>
<p><A NAME="1008440"></a>В общем случае, <CODE>this</CODE> ссылается в методе на вызывающий объект.</p><p><A NAME="1008441"></a>
При сочетании со свойством <CODE>form</CODE>, <CODE>this</CODE> может ссылаться 
на родительскую форму текущего объекта. В следующем примере, форма <CODE>myForm</CODE> 
содержит <CODE>Text</CODE>-объект и кнопку. Когда пользователь нажимает кнопку, 
в значение <CODE>Text</CODE>-объекта устанавливается имя формы. Обработчик <CODE>onClick</CODE> 
кнопки использует <CODE>this.form</CODE> для обращения к родительской форме, <CODE>myForm</CODE>.</p>
<PRE><A NAME="1008442"></a>&lt;FORM NAME="myForm"&gt;<br>Form name:&lt;INPUT TYPE="text" NAME="text1" VALUE="Beluga"&gt;<br>&lt;P&gt;<br>&lt;INPUT NAME="button1" TYPE="button" VALUE="Show Form Name"<br>&nbsp;&nbsp;&nbsp;onClick="this.form.text1.value=this.form.name"&gt;<br>&lt;/FORM&gt;</PRE>
<H3><A NAME="Head2;"></a><A NAME="1008445"></a>Удаление объектов</H3><hr><p><A NAME="1016365"></a>
Вы можете удалить объект оператором <CODE>delete</CODE>. Следующий код показывает, как удалить объект.</p>
<PRE><A NAME="1016392"></a>myobj=new Number()<br>delete myobj &nbsp;&nbsp;// удаляет объект и возвращает true</PRE>
<p><A NAME="1017136"></a>См. также <A HREF="expr.php#1008702">"delete"</a>.</p><p><B><A NAME="HeadRunIn;"></a>
<A NAME="1016376"></a>JavaScript 1.1. </B><A NAME="1016377"></a>Вы можете удалить объект, установив ссылку на объекта в null (если это последняя 
ссылка на объект). JavaScript &quot;финализирует&quot; объект немедленно, как часть операции присвоения.</p>
<p><B><A NAME="HeadRunIn;"></a><A NAME="1010303"></a>JavaScript 1.0. </B><A NAME="1010315"></a>
Вы не можете удалять объекты - они существуют, пока Вы не выйдете со страницы.</p><H2><A NAME="Predefined Core Objects">
<A NAME="1010352"></a>Предопределённые объекты ядра</H2><hr><p><A NAME="1013801"></a>
В этом разделе рассматриваются предопределённые объекты ядра JavaScript: <CODE>Array</CODE>, <CODE>Boolean</CODE>, <CODE>Date</CODE>, <CODE>Function</CODE>, <CODE>Math</CODE>, <CODE>Number</CODE>, <CODE>RegExp</CODE> 
и <CODE>String</CODE>. Предопределённые клиентские объекты рассматриваются в <A HREF="navobj.php#1005423">
Главе 11, "Использование Объектов Navigator&#39;а&quot;</a>.</p><H3><A NAME="Head2;"></a>
<A NAME="1008453"></a>Объект Array</H3><hr><p><A NAME="1008454"></a>В JavaScript нет типа данных array (массив). Однако Вы может использовать 
предопределённый объект <CODE>Array</CODE> и его методы для работы с массивами в 
Ваших приложениях. Объект <CODE>Array</CODE> имеет методы для работы с 
массивами: объединения, разворачивания и сортировки. Он имеет свойство для 
определения размера массива и другие свойства для использования с регулярными выражениями.</p><p><A NAME="1016713"></a>
<i>Массив</i> это упорядоченный набор значений, к которым Вы обращаетесь по 
индексу или по имени. Например, у Вас имеется массив <CODE>emp</CODE>, в котором 
содержатся имена служащих, индексированные числом. Так, <CODE>emp[1]</CODE> это 
служащий номер 1, <CODE>emp[2]</CODE> - служащий номер 2 и так далее.</p><H4><A NAME="Head3;"></a>
<A NAME="1016718"></a>Создание массива</H4><hr><p><A NAME="1016715"></a>Создание <CODE>Array</CODE>-объекта:</p>
<PRE><A NAME="1008459"></a>1. arrayObjectName = new Array(element0, element1, ..., element<I>N</I>)<br>2. arrayObjectName = new Array(arrayLength)</PRE>
<p><A NAME="1008460"></a><CODE>arrayObjectName</CODE> это либо имя нового объекта, либо свойство 
существующего объекта. При использовании свойств и методов объекта <CODE>Array</CODE>, <CODE>arrayObjectName</CODE> 
это либо имя существующего <CODE>Array</CODE>-объекта, либо свойство существующего объекта.</p>
<p><A NAME="1008461"></a><CODE>element0, element1, ..., element</CODE><I><CODE>N</CODE></I>&nbsp; это 
список значений для элементов массива. Если специфицирована эта форма, массив 
инициализируется специфицированными значениями в качестве его элементов, а в 
свойство <CODE>length</CODE> массива устанавливается количество аргументов.</p><p><A NAME="1009639"></a>
<CODE>arrayLength</CODE> это начальный размер массива. Следующий код создаёт массив из 5 элементов:</p>
<PRE><A NAME="1009640"></a>billingMethod = new Array(5)</PRE><p><A NAME="1016735"></a>
Литералы массива также являются <CODE>Array</CODE>-объектами; например, 
следующий литерал является <CODE>Array</CODE>-объектом.</p><PRE><A NAME="1016774"></a>coffees = ["French Roast", "Columbian", "Kona"]</PRE>
<p>См. также <A HREF="ident.php#1011655">"Литералы Массива"</a>.</p><H4><A NAME="Head3;"></a>
<A NAME="1016745"></a>Наполнение массива</H4><hr><p><A NAME="1016746"></a>Вы можете наполнить массив, присвоив значения его элементам. Например,</p>
<PRE><A NAME="1016747"></a>emp[1] = "Casey Jones"<br>emp[2] = "Phil Lesh"<br>emp[3] = "August West"</PRE>
<p><A NAME="1016748"></a>Вы может наполнить массив также при его создании:</p>
<PRE><A NAME="1016749"></a>myArray = new Array("Hello", myVar, 3.14159)</PRE><H4><A NAME="Head3;"></a>
<A NAME="1016756"></a>Обращение к элементам массива</H4><hr><p><A NAME="1016757"></a>Вы обращаетесь к элементам массива по порядковому номеру элемента. Например, Вы 
определили следующий массив:</p><PRE><A NAME="1016758"></a>myArray = new Array("Wind","Rain","Fire")</PRE>
<p><A NAME="1016759"></a>Затем Вы обращаетесь к первому элементу массива <CODE>myArray[0]</CODE>, а ко второму 
элементу - <CODE>myArray[1]</CODE>.</p><p><A NAME="1016760"></a>
Индексы массива начинаются от 0, но размер массива (например, <CODE>myArray.length</CODE>) 
отражает реальное количество элементов массива.</p><H4><A NAME="Head3;"></a>
<A NAME="1016725"></a>Методы объекта Array</H4><hr><p><A NAME="1008467"></a>Объект <CODE>Array</CODE> имеет следующие методы:</p>
<ul><LI><A NAME="1008468"></a><CODE>concat&nbsp;&nbsp;&nbsp; </CODE>объединяет два массива и возвращает новый 
массив.<LI><A NAME="1008469"></a><CODE>join&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </CODE>объединяет все элементы массива 
в строку.</LI><LI><A NAME="1008470"></a>
<CODE>pop</CODE>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
удаляет последний элемент массива и возвращает этот элемент.</LI><LI><A NAME="1008471"></a>
<CODE>push</CODE>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
добавляет один или более элементов в конец массива и возвращает этот 
добавленный элемент.</LI><LI><A NAME="1008472"></a>
<CODE>reverse</CODE>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; разворачивает элементы 
массива: первый элемент становится последним, а последний - первым.</LI><LI><A NAME="1008473"></a>
<CODE>shift</CODE>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; удаляет 
первый элемент массива и возвращает этот элемент.</LI><LI><A NAME="1008474"></a>
<CODE>slice</CODE>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
извлекает раздел массива возвращает новый массив.</LI><LI><A NAME="1008475"></a>
<CODE>splice</CODE>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; добавляет и/или 
удаляет элементы массива.</LI><LI><A NAME="1008476"></a>
<CODE>sort</CODE>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
сортирует элементы массива.</LI><LI><A NAME="1008477"></a>
<CODE>unshift</CODE>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; прибавляет один или более 
элементов в начало массива и возвращает новый размер массива.</LI></ul><p><A NAME="1008478"></a>Например, Вы определили массив:</p>
<PRE><A NAME="1008479"></a>myArray = new Array("Wind","Rain","Fire")</PRE>
<p><A NAME="1008480"></a><CODE>myArray.join()</CODE> возвращает "Wind,Rain,Fire";<br>
<CODE>myArray.reverse</CODE> разворачивает массив; <CODE>myArray[0]</CODE> 
становится "Fire", <CODE>myArray[1]</CODE> - "Rain", а <CODE>myArray[2]</CODE> - "Wind".<br>
<CODE>myArray.sort</CODE> сортирует массив; <CODE>myArray[0]</CODE> становится "Fire", <CODE>myArray[1]</CODE> 
- "Rain", а <CODE>myArray[2]</CODE> - "Wind".</p><H4><A NAME="Head3;"></a><A NAME="1009661"></a>Двухмерные массивы</H4>
<hr><p><A NAME="1009662"></a>Следующий код создаёт двухмерный массив:</p>
<PRE><A NAME="1008488"></a>a = new Array(4)<br>for (i=0; i &lt; 4; i++) {<br>&nbsp;&nbsp;&nbsp;a[i] = new Array(4)<br>&nbsp;&nbsp;&nbsp;for (j=0; j &lt; 4; j++) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;a[i][j] = "["+i+","+j+"]"<br>&nbsp;&nbsp;&nbsp;}<br>}</PRE>
<p><A NAME="1017774"></a>Следующий код выводит массив:</p>
<PRE><A NAME="1017775"></a>for (i=0; i &lt; 4; i++) {<br>&nbsp;&nbsp;&nbsp;str = "Row "+i+":"<br>&nbsp;&nbsp;&nbsp;for (j=0; j &lt; 4; j++) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;str += a[i][j]<br>&nbsp;&nbsp;&nbsp;}<br>&nbsp;&nbsp;&nbsp;document.write(str,"&lt;p&gt;")<br>}</PRE>
<p><A NAME="1017776"></a>Будет выведено:</p>
<PRE><A NAME="1017777"></a>Row 0:[0,0][0,1][0,2][0,3]<br>Row 1:[1,0][1,1][1,2][1,3]<br>Row 2:[2,0][2,1][2,2][2,3]<br>Row 3:[3,0][3,1][3,2][3,3]</PRE>
<H4><A NAME="Head3;"></a><A NAME="1008496"></a>Массивы и регулярные выражения</H4><hr><p><A NAME="1008497"></a>
Если массив является результатом совпадения регулярного выражения и строки , 
этот массив возвращает свойства и элементы, которые предоставляют информацию о 
совпадении. Массив является тогда return-значением <CODE>regexp.exec</CODE>, <CODE>string.match</CODE> 
и <CODE>string.replace</CODE>. Об использовании массивов с регулярными 
выражениями см. <A HREF="regexp.php#1010922">Главу 4 &quot;Регулярные Выражения&quot;</a>.</p>
<H3><A NAME="Head2;"></a><A NAME="1008502"></a>Объект Boolean</H3><hr><p><A NAME="1008503"></a>
Объект <CODE>Boolean</CODE> является оболочкой вокруг примитивного типа данных Boolean. 
Используйте следующий синтаксис для создания <CODE>Boolean</CODE>-объекта:</p>
<PRE><A NAME="1008505"></a>booleanObjectName = new Boolean(value)</PRE><p><A NAME="1016879"></a>
Не путайте примитивные Boolean-значения true и false со значениями true и false объекта <CODE>Boolean</CODE>. 
Любой объект, значение которого не <CODE>undefined</CODE> или <CODE>null</CODE>, 
и не объект <CODE>Boolean</CODE> со значением false, вычисляется в true, когда передаётся в условный оператор. 
См. <A HREF="stmtsov.php#1008323">"Оператор if...else"</a>.</p><H3><A NAME="Head2;"></a>
<A NAME="1008512"></a>Объект Date</H3><hr><p><A NAME="1008514"></a>В JavaScript 
нет типа данных data. Однако можно использовать объект <CODE>Date</CODE> 
и его методы для работы с датами и временем. Объект <CODE>Date</CODE> имеет 
большое количество методов для установки, получения и обслуживания дат.<br>Он не имеет свойств.</p><p><A NAME="1008515"></a>
JavaScript обрабатывает даты аналогично Java. Эти два языка имеют много 
одинаковых методов для дат и хранят даты как количество миллисекунд относительно 1 января 1970 года, 00:00:00.</p>
<p><A NAME="1008517"></a>Диапазон объекта <CODE>Date</CODE> от -100,000,000 до 100,000,000 дней относительно 01 January, 1970 UTC.</p>
<p><A NAME="1008519"></a>Для создания <CODE>Date</CODE>-объекта:</p><PRE><A NAME="1008520"></a>dateObjectName = new Date([parameters])</PRE>
<p><A NAME="1008521"></a>где <CODE>dateObjectName</CODE> это имя создаваемого <CODE>Date</CODE>-объект; 
это может быть новый объект или свойство существующего объекта.</p><p><A NAME="1008522"></a>Значение <CODE>parameters</CODE> может быть одним из:</p>
<ul><LI><A NAME="1008523"></a> Ничем: создаётся текущая дата и время. Например, <CODE>today = new Date()</CODE>.</LI><LI><A NAME="1008524"></a>
Строкой, представляющей дату в следующей форме: "Month day, year hours:minutes:seconds".<br>
Например, <CODE>Xmas95 = new Date("December 25, 1995 13:30:00")</CODE>.<br>
Если Вы опустите hours, minutes или seconds, значение будет установлено в 0.</LI><LI><A NAME="1008525"></a>
Набором целочисленных значений для year, month и day. Например, <CODE>Xmas95 = new Date(1995,11,25)</CODE>.<br>
Набором целочисленных значений для year, month, day, hour, minute и seconds. Например, <CODE>Xmas95 = new Date(1995,11,25,9,30,0)</CODE>.</LI></ul>
<p><B><A NAME="HeadRunIn;"></a><A NAME="1017659"></a>JavaScript 1.2 и предыдущие версии. </B><A NAME="1017660"></a>
Объект <CODE>Date</CODE> работает так:</p><ul><LI><A NAME="1017661"></a>
Даты до 1970 не допускаются.</LI><LI><A NAME="1017662"></a>
JavaScript зависит от платформы, на которой используется; поведение объекта <CODE>Date</CODE> 
  варьируется от платформы к платформе.</LI></ul>
<H4><A NAME="Head3;"></a><A NAME="1008526"></a>Методы объекта Date</H4><hr><p><A NAME="1008527"></a>
Методы объекта <CODE>Date</CODE> для работы с датами и временем распадаются на следующие обширные категории:</p>
<ul><LI><A NAME="1008528"></a>"set"-методы для установки значений объектов <CODE>Date</CODE>.</LI><LI><A NAME="1008529"></a>
"get"-методы для получения значений даты и времени из объектов <CODE>Date</CODE>.</LI><LI><A NAME="1008530"></a>
"to"-методы для возвращения строковых значений из объектов <CODE>Date</CODE>.</LI><LI><A NAME="1008531"></a>
parse и UTC-методы для разбора <CODE>Date</CODE>-строк.</LI></ul><p><A NAME="1008532"></a>
Методами "get" и "set" Вы можете получать и устанавливать значения для секунд, 
минут, часа, дня недели, числа месяца, месяца и года. Имеется метод <CODE>getDay</CODE>, 
который возвращает день недели, но нет па&#x0301;рного метода <CODE>setDay</CODE>, 
поскольку день недели устанавливается автоматически. Эти методы используют целые числа для представления этих значений:</p>
<ul><LI><A NAME="1008535"></a>Секунды и минуты: от 0 до 59</LI><LI><A NAME="1008536"></a>
Час: от 0 до 23</LI><LI><A NAME="1008537"></a>
День недели: от 0 (Sunday) до 6 (Saturday)</LI><LI><A NAME="1008538"></a>
Число месяца: от 1 до 31</LI><LI><A NAME="1008539"></a>
Месяц: от 0 (January) до 11 (December)</LI><LI><A NAME="1008540"></a>
Год: годы после 1900</LI></ul><p><A NAME="1008541"></a>Например,  Вы определили дату:</p>
<PRE><A NAME="1008542"></a>Xmas95 = new Date("December 25, 1995")</PRE><p><A NAME="1008543"></a>
Тогда <CODE>Xmas95.getMonth()</CODE> возвращает 11, а <CODE>Xmas95.getFullYear()</CODE> возвращает 95.</p>
<p><A NAME="1008546"></a>Методы <CODE>getTime</CODE> и <CODE>setTime</CODE> используются для сравнения 
дат. Метод <CODE>getTime</CODE> возвращает количество миллисекунд, прошедших 
после January 1, 1970, 00:00:00 для <CODE>Date</CODE>-объекта.</p><p><A NAME="1008547"></a>
Например, следующий код выводит количество дней оставшихся в текущем году:</p>
<PRE><A NAME="1008548"></a>today = new Date()<br>endYear = new Date(1995,11,31,23,59,59,999) // устанавливает день и месяц<br>endYear.setFullYear(today.getFullYear()) // устанавливает в year текущий год<br>msPerDay = 24 * 60 * 60 * 1000 // количество миллисекунд в сутках<br>daysLeft = (endYear.getTime() - today.getTime()) / msPerDay<br>daysLeft = Math.round(daysLeft) //возвращает количество оставшихся в году дней</PRE>
<p><A NAME="1008549"></a>Этот пример создаёт&nbsp; <CODE>Date</CODE>-объект <CODE>today</CODE>, который 
содержит текущую дату. Затем создаётся <CODE>Date</CODE>-объект <CODE>endYear</CODE> 
в него устанавливается значение текущего года. Далее, с использованием 
количества миллисекунд в сутки, вычисляется количество дней между текущей датой 
и <CODE>endYear</CODE>, с использованием <CODE>getTime</CODE>, которое затем округляется до целого количества суток.</p>
<p><A NAME="1008551"></a>Метод <CODE> parse</CODE> используется для присвоения значений из строк с датой 
существующим <CODE>Date</CODE>-объектам. Например, следующий код использует <CODE>parse</CODE> 
и <CODE>setTime</CODE> для присвоения значения даты объекту <CODE>IPOdate</CODE>:</p>
<PRE><A NAME="1008553"></a>IPOdate = new Date()<br>IPOdate.setTime(Date.parse("Aug 9, 1995"))</PRE><H4><A NAME="Head3;"></a>
<A NAME="1008554"></a>Использование объекта Date: пример</H4><hr><p><A NAME="1016971"></a>
В следующем примере функция <CODE>JSClock()</CODE> возвращает время в формате цифровых часов.</p>
<PRE><A NAME="1016947"></a>function JSClock() {<br>&nbsp;&nbsp;&nbsp;var time = new Date()<br>&nbsp;&nbsp;&nbsp;var hour = time.getHours()<br>&nbsp;&nbsp;&nbsp;var minute = time.getMinutes()<br>&nbsp;&nbsp;&nbsp;var second = time.getSeconds()<br>&nbsp;&nbsp;&nbsp;var temp = "" + ((hour &gt; 12) ? hour - 12 : hour)<br>&nbsp;&nbsp;&nbsp;temp += ((minute &lt; 10) ? ":0" : ":") + minute<br>&nbsp;&nbsp;&nbsp;temp += ((second &lt; 10) ? ":0" : ":") + second<br>&nbsp;&nbsp;&nbsp;temp += (hour &gt;= 12) ? " P.M." : " A.M."<br>&nbsp;&nbsp;&nbsp;return temp<br>}</PRE>
<p><A NAME="1008571"></a>Функция <CODE>JSClock</CODE> сначала создаёт новый <CODE>Date</CODE>-объект <CODE>time</CODE>; 
поскольку аргументы не заданы, объект создаётся с текущей датой и временем. 
Затем методы <CODE>getHours</CODE>, <CODE>getMinutes</CODE> и <CODE>getSeconds</CODE> 
присваивают значения текущих часа, минут и секунд переменным <CODE>hour</CODE>, <CODE>minute</CODE> и <CODE>second</CODE>.</p>
<p><A NAME="1008575"></a>Следующие четыре оператора строят строковое значение на основе этого времени.</p>
<p>Первый оператор создаёт переменную <CODE>temp</CODE>, присваивая ей значение 
условного выражения; если <CODE>hour</CODE> больше 12, (<CODE>hour</CODE> - 13), иначе просто <CODE>hour</CODE>.</p>
<p><A NAME="1008576"></a>Следующий оператор присоединяет значение <CODE>minute</CODE> к <CODE>temp</CODE>. 
Если значение <CODE>minute</CODE> меньше 10, условное выражение прибавляет 
строку с предшествующим 0; иначе добавляет строку с разделяющим двоеточием. 
Затем оператор присоединяет значение секунд к <CODE>temp</CODE> тем же способом.</p><p><A NAME="1008577"></a>
Наконец, условное выражение присоединяет "PM" к <CODE>temp</CODE>, если <CODE>hour</CODE> 
равно или больше 12; иначе присоединяет "AM" к <CODE>temp</CODE>.</p><H3><A NAME="Head2;"></a>
<A NAME="1008590"></a>Объект Function</H3><hr><p><A NAME="1008591"></a>
Предопределённый объект <CODE>Function</CODE> специфицирует строку кода JavaScript, компилируемую как функция.</p>
<p><A NAME="1008592"></a>Для создания <CODE>Function</CODE>-объекта:</p>
<PRE><A NAME="1008593"></a>functionObjectName = new Function ([arg1, arg2, ... argn], functionBody)</PRE>
<p><A NAME="1008594"></a><CODE>functionObjectName</CODE> это имя переменной или свойства существующего 
объекта. Это может быть также объект с последующим именем обработчика события в 
нижнем регистре, например, <CODE>window.onerror</CODE>.</p><p><A NAME="1008595"></a>
<CODE>arg1, arg2, ... argn</CODE> это аргументы, используемые функцией как имена 
формальных аргументов. Каждое обязано быть строкой, соответствующей верному 
идентификатору JavaScript; например "x" или "theForm".</p><p><A NAME="1008596"></a>
<CODE>functionBody</CODE> это строка, специфицирующая код JavaScript, компилируемый как тело функции.</p>
<p><A NAME="1008597"></a><CODE>Function</CODE>-объекты вычисляются при каждом использовании. Это менее 
эффективно, чем объявление функции и вызов её в коде, поскольку объявленная функция компилируется.</p><p><A NAME="1008598"></a>
Помимо рассмотренного здесь объявления, Вы можете также использовать оператор <CODE>function</CODE>. 
См. книгу <I><a TARGET="_top" href="index.php">Клиентский JavaScript. Справочник</a></I>.</p><p><A NAME="1008604"></a>
Следующий код присваивает функцию переменной <CODE>setBGColor</CODE>. Эта 
функция устанавливает цвет фона текущего документа.</p>
<PRE><A NAME="1008605"></a>var setBGColor = new Function("document.bgColor='antiquewhite'")</PRE>
<p><A NAME="1008606"></a>Для вызова <CODE>Function</CODE>-объекта Вы можете специфицировать имя 
переменной, как если бы это была функция. Следующий код выполняет функцию, 
специфицированную переменной <CODE>setBGColor</CODE>:</p>
<PRE><A NAME="1008607"></a>var colorChoice="antiquewhite"<br>if (colorChoice=="antiquewhite") {setBGColor()}</PRE>
<p><A NAME="1008608"></a>Вы можете присвоить функцию обработчику события одним из следующих способов:</p>
<PRE><A NAME="1008609"></a>1. document.form1.colorButton.onclick=setBGColor</PRE><PRE><A NAME="1017876"></a>2. &lt;INPUT NAME="colorButton" TYPE="button"<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;VALUE="Change background color"<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;onClick="setBGColor()"&gt;</PRE>
<p><A NAME="1008610"></a>Создание переменной <CODE>setBGColor</CODE>, показанное выше, похоже на объявление следующей функции:</p>
<PRE><A NAME="1008611"></a>function setBGColor() {<br>&nbsp;&nbsp;&nbsp;document.bgColor='antiquewhite'<br>}</PRE>
<p><A NAME="1017163"></a>Вы можете вкладывать функцию в функцию. Вложенная (внутренняя) функция является private 
для её содержащей (внешней) функции:</p><ul><LI><A NAME="1017164"></a>
Внутренняя функция доступна только для операторов внешней функции.</LI><LI><A NAME="1017165"></a>
Внутренняя функция может использовать аргументы и переменные внешней функции. 
Внешняя функция не может использовать аргументы и переменные внутренней функции.</LI></ul><H3><A NAME="Head2;"></a>
<A NAME="1008620"></a>Объект Math</H3><hr><p><A NAME="1008621"></a>
Предопределённый объект <CODE>Math</CODE> имеет свойства и методы для 
математических констант и функций. Например, свойство <CODE>PI</CODE> имеет 
значение pi (3.141...), которое Вы можете использовать в приложениях так:</p><PRE><A NAME="1008623"></a>Math.PI</PRE>
<p><A NAME="1008624"></a>Также и стандартные математические функции являются методами объекта <CODE>Math</CODE>. 
Сюда входят тригонометрические, логарифмические, экспоненциальные и др. функции. Например, 
если Вы хотите использовать тригонометрическую функцию sine/синус, Вы может записать:</p>
<PRE><A NAME="1008625"></a>Math.sin(1.56)</PRE><p><A NAME="1008626"></a>
Учтите, что все тригонометрические методы объекта <CODE>Math</CODE> принимают объекты в радианах.</p><p><A NAME="1008680"></a>
В таблице дано резюме по методам объекта <CODE>Math</CODE>.</p><A NAME="1010009"></a>
<h6 style="text-align: center"><A NAME="1008633"></a>Таблица 7.1 Методы объекта Math</h6><TABLE BORDER="2" CELLPADDING=5>
<TR><TH><A NAME="1008637"></a>Метод<TH><A NAME="1008639"></a>
Описание<TR><TD><PRE><A NAME="1008641"></a>abs</PRE><TD><P><A NAME="1008643"></a>Абсолютное значение</P>
<TR><TD><PRE><A NAME="1008645"></a>sin, cos, tan</PRE><TD><P><A NAME="1008647"></a>
Стандартные тригонометрические функции; аргумент в радианах</P>
<TR><TD><PRE><A NAME="1008649"></a>acos, asin, atan</PRE><TD><P><A NAME="1008651"></a>
Инверсные тригонометрические функции; return-значения в радианах</P>
<TR><TD><PRE><A NAME="1008653"></a>exp, log</PRE><TD><P><A NAME="1008655"></a>Экспоненциальный и натуральный логарифмы, база <CODE>e</CODE></P>
<TR><TD><PRE><A NAME="1008657"></a>ceil</PRE><TD><P><A NAME="1008659"></a>Возвращает наименьшее целое, больше и равное аргументу</P>
<TR><TD><PRE><A NAME="1008661"></a>floor</PRE><TD><P><A NAME="1008663"></a>Возвращает наибольшее целое, меньше и равное аргументу</P>
<TR><TD><PRE><A NAME="1008665"></a>min, max</PRE><TD><P><A NAME="1008667"></a>Возвращается больший или меньший (соответственно) из двух аргументов</P>
<TR><TD><PRE><A NAME="1008669"></a>pow</PRE><TD><P><A NAME="1008671"></a>Показатель степени; первый аргумент - база, второй - экспонента</P>
<TR><TD><PRE><A NAME="1008673"></a>round</PRE><TD><P><A NAME="1008675"></a>Округляет аргумент до ближайшего целого</P>
<TR><TD><PRE><A NAME="1008677"></a>sqrt</PRE><TD><P><A NAME="1008679"></a>Квадратный корень</P></TABLE>
<p><A NAME="1008681"></a>В отличие от многих других объектов, Вы никогда не создаёте собственные объекты <CODE>Math</CODE>. Вы 
всегда используете предопределённый объект <CODE>Math</CODE>.</p><p><A NAME="1008683"></a>
Часто бывает удобнее использовать этот объект с оператором <CODE>with</CODE>, 
когда большой участок кода использует математические константы и методы, чтобы 
не нужно было постоянно печатать "Math". Например,</p>
<PRE><A NAME="1008684"></a>with (Math) {<br>&nbsp;&nbsp;&nbsp;a = PI * r*r<br>&nbsp;&nbsp;&nbsp;y = r*sin(theta)<br>&nbsp;&nbsp;&nbsp;x = r*cos(theta)<br>}</PRE>
<H3><A NAME="Head2;"></a><A NAME="1008686"></a>Объект Number</H3><hr><p><A NAME="1008687"></a>
Объект <CODE>Number</CODE> имеет свойства для числовых констант, таких как 
максимальное значение, не-число и бесконечность. Вы не можете изменять эти значения и используете их так:</p>
<PRE><A NAME="1008688"></a>biggestNum = Number.MAX_VALUE<br>smallestNum = Number.MIN_VALUE<br>infiniteNum = Number.POSITIVE_INFINITY<br>negInfiniteNum = Number.NEGATIVE_INFINITY<br>notANum = Number.NaN</PRE>
<p><A NAME="1008689"></a>Вы всегда обращаетесь к свойствам предопределённого объекта <CODE>Number</CODE> 
так, как показано выше, а не как к свойствам <CODE>Number</CODE>-объекта, созданного Вами.</p><p><A NAME="1008723"></a>
В таблице дано резюме по свойствам объекта <CODE>Number</CODE>.</p><A NAME="1010022"></a>
<h6 style="text-align: center"><A NAME="1008696"></a>Таблица 7.2 Свойства объекта Number</h6><TABLE BORDER="2" CELLPADDING=5>
<TR><TH><A NAME="1008700"></a>Метод<TH><A NAME="1008702"></a>
Описание<TR><TD><PRE><A NAME="1008704"></a>MAX_VALUE</PRE><TD><P><A NAME="1008706"></a>Наибольшее представимое число</P>
<TR><TD><PRE><A NAME="1008708"></a>MIN_VALUE</PRE><TD><P><A NAME="1008710"></a>Наименьшее представимое число</P>
<TR><TD><PRE><A NAME="1008712"></a>NaN</PRE><TD><P><A NAME="1008714"></a>Специальное значение "not a number/не число"</P>
<TR><TD><PRE><A NAME="1008716"></a>NEGATIVE_INFINITY</PRE><TD><P><A NAME="1008718"></a>Специальное значение &quot;бесконечность&quot;; возвращается при переполнении</P>
<TR><TD><PRE><A NAME="1008720"></a>POSITIVE_INFINITY</PRE><TD><P><A NAME="1008722"></a>Специальное значение &quot;отрицательная бесконечность&quot;; возвращается при 
переполнении</P></TABLE><H3><A NAME="Head2;"></a><A NAME="1008724"></a>Объект RegExp</H3><hr><p><A NAME="1008725"></a>
Объект <CODE>RegExp</CODE> даёт возможность работать с регулярными выражениями. 
Он рассмотрен в <A HREF="regexp.php#1010922">Главе 4 "Регулярные Выражения&quot;</a>.</p><H3><A NAME="Head2;"></a>
<A NAME="1008731"></a>Объект String</H3><hr><p><A NAME="1008732"></a>
Объект <CODE>String</CODE> является оболочкой для примитивного типа данных string. 
Не путайте строковой литерал с объектом <CODE>String</CODE>. Например, следующий код 
создаёт строковой литерал <CODE>s1</CODE> и <CODE>String</CODE>-объект <CODE>s2</CODE>:</p>
<PRE><A NAME="1016978"></a>s1 = "foo" 		//создаёт строковое литеральное значение<br>s2 = new String("foo") //создаёт String-объект</PRE>
<p><A NAME="1016977"></a>Вы можете вызывать любой из методов объекта <CODE>String</CODE> в строковом 
литеральном значении - JavaScript автоматически конвертирует строковой литерал 
во временный <CODE>String</CODE>-объект, вызывает метод, затем уничтожает 
временный <CODE>String</CODE>-объект. Вы можете также использовать свойство <CODE>String.length</CODE> со строковым литералом.</p>
<p><A NAME="1017005"></a>Вы должны использовать строковые литералы, если только Вам не нужно обязательно 
использовать объект <CODE>String</CODE>, поскольку <CODE>String</CODE>-объекты 
могут иметь непредсказуемое поведение. Например:</p>
<PRE><A NAME="1017017"></a>s1 = "2 + 2" //создаёт строковое литеральное значение<br>s2 = new String("2 + 2")//создаёт String-объект<br>eval(s1) //возвращает число 4<br>eval(s2) //возвращает строку "2 + 2"</PRE>
<p><A NAME="1017046"></a>Объект <CODE>String</CODE> имеет одно свойство, <CODE>length</CODE>, которое 
обозначает количество символов в строке. Например, следующий код присваивает 
переменной <CODE>x</CODE> значение 13, поскольку "Hello, World!" состоит из 13 символов:</p>
<PRE><A NAME="1008742"></a>myString = "Hello, World!"<br>x = mystring.length</PRE>
<p><A NAME="1008744"></a>Объект <CODE>String</CODE> имеет методы двух типов: возвращающие вариации самой 
строки, такие как <CODE>substring</CODE> и <CODE>toUpperCase</CODE>, и 
возвращающие HTML-форматированную версию строки, такие как <CODE>bold</CODE> и <CODE>link</CODE>.</p>
<p><A NAME="1008745"></a>Например, используя предыдущий пример, и <CODE>mystring.toUpperCase()</CODE> и <CODE>"hello, world!".toUpperCase()</CODE> 
возвратят строку &quot;HELLO, WORLD!".</p><p><A NAME="1008746"></a>
Метод <CODE>substring</CODE> принимает два аргумента и возвращает подстроку 
между двумя аргументами. Используя предыдущий пример, <CODE>mystring.substring(4, 9)</CODE> возвращает 
строку &quot;o, Wo." См. метод <CODE>substring</CODE> объекта <CODE>String</CODE> в книге <I>
<a TARGET="_top" href="index.php">Клиентский JavaScript. Справочник</a></I>.</p><p><A NAME="1008752"></a>
Объект <CODE>String</CODE> также имеет несколько методов для автоматического HTML-форматирования, 
такие как <CODE>bold</CODE> для создания жирного начертания текста и <CODE>link</CODE> 
для создания гиперссылки. Например, Вы можете создать гиперссылку на воображаемый URL методом <CODE>link</CODE>:</p>
<PRE><A NAME="1008753"></a>mystring.link("http://www.helloworld.com")</PRE><p><A NAME="1008815"></a>
В таблице дано резюме по методам объекта <CODE>String</CODE>.</p><A NAME="1010032"></a>
<h6 style="text-align: center"><A NAME="1008760"></a>Таблица 7.3 Методы объекта String</h6>
<TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1008764"></a>Метод<TH><A NAME="1008766"></a>
Описание<TR><TD><PRE><A NAME="1008768"></a>anchor</PRE><TD><P><A NAME="1008770"></a>Создаёт именованный якорь HTML</P>
<TR><TD><PRE><A NAME="1008772"></a>big, blink, bold,<br>fixed, italics, small,<br>strike, sub, sup</PRE><TD><P><A NAME="1008774"></a>
Создают HTML-форматированную строку</P><TR><TD><PRE><A NAME="1008776"></a>charAt, charCodeAt</PRE><TD><P><A NAME="1008778"></a>
Возвращают символ или код символа в специфицированной позиции в строке</P>
<TR><TD><PRE><A NAME="1008780"></a>indexOf, lastIndexOf</PRE><TD><P><A NAME="1008782"></a>
Возвращают позицию специфицированной подстроки в строке или последнюю позицию специфицированной подстроки, соответственно</P>
<TR><TD><PRE><A NAME="1008784"></a>link</PRE><TD><P><A NAME="1008786"></a>
  Создаёт гиперссылку HTML</P>
<TR><TD><PRE><A NAME="1008788"></a>concat</PRE><TD><P><A NAME="1008790"></a>Комбинирует текст двух строк и возвращает новую строку</P>
<TR><TD><PRE><A NAME="1008792"></a>fromCharCode</PRE><TD><P><A NAME="1008794"></a>Конструирует строку из специфицированной последовательности кодовых значений 
набора ISO-Latin-1</P><TR><TD><PRE><A NAME="1008796"></a>split</PRE><TD><P><A NAME="1008798"></a>
Делит <CODE>String</CODE>-объект на массив строк, разделяя строку на подстроки</P>
<TR><TD><PRE><A NAME="1008800"></a>slice</PRE><TD><P><A NAME="1008802"></a>Извлекает участок строки и возвращает новую строку </P>
<TR><TD><PRE><A NAME="1008804"></a>substring, substr</PRE><TD><P><A NAME="1008806"></a>
Возвращают специфицированный поднабор строки, специфицируя индексы start и end или start-индекс и размер</P>
<TR><TD><PRE><A NAME="1008808"></a>match, replace, search</PRE><TD><P><A NAME="1008810"></a>
Используются для работы с регулярными выражениями</P>
<TR><TD><PRE><A NAME="1008812"></a>toLowerCase, toUpperCase</PRE><TD><P><A NAME="1008814"></a>
Возвращают строку в нижнем или верхнем регистре, соответственно</P></TABLE>
<h5><a href="contents.php">Оглавление</a> | <a href="fcns.php">Назад</a>
| <a href="obj2.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5>
<hr></BODY></HTML>
<?
include_once '../../sys/inc/tfoot.php';
?>