<?
include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/user.php';
$set['title']='Учебник JavaScript';
include_once '../../sys/inc/thead.php';
title();
err();
//aut();
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<phpl<TITLE>Регулярные Выражения</TITLE>
<BODY>
<h5><a href="contents.php">Оглавление</a> | <a href="expr.php">Назад</a>
| <a href="stmtsov.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5><HR>
<h1>Глава 4<BR><a name="1010922"></a>Регулярные Выражения</h1><p><A NAME="1012348"></a>
Регулярные выражения являются патэрнами, используемыми при поиске совпадений 
комбинаций символов в строках. В JavaScript регулярные выражения являются также 
объектами. Эти патэрны используются с методами exec и test объекта RegExp и с 
методами match, replace, search и split объекта String. В этой главы рассматриваются регулярные выражения JavaScript.</p>
<p><B><A NAME="HeadRunIn;"></a><A NAME="1012350"></a>
JavaScript 1.1 и более ранние версии. </B><A NAME="1012351"></a>
Регулярные выражения недоступны в JavaScript 1.1 и предыдущих версиях.</p><p><A NAME="1009793"></a>
В главе имеются следующие разделы:</p><ul><LI><A NAME="1009794"></a>
<A HREF="#1008311">Создание регулярного выражения</a></LI><LI><A NAME="1009795"></a>
<A HREF="#1010689">Написание патэрна регулярного выражения</a></LI><LI><A NAME="1009885"></a>
<A HREF="#1008506">Работа в регулярными выражениями</a></LI><LI><A NAME="1009891"></a>
<A HREF="#1008694">Примеры</a></LI></ul><H2><A NAME="Creating a Regular Expression"><A NAME="1008311"></a>
Создание регулярного выражения</H2><hr><p><A NAME="1008312"></a>
Вы конструируете регулярное выражение одним из двух способов:</p><ul><LI><A NAME="1008313"></a>
Используя инициализатор объекта:</LI><PRE><A NAME="1008314"></a>re = /ab+c/</PRE><A NAME="1008315"></a>
Инициализаторы объектов выполняют компиляцию регулярного выражения при вычислении скрипта. Если регулярное выражение является константным, 
используйте инициализатор для повышения производительности. Инициализаторы объектов обсуждаются в разделе <A HREF="obj.php#1008330">"Использование 
Инициализаторов Объектов"</a>.<LI><A NAME="1008316"></a>
Вызывая функцию-конструктор объекта <CODE>RegExp</CODE>:</LI><PRE><A NAME="1008317"></a>re = new RegExp("ab+c")</PRE><A NAME="1010687"></a>
Использование функции-конструктора предоставляет компиляцию регулярного
выражения на этапе прогона. Это делается, если известно, что патэрн
регулярного выражения будет изменяться, или если Вы не знаете патэрн и
получаете его из другого источника, такого как пользовательский ввод. После
того как регулярное выражение определено, и если оно используется в скрипте и
исходное значение изменяется, Вы можете использовать метод <CODE>compile</CODE>
для компиляции нового регулярного выражения для более эффективного многократного использования.</ul>
<H2><A NAME="Writing a Regular Expression Pattern"><A NAME="1010689"></a>Написание патэрна регулярного выражения</H2><hr>
<p><A NAME="1010690"></a>Патэрн регулярного выражения состоит из простых символов, например, <CODE>/abc/</CODE>, 
или из комбинаций простых и специальных символов, как <CODE>/ab*c/</CODE> или <CODE>/Chapter&nbsp;(\d+)\.\d*/</CODE>. 
В последнем примере имеются скобки, которые использованы как запоминающее 
устройство. Совпадение, сделанное этой частью патэрна, запоминается для 
последующего использования, как описано в разделе <A HREF="#1008659">"Использование Совпадений Подстрок в Скобках"</a>.</p>
<H3><A NAME="Head2;"></a><A NAME="1008325"></a>Использование простых патэрнов</H3><hr><p><A NAME="1008326"></a>
Простые патэрны состоят из символов, для которых ищется прямое совпадение. Например, 
патэрн <CODE>/abc/</CODE> совпадает с комбинацией символов в строке только 
тогда, когда символы 'abc' появляются вместе и в указанном порядке. Такое 
совпадение будет найдено в строках "Hi, do you know your abc's?&quot; и &quot;The latest 
airplane designs evolved from slabcraft.&quot; В обоих случаях имеется совпадение с 
подстрокой 'abc'. В строке &quot;Grab crab&quot; совпадения нет, потому что она не 
содержит подстроки 'abc'.</p><H3><A NAME="Head2;"></a>
<A NAME="1008327"></a>Использование специальных символов</H3><hr><p><A NAME="1008328"></a>
Если при поиске требуется выполнить нечто большее, чем простое совпадение, 
например, найти один или более символов b или найти пробелы, патэрн должен 
содержать специальные символы. Например, патэрн <CODE>/ab*c/</CODE> совпадает с 
любой комбинацией символов, в которой после одиночного 'a' следуют ноль или 
более 'b' (<CODE>*</CODE> означает 0 или более вхождений предыдущего символа) и 
символ 'c'. В строке &quot;cbbabbbbcdebc&quot; этот патэрн совпадает с подстрокой 'abbbbc'.</p>
<p><A NAME="1008332"></a>В таблице дан полный список - описание специальных символов, которые могут использоваться в регулярных выражениях.</p>
<A NAME="1009645"></a><h6 style="text-align: center"><A NAME="1008339"></a>
Таблица 4.1 Специальные символы в регулярных выражениях</h6><TABLE BORDER="2" CELLPADDING=5>
<TR><TH><B><A NAME="1008343"></a>Символ<TH><A NAME="1008345"></a>
Значение<TR><TD><PRE><A NAME="1008347"></a>\</PRE><TD><P><A NAME="1008349"></a>
Один из следующих вариантов:</P><ul></P><LI><A NAME="1010071"></a>
Для символов, которые обычно рассматриваются литерально, указывает, что 
следующий символ является специальным и не должен интерпретироваться литерально.<p><A NAME="1008350"></a>
Например, <CODE>/b/</CODE> совпадает с символом 'b'. При помещении символа backslash 
перед b, то есть <CODE>/\b/</CODE>, символ становится специальным, обозначая границу слова.</p>
<LI><A NAME="1010006"></a>Для символов, которые обычно рассматриваются как специальные, указывает что 
следующий символ не является специальным и должен интерпретироваться литерально.<p><A NAME="1010007"></a>
Например, <CODE>*</CODE> это специальный символ, который означает 0 или более 
совпадений с вхождением предыдущего символа; например, <CODE>/a*/</CODE> 
означает 0 или более символов а<CODE>.</CODE> Для подстановки <CODE>*</CODE> 
литерально, поставьте передним backslash; например, <CODE>/a\*/</CODE> совпадает с 'a*'.</p></ul>
<TR><TD><PRE><A NAME="1008355"></a>^</PRE><TD><P><A NAME="1008357"></a>
Совпадает с началом ввода или строки.</P><P><A NAME="1010069"></a></P><P><A NAME="1010070"></a>
Например, <CODE>/^A/</CODE> не совпадает с 'A' в строке "an A," но совпадает с 
первой А в строке "An A&quot;.</P><TR><TD><PRE><A NAME="1008360"></a>$</PRE><TD><P><A NAME="1008362"></a>
Совпадает с концом ввода или строки.</P><P><A NAME="1010068"></a></P><P><A NAME="1008363"></a>
Например, <CODE>/t$/</CODE> не совпадает с 't' в "eater", но совпадает в "eat".</P>
<TR><TD><PRE><A NAME="1008365"></a>*</PRE><TD><P><A NAME="1008367"></a>
Предшествующий символ совпадает 0 или более раз.</P><P><A NAME="1010078"></a></P><P><A NAME="1008368"></a>
Например, <CODE>/bo*/</CODE> совпадает с 'boooo' в "A ghost booooed" и с 'b' в "A bird warbled", 
но не совпадает в "A goat grunted".</P>
<TR><TD><PRE><A NAME="1008370"></a>+</PRE><TD><P><A NAME="1008372"></a>
Предшествующий символ совпадает 1 или более раз. Эквивалентно <CODE>{1,}</CODE>.</P><P><A NAME="1010079"></a>
</P><P><A NAME="1008373"></a>Например, <CODE>/a+/</CODE> совпадает с 'a' в "candy" and all the a's in "caaaaaaandy."</P>
<TR><TD><PRE><A NAME="1008375"></a>?</PRE><TD><P><A NAME="1008377"></a>
Предшествующий символ совпадает 0 или 1 раз.</P><P><A NAME="1010080"></a></P><P><A NAME="1008378"></a>
Например, <CODE>/e?le?/</CODE> совпадает с 'el' в "angel" и с 'le' в "angle."</P>
<TR><TD><PRE><A NAME="1008380"></a>.</PRE><TD><P><A NAME="1008382"></a>
(Десятичная точка) совпадает с любым одиночным символом, кроме символа новой строки.</P><P><A NAME="1010085"></a>
</P><P><A NAME="1008383"></a>Например, <CODE>/.n/</CODE> совпадает с 'an' и с 'on' в "nay, an apple is on the tree", 
но не с 'nay'.</P><TR><TD><PRE><A NAME="1008385"></a>(x)</PRE><TD><P><A NAME="1008387"></a>
Совпадает с 'x' и запоминает совпадение.</P><P><A NAME="1010086"></a></P><P><A NAME="1008388"></a>
Например, <CODE>/(foo)/</CODE> совпадает (и запоминает) с 'foo' в "foo bar." 
Совпавшая подстрока может быть вызвана из результирующего массива элементов <CODE>[1]</CODE>, ..., <CODE>[n]</CODE> 
или из свойств <CODE>$1</CODE><I>, ..., </I><CODE>$9</CODE> предопределённого объекта <CODE>RegExp</CODE>.</P>
<TR><TD><PRE><A NAME="1008390"></a>x|y</PRE><TD><P><A NAME="1008392"></a>
Совпадает с 'x' или с 'y'.</P><P><A NAME="1010087"></a></P><P><A NAME="1008393"></a>
Например, <CODE>/green|red/</CODE> совпадает с 'green' в "green apple" и с 'red' в "red apple."</P>
<TR><TD><PRE><A NAME="1008395"></a>{n}</PRE><TD><P><A NAME="1008397"></a>
Где <CODE>n</CODE> это положительное целое. Предшествующий символ совпадает точно <CODE>n</CODE> раз.</P><P><A NAME="1010088"></a>
</P><P><A NAME="1008398"></a>Например, <CODE>/a{2}/</CODE> не совпадает с 'a' в "candy&quot;, но совпадает со 
всеми 'a' в "caandy&quot; и с первыми двумя 'a' в "caaandy."</P>
<TR><TD><PRE><A NAME="1008400"></a>{n,}</PRE><TD><P><A NAME="1008402"></a>
Где <CODE>n</CODE> это положительное целое. Предшествующий символ совпадает 
как минимум <CODE>n</CODE> раз.</P><P><A NAME="1010089"></a></P><P><A NAME="1008403"></a>
Например, <CODE>/a{2,}</CODE> не совпадает с 'a' в "candy", но совпадает со всеми 'a' в "caandy" и в "caaaaaaandy."</P>
<TR><TD><PRE><A NAME="1008405"></a>{n,m}</PRE><TD><P><A NAME="1008407"></a>
Где <CODE>n</CODE> и <CODE>m</CODE> это положительные целые. Предшествующий 
символ совпадает как минимум <CODE>n</CODE> и максимум <CODE>m </CODE>раз.</P><P><A NAME="1010090"></a>
</P><P><A NAME="1008408"></a>Например, <CODE>/a{1,3}/</CODE> не совпадает ни с чем в "cndy", совпадает с 'a' 
in "candy," первыми двумя 'a' в "caandy&quot; и первыми тремя 'a' в "caaaaaaandy" 
Обратите внимание, что в "caaaaaaandy&quot; совпадает только "aaa", хотя строка-оригинал содержит больше символов 'a'.</P>
<TR><TD><PRE><A NAME="1008410"></a>[xyz]</PRE><TD><P><A NAME="1008412"></a>
Набор символов. Совпадает с любым одним из символов патэрна. Вы можете 
специфицировать диапазон символов, используя дефис.</P><P><A NAME="1010091"></a>
</P><P><A NAME="1008413"></a>Например, <CODE>[abcd]</CODE> эквивалентно <CODE>[a-d]</CODE>. Совпадает с 'b' в "brisket" 
и с 'c' в "ache"<CODE>.</CODE></P><TR><TD><PRE><A NAME="1008415"></a>[^xyz]</PRE><TD><P><A NAME="1008417"></a>
Отрицание набора символов. То есть совпадение со всем, кроме того, что 
находится в скобках. Вы можете специфицировать диапазон символов, используя дефис.</P><P><A NAME="1010092"></a>
</P><P><A NAME="1008418"></a>Например, <CODE>[^abc]</CODE> это то же самое, что <CODE>[^a-c]</CODE>. 
Первоначально совпадает с 'r' в "brisket" и с 'h' в "chop&quot;.</P><TR><TD><PRE><A NAME="1008420"></a>[\b]</PRE><TD><P><A NAME="1008422"></a>
Совпадает с backspace. (Не путайте с <CODE>\b</CODE>.)</P>
<TR><TD><PRE><A NAME="1008424"></a>\b</PRE><TD><P><A NAME="1008426"></a>
Совпадает с границей слова, такой как пробел/space или символ новой строки. (Не путайте с <CODE>[\b]</CODE>.)</P><P><A NAME="1010093"></a>
</P><P><A NAME="1008427"></a>Например, <CODE>/\bn\w/</CODE> совпадает с 'no' in "noonday";<CODE> /\wy\b/</CODE> 
совпадает с 'ly' in "possibly yesterday&quot;.</P><TR><TD><PRE><A NAME="1008429"></a>\B</PRE><TD><P><A NAME="1008431"></a>
Совпадает с не-границей слова.</P><P><A NAME="1010094"></a></P><P><A NAME="1008432"></a>
Например, <CODE>/\w\Bn/</CODE> совпадает с 'on' в "noonday&quot;; <CODE>/y\B\w/</CODE> 
совпадает с 'ye' в "possibly yesterday&quot;.</P><TR><TD><PRE><A NAME="1008434"></a>\c<I>X</I></PRE><TD><P><A NAME="1008436"></a>
Где <I>X</I> это управляющий символ. Совпадает с управляющим символом в строке.</P><P><A NAME="1010095"></a>
</P><P><A NAME="1008437"></a>Например, <CODE>/\cM/</CODE> совпадает с комбинацией control-M.</P>
<TR><TD><PRE><A NAME="1008439"></a>\d</PRE><TD><P><A NAME="1008441"></a>
Совпадает с цифрой. Эквивалентно <CODE>[0-9]</CODE>.</P><P><A NAME="1010115"></a></P><P><A NAME="1008442"></a>
Например, <CODE>/\d/</CODE> или <CODE>/[0-9]/</CODE> совпадает с '2' в строке "B2 is the suite number&quot;.</P>
<TR><TD><PRE><A NAME="1008444"></a>\D</PRE><TD><P><A NAME="1008446"></a>
Совпадает с не-цифрой. Эквивалентно <CODE>[^0-9]</CODE>.</P><P><A NAME="1010116"></a></P><P><A NAME="1008447"></a>
Например, <CODE>/\D/</CODE> или <CODE>/[^0-9]/</CODE> совпадает с 'B' в "B2 is the suite number&quot;.</P>
<TR><TD><PRE><A NAME="1008449"></a>\f</PRE><TD><P><A NAME="1008451"></a>
Совпадает с form-feed.</P><TR><TD><PRE><A NAME="1008453"></a>\n</PRE><TD><P><A NAME="1008455"></a>
Совпадает с linefeed.</P><TR><TD><PRE><A NAME="1008457"></a>\r</PRE><TD><P><A NAME="1008459"></a>
Совпадает с carriage return.</P><TR><TD><PRE><A NAME="1008461"></a>\s</PRE><TD><P><A NAME="1008463"></a>
Совпадает с одиночным пробельным символом, включая space, tab, form feed, line feed.<br>
Эквивалентно <CODE>[ \f\n\r\t\v]</CODE>.</P><P><A NAME="1010117"></a></P><P><A NAME="1008464"></a>
Например, <CODE>/\s\w*/</CODE> совпадает с ' bar' в "foo bar&quot;.</P>
<TR><TD><PRE><A NAME="1008466"></a>\S</PRE><TD><P><A NAME="1008468"></a>
Совпадает с одиночным символом, отличным от пробела. Эквивалентно <CODE>[^ \f\n\r\t\v]</CODE>.</P><P><A NAME="1010120"></a>
</P><P><A NAME="1008469"></a>Например, <CODE>/\S\w*/</CODE> совпадает с&nbsp; 'foo' в "foo bar."</P>
<TR><TD><PRE><A NAME="1008471"></a>\t</PRE><TD><P><A NAME="1008473"></a>Совпадает с tab.</P>
<TR><TD><PRE><A NAME="1008475"></a>\v</PRE><TD><P><A NAME="1008477"></a>Совпадает с vertical tab.</P>
<TR><TD><PRE><A NAME="1008479"></a>\w</PRE><TD><P><A NAME="1008481"></a>Совпадает с любым алфавитно-цифровым символом, включая символ подчёркивания. 
Эквивалентно <CODE>[A-Za-z0-9_]</CODE>.</P><P><A NAME="1010121"></a></P><P><A NAME="1008482"></a>
Например, <CODE>/\w/</CODE> совпадает с&nbsp; 'a' в "apple", с '5' в "$5.28&quot; и с '3' в "3D."</P>
<TR><TD><PRE><A NAME="1008484"></a>\W </PRE><TD><P><A NAME="1008486"></a>
Совпадает с любым не-алфавитно-цифровым символом. Эквивалентно <CODE>[^A-Za-z0-9_]</CODE>.</P><P><A NAME="1010122"></a>
</P><P><A NAME="1008487"></a>Например, <CODE>/\W/</CODE> или <CODE>/[^$A-Za-z0-9_]/</CODE> совпадает с '%' в "50%."</P>
<TR><TD><PRE><A NAME="1008489"></a>\<I>n</I></PRE><TD><P><A NAME="1008491"></a>
Где <I>n</I> это положительное целое. Обратная ссылка на последнее совпадение 
подстроки с <I>n</I> в скобках из регулярного выражения (с учётом левых скобок).</P><P><A NAME="1010123"></a>
</P><P><A NAME="1008492"></a>Например, <CODE>/apple(,)\sorange\1/</CODE> совпадает с 'apple, orange,' в "apple, orange, cherry, peach."<br>
Более сложный пример идёт далее после таблицы.</P><P><A NAME="1010133"></a></P><P><A NAME="1008493"></a>
<b>Примечание:</b> Если количество левых скобок меньше числа, 
специфицированного в \<I>n</I>, то \<I>n</I> считается восьмеричной escape-последовательностью, как описано в следующем ряду.</P>
<TR><TD><PRE><A NAME="1008495"></a>\o<I>octal<br></I>\x<I>hex</I></PRE><TD><P><A NAME="1008497"></a>
Где <CODE>\o</CODE><I><CODE>octal</CODE></I>&nbsp; это 8-ричное escape-значение 
или где <CODE>\x</CODE><I><CODE>hex</CODE></I>&nbsp; это 16-ричное escape-значение. 
Даёт возможность внедрять ASCII-коды в регулярные выражения.</P></TABLE><H3><A NAME="Head2;"></a>
<A NAME="1008498"></a>Использование скобок</H3><hr><p><A NAME="1008499"></a>
Скобки вокруг любой части патэрна регулярного выражения вызывают запоминание 
этой части совпавшей подстроки. После запоминания подстрока может быть вызвана 
для другого использования, как описано в разделе <A HREF="#1008659">"Использование Совпадений Подстроки в Скобках"</a>.</p>
<p><A NAME="1008503"></a>Например, патэрн <CODE>/Chapter&nbsp;(\d+)\.\d*/</CODE> иллюстрирует совпадение 
дополнительных заменяющих и специальных символов и указывает, что эту часть 
патэрна нужно запомнить. Совпадает с точно символами 'Chapter ' и последующими 
одной или более цифрами (<CODE>\d</CODE> означает любую цифру, а <CODE>+</CODE> 
означает 1 или более раз), с последующей десятичной точкой (которая является 
сама по себе специальным символом; поэтому её предшествует \ , что означает, что 
патэрн обязан искать литеральный символ '.'), с последующим цифровым символом, 0 
или более раз (<CODE>\d</CODE> означает цифру, <CODE>*</CODE> означает 0 или 
более раз). Кроме того, скобки используются для запоминания первых совпавших цифровых символов.</p><p><A NAME="1008504"></a>
Этот патэрн находит совпадение в "Open Chapter 4.3, paragraph 6", и '4' 
запоминается. Патэрн не находит совпадение в "Chapter 3 and 4", поскольку эта 
строка не содержит точку после '3'.</p><H2><A NAME="Working with Regular Expressions">
<A NAME="1008506"></a>Работа в регулярными выражениями</H2><hr><p><A NAME="1008507"></a>
Регулярные выражения используются с методами <CODE>test</CODE> и <CODE>exec</CODE> 
объекта <CODE>RegExp</CODE> и с методами <CODE>match</CODE>, <CODE>replace</CODE>, <CODE>search</CODE> 
и <CODE>split</CODE> объекта <CODE>String</CODE>. Эти методы детально 
рассмотрены в книге <I><a TARGET="_top" href="../clientref13/index.php">
Клиентский JavaScript. </a></I><a href="../clientref13/index.php"><i>Справочник</i></a>.</p>
<A NAME="1012481"></a><h6 style="text-align: center"><A NAME="1012488"></a>
Таблица 4.2 Методы, использующие регулярные выражения</h6><TABLE BORDER="2" CELLPADDING=5>
<TR><TH><a name="1012492"></a>Метод<TH><A NAME="1012494"></a>
Описание<TR><TD><PRE><A NAME="1012526"></a>exec</PRE><TD><P><A NAME="1012528"></a>
Метод объекта <CODE>RegExp</CODE>, выполняющий поиск совпадения в строке. Возвращает массив информации. </P>
<TR><TD><PRE><A NAME="1012530"></a>test</PRE><TD><P><A NAME="1012532"></a>
Метод объекта <CODE>RegExp</CODE>, тестирующий на наличие совпадений в строке. Возвращает true или false.</P>
<TR><TD><PRE><A NAME="1012534"></a>match</PRE><TD><P><A NAME="1012536"></a>
Метод объекта <CODE>String</CODE>, выполняющий поиск совпадения в строке. Возвращает массив информации, или null при отсутствии совпадения.</P>
<TR><TD><PRE><A NAME="1012538"></a>search</PRE><TD><P><A NAME="1012540"></a>
Метод объекта <CODE>String</CODE>, тестирующий на наличие совпадений в строке. 
Возвращает индекс совпадения или -1, если поиск завершился неудачно.</P>
<TR><TD><PRE><A NAME="1012572"></a>replace</PRE><TD><P><A NAME="1012574"></a>
Метод объекта <CODE>String</CODE>, выполняющий поиск совпадения в строке и 
заменяющий найденные подстроки замещающей подстрокой.</P>
<TR><TD><PRE><A NAME="1012568"></a>split</PRE><TD><P><A NAME="1012570"></a>
Метод объекта <CODE>String</CODE>, использующий регулярное выражение или 
фиксированную строку для разделения строки на массив подстрок.</P></TABLE><p><A NAME="1008538"></a>
Если Вам необходимо выяснить, найден ли патэрн в строке, используйте методы <CODE>test</CODE> 
или <CODE>search</CODE>; для получения большего количества информации (и более 
медленного выполнения) используйте методы <CODE>exec</CODE> или <CODE>match</CODE>.<br>
Если Вы используете <CODE>exec</CODE> или <CODE>match</CODE> и если совпадение 
найдено, эти методы возвращают массив и обновляют свойства ассоциированного 
объекта регулярного выражения и предопределённого объекта регулярного выражения, <CODE>RegExp</CODE>. 
Если совпадения нет, метод <CODE>exec</CODE> возвращает значение <CODE>null</CODE> (которое конвертируется в <CODE>false</CODE>).</p>
<p><A NAME="1008539"></a>В следующем примере скрипт использует метод <CODE>exec</CODE> для поиска совпадения в строке:</p>
<PRE><A NAME="1008540"></a>&lt;SCRIPT LANGUAGE="JavaScript1.2"&gt;<br>myRe=/d(b+)d/g;<br>myArray = myRe.exec("cdbbdbsbz");<br>&lt;/SCRIPT&gt;</PRE>
<p><A NAME="1008541"></a>Если Вам не нужен доступ к свойствам регулярного выражения, можно создать <CODE>myArray</CODE> таким скриптом:</p>
<PRE><A NAME="1008542"></a>&lt;SCRIPT LANGUAGE="JavaScript1.2"&gt;<br>myArray = /d(b+)d/g.exec("cdbbdbsbz");<br>&lt;/SCRIPT&gt;</PRE>
<p><A NAME="1008543"></a>Если Вы хотите иметь возможность рекомпиляции регулярного выражения, то вот ещё один скрипт:</p>
<PRE><A NAME="1008544"></a>&lt;SCRIPT LANGUAGE="JavaScript1.2"&gt;<br>myRe= new RegExp ("d(b+)d", "g:);<br>myArray = myRe.exec("cdbbdbsbz");<br>&lt;/SCRIPT&gt;</PRE>
<p><A NAME="1009660"></a>При выполнении скриптов производится поиск совпадения, возвращается массив и 
обновляются свойства, показанные в таблице.</p><A NAME="1009763"></a><h6 style="text-align: center"><A NAME="1009670"></a>
Таблица 4.3 Результаты выполнения регулярного выражения</h6><TABLE BORDER="2" CELLPADDING=5>
<TR><TH><A NAME="1009678"></a>Объект<TH><A NAME="1009680"></a>
Свойство или Индекс<TH><A NAME="1009682"></a>Описание<TH><A NAME="1009684"></a>
В данном примере<TR><TD VALIGN=baseline ALIGN=left COLSPAN=1 ROWSPAN=4><PRE><A NAME="1009686"></a>myArray</PRE><TD><PRE><A NAME="1009688"></a></PRE><TD><P><A NAME="1009690"></a>
Совпавшая строка и все запомненные подстроки.</P><TD><P><A NAME="1009692"></a>
<CODE>["dbbd", "bb"]</CODE></P><TR><TD><PRE><A NAME="1009696"></a>index</PRE><TD><P><A NAME="1009698"></a>
Индекс с базой 0 совпадения в строке ввода.</P><TD><P><A NAME="1009700"></a><CODE>1</CODE></P>
<TR><TD><PRE><A NAME="1009704"></a>input</PRE><TD><P><A NAME="1009706"></a>Строка-оригинал.</P><TD><P><A NAME="1009708"></a>
<CODE>"cdbbdbsbz"</CODE></P><TR><TD><PRE><A NAME="1009712"></a>[0]</PRE><TD><P><A NAME="1009714"></a>
Последние совпавшие символы.</P><TD><P><A NAME="1009716"></a><CODE>"dbbd"</CODE></P>
<TR><TD VALIGN=baseline ALIGN=left COLSPAN=1 ROWSPAN=2><PRE><A NAME="1009718"></a>myRe</PRE><TD><PRE><A NAME="1009720"></a>lastIndex</PRE><TD><P><A NAME="1009722"></a>
Индекс, по которому находится начало следующего совпадения. (Это свойство 
устанавливается, только если регулярное выражение использует опцию <CODE>g</CODE>, 
описанную в разделе <A HREF="#1008681">"Выполнение Глобального Поиска и 
Игнорирование Регистра Символов"</a>.)</P><TD><P><A NAME="1009727"></a><CODE>5</CODE></P>
<TR><TD><PRE><A NAME="1009731"></a>source</PRE><TD><P><A NAME="1009733"></a>Текст патэрна.</P><TD><P><A NAME="1009735"></a>
<CODE>"d(b+)d"</CODE></P><TR><TD VALIGN=baseline ALIGN=left COLSPAN=1 ROWSPAN=3><PRE><A NAME="1009737"></a>RegExp</PRE><TD><PRE><A NAME="1009739"></a>lastMatch</PRE><TD><P><A NAME="1009741"></a>
Последние совпавшие символы.</P><TD><P><A NAME="1009743"></a><CODE>"dbbd"</CODE></P>
<TR><TD><PRE><A NAME="1009747"></a>leftContext</PRE><TD><P><A NAME="1009749"></a>
Подстрока, предшествующая самому последнему совпадению.</P><TD><P><A NAME="1009751"></a><CODE>"c"</CODE></P>
<TR><TD><PRE><A NAME="1009755"></a>rightContext</PRE><TD><P><A NAME="1009757"></a>
Подстрока, идущая после самого последнего совпадения.</P><TD><P><A NAME="1009759"></a><CODE>"bsbz"</CODE></P></TABLE>
<p><A NAME="1009760"></a><CODE>RegExp.leftContext</CODE> и <CODE>RegExp.rightContext</CODE> могут быть 
высчитаны из других значений.<CODE><br>RegExp.leftContext</CODE> эквивалентно:</p>
<PRE><A NAME="1008646"></a>myArray.input.substring(0, myArray.index)</PRE><p><A NAME="1008647"></a>
а <CODE>RegExp.rightContext</CODE> эквивалентно:</p>
<PRE><A NAME="1008648"></a>myArray.input.substring(myArray.index + myArray[0].length)</PRE><p><A NAME="1008649"></a>
Как видно из второй формы этого примера, Вы можете использовать регулярное 
выражение, созданное инициализатором объекта, без присвоения его переменной. 
Если Вы это сделаете, каждое вхождение будет новым регулярным выражением. 
Поэтому, если Вы используете эту форму без присвоения значения, Вы не сможете 
получить доступ к свойствам этого регулярного выражения. Например, у Вас имеется такой скрипт:</p>
<PRE><A NAME="1008650"></a>&lt;SCRIPT LANGUAGE="JavaScript1.2"&gt;<br>myRe=/d(b+)d/g;<br>myArray = myRe.exec("cdbbdbsbz");<br>document.writeln("The value of lastIndex is " + myRe.lastIndex);<br>&lt;/SCRIPT&gt;</PRE>
<p><A NAME="1008651"></a>Он выводит:</p><P><A NAME="1008652"></a>The value of lastIndex is 5</P><p><A NAME="1008653"></a>
Но если у Вас такой скрипт:</p><PRE><A NAME="1008654"></a>&lt;SCRIPT LANGUAGE="JavaScript1.2"&gt;<br>myArray = /d(b+)d/g.exec("cdbbdbsbz");<br>document.writeln("The value of lastIndex is " + /d(b+)d/g.lastIndex);<br>&lt;/SCRIPT&gt;</PRE>
<p><A NAME="1008655"></a>Он выведет:</p><P><A NAME="1008656"></a>The value of lastIndex is 0</P><p><A NAME="1008657"></a>
Появления <CODE>/d(b+)d/g</CODE> в этих двух операторах являются разными 
объектами регулярного выражения и, следовательно, имеют разные значения своих 
свойств <CODE>lastIndex</CODE>. Если Вам нужен доступ к свойствам регулярного 
выражения, созданного инициализатором объекта, Вы должны сначала присвоить его переменной.</p><H3><A NAME="Head2;"></a>
<A NAME="1008659"></a>Использование совпадений подстрок в скобках</H3><hr><p><A NAME="1008660"></a>
Включение скобок в патэрн регулярного выражения вызывает запоминание 
соответствующего подсовпадения. Например, <CODE>/a(b)c/</CODE> совпадает с 
символами 'abc' и запоминает 'b'. Для последующего вызова этих запомненных 
подсовпадений используйте свойства <CODE>$1</CODE>, ..., <CODE>$9</CODE> объекта <CODE>RegExp</CODE> 
или элементы <CODE>[1]</CODE>, ..., <CODE>[n]</CODE> объекта <CODE>Array</CODE>.</p><p><A NAME="1008661"></a>
Количество подстрок в скобках не ограничено. Предопределённый объект <CODE>RegExp</CODE> 
хранит последние 9 подстрок, а массив содержит всё, что найдено. Следующие примеры 
иллюстрируют использование совпадений подстрок в скобках.</p><p><B><A NAME="HeadRunIn;"></a><A NAME="1008662"></a>
Пример 1. </B><A NAME="1008663"></a>Следующий скрипт использует метод <CODE>replace</CODE> для переключения слов в 
строке. Для замещающего текста скрипт использует значения свойств <CODE>$1</CODE> и <CODE>$2</CODE>.</p>
<PRE><A NAME="1008664"></a>&lt;SCRIPT LANGUAGE="JavaScript1.2"&gt;<br>re = /(\w+)\s(\w+)/;<br>str = "John Smith";<br>newstr = str.replace(re, "$2, $1");<br>document.write(newstr)<br>&lt;/SCRIPT&gt;</PRE>
<p><A NAME="1008665"></a>Будет выведено "Smith, John".</p><p><B><A NAME="HeadRunIn;"></a><A NAME="1008666"></a>Пример 2. </B><A NAME="1008667"></a>
В следующем примере <CODE>RegExp.input</CODE> устанавливается событием Change. В 
функции <CODE>getInfo</CODE> метод <CODE>exec</CODE> использует значение <CODE>RegExp.input</CODE> 
в качестве аргумента. Заметьте, что <CODE>RegExp</CODE> обязан быть присоединён 
как префикс к его свойствам <CODE>$</CODE> (поскольку они появляются вне 
замещающей строки). (Пример 3 это более эффективный, хотя, может быть, и более 
завуалированный способ сделать то же самое.)</p>
<PRE><A NAME="1008668"></a>&lt;HTML&gt;</PRE><PRE><A NAME="1008669"></a>&lt;SCRIPT LANGUAGE="JavaScript1.2"&gt;<br>function getInfo(){<br>&nbsp;&nbsp;&nbsp;re = /(\w+)\s(\d+)/<br>&nbsp;&nbsp;&nbsp;re.exec();<br>&nbsp;&nbsp;&nbsp;window.alert(RegExp.$1 + ", your age is " + RegExp.$2);<br>}<br>&lt;/SCRIPT&gt;</PRE><PRE><A NAME="1008670"></a>Enter your first name and your age, and then press Enter.</PRE><PRE><A NAME="1008671"></a>&lt;FORM&gt;<br>&lt;INPUT TYPE="text" NAME="NameAge" onChange="getInfo(this);"&gt;<br>&lt;/FORM&gt;</PRE><PRE><A NAME="1008672"></a>&lt;/HTML&gt;</PRE>
<p><B><A NAME="HeadRunIn;"></a><A NAME="1008673"></a>Пример 3. </B><A NAME="1008674"></a>
Это пример похож на Пример 2. Но вместо использования <CODE>RegExp.$1</CODE> и <CODE>RegExp.$2</CODE> 
этот пример создаёт массив и использует <CODE>a[1]</CODE> и <CODE>a[2]</CODE>. 
Здесь используется также сокращённая нотация для метода <CODE>exec</CODE>.</p>
<PRE><A NAME="1008675"></a>&lt;HTML&gt;</PRE><PRE><A NAME="1008676"></a>&lt;SCRIPT LANGUAGE="JavaScript1.2"&gt;<br>function getInfo(){<br>&nbsp;&nbsp;&nbsp;a = /(\w+)\s(\d+)/();<br>&nbsp;&nbsp;&nbsp;window.alert(a[1] + ", your age is " + a[2]);<br>}<br>&lt;/SCRIPT&gt;</PRE><PRE><A NAME="1008677"></a>Enter your first name and your age, and then press Enter.</PRE><PRE><A NAME="1008678"></a>&lt;FORM&gt;<br>&lt;INPUT TYPE="text" NAME="NameAge" onChange="getInfo(this);"&gt;<br>&lt;/FORM&gt;</PRE><PRE><A NAME="1008679"></a>&lt;/HTML&gt;</PRE>
<H3><A NAME="Head2;"></a><A NAME="1008681"></a>Выполнение глобального поиска и игнорирование регистра символов</H3>
<hr><p><A NAME="1008682"></a>Регулярное выражение имеет две не обязательные опции-флаги, которые дают 
возможность проводить поиск глобально и без учёта регистра символов.<br>
Для глобального поиска используйте флаг <CODE>g</CODE>.<br>
Для поиска без учёта регистра используйте флаг <CODE>i</CODE>.<br>
Эти флаги можно использовать вместе или по отдельности в любом порядке, и они включаются как часть регулярного выражения.</p>
<p><A NAME="1008683"></a>Синтаксис для включения флага:</p>
<PRE><A NAME="1008684"></a>re = /pattern/[g|i|gi]<br>re = new RegExp("pattern", ['g'|'i'|'gi'])</PRE>
<p><A NAME="1008685"></a>Заметьте, что флаги <CODE>i</CODE> и <CODE>g</CODE> являются неотъемлемой частью 
регулярного выражения. Они не могут быть добавлены и удалены позднее.</p><p><A NAME="1008686"></a>
Например, <CODE>re&nbsp;=&nbsp;/\w+\s/g</CODE> создаёт регулярное выражение, 
которое ищет один или более символов с последующим пробелом, и ищет такую комбинацию по всей строке.</p>
<PRE><A NAME="1008687"></a>&lt;SCRIPT LANGUAGE="JavaScript1.2"&gt;<br>re = /\w+\s/g;<br>str = "fee fi fo fum";<br>myArray = str.match(re);<br>document.write(myArray);<br>&lt;/SCRIPT&gt;</PRE>
<p><A NAME="1008688"></a>Это выведет ["fee ", "fi ", "fo "]. В данном примере Вы можете заменить строку:</p>
<PRE><A NAME="1008689"></a>re = /\w+\s/g;</PRE><p><A NAME="1008690"></a>на строку:</p>
<PRE><A NAME="1008691"></a>re = new RegExp("\\w+\\s", "g");</PRE><p><A NAME="1008692"></a>и получить тот же самый результат.</p>
<H2><A NAME="Examples"><A NAME="1008694"></a>Примеры</H2><hr><p><A NAME="1010172"></a>Далее идут пример использования регулярных выражений.</p>
<H3><A NAME="Head2;"></a><A NAME="1008695"></a>Изменение порядка в строке ввода</H3><hr><p><A NAME="1008696"></a>
Это пример форматирования регулярных выражений и использования методов <CODE>string.split()</CODE> 
и <CODE>string.replace()</CODE>. Здесь зачищается грубо отформатированная строка 
ввода, содержащая имена (первое имя идёт первым), разделённые пробелом, 
табуляцией и одним символом &quot;точка с запятой&quot;. Затем порядок имён 
разворачивается (последнее имя идёт первым) и список сортируется.</p>
<PRE><A NAME="1008699"></a>&lt;SCRIPT LANGUAGE="JavaScript1.2"&gt;</PRE><PRE><A NAME="1008700"></a>// Строка name содержит несколько пробелов и табуляций,<br>// и может иметь несколько пробелов между первым и последним именами.<br>names = new String ( "Harry Trump ;Fred Barney; Helen Rigby ;\<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Bill Abel ;Chris Hand ")</PRE><PRE><A NAME="1008701"></a>document.write ("---------- Original String" + "&lt;BR&gt;" + "&lt;BR&gt;")<br>document.write (names + "&lt;BR&gt;" + "&lt;BR&gt;")</PRE><PRE><A NAME="1008702"></a>// Готовятся два патэрна и массив-хранилище.<br>// Строка делится на элементы массива.</PRE><PRE><A NAME="1008703"></a>// патэрн: возможен пробел, затем ; и затем снова возможен пробел<br>pattern = /\s*;\s*/</PRE><PRE><A NAME="1008704"></a>// Разбивка строки на куски, разделённые вышеуказанным патэрном,<br>// и сохранение этих кусков в массиве nameList<br>nameList = names.split (pattern)</PRE><PRE><A NAME="1008705"></a>// новый патэрн: один или боле символов, затем пробелы, затем символы.<br>// Скобки используются для "запоминания" части патэрна.<br>// Запомненные части будут использованы позднее.<br>pattern = /(\w+)\s+(\w+)/</PRE><PRE><A NAME="1008706"></a>// Новый массив для хранения обрабатываемых имён.<br>bySurnameList = new Array;</PRE><PRE><A NAME="1008707"></a>// Вывести имя массива и заполнить этот новый массив<br>// именами с разделением запятыми, последнее имя идёт первым.<br>//<br>// Метод replace удаляет всё совпадающее с патэрном<br>// и замещает это запомненной строкой - второй запомненной частью,
// с последующими запятой и пробелом, с последующей запомненной первой частью.<br>// <br>// Переменные $1 и $2 ссылаются на части, запомненные при совпадении патэрна.</PRE><PRE><A NAME="1008708"></a>document.write ("---------- After Split by Regular Expression" + "&lt;BR&gt;")<br>for ( i = 0; i &lt; nameList.length; i++) {<br>&nbsp;&nbsp;&nbsp;document.write (nameList[i] + "&lt;BR&gt;")<br>&nbsp;&nbsp;&nbsp;bySurnameList[i] = nameList[i].replace (pattern, "$2, $1")<br>}</PRE><PRE><A NAME="1008709"></a>// отображение нового массива.<br>document.write ("---------- Names Reversed" + "&lt;BR&gt;")<br>for ( i = 0; i &lt; bySurnameList.length; i++) {<br>&nbsp;&nbsp;&nbsp;document.write (bySurnameList[i] + "&lt;BR&gt;")<br>}</PRE><PRE><A NAME="1008710"></a>// сортировка по фамилии, затем вывод отсортированного массива.<br>bySurnameList.sort()<br>document.write ("---------- Sorted" + "&lt;BR&gt;")<br>for ( i = 0; i &lt; bySurnameList.length; i++) {<br>&nbsp;&nbsp;&nbsp;document.write (bySurnameList[i] + "&lt;BR&gt;")<br>}</PRE><PRE><A NAME="1008711"></a>document.write ("---------- End" + "&lt;BR&gt;")</PRE><PRE><A NAME="1008712"></a>&lt;/SCRIPT&gt;</PRE>
<H3><A NAME="Head2;"></a><A NAME="1008713"></a>Использование специальных символов для проверки ввода</H3><hr><p>
<A NAME="1008714"></a>В следующем примере пользователь вводит номер телефона. Когда пользователь 
нажимает Enter, скрипт проверяет правильность ввода. Если номер верен (совпадает 
с последовательностью символов, специфицированной регулярным выражением), скрипт 
выводит окно, подтверждающее номер. Если номер введён неправильно, скрипт 
выводит окно, сообщающее пользователю, что номер введён неправильно.</p><p><A NAME="1008715"></a>
Регулярное выражение ищет ноль или открывающих скобок <CODE>\(?</CODE>, с 
последующими тремя цифрам <CODE>\d{3}</CODE>, с последующими нуль или одной 
закрывающих скобок <CODE>\)?</CODE>, с последующими одним тире, слэшем или 
десятичной точкой и, если эти символы найдены, запоминает символы <CODE>([-\/\.])</CODE>, 
с последующими тремя цифрами <CODE>\d{3}</CODE>, с последующим запомненным 
совпадением тире, слэша или десятичной точки и <CODE>\1</CODE>, с последующими 
четырьмя цифрами <CODE>\d{4}</CODE>.</p><p><A NAME="1008716"></a>Событие Change активируется, когда пользователь нажатием Enter устанавливает 
значение <CODE>RegExp.input</CODE>.</p>
<PRE><A NAME="1008717"></a>&lt;HTML&gt;<br>&lt;SCRIPT LANGUAGE = "JavaScript1.2"&gt;</PRE><PRE><A NAME="1008718"></a>re = /\(?\d{3}\)?([-\/\.])\d{3}\1\d{4}/</PRE><PRE><A NAME="1008719"></a>function testInfo() {<br>&nbsp;&nbsp;&nbsp;OK = re.exec()<br>&nbsp;&nbsp;&nbsp;if (!OK)<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;window.alert (RegExp.input + <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" isn't a phone number with area code!")<br>&nbsp;&nbsp;&nbsp;else<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;window.alert ("Thanks, your phone number is " + OK[0])<br>}</PRE><PRE><A NAME="1008720"></a>&lt;/SCRIPT&gt;</PRE><PRE><A NAME="1008721"></a>Enter your phone number (with area code) and then press Enter.<br>&lt;FORM&gt; <br>&lt;INPUT TYPE="text" NAME="Phone" onChange="testInfo(this);"&gt;<br>&lt;/FORM&gt;</PRE><PRE><A NAME="1008722"></a>&lt;/HTML&gt;</PRE>
<h5><a href="contents.php">Оглавление</a> | <a href="expr.php">Назад</a>
| <a href="stmtsov.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5>
<hr></BODY></HTML>
<?
include_once '../../sys/inc/tfoot.php';
?>