<?
include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/user.php';
$set['title']='Учебник JavaScript';
include_once '../../sys/inc/thead.php';
title();
err();
//aut();
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<phpl<TITLE>Операторы</TITLE>
<BODY>
<h5><a href="contents.php">Оглавление</a> | <a href="regexp.php">Назад</a>
| <a href="fcns.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5>
<HR><h1>Глава 5<BR><a name="1008303"></a>Операторы</h1><p><A NAME="1008305"></a>
JavaScript поддерживает компактный набор операторов, который Вы можете 
использовать для реализации интерактивного поведения Web-страниц. В главе дан обзор этих операторов.</p>
<p><A NAME="1009733"></a>В главе имеются следующие разделы, в которых дан краткий обзор каждого оператора:</p>
<ul><LI><A NAME="1009737"></a>
<a href="#1008319">Условные операторы:</a> <CODE>if...else</CODE> и <CODE>switch</CODE></LI><LI><A NAME="1009798"></a>
<a href="#1008340">Операторы циклов:</a> <CODE>for</CODE>, <CODE>while</CODE>,<CODE> do while</CODE>,<CODE> label</CODE>, <CODE>break</CODE> 
и<CODE> continue</CODE> (<CODE>label</CODE> сам по себе не оператор цикла, но 
часто используется с этими операторами)</LI><LI><A NAME="1009832"></a>
<a href="#1008417">Операторы манипулирования объектами:</a> <CODE>for...in </CODE>и <CODE>with</CODE></LI><LI><A NAME="1009837"></a>
<a href="#1008468">Комментарии</a></LI></ul><p><A NAME="1014479"></a>
Любое выражение также является оператором. См. в <A HREF="expr.php#1008302">
Главе 3 "Выражения и Операторы"</a> полную информацию об операторах.</p><p><A NAME="1014489"></a>
Используйте точку с запятой (;) для разделения операторов в коде JavaScript.</p><p><A NAME="1009782"></a>
См. в книге <I><a TARGET="_top" href="../clientref13/index.php">Клиентский JavaScript. 
Справочник.</a></I> детальную информацию об операторах данной главы.</p><H2><A NAME="Conditional Statements">
<A NAME="1008319"></a>Условные Операторы</H2><hr><p><A NAME="1008320"></a>
Условный оператор это набор команд, выполняемый, если специфицированное true. JavaScript 
поддерживает два условных оператора : <CODE>if...else</CODE> и <CODE>switch</CODE>.</p>
<H3><A NAME="Head2;"></a><A NAME="1008323"></a>Оператор if...else</H3><hr><p><A NAME="1008324"></a>
Оператор <CODE>if</CODE> используется для выполнения определённых операторов, 
если логическое условие true; не обязательный блок <CODE>else</CODE> 
выполняется, если условие false. Оператор <CODE>if</CODE> выглядит так:</p>
<PRE><A NAME="1008325"></a>if (<I>condition</I>) {<br>&nbsp;&nbsp;&nbsp;<I>statements1</I> <br>}<br>[else {<br>&nbsp;&nbsp;&nbsp;<I>statements2</I> <br>} ]</PRE>
<p><A NAME="1008326"></a>condition это может быть любое выражение JavaScript, которое вычисляется в true 
или false. Выполняемые операторы это любые операторы JavaScript, включая 
вложенные <CODE>if</CODE>. Если Вы хотите использовать более одного оператора 
после операторов <CODE>if</CODE> или <CODE>else</CODE>, Вы обязаны заключать их в фигурные скобки {}.</p>
<p><A NAME="1014519"></a>Не путайте примитивные Boolean-значения true и false со значениями true и false объекта Boolean. 
Любой объект, значением которого не является undefined или null, включая объект Boolean 
со значением false, вычисляется в true, когда передаётся в условный оператор. Например:</p>
<PRE><A NAME="1014538"></a>var b = new Boolean(false);<br>if (b) // это условие вычисляется в true</PRE>
<p><A NAME="1008327"></a><B>Пример.</B> В следующем примере функция <CODE>checkData</CODE> возвращает true, 
если количество символов в объекте <CODE>Text</CODE> равно трём; иначе выводит диалог alert и возвращает false.</p>
<PRE><A NAME="1008328"></a>function checkData () {<br>&nbsp;&nbsp;&nbsp;if (document.form1.threeChar.value.length == 3) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;return true<br>&nbsp;&nbsp;&nbsp;} else {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;alert("Enter exactly three characters. " + &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;document.form1.threeChar.value + " is not valid.")<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;return false<br>&nbsp;&nbsp;&nbsp;}<br>}</PRE>
<H3><A NAME="Head2;"></a><A NAME="1008329"></a> Оператор switch</H3><hr><p><A NAME="1008330"></a>
Оператор <CODE>switch</CODE> позволяет вычислять выражение и пытается найти 
совпадение значения выражения с оператором label. Если совпадение найдено, 
программа выполняет ассоциированный оператор. Оператор <CODE>switch</CODE> выглядит так:</p>
<PRE><A NAME="1008331"></a>switch (<I>expression</I>){<br>&nbsp;&nbsp;&nbsp;case <I>label</I> : <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<I>statement</I>;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;break;<br>&nbsp;&nbsp;&nbsp;case <I>label</I> : <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<I>statement</I>;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;break;<br>&nbsp;&nbsp;&nbsp;...<br>&nbsp;&nbsp;&nbsp;default : <I>statement</I>;<br>}</PRE>
<p><A NAME="1008332"></a>Программа сначала ищет label/метку, совпадающую по значению с выражением, а 
затем выполняет ассоциированный оператор. Если совпадающий label не найден, 
программа ищет не обязательный оператор по умолчанию и, если он найден, 
выполняет ассоциированный оператор. Если оператор по умолчанию/default statement 
на найден, программа продолжает выполняться с оператора, идущего после конца <CODE>switch</CODE>.</p>
<p><a NAME="1008333"></a>Не обязательный оператор <code>break</code>, 
ассоциируемый с каждым case, гарантирует, что программа прервёт выполнение блока
<code>switch</code>, как только будет выполнен совпавший оператор, и продолжит 
выполнение с оператора, идущего после <kbd>switch</kbd>. Если <code>break</code> 
отсутствует, программа продолжит выполнение следующего оператора в блоке <code>switch</code>.</p><p><A NAME="1008334"></a>
<B>Пример.</B> В следующем примере, если <CODE>expr</CODE> вычисляется в "Bananas",
программа находит совпадение с case "Bananas" и выполняет ассоциированный
оператор. Если обнаружен <CODE>break</CODE>, программа прерывает выполнение
блока <CODE>switch</CODE> и выполняет оператор, идущий после <CODE>switch</CODE>. 
Если <CODE>break</CODE> отсутствует, оператор для case "Cherries" также будет выполнен.</p>
<PRE><A NAME="1010429"></a>switch (expr) {<br>&nbsp;&nbsp;&nbsp;case "Oranges" : <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;document.write("Oranges are $0.59 a pound.&lt;BR&gt;"); <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;break; <br>&nbsp;&nbsp;&nbsp;case "Apples" :<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;document.write("Apples are $0.32 a pound.&lt;BR&gt;");<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;break;<br>&nbsp;&nbsp;&nbsp;case "Bananas" : <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;document.write("Bananas are $0.48 a pound.&lt;BR&gt;"); <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;break; <br>&nbsp;&nbsp;&nbsp;case "Cherries" :<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;document.write("Cherries are $3.00 a pound.&lt;BR&gt;");<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;break; <br>&nbsp;&nbsp;&nbsp;default :<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;document.write("Sorry, we are out of " + i + ".&lt;BR&gt;"); <br>}</PRE><PRE><A NAME="1008337"></a>document.write("Is there anything else you'd like?&lt;BR&gt;");</PRE>
<H2><A NAME="Loop Statements"><A NAME="1008340"></a>Операторы циклов</H2><hr><p><A NAME="1008341"></a>
Цикл/loop это набор команд, которые выполняются неоднократно, пока не будет 
выполнено специфицированное условие. JavaScript поддерживает операторы циклов <CODE>for</CODE>, <CODE>do while</CODE>, <CODE>while</CODE> 
и <CODE>label</CODE> (<CODE>label</CODE> сам по себе не является оператором 
цикла, но часто используется с этими операторами). Кроме того, Вы можете 
использовать операторы <CODE>break</CODE> и <CODE>continue</CODE> с операторами циклов.</p><p><A NAME="1008342"></a>
Ещё один оператор, <CODE>for...in</CODE>, выполняет операторы циклически, но 
используется при работе с объектами. См. <A HREF="#1008417">"Операторы Манипуляций с Объектами"</a>.</p><H3><A NAME="Head2;"></a>
<A NAME="1008347"></a>Оператор for</H3><hr><p><A NAME="1008349"></a>
Оператор <CODE>for</CODE> повторяется, пока специфицированное условие не станет false. JavaScript-цикл <CODE>for</CODE> 
похож на аналогичные циклы Java и C. Оператор <CODE>for</CODE> выглядит так:</p>
<PRE><A NAME="1008350"></a>for ([<I>initialExpression</I>]; [<I>condition</I>]; [<I>incrementExpression</I>]) {<br>&nbsp;&nbsp;&nbsp;<I>statements<br></I>}</PRE>
<p><A NAME="1008351"></a>При выполнении цикла <CODE>for</CODE> происходит следующее:</p><OL><LI><A NAME="1008352"></a>
Выполняется инициализирующее выражение <CODE>initial-expression</CODE>, если 
имеется. Это выражение обычно инициализирует один или более счётчиков цикла, но 
синтаксис допускает выражения любой сложности.</LI><LI><A NAME="1008353"></a>
Выражение <CODE>condition</CODE> вычисляется. Если <CODE>condition</CODE> даёт true, 
цикл выполняется. Если <CODE>condition</CODE> равно false, цикл <CODE>for</CODE> 
прерывается.</LI><LI><A NAME="1014494"></a>Выполняются <CODE>statements</CODE>/операторы.</LI><LI><A NAME="1008354"></a>
Выполняется выражения обновления <CODE>incrementExpression</CODE>, и управление возвращается к шагу 2.</LI></OL>
<p><A NAME="1008356"></a><B>Пример.</B> Эта функция содержит оператор <CODE>for</CODE>, подсчитывающий 
количество выбранных опций в прокручиваемом списке (объекте <CODE>Select</CODE>, 
который позволяет делать множественный выбор). Оператор <CODE>for</CODE> 
объявляет переменную <CODE>i</CODE> и инициализирует её значением 0 (нуль). Если <CODE>i</CODE> 
меньше количества опций объекта <CODE>Select</CODE>, выполняется следующий 
оператор <CODE>if</CODE>, а <CODE>i</CODE> увеличивается на 1 при каждом прохождении цикла.</p>
<PRE><A NAME="1016194"></a>&lt;SCRIPT&gt;<br>function howMany(selectObject) {<br>&nbsp;&nbsp;&nbsp;var numberSelected=0<br>&nbsp;&nbsp;&nbsp;for (var i=0; i &lt; selectObject.options.length; i++) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;if (selectObject.options[i].selected==true)<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;numberSelected++<br>&nbsp;&nbsp;&nbsp;}<br>&nbsp;&nbsp;&nbsp;return numberSelected<br>}<br>&lt;/SCRIPT&gt;</PRE><PRE><A NAME="1016196"></a>&lt;FORM NAME="selectForm"&gt;<br>&lt;P&gt;&lt;B&gt;Choose some music types, then click the button below:&lt;/B&gt;<br>&lt;BR&gt;&lt;SELECT NAME="musicTypes" MULTIPLE&gt;<br>&lt;OPTION SELECTED&gt; R&amp;B<br>&lt;OPTION&gt; Jazz<br>&lt;OPTION&gt; Blues<br>&lt;OPTION&gt; New Age<br>&lt;OPTION&gt; Classical<br>&lt;OPTION&gt; Opera<br>&lt;/SELECT&gt;<br>&lt;P&gt;&lt;INPUT TYPE="button" VALUE="How many are selected?"<br>onClick="alert ('Number of options selected: ' + howMany(document.selectForm.musicTypes))"&gt;<br>&lt;/FORM&gt;</PRE>
<H3><A NAME="Head2;"></a><A NAME="1008359"></a>Оператор do...while</H3><hr><p><A NAME="1008360"></a>
Оператор <CODE>do...while</CODE> повторяется, пока специфицированное выражение 
не станет false. Оператор <CODE>do...while</CODE> выглядит так:</p>
<PRE><A NAME="1008361"></a>do<CODE> {<br></CODE>&nbsp;&nbsp;&nbsp;<I>statement<br></I>}<CODE> </CODE>while<CODE> (</CODE><I>condition</I><CODE>)</CODE></PRE>
<p><A NAME="1008362"></a><CODE>statement</CODE> выполняется как минимум один раз, так как находится перед 
проверяемым условием. Если <CODE>condition</CODE> возвращает <CODE>true</CODE>, 
цикл выполняется ещё раз. В конце каждого прохода проверяется условие. Если condition возвращает <CODE>false</CODE>, 
выполнение останавливается и управление передаётся оператору, идущему после <CODE>do...while</CODE>.</p>
<p><A NAME="1008363"></a><B>Пример.</B> В следующем примере цикл <CODE>do</CODE> итерирует как минимум 
один раз, пока i не станет меньше 5.</p>
<PRE><A NAME="1008364"></a>do {<br>&nbsp;&nbsp;&nbsp;i+=1;<br>&nbsp;&nbsp;&nbsp;document.write(i);<br>} while (i&lt;5);</PRE>
<H3><A NAME="Head2;"></a><A NAME="1008366"></a>Оператор while</H3><hr><p><A NAME="1008367"></a>
Оператор <CODE>while</CODE> выполняется, пока специфицированное условие 
вычисляется в true. Оператор <CODE>while</CODE> выглядит так:</p>
<PRE><A NAME="1008368"></a>while (<I>condition</I>) {<br>&nbsp;&nbsp;&nbsp;<I>statements<br></I>}</PRE>
<p><A NAME="1008369"></a>Если condition становится false, операторы внутри цикла перестают выполняться и 
управление передаётся оператору, идущему после цикла.</p><p><A NAME="1008370"></a>
Проверка условия/condition выполняется перед началом каждого цикла. Если condition возвращает true, 
операторы выполняются и условие проверяется снова. Если condition возвращает false, 
выполнение прекращается и управление передаётся оператору, идущему после цикла <CODE>while</CODE>.</p>
<p><A NAME="1008371"></a><B>Пример 1.</B> Следующий цикл <CODE>while</CODE> итерирует, пока <CODE>n</CODE> меньше 3:</p>
<PRE><A NAME="1008372"></a>n = 0<br>x = 0<br>while( n &lt; 3 ) {<br>&nbsp;&nbsp;&nbsp;n ++<br>&nbsp;&nbsp;&nbsp;x += n<br>}</PRE>
<p><A NAME="1008373"></a>При каждой итерации выполняется инкремент <CODE>n</CODE> и обновляется значение <CODE>x</CODE>. 
Следовательно, <CODE>x</CODE> и <CODE>n</CODE> получают следующие значения:</p><ul><LI><A NAME="1008374"></a>
После первого прохода: <CODE>n</CODE> = 1 и <CODE>x</CODE> = 1</LI><LI><A NAME="1008375"></a>
После второго прохода: <CODE>n</CODE> = 2 и <CODE>x</CODE> = 3</LI><LI><A NAME="1008376"></a>
После третьего прохода: <CODE>n</CODE> = 3 и <CODE>x</CODE> = 6</LI></ul><p><A NAME="1008377"></a>
После третьего прохода условие <CODE>n &lt; 3</CODE> больше не true, поэтому цикл прерывается.</p><p><A NAME="1008378"></a>
<B>Пример 2: Бесконечный цикл.</B> Проверяйте, что условие в цикле рано или
поздно станет false; иначе цикл никогда не закончится. Операторы следующего
цикла <CODE>while</CODE> выполняются бесконечно, поскольку condition никогда не станет false:</p>
<PRE><A NAME="1010472"></a>while (true) {<br>&nbsp;&nbsp;&nbsp;alert("Hello, world") }</PRE><H3><A NAME="Head2;"></a>
<A NAME="1010474"></a>Оператор label</H3><hr><p><A NAME="1008383"></a>
Оператор label предоставляет оператор с идентификатором, что позволяет 
обратиться к нему в программе. Например, Вы можете использовать label для 
идентифицирования цикла, а затем использовать <CODE>break</CODE> или <CODE>continue</CODE> 
для указания момента, когда программа должна прервать выполнение цикла или начать новую итерацию.</p>
<p><A NAME="1014644"></a>Синтаксис оператора label примерно такой:</p>
<PRE><A NAME="1008384"></a><I>label</I> :<br>&nbsp;&nbsp;&nbsp;<I>statement</I></PRE>
<p><A NAME="1008385"></a>Значение <I><CODE>label </CODE></I>это любой идентификатор JavaScript, не 
являющийся зарезервированным словом. <I><CODE>statement\оператор</CODE></I> , 
идентифицируемый Вами с помощью label, может быть любого типа.</p><p><A NAME="1014768"></a>
<B>Пример.</B> Здесь label <CODE>markLoop</CODE> идентифицирует цикл <CODE>while</CODE>.</p>
<PRE><A NAME="1014713"></a>markLoop:<br>while (theMark == true)<br>&nbsp;&nbsp;&nbsp;doSomething();<br>}</PRE>
<H3><A NAME="Head2;"></a><A NAME="1008389"></a>Оператор break</H3><hr><p><A NAME="1008390"></a>
Оператор break используется для прерывания выполнения цикла, либо операторов <CODE>switch</CODE> или label.</p>
<ul><LI><A NAME="1008391"></a>
Когда Вы используете <CODE>break</CODE> с операторами <CODE>while</CODE>, <CODE>do-while</CODE>, <CODE>for</CODE> 
или <CODE>switch</CODE>, оператор <CODE>break</CODE> немедленно прерывает 
самый внутренний цикл или <CODE>switch</CODE> и передаёт управление следующему оператору.</LI><LI><A NAME="1008392"></a>
Когда Вы используете <CODE>break</CODE> внутри оператора label, он прерывает 
этот оператор и передаёт управление следующему оператору. Если Вы 
специфицировали label при вызове <CODE>break</CODE>, оператор <CODE>break</CODE> прерывает специфицированный оператор.</LI></ul>
<p><A NAME="1014917"></a>Синтаксис <CODE>break</CODE> выглядит так:</p>
<PRE><A NAME="1008396"></a>1. break<br>2. break [<I>label</I>]</PRE><p><A NAME="1014993"></a>
Первая форма прерывает самый внутренний цикл, <CODE>switch</CODE> или label; 
вторая форма прерывает специфицированный содержащий оператор label.</p><p><A NAME="1014994"></a>
<B>Пример.</B> Здесь происходит итерация по элементам массива, пока не будет 
найден индекс элемента, значением которого является <CODE>theValue</CODE>:</p>
<PRE><A NAME="1015015"></a>for (i = 0; i &lt; a.length; i++) {<br>&nbsp;&nbsp;&nbsp;if (a[i] = theValue);<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;break;<br>}</PRE>
<H3><A NAME="Head2;"></a><A NAME="1008402"></a>Оператор continue</H3><hr><p><A NAME="1015074"></a>
Оператор <CODE>continue</CODE> может использоваться для рестарта оператора <CODE>while</CODE>, <CODE>do-while</CODE>, <CODE>for</CODE> 
или <CODE>label</CODE>.</p><ul><LI><A NAME="1008404"></a>
В операторах <CODE>while</CODE> или <CODE>for</CODE>, оператор <CODE>continue</CODE> 
прерывает текущий цикл и начинает новую итерацию (проход) цикла. В отличие от <CODE>break</CODE>, <CODE>continue</CODE> 
не прерывает полностью выполнение цикла. В цикле <CODE>while</CODE> он 
перескакивает на <CODE>condition</CODE>. В цикле <CODE>for</CODE> он 
перескакивает на <CODE>increment-expression</CODE>.</LI><LI><A NAME="1008405"></a>
В операторе <CODE>label</CODE> оператор <CODE>continue </CODE>переходит по 
метке/label, которая идентифицирует оператор <CODE>label</CODE>. Этот тип <CODE>continue</CODE> 
рестартует оператор label или продолжает выполнение помеченного цикла со 
следующей итерации. <CODE>continue</CODE> обязан находиться в теле оператора 
цикла, идентифицированного label, используемым <CODE>continue</CODE>.</LI></ul><p><A NAME="1015133"></a>
Синтаксис оператора <CODE>continue</CODE> выглядит так:</p><PRE><A NAME="1015134"></a>1. continue<br>2. continue [<I>label</I>]</PRE>
<p><A NAME="1008410"></a><B>Пример 1.</B> здесь цикл <CODE>while</CODE> с оператором <CODE>continue</CODE> 
выполняется, если <CODE>i</CODE> имеет значение 3. Таким образом, <CODE>n</CODE> получает значения 1, 3, 7 и 12.</p>
<PRE><A NAME="1008411"></a>i = 0<br>n = 0<br>while (i &lt; 5) {<br>&nbsp;&nbsp;&nbsp;i++<br>&nbsp;&nbsp;&nbsp;if (i == 3)<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;continue<br>&nbsp;&nbsp;&nbsp;n += i<br>}</PRE>
<p><A NAME="1008413"></a><B>Пример 2.</B> Оператор, помеченный <CODE>checkiandj</CODE>, содержит 
оператор, помеченный <CODE>checkj</CODE>. Если обнаружен <CODE>continue</CODE>, 
программа прерывает текущую итерацию <CODE>checkj</CODE> и начинает следующую. 
Каждый раз при обнаружении <CODE>continue</CODE> оператор <CODE>checkj</CODE> 
реитерирует, пока его условие не возвратит <CODE>false</CODE>. Если возвращено <CODE>false</CODE>, 
выполняется остаток оператора <CODE>checkiandj</CODE> и <CODE>checkiandj</CODE> 
реитерирует, пока его условие не возвратит <CODE>false</CODE>. Если возвращено <CODE>false</CODE>, 
программа продолжает выполнение с оператора, идущего после <CODE>checkiandj</CODE>.</p><p><A NAME="1008414"></a>
Если <CODE>continue</CODE> имеет метку <CODE>checkiandj</CODE>, программа 
продолжит выполнение от верха оператора <CODE>checkiandj</CODE>.</p>
<PRE><A NAME="1008415"></a>checkiandj : <br>&nbsp;&nbsp;&nbsp;while (i&lt;4) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;document.write(i + "&lt;BR&gt;"); <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;i+=1; <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;checkj : <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;while (j&gt;4) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;document.write(j + "&lt;BR&gt;"); <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;j-=1; <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;if ((j%2)==0);<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;continue checkj;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;document.write(j + " is odd.&lt;BR&gt;");<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;document.write("i = " + i + "&lt;br&gt;");<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;document.write("j = " + j + "&lt;br&gt;");  <br>&nbsp;&nbsp;&nbsp;}</PRE>
<H2><A NAME="Object Manipulation Statements"><A NAME="1008417"></a>Операторы манипулирования объектами</H2><hr>
<p><A NAME="1008419"></a>JavaScript использует операторы <CODE>for...in</CODE> и <CODE>with</CODE> для работы с объектами.</p>
<H3><A NAME="Head2;"></a><A NAME="1008452"></a>Оператор for...in</H3><hr><p><A NAME="1008453"></a>
Оператор <CODE>for...in</CODE> итерирует специфицированную переменную по всем 
свойствам объекта. Для каждого отдельного свойства JavaScript выполняет 
специфицированные операторы. Цикл <CODE>for...in</CODE> выглядит так:</p>
<PRE><A NAME="1008454"></a>for (<I>variable</I> in <I>object</I>) {<br>&nbsp;&nbsp;&nbsp;<I>statements</I> }</PRE>
<p><A NAME="1008455"></a><B>Пример.</B> Следующая функция принимает в качестве аргументов объект и имя 
объекта. Затем итерирует по всем свойствам объекта и возвращает строку - список свойств объекта и их значений.</p>
<PRE><A NAME="1008456"></a>function dump_props(obj, obj_name) {<br>&nbsp;&nbsp;&nbsp;var result = ""<br>&nbsp;&nbsp;&nbsp;for (var i in obj) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;result += obj_name + "." + i + " = " + obj[i] + "&lt;BR&gt;"<br>&nbsp;&nbsp;&nbsp;}<br>&nbsp;&nbsp;&nbsp;result += "&lt;HR&gt;"<br>&nbsp;&nbsp;&nbsp;return result<br>}</PRE>
<p><A NAME="1008457"></a>Для объекта <CODE>car</CODE> со свойствами <CODE>make</CODE> и <CODE>model</CODE>, <CODE>result</CODE> будет:</p>
<p><A NAME="1008458"></a>car.make = Ford<br>car.model = Mustang</p><H3><A NAME="Head2;"></a>
<A NAME="1008460"></a>Оператор with</H3><hr><p><A NAME="1008461"></a>
Оператор <CODE>with</CODE> устанавливает объект по умолчанию для блока 
операторов. JavaScript ищет неквалифицированные имена в на боре операторов для 
определения, являются ли имена свойствами объекта пор умолчанию. Если 
неквалифицированное имя совпадает со свойством, то свойство используется в 
операторе; иначе используется локальная или глобальная переменная.</p><p><A NAME="1015235"></a>Оператор <CODE>with</CODE> выглядит так:</p>
<PRE><A NAME="1008462"></a>with (<I>object</I>){<br>&nbsp;&nbsp;&nbsp;<I>statements<br></I>}</PRE>
<p><A NAME="1008463"></a><B>Пример.</B> Оператор <CODE>with</CODE> специфицирует, что объект <CODE>Math</CODE> 
является объектом по умолчанию. Оператор, идущий после оператора <CODE>with</CODE>, 
обращается к свойству <CODE>PI</CODE> и методам <CODE>cos</CODE> и <CODE>sin</CODE> 
без специфицирования объекта. JavaScript принимает <CODE>Math</CODE> как объект для этих свойств.</p>
<PRE><A NAME="1008464"></a>var a, x, y<br>var r=10<br>with (Math) {<br>&nbsp;&nbsp;&nbsp;a = PI * r * r<br>&nbsp;&nbsp;&nbsp;x = r * cos(PI)<br>&nbsp;&nbsp;&nbsp;y = r * sin(PI/2)<br>}</PRE>
<H2><A NAME="Comments"><A NAME="1008468"></a>Комментарии</H2><hr><p><A NAME="1008469"></a>
Комментарии являются заметками автора, разъясняющими действия кода. Комментарии 
игнорируются интерпретатором. JavaScript поддерживает комментарии в стиле Java:</p><ul><LI><A NAME="1008471"></a>
Однострочный комментарии начинается с двойного слэша (//).</LI><LI><A NAME="1008474"></a>
Многострочный комментарий начинается с /* и заканчивается */</LI></ul><p><A NAME="1008475"></a><B>Пример.</B> Вот два комментария:</p>
<PRE><A NAME="1008476"></a>// Это однострочный комментарий.</PRE><PRE><A NAME="1008477"></a>/* Это многострочный комментарий. Он может быть любого размера, и<br>Вы может поместить в него что угодно. */</PRE>
<h5><a href="contents.php">Оглавление</a> | <a href="regexp.php">Назад</a> | <a href="fcns.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5>
<hr><P ALIGN=right><FONT SIZE=-2><I>Дата последнего обновления: 27 мая 1999 года.</I><br>
</BODY></HTML>
<?
include_once '../../sys/inc/tfoot.php';
?>