<?include'h.php';?>
<html><head>
		<title>Учебник PHP, Глава 4</title>
		<meta http-equiv="Content-type" content="text/html; charset=Windows-1251">
		</head>
		
      <DIV class=infotxt>
      <LI><A href="#a">Глава 4. Функции </A>
      <UL>
        <LI><A href="#b">Что такое функция? </A>
        <LI><A href="#c">Определение и вызов 
        функций </A>
        <LI><A href="#d">Вложенные функции </A>
        <LI><A href="#e">Возврат значений из 
        функции </A>
        <LI><A href="#f">Рекурсивные функции </A>
        <LI><A href="#g">Функции-переменные </A>
        <LI><A href="#h">Построение библиотек 
        функций </A>
        <LI><A href="#i">Итоги </A></LI></UL>
      <UL></UL><A name=a></A>
      <P>&nbsp;</P>
      <P>ГЛАВА 4</P>
      <P>Функции</P>
      <P>В этой главе представлены общие концепции функционального 
      программирования — одного из самых влиятельных принципов в области 
      разработки приложений. При помощи функций можно создавать компоненты 
      многократного использования, которые легко изменяются при необходимости и 
      оказываются особенно удобными при разработке web-приложений, не содержащих 
      серьезных различий на концептуальном и практическом уровне. Функциональное 
      программирование помогает создавать более короткие и удобочитаемые 
      программы. </P>
      <P>Данная глава посвящена функциям РНР, их определению и применению на 
      практике. Хотя основное внимание в ней уделяется определению и вызову 
      пользовательских функций, необходимо помнить и о том, что в РНР существуют 
      сотни стандартных функций. Стандартные функции работают точно так же, как 
      пользовательские, и обеспечивают заметную экономию времени при создании 
      новых приложений. Обновленный список стандартных функций РНР можно найти 
      по адресу <A href="http.html://www.php.net/">http://www.php.net/</A>. </P>
      <P><A href="http.html://doks.gorodok.net/0" name=b></A>Что такое функция?</P>
      <P>Функцией называется фрагмент программного кода, обладающий уникальным 
      именем и предназначенный для решения конкретной задачи. Функция вызывается 
      по имени в разных точках программы, что позволяет многократно выполнять 
      фрагмент с указанным именем. Преимущество такого решения заключается в 
      том, что блок кода пишется всего один раз, а затем легко модифицируется по 
      мере необходимости. </P>
      <P><A name=c></A>Определение и вызов функций</P>
      <P>Определить новую функцию в РНР несложно. Функции могут создаваться в 
      любой точке программ РНР, однако по соображениям структурной организации 
      кода удобнее разместить все функции, используемые сценарием, в самом 
      начале сценарного </P>
      <P>файла. Существует и другой способ, заметно повышающий эффективность 
      программирования и способствующий многократному использованию кода, — 
      выделение функций в отдельный файл (называемый библиотекой). Библиотеки 
      удобны тем, что их функции можно использовать в разных приложениях, не 
      создавая лишних копий и не рискуя допустить ошибки в процессе копирования. 
      Эта тема подробно рассматривается в разделе «Построение библиотек функций» 
      ближе к концу главы. </P>
      <P>Определение функции обычно состоит из трех частей: </P>
      <UL>
        <LI>имени функции; 
        <LI>круглых скобок, в которых перечисляются необязательные входные 
        параметры, разделенные запятыми; 
        <LI>тела функции, заключенного в фигурные скобки. </LI></UL>
      <P>Обобщенный синтаксис функций РНР выглядит так: </P>
      <P>function имя_функции ([$параметр1. $параметр2, .... $параметрn]) {</P>
      <P>тело функции</P>
      <P>}</P>
      <P>Имя функции должно подчиняться условиям, приведенным для 
      идентификаторов в главе 2. После имени функции следуют обязательные 
      круглые скобки, в которые заключается необязательный список входных 
      параметров ($параметр1, $параметр2, .... $параметрn). Вследствие 
      относительно либеральных принципов определения переменных в РНР указывать 
      тип входных параметров не нужно. Хотя такой подход имеет свои 
      преимущества, следует помнить, что механизм РНР не проверяет аргументы на 
      соответствие тем типам, которые должны обрабатываться функцией. Случайные 
      ошибки в использовании входных параметров могут привести к неожиданным 
      последствиям (чтобы убедиться в том, что параметр относится к нужному 
      типу, можно проверить его стандартной функцией gettype( )). После 
      закрывающей круглой скобки следуют фигурные скобки, в которые заключается 
      программный код, ассоциируемый с именем функции. </P>
      <P>Рассмотрим простой пример использования функции. Предположим, вы хотите 
      создать функцию для вывода лицензионной информации на web-странице: </P>
      <P>function display_copyright() {</P>
      <P>print "Copyright &amp;copy; 2001 PHP-Powered Recipes. All Rights 
      Reserved.";</P>
      <P>}</P>
      <P>Если ваш web-сайт состоит из нескольких страниц, достаточно вызвать эту 
      функцию в конце каждой страницы — и вам не придется заново переписывать 
      один и тот же текст. А когда наступит 2002 год, одно простое изменение 
      текста, выводимого этой функцией, приведет к автоматическому обновлению 
      всех страниц. Если бы не преимущества функционального программирования, 
      вам пришлось бы вручную редактировать все страницы, на которых выводится 
      лицензионная информация. </P>
      <P>Рассмотрим разновидность функции display_copyright(), которой при 
      вызове передается параметр. Предположим, вы отвечаете за администрирование 
      нескольких web-сайтов, каждому из которых присвоено отдельное имя. На 
      каждом сайте имеется собственный административный сценарий с несколькими 
      переменными, относящимися к этому сайту; к их числу принадлежит переменная 
      $site_name с именем </P>
      <P>сайта. В этом случае функцию display_copyright() можно записать 
      следующим образом: </P>
      <P>function display_copyright($site_name) {</P>
      <P>print "Copyright &amp;copy; 2001 $site_name. All Rights Reserved.";</P>
      <P>}</P>
      <P>Переменная $site_name, значение которой присваивается за пределами 
      display_copy-right(), передается функции в качестве параметра. Переданное 
      значение можно использовать и модифицировать в любом месте функции, однако 
      любые изменения будут действовать лишь внутри этой функции. Впрочем, 
      специальные ключевые слова позволяют сделать так, чтобы изменения 
      параметров распространялись и за пределы display_copyright(). Эти ключевые 
      слова были представлены в главе 2, в общем обзоре области видимости 
      переменных и ее отношения к функциям. </P>
      <P><A name=d></A>Вложенные функции</P>
      <P>Функции можно вызывать внутри других функций — по аналогии с тем, как 
      одна управляющая конструкция (if, while, for и т. д.) может находиться 
      внутри другой. Такая возможность удобна в любых программах, и в больших, и 
      в малых, поскольку она увеличивает степень модульности приложения и 
      упрощает сопровождение программы. </P>
      <P>В примере, описанном выше, можно полностью избавиться от необходимости 
      модификации даты. Для этого достаточно включить в d1splay_copyright() 
      вызов стандартной функции РНР date( ): </P>
      <P>function display_copyright($site_name) {</P>
      <P>print "Copyright &amp;copy". date("Y"). "$site_name. All Rights 
      Reserved.";</P>
      <P>}</P>
      <P>Параметр Y функции date( ) указывает, что возвращаемое значение 
      представляет собой текущий год, отформатированный в виде четырех цифр. 
      Если системная дата установлена правильно, РНР при каждом выполнении 
      сценария будет выводить год. Функция РНР date( ) отличается исключительной 
      гибкостью и поддерживает 25 разных флагов форматирования даты и времени. 
      </P>
      <P>Также допускается объявление функций внутри других функций. Тем не 
      менее, вложенное объявление еще не делает функцию «защищенной», то есть не 
      ограничивает возможность ее вызова той функцией, в которой она была 
      объявлена. Более того, вложенная функция не наследует параметров 
      родительской функции; параметры должны передаваться ей точно так же, как и 
      любой другой функции. Впрочем, вложенные объявления функций все равно 
      могут использоваться из соображений удобства сопровождения и наглядности. 
      Пример вложенного объявления приведен в листинге 4.1. </P>
      <P>Листинг 4.1. Эффективное использование вложенных функций</P>
      <P>function display_footer($site_name) {</P>
      <P>function display_copyright($site_name) {</P>
      <P>print "Copyright &amp;сору". date("Y").</P>
      <P>$site_name. All Rights Reserved.";</P>
      <P>print "&lt;center&gt;</P>
      <P>&lt;a href = \"\"&gt;home&lt;/a&gt; | &lt;a href = 
      \"\"&gt;recipes&lt;/a&gt; | &lt;a href = 
      \"\"&gt;events&lt;/a&gt;&lt;br&gt;</P>
      <P>&lt;a href = \"\"&gt;tutorials&lt;/a&gt; | &lt;a href = 
      \"\"&gt;about&lt;/a&gt; I &lt;a href = \"\"&gt;contact 
      us&lt;/a&gt;&lt;br&gt;";</P>
      <P>display_copyright($site_name);</P>
      <P>print "&lt;/center&gt;";</P>
      <P>}</P>
      <P>$site_name = "PHP Recipes":</P>
      <P>display_footer($site_name);</P>
      <P>display_copyhght($site_name);</P>
      <P>Сценарий выводит следующий результат: </P>
      <P>home | recipes | events</P>
      <P>tutorials | about | contact us</P>
      <P>Copyright © 2001 PHP Recipes. All Rights Reserved</P>
      <P>Обратите внимание: функцию display_copyright( ) можно вызвать и за 
      пределами display_footer( ) по аналогии стем, как функция display_footer( 
      ) использовалась в предыдущем примере. Концепция защищенных функций в РНР 
      не поддерживается.</P>
      <P>Хотя вложенные функции не защищены от вызова из других точек сценария, 
      они не могут вызываться до вызова своей родительской функции. При попытке 
      вызвать вложенную функцию раньше вызова родительской функции выводится 
      сообщение об ошибке. </P>
      <P><A name=e></A>Возврат значений из функции</P>
      <P>По завершении работы функции часто бывает полезно вернуть некоторое 
      значение, для чего результат вызова функции обычно присваивается некоторой 
      переменной. Функции могут возвращать значения любых типов, в том числе 
      массивы и списки. Пример приведен в листинге 4.2, где функция 
      calculate_cost( ) вычисляет налог с заданной суммы и возвращает общую 
      сумму вместе с налогом. Прежде чем переходить к рассмотрению листинга, 
      просмотрите краткое описание алгоритма на псевдокоде: </P>
      <UL>
        <LI>Перед вызовом функции задать значения переменных: $price (цена 
        товара) и $tax (налоговая ставка). 
        <LI>Объявить функцию calculate_cost( ). При вызове функция получает два 
        параметра: налоговую ставку и цену товара. 
        <LI>Вычислить цену с учетом налога и вернуть ее командой return. 
        <LI>Вызвать calculate_cost() и присвоить значение, возвращенное 
        функцией, переменной $total_cost. 
        <LI>Вывести соответствующее сообщение. </LI></UL>
      <P>Листинг 4.2. Создание функции для вычисления налога </P>
      <P>$price = 24.99; $tax = .06;</P>
      <P>function calculate_cost($tax, $price) { </P>
      <P>$sales_tax = $tax; </P>
      <P>return $price + ($price * $sales_tax); </P>
      <P>} </P>
      <P>// Обратите внимание на возврат значения функцией calculate_cost(). 
      $total_cost = calculate_cost ($tax. $price); </P>
      <P>// Округлить цену до двух десятичных цифр. </P>
      <P>$total_cost = round($total_cost. 2); </P>
      <P>print "Total cost: $".$total_cost;</P>
      <P>// $total cost = 26.49</P>
      <P>Функции, не возвращающие значений, также называются процедурами.</P>
      <P>Существует и другой способ использования возвращаемых значений, при 
      котором вызов функции включается прямо в условную/циклическую команду. В 
      следующей программе (листинг 4.3) сумма счета пользователя сравнивается с 
      предельным размером кредита. Алгоритм на псевдокоде выглядит так: </P>
      <UL>
        <LI>Объявить функцию check_limit( ), которая при вызове получает два 
        параметра. Первый параметр, $total_cost, определяет общую сумму счета, 
        накопленную пользователем до настоящего момента. Второй параметр, 
        $credit_limit, определяет максимальную сумму, которую может потратить 
        пользователь. 
        <LI>Если накопленная сумма счета превышает предельный размер кредита, 
        функция возвращает ложное значение (0). 
        <LI>Если условие команды i f оказывается ложным, работа функции еще не 
        завершена. В этом случае общая сумма не превышает предельного размера 
        кредита, поэтому функция должна вернуть логическую истину. 
        <LI>Вызвать функцию check_limit( ) в условии команды if. Проверить, 
        какое значение было возвращено при вызове — истинное или ложное. В 
        зависимости от результата проверки выполняется то или иное действие. 
        </LI></UL>
      <P>Если при вызове check_limit( ) было получено значение TRUE, мы 
      предлагаем пользователю продолжить закупку. В противном случае 
      пользователь информируется о превышении кредита. </P>
      <P>Листинг 4.3. Сравнение текущей суммы счета пользователя с предельным 
      размером кредита </P>
      <P>$cost = 1456.22;</P>
      <P>$limit = 1000.00;</P>
      <P>function check_limit($total_cost. $credit_limit)</P>
      <P>if ($total_cost &gt; $credit_limit) :</P>
      <P>return 0;</P>
      <P>endif;</P>
      <P>return 1;</P>
      <P>}</P>
      <P>if (check_limit($cost. $limit)) :</P>
      <P>// Продолжить закупки</P>
      <P>print "Keep shopping!";</P>
      <P>else :</P>
      <P>print "Please lower your total bill to less than $".$limit."!";</P>
      <P>endif;</P>
      <P>При выполнении листинга 4.3 будет выведено сообщение об ошибке, 
      поскольку значение $cost превышает $limit. </P>
      <P>Функция также может возвращать сразу несколько значений при помощи 
      списка. Продолжая кулинарную тему, давайте напишем функцию, которая бы 
      возвращала три лучших года для указанного сорта вина. Функция приведена в 
      листинге 4.4, но сначала прочитайте алгоритм на псевдокоде: </P>
      <UL>
        <LI>Объявить функцию best_years( ), вызываемую с одним параметром. 
        Параметр $label определяет сорт вина, для которого пользователь хотел бы 
        узнать три рекомендуемых года. 
        <LI>Объявить два массива, $merlot и $zinfandel. В каждом массиве 
        хранится три рекомендуемых года для соответствующего сорта вина. 
        <LI>Написать команду return, которая бы использовала особые возможности 
        переменных. Выражение $$label сначала интерпретирует переменную $label, 
        а затем интерпретирует полученное значение как имя другой переменной. В 
        настоящем примере массив merlot возвращается в виде списка, и каждый 
        возвращаемый год занимает свою позицию в списке, для которого вызывалась 
        функция. 
        <LI>Вывести сообщение с информацией о рекомендуемых годах. </LI></UL>
      <P>Листинг 4.4. Возвращение функцией нескольких величин</P>
      <P>// Сорт вина, для которого выводятся лучшие годы</P>
      <P>$label = "merlot";</P>
      <P>// Функция использует массивы и "переменную в переменной"</P>
      <P>// для возвращения нескольких значений.</P>
      <P>function best_years($label) {</P>
      <P>$merlot = array("1987", "1983", "1977");</P>
      <P>$zinfandel = array("1992", "1990", "1989");</P>
      <P>return $$label;</P>
      <P>}</P>
      <P>// Функция list( ) используется получения возвращаемых значений. </P>
      <P>list ($yr_one, $yr_two. $yr_three) = best_years($label); </P>
      <P>print "$label had three particularly remarkable years: $yr_one. 
      $yr_two, and $yr_three."; </P>
      <P>Программа выводит следующий результат: </P>
      <P>merlot has three particularly remarkable years: 1987, 1983 and 
1977.</P>
      <P><A name=f></A>Рекурсивные функции</P>
      <P>Ситуация, при которой функция многократно вызывает сама себя, пока не 
      будет выполнено некоторое условие, открывает замечательные возможности. 
      При правильном использовании рекурсивные функции уменьшают объем программы 
      и делают ее более выразительной. Рекурсивные функции особенно часто 
      используются при выполнении повторяющихся действий — например, при поиске 
      в файлах/массивах и построении графических изображений (например, 
      фракталов). Классическим примером рекурсивных функций, встречающимся во 
      многих курсах программирования, является суммирование чисел от 1 до N. 
      Программа, приведенная в листинге 4.5, суммирует все целые числа от 1 до 
      10. </P>
      <P>Листинг 4.5. Использование рекурсивной функции для суммирования 
      последовательных целых чисел </P>
      <P>function summation ($count) {</P>
      <P>if ($count != 0) :</P>
      <P>return $count + summation($count-1);</P>
      <P>endif;</P>
      <P>}</P>
      <P>$sum = summation(10);</P>
      <P>print "Summation = $sum";</P>
      <P>В результате выполнения листинга 4.5 будет выведен следующий результат: 
      </P>
      <P>Summation = 55</P>
      <P>Если функция вызывается достаточно часто, рекурсия делает программу 
      более эффективной. Тем не менее, при использовании рекурсии необходима 
      осторожность, поскольку ошибки могут привести к зацикливанию программы. 
      </P>
      <P><A name=g></A>Функции-переменные</P>
      <P>Одной из интересных возможностей РНР являются функции-переменные 
      (variable functions), то есть динамические вызовы функций, имена которых 
      определяются во время выполнения программы. Хотя в большинстве 
      web-приложений можно обойтись и без функций-переменных, они значительно 
      сокращают объем и сложность программного кода, а также часто снимают 
      необходимость в условных командах if. </P>
      <P>Вызов функции-переменной представляет собой имя переменной, за которым 
      следует пара круглых скобок. В круглых скобках могут перечисляться 
      параметры (однако присутствие параметров не обязательно). Обобщенный 
      синтаксис функции-переменной: </P>
      <P>$имя_функции( );</P>
      <P>Следующая программа (листинг 4.6) демонстрирует эту непривычную, но 
      полезную возможность. Допустим, программа выводит разную информацию в 
      зависимости от языка, выбранного пользователем. В нашем примере для 
      простоты используются приветственные сообщения для англо- и италоязычных 
      пользователей. Алгоритм на псевдокоде: </P>
      <UL>
        <LI>Создать сообщение для итальянского языка в функции с именем italian. 

        <LI>Создать сообщение для английского языка в функции с именем english. 
        <LI>Передать информацию о выбранном языке в сценарий, присвоив значение 
        переменной $language. </LI></UL>
      <P>Переменная $language используется для выполнения функции-переменной (в 
      приведенном примере — italian()). </P>
      <P>Листинг 4.6. Выбор функции в зависимости от пользовательского ввода</P>
      <P>// Приветствие на итальянском языке, function italian( ) {</P>
      <P>" print "Benvenuti al PHP Recipes.";</P>
      <P>}</P>
      <P>// Приветствие на английском языке</P>
      <P>function english( ) {</P>
      <P>print "Welcome to PHP Recipes.";</P>
      <P>}</P>
      <P>// Выбрать итальянский язык</P>
      <P>$language = "italian":</P>
      <P>// Выполнить функцию-переменную</P>
      <P>$language( );</P>
      <P>Листинг 4.6 демонстрирует интересную концепцию функций-переменных и 
      наглядно показывает, что функции-переменные способствуют уменьшению объема 
      программного кода. Если бы не эта возможность, функцию пришлось бы 
      выбирать командой if или switch; это привело бы к заметному увеличению 
      объема программного кода и риску появления дополнительных ошибок при 
      кодировании. </P>
      <P><A href="http.html://doks.gorodok.net/996" name=h></A>Построение библиотек 
      функций</P>
      <P>Библиотеки функций — одно из самых эффективных средств экономии времени 
      при построении приложений. Предположим, вы написали серию функций для 
      сортировки массива. Вероятно, эти функции будут неоднократно 
      использоваться в разных приложениях. Вместо того чтобы постоянно 
      переписывать эти функции в новый сценарий или копировать их через 
      текстовый буфер, гораздо удобнее разместить все функции сортировки в 
      отдельном файле и присвоить ему легко узнаваемое имя (например, 
      array_sorting.inc). Пример такого файла приведен в листинге 4.7. </P>
      <P>Листинг 4.7. Пример библиотеки функций (array_sorting.inc) </P>
      <P>&lt;?</P>
      <P>// Файл: array_sorting.inc</P>
      <P>// Назначение: библиотека функций для сортировки массивов.</P>
      <P>// Дата: 17 июля 2000 г.</P>
      <P>function merge_sort($array. $tmparray, $right, $left) {</P>
      <P>...</P>
      <P>function bubble_sort($array. $n) {</P>
      <P>...</P>
      <P>}</P>
      <P>function quicksort ($array. $right. $left) {</P>
      <P>...</P>
      <P>}</P>
      <P>?&gt;</P>
      <P>Библиотека array_sorting.inc служит накопителем для всех функций 
      сортировки. Это удобно, поскольку функции фактически группируются по 
      своему назначению и при необходимости можно легко найти нужную функцию. 
      Как видно из листинга 4.7, в начало библиотеки обычно включается заголовок 
      из нескольких строк комментария, чтобы при открытии файла библиотеки можно 
      было сразу получить краткую сводку его содержимого. После собственной 
      библиотеки функций можно включить ее в сценарий при помощи команд РНР 
      include( ) и require( ), в результате чего все функции библиотеки 
      становятся доступными. В общем виде синтаксис этих команд выглядит так: 
      </P>
      <P>include(путь/имя_файла);</P>
      <P>require(путь/имя_файла); </P>
      <P>Также существует альтернативный вариант: </P>
      <P>include "путь/имя_файла";</P>
      <P>require "путь/имя_файла"; </P>
      <P>где путь определяет относительный или абсолютный путь к файлу. 
      Конструкции include( ) и requirе( ) подробно описаны в главе 9. А пока 
      достаточно запомнить, что эти конструкции используются для включения файла 
      непосредственно в сценарий. </P>
      <P>Предположим, вы хотите воспользоваться функциями библиотеки 
      array_sorting.inc в сценарии. Пример включения библиотеки показан в 
      листинге 4.8. </P>
      <P>Листинг 4.8. Включение библиотечного файла (array_sorting.inc) в 
      сценарий </P>
      <P>// Предполагается, что библиотека array_sorting.inc</P>
      <P>// находится в одном каталоге со сценарием.</P>
      <P>include("array_sorting.inc");</P>
      <P>// Теперь вы можете использовать любые функции из array_sorting.inc</P>
      <P>$some_array = array (50, 42. 35, 46);</P>
      <P>// Использовать функцию bubble_sort()</P>
      <P>$sorted_array = bubble_sort($some_array, 1);</P>
      <P><A name=i></A>Итоги</P>
      <P>Эта глава посвящена функциям и их применению в РНР. В частности, мы 
      рассмотрели следующие темы: </P>
      <UL>
        <LI>определение и вызов функций; 
        <LI>вложенные функции; 
        <LI>возврат значений из функции; 
        <LI>рекурсивные функции; 
        <LI>функции-переменные; 
        <LI>построение библиотек функций. </LI></UL>
      <P>Хорошее знание этого материала абсолютно необходимо для понимания 
      концепций, рассматриваемых в следующих главах, поскольку функции 
      используются везде, где это возможно. Как и в других главах, я рекомендую 
      поэкспериментировать с примерами, чтобы лучше усвоить изложенный материал. 
      </P>
      <P>Глава 5 посвящена массивам — несомненно, эта тема заметно обогатит ваши 
      познания в РНР. В главе 5 мы познакомимся с основными принципами хранения 
      данных, постепенно продвигаясь к более содержательным и, в конечном счете, 
      более интересным приложениям. </P></LI></DIV>
<center>
[ <a href="03.php">Назад</a> | <a href="index.php">Содержание</a> | <a href="05.php">Вперед</a> ]
</center><br>
<? include_once '../../sys/inc/tfoot.php'; ?>