<?include'h.php';?>
<html><head>
		<title>Учебник PHP, Глава 5</title>
		<meta http-equiv="Content-type" content="text/html; charset=Windows-1251">
		</head>
		
      <DIV class=infotxt>
      <LI><A href="#a">Глава 5. Массивы </A>
      <UL>
        <LI><A href="#b">Создание массивов </A>
        <LI><A href="#c">Многомерные массивы </A>
        <LI><A href="#d">Ссылки на многомерные 
        массивы </A>
        <LI><A href="#e">Поиск элементов массива 
        </A>
        <LI><A href="#f">Добавление и удаление 
        элементов </A>
        <LI><A href="#g">Перебор элементов </A>
        <LI><A href="#h">Размер массива </A>
        <LI><A href="#i">Сортировка массивов </A>
        <LI><A href="#j">Другие полезные функции 
        </A>
        <LI><A href="#k">Итоги </A></LI></UL>
      <UL></UL><A name=a></A>
      <P>&nbsp;</P>
      <P>ГЛАВА 5</P>
      <P>Массивы</P>
      <P>В главе 2 были представлены две разновидности массивов, используемых в 
      программах РНР, — индексируемые и ассоциативные. Вероятно, вы помните, что 
      в индексируемых массивах при обращении к элементу указывается его позиция, 
      а в ассоциативных массивах для этой цели используется специальный ключ. 
      Обе разновидности массивов обладают гибкими и мощными средствами для 
      работы с большими объемами данных</P>
      <P>В этой главе рассматриваются различные средства РНР по работе с 
      массивами. К концу этой главы вы познакомитесь с одномерными и 
      многомерными массивами, сортировкой и перебором элементов, а также с 
      другими возможностями, часто используемыми при работе с массивами. Книгу 
      не стоит рассматривать как подробный справочник по всем существующим 
      функциям, хотя так уж получилось, что в этой главе рассматриваются 
      практически все функции массивов. Последнюю версию списка функций можно 
      найти на домашней странице РНР по адресу <A 
      href="http.html://www.php.net/">http://www.php.net/</A>.</P>
      <P><A href="http.html://doks.gorodok.net/0" name=b></A>Создание массивов</P>
      <P>Массив представляет собой совокупность объектов, имеющих одинаковые 
      размер и тип. Каждый объект в массиве называется элементом массива. 
      Создать новый массив в РНР несложно. При объявлении индексируемого массива 
      после имени переменной ставится пара квадратных скобок ([ ]):</P>
      <P>$languages [ ] = "Spanish";&nbsp;</P>
      <P>// $languages[0] = "Spanish"</P>
      <P>После этого в массив можно добавлять новые элементы, как показано ниже. 
      Обратите внимание: новые элементы добавляются без явного указания индекса. 
      В этом случае новый элемент добавляется в позицию, равную длине массива 
      плюс 1:</P>
      <P>$languages[ ] = "English"; // $1anguages[l] = "English";&nbsp;</P>
      <P>$languagest ] = "Gaelic"; // $languages[2] = "Gaelic";</P>
      <P>Кроме того, новые элементы можно добавлять в конкретную позицию 
      массива. Для этого указывается индекс нрвого элемента:</P>
      <P>$languages[15] = "Italian";&nbsp;</P>
      <P>$languages[22] = "French";</P>
      <P>Ассоциативные массивы создаются аналогичным образом:</P>
      <P>$languages["Spain"] = "Spanish";&nbsp;</P>
      <P>$languages["France"] = "French";</P>
      <P>При создании массивов используются три стандартные языковые 
      конструкции:</P>
      <UL>
        <LI>аrrау( ); 
        <LI>list( ); 
        <LI>range( ). </LI></UL>
      <P>Хотя все три случая приводят к одному результату — созданию массива, в 
      некоторых случаях одна конструкция может оказаться предпочтительнее 
      других. Далее приведены описания и примеры использования каждой 
      конструкции.</P>
      <P>аггау( )</P>
      <P>Функция array( ) получает ноль или более элементов и возвращает массив, 
      состоящий из указанных элементов. Ее синтаксис:</P>
      <P>array array ( [элемент1, элемент2...] )</P>
      <P>Вероятно, array( ) является всего лишь более наглядной записью для 
      создания массива, используемой для удобства программиста. Ниже показан 
      пример использования array( ) для создания индексируемого массива:</P>
      <P>$languages = array ("English". "Gaelic". "Spanish");</P>
      <P>// $languages[0] = "English". $languages[1] = "Gaelic",</P>
      <P>// $languages[2] = "Spanish"</P>
      <P>А вот как array( ) используется при создании ассоциативных 
массивов:</P>
      <P>$languages = array("Spain" =&gt; "Spanish",</P>
      <P>"Ireland" =&gt; "Gaelic".</P>
      <P>"United States" =&gt; "English");</P>
      <P>// $languages["Spain"] = "Spanish"</P>
      <P>// $languages["Ireland"] = "Gaelic"</P>
      <P>// $languages["United States"] = "English"</P>
      <P>Ассоциативные массивы особенно удобны в тех ситуациях, когда числовые 
      индексы не имеют логического соответствия. Например, в предыдущем примере 
      названия стран вполне естественно ассоциируются с языками. Попробуйте-ка 
      воплотить эту логическую связь при помощи цифр!</P>
      <P>list( )</P>
      <P>Конструкция list( ) похожа на аrrау( ), однако ее главная задача — 
      одновременное присваивание значений, извлеченных из массива, сразу 
      нескольким переменным. Синтаксис команды list( ):</P>
      <P>void list (переменная1 [. переменная2 , ...] )</P>
      <P>Конструкция list() особенно удобна при чтении информации из базы данных 
      или файла. Допустим, вы хотите отформатировать и вывести данные, 
      прочитанные из текстового файла. Каждая строка файла содержит сведения о 
      пользователе (имя,</P>
      <P>профессия и любимый цвет); компоненты записи разделяются вертикальной 
      чертой (|). Типичная строка выглядит так:</P>
      <P>Nino Sanzi|Professional Golfer|green</P>
      <P>При помощи list ( ) можно написать простой цикл, который будет читать 
      каждую строку, присваивать ее компоненты переменным, форматировать и 
      отображать данные. Приведенный ниже листинг демонстрирует возможность 
      одновременного присваивания нескольким переменным с использованием list ( 
      ):</P>
      <P>// Читать строки, пока не будет достигнут конец файла&nbsp;</P>
      <P>while ($line = fgets ($user_file. 4096)) :</P>
      <P>// Разделить строку функцией split( ).</P>
      <P>// Компоненты присваиваются переменным Sname. $occupation и Scolor.</P>
      <P>list ($name, $occupation, $color) = split( "|", $line);</P>
      <P>// Отформатировать и вывести данные</P>
      <P>print "Name: Sname &lt;br&gt;";</P>
      <P>print "Occupation: Soccupation &lt;br&gt;";</P>
      <P>print "Favorite color: Scolor &lt;br&gt;";</P>
      <P>endwhile;</P>
      <P>Каждая строка файла читается, форматируется и выводится в следующем 
      виде:</P>
      <P>Name: Nino Sanzi</P>
      <P>Occupation: Professional Golfer</P>
      <P>Favorite color: green</P>
      <P>В приведенном примере применение list( ) зависит от разделения строки 
      на элементы функцией split( ). Элементы, полученные в результате деления, 
      присваиваются, соответственно, переменным $name, $occupation и $color. 
      Дальше все сводится к форматированию данных для вывода в конкретном 
      браузере. Удобные средства лексического анализа текстовых файлов являются 
      одной из сильных сторон РНР. Эта тема подробно рассматривается в главах 7 
      и 8.</P>
      <P>range ( )</P>
      <P>Конструкция range( ) позволяет легко и быстро создать массив целых 
      чисел из интервала, определяемого верхней и нижней границами. Range( ) 
      возвращает массив, состоящий из всех целых чисел указанного интервала. 
      Синтаксис range( ):</P>
      <P>array range (int нижняя_граница, int верхняя граница)</P>
      <P>Следующий пример наглядно показывает, насколько удобна эта 
      конструкция:</P>
      <P>$lottery = range(0,9);</P>
      <P>// $lottery = array(0,1,2,3,4,5,6,7,8,9)</P>
      <P>Как видно из приведенного фрагмента, в параметрах range( ) был указан 
      интервал от 0 до 9 и массив $lottery был заполнен целыми числами из этого 
      интервала.</P>
      <P><A name=c></A>Многомерные массивы</P>
      <P>Со временем ваши программы станут более сложными, и возможностей 
      простых одномерных массивов окажется недостаточно для хранения необходимой 
      информации. Многомерный массив (массив массивов) предоставляет в 
      распоряжение программиста более эффективные средства для хранения 
      информации, требующей дополнительного структурирования. Создать 
      многомерный массив несложно — просто добавьте дополнительную пару 
      квадратных скобок, чтобы вывести массив в новое измерение:</P>
      <P>$chessboard [1] [4] = "King"; // Двухмерный массив</P>
      <P>$capitals["USA"] ["Ohio"] = "Columbus": // Двухмерный массив</P>
      <P>$streets["USA"]["Ohio"]["Columbus"] = "Harrison"; // Трехмерный 
      массив</P>
      <P>В качестве примера рассмотрим массив, в котором хранится информация о 
      десертах и особенностях их приготовления. Обойтись одномерным массивом 
      было бы довольно трудно, но двухмерный массив подходит как нельзя 
      лучше:</P>
      <P>$desserts = аrrау(</P>
      <P>"Fruit Cup" =&gt; array (</P>
      <P>"calories" =&gt; "low",</P>
      <P>"served" -&gt; "cold",</P>
      <P>"preparation" =&gt; "10 minutes"</P>
      <P>),</P>
      <P>"Brownies" =&gt; array (</P>
      <P>"calories" -&gt; "high",</P>
      <P>"served" =&gt; "piping hot",</P>
      <P>"preparation" =&gt; "45 minutes"</P>
      <P>)</P>
      <P>);</P>
      <P>После создания массива к его элементам можно обращаться по 
      соответствующим ключам:</P>
      <P>$desserts["Fruit Cup"]["preparation"] // возвращает "10 minutes"</P>
      <P>$desserts["Brownies"]["calories"] // возвращает "high"</P>
      <P>Присваивание значений элементам многомерных массивов выполняется так 
      же, как и в одномерных массивах:</P>
      <P>$desserts["Cake"]["calories"] = "too many";</P>
      <P>// Присваивает свойству "calories" объекта "Cake" значение "too 
      many"</P>
      <P>Хотя в многомерных массивах появляются новые уровни логической 
      организации данных, многомерные массивы создаются практически так же, как 
      и одномерные. Впрочем, ссылки на многомерные массивы в строках требуют 
      особого внимания; этой теме посвящен следующий раздел.</P>
      <P><A name=d></A>Ссылки на многомерные массивы</P>
      <P>Ссылки на элементы многомерных массивов внутри строк несколько 
      отличаются от ссылок на другие типы данных. Возможны два варианта. 
      Во-первых, можно воспользоваться оператором конкатенации:</P>
      <P>print "Brownies are good, but the calories content is ".</P>
      <P>$desserts["Brownies"]["calories"];</P>
      <P>Во-вторых, ссылку на элемент многомерного массива можно заключить в 
      фигурные скобки ({ }):</P>
      <P>print "Brownies are good, but the calories content is</P>
      <P>{$desserts[Brownies][calories]}";</P>
      <P>Обратите внимание на отсутствие кавычек вокруг ключей. Также следует 
      помнить, что между фигурными скобками и ссылкой не должно быть лишних 
      пробелов. Если хотя бы одно из этих условий не выполняется, произойдет 
      ошибка. Впрочем, годятся оба способа. Я рекомендую выбрать один формат и 
      придерживаться его, чтобы ваши программы выглядели более последовательно. 
      Если не использовать какой-либо из этих способов форматирования, ссылки на 
      многомерные массивы будут интерпретироваться буквально, что наверняка 
      приведет к непредвиденным результатам.</P>
      <P><A name=e></A>Поиск элементов массива</P>
      <P>Поиск элементов относится к числу важнейших операций с массивами. В РНР 
      существует несколько стандартных функций, позволяющих легко находить в 
      массиве нужные ключи и значения.</P>
      <P>in_array( )</P>
      <P>Функция i n_array ( ) проверяет, присутствует ли в массиве заданный 
      элемент. Если поиск окажется удачным, функция возвращает TRUE, в противном 
      случае возвращается FALSE. Синтаксис функции in_array( ):</P>
      <P>bool in_array(mixed элемент, array массив) </P>
      <P>Эта функция особенно удобна тем, что вам не приходится в цикле 
      перебирать весь массив в поисках нужного элемента. В следующем примере 
      функция in_array( ) ищет элемент "Russian" в массиве $languages:</P>
      <P>$languages = array("English", "Gaelic", "Spanish"):</P>
      <P>$exists = in_array("Russian", $languages); // $exists присваивается 
      FALSE</P>
      <P>$exists = in_array("English", $languages): // $exists присваивается 
      TRUE</P>
      <P>Функция in_array( ) часто встречается в управляющих конструкциях, когда 
      ее возвращаемое значение (TRUE/FALSE) используется для выбора одного из 
      двух вариантов продолжения. В следующем примере функция in_array( ) 
      используется для выбора одного из двух вариантов в условной команде 
if:</P>
      <P>// Ввод данных пользователем</P>
      <P>$language = "French"; $email = "wjgilmore@hotmail.com";</P>
      <P>// Если язык присутствует в массиве</P>
      <P>if (in_array($language. $languages)) :</P>
      <P>// Подписать пользователя на бюллетень.</P>
      <P>// Обратите внимание: в РНР нет стандартной функции с именем</P>
      <P>// subscribe_user(). В данном примере эта функция просто имитирует</P>
      <P>// процесс подписки.</P>
      <P>subscribe_user($email, $language);</P>
      <P>print "You are now subscribed to the $language edition of the 
      newsletter.";</P>
      <P>// Язык отсутствует в массиве</P>
      <P>else :</P>
      <P>print "We're sorry, but we don't yet offer a $language edition of the 
      newsletter".</P>
      <P>endif;</P>
      <P>Что происходит в этом примере? Допустим, переменные $language и $email 
      содержат данные, введенные пользователем. Вы хотите убедиться в том, что 
      указанный язык поддерживается вашей системой, и используете для этой цели 
      функцию in_array( ). Если название языка присутствует в массиве, 
      пользователь подписывается на бюллетень и получает соответствующее 
      сообщение. В противном случае программа сообщает, что на указанном языке 
      бюллетень не распространяется. Конечно, в настоящей программе пользователь 
      не должен гадать, какие языки поддерживаются вашей программой. Задача 
      решается при помощи раскрывающегося списка — эта тема подробно 
      рассматривается в главе 10. Здесь этот пример всего лишь демонстрирует 
      возможности работы с массивами.</P>
      <P>array_keys( )</P>
      <P>Функция array_keys( ) возвращает массив, содержащий все ключи исходного 
      массива, переданного в качестве параметра. Если при вызове передается 
      дополнительный параметр искомый_элемент, возвращаются только ключи, 
      которым соответствует заданное значение; в противном случае возвращаются 
      все ключи массива. Синтаксис функции array_keys( ):</P>
      <P>array array_keys (array массив [, mixed искомый_элемент])</P>
      <P>Рассмотрим пример использования функции array_keys( ) для получения 
      ключа заданного элемента:</P>
      <P>$great_wines = array ("Australia" =&gt; "Clarendon Hills 96",</P>
      <P>"France" =&gt; "Comte George de Vogue 97",</P>
      <P>"Austria" =&gt; "Feiler Artinger 97");</P>
      <P>$great_labels = array_keys($great_wines);</P>
      <P>// $great_labels = array("Australia", "France", "Austria");</P>
      <P>$great_labels = array_keys($great_wines, "Clarendon Hills 96");</P>
      <P>// $great_labels = array("Australia");</P>
      <P>Функция array_keys( ) позволяет очень легко получить все ключи 
      ассоциативного массива — например, в предыдущем случае ими были названия 
      стран, в которых производятся различные сорта вин.</P>
      <P>array_values( )</P>
      <P>Функция array_values( ) возвращает массив, состоящий из всех значений 
      исходного массива, переданного в качестве параметра. Синтаксис функции 
      array_values( ): </P>
      <P>array array_values(array массив) </P>
      <P>Вернемся к предыдущему примеру, в котором функция array_keys( ) 
      использовалась для получения всех значений ключей. На этот раз функция 
      array_values( ) возвращает все значения, соответствующие ключам:</P>
      <P>// $great_wines = array ("Australia" =&gt; "Clarendon Hills 96",</P>
      <P>// "France" =&gt; "Comte George de Vogue 97",</P>
      <P>// "Austria" =&gt; "Feiler Artinger 97");</P>
      <P>$great_labels = array_values($great_wines);</P>
      <P>// $great_labels = аrrау("Clarendon Hills 96",</P>
      <P>// "Comte George de Vogue 97",</P>
      <P>// "Feiler Artinger 97");</P>
      <P>Функции array_keys( ) и array_values( ) дополняют друг друга, позволяя 
      при необходимости получить все составляющие той или иной стороны 
      ассоциативного массива.</P>
      <P><A name=f></A>Добавление и удаление элементов</P>
      <P>К счастью, в РНР при создании массива не нужно указывать максимальное 
      количество элементов. Это увеличивает свободу действий при операциях с 
      массивами, поскольку вам не приходится беспокоиться о случайном выходе за 
      границы массива, если количество элементов превысит ожидаемый порог. В РНР 
      существует несколько функций для увеличения размеров массива. Некоторые из 
      них были созданы для удобства программистов, привыкших работать с 
      различными типами очередей и стеков (FIFO, FILO и т. д.), что отражается в 
      названиях функций (push, pop, shift и unshift). Но даже если вы не знаете, 
      что такое «очередь» или «стек», не огорчайтесь — в этих функциях нет 
      ничего сложного.</P>
      <P>Очередью (queue) называется структура данных, из которой элементы 
      извлекаются в порядке поступления. Стеком (stack) называется структура 
      данных, из которой элементы извлекаются в порядке, обратном порядку их 
      поступления.</P>
      <P>array_push( )</P>
      <P>Функция array_push( ) присоединяет (то есть дописывает в конец массива) 
      один или несколько новых элементов. Синтаксис функции array_push( ): </P>
      <P>int array_push(array массив, mixed элемент [, ...]) </P>
      <P>Длина массива возрастает прямо пропорционально количеству его 
      элементов. Это продемонстрировано в следующем примере:</P>
      <P>$languages = array("Spanish", "English", "French");</P>
      <P>array_push($languages, "Russian", "German", "Gaelic");</P>
      <P>// $languages = array("Spanish", "English", "French",</P>
      <P>// "Russian", "German", "Gaelic")</P>
      <P>У функции array_push( ), как и у многих стандартных функций РНР, 
      существует «двойник» — функция аrrау_рор( ), предназначенная для 
      извлечения элементов из массива. Главное различие между этими функциями 
      заключается в том, что array_push( ) может добавлять несколько элементов 
      одновременно, а аrrау_рор( ) удаляет элементы только по одному.</P>
      <P>аrrау_рор( )</P>
      <P>Результат работы функции аrrау_рор( ) прямо противоположен array_push( 
      ) — эта функция извлекает (то есть удаляет) последний элемент из массива. 
      Извлеченный элемент возвращается функцией. Синтаксис функции аrrау_рор( 
      ):</P>
      <P>аrrау_рор(аrrау массив) </P>
      <P>При каждом выполнении аrrау_рор( ) размер массива уменьшается на 1. 
      Рассмотрим пример:</P>
      <P>$languages = array("Spanish", "English", "French",</P>
      <P>"Russian", "German", "Gaelic");</P>
      <P>$a_language = array_pop($languages): // $a_language = "Gaelic"</P>
      <P>$a_language = array_pop($languages): // $a_language = "German"</P>
      <P>// $languages = array ("Spanish", "English", "French", "Russian");</P>
      <P>Функции array_push( ), и array_pop( ) удобны тем, что с их помощью 
      можно выполнять операции с элементами и управлять размером массива, не 
      беспокоясь о неинициализированных или пустых элементах. Такое решение 
      работает намного эффективнее, чем любые попытки управления этими факторами 
      со стороны программиста.</P>
      <P>array_shift( )</P>
      <P>Функция array_shift( ) аналогична аrrау_рор( ) с одним отличием: 
      элемент удаляется из начала (левого края) массива. Все остальные элементы 
      массива сдвигаются на одну позицию к началу массива. У функции 
      array_shift( ) такой же синтаксис, как и у аггау_рор( ): </P>
      <P>array_shift(array массив) </P>
      <P>При работе с функцией array_shift( ) необходимо помнить, что элементы 
      удаляются из начала массива, как показывает следующий пример:</P>
      <P>$languages = array("Spanish", "English", "French", "Russian");</P>
      <P>$a_language = array_shift($languages); // $a_language = "Spanish";</P>
      <P>// $languages = array("English", "French", "Russian");</P>
      <P>array_unshift( )</P>
      <P>Функция array_unshift( ) дополняет array_shift( ) — новый элемент 
      вставляется в начало массива, а остальные элементы сдвигаются на одну 
      позицию вправо. Синтаксис команды array_unshift( ): </P>
      <P>1nt array_unshift(array массив, mixed переменная1 [....переменная2]) 
      </P>
      <P>При одном вызове функции можно добавить как один, так и несколько 
      элементов, при этом размер массива возрастает пропорционально количеству 
      добавленных элементов. Пример добавления нескольких элементов:</P>
      <P>$languages = array("French", "Italian", "Spanish");</P>
      <P>array_unshift($languages, "Russian", "Swahili", "Chinese");</P>
      <P>// $languages = array("Russian", "Swahili", "Chinese",</P>
      <P>// "French", "Italian", "Spanish");</P>
      <P>array_pad( )</P>
      <P>Функция array_pad( ) позволяет быстро увеличить массив до желаемого 
      размера посредством его дополнения стандартными элементами. Синтаксис 
      функции array_pad( ): </P>
      <P>array arrap_pad(array массив, int размер, mixed значение): </P>
      <P>Параметр размер определяет новую длину массива. Параметр значение 
      задает стандартное значение, присваиваемое элементам во всех новых 
      позициях массива. При использовании array_pad( ) необходимо учитывать 
      некоторые обстоятельства:</P>
      <P>Если размер положителен, массив дополняется справа, а если отрицателен 
      — слева.</P>
      <P>Если абсолютное значение параметра размер меньше либо равно длине 
      массива, никаких действий не выполняется.</P>
      <P>Абсолютным значением (модулем) целого числа называется его значение без 
      знака. Например, абсолютное значение чисел 5 и -5 равно 5.</P>
      <P>Пример дополнения массива с конца:</P>
      <P>$weights = array(1, 3, 5, 10, 15, 25, 50);</P>
      <P>$weights = array_pad($weights. 10, 100);</P>
      <P>// Результат: $weights = array(1, 3, 5, 10, 15, 25, 50, 100, 100, 
      100);</P>
      <P>Пример дополнения массива с начала:</P>
      <P>$weights = array(1, 3, 5, 10, 15, 25, 50);</P>
      <P>$weights = array_pad($weights, -10, 100);</P>
      <P>// Результат: $weights = array(100, 100, 100, 1, 3, 5, 10, 15, 25, 
      50);</P>
      <P>Неправильная попытка дополнения массива:</P>
      <P>$weights = array(1, 3, 5, 10, 15, 25, 50);</P>
      <P>$weights = array_pad($weigtits, 3, 100);</P>
      <P>// Массив $weights не изменяется:</P>
      <P>// $weights = array(1, 3, 5, 10, 15, 25, 50);</P>
      <P><A name=g></A>Перебор элементов</P>
      <P>В РНР существует несколько стандартных функций, предназначенных для 
      перебора элементов массива. В совокупности эти функции обеспечивают гибкие 
      и удобные средства для быстрой обработки и вывода содержимого массивов. 
      Вероятно, вы будете часто использовать эти функции, поскольку они лежат в 
      основе практически всех алгоритмов работы с массивами.</P>
      <P>reset( )</P>
      <P>Функция reset( ) переводит внутренний указатель текущей позиции в 
      массиве к первому элементу. Кроме того, она возвращает значение первого 
      элемента. Синтаксис функции reset( ):</P>
      <P>mixed reset (array массив)</P>
      <P>Рассмотрим следующий массив:</P>
      <P>$fruits = array("apple", "orange", "banana");</P>
      <P>Допустим, указатель текущей позиции в этом массиве установлен на 
      элемент "orange". Команда:</P>
      <P>$a_fruit = reset($fruits);</P>
      <P>вернет указатель в начало массива, то есть на элемент "apple", и вернет 
      это значение, если результат вызова reset( ) используется в программе. 
      Возможен и упрощенный вариант вызова:</P>
      <P>reset($fruits);</P>
      <P>В этом случае указатель переходит к первому элементу массива, а 
      возвращаемое значение не используется.</P>
      <P>each ( )</P>
      <P>Функция each( ) при каждом вызове выполняет две операции: она 
      возвращает пару «ключ/значение», на которую ссылается указатель текущей 
      позиции, и перемещает указатель к следующему элементу. Синтаксис функции 
      each( ):</P>
      <P>array each (array массив)</P>
      <P>Для удобства each ( ) возвращает ключ и значение в виде массива из 
      четырех элементов; ключами этого массива являются 0, 1, value и key. 
      Возвращаемый ключ ассоциируется с ключами 0 и key, а возвращаемое значение 
      — с ключами 1 и value.</P>
      <P>В следующем примере функция each ( ) возвращает элемент, находящийся в 
      текущей позиции:</P>
      <P>// Объявить массив из пяти элементов</P>
      <P>$spices = array("parsley", "sage", "rosemary", "thyme", "pepper");</P>
      <P>// Установить указатель на первый элемент массива</P>
      <P>reset($spices);</P>
      <P>// Создать массив $a_sp1ce. состоящий из четырех элементов</P>
      <P>$a_spice = each($spices);</P>
      <P>В результате выполнения приведенного фрагмента массив $a_spice будет 
      содержать следующие пары «ключ/значение»:</P>
      <UL>
        <LI>0 =&gt; 0; 
        <LI>1 =&gt; "parsley"; 
        <LI>key =&gt; 0; 
        <LI>value =&gt; "parsley". </LI></UL>
      <P>После этого строку "parsley" можно вывести любой из следующих 
      команд:</P>
      <P>print $a_spice[1]: print $a_spice["value"];</P>
      <P>Функция each() обычно используется в сочетании с list( ) в циклических 
      конструкциях для перебора всех или некоторых элементов массива. При каждой 
      итерации each( ) возвращает либо следующую пару «ключ/значение», либо 
      логическую ложь при достижении последнего элемента массива. Вернемся к 
      массиву $spices; чтобы вывести все элементы на экран, можно 
      воспользоваться следующим сценарием:</P>
      <P>// Сбросить указатель текущей позиции</P>
      <P>reset($spices);</P>
      <P>// Перебрать пары "ключ/значение", ограничиваясь выводом значения</P>
      <P>while (list ($key, $val) = each ($spices) ) :</P>
      <P>print "$val &lt;br&gt;"</P>
      <P>endwhile;</P>
      <P>Ниже приведен более интересный пример использования each( ) в сочетании 
      с другими функциями, описанными в этой главе. Листинг 5.1 показывает, как 
      при помощи этих функций вывести отформатированную таблицу стран и 
      языков.</P>
      <P>Листинг 5.1. Построение таблицы HTML по содержимому массива</P>
      <P>// Объявить ассоциативный массив стран и языков $languages = array 
      ("Country" =&gt; "Language",</P>
      <P>"Spain" =&gt; "Spanish",</P>
      <P>"USA" =&gt; "English",</P>
      <P>"France" =&gt; "French",</P>
      <P>"Russia" =&gt; "Russian");</P>
      <P>// Начать новую таблицу</P>
      <P>print "&lt;table border=l&gt;";</P>
      <P>// Переместить указатель к позиции первого элемента</P>
      <P>reset ($languages);</P>
      <P>// Прочитать первый ключ и элемент</P>
      <P>$hdl = key ($languages);</P>
      <P>Shd2 = $languages[$hd1];</P>
      <P>// Вывести первый ключ и элемент в виде заголовков таблицы</P>
      <P>print 
      "&lt;tr&gt;&lt;th&gt;$hd1&lt;/th&gt;&lt;th&gt;$hd2&lt;/th&gt;&lt;/tr&gt;";</P>
      <P>next($languages);</P>
      <P>// Выводить строки таблицы с ключами и элементами массива</P>
      <P>while (list ($ctry,$lang) = each ($languages)) :</P>
      <P>print 
      "&lt;tr&gt;&lt;td&gt;Sctry&lt;/td&gt;&lt;td&gt;$lang&lt;/td&gt;&lt;/tr&gt;";</P>
      <P>endwhile;</P>
      <P>// Завершить таблицу print "&lt;/table&gt;";</P>
      <P>?&gt;</P>
      <P>В результате выполнения этого кода будет построена следующая таблица 
      HTML.</P>
      <TABLE height=119 cellSpacing=0 cellPadding=0 width=100% border=1>
        <TBODY>
        <TR>
          <TD vAlign=top align=middle width=92 height=19>
            <P>Country</P></TD>
          <TD vAlign=top align=middle width=170 height=19>
            <P>Language</P></TD></TR>
        <TR>
          <TD vAlign=top align=middle width=92 height=18>Spain </TD>
          <TD vAlign=top align=middle width=170 height=18>Spanish </TD></TR>
        <TR>
          <TD vAlign=top align=middle width=100 height=16>USA </TD>
          <TD vAlign=top align=middle width=170 height=16>English </TD></TR>
        <TR>
          <TD vAlign=top align=middle width=92 height=17>France </TD>
          <TD vAlign=top align=middle width=170 height=17>French </TD></TR>
        <TR>
          <TD vAlign=top align=middle width=92 height=19>Russia </TD>
          <TD vAlign=top align=middle width=170 height=19>Russian 
        </TD></TR></TBODY></TABLE>
      <P>Этот пример дает представление о самой сильной стороне РНР — 
      возможности объединения динамического кода с HTML для получения 
      наглядного, отформатированного представления прочитанных данных.</P>
      <P>end( )</P>
      <P>Функция end( ) перемещает указатель к позиции последнего элемента 
      массива. Синтаксис функции end( ):</P>
      <P>end (array массив)</P>
      <P>next( )</P>
      <P>Функция next ( ) смещает указатель на одну позицию вперед, после чего 
      возвращает элемент, находящийся в новой позиции. Если в результате 
      смещения</P>
      <P>указатель выйдет за пределы массива, next ( ) возвращает ложное 
      значение. Синтаксис функции next ( ):</P>
      <P>mixed next (array массив)</P>
      <P>Недостаток функции 
      next ( ) заключается в том, что ложное значение возвращается и для 
      существующих, но пустых элементов массива. Если вы хотите провести обычный 
      перебор, воспользуйтесь функцией each( ).</P>
      <P>prev( )</P>
      <P>Функция prev( ) аналогична next ( ) за одним исключением: указатель 
      смещается на одну позицию к началу массива, после чего возвращается 
      элемент, находящийся в новой позиции. Если в результате смещения указатель 
      окажется перед первым элементом массива, prev( ) вернет ложное значение. 
      Синтаксис функции prev( ):</P>
      <P>mixed prev (array массив)</P>
      <P>Недостаток функции prev( ) заключается в том, что ложное значение 
      возвращается и для существующих, но пустых элементов массива. Если вы 
      хотите провести обычный перебор, воспользуйтесь функцией each( ).</P>
      <P>array_walk( )</P>
      <P>Функция array_walk( ) позволяет применить функцию к нескольким (а 
      возможно, всем) элементам массива. Синтаксис функции array_walk( ):</P>
      <P>int array_walk(array массив, string имя_функции [, mixed данные])</P>
      <P>Функция, заданная параметром имя_функции, может использоваться для 
      различных целей — например, для поиска элементов с определенными 
      характеристиками или модификации содержимого массива. В ассоциативных 
      массивах функция имя_функции должна получать минимум два параметра — 
      элемент массива и ключ. Если указан необязательный третий параметр данные, 
      он становится третьим параметром. В следующем примере функция array_walk( 
      ) используется для удаления дубликатов из массива:</P>
      <P>function delete_dupes($element) {</P>
      <P>static $last=""; if ($element == $last)</P>
      <P>unset($element); else . ''</P>
      <P>$last=$element:</P>
      <P>}</P>
      <P>$emails = array("blah@blah.com", "chef@wjgilmore.com", 
      "blah@blah.com");</P>
      <P>sort($emails);</P>
      <P>reset($emails);</P>
      <P>array_walk($emails,"delete_dupes");</P>
      <P>// $emails = array("chef@wjgilmore.com", "blah@blah.com");</P>
      <P>array_reverse( )</P>
      <P>Функция array_reverse( ) позволяет легко перейти к противоположному 
      порядку элементов, составляющих массив. Синтаксис функции array_reverse( 
      ): </P>
      <P>array array_reverse(array массив) </P>
      <P>Рассмотрим пример использования функции array_reverse( ):</P>
      <P>$us_wireproducers = array ("California", "Oregon", "New York". 
      "Washington");</P>
      <P>$us_wine_producers - array_reverse (Sus_wine_producers);</P>
      <P>// $us_wine_producers = array ("Washington". "New York", "Oregon". 
      "California");</P>
      <P>При вызове array_reverse( ) для ассоциативного массива пары 
      «ключ/значение» сохраняются, изменяется только порядок элементов 
      массива.</P>
      <P>array_flip( )</P>
      <P>Функция array_flip( ) меняет местами ключи и значения элементов 
      массива. Синтаксис функции array_flip( ): </P>
      <P>array array_flip(array массив) </P>
      <P>В следующем примере функция array_flip( ) меняет местами все ключи и 
      значения элементов:</P>
      <P>$languages = array("Spain" =&gt; "Spanish", "France" =&gt; "French", 
      "Italy" =&gt; "Italian");</P>
      <P>$languages = array_flip($languages);</P>
      <P>// $languages = array("Spanish" =&gt; "Spain", // "French" =&gt; 
      "France", // "Italian" =&gt; "Italy");</P>
      <P>Помните: функция array_flip( ) не изменяет порядок элементов массива. 
      Для этой цели используется функция array_reverse( ).</P>
      <P><A href="http.html://doks.gorodok.net/996" name=h></A>Размер массива</P>
      <P>Наличие информации о текущем размере массива часто позволяет повысить 
      эффективность сценария. Вероятно, размер массива чаще всего используется 
      при циклическом переборе элементов:</P>
      <P>$us_wine_producers = array ("Washington". "New York", "Oregon", 
      "California");</P>
      <P>for (Si = 0; Si &lt; sizeof ($us_wine_producers); $i++) :</P>
      <P>print "$us_wine_producers[$i]";</P>
      <P>endfor;</P>
      <P>Поскольку массив $us_wine_producers индексируется целыми числами, мы 
      можем воспользоваться циклом for для циклического увеличения 
      переменной-счетчика ($i) и вывода каждого элемента в массиве.</P>
      <P>sizeof( )</P>
      <P>Функция sizeof ( ) возвращает количество элементов в массиве. Синтаксис 
      функции sizeof ( ):</P>
      <P>int sizeof (array массив) </P>
      <P>Вероятно, функция sizeof ( ) будет часто встречаться в ваших 
      web-приложениях. Ниже приведен краткий пример ее использования (кстати, 
      предыдущий пример тоже относится к числу стандартных применений sizeof ( 
      )):</P>
      <P>$pasta = array("bowties", "angelhair", "rigatoni");</P>
      <P>$pasta_size = sizeof($pasta);</P>
      <P>// $pasta_size = 3</P>
      <P>У функции sizeof ( ) существует и другая, расширенная форма — count ( ) 
      (см. ниже).</P>
      <P>count( )</P>
      <P>Функция count( ) выполняет ту же операцию, что и sizeof ( ), — она 
      возвращает количество значений, содержащихся в массиве. Синтаксис функции 
      count ( ):</P>
      <P>int count (mixed переменная)</P>
      <P>Единственное различие между sizeof ( ) и count( ) заключается в том, 
      что в некоторых ситуациях count ( ) возвращает дополнительную 
      информацию:</P>
      <UL>
        <LI>если переменная существует и является массивом, count ( ) возвращает 
        количество элементов в массиве; 
        <LI>если переменная существует, но не является массивом, функция 
        возвращает значение 1; 
        <LI>если переменная не существует, возвращается значение 0. </LI></UL>
      <P>array_count_values( )</P>
      <P>Функция array_count_values( ) является разновидностью sizeof ( ) и 
      count ( ). Вместо общего количества элементов она подсчитывает количество 
      экземпляров каждого значения в массиве. Синтаксис функции 
      array_count_values( ): </P>
      <P>array array_count_values(array массив): </P>
      <P>В возвращаемом массиве ключами будут значения исходного массива, а 
      значениями — их частоты:</P>
      <P>$states = аrrау("ОН", "ОК", "СА", "РА", "ОН", "ОН", "РА", "АК");</P>
      <P>$state_freq = array_count_values($states);</P>
      <P>Массив $state_freq заполняется следующими ассоциативными парами 
      «ключ/значение»:</P>
      <P>$state_freq = аrrау("ОН" =&gt; 3, "ОК" =&gt; 1, "СА" =&gt; 1, "РА" 
      =&gt; 2, "АК" =&gt; 1);</P>
      <P><A name=i></A>Сортировка массивов</P>
      <P>Сортировка занимает важное место в программировании и часто встречается 
      на практике в таких Интернет-приложениях, как коммерческие сайты 
      (сортировка категорий товаров в алфавитном порядке, сортировка цен) или 
      поисковые системы (сортировка программ по количеству загрузок). В РНР 
      существует девять стандартных функций сортировки (табл. 5.1), причем 
      каждая функция сортирует массив особым образом.</P>
      <P>Таблица 5.1. Функции сортировки</P>
      <TABLE cellSpacing=0 cellPadding=0 width="100%" border=1>
        <TBODY>
        <TR>
          <TD vAlign=top align=middle width=68 height=19>
            <P>Функция</P></TD>
          <TD vAlign=top align=middle width=102 height=19>
            <P>Сортировка</P></TD>
          <TD vAlign=top align=middle width=121 height=19>
            <P>Обратный порядок</P></TD>
          <TD vAlign=top align=middle width=199 height=19>
            <P>Сохранение пар «ключ/значение»</P></TD></TR>
        <TR>
          <TD vAlign=top width=68 height=15>
            <P>sort</P></TD>
          <TD vAlign=top width=102 height=15>
            <P>Значение</P></TD>
          <TD vAlign=top align=middle width=121 height=15>
            <P>Нет</P></TD>
          <TD vAlign=top align=middle width=199 height=15>
            <P>Нет</P></TD></TR>
        <TR>
          <TD vAlign=top width=68 height=14>
            <P>rsort</P></TD>
          <TD vAlign=top width=102 height=14>
            <P>Значение</P></TD>
          <TD vAlign=top align=middle width=121 height=14>
            <P>Да</P></TD>
          <TD vAlign=top align=middle width=199 height=14>
            <P>Нет</P></TD></TR>
        <TR>
          <TD vAlign=top width=68 height=14>
            <P>asort</P></TD>
          <TD vAlign=top width=102 height=14>
            <P>Значение</P></TD>
          <TD vAlign=top align=middle width=121 height=14>
            <P>Нет</P></TD>
          <TD vAlign=top align=middle width=199 height=14>
            <P>Да</P></TD></TR>
        <TR>
          <TD vAlign=top width=68 height=13>
            <P>arsort</P></TD>
          <TD vAlign=top width=102 height=13>
            <P>Значение</P></TD>
          <TD vAlign=top align=middle width=121 height=13>
            <P>Да</P></TD>
          <TD vAlign=top align=middle width=199 height=13>
            <P>Да</P></TD></TR>
        <TR>
          <TD vAlign=top width=68 height=14>
            <P>ksort</P></TD>
          <TD vAlign=top width=102 height=14>
            <P>Ключ</P></TD>
          <TD vAlign=top align=middle width=121 height=14>
            <P>Нет</P></TD>
          <TD vAlign=top align=middle width=199 height=14>
            <P>Да</P></TD></TR>
        <TR>
          <TD vAlign=top width=68 height=14>
            <P>krsort</P></TD>
          <TD vAlign=top width=102 height=14>
            <P>Ключ</P></TD>
          <TD vAlign=top align=middle width=121 height=14>
            <P>Да</P></TD>
          <TD vAlign=top align=middle width=199 height=14>
            <P>Да</P></TD></TR>
        <TR>
          <TD vAlign=top width=68 height=12>
            <P>usort</P></TD>
          <TD vAlign=top width=102 height=12>
            <P>Значение</P></TD>
          <TD vAlign=top align=middle width=121 height=12>
            <P>?</P></TD>
          <TD vAlign=top align=middle width=199 height=12>
            <P>Нет</P></TD></TR>
        <TR>
          <TD vAlign=top width=68 height=14>
            <P>uasort</P></TD>
          <TD vAlign=top width=102 height=14>
            <P>Значение</P></TD>
          <TD vAlign=top align=middle width=121 height=14>
            <P>?</P></TD>
          <TD vAlign=top align=middle width=199 height=14>
            <P>Да</P></TD></TR>
        <TR>
          <TD vAlign=top width=68 height=18>
            <P>uksort</P></TD>
          <TD vAlign=top width=102 height=18>
            <P>Ключ</P></TD>
          <TD vAlign=top align=middle width=121 height=18>
            <P>?</P></TD>
          <TD vAlign=top align=middle width=199 height=18>
            <P>Да</P></TD></TR></TBODY></TABLE>
      <P>? относится к применению пользовательских функций сортировки, когда 
      порядок сортировки массива зависит от результатов, возвращаемых 
      пользовательской функцией.</P>
      <P>Сортировка элементов массива не ограничивается стандартными критериями, 
      поскольку три функции (usort(), uasort( ) и uksort( )) позволяют задать 
      пользовательский критерий и отсортировать информацию произвольным 
      образом.</P>
      <P>sort( )</P>
      <P>Простейшая функция sort( ) сортирует элементы массива по возрастанию 
      (от меньших к большим). Синтаксис функции sort ( ):</P>
      <P>void sort (array массив)</P>
      <P>Нечисловые элементы сортируются в алфавитном порядке в соответствии с 
      ASCII-кодами. Следующий пример демонстрирует применение функции sort( ) 
      при сортировке:</P>
      <P>// Создать массив городов.</P>
      <P>$cities = array("Aprilia", "Nettuno", "Roma", "Venezia", "Anzio");</P>
      <P>// Отсортировать города по возрастанию</P>
      <P>sort($cities);</P>
      <P>// Перебрать содержимое массива и вывести все пары "ключ/значение".</P>
      <P>for (reset($cities); $key = key ($cities); next ($cities)):</P>
      <P>print("cities[$key] = $cities[$key] &lt;br&gt;";</P>
      <P>endfor;</P>
      <P>Этот фрагмент выводит следующий результат:</P>
      <P>cities[0] = Anzio</P>
      <P>cities[1] = Aprilia</P>
      <P>cities[2] = Nettuno</P>
      <P>cities[3] = Roma</P>
      <P>cities[4] = Venezia</P>
      <P>Как видите, массив $cities сортируется в алфавитном порядке. Одна из 
      разновидностей этого способа сортировки реализована в функции asort( ), 
      описанной ниже.</P>
      <P>rsort( )</P>
      <P>Функция rsort ( ) работает точно так же, как функция sort ( ), за одним 
      исключением: элементы массива сортируются в обратном порядке. Синтаксис 
      функции rsort ( ):</P>
      <P>void rsort (array массив) </P>
      <P>Вернемся к массиву $cities из предыдущего примера:</P>
      <P>$cities array("Aprilia", "Nettuno", "Roma", "Venezia", "Anzio");</P>
      <P>rsort($cities);</P>
      <P>В результате сортировки массива $cities функцией rsort( ) элементы 
      будут расположены в следующем порядке:</P>
      <P>cities[0] = Venezia</P>
      <P>cities[1] = Roma</P>
      <P>cities[2] = Nettuno</P>
      <P>cities[3] = Aprilia</P>
      <P>cities[4] = Anzio</P>
      <P>Массив $cities также сортируется, но на этот раз в порядке, обратном 
      алфавитному. Одна из разновидностей этого способа сортировки реализована в 
      функции arsort( ), описанной ниже.</P>
      <P>asort( )</P>
      <P>Функция asort( ) работает почти так же, как упоминавшаяся выше функция 
      sort( ), однако она сохраняет исходную ассоциацию индексов с элементами 
      независимо от нового порядка элементов. Синтаксис функции asort( ):</P>
      <P>void asort(array массив)</P>
      <P>Вернемся к массиву $cities:</P>
      <P>$cities = array("Aprilia", "Nettuno", "Roma", "Venezia", "Anzio");</P>
      <P>asort($cities):</P>
      <P>В результате сортировки массива $cities функцией rsort() элементы будут 
      расположены в следующем порядке:</P>
      <P>cities[4] = Anzio</P>
      <P>cities[0] = Aprilia</P>
      <P>cities[1] = Nettuno</P>
      <P>cities[2] = Roma</P>
      <P>cities[3] = Venezia</P>
      <P>Обратите внимание на индексы и сравните их с приведенными в описании 
      функции sort ( ). Именно в этом и состоит различие между двумя 
      функциями.</P>
      <P>arsort( )</P>
      <P>Функция arsort ( ) представляет собой разновидность asort( ), которая 
      сохраняет исходную ассоциацию индексов, но сортирует элементы в обратном 
      порядке. Синтаксис функции arsort( ):</P>
      <P>void arsort (array массив)</P>
      <P>Воспользуемся функцией arsort( ) для сортировки массива $cities:</P>
      <P>$cities = array("Aprilia", "Nettuno", "Roma", "Venezia", "Anzio");</P>
      <P>arsort($cities);</P>
      <P>В результате сортировки элементы будут расположены в следующем 
      порядке:</P>
      <P>cities[3] = Venezia</P>
      <P>cities[2] = Roma</P>
      <P>cities[l] = Nettuno</P>
      <P>cities[0] = Aprilia</P>
      <P>cities[4] = Anzio</P>
      <P>Обратите внимание на индексы и сравните их с приведенными в описании 
      функции rsort( ). Именно в этом и состоит различие между двумя 
      функциями.</P>
      <P>ksort( )</P>
      <P>Функция ksort( ) сортирует массив по ключам, сохраняя исходные 
      ассоциации ключей со значениями. Синтаксис функции ksort( ):</P>
      <P>void ksort (array массив)</P>
      <P>Для примера рассмотрим массив, слегка отличающийся от исходного 
      массива</P>
      <P>$cities:</P>
      <P>$wine_producers = array ("America" =&gt; "Napa Valley",</P>
      <P>"Italy" =&gt; "Tuscany",</P>
      <P>"Australia" =&gt; "Ruthgerlen",</P>
      <P>"France" =&gt; "Loire",</P>
      <P>"Chile" =&gt; "Rapel Valley");</P>
      <P>В результате сортировки массива функцией ksort( ) элементы будут 
      расположены в следующем порядке:</P>
      <P>"America" =&gt; "Napa Valley"</P>
      <P>"Australia" =&gt; "Ruthgerlen"</P>
      <P>"Chile" =&gt; "Rapel Valley"</P>
      <P>"France" =&gt; "Loire"</P>
      <P>"Italy" =&gt; "Tuscany"</P>
      <P>Сравните с результатами сортировки $wine_producers функцией sort ( 
      ):</P>
      <P>"America" =&gt; "Napa Valley"</P>
      <P>"Australia" =&gt; "Tuscany"</P>
      <P>"Chile" =&gt; "Ruthgerlen"</P>
      <P>"France" =&gt; "Loire"</P>
      <P>"Italy" =&gt; "Rapel Valley"</P>
      <P>Более чем сомнительный результат!</P>
      <P>krsort( )</P>
      <P>Функция krsort( ) почти аналогична ksort( ), однако ключи сортируются в 
      обратном порядке. Синтаксис функции krsort( ):</P>
      <P>void krsort (array $массив)</P>
      <P>Рассмотрим сортировку массива $wi reproducers функцией krsort( ):</P>
      <P>$wine_producers = array ("America" =&gt; "Napa Valley",</P>
      <P>"Italy" =&gt; "Tuscany",</P>
      <P>"Australia" =&gt; "Ruthgerlen",</P>
      <P>"France" =&gt; "Loire".</P>
      <P>"Chile" =&gt; "Rapel Valley");</P>
      <P>krsort($wine_producers);</P>
      <P>В результате сортировки элементы будут расположены в следующем 
      порядке:</P>
      <P>"Italy" =&gt; "Tuscany"</P>
      <P>"France" =&gt; "Loire"</P>
      <P>"Chile" =&gt; "Rapel Valley"</P>
      <P>"Australia" =&gt; "Ruthgerlen"</P>
      <P>"America" =&gt; "Napa Valley"</P>
      <P>Вероятно, описанных выше функций сортировки будет вполне достаточно для 
      большинства случаев. Тем не менее, в некоторых ситуациях может возникнуть 
      необходимость в определении собственных критериев сортировки. В РНР такая 
      возможность реализована в трех стандартных функциях: usort( ), uasort( ) и 
      uksort( ).</P>
      <P>usort( )</P>
      <P>Функция usort( ) дает возможность отсортировать массив на основании 
      критерия, определяемого программистом. Для этого usort( ) в качестве 
      параметра передается имя функции, определяющей порядок сортировки. 
      Синтаксис функции usort( ):</P>
      <P>void usort (array массив, string имя_функции)</P>
      <P>В параметре массив передается имя сортируемого массива, а в параметре 
      имя_функции — имя функции, на основании которой будет осуществляться 
      сортировка. Допустим, у вас имеется длинный список греческих имен, которые 
      необходимо выучить к предстоящему экзамену по истории. Вы хотите 
      отсортировать слова по длине, чтобы начать с самых длинных, а затем учить 
      короткие, когда вы уже устанете. Для сортировки массива по длине можно 
      воспользоваться функцией usort( ).</P>
      <P>Листинг 5.2. Определение критерия сортировки для функции usort( )</P>
      <P>$vocab = аrrау( "Socrates", "Aristophanes", "Plato", "Aeschylus", 
      "Thesmophoriazusae");</P>
      <P>function compare_length($str1, $str2) {</P>
      <P>// Получить длину двух следующих слов</P>
      <P>$length1 = strlen($str1);</P>
      <P>$length2 = strlen($str2);</P>
      <P>// Определить, какая строка имеет меньшую длину</P>
      <P>if ($length1 == $length2) :</P>
      <P>return 0;</P>
      <P>elseif ($length1 &lt; $length2) :</P>
      <P>return -1;</P>
      <P>else :</P>
      <P>return 1;</P>
      <P>endif;</P>
      <P>}</P>
      <P>// Вызвать usort() с указанием функции compare_length()</P>
      <P>// в качестве критерия сортировки</P>
      <P>usort ($vocab, "compare_length") :</P>
      <P>// Вывести отсортированный список</P>
      <P>while (list ($key, $val) = each ($vocab)) {</P>
      <P>echo "$val&lt;br&gt;";</P>
      <P>}</P>
      <P>В листинге 5.2 функция compare_length ( ) определяет критерий 
      сортировки массива. В данном случае это делается посредством сравнения 
      длины передаваемых элементов. Функция-критерий должна получать два 
      параметра, представляющих</P>
      <P>сравниваемые элементы массива. Также обратите внимание на то, как эти 
      элементы неявно передаются функции-критерию при вызове usort( ), и на то, 
      что все элементы автоматически сравниваются этой функцией.</P>
      <P>Функции uasort( ) и uksort( ) представляют собой разновидности usort( ) 
      с тем же синтаксисом. Функция uasort() сортирует массив по 
      пользовательскому критерию с сохранением ассоциаций «ключ/значение». 
      Функция uksort( ) также сортирует массив по пользовательскому критерию, 
      однако сортируются не значения, а ключи.</P>
      <P><A name=j></A>Другие полезные функции</P>
      <P>В этом разделе описаны некоторые функции, которые не принадлежат ни к 
      какому конкретному разделу, но приносят несомненную пользу.</P>
      <P>array_merge( )</P>
      <P>Функция arrayjnerge( ) сливает от 1 до N массивов, объединяя их в 
      соответствии с порядком перечисления в параметрах. Синтаксис функции 
      array_merge( ): </P>
      <P>array array_merge(array массив1, array массив2, ..., array массивN]</P>
      <P>Рассмотрим пример простого объединения массивов функцией arrayjnerge( 
      );</P>
      <P>$arr_1 = array("strawberry", "grape", "lemon");</P>
      <P>$arr_2 = array("banana", "cocoa", "lime");</P>
      <P>$arr_3 = array("peach", "orange");</P>
      <P>$arr_4 = array_merge ($arr2, $arr_1, $arr_3):</P>
      <P>// $arr_4 = array("banana", "cocoa", "lime", "strawberry", "grape", 
      "lemon", "peach", "orange");</P>
      <P>array_slice( )</P>
      <P>Функция array_slice( ) возвращает часть массива, начальная и конечная 
      позиция которой определяется смещением от начала и необязательным 
      параметром длины. Синтаксис функции array_slice( ): </P>
      <P>array array_slice(array массив, int смещение [, int длина])</P>
      <P>Значения параметров задаются по определенным правилам:</P>
      <UL>
        <LI>Если смещение положительно, начальная позиция возвращаемого 
        фрагмента отсчитывается от начала массива. 
        <LI>Если смещение отрицательно, начальная позиция возвращаемого 
        фрагмента отсчитывается от конца массива. 
        <LI>Если длина не указана, в возвращаемый массив включаются все элементы 
        от начальной позиции до конца массива. 
        <LI>Если указана положительная длина, возвращаемый фрагмент состоит из 
        заданного количества элементов. 
        <LI>Если указана отрицательная длина, возвращаемый фрагмент 
        заканчивается в заданном количестве элементов от конца массива. </LI></UL>
      <P>array_splice( )</P>
      <P>Функция array_spl ice( ) отдаленно напоминает array_slice( ) — она 
      заменяет часть массива, определяемую начальной позицией и необязательной 
      длиной, элементами необязательного параметра-массива. Синтаксис функции 
      array_splice( ):</P>
      <P>array_splice(array входной_массив, int смещение, [int длина], [array 
      заменяющий_массив]); </P>
      <P>Значения параметров задаются по определенным правилам:</P>
      <UL>
        <LI>Если смещение положительно, начальная позиция первого удаляемого 
        элемента отсчитывается от начала массива. 
        <LI>Если смещение отрицательно, начальная позиция первого удаляемого 
        элемента отсчитывается от конца массива. 
        <LI>Если длина не указана, удаляются все элементы от начальной позиции 
        до конца массива. 
        <LI>Если указана положительная длина, удаляемый фрагмент состоит из 
        заданного количества элементов. 
        <LI>Если указана отрицательная длина, из массива удаляются элементы от 
        начальной позиции до позиции, находящейся на заданном расстоянии от 
        конца массива. 
        <LI>Если заменяющий_массив не указан, то элементы, заданные смещением и 
        необязательной длиной, удаляются из массива. 
        <LI>Если заменяющий_массив указан, он должен быть заключен в конструкцию 
        аггау() (если он содержит более одного элемента). </LI></UL>
      <P>Рассмотрим несколько примеров, наглядно демонстрирующих возможности 
      этой функции. В этих примерах будет использоваться массив $pasta (см. 
      выше), с которым будут выполняться различные операции.</P>
      <P>Удаление всех элементов с пятой позиции до конца массива:</P>
      <P>$pasta = array_splice($pasta, 5);</P>
      <P>Удаление пятого и шестого элементов:</P>
      <P>$pasta = array_splice($pasta. 5, 2);</P>
      <P>Замена пятого и шестого элементов новыми значениями:</P>
      <P>$pasta = array_splice($pasta, 5, 2, array("element1", "element2"));</P>
      <P>Удаление всех элементов, начиная с пятого, до третьего элемента с конца 
      массива:</P>
      <P>$pasta = array_splice($pasta, 5, -3);</P>
      <P>Как видно из приведенных примеров, функция array_splice( ) обеспечивает 
      гибкие возможности удаления элементов из массива при минимальном объеме 
      кода.</P>
      <P>shuffle( )</P>
      <P>Функция shuffle( ) сортирует элементы массива в случайном порядке. 
      Синтаксис функции shuffle( ): </P>
      <P>void shuffle(array массив); </P>
      <P><A name=k></A>Итоги</P>
      <P>В этой главе рассматривались массивы и стандартные функции РНР для 
      работы с массивами. В частности, рассматривались следующие темы:</P>
      <UL>
        <LI>создание индексируемых и ассоциативных массивов; 
        <LI>многомерные массивы; 
        <LI>отображение содержимого многомерных массивов; 
        <LI>поиск элементов; 
        <LI>добавление и удаление элементов; 
        <LI>размер массива; 
        <LI>сортировка; 
        <LI>другие полезные функции для работы с массивами. </LI></UL>
      <P>Массивы являются очень удобными и универсальными средствами для работы 
      с данными в web-приложениях. В примерах дальнейших глав массивы будут 
      неоднократно использоваться для повышения эффективности и наглядности 
      кода.</P>
      <P>В главе 6 мы продолжим знакомиться с базовыми средствами РНР. На этот 
      раз речь пойдет об объектно-ориентированных возможностях 
      языка.</P></LI></DIV>
<center>
[ <a href="04.php">Назад</a> | <a href="index.php">Содержание</a> | <a href="06.php">Вперед</a> ]
</center><br>
<? include_once '../../sys/inc/tfoot.php'; ?>