<?include'h.php';?>
<html><head>
		<title>Учебник PHP, Глава 7</title>
		<meta http-equiv="Content-type" content="text/html; charset=Windows-1251">
		</head>
		
      <DIV class=infotxt>
      <LI><A href="#a">Глава 7. Файловый 
      ввод/вывод и файловая система</A> 
      <UL>
        <LI><A href="#b">Проверка существования и 
        размера файла</A> 
        <LI><A href="#c">Открытие и закрытие 
        файлов</A> 
        <LI><A href="#d">Запись в файл</A> 
        <LI><A href="#e">Чтение из файла</A> 
        <LI><A href="#f">Чтение файла в массив</A> 

        <LI><A href="#g">Перенаправление файла в 
        стандартный выходной поток</A> 
        <LI><A href="#h">Открытие файлового 
        манипулятора процесса</A> 
        <LI><A href="#i">Открытие соединения через 
        сокет</A> 
        <LI><A href="#j">Запуск внешних 
        программ</A> 
        <UL>
          <LI><A href="#k">Обратные апострофы</A> 
          </LI></UL>
        <LI><A href="#l">Работа с файловой 
        системой</A> 
        <LI><A href="#m">Отображение и изменение 
        характеристик файлов</A> 
        <LI><A href="#n">Копирование и 
        переименование файлов</A> 
        <LI><A href="#o">Удаление файлов</A> 
        <LI><A href="#p">Работа с каталогами</A> 
        <LI><A href="#q">Проект 1: простой счетчик 
        обращений</A> 
        <LI><A href="#r">Проект 2: построение 
        карты сайта</A> 
        <LI><A href="#s">Итоги</A> </LI></UL>
      <UL></UL><A name=a></A>
      <P>&nbsp;</P>
      <P>ГЛАВА 7</P>
      <P>Файловый ввод/вывод и файловая система</P>
      <P>Данная глава посвящена одному из важнейших аспектов РНР — средствам 
      файлового ввода/вывода. Как нетрудно предположить, входные и выходные 
      потоки данных интенсивно используются при разработке web-приложений. Не 
      ограничиваясь простым чтением/записью файлов, РНР предоставляет в 
      распоряжение программиста средства просмотра и модификации серверной 
      информации, а также запуска внешних программ. Этим средствам и посвящена 
      настоящая глава.</P>
      <P><A name=b></A>Проверка существования и размера файла</P>
      <P>Прежде чем пытаться работать с файлом, желательно убедиться в том, что 
      он существует. Для решения этой задачи обычно используются две 
функции:</P>
      <P>file_exists( ) и is_file( ).</P>
      <P>file_exists( )</P>
      <P>Функция f ilе_ехists ( ) проверяет, существует ли заданный файл. Если 
      файл существует, функция возвращает TRUE, в противном случае возвращается 
      FALSE. Синтаксис функции file_exists( ):</P>
      <P>bool file_exists(string файл) </P>
      <P>Пример проверки существования файла:</P>
      <P>if (! file_exists ($filename)) :</P>
      <P>print "File $filename does not exist!";</P>
      <P>endif:</P>
      <P>is_file( )</P>
      <P>Функция is_file( ) проверяет существование заданного файла и 
      возможность выполнения с ним операций чтения/записи. В сущности, is_file( 
      ) представляет собой более надежную версию file_exists( ), которая 
      проверяет не только факт существования файла, но и то, поддерживает ли он 
      чтение и запись данных:</P>
      <P>bool is_file(string файл) </P>
      <P>Следующий пример показывает, как убедиться в существовании файла и 
      возможности выполнения операций с ним:</P>
      <P>$file = "somefile.txt";</P>
      <P>if (is_file($file)) :</P>
      <P>print "The file $file is valid and exists!";</P>
      <P>else :</P>
      <P>print "The file $file does not exist or it is not a valid file!";</P>
      <P>endif:</P>
      <P>Убедившись в том, что нужный файл существует и с ним можно выполнять 
      различные операции чтения/записи, можно переходить к следующему шагу — 
      открытию файла.</P>
      <P>filesize( )</P>
      <P>Функция filesize( ) возвращает размер (в байтах) файла с заданным 
      именем или FALSE в случае ошибки. Синтаксис функции filesize( ):</P>
      <P>int filesize(string имя_файла)</P>
      <P>Предположим, вы хотите определить размер файла pastry.txt. Для 
      получения нужной информации можно воспользоваться функцией filesize( 
):</P>
      <P>$fs = filesize("pastry.txt"); print "Pastry.txt is $fs bytes.";</P>
      <P>Выводится следующий результат:</P>
      <P>Pastry.txt is 179 bytes.</P>
      <P>Прежде чем выполнять операции с файлом, необходимо открыть его и 
      связать с файловым манипулятором, а после завершения работы с файлом его 
      следует закрыть. Эти темы рассматриваются в следующем разделе.</P>
      <P><A name=c></A>Открытие и закрытие файлов</P>
      <P>Прежде чем выполнять операции ввода/вывода с файлом, необходимо открыть 
      его функцией fopen( ).</P>
      <P>fopen( )</P>
      <P>Функция fopen( ) открывает файл (если он существует) и возвращает целое 
      число — так называемый файловый манипулятор (file handle). Синтаксис 
      функции fopen( ):</P>
      <P>int fopen (string файл, string режим [, int включение_пути])</P>
      <P>Открываемый файл может находиться в локальной файловой системе, 
      существовать в виде стандартного потока ввода/вывода или представлять файл 
      в удаленной системе, принимаемой средствами HTTP или FTP.</P>
      <P>Параметр файл может задаваться в нескольких формах, перечисленных 
      ниже:</P>
      <P>Если параметр содержит имя локального файла, функция fopen( ) открывает 
      этот файл и возвращает манипулятор.</P>
      <P>Если параметр задан в виде php://stdin, php://stdout или php://stderr, 
      открывается соответствующий стандартный поток ввода/вывода.</P>
      <P>Если параметр начинается с префикса http://, функция открывает 
      подключение HTTP к серверу и возвращает манипулятор для указанного 
      файла.</P>
      <P>Если параметр начинается с префикса ftp://, функция открывает 
      подключение FTP к серверу и возвращает манипулятор для указанного файла. В 
      этом случае следует обратить особое внимание на два обстоятельства: если 
      сервер не поддерживает пассивный режим FTP, вызов fopen( ) завершается 
      неудачей. Более того, FTP-файлы открываются либо для чтения, либо для 
      записи.</P>
      <P>При работе в пассивном режиме сервер ЯР ожидает подключения со стороны 
      клиентов. При работе в активном режиме сервер сам устанавливает соединение 
      с клиентом. По умолчанию обычно используется активный режим.</P>
      <P>Параметр режим определяет возможность выполнения чтения и записи в 
      файл. В табл. 7.1 перечислены некоторые значения, определяющие режим 
      открытия файла.</P>
      <P>Таблица 7.1. Режимы открытия файла&nbsp;</P>
      <TABLE cellSpacing=0 cellPadding=0 width="100%" border=1>
        <TBODY>
        <TR>
          <TD align=middle width=136>Режим </TD>
          <TD align=middle width=358>Описание </TD></TR>
        <TR>
          <TD align=middle width=150>
            <P align=center>r</P></TD>
          <TD width=350>Только чтение. Указатель текущей позиции 
            устанавливается в начало файла </TD></TR>
        <TR>
          <TD align=middle width=150>r+</TD>
          <TD width=350>Чтение и запись. Указатель текущей позиции 
            устанавливается в начало файла</TD></TR>
        <TR>
          <TD align=middle width=150>w</TD>
          <TD width=350>Только запись. Указатель текущей позиции 
            устанавливается в начало файла, а все содержимое файла уничтожается. 
            Если файл не существует, функция пытается создать его </TD></TR>
        <TR>
          <TD align=middle width=150>w+</TD>
          <TD width=350>Чтение и запись. Указатель текущей позиции 
            устанавливается в начало файла, а все содержимое файла уничтожается. 
            Если файл не существует, функция пытается создать его&nbsp; </TD></TR>
        <TR>
          <TD align=middle width=150>a</TD>
          <TD width=350>Только запись. Указатель текущей позиции 
            устанавливается в конец файла. Если файл не существует, функция 
            пытается создать его</TD></TR>
        <TR>
          <TD align=middle width=150>a+</TD>
          <TD width=350>Чтение и запись. Указатель текущей позиции 
            устанавливается в конец файла. Если файл не существует, функция 
            пытается создать его</TD></TR></TBODY></TABLE>
      <P>Если необязательный третий параметр включение_пути равен 1, то путь к 
      файлу определяется по отношению к каталогу включаемых файлов, указанному в 
      файле php.ini (см. главу 1).</P>
      <P>Ниже приведен пример открытия файла функцией fopen( ). Вызов die( ), 
      используемый в сочетании с fopen( ), обеспечивает вывод сообщения об 
      ошибке в том случае, если открыть файл не удастся:</P>
      <P>$file = "userdata.txt"; // Некоторый файл</P>
      <P>$fh = fopen($file, "a+") or die("File ($file) does not exist!");</P>
      <P>Следующий фрагмент открывает подключение к сайту РНР 
      (http://www.php.net):</P>
      <P>$site = "http://www.php.net": // Сервер, доступный через HTTP</P>
      <P>$sh = fopen($site., "r");&nbsp;&nbsp;&nbsp;&nbsp; //Связать манипулятор 
      с индексной страницей Php.net</P>
      <P>После завершения работы файл всегда следует закрывать функцией fclose( 
      ).</P>
      <P>fclose ( )</P>
      <P>Функция fclose( ) закрывает файл с заданным манипулятором. При успешном 
      закрытии возвращается TRUE, при неудаче — FALSE. Синтаксис функции fclose( 
      ): </P>
      <P>int fclose(int манипулятор)</P>
      <P>Функция fclose( ) успешно закрывает только те файлы, которые были ранее 
      открыты функциями fopen( ) или fsockopen( ). Пример закрытия файла:</P>
      <P>$file = "userdata.txt";</P>
      <P>if (file_exists($file)) :</P>
      <P>$fh = fopen($file, "r");</P>
      <P>// Выполнить операции с файлом</P>
      <P>fclose($fh);</P>
      <P>else :</P>
      <P>print "File Sfile does not exist!";</P>
      <P>endif;</P>
      <P><A name=d></A>Запись в файл</P>
      <P>С открытыми файлами выполняются две основные операции — чтение и 
      запись.</P>
      <P>is_writeable( )</P>
      <P>Функция is_writeable( ) позволяет убедиться в том, что файл существует 
      и для него разрешена операция записи. Возможность записи проверяется как 
      для файла, так и для каталога. Синтаксис функции is_writeable( ):</P>
      <P>bool is_writeable (string файл)</P>
      <P>Одно важное обстоятельство: скорее всего, РНР будет работать под 
      идентификатором пользователя, используемым web-сервером (как правило, 
      «nobody»). Пример использования is_writeable( ) приведен в описании 
      функции fwrite( ).</P>
      <P>fwrite ( )</P>
      <P>Функция fwrite( ) записывает содержимое строковой переменной в файл, 
      заданный файловым манипулятором. Синтаксис функции fwrite( ): </P>
      <P>int fwrite(int манипулятор, string переменная [, int длина]) </P>
      <P>Если при вызове функции передается необязательный параметр длина, 
      запись останавливается либо после записи указанного количества символов, 
      либо при достижении конца строки. Проверка возможности записи в файл 
      продемонстрирована в следующем примере:</P>
      <P>&lt;?</P>
      <P>// Информация о трафике на пользовательском сайте</P>
      <P>$data = "08:13:00|12:37:12|208.247.106.187|Win98";</P>
      <P>$filename = "somefile.txt";</P>
      <P>// Если файл существует и в него возможна запись</P>
      <P>if ( is_writeable($filename) ) :</P>
      <P>// Открыть файл и установить указатель текущей позиции в конец 
файла</P>
      <P>$fh = fopen($filename, "a+");</P>
      <P>// Записать содержимое $data в файл</P>
      <P>$success - fwrite($fh, $data);</P>
      <P>// Закрыть файл</P>
      <P>fclose($fh); else :</P>
      <P>print "Could not open Sfilename for writing";</P>
      <P>endif;</P>
      <P>?&gt;</P>
      <P>Функция fputs( ) является псевдонимом fwrite( ) и может использоваться 
      всюду, где используется fwrite( ).</P>
      <P>fputs( )</P>
      <P>Функция fputs( ) является псевдонимом fwrite( ) и имеет точно такой же 
      синтаксис. Синтаксис функции fputs( ): </P>
      <P>int fputs(int манипулятор, string переменная [, int длина]) </P>
      <P>Лично я предпочитаю использовать fputs( ). Следует помнить, что это 
      всего лишь вопрос стиля, никак не связанный с какими-либо различиями между 
      двумя функциями.</P>
      <P><A name=e></A>Чтение из файла</P>
      <P>Несомненно, чтение является самой главной операцией, выполняемой с 
      файлами. Ниже описаны некоторые функции, повышающие эффективность чтения 
      из файла. Синтаксис этих функций практически точно копирует синтаксис 
      аналогичных функций записи.</P>
      <P>is_readable( )</P>
      <P>Функция i s_readable( ) позволяет убедиться в том, что файл существует 
      и для него разрешена операция чтения. Возможность чтения проверяется как 
      для файла, так и для каталога. Синтаксис функции is_readable( ):</P>
      <P>boo! is_readable (string файл]</P>
      <P>Скорее всего, РНР будет работать под идентификатором пользователя, 
      используемым web-сервером (как правило, «nobody»), поэтому для того чтобы 
      функция is_readable( ) возвращала TRUE, чтение из файла должно быть 
      разрешено всем желающим. Следующий пример показывает, как убедиться в том, 
      что файл существует и доступен для чтения:</P>
      <P>if ( is_readable($filename) ) :</P>
      <P>// Открыть файл и установить указатель текущей позиции в конец 
файла</P>
      <P>$fh = fopen($filename, "r");</P>
      <P>else :</P>
      <P>print "$filename is not readable!";</P>
      <P>endif;</P>
      <P>fread( )</P>
      <P>Функция fread( ) читает из файла, заданного файловым манипулятором, 
      заданное количество байт. Синтаксис функции fwrite( ): </P>
      <P>int fread(int манипулятор, int длина) </P>
      <P>Манипулятор должен ссылаться на открытый файл, доступный для чтения 
      (см. описание функции is_readable( )). Чтение прекращается после прочтения 
      заданного количества байт или при достижении конца файла. Рассмотрим 
      текстовый файл pastry.txt, приведенный в листинге 7.1. Чтение и вывод 
      этого файла в браузере осуществляется следующим фрагментом:</P>
      <P>$fh = fopen('pastry.txt', "r") or die("Can't open file!");</P>
      <P>$file = fread($fh, filesize($fh));</P>
      <P>print $file;</P>
      <P>fclose($fh);</P>
      <P>Используя функцию fllesize( ) для определения размера pastry.txt в 
      байтах, вы гарантируете, что функция fread( ) прочитает все содержимое 
      файла.</P>
      <P>Листинг 7.1. Текстовый файл pastry.txt</P>
      <P>Recipe: Pastry Dough</P>
      <P>1 1/4 cups all-purpose flour</P>
      <P>3/4 stick (6 tablespoons) unsalted butter, chopped</P>
      <P>2 tablespoons vegetable shortening 1/4 teaspoon salt</P>
      <P>3 tablespoons water</P>
      <P>fgetc( )</P>
      <P>Функция fgetc( ) возвращает строку, содержащую один символ из файла в 
      текущей позиции указателя, или FALSE при достижении конца файла. Синтаксис 
      функции fgetc( ):</P>
      <P>string fgetc (int манипулятор)</P>
      <P>Манипулятор должен ссылаться на открытый файл, доступный для чтения 
      (см. описание функции is_readable( ) ранее в этой главе). В следующем 
      примере продемонстрированы посимвольное чтение и вывод файла с 
      использованием функции fgetc( ):</P>
      <P>$fh = fopen("pastry.txt", "r"); while (! feof($fh)) :</P>
      <P>$char = fgetc($fh):</P>
      <P>print $char; endwhile;</P>
      <P>fclose($fh);</P>
      <P>fgets( )</P>
      <P>Функция fgets( ) возвращает строку, прочитанную от текущей позиции 
      указателя в файле, определяемом файловым манипулятором. Файловый указатель 
      должен ссылаться на открытый файл, доступный для чтения (см. описание 
      функции is_readable( ) ранее в этой главе). Синтаксис функции fgets( 
):</P>
      <P>string fgets (int манипулятор, int длина)</P>
      <P>Чтение прекращается при выполнении одного из следующих условий:</P>
      <UL>
        <LI>из файла прочитано длина — 1 байт; 
        <LI>из файла прочитан символ новой строки (включается в возвращаемую 
        строку); 
        <LI>из файла прочитан признак конца файла (EOF). </LI></UL>
      <P>Если вы хотите организовать построчное чтение файла, передайте во 
      втором параметре значение, заведомо превышающее количество байт в строке. 
      Пример построчного чтения и вывода файла:</P>
      <P>$fh = fopen("pastry.txt", "r");</P>
      <P>while (! feof($fh));</P>
      <P>$line = fgets($fh, 4096);</P>
      <P>print $line. "&lt;br&gt;";</P>
      <P>endwhile;</P>
      <P>fclose($fh):</P>
      <P>fgetss( )</P>
      <P>Функция fgetss( ) полностью аналогична fgets( ) за одним исключением — 
      она пытается удалять из прочитанного текста все теги HTML и РНР:</P>
      <P>string fgetss (Int манипулятор, int длина [, string 
      разрешенные_теги])</P>
      <P>Прежде чем переходить к примерам, ознакомьтесь с содержимым листинга 
      7.2 — этот файл используется в листингах 7.3 и 7.4.</P>
      <P>Листинг 7.2. Файл science.html</P>
      <P>&lt;html&gt;</P>
      <P>&lt;head&gt;</P>
      <P>&lt;title&gt;Breaking News - Science&lt;/title&gt;</P>
      <P>&lt;body&gt;</P>
      <P>&lt;h1&gt;Alien lifeform discovered&lt;/h1&gt;&lt;br&gt;</P>
      <P>&lt;b&gt;August 20. 2000&lt;/b&gt;&lt;br&gt;</P>
      <P>Early this morning, a strange new form of fungus was found growing in 
      the closet of W. J. Gilmore's old apartment refrigerator. It is not known 
      if powerful radiation emanating from the tenant's computer monitor aided 
      in this evolution.</P>
      <P>&lt;/body&gt;</P>
      <P>&lt;/html&gt;</P>
      <P>Листинг 7.З. Удаление тегов из файла HTML перед отображением в 
      браузере</P>
      <P>&lt;?</P>
      <P>$fh = fopen("science.html", "r");</P>
      <P>while (! feof($fh)) :</P>
      <P>print fgetss($fh, 2048);</P>
      <P>endwhile;</P>
      <P>fclose($fh);</P>
      <P>?&gt;</P>
      <P>Результат приведен ниже. Как видите, из файла science.html были удалены 
      все теги HTML, что привело к потере форматирования:</P>
      <P>Breaking News - Science Alien lifeform discovered August 20. 2000 Early 
      this morning, a strange new form of fungus was found growing in the closet 
      of W. J. Gilmore's old apartment refrigerator. It is not known if powerful 
      radiation emanating from the tenant's computer monitor aided in this 
      evolution.</P>
      <P>В некоторых ситуациях из файла удаляются все теги, кроме некоторых — 
      например, тегов разрыва строк &lt;br&gt;. Листинг 7.4 показывает, как это 
      делается.</P>
      <P>Листинг 7.4. Выборочное удаление тегов из файла HTML</P>
      <P>&lt;?</P>
      <P>$fh = fopenC'science.html", "r");</P>
      <P>$allowable = "&lt;br&gt;";</P>
      <P>while (! feof($fh)) :</P>
      <P>print fgetss($fh. 2048, $allowable);</P>
      <P>endwhile;</P>
      <P>fclose($fh);</P>
      <P>?&gt;</P>
      <P>Результат:</P>
      <P>Breaking News - Science Alien lifeform discovered August 20. 2000 Early 
      this morning, a strange new form of fungus was found growing in the closet 
      of W. J. Gilmore's old apartment refrigerator. It is not known if powerful 
      radiation emanating from the tenant's computer monitor aided in this 
      evolution.</P>
      <P>Как видите, функция fgetss( ) упрощает преобразование файлов, особенно 
      при наличии большого количества файлов HTML, отформатированных сходным 
      образом.</P>
      <P><A name=f></A>Чтение файла в массив</P>
      <P>Функция file( ) загружает все содержимое файла в индексируемый массив. 
      Каждый элемент массива соответствует одной строке файла. Синтаксис функции 
      filе ( ):</P>
      <P>array file (string файл [, int включение_пути])</P>
      <P>Если необязательный третий параметр включение_пути равен 1, то путь к 
      файлу определяется по отношению к каталогу включаемых файлов, указанному в 
      файле php.ini (см. главу 1). В листинге 7.5 функция file( ) используется 
      для загрузки файла pastry.txt (см. листинг 7.1).</P>
      <P>Листинг 7.5. Загрузка файла pastry.txt функцией file( )</P>
      <P>&lt;?</P>
      <P>$file_array = file( "pastry.txt" );</P>
      <P>while ( list( $line_num. $line ) = eacht($file_array ) ):</P>
      <P>print "&lt;b&gt;Line $line_num:&lt;/b&gt; ", htmlspecialchars($line ), 
      "&lt;br&gt;\n"</P>
      <P>endwhile;</P>
      <P>?&gt;</P>
      <P>Каждая строка массива выводится вместе с номером:</P>
      <P>Line 0: Recipe: Pastry Dough</P>
      <P>Line 1: 1 1/4 cups all-purpose flour</P>
      <P>Line 2: 3/4 stick (6 tablespoons) unsalted butter, chopped</P>
      <P>Line 3: 2 tablespoons vegetable shortening</P>
      <P>Line 4: 1/4 teaspoon salt</P>
      <P>Line 5: 3 tablespoons water</P>
      <P><A name=g></A>Перенаправление файла в стандартный выходной поток</P>
      <P>Функция readfile( ) читает содержимое файла и направляет его в 
      стандартный вывод (в большинстве случаев — в браузер). Синтаксис функции 
      readfile( ):</P>
      <P>int readfile (string файл [, int включение_пути])</P>
      <P>Функция возвращает количество прочитанных байтов. Файл может находиться 
      в локальной файловой системе, существовать в виде стандартного потока 
      ввода/вывода или представлять файл в удаленной системе, принимаемой 
      средствами HTTP или FTP. Параметр файл задается по тем же правилам, что и 
      в функции fopen( ).</P>
      <P>Предположим, у вас имеется файл latorre.txt, содержимое которого вы 
      хотите вывести в браузере:</P>
      <P>Restaurant "La Тоrrе." located in Nettuno, Italy, offers an eclectic 
      blend of style. history, and fine seafood cuisine. Within the walls of the 
      medieval borgo surrounding the city, one can dine while watching the 
      passersby shop in the village boutiques. Comfort coupled with only the 
      freshest seafare make La Torre one of Italy's finest restaurants.</P>
      <P>При выполнении следующего фрагмента все содержимое latorre.txt 
      направляется в стандартный выходной поток:</P>
      <P>&lt;?</P>
      <P>$restaurant_file = "latorre.txt";</P>
      <P>// Направить весь файл в стандартный выходной поток</P>
      <P>readfile($restaurant_filе);</P>
      <P>?&gt;</P>
      <P><A name=h></A>Открытие файлового манипулятора процесса</P>
      <P>popen( )</P>
      <P>Наряду с обычными файлами можно открывать файловые манипуляторы для 
      взаимодействия с процессами на сервере. Задача решается функцией рореn( ), 
      которая имеет следующий синтаксис:</P>
      <P>int popen (string команда, string режим) </P>
      <P>Параметр команда определяет выполняемую системную команду, а параметр 
      режим описывает режим доступа:</P>
      <P>&lt;?</P>
      <P>// Открыть файл "spices.txt" для записи</P>
      <P>$fh = fopen("spices.txt","w");</P>
      <P>// Добавить несколько строк текста</P>
      <P>fputs($fh, "Parsley, sage, rosemary\n");</P>
      <P>fputs($fh, "Paprika, salt, pepper\n");</P>
      <P>fputs($fh, "Basil, sage, ginger\n");</P>
      <P>// Закрыть манипулятор</P>
      <P>fclose($fh);</P>
      <P>// Открыть процесс UNIX grep для поиска слова Basil в файле 
      spices.txt</P>
      <P>$fh - popen("grep Basil &lt; spices.txt", "r");</P>
      <P>// Вывести результат работы grep</P>
      <P>fpassthru($fh);</P>
      <P>?&gt;</P>
      <P>Результат выглядит так:</P>
      <P>Basil, sage, ginger</P>
      <P>Функция fpassthru( ) является аналогом функции passthru( ), 
      рассматриваемой в разделе «Запуск внешних программ» этой главы.</P>
      <P>pclose( )</P>
      <P>После выполнения всех операций файл или процесс необходимо закрыть. 
      Функция pclose( ) закрывает соединение с процессом, заданным 
      манипулятором, по аналогии с тем, как функция fclose( ) закрывает файл, 
      открытый функцией fopen( ). Синтаксис функции pclose( ):</P>
      <P>int pclose (int манипулятор}</P>
      <P>В параметре манипулятор передается манипулятор, полученный ранее при 
      успешном вызове рореn( ).</P>
      <P><A name=i></A>Открытие соединения через сокет</P>
      <P>РНР не ограничивается взаимодействием с файлами и процессами — вы также 
      можете устанавливать соединения через сокеты. Сокет (socket) представляет 
      собой программную абстракцию, позволяющую устанавливать связь с различными 
      службами другого компьютера.</P>
      <P>fsockopen( )</P>
      <P>Функция fsockopen( ) устанавливает сокетное соединение с сервером в 
      Интернете</P>
      <P>через протокол TCP или UDP. Синтаксис функции fsockopen( ):</P>
      <P>int fsockopen (string узел, int порт [, int код_ошибки [, string 
      текст_ошибки [, int тайм-аут]]]) </P>
      <P>Необязательные параметры код_ошибки и текст_ошибки содержат информацию, 
      которая будет выводиться в случае неудачи при подключении к серверу. Оба 
      параметра должны передаваться по ссылке. Третий необязательный параметр, 
      тайм-аут, задает продолжительность ожидания ответа от сервера (в 
      секундах). В листинге 7.6 продемонстрировано применение функции fsockopen( 
      ) для получения информации о сервере. Однако перед рассмотрением листинга 
      7.6 необходимо познакомиться еще с одной функцией — socket_set_blocking( 
      ).</P>
      <P>UDP (User Datagram Protocol) — коммуникационный протокол, не 
      ориентированный на соединение.</P>
      <P>socket_set_blocking( )</P>
      <P>Функция socket_set_b1ocki ng( ) позволяет установить контроль над 
      тайм-аутом для операций с сервером:</P>
      <P>socket_set_blocking(int манипулятор, boolean режим) </P>
      <P>Параметр манипулятор задает открытый ранее сокет, а параметр режим 
      выбирает режим, в который переключается сокет (TRUE для блокирующего 
      режима, FALSE для неблокирующего режима). Пример использования функций 
      fsockopen( ) и socket_set_blocking( ) приведен в листинге 7.6.</P>
      <P>Листинг 7.6. Использование функции fsockopen() для получения информации 
      о сервере</P>
      <P>&lt;?</P>
      <P>function getthehost($host.$path) {</P>
      <P>// Открыть подключение к узлу</P>
      <P>$fp - fsockopen($host, 80, &amp;$errno, &amp;$errstr, 30);</P>
      <P>// Перейти в блокирующий режим</P>
      <P>socket_set_blocking($fp, 1),</P>
      <P>// Отправить заголовки</P>
      <P>fputs($fp,"GET $path HTTP/1.1\r\n");</P>
      <P>fputs ($fp, "Host: $host\r\n\r\n"); $x = 1;</P>
      <P>// Получить заголовки</P>
      <P>while($x &lt; 10) :</P>
      <P>$headers = fgets ($fp, 4096);</P>
      <P>print $headers;</P>
      <P>$x++;</P>
      <P>endwhile;</P>
      <P>// Закрыть манипулятор</P>
      <P>fclose($fp);</P>
      <P>}</P>
      <P>getthehost("www. apress.com", "/");</P>
      <P>?&gt;</P>
      <P>В результате выполнения листинга 7.6 выводится следующий результат:</P>
      <P>НТТР/1.1 200 OK Server: Microsoft-IIS/4.0 Content-location:</P>
      <P>http://www.apress.com/0efault.htm Date: Sat. 19 Aug 2000 23:03:25 
      GMT</P>
      <P>Content-Type: text/html Accept-Ranges: bytes Last-Modified: Wed. 19 
      Jul</P>
      <P>2000 20:25:06 GMT ETag: "f0a61666dbff1bf1:34a5" Content-Length: 
1311</P>
      <P>pfsockopen( )</P>
      <P>Функция pfsockopen( ) представляет собой устойчивую (persistent) версию 
      fsockopen( ). Это означает, что соединение не будет автоматически 
      разорвано по завершении сценария, в котором была вызвана функция. 
      Синтаксис функции pfsockopen( ):</P>
      <P>int pfsockopen (string узел, int порт [, int код_ошибки [, string текст 
      _ошибки [, int тайм-аут]]])</P>
      <P>В зависимости от конкретных целей вашего приложения может оказаться 
      удобнее использовать pfsockopen( ) вместо fsockopen( ).</P>
      <P><A name=j></A>Запуск внешних программ</P>
      <P>Сценарии РНР также могут выполнять программы, находящиеся на сервере. 
      Такая возможность особенно часто используется при администрировании 
      системы через web-браузер, а также для более удобного получения сводной 
      информации о системе.</P>
      <P>ехес( )</P>
      <P>Функция ехес( ) запускает заданную программу и возвращает последнюю 
      строку ее выходных данных. Синтаксис функции ехес( ):</P>
      <P>string exec (string команда [, string массив [, int возврат]])</P>
      <P>Обратите внимание: функция ехес( ) только выполняет команду, не выводя 
      результатов ее работы. Все выходные данные команды можно сохранить в 
      необязательном параметре массив. Кроме того, если при заданном параметре 
      массив также задается переменная возврат, последней присваивается код 
      возврата выполненной команды.</P>
      <P>Листинг 7.7 показывает, как использовать функцию ехес( ) для выполнения 
      системной функции UNIX ping.</P>
      <P>Листинг 7.7. Проверка связи с сервером с применением функции ехес( 
)</P>
      <P>&lt;?</P>
      <P>exec("ping -с 5 www.php.net", $ping);</P>
      <P>// В Windows - exec("ping -n 5 www.php.net. $ping);</P>
      <P>for ($i=0; $i&lt; count($ping);$i++) :</P>
      <P>print "&lt;br&gt;$ping[$i]";</P>
      <P>endfor;</P>
      <P>?&gt;</P>
      <P>Результат:</P>
      <P>PING www.php.net (208.247.106.187): 56 data bytes</P>
      <P>64 bytes from 208.247.106.187: icmp_seq=0 ttl=243 time=66.602 ms</P>
      <P>64 bytes from 208.247.106.187: icmp_seq=1 ttl=243 time=55.723 ms</P>
      <P>64 bytes from 208.247.106.187: icmp_seq=2 ttl=243 time=70.779 ms</P>
      <P>64 bytes from 208.247.106.187: icmp_seq=3 ttl=243 time=55.339 ms</P>
      <P>64 bytes from 208.247.106.187: icmp_seq=4 ttl=243 time=69.865 ms</P>
      <P>-- www.php.net ping statistics --</P>
      <P>5 packets transmitted. 5 packets received. 0% packet loss</P>
      <P>round-trip min/avg/max/stddev - 55.339/63.662/70.779/6.783 ms</P>
      <P><A name=k></A>Обратные апострофы</P>
      <P>Существует и другой способ выполнения системных команд, не требующий 
      вызова функций, — выполняемая команда заключается в обратные апострофы (` 
      `), а результаты ее работы отображаются в браузере. Пример:</P>
      <P>$output = `ls`;</P>
      <P>print "&lt;pre&gt;$output&lt;/pre&gt;";</P>
      <P>Этот фрагмент выводит в браузер содержимое каталога, в котором 
      находится сценарий.</P>
      <P>Внутренний параметр 
      ping -с 5 (-п 5 в системе Windows) задает количество опросов сервера.</P>
      <P>Если вы хотите просто вернуть неформатированные результаты выполнения 
      команды, воспользуйтесь функцией passthru( ), описанной ниже.</P>
      <P>passthru( )</P>
      <P>Функция passthru( ) работает почти так же, как ехес( ), за одним 
      исключением — она автоматически выводит результаты выполнения команды. 
      Синтаксис функции passthru( ): </P>
      <P>void passthru(string команда [, int возврат])</P>
      <P>Если при вызове passthru( ) передается необязательный параметр возврат, 
      этой переменной присваивается код возврата выполненной команды.</P>
      <P>escapeshellcmd( )</P>
      <P>Функция escapeshellcmd( ) экранирует все потенциально опасные символы, 
      которые могут быть введены пользователем (например, на форме HTML), для 
      выполнения команд exec( ), passthru( ), system( ) или рореn( ). 
      Синтаксис:</P>
      <P>string escapeshellcmd (string команда)</P>
      <P>К пользовательскому вводу всегда следует относиться с определенной 
      долей осторожности, но даже в этом случае пользователи могут вводить 
      команды, которые будут исполняться функциями запуска системных команд. 
      Рассмотрим следующий фрагмент:</P>
      <P>$user_input = `rm -rf *`; // Удалить родительский каталог и все его 
      подкаталоги</P>
      <P>ехес($user_input); // Выполнить $user_input !!!</P>
      <P>Если не предпринять никаких мер предосторожности, такая команда 
      приведет к катастрофе. Впрочем, можно воспользоваться функций 
      escapeshellcmd( ) для экранирования пользовательского ввода:</P>
      <P>$user_input = `rm - rf *`; // Удалить родительский каталог и все его 
      подкаталоги</P>
      <P>ехес( escapeshellcmd($user_input)); // Экранировать опасные символы</P>
      <P>Функция escapeshellcmd( ) экранирует символ *, предотвращая 
      катастрофические последствия выполнения команды.</P>
      <P>Безопасность является одним из важнейших аспектов программирования в 
      среде Web, поэтому я посвятил целую главу этой теме и ее отношению к 
      программированию РНР. За дополнительной информацией обращайтесь к главе 
      16.</P>
      <P><A name=l></A>Работа с файловой системой</P>
      <P>В РНР существуют функции для просмотра и выполнения различных операций 
      с файлами на сервере. Информация об атрибутах серверных файлов 
      (местонахождение, владелец и привилегии) часто бывает полезной.</P>
      <P>basename( )</P>
      <P>Функция basename( ) выделяет имя файла из переданного полного имени. 
      Синтаксис функции basename( ):</P>
      <P>string basename(string полное_имя)</P>
      <P>Выделение базового имени файла из полного имени происходит следующим 
      образом:</P>
      <P>$path = "/usr/local/phppower/htdocs/index.php"; $file = 
      basename($path); // $file = "index.php"</P>
      <P>Фактически эта функция удаляет из полного имени путь и оставляет только 
      имя файла.</P>
      <P>getlastmod( )</P>
      <P>Функция getlastmod( ) возвращает дату и время последней модификации 
      страницы, из которой вызывается функция. Синтаксис функции getlastmod( 
      ):</P>
      <P>int getlastmod(void)</P>
      <P>Возвращаемое значение соответствует формату даты/времени UNIX, и для 
      его форматирования можно воспользоваться функцией date( ). Следующий 
      фрагмент выводит дату последней модификации страницы:</P>
      <P>echo "Last modified: ".date( "H:i:s a". getlastmod( ) );</P>
      <P>stat( )</P>
      <P>Функция stat( ) возвращает индексируемый массив с подробной информацией 
      о файле с заданным именем:</P>
      <P>array stat(string имя_файла)</P>
      <P>В элементах массива возвращается следующая информация:</P>
      <P>0 Устройство</P>
      <P>1 Индексный узел (inode)</P>
      <P>2 Режим защиты индексного узла</P>
      <P>3 Количество ссылок</P>
      <P>4 Идентификатор пользователя владельца</P>
      <P>5 Идентификатор группы владельца</P>
      <P>6 Тип устройства индексного узла</P>
      <P>7 Размер в байтах</P>
      <P>8 Время последнего обращения</P>
      <P>9 Время последней модификации</P>
      <P>10 Время последнего изменения</P>
      <P>11 Размер блока при вводе/выводе в файловой системе</P>
      <P>12 Количество выделенных блоков</P>
      <P>Таким образом, если вы хотите узнать время последнего обращения к 
      файлу, обратитесь к элементу 8 возвращаемого массива. Рассмотрим 
      пример:</P>
      <P>$file - "datafile.txt";</P>
      <P>list($dev, $inode, $inodep, $nlink, $uid, $gid, $inodev, $size, $atime, 
      $mtime, $ctime,</P>
      <P>$bsize) = stat($file);</P>
      <P>print "$file is $size bytes. &lt;br&gt;";</P>
      <P>print "Last access time: $atime &lt;br&gt;";</P>
      <P>print "Last modification time: $mtime &lt;br&gt;";</P>
      <P>Результат:</P>
      <P>popen.php is 289 bytes.</P>
      <P>Last access time: August 15 2000 12:00:00</P>
      <P>Last modification time: August 15 2000 10:07:18</P>
      <P>В этом примере я воспользовался конструкцией list () для присваивания 
      имен каждому возвращаемому значению. Конечно, с таким же успехом можно 
      вернуть массив, в цикле перебрать элементы и вывести всю необходимую 
      информацию. Как видите, функция stat ( ) позволяет получить различные 
      полезные сведения о файле.</P>
      <P><A name=m></A>Отображение и изменение характеристик файлов</P>
      <P>У каждого файла в системах семейства UNIX есть три важные 
      характеристики:</P>
      <UL>
        <LI>принадлежность группе; 
        <LI>владелец; 
        <LI>разрешения (permissions). </LI></UL>
      <P>Все эти характеристики можно изменить при помощи соответствующих 
      функций РНР. Функции, описанные в этом разделе, не работают в системах 
      семейства Windows.</P>
      <P>Если у вас нет опыта работы в операционных системах UNIX, информацию о 
      характеристиках файловой системы UNIX можно получить по адресу <A 
      href="http.html://sunsite.auc.dk/linux-newbie/FAQ2.htm">http://sunsite.auc.dk/linux-newbie/FAQ2.htm</A>. 
      Темы принадлежности группе, владения и разрешений рассматриваются в 
      разделе 3.2.6.</P>
      <P>chgrp( )</P>
      <P>Функция chgrp( ) пытается сменить группу, которой принадлежит заданный 
      файл. Синтаксис функции chgrp( ):</P>
      <P>int chgrp (string имя_файла, mixed группа)</P>
      <P>filegroup( )</P>
      <P>Функция filegroup( ) возвращает идентификатор группы владельца файла с 
      заданным именем или FALSE в случае ошибки. Синтаксис функции filegroup( 
      ):</P>
      <P>int filegroup (string имя_файла)</P>
      <P>chmod( )</P>
      <P>Функция chmod( ) изменяет разрешения файла с заданным именем. Синтаксис 
      функции chmod( ):</P>
      <P>int chmod (string имя_файла, int разрешения)</P>
      <P>Разрешения задаются в восьмеричной системе. Специфика задания параметра 
      функции chmod ( ) продемонстрирована в следующем примере:</P>
      <P>chmod("data_file.txt", g+r); // He работает</P>
      <P>chmod("data_file.txt", 766); // Не работает</P>
      <P>chmod("data_file.txt", 0766); // Работает</P>
      <P>fileperms( )</P>
      <P>Функция fileperms( ) возвращает разрешения файла с заданным именем или 
      FALSE в случае ошибки. Синтаксис функции fileperms( ):</P>
      <P>int fileperms (string имя_файла)</P>
      <P>chown( )</P>
      <P>Функция chown( ) пытается сменить владельца файла. Право изменения 
      владельца файла предоставляется только привилегированному пользователю. 
      Синтаксис функции chown( ):</P>
      <P>int chown (string имя_файла, mixed пользователь)</P>
      <P>fileowner( )</P>
      <P>Функция fileowner( ) возвращает идентификатор пользователя для 
      владельца файла с заданным именем. Синтаксис функции fileowner( ):</P>
      <P>int fileowner (string имя_файла)</P>
      <P><A name=n></A>Копирование и переименование файлов</P>
      <P>К числу других полезных системных функций, которые могут выполняться в 
      сценариях РНР, относятся копирование и переименование файлов на сервере. 
      Эти операции выполняются двумя функциями: сору( ) и rename( ).</P>
      <P>сору( )</P>
      <P>Скопировать файл в сценарии РНР ничуть не сложнее, чем при помощи 
      команды UNIX ср. Задача решается функцией РНР сору( ). Синтаксис функции 
      сору( ):</P>
      <P>int copy (string источник, string приемник)</P>
      <P>Функция сору( ) пытается скопировать файл источник в файл приемник; в 
      случае успеха возвращается TRUE, а при неудаче — FALSE. Если файл приемник 
      не существует, функция сору( ) создает его. Следующий пример показывает, 
      как создать резервную копию файла при помощи функции сору( ):</P>
      <P>$data_file = "datal.txt";</P>
      <P>copy($data_file. $data_file'.bak') or die("Could not copy 
      $data_file");</P>
      <P>rename ( )</P>
      <P>Функция rename( ) переименовывает файл. В случае успеха возвращается 
      TRUE, a при неудаче — FALSE. Синтаксис функции rename( ):</P>
      <P>bool rename (string старое_имя, string новое_имя)</P>
      <P>Пример переименования файла функцией rename( ):</P>
      <P>$data_file = "datal.txt";</P>
      <P>rename($data file, $datafile'.old') or die ("Could not rename $data 
      file");</P>
      <P><A name=o></A>Удаление файлов</P>
      <P>unlink( )</P>
      <P>Функция unlink( ) удаляет файл с заданным именем. Синтаксис:</P>
      <P>int unlink (string файл)</P>
      <P>Если вы работаете с РНР в системе Windows, при использовании этой 
      функции иногда возникают проблемы. В этом случае можно воспользоваться 
      описанной выше функцией system( ) и удалить файл командой DOS del:</P>
      <P>system ("del filename.txt");</P>
      <P><A name=p></A>Работа с каталогами</P>
      <P>Функции РНР позволяют просматривать содержимое каталогов и перемещаться 
      по ним. В листинге 7.8 изображена типичная структура каталогов в системе 
      UNIX.</P>
      <P>Листинг 7.8. Типичная структура каталогов</P>
      <P>drwxr-xr-x 4 root wheel 512 Aug 13 13:51 book/</P>
      <P>drwxr-xr-x 4 root wheel 512 Aug 13 13:51 code/</P>
      <P>-rw-r--r-- 1 root wheel 115 Aug 4 09:53 index.html</P>
      <P>drwxr-xr-x 7 root wheel 1024 Jun 29 13:03 manual/</P>
      <P>-rw-r--r-- 1 root wheel 19 Aug 12 12:15 test.php</P>
      <P>dirname( )</P>
      <P>Функция dirname( ) дополняет basename( ) — она извлекает путь из 
      полного имени файла. Синтаксис функции dirname( ):</P>
      <P>string dirname (string путь)</P>
      <P>Пример использования dirname( ) для извлечения пути из полного 
      имени:</P>
      <P>$path = "/usr/locla/phppower/htdocs/index.php";</P>
      <P>$file = dirname($path); // $file = "usr/local/phppower/htdocs"</P>
      <P>Функция dirname( ) иногда используется в сочетании с переменной 
      $SCRIPT_FILENAME для получения полного пути к сценарию, из которого 
      выполняется команда:</P>
      <P>$dir - dirname($SCRIPT_FILENAME);</P>
      <P>is_dir( )</P>
      <P>Функция is_dir( ) проверяет, является ли файл с заданным именем 
      каталогом:</P>
      <P>bool is_dir (string имя_файла)</P>
      <P>В следующем примере используется структура каталогов из листинга 
      7.8:</P>
      <P>$isdir = is_dir("index.html"); // Возвращает FALSE</P>
      <P>$isdir = is_dir("book");&nbsp; // Возвращает TRUE</P>
      <P>mkdir()</P>
      <P>Функция mkdir( ) делает то же, что и одноименная команда UNIX, — она 
      создает новый каталог. Синтаксис функции mkdir( ):</P>
      <P>int mkdir (string путь, int режим)</P>
      <P>Параметр путь определяет путь для создания нового каталога. Не забудьте 
      завершить параметр именем нового каталога! Параметр режим определяет 
      разрешения, назначаемые созданному каталогу.</P>
      <P>opendir( )</P>
      <P>Подобно тому как функция fopen( ) открывает манипулятор для работы с 
      заданным файлом, функция opendir( ) открывает манипулятор для работы с 
      каталогом. Синтаксис функции opendir( ):</P>
      <P>int opendir (string путь)</P>
      <P>closedir( )</P>
      <P>Функция closedir( ) закрывает манипулятор каталога, переданный в 
      качестве параметра. Синтаксис функции closedir( ):</P>
      <P>void closedir(int манипулятор_каталога)</P>
      <P>readdir( )</P>
      <P>Функция readdir( ) возвращает очередной элемент заданного каталога. 
      Синтаксис:</P>
      <P>string readdir(int манипулятор_каталога)</P>
      <P>С помощью этой функции можно легко вывести список всех файлов и 
      подкаталогов, находящихся в текущем каталоге:</P>
      <P>$dh = opendir(' . );</P>
      <P>while ($file = readdir($dh)) :</P>
      <P>print "$file &lt;br&gt;"; endwhile;</P>
      <P>closedir($dh);</P>
      <P>chdir( )</P>
      <P>Функция chdir( ) работает так же, как команда UNIX cd, — она 
      осуществляет переход в каталог, заданный параметром. Синтаксис функции 
      chdir( ):</P>
      <P>int chdir (string каталог)</P>
      <P>В следующем примере мы переходим в подкаталог book/ и выводим его 
      содержимое:</P>
      <P>$newdir = "book";</P>
      <P>chdir($newdir) or die("Could not change to directory ($newdir)"); $dh = 
      opendir(' . ');</P>
      <P>print "Files:";</P>
      <P>while ($file = readdir($dh)) ;</P>
      <P>print "$file &lt;br&gt;";</P>
      <P>endwhile;</P>
      <P>closedir($dh);</P>
      <P>rewinddir( )</P>
      <P>Функция rewlnddir( ) переводит указатель текущей позиции в начало 
      каталога, открытого функцией opendir( ). Синтаксис функции rewinddir( 
      ):</P>
      <P>void rewinddir (int нанипулятор_каталога)</P>
      <P><A name=q></A>Проект 1: простой счетчик обращений</P>
      <P>Сценарий, представленный в этом разделе, подсчитывает количество 
      обращений к странице, в которой он находится. Прежде чем переходить к 
      программному коду в листинге 7.9, просмотрите алгоритм, написанный на 
      псевдокоде:</P>
      <OL>
        <LI>Присвоить переменной $access имя файла, в котором будет храниться 
        значение счетчика. 
        <LI>Использовать функцию filе( ) для чтения содержимого $access в массив 
        $visits. Префикс @ перед именем функции подавляет возможные ошибки 
        (например, отсутствие файла с заданным именем). 
        <LI>Присвоить переменной $current_visitors значение первого (и 
        единственного) элемента массива $visits. 
        <LI>Увеличить значение $current_visitors на 1. 
        <LI>Открыть файл $access для записи и установить указатель текущей 
        позиции в начало файла. 
        <LI>Записать значение $current_visitors в файл $access. 
        <LI>Закрыть манипулятор, ссылающийся на файл $access. </LI></OL>
      <P>Листинг 7.9. Простой счетчик обращений</P>
      <P>&lt;?</P>
      <P>// Сценарий: простой счетчик обращений</P>
      <P>// Назначение: сохранение количества обращений в файле</P>
      <P>$access = "hits.txt"; // Имя файла выбирается произвольно</P>
      <P>$visits = @file($access); // Прочитать содержимое файла в масссив</P>
      <P>$current_visitors = $visits[0]; // Извлечь первый (и единственный) 
      элемент</P>
      <P>++$current_visitors; // Увеличить счетчик обращений</P>
      <P>$fh = fopen($access. "w"); // Открыть файл hits.txt и установить</P>
      <P>// указатель текущей позиции в начало файла</P>
      <P>@fwrite($fh, $current_visitors);// Записать новое значение счетчика</P>
      <P>// в файл "hits.txt"</P>
      <P>fclose($fh);&nbsp; // Закрыть манипулятор файла "hits.txt"</P>
      <P>?&gt;</P>
      <P><A name=r></A>Проект 2: построение карты сайта</P>
      <P>Сценарий, приведенный в листинге 7.10, строит карту сайта — 
      иерархическое изображение всех папок и файлов на сервере, начиная с 
      заданного каталога. При вычислении отступов элементов, из которых состоит 
      карта сайта, используются функции, определенные в этой и предыдущих 
      главах. Прежде чем переходить к программе, просмотрите алгоритм, 
      написанный на псевдокоде:</P>
      <OL>
        <LI>Объявить служебные переменные для хранения родительского каталога, 
        имени графического файла с изображением папки, названия страницы и флага 
        серверной ОС (Windows или другая система). 
        <LI>Объявить функцию display_directory( ), которая читает содержимое 
        каталога и форматирует его для вывода в браузере. 
        <LI>Построить путь к каталогу объединением имени, передаваемого в 
        переменной $dir1, с $dir. 
        <LI>Открыть каталог и прочитать его содержимое. Отформатировать имена 
        каталога и файлов и вывести их в браузере. 
        <LI>Если текущий файл является каталогом, рекурсивно вызвать функцию 
        display_di rectory( ) и передать ей имя нового каталога для вывода. 
        Вычислить отступ, используемый при форматировании вывода. </LI></OL>
      <P>Если файл не является каталогом, он форматируется для отображения в 
      виде гиперссылки (а также вычисляется отступ, используемый при 
      форматировании).</P>
      <P>Листинг 7.10. Программа sitemap.php</P>
      <P>// Файл: sitemap.php</P>
      <P>// Назначение: построение карты сайта</P>
      <P>// Каталог, с которого начинается построение карты</P>
      <P>$beg_path = "C:\Program FilesVApache 
      Group\Apache\htdocs\phprecipes";</P>
      <P>// Файл с графическим изображением папки.</P>
      <P>// Путь должен задаваться Относительно* корневого каталога сервера 
      Apache</P>
      <P>$folder_location = "C:\My Documents\PHP for Programmers\FINAL 
      CHPS\graphics\folder.gif";</P>
      <P>// Текст в заголовке окна $page_name = "PHPRecipes SiteMap";</P>
      <P>// В какой системе будет использоваться сценарий - Linux или 
      Windows?</P>
      <P>// (0 - Windows; 1 - Linux)</P>
      <P>$usingjinux = 0;</P>
      <P>// Функция: display_directory</P>
      <P>// Назначение: чтение содержимого каталога, определяемого 
параметром</P>
      <P>// $dir1, с последующим форматированием иерархии каталогов и 
файлов.</P>
      <P>// Функция может вызываться рекурсивно.</P>
      <P>function display_directory ($dir1, $folder_location, $using_linux, 
      $init_depth) {</P>
      <P>// Обновить путь</P>
      <P>$dir.= $dir1;</P>
      <P>Sdh = opendir($dir);</P>
      <P>while($file = readdir($dh)) :</P>
      <P>// Элементы каталогов "." и ".." не выводятся.</P>
      <P>if ( ($file != ".") &amp;&amp; ($file != "..") ) :</P>
      <P>if ($using_linux == 0 ) :</P>
      <P>$depth = explode("\\", $dir): else :</P>
      <P>$depth = explode("/", $dir); endif ; $curtent_depth = sizeof( 
      $depth);</P>
      <P>// Построить путь по правилам используемой операционной системы. if 
      ($using_linux == 0) :</P>
      <P>$tab_depth = $current_deptn - $init_depth;</P>
      <P>$file = $dir. "\\", $file; else :</P>
      <P>$file = $dir. "/",$file; endif;</P>
      <P>// Переменная $file содержит каталог? if ( is dir($file) ) :</P>
      <P>$х = 0;</P>
      <P>// Вычислить отступ</P>
      <P>while ( $х &lt; ($tab_depth * 2) ) :</P>
      <P>print "&amp;nbsp;";</P>
      <P>$х++; endwhile;</P>
      <P>print "&lt;img src=\"$folder_location\" alt=\"[dir]\"&gt;</P>
      <P>".basename($file)."&lt;br&gt;";</P>
      <P>// Увеличить счетчик &amp;nbsp;</P>
      <P>// Рекурсивный вызов функции display_directory()</P>
      <P>display_directory($file, $folder_location, $using_linux, 
      $init_depth);</P>
      <P>// He каталог</P>
      <P>else :</P>
      <P>// Построить путь по правилам используемой</P>
      <P>// операционной системы.</P>
      <P>if ($using_linux == 0) :</P>
      <P>$tab_depth = ($current_depth - $init_depth) - 2; $x = 0;</P>
      <P>// Вычислить отступ</P>
      <P>while ( $x &lt; (($tab_depth * 2) + 5) ) :</P>
      <P>print "&amp;nbsp;";</P>
      <P>$x++;</P>
      <P>endwhile:</P>
      <P>print "&lt;a href =\ "" 
      .$dir."\\".basename($file)."\"&gt;".basename($file)."&lt;/a&gt; 
      &lt;br&gt;";</P>
      <P>else :</P>
      <P>print "&lt;a href = 
      \"".$dir."/".basename($file)."\"&gt;".basename($file)."&lt;/a&gt; 
      &lt;br&gt;";</P>
      <P>endif:</P>
      <P>endif; // Is_dir(file) endif: // If ! "." or ".."</P>
      <P>endwhile;</P>
      <P>// Закрыть каталог closedir($dh);</P>
      <P>&lt;html &gt;</P>
      <P>&lt;head&gt;</P>
      <P>&lt;title&gt; &lt;? print "$page_name"; ?&gt; &lt;/title&gt;</P>
      <P>&lt;/head&gt;</P>
      <P>&lt;body bgcolor="#ffffff" text="#000000" link="#000000" 
      vlink="#000000" alink="#000000"&gt;</P>
      <P>&lt;?</P>
      <P>// Вычислить начальный отступ</P>
      <P>if ($using_linux == 0) :</P>
      <P>$depth = explode("\\", $beg_path);</P>
      <P>else :</P>
      <P>$depth = explode("/", $beg_path);</P>
      <P>endif:</P>
      <P>$init_depth = sizeof($depth);</P>
      <P>display_directory ($beg_path, $folder_location, $using_linux, 
      $init_depth);</P>
      <P>?&gt;</P>
      <P>&lt;/body&gt;</P>
      <P>&lt;/html&gt;</P>
      <P>На рис. 7.1 изображен результат выполнения сценария для каталога с 
      несколькими главами этой книги.</P>
      <P>&nbsp;<IMG src="2_1_7.1Rus.jpg"></P>
      <P>Рис. 7.1. Вывод структуры каталога на сервере с использованием сценария 
      sitemap.php</P>
      <P><A name=s></A>Итоги</P>
      <P>В этой главе были представлены многие средства РНР, предназначенные для 
      работы с файлами. В частности, мы рассмотрели следующие вопросы:</P>
      <UL>
        <LI>проверку существования файлов; 
        <LI>открытие и закрытие файлов и потоков ввода/вывода; 
        <LI>запись в файл и чтение из него; 
        <LI>перенаправление файла в выходной поток; 
        <LI>запуск внешних программ; 
        <LI>операции с файловой системой. </LI></UL>
      <P>Материал этой главы подготовил почву для следующей главы, «Строки и 
      регулярные выражения», поскольку при разработке web-приложений обработка 
      строк и операции ввода/вывода очень тесно 
    связаны.</P></LI></DIV>
<center>
[ <a href="06.php">Назад</a> | <a href="index.php">Содержание</a> | <a href="08.php">Вперед</a> ]
</center><br>
<? include_once '../../sys/inc/tfoot.php'; ?>