<? include 'head.php' ?>
<!DOCTYPE php PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html><head>
<link rel="stylesheet" href="css.css" type="text/css">
<meta http-equiv="Content-Type" content="text/html; charset=windows-1251">
<meta http-equiv="Content-Language" content="ru">
<title>Глава 1.</title></head>
<body>
<h1>Глава 1. РЕЛЯЦИОННЫЕ БАЗЫ ДАННЫХ. ВВЕДЕНИЕ.</h1>
<hr width="50%">
<h3>ВВЕДЕНИЕ</h3>
<p><b>SQL</b> (произносится обычно &quot;СЭКВЭЛ&quot; (или, более англообразно - 
СКЬЮЭЛ)) означает <b> Структурированный Язык Запросов.</b></p>
<p>Это язык, который дает  возможность создавать реляционные базы данных (и работать с 
ними), которые представляют собой наборы связанной информации, сохраняемой в таблицах.</p>
<p>Мир БД становится всё более единым, что привело к необходимости 
создания стандартного языка, который мог бы использоваться для функционирования 
в большом количестве различных видов компьютерных сред. Стандартный язык 
даст возможность пользователям, знающим один набор команд, использовать их, чтобы 
создавать, отыскивать, изменять и передавать информацию, независимо от того, 
где идёт работа: на персональном компьютере, сетевой рабочей станции или на универсальной ЭВМ.</p>
<p>В нашем, всё более и более взаимосвязанном компьютерном мире, пользователь, 
снабжённый таким языком, имеет огромное преимущество в использовании и обобщении 
информации из ряда источников с помощью большого количества способов.</p>
<p>Элегантность и независимость от специфики компьютерных технологий, а также 
его поддержка лидерами промышленности в области технологии РБД, сделали <b>SQL</b> 
(и, вероятно, в течение обозримого будущего, оставят его) основным стандартным языком БД. По этой причине любой, кто хочет работать с 
базами данных 90-х годов (прошлого века), должен знать<b> SQL.</b></p>
<p><b>Стандарт SQL</b> определяется<b> ANSI (Американским Национальным 
Институтом Стандартов)</b> и в данное время также принимается <b>ISO 
(Международной организацией по стандартизации).</b> Однако большинство 
коммерческих программ БД расширяют<b> SQL</b> без уведомления<b> ANSI</b>, 
добавляя разные особенности в этот язык, которые, как они считают, будут весьма полезны.<br>
Иногда это несколько нарушает стандарт языка, хотя хорошие идеи имеют тенденцию 
развиваться и становиться стандартами  рынка в силу полезности своих качеств.</p>
<p>В этой книге мы будем в основном следовать стандарту ANSI, но одновременно 
иногда будем давать и некоторые наиболее распространённые отклонения от его стандарта.</p>
<p>Вы должны проконсультироваться в документации вашего пакета программ, 
который будете использовать, чтобы знать, где в нём этот стандарт видоизменен.</p>
<p>ПРЕЖДЕ ЧЕМ ВЫ СМОЖЕТЕ ИСПОЛЬЗОВАТЬ SQL, вы должны понять, <b>что такое реляционные базы данных.</b></p>
<p>В этой главе мы  объясним и покажем, насколько РБД полезны. Мы не будем 
обсуждать SQL именно здесь, и, если вы уже знаете эти понятия достаточно хорошо, вы можете просто пропустить эту главу. <br>
В любом случае вы должны просмотреть три таблицы, которые предоставляются и 
объясняются в конце главы; они станут основой наших примеров в этой книге. 
Вторая копия этих таблиц находится в <a href="e.php">Приложении E</a>, и мы рекомендуем скопировать их для удобства ссылки к ним.</p>
<hr width="50%">
<h3><a name="what">Ч</a>ТО ТАКОЕ &quot;РЕЛЯЦИОННАЯ БАЗА ДАННЫХ&quot;?</h3>
<p><b>Реляционная база данных </b>это тело связанной информации, сохраняемой в 
двухмерных таблицах. Это напоминает адресную или телефонную книгу.</p>
<p>В любой книге имеется большое количество разделов, каждый из которых соответствует 
определённой особенности. Для каждой такой особенности может быть несколько 
независимых фрагментов данных, например: имя, телефонный номер и адрес.<br>
Предположим, что вы должны сформатировать эту адресную книгу в виде таблицы со 
строками и столбцами. Каждая строка (называемая также записью) будет 
соответствовать определённой личности; каждый столбец будет содержать 
значение для каждого типа данных: имени, телефонного номера и адреса, представляемых в каждой строке.</p>
<p>Адресная книга могла бы выглядеть следующим образом:</p>
<table cellSpacing="15">
<tr><td>Имя</font></td><td>Телефон</font></td><td>Адрес</font></td></tr>
<tr><th>Gerry Farish</th><th>(415)365-8775</th><th>127 Primrose Ave.,SF</th></tr>
<tr><th>Celia Brock</th><th>(707)874-3553</th><th>246 #3rd St.,Sonoma</th></tr>
<tr><th>Yves Grillet</th><th>(762)976-3665</th><th>778 Modernas,Barcelona</th></tr></table>
<p>То, что вы получили, является<b> основой реляционной базы данных</b>, как и 
было определено в начале этого обсуждения, а именно - <b>двухмерной (строка и столбец) таблицей информации.</b></p>
<p>Однако РБД редко состоят из одной таблицы. Такая таблица меньше, чем файловая 
система. Создав несколько таблиц взаимосвязанной информации, вы сможете 
выполнять более сложные и мощные операции с вашими данными. Мощность БД зависит 
от связи, которую вы можете создать между фрагментами информации, а не от самого фрагмента информации.</p>
<hr width="50%">
<h3><a name="Table">С</a>ВЯЗЫВАНИЕ ОДНОЙ ТАБЛИЦЫ С ДРУГОЙ</h3>
<p>Давайте используем пример нашей адресной книги, чтобы начать 
обсуждение БД, которая может реально использоваться в деловой ситуации. 
Предположим, что персонажи в нашей первой таблице (адресной книге) это пациенты 
больницы. В другой таблице мы могли бы запомнить дополнительную информацию об 
этих пациентах. Столбцы второй таблицы можно назвать Пациент, Доктор, Страховка и Баланс.</p>
<pre>   Пациент   Доктор    Страховка    Баланс

   Farish    Drume     B.C./B.S.    $272.99

   Grillet   Halben    None         $44. 76

   Brock     Halben    Health,Inc.  $9077.47</pre>
<p>Много мощных функций можно использовать для извлечения информации из этих 
таблиц, согласно указанным параметрам, особенно когда эти параметры включают в 
себя фрагменты информации, связанные в различных таблицах друг с другом. 
Например, возьмём докторов. Предположим доктор Halben захотел получить номера 
телефонов всех своих пациентов. Чтобы извлечь эту информацию, он мог бы связать 
таблицу с номерами телефонов пациентов (по адресной книге) с таблицей, которая 
указывала бы, какой из пациентов - его. Хотя в этом простом примере он мог бы 
держать это в голове и сразу получать номера телефонов пациентов Grillet и Brock, 
эти таблицы могут быть достаточно большими и сложными.</p>
<p>Программы РБД разрабатывались для того, чтобы обрабатывать большие и сложные совокупности 
данных такого типа, что, очевидно, является более универсальным методом в 
деловом мире. Даже если бы БД больницы содержала сотни или тысячи имен, как это 
вероятно и бывает на практике, одна команда SQL могла бы выдать доктору Halben информацию, в которой он нуждается, почти немедленно.</p>
<hr width="50%">
<h3><a name="Lines">П</a>ОРЯДОК СТРОК ПРОИЗВОЛЕН</h3>
<p>Чтобы поддерживать максимальную гибкость, строки таблицы, по определению, не 
должны находиться в каком-то определенном порядке. С этой точки зрения структура БД отличается от нашей адресной книги.</p>
<p>Вход в адресную книгу обычно упорядочивается в алфавитном порядке. В системах 
с РБД имеется одна мощная возможность для пользователей: способность 
упорядочивать информацию так, чтобы они могли восстанавливать её.</p>
<p>Рассмотрим вторую таблицу. Иногда вам необходимо видеть эту информацию упорядоченной в алфавитном порядке по именам, иногда - в возрастающем или 
убывающем порядке, а иногда - сгруппированной по отношению к какому-нибудь доктору.</p>
<p>Порядок набора в строках будет конфликтовать со способностью заказчика 
изменять его, поэтому строки всегда рассматриваются как неупорядоченные. По этой 
причине вы не можете просто сказать: &quot;Мы хотим посмотреть пятую строку 
таблицы&quot;. Пренебрегая порядком, в котором данные вводились, или любым другим 
критерием, мы определим не ту строку, хотя она и будет пятой. Строки таблицы не находятся в какой-либо определенной последовательности.</p>
<hr width="50%">
<h3><a name="IdenLine">И</a>ДЕНТИФИКАЦИЯ СТРОК (ПЕРВИЧНЫЙ КЛЮЧ)</h3>
<p>По этим и другим причинам вы должны иметь в вашей таблице столбец, который  идентифицировал 
бы каждую строку уникально. Обычно этот столбец содержит номер, 
например: номер пациента, назначаемый каждому пациенту. Конечно, вы могли бы 
использовать имена пациентов, но возможно, что имеется несколько Mary Smith, и 
в этом случае вы не будете иметь другого способа отличить этих пациентов друг от друга.</p>
<p>Вот почему номера так необходимы. Такой уникальный столбец (или уникальная 
группа столбцов), используемый для идентификации каждой строки и хранения всех 
строк по отдельности, называется первичным ключом таблицы.</p>
<p>Первичные ключи таблицы - важный элемент в структуре базы данных. Они - 
основа вашей системы записи в файл; и, когда вы хотите найти определённую строку 
в таблице, вы ссылаетесь на этот первичный ключ. Кроме того, первичные ключи 
гарантируют, что ваши данные имеют определенную целостность. Если первичный ключ 
правильно используется и поддерживается, вы будете знать, что нет пустых строк 
таблицы и что каждая строка отличается от любой другой строки. Мы будем 
обсуждать ключи и далее, когда поговорим относительно справочной целостности в <a href="ch19.php">Главе 19</a>.</p>
<hr width="50%">
<h3><a name="NumSt">С</a>ТОЛБЦЫ ИМЕНУЮТСЯ И НУМЕРУЮТСЯ</h3>
<p>В отличие от строк, столбцы таблицы (называемые также полями) упорядочиваются 
и именуются. Таким образом, в нашей таблице адресной книги можно указать на 
&quot;адрес столбца&quot; или на &quot;столбец 3&quot;. Это означает, что каждый столбец 
данной таблицы должен иметь уникальное имя, чтобы избежать неоднозначности. Лучше 
всего, если эти имена указывают на содержание поля. В типовых таблицах этой 
книги мы будем использовать такие сокращения для имени столбца как cname для 
имени заказчика и odate для даты заказа. Мы также дадим каждой таблице личный 
числовой номер столбца в качестве первичного ключа. Следующий раздел будет рассматривать эти таблицы и их ключи более подробно.</p>
<hr width="50%">
<h3><a name="Data">Т</a>ИПОВАЯ БАЗА ДАННЫХ</h3>
<p>Таблицы 1.1, 1.2 и 1.3 составляют реляционную базу данных, которая является 
минимально достаточной, чтобы легко её отслеживать, и достаточно полной, чтобы 
иллюстрировать главные понятия и практику использования SQL. Эти таблицы 
напечатаны в этой главе, а также в <a href="e.php">Приложении E</a>.</p>
<p>Так как они будут использоваться для иллюстрирования различных особенностей 
SQL по всей этой книге, мы рекомендуем  вам скопировать их для удобства использования.</p>
<p>Вы могли уже заметить, что первый столбец каждой таблицы содержит номера,  значения 
которых различны для каждой строки. Как вы, наверное, уже предположили, это - 
первичные ключи таблиц. Некоторые из этих номеров также показаны в столбцах 
других таблиц. В этом нет ничего неверного. Они показывают связь между строками, 
которые используют значение, принимаемое из первичного ключа, и строками, где это значение используется в самом первичном ключе.</p>
<pre>Таблица 1.1: Продавцы

      ----------------------------------------------
        SNUM  |   SNAME   |  CITY        |   COMM
      --------|-----------|--------------|----------
        1001  |  Peel     |  London      |    .12
        1002  |  Serres   |  San Jose    |    .13
        1004  |  Motika   |  London      |    .11
        1007  |  Rifkin   |  Barcelona   |    .15
        1003  |  Axelrod  |  New York    |    .10
       ---------------------------------------------


Таблица 1.2: Заказчики

       ----------------------------------------------
        CNUM  |  CNAME     | CITY    | RATING | SNUM
       -------|------------|---------|--------|------
        2001  |  Hoffman   | London  |   100  | 1001
        2002  |  Giovanni  | Rome    |   200  | 1003
        2003  |  Liu       | SanJose |   200  | 1002
        2004  |  Grass     | Berlin  |   300  | 1002
        2006  |  Clemens   | London  |   100  | 1001
        2008  |  Cisneros  | SanJose |   300  | 1007
        2007  |  Pereira   | Rome    |   100  | 1004
       ----------------------------------------------

Таблица 1.3: Заказы

       -----------------------------------------------
        ONUM  |    AMT    |    ODATE    | CNUM | SNUM
       -------|-----------|-------------|------|------
        3001  |    18.69  |  10/03/1990 | 2008 | 1007
        3003  |   767.19  |  10/03/1990 | 2001 | 1001
        3002  |  1900.10  |  10/03/1990 | 2007 | 1004
        3005  |  5160.45  |  10/03/1990 | 2003 | 1002
        3006  |  1098.16  |  10/03/1990 | 2008 | 1007
        3009  |  1713.23  |  10/04/1990 | 2002 | 1003
        3007  |    75.75  |  10/04/1990 | 2004 | 1002
        3008  |  4723.00  |  10/05/1990 | 2006 | 1001
        3010  |  1309.95  |  10/06/1990 | 2004 | 1002
        3011  |  9891.88  |  10/06/1990 | 2006 | 1001
       -----------------------------------------------</pre>
<p>Например, поле snum в таблице Заказчиков указывает, какому продавцу назначен 
данный заказчик. Номер поля snum связан с таблицей Продавцов, которая даёт 
информацию об этих продавцах. Очевидно, что продавец, которому назначены 
заказчики, должен уже существовать - то есть значение snum из таблицы Заказчиков 
должно также быть представлено в таблице Продавцов. Если это так, то говорят, 
что &quot;система находится в состоянии справочной целостности&quot;. Этот вывод будет 
более полно и формально объяснен в <a href="ch19.php">Главе 19</a>.</p>
<h6><b>ПРИМЕЧАНИЕ:</b> эти три представленных таблицы в тексте имеют 
русскоязычные имена - Продавцы, Заказчики и Заказы - и далее будут упоминаться именно под этими 
именами. Имена любых других применяемых в книге таблиц будут написаны 
по-английски, чтобы отличать их от  базовых таблиц этой БД. Кроме того, в 
целях однозначности имена заказчиков, продавцов, Системных Каталогов, а также полей в тексте, также будут даны на латыни.</h6>
<p>Таблицы приведены как пример похожей ситуации в реальной жизни, когда вы 
будете использовать SQL, чтобы следить за продавцами, их заказчиками и заказами 
заказчиков. Давайте рассмотрим эти три таблицы и значения их полей. Здесь показаны столбцы Таблицы 1.1:</p>
<pre>   ПОЛЕ         СОДЕРЖАНИЕ
  ---------    ----------------------------------------------
   snum        уникальный номер назначенный каждому продавцу
               (&quot;номер служащего&quot;).

   sname       имя продавца.

   city        местонахождение продавца (город).

   comm        комиссионные продавцов в десятичной форме.


Таблица 1.2 содержит следующие столбцы:

   ПОЛЕ        СОДЕРЖАНИЕ
  --------    ---------------------------------------------------
   cnum       уникальный номер, назначенный каждому заказчику.

   cname      имя заказчика.

   city       местонахождение заказчика (город).

   rating     код, указывающий уровень предпочтения данного заказчика
              перед другими. Более высокий номер указывают на большее предпочтение (рейтинг).
   snum       номер продавца, назначенного этому заказчику (из таблицы Продавцов).


 И столбцы в Таблице 1.3:

     ПОЛЕ      СОДЕРЖАНИЕ
    --------- ---------------------------------------------------
    onum      уникальный номер, данный каждому приобретению.

    amt       значение суммы приобретений.

    odate     дата приобретения.

    cnum      номер заказчика, делающего приобретение (из таблицы Заказчиков).
    snum      номер продавца, продающего приобретение (из таблицы Продавцов).</pre>
<hr width="50%">
<h3><a name="Res">Р</a>ЕЗЮМЕ</h3>
<p>Теперь вы знаете, что такое реляционная база данных - понятие, которое звучит 
сложнее, чем это есть на самом деле. Вы также изучили некоторые фундаментальные 
принципы  того, как сделаны таблицы: как работают строки и столбцы, 
как первичные ключи отличают строки друг друга и как столбцы могут ссылаться на значения в других столбцах.</p>
<p>Вы поняли, что запись это синоним строки и что поле это синоним столбца. Оба 
термина встречаются в обсуждении SQL, и мы будем использовать их в равной степени в этой книге.</p>
<p>Вы теперь знакомы с таблицами примеров. Краткие и простые, они способны 
показать большинство особенностей языка, как вы это увидите далее. В некоторых 
случаях мы будем использовать одни таблицы или постулаты  различных 
данных в другой таблице, чтобы показать вам некоторые другие возможности.</p>
<p>Теперь вы готовы к погружению в SQL. Следующая глава даст 
краткое рассмотрение языка и информацию, которая поможет вам обращаться к уже пройденным местам.</p>
<hr width="50%">
<h3><a name="Work">Р</a>АБОТА СО SQL</h3>
<pre>1. Какое поле таблицы Заказчиков является первичным ключом?

2. Что является столбцом 4 из таблицы Заказчиков?

3. Как по другому называется строка? Столбец?

4. Почему вы не можете запрашивать для просмотра первые пять строк таблицы?

(См. ответы в <a href="a.php#1">Приложении A</a>.)</pre></body></html>
<? include 'foot.php' ?>