<? include 'head.php' ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html><head>
<link rel="stylesheet" href="css.css" type="text/css">
<meta http-equiv="Content-Type" content="text/html; charset=windows-1251">
<meta http-equiv="Content-Language" content="ru">
<title>Глава 24.</title></head>
<body>
<h1>Глава 24. КАК ДАННЫЕ SQL ХРАНЯТСЯ В УПОРЯДОЧЕННОМ ВИДЕ?</h1>
<hr width="50%">
<p>В этой главе вы узнаете, как типовая база данных SQL  сохраняет самоорганизованность. 
Самоорганизованность обеспечивается реляционной 
базой данных, создаваемой и поддерживаемой с помощью программы. 
Вы можете обращаться к  таблицам самостоятельно для получения 
информации о привилегиях, таблицах, индексах, и так далее. В этой главе мы 
покажем вам некоторые типы содержимого такой БД.</p>
<a name="24.1"></a>
<h3>КАТАЛОГ СИСТЕМЫ</h3>
<p>Чтобы функционировать как БД SQL, ваша компьютерная система 
должна следить за многими вещами: таблицами, представлениями, индексами, синонимами, привилегиями, пользователями и т.д. 
Имеются различные способы делать это, но ясно, что наиболее логичный, эффективный и согласованный способ делать это в реляционной среде 
состоит в том, чтобы сохранять эту информацию в таблицах. Это даёт возможность компьютеру размещать 
информацию и управлять ею,  используя те же самые процедуры, которые он использует чтобы размещать и управлять данными, которые он хранит для вас.</p>
<p>Хотя это - вопрос конкретной программы, а не  стандарта ANSI, большинство 
БД SQL используют набор SQL-таблиц, хранящих служебную информацию, для своих внутренних потребностей. Этот набор называется в различных публикациях  системный каталог, словарь данных
или просто системные таблицы (Термин &quot;словарь данных&quot; может также относится к общему архиву данных, включая информацию о физических 
параметрах БД, - данных, которые хранятся вне SQL. Следовательно, имеются программы баз данных, которые имеют и системный каталог, и словарь данных.)</p>
<p>Таблицы системного каталога напоминают обычные SQL-таблицы: те же строки и столбцы данных. Например, одна таблица каталога обычно содержит информацию о таблицах, существующих в 
БД, по одной строке на каждую таблицу базы данных; другая содержит информацию о различных столбцах таблиц, по одной строке на столбец, и так далее.</p>
<p>Таблицы каталога создаются и заполняются с помощью самой БД и идентифицируются с помощью специальных имён, таких, например,
как SYSTEM.</p>
<p>База данных создает эти таблицы и модифицирует их автоматически; таблицы каталога не могут быть непосредственно подвергнуты
действию команды модификации. Если это случится, это значительно запутает всю систему и сделает её неработоспособной. Однако в большинстве систем каталог может быть запрошен пользователем. Это очень полезно, потому что это даёт  возможность узнать кое-что о 
БД, которую вы используете. Конечно, не вся информация  всегда доступна всем пользователям. Подобно другим 
таблицам, доступ к каталогу ограничен для пользователей без соответствующих привилегий.
Так как каталог принадлежит самой системе, имеется некоторая неясность 
относительно того, кто имеет привилегии и кто может предоставить привилегии в этом каталоге. Обычно привилегии каталога предоставляет суперпользователь, например, администратор системы, зарегистрированный как
SYSTEM или DBA. Кроме того, некоторые привилегии могут предоставляться пользователям автоматически.</p>
<a name="24.2"></a>
<h3>ТИПИЧНЫЙ  КАТАЛОГ СИСТЕМЫ</h3>
<p>Давайте рассмотрим некоторые таблицы, которые мы могли бы найти в типовом каталоге системы:</p>
<pre>     Таблицы                     Содержание
 -------------      ------------------------------------------- 
 
 SYSTEMCATALOG      Таблицы (базовые и представления)
 
 SYSTEMCOLUMNS      Столбцы таблицы
 
 SYSTEMTABLES       Каталог представления в SYSTEMCATALOG
 
 SYSTEMINDEXES      Индексы в таблице
 
 SYSTEMUSERAUTH     Пользователи базы данных
 
 SYSTEMTABAUTH      Объектные привилегии пользователей
 
 SYSTEMCOLAUTH      Столбцовые привилегии пользователей

 SYSTEMSYNONS       Синонимы таблиц</pre>
<p>Теперь, если наш DBA предоставит пользователю Stephen право просматривать SYSTEMCATALOG такой командой</p>
<pre>     GRANT SELECT ON SYSTEMCATALOG TO Stephen;</pre>
<p>то Stephen сможет увидеть некоторую информацию обо всех таблицах в БД (мы имеем здесь пользователя DBA, пользователя Chris 
- 
владельца трёх наших типовых таблиц, а также Adrian - владельца представления Londoncust).</p>
<pre>        SELECT tname, owner, numcolumns, type, CO
           FROM SYSTEMCATALOG;


         ===============  SQL Execution Log ===============
        |                                                  |
        | SELECT tname, owner, numcolumns, type, CO        |
        | FROM  SYSTEMCATALOG;                             |
        |                                                  |
        | ================================================ |
        |   tname          owner    numcolumns  type  CO   |
        | -------------   -------   ----------  ----  ---  |
        | SYSTEMCATALOG   SYSTEM            4     B        |
        | Salespeople     Chris             4     B        |
        | Customers       Chris             5     B        |
        | Londoncust      Adrian            5     V    Y   |
        | Orders          Chris             5     B        |
        |                                                  |
         ==================================================

	  Рисунок 24.1 Содержание таблицы SYSTEMCATALOG</pre>
<p>Как видите, каждая строка описывает свою таблицу. 
Первый столбец - имя; второй - имя пользователя, который владеет ею; 
третий - число столбцов  таблицы; четвертый - код 
из одного символа: это или B (для базовой таблицы), или V (для представления). Последний столбец имеет пустые (NULL) значения, если его
тип не равен V, и этот столбец указывает, определена или нет возможность проверки.</p>
<p>Обратите внимание что SYSTEMCATALOG (СИСТЕМНЫЙ КАТАЛОГ) представлен как одна из таблиц в вышесказанном списке. Для
простоты мы исключили остальные каталоги системы из вывода. Таблицы системного каталога обычно показываются в SYSTEMCATALOG.</p>
<a name="24.3"></a>
<h3>ИСПОЛЬЗОВАНИЕ ПРЕДСТАВЛЕНИЙ В ТАБЛИЦАХ КАТАЛОГА</h3>
<p>Поскольку SYSTEMCATALOG это таблица, вы можете использовать 
её в представлении. Фактически можно считать, что имеется такое представление с именем SYSTEMTABLES.</p>
<p>Это представление SYSTEMCATALOG содержит только те таблицы, которые входят в системный каталог; это обычно таблицы базы данных, типа
таблицы Продавцов, которые показаны в SYSTEMCATALOG, но не в SYSTEMTABLES.</p>
<p>Давайте предположим, что только таблицы каталога являются собственностью пользователя SYSTEM. Если вы захотите, вы можете определить другое
представление, которое специально исключало бы таблицы каталога из вывода:</p>
<pre>           CREATE VIEW Datatables
              AS SELECT *
                 FROM SYSTEMCATALOG
                 WHERE owner &lt; &gt; 'SYSTEM';

<b>РАЗРЕШИТЬ ПОЛЬЗОВАТЕЛЯМ ВИДЕТЬ (ТОЛЬКО) ИХ СОБСТВЕННЫЕ ОБЪЕКТЫ</b></pre>
<p>Кроме того, возможно другое использование представлений каталога. 
Предположим, вам нужно, чтобы каждый пользователь был способен сделать запрос 
каталога для получения информации только из таблиц, которыми он владеет. 
Поскольку значение USER в команде SQL постоянно для ID
доступа пользователя, выдающего команду, оно может всегда быть использовано, чтобы давать доступ пользователям только к их собственным таблицам.</p>
<p>Вы можете, для начала, создать следующее представление:</p>
<pre>               CREATE VIEW Owntables
                 AS SELECT *
                    FROM SYSTEMCATALOG
                    WHERE Owner = USER;</pre>
<p>Теперь вы можете предоставить всем пользователям доступ к этому представлению:</p>
<pre>            GRANT SELECT ON Owntables TO PUBLIC;</pre>
<p>Каждый пользователь теперь способен выбирать (SELECT) только те строки из SYSTEMCATALOG, владельцем которых он сам является.</p>
<p><b>ПРЕДСТАВЛЕНИЕ SYSTEMCOLUMNS</b></p>
<p>Одно небольшое добавление к этому позволит каждому пользователю просматривать таблицу SYSTEMCOLUMNS для столбцов из его собственных таблиц.</p>
<p>Сначала давайте рассмотрим ту часть таблицы SYSTEMCOLUMNS, которая описывает наши типовые таблицы (другими словами, исключим сам каталог):</p>
<pre>   tname      cname   datatype  cnumber  tabowner
 -----------  -----   --------  -------  --------

 Salespeople  snum    integer      1      Diane

 Salespeople  sname   char         2      Diane

 Salespeople  city    char         3      Diane

 Salespeople  comm    decimal      4      Diane

 Customers    cnum    integer      1      Claire

 Customers    cname   char         2      Claire

 Customers    city    char         3      Claire

 Customers    rating  integer      4      Claire

 Customers    snum    integer      5      Claire

 Orders       onum    integer      1      Diane

 Orders       odate   date         2      Diane

 Orders       amt     decimal      3      Diane

 Orders       cnum    integer      4      Diane

 Orders       snum    integer      5      Diane</pre>
<p>Как видите, каждая строка этой таблицы показывает столбец таблицы в БД. Все столбцы данной таблицы должны иметь разные имена, так же как каждая таблица должна иметь данного пользователя, и, наконец, все комбинации пользователей, таблиц и имён
столбцов должны различаться между собой.</p>
<p>Следовательно, табличные столбцы: tname (имя таблицы), tabowner 
(владелец таблицы) и cname (имя столбца) вместе составляют первичный ключ этой таблицы. Столбец datatype (тип данных) говорит
сам за себя. Столбец cnumber (номер столбца) указывает на местоположение этого столбца внутри таблицы. Для упрощения мы опустили параметры длины столбца, точности и масштаба.</p>
<p>Для справки показана строка из SYSTFMCATALOG, которая ссылается на эту таблицу:</p>
<pre>tname           owner  numcolumns     type   CO
-------------  ------  -----------    -----  ---

SYSTEMCOLUMNS  System   8             B</pre>
<p>Некоторые SQL-реализации будут обеспечивать вас б&#x0301;ольшим количеством данных, чем показано в этих столбцах, но показанное является основой  любых реализаций.</p>
<p>Для иллюстрации процедуры, предложенной в начале этого раздела, имеется способ, позволяющий каждому пользователю видеть информацию SYSTEMCOLUMNS только 
в принадлежащих ему таблицах:</p>
<pre>          CREATE VIEW Owncolumns
             AS SELECT *
                FROM SYSTEMCOLUMNS
                WHERE tabowner = USER;

          GRANT SELECT ON Owncolumns TO PUBLIC;</pre>
<a name="24.4"></a>
<h3>КОММЕНТАРИЙ В СОДЕРЖАНИИ КАТАЛОГА </h3>
<p>

Большинство версий SQL, позволяют  помещать комментарии (ремарки) в специальные столбцы пояснений таблиц каталогов SYSTEMCATALOG 
и SYSTEMCOLUMNS, что удобно, так как эти таблицы не всегда могут объяснить свое содержание. Для простоты мы пока исключали этот столбец из наших иллюстраций.
Можно использовать команду COMMENT ON со строкой текста, чтобы пояснить любую строку в одной из этих таблиц. Состояние TABLE - для комментирования в SYSTEMCATALOG, 
а текст COLUMN - для SYSTEMCOLUMNS. Например:</p>
<pre>               COMMENT ON TABLE Chris.Orders

                 IS 'Current Customer Orders';</pre>
<p>Текст будет помещен в столбец пояснений SYSTEMCATALOG. Обычно максимальная длина таких пояснений - 254 символа.</p>
<p>Сам комментарий указывается для конкретной строки, один с tname=Orders, а 
другой owner=Chris. Мы увидим этот комментарий в строке  таблицы Заказов в SYSTEMCATALOG:</p>
<pre>         SELECT tname, remarks
            FROM SYSTEMCATALOG
            WHERE tname = 'Orders'
               AND owner = 'Chris';</pre>
<p> Вывод для этого запроса показан на Рисунке 24.2.</p>
<p>SYSTEMCOLUMNS работает точно так же. Сначала мы создаём комментарий</p>
<pre>             COMMENT ON COLUMN Orders.onum
              IS 'Order #';</pre>
<p>затем выбираем эту строку из SYSTEMCOLUMNS:</p>
<pre>           SELECT cnumber, datatype, cname, remarks
              FROM SYSTEMCOLUMNS
              WHERE tname = 'Orders'
                 AND tabowner = 'Chris'
                 AND cname = onum;</pre>
<p>Вывод для этого запроса показан на Рисунке 24.3.</p>
<p>Чтобы изменить комментарий, вы можете просто ввести новую команду COMMENT ON для той же строки. Новый комментарий будет записан 
поверх старого. Если вы хотите удалить комментарий, напишите поверх него пустой комментарий:</p>
<pre>            COMMENT ON COLUMN Orders.onum
               IS '';</pre>
<p>и этот пустой комментарий затрёт предыдущий.</p>
<pre>         ===============  SQL Execution Log ===============
        |                                                  |
        | SELECT tname, remarks                            |
        | FROM  SYSTEMCATALOG                              |
        | WHERE tname = 'Orders'                           |
        | AND owner = 'Chris'                              |
        | ;                                                |
        | ================================================ |
        |   tname          remarks                         |
        | -------------   -----------------------          |
        | Orders          Current Customers Orders         |
        |                                                  |
         ==================================================

	    Рисунок 24.2 Комментарий в SYSTEMCATALOG


         ===============  SQL Execution Log ===============
        |                                                  |
        | SELECT cnumber, datatype, cname, remarks         |
        | FROM  SYSTEMCOLUMNS                              |
        | WHERE tname = 'Orders'                           |
        | AND tabowner = 'Chris'                           |
        | AND cname = 'onum'                               |
        | ;                                                |
        | ================================================ |
        |   cnumber      datatype    cname    remarks      |
        | ----------     ---------   ------  ------------  |
        |          1     integer     onum    Orders #      |
        |                                                  |
         ==================================================

   	   Рисунок 24.3 Комментарий в SYSTEMCOLUMNS</pre>
<a name="24.5"></a>
<h3>ОСТАЛЬНОЕ СОДЕРЖИМОЕ КАТАЛОГА</h3>
<p>

Здесь показаны определения остальных ваших системных таблиц с типовым запросом для каждого:</p>
<a name="24.6"></a>
<h4>SYSTEMINDEXES - ИНДЕКСАЦИЯ В БАЗЕ ДАННЫХ</h4>
<p>

Имена столбцов в таблице SYSTEMINDEXES и их описания:</p>
<pre>СТОЛБЕЦ          ОПИСАНИЕ
-------------    ----------------------------------------------- 

iname 		 Имя индекса (используемое для его исключения)

iowner           Имя пользователя, создавшего индекс

tname            Имя таблицы, которая содержит индекс

cnumber          Номер столбца в таблице

tabowner         Пользователь, который владеет таблицей, содержащей индекс

numcolumns       Число столбцов в индексе

cposition        Позиция текущего столбца среди набора индексов

isunique         Уникален ли индекс (Y или N)</pre>
<p><b><br>
ТИПОВОЙ ЗАПРОС</b> Индекс считается неуникальным, если он вызывает продавца в snum-столбце таблицы Заказчиков:</p>
<pre>SELECT iname, iowner, tname, cnumber, isunique
FROM SYSTEMINDEXES
WHERE iname = 'salesperson';</pre>
<p>Вывод для этого запроса показан на Рисунке 24.4.</p>
<pre> ===============  SQL Execution Log ================
|                                                   |
| SELECT iname, iowner, tname, cnumber, isunique    |
| FROM  SYSTEMINDEXES                               |
| WHERE iname = 'salespeople'                       |
| ;                                                 |
| ================================================= |
|   iname      iowner   tname     cnumber  isunique |
| -----------  ------  ---------- -------  -------- |
| salesperson  Stephan  Customers       5   N       |
|                                                   |
 ===================================================

    Рисунок 24.4 Строка из таблицы SYSTEMINDEXES
</pre>
<a name="24.7"></a>
<h4>SYSTEMUSERAUTH - ПОЛЬЗОВАТЕЛЬСКИЕ И СИСТЕМНЫЕ ПРИВИЛЕГИИ В БАЗЕ ДАННЫХ</h4>
<p>Имена столбцов для SYSTEMUSERAUTH и их описания:</p>
<pre>СТОЛБЕЦ          ОПИСАНИЕ 
--------------   ----------------------------------------------- 

username      	 Идентификатор (ID) доступа пользователя

password   	 Пароль пользователя, вводимый при регистрации

resource   	 Где пользователь имеет права RESOURCE

dba        	 Где пользователь имеет права DBA</pre>
<p>Мы будем использовать простую схему системных привилегий из Главы 22, где были представлены три системные привилегии: CONNECT (ПОДКЛЮЧИТЬ), RESOURCE (РЕСУРСЫ)
и DBA.</p><p>Все пользователи получают CONNECT по умолчанию при регистрации, поэтому она не описана в таблице выше. Возможные состояния столбцов 
resource и dba: Y (Да, пользователь имеет привилегии) или No (Нет, пользователь не имеет привилегий).</p>
<p>Пароли (password) доступны только высокопривилегированным пользователям, если таковые существуют. Следовательно, запрос этой 
таблицы можно вообще делать только для получения информации относительно привилегий системы и пользователей.</p>
<p><b>ТИПОВОЙ ЗАПРОС</b> Чтобы найти всех пользователей, которые имеют привилегию RESOURCE, и увидеть, какие из них - DBA, вы 
можете ввести следующее условие:</p>
<pre> SELECT username, dba
    FROM SYSTEMUSERAUTH
    WHERE resource = 'Y';</pre>
<p>Вывод для этого запроса показан на Рисунке 24.5.</p>
<a name="24.8"></a>
<h4>SYSTEMTABAUTH - ПРИВИЛЕГИИ ОБЪЕКТА, КОТОРЫЕ НЕ ОПРЕДЕЛЯЮТ АВТОРИЗАЦИЮ 
СТОЛБЦА</h4>
<p>

Здесь показаны имена столбцов в таблице SYSTEMTABAUTH 
и их описания:</p>
<pre>СТОЛБЕЦ         ОПИСАНИЕ
------------    --------------------------------------------- 
username      	Пользователь, который имеет привилегии

grantor       	Пользователь, который передает привилегии по имени пользователя

tname         	Имя таблицы, в которой существуют привилегии

owner         	Владелец tname

selauth       	Имеет ли пользователь привилегию SELECT

insauth       	Имеет ли пользователь привилегию INSERT

delauth       	Имеет ли пользователь привилегию DELETE</pre>
<p>Возможные значения  каждой из перечисленных привилегий объекта (имена столбцов которых оканчиваются на auth): Y, N и G.</p>
<p>G указывает, что пользователь имеет привилегию с возможностью передачи привилегий. В каждой строке по крайней мере один из этих 
столбцов должен иметь состояние, отличное от N (другими словами, иметь хоть какую-то привилегию).</p>
<pre> ===============  SQL Execution Log ================
|                                                   |
| SELECT username, dba                              |
| FROM  SYSTEMUSERAUTH                              |
| WHERE resource = 'Y'                              |
| ;                                                 |
| ================================================= |
|   username    dba                                 |
| -----------  ------                               |
|  Diane         N                                  |
|  Adrian        Y                                  |
|                                                   |
===================================================

Рисунок 24.5 Пользователи, имеющие привилегию RESOURCE</pre>
<p>Первые четыре столбца этой таблицы составляют первичный ключ. Это означает что каждая комбинация из tname, владелец-пользователь (не 
забудьте, что две различные таблицы с различными владельцами могут иметь одно и тоже имя), пользователь и пользователь, передающий права (грантор), должна быть уникальной. Каждая строка этой таблицы
содержит все привилегии (которые не являются определённым столбцом), предоставляемые одним определённым пользователем другому
определённому пользователю в конкретном объекте.</p>
<p>UPDATE и REFERENCES, являются привилегиями, которые могут 
быть определёнными столбцами и находиться в различных таблицах каталога. Если пользователь получает привилегии в таблице от более чем одного пользователя, такие привилегии могут быть отдельными строками, созданными в этой таблице. Это необходимо для каскадного отслеживания при вызове привилегий.</p>
<p><b>ТИПОВОЙ ЗАПРОС</b> Чтобы найти все привилегии SELECT, INSERT 
и DELETE, которые Adrian предоставляет пользователям в таблице Заказчиков, вы можете ввести следующее (вывод показан на Рисунке 24.6):</p>
<pre>SELECT username, selauth, insauth, delauth
  FROM SYSTEMTABAUTH
  WHERE grantor = 'Adrian'
     ANDtname = 'Customers';

 ===============  SQL Execution Log ================
|                                                   |
| SELECT username, selauth, insauth, delauth        |
| FROM  SYSTEMTABAUTH                               |
| WHERE grantor = 'Adrian'                          |
| AND tname = 'Customers'                           |
| ;                                                 |
| ================================================= |
|   username   selauth  insauth  delauth            |
| -----------  -------  -------- --------           |
|  Claire      G        Y        N                  |
|  Norman      Y        Y        Y                  |
|                                                   |
===================================================

Рисунок 24.6 Пользователи, получившие привилегии от Adrian 

</pre>
<p>Выше показано, что Adrian предоставил Claire привилегии INSERT и SELECT в таблице Заказчиков, позднее предоставив ей права на передачу привилегий. 
Пользователю Norman он предоставил привилегии SELECT, INSERT и DELETE, но не дал возможность передачи  ни  одной из них. Если Claire 
имела привилегию DELETE в таблице Заказчиков от какого-то другого источника, в этом запросе это показано не будет.</p>
<a name="24.9"></a>
<h4>SYSTEMCOLAUTH - ПРИВИЛЕГИИ ОБЪЕКТА, КОТОРЫЕ ОПРЕДЕЛЯЮТ АВТОРИЗАЦИЮ СТОЛБЦА</h4>
<pre>СТОЛБЕЦ		ОПИСАНИЕ
-------------   -------------------------------------------

username    	Пользователь, который имеет привилегии

grantor     	Пользователь, который предоставляет привилегии другому пользователю 

tname       	Имя таблицы, в которой существуют привилегии

cname       	Имя столбца, в котором существуют привилегии

owner       	Владелец tname

updauth     	Имеет ли пользователь привилегию UPDATE в этом столбце

refauth     	Имеет ли пользователь привилегию REFERENCES в этом столбце</pre>
<p>Столбцы updauth и refauth могут быть в состоянии Y, N или G, но не могут быть одновременно в состоянии N в одной и той же строке. 
Это первые пять столбцов таблицы, которые не составляют первичный ключ. 
Он отличается от первичного ключа SYSTEMTABAUTH, в котором содержится поле cname, указывающее на определенный столбец обсуждаемой таблицы, для которой применяются одна или обе привилегии. Отдельная строка в этой таблице может существовать для каждого столбца в любой данной таблице,
в которой одному пользователю передаются привилегии определенного столбца с помощью другого пользователя.</p>
<p>Как и в случае с SYSTEMTABAUTH, та же привилегия может быть описана в более чем одной строке этой таблицы, если она была передана более чем одним пользователем.</p>
<p><b>ТИПОВОЙ ЗАПРОС</b> Чтобы выяснить, в каких столбцах какой таблицы вы имеете привилегию REFERENCES, вы можете ввести следующий запрос 
(вывод показан на Рисунке 24.7):</p>
<pre>SELECT owner, tname, cname
   FROM SYSTEMCOLAUTH
   WHERE refauth IN ('Y', 'G')
      AND username = USE 
   ORDER BY 1, 2;</pre>
<p>который показывает, что эти две таблицы,  имеющие различных владельцев, но одинаковые имена, в действительности 
- совершенно разные таблицы (т.е. это не  два синонима для одной таблицы).</p>
<pre> ===============  SQL Execution Log ================
|                                                   |
| SELECT OWNER, TNAME, CNAME                        |
| FROM  SYSTEMCOLAUTH                               |
| WHERE refaulth IN ('Y' , 'G' )                    |
| AND username = USER                               |
| ORDER BY 1, 2                                     |
| ;                                                 |
| ================================================= |
|   owner       tname       cname                   |
| -----------  -----------  -------                 |
|  Diane       Customers     cnum                   |
|  Diane       Salespeople   sname                  |
|  Diane       Salespeople   sname                  |
|  Gillan      Customers     cnum                   |
===================================================

Рисунок 24.7 Столбцы, в которых пользователь имеет привилегию INSERT</pre>
<a name="24.10"></a>
<h4>SYSTEMSYNONS - СИНОНИМЫ ДЛЯ ТАБЛИЦ В БАЗЕ ДАННЫХ</h4>
<p>

Это  имена столбцов в таблице SYSTEMSYNONS и их описания:</p>
<pre>СТОЛБЕЦ     	ОПИСАНИЕ 
-------------   -------------------------------------------- 
synonym      	Имя синонима

synowner     	Пользователь, который является владельцем синонима (может быть PUBLIC (ОБЩИЙ))

tname        	Имя таблицы, используемой владельцем

tabowner     	Имя пользователя, который является владельцем таблицы</pre>
<p><b>ТИПОВОЙ ЗАПРОС</b> Предположим, что Adrian имеет синоним Clients для таблицы Заказчиков, принадлежащей Diane, и что имеется 
общий синоним Customers для этой же таблицы. Вы делаете запрос таблицы для всех синонимов в таблице Заказчиков (вывод показан на Рисунке 24.8):</p>
<pre>SELECT *
FROM SYSTEMSYNONS
WHERE tname = 'Customers'


 ===============  SQL Execution Log ================
|                                                   |
| SELECT *                                          |
| FROM  SYSTEMSYNONS                                |
| WHERE tname = 'Customers'                         |
| ;                                                 |
| ================================================= |
| synonym       synowner    tname       tabowner    |
| -----------  -----------  ----------  ----------  |
|  Clients      Adrian      Customers   Diane       |
|  Customers    PUBLIC      Customers   Diane       |
|                                                   |
===================================================

   Рисунок 24.8 Синонимы для таблицы Заказчиков</pre>
<a name="24.11"></a>
<h3>ДРУГОЕ ИСПОЛЬЗОВАНИЕ КАТАЛОГА </h3>
<p>

Конечно, вы можете выполнять более сложные запросы в системном каталоге. 
Объединения, например, могут быть очень удобны.<br>Эта команда позволит вам увидеть столбцы таблиц и базовые индексы, установленные для каждого 
(вывод показан на Рисунке 24.9):</p>
<pre>SELECT a.tname, a.cname, iname, cposition
FROM SYSTEMCOLUMNS a, SYSTEMINDEXES b
WHERE a.tabowner = b. tabowner
   AND a.tname = b.tname
   AND a.cnumber = b.cnumber
ORDER BY 3 DESC, 2;</pre>
<p>Она показывает два индекса: один - для таблицы Заказчиков и один - для таблицы Продавцов.
Последний из них это одностолбцовый индекс с именем salesno в поле snum; он был помещён первым из-за сортировки по убыванию (в обратном 
алфавитном порядке) в столбце iname. Другой индекс, custsale, используется продавцами, чтобы отыскивать своих заказчиков. Он основывается на комбинации полей snum и cnum внутри таблицы Заказчиков с полем snum,
приходящим в индексе первым, как это и показано с помощью поля cposition.</p>
<pre> ===============  SQL Execution Log ================
|                                                   |
| SELECT a.tname, a.cname, iname, cposition         |
| FROM  SYSTEMCOLUMNS a, SYSTEMINDEXES b            |
| WHERE a.tabowner = b.tabowner                     |
| AND a.tname = b.tname                             |
| AND a.cnumber = b.cnumber                         |
| ORDER BY 3 DESC, 2;                               |
|                                                   |
| ================================================= |
|    tname        cname   iname     cposition       |
|   -----------  -------  --------  ------------    |
|   Salespeople   sname   salesno              1    |
|   Customers     cnum    custsale             2    |
|   Customers     snum    custsale             1    |
|                                                   |
 ===================================================

	 Рисунок 24.9 Столбцы и их индексы</pre>
<p>Подзапросы также могут быть использованы. Имеется способ увидеть данные столбца только для столбцов из таблиц каталога:</p>
<pre>SELECT *
FROM SYSTEMCOLUMNS
WHERE tname IN
(SELECT tname
    FROM SYSTEMCATALOG);</pre>
<p>Для упрощения мы не будем показывать вывод этой команды, которая состоит из одного входа для каждого столбца каждой таблицы каталога. Вы могли бы 
поместить этот запрос в представление, назвав его, например, SYSTEMTABCOLS, для представления SYSTEMTABLES.</p>
<a name="24.12"></a>
<h3>РЕЗЮМЕ</h3>
<p>Итак, система SQL использует набор таблиц, называемый системным каталогом, в структуре базы данных. Эти таблицы могут запрашиваться, но 
не модифицироваться. Кроме того, вы можете добавлять комментарии столбцов в (и удалять их из) таблицы SYSTEMCATALOG и SYSTEMCOLUMNS.</p>
<p>Создание представлений в этих таблицах - превосходный способ точно определить, какая пользовательская информация может быть доступной.</p>
<p>Теперь, когда вы узнали о каталоге, вы завершили ваше обучение SQL в диалоговом режиме. <a href="ch25.php">Следующая глава</a> этой книги расскажет вам, как
SQL используется в программах, которые написаны  на других языках, но которые способны извлечь пользу из возможностей SQL, взаимодействуя с его таблицами баз данных.</p>
<a name="24.13"></a>
<h3>РАБОТА СО SQL</h3>
<pre>1. Сделайте запрос каталога, чтобы вывести для каждой таблицы, имеющей
   более чем четыре столбца, имя таблицы, имя владельца, а также 
   имена столбцов и тип данных этих столбцов.

2. Сделайте запрос каталога, чтобы выяснить, сколько синонимов существует
   для каждой таблицы в базе данных. Не забудьте, что один и тот же 
   синоним, принадлежащий двум различным пользователям - это фактически два разных синонима.

3. Выясните, сколько таблиц имеют индексы в более чем пятидесяти процентах их столбцов.

(См. ответы в <a href="a.php#24">Приложении A</a>.)</pre></body></html>
<? include 'foot.php' ?>