<?
include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/user.php';
$set['title']='Учебник XML';
include_once '../../sys/inc/thead.php';
title();
err();
//aut();
?>
<h3 align=center>4. Идентификация типов документов (DTD)</h3>
<p align=justify>В XML- документах DTD определяет набор действительных элементов, идентифицирует элементы, которые могут находиться в других элементах, и определяет действительные атрибуты для каждого из них. Синтаксис DTD  весьма своеобразен и от автора-разработчика требуются  дополнительные усилия при создании таких документов(сложность DTD является одной из причин того, что использование SGML, требующего определение DTD для любого документа, не получило столь широкого распространения как, например, phpL).  Как уже отмечалось, в XML использовать DTD не обязательно -  документы, созданные без этих правил, будут правильно обрабатываться программой-анализатором, если они удовлетворяют основным требованиям синтаксиса XML. Однако контроль за типами элементов и корректностью отношений между ними в этом случае будет полностью возлагаться на автора документа. До тех пор, пока грамматика нашего нового языка не описана, его сможем использовать только мы, и для этого мы будем вынуждены применять специально разработанное программное обеспечение, а не универсальные программы-анализаторы.. 
</p>
<p align=justify>В DTD для XML используются следующие типы правил: правила для элементов и их атрибутов, описания категорий(макроопределений), описание форматов бинарных данных. Все они описывают основные конструкции языка - элементы, атрибуты, символьные константы внешние файлы бинарных данных.
</p>
<p align=justify>Для того, чтобы использовать DTD в нашем документе, мы можем или описать его во внешнем  файле и при описании DTD просто указать ссылку на этот файл или же непосредственно внутри самого документа выделить область, в которой определить нужные правила. В первом случае в документе указывается имя файла, содержащего DTD- описания:
</p>
<pre>
&lt;?xml version="1.0" standalone="yes" ?&gt;
&lt;! DOCTYPE journal SYSTEM "journal.dtd"&gt;
...
</pre>
<p align=justify>Внутри же документа DTD- декларации включаются следующим образом:
</p>
<pre>
...
&lt;! DOCTYPE journal [
&lt;!ELEMENT journal (contacts, issues, authors)&gt;
...
]&gt;
...
</pre>
<p align=justify>В том случае, если используются одновременно внутренние и внешние описания, то программой-анализатором будут сначала  рассматриваться внутренние, т.е. их приоритет выше. При проверке документа XML- процессор в первую очередь ищет DTD внутри документа. Если правила внутри документа не определены и не задан атрибут <i>standalone ="yes" </i>, то программа загрузит указанный внешний файл и правила, находящиеся в нем, будут считаны оттуда. Если же атрибут <i>standalone  </i>имеет значение <i>"yes</i>", </i>то использование внешних DTD описаний будет запрещено.
</p>
<h4>Определение элемента
</h4>
<p align=justify></b>Элемент в DTD определяется с помощью дескриптора !<b>ELEMENT</b>, в котором указывается название элемента и структура его содержимого. 
</p>
<p align=justify>Например,  для элемента &lt;flower&gt; можно определить следующее правило:
</p>
<pre>
&lt;!ELEMENT flower  PCDATA&gt;
</pre>
<p align=justify>Ключевое слово ELEMENT указывает, что данной инструкцией будет описываться элемент XML. Внутри этой инструкции задается название элемента(flower) и тип его содержимого. 
</p>
<p align=justify>В определении элемента мы указываем сначала название элемента(flower), а затем его модель содержимого - определяем, какие другие элементы или типы данных могут встречаться внутри него. В данном случае содержимое элемента flower будет определяться при помощи специального маркера PCDATA( что означает parseable character  data - любая информация, с которой может работать программа-анализатор). Существует еще две инструкции, определяющие тип содержимого: EMPTY,ANY. Первая указывает на то, что элемент должен быть пустым(например, &lt;red/&gt;), вторая  - на то, что содержимое элемента специально не описывается.
</p>
<p align=justify>Последовательность дочерних для текущего элемента объектов задается в виде списка разделенных запятыми названий элементов. При этом для того, чтобы указать количество повторений включений этих элементов могут использоваться символы +,*, ? :
</p>
<pre>
&lt;!ELEMENT issue (title, author+, table-of-contents?)&gt;
</pre>
<p align=justify>В этом примере указывается, что внутри элемента &lt;issue&gt; должны быть определены элементы title, author и table-of-contents, причем элемент title является обязательным элементом и может встречаться лишь однажды, элемент author может встречаться несколько раз, а элемент table-of-contents является опциональным, т.е. может отсутствовать. В том случае, если существует несколько возможных вариантов содержимого определяемого элемента, их следует разделять при помощи символа "|" :
</p>
<pre>
&lt;!ELEMENT flower (PCDATA | title )*&gt;
</pre>
<p align=justify>Символ * в этом примере указывает на то, что определяемая последовательность внутренних элементов может быть повторена несколько раз или же совсем не использоваться. 
</p>
<p align=justify>Если в определении элемента указывается "смешанное" содержимое, т.е. текстовые данные или набор элементов, то необходимо сначала указать PCDATA, а затем разделенный символом "|" список элементов. 
</p>
<p align=justify>Пример корректного XML- документа:
</p>
<pre>
&lt;?xml version="1.0"?&gt;
&lt;! DOCTYPE journal [
&lt;!ELEMENT contacts (address, tel+, email?)&gt;
&lt;!ELEMENT address (street, appt)&gt;
&lt;!ELEMENT street PCDATA&gt;
&lt;!ELEMENT appt (PCDATA | EMPTY)*&gt;
&lt;!ELEMENT tel PCDATA&gt;
&lt;!ELEMENT email PCDATA&gt;
]&gt;
...
&lt;contacts&gt;
&lt;address&gt;
&lt;street&gt;Marks avenue&lt;/street&gt;
&lt;appt id="4"&gt;
&lt;/address&gt;
&lt;tel&gt;12-12-12&lt;/tel&gt;
&lt;tel&gt;46-23-62&lt;/tel&gt;
&lt;email&gt;info@j.com&lt;/email&gt;
&lt;/contacts&gt;
</pre>
<h4>Определение атрибутов</h4>
<p align=justify>Списки атрибутов элемента определяются с помощью ключевого слова !<b>ATTLIST</b>. Внутри него задаются названия атрибутов, типы их значений и дополнительные параметры. Например, для элемента &lt;article&gt; могут быть определены следующие атрибуты:
</p>
<pre>
&lt;!ATTLIST article
id ID #REQUIRED
about CDATA #IMPLIED
type (actual | review | teach )  'actual' ''
&gt;
</pre>
<p align=justify>В данном примере для элемента <i>article </i>определяются три атрибута: <i>id, about </i>и <i>type</i>, которые имеют типы ID(идентификатор), CDATA и список возможных значений соответственно. Всего существует шесть возможных типов значений атрибута:
</p>
<UL>
<LI>CDATA - содержимым документа могут быть любые символьные данные
<LI>ID - определяет уникальный идентификатор элемента в документе
<LI>IDREF( IDREFS )- указывает, что значением атрибута должно выступать название(или несколько таких названий, разделенных пробелами во втором случае) уникального идентификатора определенного в этом документе элемента
<LI>ENTITY( ENTITIES) - значение атрибута должно быть названием(или списком названий, если используется ENTITIES) компонента (макроопределения), определенного в документе 
<LI>NMTOKEN (NMTOKENS) - содержимым элемента может быть только одно отдельное слово(т.е. этот параметр является ограниченным вариантом CDATA)
<LI>Список допустимых значений - определяется список значений, которые может иметь данный атрибут.
</UL>
<p align=justify>Также в определении атрибута можно использовать следующие параметры:
</p>
<UL>
<LI>#REQUIRED - определяет обязательный атрибут, который должен быть задан во всех элементах данного типа 
<LI>#IMPLIED - атрибут не является обязательным
<LI>#FIXED "значение" - указывает, что атрибут должен иметь только указанное значение, однако само определение атрибута не является обязательным, но в процессе разбора его значение в любом случае будет передано программе-анализатору 
<LI>Значение - задает значение атрибута по умолчанию
</UL>
<h4>Определение компонентов(макроопределений)</h4>
<p align=justify>Компонент (entity) представляет собой определения, содержимое которых может быть повторно использовано в документе . В других языках программирования подобные элементы называются макроопределениями. Создаются DTD- компоненты при помощи инструкции !ENTITY:
</p>
<pre>
&lt;!ENTITY hello ' Мы рады приветствовать Вас!' &gt;
</pre>
<p align=justify>Программа-анализатор, просматривая в первую очередь содержимое области DTD- определений, обработает эту инструкцию и при дальнейшем разборе документа будет использовать содержимое DTD- компонента в том месте, где будет встречаться его название. Т.е. теперь в документе мы можем использовать выражение &hello; , которое будет заменено на строчку <i>"Мы рады приветствовать Вас"</i>
</p>
<p align=justify>В общем случае, внутри DTD можно задать три типа макроопределений:
</p>
<p align=justify><b>Внутренние макроопределения </b>- предназначены для определения строковой константы, с их помощью можно организовывать ссылки на часто изменяемую информацию, делая документ более читабельным. Внутренние компоненты включаются в документ при помощи амперсанта &
</p>
<p align=justify>В XML существует пять предустановленных внутренних символьных констант:
<ul>
<li>&amplt; - символ "&lt;"
<li>&ampgt; - символ "&gt;"
<li>&ampamp; - символ "&amp"
<li>&ampapos; - символ апострофа "&apos;"
<li>&ampquot; - символ двойной кавычки "&quot;"
</ul>
<p align=justify><b>Внешние макроопределения </b>- указывают на содержимое внешнего файла, причем этим содержимым могут быть как текстовые, так и двоичные данные. В первом случае в месте использования макроса будут вставлены текстовые строки, во втором - бинарные данные, которые анализатором не рассматриваются и используются внешними программами
</p>
<pre>
&lt;!ENTITY logotype SYSTEM "/image.gif" NDATA GIF87A&gt;
</pre>
<p align=justify><b>Макроопределения правил </b>- макроопределения параметров могут использоваться только внутри области DTD и обозначаются специальным символом %, вставляемым перед названием макроса. При этом содержимое компонента будет помещено непосредственно в текст DTD- правила
</p>
<p align=justify>Например, для следующего фрагмента документа:
</p>
<pre>
&lt;!ELEMENT name (PCDATA)&gt;
&lt;!ELEMENT title (PCDATA | name)*&gt;
&lt;!ELEMENT author (PCDATA | name)*&gt;
&lt;!ELEMENT article (title, author)*&gt;
&lt;!ELEMENT book (title, author)*&gt;
&lt;!ELEMENT bookstore (book | article)*&gt;
&lt;!ELEMENT bookshelf (book | article)*&gt;
</pre>
<p align=justify>можно использовать более короткую форму записи:
</p>
<pre>
&lt;!ELEMENT name (PCDATA)&gt;
&lt;! ENTITY %names 'PCDATA | name'&gt;
&lt;!ELEMENT article (%names;)*&gt;
&lt;!ELEMENT book (%names;)*&gt;
&lt;!ENTITY %content 'book | article'&gt;
&lt;!ELEMENT bookstore (%content;)*&gt;
&lt;!ELEMENT bookshelf (%content;)*&gt;
</pre>
<p align=justify>Макроопределения часто используются для описания параметров в правилах атрибутов. В этом случае  появляется возможность использовать одинаковые определения атрибутов для различных элементов:
</p>
<pre>
&lt;!ENTITY %itemattr 'id ID #IMPLIED src CDATA'&gt;
&lt;!ENTITY %bookattr "ISDN ID #IMPLIED type CDATA'&gt;
&lt;!ENTITY %artattr " size CDATA'&gt;
&lt;!ELEMENT book (title, author,content)*&gt;
&lt;!ATTLIST book %itemattr  %bookattr;&gt;
&lt;!ELEMENT article (title, author, content)*&gt;
&lt;!ATTLIST article %itemattr  %artattr;&gt;
</pre>
<h4>Типизация данных</h4>
<p align=justify>Довольно часто при создании XML- элемента разработчику требуется определить, данные какого типа могут использоваться в качестве его содержимого. Т.е. если мы определяем элемент &lt;last-modified&gt;10.10.98&lt;/last-modified&gt;,  то хотим быть уверенными, что в документе в этом месте будет находиться строка, представляющая собой дату, а не число или произвольную последовательность символов. Используя типизацию данных, можно создавать элементы, значения которых могут  использоваться, например, в качестве параметров SQL- запросов. Программа клиент в этом случае должна знать, к какому типу данных относится текущее значение элемента и в случае соответствия  формирует SQL-запрос.
</p>
<p align=justify>Если  в качестве программы на стороне клиента используется верифицирующий XML-процессор, то информацию о типе можно передавать при помощи специально созданного для этого атрибута элемента, имеющего соответствующее DTD- определение. В процессе разбора программа-анализатор передаст значение этого атрибута клиентскому приложению, которое сможет использовать эту информацию должным образом. Например, чтобы указать, что содержимое элемента должно быть длинным целым, можно использовать следующее DTD- определение:
</p>
<pre>
&lt;!ELEMENT counter (PCDATA)&gt;
&lt;!ATTLIST counter data_long CDATA #FIXED "LONG"&gt;
</pre>
<p align=justify>Задав атрибуту значение по умолчанию LONG и определив его как FIXED, мы позволили тем самым программе-клиенту получить необходимую информацию о типе содержимого данного элемента, и теперь она может самостоятельно определить соответствие типа этого содержимого указанному в DTD- определении . 
</p>
<p align=justify>Вот пример XML- документа, в котором определяются и используются несколько элементов с различными типами данных:
</p>
<pre>
&lt;!ELEMENT price (PCDATA)&gt;
&lt;!ATTLIST price data_currency CDATA #FIXED "CURRENCY"&gt;
&lt;!ELEMENT rooms_num (PCDATA)&gt;
&lt;!ATTLIST rooms_num data_byte CDATA #FIXED "BYTE"&gt;
&lt;!ELEMENT floor (PCDATA)&gt;
&lt;!ATTLIST floor data_byte CDATA #FIXED "INTEGER"&gt;
&lt;!ELEMENT living_space (PCDATA)&gt;
&lt;!ATTLIST living_space data_float CDATA #FIXED "FLOAT"&gt;
&lt;!ELEMENT counter (PCDATA)&gt;
&lt;!ATTLIST counter data_long CDATA #FIXED "LONG"&gt;
&lt;!ELEMENT is_tel (PCDATA)&gt;
&lt;!ATTLIST is_tel data_bool CDATA #FIXED "BOOL"&gt;
&lt;!ELEMENT house (rooms_num, floor,living_space, is_tel, counter, price)&gt;
&lt;!ATTLIST house id ID  #REQUIED&gt;
...
&lt;house id="0"&gt;
&lt;rooms_num&gt;5&lt;/rooms_num&gt;
&lt;floor&gt;2&lt;/floor&gt;
&lt;living_space&gt;32.5&lt;/living_space&gt;
&lt;is_tel&gt;true&lt;/is_tel&gt;
&lt;counter&gt;18346&lt;/counter&gt;
&lt;price&gt;34 р. 28 к.&lt;/price&gt;
&lt;/house&gt;
...
</pre>
<p align=justify>Как видно из примера, механизм создания элементов документа при этом нисколько не изменился. Все необходимая для проверки типов данных информация заложена в определения элементов внутри блока DTD.
</p>
<p align=justify>В заключении хотелось бы отметить, что DTD предоставляет нам весьма удобный механизм осуществления контроля за содержимым документа. На сегодняшний день, практически все программы просмотра документов Интернет используют DTD-правила. Однако это далеко не единственный способ проверки корректности документа. В настоящий момент в W3 консорциуме находится на рассмотрении новый стандарт языка описания структуры документов, называемый схемами данных. Следующий раздел посвящен работе с ними.
</p>
<p><center><p>
<font size=-1>
<a href="PART3.php">Назад</a> | <a href="index.php">Содержание</a> | <a href="PART5.php">Вперед</a></font></center></p>
</body></html>
<?
include_once '../../sys/inc/tfoot.php';
?>