<?php

class Module extends \bff\base\Module
{
    /**
     * Включена ли фильтрация по региону в модуле (в подразделе модуля)
     */
    public function regionsFilterEnabled()
    {
        # фильтрация выключена в системных настройках
        if (!Geo::regionsFilter()) {
            return false;
        }
        # мобильная версия
        if (bff::isMobile()) {
            return false;
        }
        # текущий город не указан
        if (!bff::adminPanel() && !Geo::cityID()) {
            return false;
        }
        # настройка фильтрации в текущем модуле (в подразделе модуля, если указан)
        $nConfig = (int)config::get('rf_'.$this->module_name, 0);
        return ($nConfig === 1);
    }

    public function showDemoLimited()
    {
        if (\Request::isAJAX()) $this->ajaxResponse(Errors::DEMO_LIMITED);

        return $this->showError(Errors::DEMO_LIMITED);
    }

    public function showForbidden($sTitle = '', $mMessage = '', $bAuth = false)
    {
        if (is_integer($mMessage)) $mMessage = $this->errors->getSystemMessage($mMessage);
        bff::setMeta($sTitle);
        return $this->errors->messageForbidden($sTitle, $mMessage, $bAuth);
    }

    /**
     * Формирование базового URL
     * @param string $languageKey ключ языка
     * @param boolean $dynamic динамическая ссылка
     * @param array $subdomains поддомены
     * @return string
     */
    public static function urlBase($languageKey = LNG, $dynamic = false, array $subdomains = array())
    {
        static $modules = array(
            'afisha' => 'afisha',
            'auto'   => 'auto',
            'bbs'    => 'board',
            'items'  => 'map',
            'job'    => 'job',
            'realty' => 'realty',
            'business' => 'business',
        );

        # подставляем регион в URL
        if ( ! static::i()->regionsFilterEnabled() && static::i()->module_name!=='geo') {
            if (isset($subdomains['city'])) {
                unset($subdomains['city']);
            }
        } else {
            if ( ! isset($subdomains['city'])) {
                $subdomains['city'] = Geo::cityID();
            }
        }
        if (isset($subdomains['city']))
        {
            if (Geo::urlType() == Geo::URL_SUBDOMAIN && ! empty($subdomains['city'])) {
                $city = ( is_array($subdomains['city']) ? $subdomains['city'] : Geo::regionData($subdomains['city']) );
                if ( ! empty($city['keyword'])) {
                    $subdomains['city'] = $city['keyword'];
                } else {
                    unset($subdomains['city']);
                }
            } else {
                unset($subdomains['city']);
            }
        }

        # особенности URL для некоторых модулей
        $moduleName = static::i()->module_name;
        $urlPostfix = '';
        if (isset($modules[$moduleName])) {
            if (bff::subdomainsEnabled($moduleName)) {
                # поддомен модуля
                $subdomains[] = $modules[$moduleName];
            } else {
                # подраздел модуля
                $urlPostfix = '/'.$modules[$moduleName];
            }
        }

        # формируем URL
        $subdomains = ( ! empty($subdomains) ? join('.', $subdomains) . '.' : '' );

        if ($dynamic) return '//'.$subdomains.'{sitehost}'.$urlPostfix;

        return Request::scheme() . '://' . $subdomains .
            (bff::isMobile() ? config::sys('site.mobile.host') : SITEHOST) .
            bff::locale()->getLanguageUrlPrefix($languageKey, false).$urlPostfix;
    }
}