<?php
# paths
if( ! defined('DS') ) {
    define('DS', DIRECTORY_SEPARATOR);
}

require 'paths.php';
require PATH_CORE.'init.php';


# user enotify
define('USERS_ENOTIFY_NEWS', 1); # подписка на получение новостей от сервиса

class bff extends \bff\base\app
{
    public static $userSettings = 0;

    public function init()
    {
        self::autoloadEx(array(
            # переопределяем базовые компоненты
            'View' => array('app', 'app/view.php')
        ));

        # Инициализируем base\app
        parent::init();

        if (static::cron()) {
            return;
        }

        # Yandex Карты 2.1
        Geo::$ymapsCoordOrder = 'latlong';
        Geo::$ymapsDefaultCoords = config::sys('geo.maps.default.coords', '55.7481,37.6206');
        Geo::$ymapsJS = 'http://api-maps.yandex.ru/2.1/?lang=ru_RU&onerror=onYMapError';

        # подключаем Javascript + CSS
        tpl::includeJS(array('jquery', 'bff'), true);
        if( ! bff::adminPanel() )
        {
            # для фронтенда:
            tpl::includeJS(array('app'), false, 6);
            tpl::includeCSS(array('custom'));
            js::setDefaultPosition(js::POS_FOOT); # переносим все инициализируемые inline-скрипты в footer
            bff::$userSettings = bff::input()->cookie(config::sys('cookie.prefix').'usett');
        } else {
            # для админки:
            tpl::includeJS(array('bootstrap2.min'), false);
            tpl::includeJS(array('admin/bff', 'fancybox'), true);
        }

        if (($userID = User::id())) {
            # актуализируем "Время последней активности"
            if( ( BFF_NOW - func::SESSION('last_activity', 0) ) >= config::sys('users.activity.timeout') )
            {
                Users::model()->userSave($userID, false, array('last_activity'=>static::database()->now()));
                func::setSESSION('last_activity', BFF_NOW);
            }
            # актуализируем счетчики
            static::security()->userCounter(null);
        }

        # отображаем правый баннер, по-умочанию
        static::showRightblockBanner(true);
    }



    public static function isIndex()
    {
        return (self::$event == 'index' && self::$class == 'site');
    }

    public static function setActiveMenu($sPath, $bSubHoverOnly = false, $bUpdateMeta = true)
    {
        $mActiveStateData = ( $bSubHoverOnly ? 2 : 1 );
        $sPath = str_replace('//', '/main/', $sPath);
        return Sitemap::i()->setActiveMenuByPath($sPath, $mActiveStateData, $bUpdateMeta);
    }

    /**
     * Конвертация цены в цену для поиска (по курсу)
     * @param integer $nPrice цена
     * @param integer $nPriceCurrencyID ID валюты, в которой указана цена
     * @return float
     */
    public static function convertPriceForSearch($nPrice, $nPriceCurrencyID)
    {
        if($nPriceCurrencyID == config::sys('currency.default') # цена уже указана в валюте по-умолчанию
            || ! $nPriceCurrencyID # валюта не указана (считаем что цена указана в валюте по-умолчанию)
            || ! $nPrice) { # цена == 0
            return $nPrice;
        }

        $curr = Site::i()->currencyData($nPriceCurrencyID, false);
        if (empty($curr)) {
            return $nPrice;
        }

        return round($nPrice * $curr['rate']);
    }

    public static function setRightblock($sHTML = '', $bAfterBanner = true)
    {
        config::set('rightblock_'.($bAfterBanner ? 'after' : 'before'), $sHTML);
    }

    public static function showRightblockBanner($bShow = true)
    {
        config::set('tpl_rightblock_banner', ($bShow ? 1 : 0) );
    }

    public static function showInstruction($sKey)
    {
        config::set('rightblock_instr', config::instruction($sKey));
    }

    public static function urlAjax($sModule, $sActionQuery)
    {
        return '/index.php?bff=ajax&s='.$sModule.'&act='.$sActionQuery;
    }

    public static function urlItem($data)
    {
        return Items::url('view', $data);
    }

    public static function urlBaseMobile($trailingSlash = true, $languageKey = LNG)
    {
        return Request::scheme().'://'.config::sys('site.mobile.host').static::locale()->getLanguageUrlPrefix($languageKey, $trailingSlash);
    }

    public static function urlAway($sURL)
    {
        $sURL = str_replace(array('http://','https://', 'ftp://'),'', $sURL);
        if( empty($sURL) || $sURL == '/' ) return bff::urlBase();
        return bff::urlBase().'away/?url='.rawurlencode($sURL);
    }

    /**
     * Используется ли фоновое изображение на сайте
     * @param null|boolean $enabled true/false - изменить, null - получить текущее значение
     * @param array $settings настройки фонового изображения
     * @return boolean
     */
    public static function backgroundSettings($enabled = null, array $settings = array())
    {
        static $state = array(
            'color' => '#fff', 'image' => false, 'style'=>'',
            'enabled' => false,
        );
        if (is_bool($enabled)) {
            $state = $settings;
            $state['enabled'] = $enabled;
        } else {
            if ($state['image']) {
                $state['style'] = 'background: '.$state['color'].' url('.$state['image-url'].') top center no-repeat; ';
                if ( ! empty($state['fixed'])) {
                    $state['style'] .= ' background-attachment: fixed;';
                }
            } else {
                $state['style'] = 'background-color: '.$state['color'].';';
            }
        }
        return $state;
    }

    public static function subdomainsEnabled($module = false)
    {

        return config::sys('subdomains', false);
    }

    public static function servicesEnabled()
    {
        if (bff::adminPanel()) {
            return bff::moduleExists('svc', false);
        } else {
            return config::sys('services.enabled', false) && bff::moduleExists('svc', false);
        }
    }

}

bff::i()->init();