<?php

/**
 * Компонент управляющий загрузкой / удалением нескольких изображений
 * @version 0.471
 * @modified 21.apr.2014
 */

class CImagesUploader extends Component
{
    /** @var integer ID записи */
    protected $recordID = 0;

    /** @var string Путь к изображениям */
    protected $path = '';
    /** @var string Путь ко временным изображениям */
    protected $pathTmp = '';
    /** @var string URL к изображениям */
    protected $url = '';
    /** @var string URL ко временным изображениям */
    protected $urlTmp = '';
    /** @var boolean сообщать об ошибках */
    protected $assignErrors = true;

    /**
     * Максимально допустимый размер файла изображения
     * @example: 5242880 - 5мб, 4194304 - 4мб, 3145728 - 3мб, 2097152 - 2мб
     */
    protected $maxSize = 4194304;

    /**
     * Минимально допустимый размер изображения по ширине/высоте
     * @vars integer
     */
    protected $minWidth = 0; // ширина (0 - не выполнять проверку)
    protected $minHeight = 0; // высота (0 - не выполнять проверку)

    /**
     * Максимально допустимый размер изображения по ширине/высоте
     * @vars integer
     */
    protected $maxWidth = 0; // ширина (0 - не выполнять проверку)
    protected $maxHeight = 0; // высота (0 - не выполнять проверку)

    /**
     * Размеры изображений
     * ! Порядок перечисления: от меньшего к большему (по размеру изображения)
     * @var array
     * @example array(
     *      key => array(
     *          'o'=> boolean сохранять ли в оригинальных размерах,
     *          'width'=> integer ширина,
     *          'height'=> integer высота,
     *          'vertical'=> настройки для вертикального изображения
     *              'width'=> integer ширина,
     *              'height'=> integer высота,
     *          ... парамметры для Thumbnail
     *      ), ...
     * )
     */
    protected $sizes = array();

    /**
     * Размеры tmp-изображений
     * Массив префиксов размеров, в которых следует сохранять изображение при tmp-загрузке
     * ! Порядок перечисления: от меньшего к большему (по размеру изображения)
     * @var array
     */
    protected $sizesTmp = array();

    /**
     * Кол-во символов в генерируемой части названия сохранямого файла
     * @var integer
     */
    protected $filenameLetters = 6;

    /**
     * Допустимые расширения файлов
     * Обязательно указывать 'jpg' и 'jpeg'
     * @var array
     */
    protected $extensionsAllowed = array('jpg', 'jpeg', 'gif', 'png');

    /**
     * Качество изображения (1-100)
     * @var integer
     */
    protected $quality = 90;

    /**
     * Раскладывать ли файлы в зависимости от recordID, по папкам folder = (recordID / 1000)
     * @var boolean
     */
    protected $folderByID = false;

    public function __construct($nRecordID = 0)
    {
    }

    public function setRecordID($nRecordID)
    {
    }

    /**
     * Загрузка(сохранение/обновление) изображения, методом $_FILES
     * @param string $sInputName input file name
     * @return array информация об успешно загруженном файле изображения (@see save) или FALSE в случае ошибки
     */
    public function uploadFILES($sInputName)
    {
    }

    /**
     * Загрузка(сохранение/обновление) изображения при помощи QQ-загрузчика
     * @return array информация об успешно загруженном файле изображения (@see save) или FALSE в случае ошибки
     */
    public function uploadQQ()
    {
    }

    /**
     * Загрузка(сохранение/обновление) изображения через компонент SWFUploader
     * @return array информация об успешно загруженном файле изображения (@see save) или FALSE в случае ошибки
     */
    public function uploadSWF()
    {
    }

    /**
     * Загрузка(сохранение/обновление) изображения по URL ссылке
     * @param string $sURL ссылка на изображение
     * @return array информация об успешно загруженном файле изображения (@see save) или FALSE в случае ошибки
     */
    public function uploadURL($sURL)
    {
    }

    /**
     * Переносим tmp-изображения в постоянную папку
     * @param string|array $mFieldname ключ в массиве $_POST, тип TYPE_ARRAY_STR или filename-массив
     * @param boolean $bEdit используем при редактировании записи
     * @param array $aParams параметры (
     *      deleteSizes => список префиксов размеров, которые следует удалить
     *    )
     * @return boolean
     */
    public function saveTmp($mFieldname = 'img', $bEdit = false, $aParams = array())
    {
    }

    /**
     * Удаление tmp изображения(-й)
     * @param string|array $mFilename имя файла (нескольких файлов)
     * @return boolean
     */
    public function deleteTmpFile($mFilename)
    {
    }

    /**
     * Удаление файлов изображения (всех размеров)
     * @param array $aImage информация о файле изображения: filename[, dir, srv]
     * @param boolean $bTmp tmp-изображение
     * @return boolean
     */
    public function deleteFile($aImage, $bTmp = false)
    {
    }

    /**
     * Устанавливаем минимально/максимально допустимые размеры изображения по ширине/высоте
     * @param integer $nMinWidth минимально допустимая ширина
     * @param integer $nMinHeight минимально допустимая высота
     * @param integer $nMaxWidth максимально допустимая ширина
     * @param integer $nMaxHeight максимально допустимая высота
     */
    public function setDimensions($nMinWidth = 0, $nMinHeight = 0, $nMaxWidth = 0, $nMaxHeight = 0)
    {
    }

    /**
     * Получаем параметры изображения
     * @param array $aImage : @see return::save
     * @param string|array $sSize префикс размера или массив префиксов размеров
     * @param boolean $bTmp tmp-изображение
     * @return array
     */
    public function getImageParams($aImage, $aSizes, $bTmp = false)
    {
    }

    /**
     * Сообщать об ошибках
     * @param boolean $bAssign
     */
    public function setAssignErrors($bAssign)
    {
    }

    public function setFolderByID($bFolderByID)
    {
    }

    /**
     * Устанавливаем пути к изображениям
     * @param string $sPath постоянный путь
     * @param string $sPathTmp временный путь
     */
    public function setPath($sPath, $sPathTmp)
    {
    }

    /**
     * Формирование URL изображения
     * @param array $aImage : filename - название файла gen(N).ext, dir - # папки, srv - ID сервера
     * @param string|array $mSize префикс размера или массив префиксов размеров
     * @param boolean $bTmp tmp-изображение
     * @return string|array URL
     */
    public function getURL($aImage, $mSize, $bTmp = false)
    {
    }

    /**
     * Устанавливаем URL к изображениям
     * @param string $sURL постоянный URL
     * @param string $sURLTmp временный URL
     */
    public function setURL($sURL, $sURLTmp)
    {
    }

    /**
     * Формирование URL изображения (быстрый вызов)
     * @param integer $nRecordID ID записи
     * @param array $aImage : filename - название файла gen(N).ext, dir - # папки, srv - ID сервера
     * @param string $sSizePrefix префикс размера
     * @param boolean $bTmp tmp-изображение
     * @return string URL
     */
    public static function url($nRecordID, $aImage, $sSizePrefix, $bTmp = false)
    {
    }

    /**
     * Устанавливаем размеры
     * @param array $aSizes
     * @param array $aSizesTmp
     */
    public function setSizes($aSizes = array(), $aSizesTmp = array())
    {
    }

    /**
     * Получаем ширину изображения для необходимого размера
     * @param string $sSizePrefix префикс размера
     * @return integer ширина
     */
    public function getSizeWidth($sSizePrefix)
    {
    }

    /**
     * Получаем высоту изображения для необходимого размера
     * @param string $sSizePrefix префикс размера
     * @return integer высота
     */
    public function getSizeHeight($sSizePrefix)
    {
    }

    /**
     * Получение максимально допустимого размера файла
     * @param boolean $bFormat применить форматирование
     * @param boolean $bFormatExtTitle полное название объема данных (при форматировании)
     * @return mixed
     */
    public function getMaxSize($bFormat = false, $bFormatExtTitle = false)
    {
    }

    /**
     * Устанавливаем максимально допустимый размер
     * @param integer $nMaxSize размер в байтах
     */
    public function setMaxSize($nMaxSize)
    {
    }

}