<?php

/**
 * @ignore
 */
if (!defined('IN_PHPBB'))
{
	exit;
}

/**
 * Название пользовательской сессии BFF
 */
define('BFF_USER_SESSION_COOKIENAME', 'bffssu');
define('BFF_LOGFILE_PATH', false);

/**
 * Возвращает информацию о текущем пользователе BFF
 * @return array
 */
function BFF_USER()
{
    $sess_data = array();
    if( isset($_COOKIE[ BFF_USER_SESSION_COOKIENAME ]) ) {
        $sess_id = session_id();
        if( empty($sess_id) ) {
            session_name( BFF_USER_SESSION_COOKIENAME );
            session_start();
        }
        if( ! empty($_SESSION['BFF']['USER']) ) {
            $data = unserialize($_SESSION['BFF']['USER']);
            if( empty($data) ) return array();
            $sess_data['admin'] = ! empty($data['admin']);
            $sess_data['login'] = ( isset($data['login']) ? $data['login'] : false );
            $sess_data['pass']  = ( isset($data['password']) ? $data['password'] : false );
            $sess_data['email'] = ( isset($data['email']) ? $data['email'] : false );
            $sess_data['fio']   = ( isset($data['name']) ? $data['name'] : false );
        }
    }

    return $sess_data;
}

function BFF_LOG($sMessage, $nLine, $sFunction)
{
    $logFile = BFF_LOGFILE_PATH; if( empty($logFile) ) return;

    static $lastFunc;
    if( $lastFunc != $sFunction && $sFunction != 'BFF_USER' ) {
        error_log( " ------------------------------------ ".PHP_EOL, 3, $logFile );
        $lastFunc = $sFunction;
    }
    error_log( @gmdate('Y/m/d H:i:s',microtime(true))." {$sFunction}[:$nLine]: $sMessage".PHP_EOL, 3, $logFile );
}

/**
 * Проверяем авторизацию при установке данного способа авторизации
 * @return boolean|string
 */
function init_bff()
{
    # выполняем проверку совпадения текущего пользователя и администратора форума
	global $user;
    $auth = BFF_USER();

	if(empty($auth) || empty($auth['admin']) || $user->data['username'] !== $auth['login'])
	{
	    return 'Логин текущего пользователя основного сайта'.( ! empty($auth['login']) ? ' ('.$auth['login'].')':'').' должен совпадать с логином администратора в phpBB ('.$user->data['username'].').';
	}
	return false;
}

/**
 * Авторизация
 * @param string $username @ref имя пользователя (логин)
 * @param string $password @ref пароль пользователя
 * @return array
 */
function login_bff(&$username, &$password)
{
	global $db;
	BFF_LOG("begin: name = '$username', pass = '$password'", __LINE__, __FUNCTION__);
	$auth = BFF_USER();

	// не разрешаем пустой пароль
	if( ! $password)
	{
		return array(
			'status'	=> LOGIN_ERROR_PASSWORD,
			'error_msg'	=> 'NO_PASSWORD_SUPPLIED',
			'user_row'	=> array('user_id' => ANONYMOUS),
		);
	}

	// не разрешаем пустой логин / email
	if( ! $username)
	{
		return array(
			'status'	=> LOGIN_ERROR_USERNAME,
			'error_msg'	=> 'LOGIN_ERROR_USERNAME',
			'user_row'	=> array('user_id' => ANONYMOUS),
		);
	}

	if(empty($auth['login']))
	{
		return array(
			'status'	=> LOGIN_ERROR_EXTERNAL_AUTH,
			'error_msg'	=> 'Ошибка авторизации',
			'user_row'	=> array('user_id' => ANONYMOUS),
		);
	}

	$auth_login = $auth['login'];
	$auth_password = $auth['pass'];

	if( ! empty($auth_login) && ! empty($auth_password))
	{
		if($auth_login !== $username)
		{
		    BFF_LOG("LOGIN_ERROR_USERNAME", __LINE__, __FUNCTION__);
			return array(
				'status'	=> LOGIN_ERROR_USERNAME,
				'error_msg'	=> 'LOGIN_ERROR_USERNAME',
				'user_row'	=> array('user_id' => ANONYMOUS),
			);
		}

		$sql = 'SELECT *
			FROM ' . USERS_TABLE . "
			WHERE username = '" . $db->sql_escape($auth_login) . "'";
		$result = $db->sql_query($sql);
		$row = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);

		if($row)
		{
			// Аккаунт неактивен / заблокирован
			if($row['user_type'] == USER_INACTIVE || $row['user_type'] == USER_IGNORE)
			{
				return array(
					'status'	=> LOGIN_ERROR_ACTIVE,
					'error_msg'	=> 'ACTIVE_ERROR',
					'user_row'	=> $row,
				);
			}

			// Успешная авторизация
			return array(
				'status'	=> LOGIN_SUCCESS,
				'error_msg' => false,
				'user_row'	=> $row,
			);
		}

		// Первая авторизация - создаем аккаунт
		BFF_LOG("LOGIN_SUCCESS_CREATE_PROFILE", __LINE__, __FUNCTION__);
		return array(
			'status'	=> LOGIN_SUCCESS_CREATE_PROFILE,
			'error_msg'	=> false,
			'user_row'	=> user_row_bff($auth_login, $auth_password, $row),
		);
	}

	// Неавторизован
	BFF_LOG("Ошибка авторизации", __LINE__, __FUNCTION__);
	return array(
		'status'	=> LOGIN_ERROR_EXTERNAL_AUTH,
		'error_msg'	=> 'Ошибка авторизации',
		'user_row'	=> array('user_id' => ANONYMOUS),
	);
}

/**
 * Автоматическая авторизация
 * @return array если пользователь авторизован(сессия не пустая) - авторизуем на форуме
 */
function autologin_bff()
{
	global $db;
	$auth = BFF_USER();

	if(empty($auth['login'])) {
		return array();
	}

	$auth_login = $auth['login'];
	$auth_password = $auth['pass'];

	if ( ! empty($auth_login) && ! empty($auth_password) )
	{
		set_var($auth_login, $auth_login, 'string', true);
		set_var($auth_password, $auth_password, 'string', true);

		$sql = 'SELECT *
			FROM ' . USERS_TABLE . "
			WHERE username = '" . $db->sql_escape($auth_login)."'";
		$result = $db->sql_query($sql);
		$row = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);

		if ($row)
		{
			return ($row['user_type'] == USER_INACTIVE || $row['user_type'] == USER_IGNORE) ? array() : $row;
		}

		if( ! function_exists('user_add')) {
			global $phpbb_root_path, $phpEx;
			include($phpbb_root_path . 'includes/functions_user.'.$phpEx);
		}

		// создаем пользователя
		user_add(user_row_bff($auth_login, $auth_password, $row));

		$sql = 'SELECT *
			FROM ' . USERS_TABLE . "
			WHERE username_clean = '" . $db->sql_escape(utf8_clean_string($auth_login))."'";
		$result = $db->sql_query($sql);
		$row = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);

		if($row) {
		    BFF_LOG("new created: ".print_r(array('id'=>$row['user_id'],'login'=>$row['username'],'email'=>$row['user_email']), true), __LINE__, __FUNCTION__);
			return $row;
		}
	}

	return array();
}

/**
 * Завершение сеанса пользователя
 */
function logout_bff($user_row, $new_session)
{
    session_destroy();
}

/**
 * Формируем массив для создания пользователя (user_add)
 * @param string $username @ref имя пользователя (логин или email)
 * @param string $password @ref пароль пользователя
 * @param array $all данные о пользователе (данные из таблицы форума USERS_TABLE)
 * @return array
 */
function user_row_bff($username, $password, $all)
{
	global $db, $config, $user;
	// получаем группу по-умолчанию (если не указана)
	if( empty($all['group_id']) ) {
        $sql = 'SELECT group_id
            FROM ' . GROUPS_TABLE . "
            WHERE group_name = '" . $db->sql_escape('REGISTERED') . "'
                AND group_type = " . GROUP_SPECIAL;
        $result = $db->sql_query($sql);
        $row = $db->sql_fetchrow($result);
        $db->sql_freeresult($result);

        if( ! $row) {
            trigger_error('NO_GROUP');
        }

        $all['group_id'] = (int)$row['group_id'];
    }

	$x = array(
		'username'		=> $username,
		'user_password'	=> phpbb_hash($password),
		'user_email'	=> '',
		'group_id'		=> (int) $all['group_id'],
		'user_type'		=> USER_NORMAL,
		'user_ip'		=> $user->ip,
		'user_new'		=> ($config['new_member_post_limit']) ? 1 : 0,
	);

	return $x;
}

/**
 * Проверяем авторизован ли указанный пользователь ($user) в текущий момент времени
 * @return boolean true - если пользователь авторизован или false - сессия должна быть закрыта
 */
function validate_session_bff(&$user)
{
    $auth = BFF_USER();

	if( ! empty($auth['login']) ) {
		$auth_login = '';
		set_var($auth_login, $auth['login'], 'string', true);
		$result = ($auth_login === $user['username'] ? true : false );
		return $result;
	}

    // Аноним / Бот
	if($user['user_type'] == USER_IGNORE) {
		return true;
	}
	return false;
}