<?php

set_time_limit(0);
header('Content-type: text/html; charset=windows-1251');

# Ключ доступа к сервису hmn.ru
$sKEY = config::sys('services.weather.key');
if( empty($sKEY) ) return;

$oDb = \bff::database();

$aStat = array('xml'=>0,'days3'=>0,'days10'=>0);

$getXML = function($fileName) use (&$aStat, $sKEY)
{
    $url = array( 0=>'http://news.hmn.ru/news_out/'.$sKEY.'/',
                  1=>'http://news1.hmn.ru/news_out/'.$sKEY.'/' );

    $aStat['xml']++;
    $ch = curl_init();
    if( !$ch ) return '';
    curl_setopt($ch, CURLOPT_RETURNTRANSFER,true);
              
    curl_setopt($ch, CURLOPT_URL, $url[0].$fileName);
    $res = curl_exec($ch);

    if($res===false || $res === '')
    {
        curl_setopt($ch, CURLOPT_URL, $url[1].$fileName);
        $res = curl_exec($ch);        
    }
    
    curl_close($ch);
    if (mb_stripos($res, 'Not Found')!==false) {
        return false;
    }
    return (!empty($res) ? simplexml_load_string($res) : false);
};

$getCityID = function($nID, $sName) use($oDb)
{
    static $cache;
    $nID = intval($nID);
    $sName = strval($sName);
    if (isset($cache[$nID])) {
        return $cache[$nID];
    }
    $nCityID = $oDb->one_data('SELECT id FROM '.TABLE_REGIONS.' WHERE title_'.LNG.' = :title', array(':title' => $sName));
    if ($nCityID) {
        $cache[$nID] = $nCityID;
        return $nCityID;
    }
    return 0;
};

# --------------------------------------------------------------------
# данные на 10 дней
$nLastDate = $oDb->one_data('SELECT MAX(city_date) FROM '.TABLE_WEATHER.' WHERE extended = 0');
$nLastDate = strtotime( $nLastDate );
$weather_signs = false; 
for($i=0;$i<=11;$i++)
{
    $x = $getXML($i.'day_forecast.xml');
    if ($x === false) continue;
 
    $date = $x->f_provider[0]->forecast_to_date[0];
    $date = mktime(0,0,0,(int)$date['month'], (int)$date['day'], (int)$date['year']);
    if($date <= $nLastDate) continue;
    $sqlDate = date('Y-m-d', $date);
    
    if($weather_signs === false) {
        $weather_signs = array();
        foreach($x->f_weather_signs[0]->weather as $w) {
            $weather_signs[ ((int)$w['code']) ] = strval($w);
        }
    }
         
    foreach($x->c as $c)
    {
        $dw = intval($c->dw);
        $nw = intval($c->nw);
        $params = array(
            // днем
            'd' => array(
                't' => intval($c->td), // Максимальная температура днем
                'w' => $dw, // Значок погоды днем (1 -17)      
                'ws' => intval($c->dws), // Скорость ветра днем м/с
                'txt' => ( isset($weather_signs[$dw]) ? $weather_signs[$dw] : '?' ),  // Описание погоды 
                ),
            // ночью
            'n' => array(
                't' => intval($c->tn), // Минимальная температура ночью
                'w' => $nw, // Значок погоды ночью (1 -17)
                'ws' => intval($c->nws), // Скорость ветра ночью м/с
                'txt' => ( isset($weather_signs[$nw]) ? $weather_signs[$nw] : '?' ),  // Описание погоды
                )
            );

        // city_date, city_id, params, extended
        $res = $oDb->insert(TABLE_WEATHER, array (
            'city_date' => $sqlDate,
            'city_id'   => $getCityID((int)$c['id'], strval($c->t)),
            'params'    => serialize($params),
            'extended'  => 0,
        ));
        if($res) {
            $aStat['days10']++;
        }
    }
}


# ------------------------------------------------------------------------------------------------
# данные на 3 суток: с разбивкой по 6 часов
$nLastDate = $oDb->one_data('SELECT MAX(city_date) FROM '.TABLE_WEATHER.' WHERE extended = 1');
$nLastDate = strtotime( $nLastDate );
// текстовки к значкам погоды
$weather_signs = false;
// направление ветра
function getWindDirectionText($d)
{
    if ($d==990) 
     return "Переменных направлений";
    if (($d>=0 AND $d<=11) OR ($d>=349 AND $d<=360))
     return "С";
    if ($d>=12 AND $d<=33)
     return "ССВ";
    if ($d>=34 AND $d<=56)
     return "СВ";    
    if ($d>=57 AND $d<=78)
     return "ВСВ";    
    if ($d>=79 AND $d<=101)
     return "В";    
    if ($d>=102 AND $d<=123)
     return "ВЮВ";    
    if ($d>=124 AND $d<=146)
     return "ЮВ";
    if ($d>=147 AND $d<=168)
     return "ЮЮВ";    
    if ($d>=169 AND $d<=191)
     return "Ю";    
    if ($d>=192 AND $d<=214)
     return "ЮЮЗ";    
    if ($d>=215 AND $d<=236)
     return "ЮЗ";    
    if ($d>=237 AND $d<=258)
     return "ЗЮЗ";    
    if ($d>=259 AND $d<=281)
     return "З";    
    if ($d>=282 AND $d<=303)
     return "ЗСЗ";    
    if ($d>=304 AND $d<=326)
     return "СЗ";    
    if ($d>=327 AND $d<=348)
     return "ССЗ";    
}
                
for($i=0;$i<=3;$i++)
{
    $x = $getXML($i.'day_d_forecast.xml');
    if(empty($x)) continue;
    
    $date = $x->f_provider[0]->forecast_to_date[0];
    $date = mktime(0,0,0,(int)$date['month'], (int)$date['day'], (int)$date['year']);
    if($date <= $nLastDate) continue;
    $sqlDate = date('Y-m-d', $date);
    
    if($weather_signs === false) {
        $weather_signs = array();
        foreach($x->f_weather_signs[0]->weather as $w) {
            $weather_signs[ ((int)$w['code']) ] = strval($w);
        }
    }
              
    foreach($x->c as $c) 
    {
        $data = array (
            'city_date' => $sqlDate,
            'city_id'   => $getCityID((int)$c['id'], strval($c->t)),
            'params'    => array(),
            'extended'  => 1,
        );
        foreach($c->ft as $f) // время дня: ночь(6), утро(12), день(18), вечер(24)
        {
            $time = (int)$f['t'];
            $w = (int)$f->w; //Значок погоды  
            $wd = (int)$f->wd; //Направление ветра в градусах
            $tf = (int)$f->tf;
            $tt = (int)$f->tt;
            $data['params'][$time] = array(
                'tf' => $tf, // Температура от
                'tt' => $tt, // Температура до   
                'w' => $w,  // Значок погоды (1 -17) 
                'txt' => ( isset($weather_signs[$w]) ? $weather_signs[$w] : '?' ),  // Описание погоды 
                'ws' => (int)$f->ws,  // Скорость ветра м/с
                'wd' => $wd,  // Направление ветра в градусах (расшифровка указана ниже)
                'wdt' => getWindDirectionText($wd),  // Текстовое описание направления ветра (С, СЗ, ЮЗ...)
                'p' => (int)$f->p,  // Давление мм.рт.ст.   
                'hum' => (int)$f->hum,  // Относительная влажность % 
                'ns' => ($time == 24 ? 'n' : ''),  // Если значок ночной, то выводится "n", если дневной - то пусто
            );   
            // средняя для просмотра
            if($tf >= $tt) {
                $avg = round(($tf - $tt)/2) + $tt;
            } else {
                $avg = round(($tt - $tf)/2) + $tf;
            }
            $data['params'][$time]['avg'] = ($avg>0 ? '+'.$avg : $avg);
        }
        
        $data['params'] = serialize($data['params']);
        // city_date, city_id, params, extended
        $res = $oDb->insert(TABLE_WEATHER, $data);
        if($res) {
            $aStat['days3']++;
        }
    }    
}
