<?php

/**
 * Права доступа группы:
 *  - afisha: Афиша
 *      -- описание находится в файле /modules/afisha/tpl/access-to.txt
 */

use bff\utils\Files;

class Afisha extends AfishaBase
{
    function listing($typeID, $typeKey)
    {
        if (!$this->haveAccessTo('items-listing', 'afisha-' . $typeKey)) {
            return $this->showAccessDenied();
        }
        $aData = array('f' => array(), 'type' => $this->type);

        $sqlTable = $this->type->tableName();

        if (Request::isAJAX()) {
            switch ($this->input->get('act')) {
                case 'toggle':
                {
                    if (!$this->haveAccessTo('items-manage', 'afisha-' . $typeKey)) {
                        return $this->showAccessDenied();
                    }

                    $nItemID = $this->input->get('item_id', TYPE_UINT);
                    if (!$nItemID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $aItemData = $this->model->itemData($nItemID, array('enabled'), $typeID);
                    if (empty($aItemData)) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $this->model->itemSave($nItemID, array('enabled = (1 - enabled)'), $typeID);

                    # актуализируем:
                    $this->calendarUpdate($nItemID, $this->type->id, ($aItemData['enabled'] ? 'disabled' : 'enabled')); // календарь
                    $this->rssUpdate($typeID); # RSS

                    $this->ajaxResponse(Errors::SUCCESS);
                }
                break;
                case 'tags-autocomplete': # autocomplete
                {
                    $sQ = $this->input->postget('q', TYPE_NOTAGS);
                    $this->initTags($typeID)->tagsAutocomplete($sQ);
                }
                break;
                case 'delete':
                {
                    if (!$this->haveAccessTo('items-delete', 'afisha-' . $typeKey)) {
                        return $this->showAccessDenied();
                    }

                    $nItemID = $this->input->postget('item_id', TYPE_UINT);
                    if (!$nItemID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $res = $this->deleteItem($nItemID);

                    $this->ajaxResponse(($res ? Errors::SUCCESS : Errors::IMPOSSIBLE));
                }
                break;
            }
        }

        $aData['orders'] = array('created' => 'desc');

        $this->input->postgetm(array(
                'page'     => TYPE_UINT,
                'category' => TYPE_UINT,
                'mod'      => TYPE_BOOL,
                'city'     => TYPE_UINT,
                'tag'      => TYPE_UINT,
                'p_from'   => TYPE_STR,
                'p_to'     => TYPE_STR,
                'id'       => TYPE_UINT,
                'user'     => TYPE_UINT,
            ), $f
        );

        $bModeration = $this->type->moderationEnabled();

        $sqlWhere = array();
        if ($f['category'] > 0) {
            $sqlWhere[] = 'I.category_id = ' . $f['category'];
        }
        if ($bModeration) {
            if ($this->type->moderationPost()) {
                if ($f['mod']) {
                    $sqlWhere[] = 'I.moderated = 0';
                }
            } else {
                $sqlWhere[] = 'I.moderated = ' . ($f['mod'] ? 0 : 1);
            }
        }

        $sqlTag = '';
        if ($f['tag'] > 0 && $this->type->tagsEnabled()) {
            $aData['tag'] = $this->initTags($typeID)->tagData($f['tag']);
            if (!empty($aData['tag'])) {
                $sqlTag = ' INNER JOIN ' . TABLE_AFISHA_TAGS_IN . ' T ON T.type_id = ' . $typeID . ' AND T.item_id = I.id AND T.tag_id = ' . $f['tag'] . ' ';
            }
        }
        if (empty($sqlTag)) {
            $f['tag'] = 0;
        }

        if (!empty($f['p_from'])) {
            $p_from = strtotime($f['p_from']);
            if (!empty($p_from)) {
                $sqlWhere[] = 'DATE(I.created) >= ' . $this->db->str2sql(date('Y-m-d', $p_from));
            }
        }
        if (!empty($f['p_to'])) {
            $p_to = strtotime($f['p_to']);
            if (!empty($p_to)) {
                $sqlWhere[] = 'DATE(I.created) <= ' . $this->db->str2sql(date('Y-m-d', $p_to));
            }
        }
        if ($f['city'] > 0) {
            $sqlWhere[] = 'I.city_id = ' . $f['city'];
        }
        if( $f['id']){
            $sqlWhere[] = 'I.id = '.$f['id'];
        }
        if( $f['user']){
            $sqlWhere[] = 'I.user_id = '.$f['user'];
        }

        $sqlWhere = (!empty($sqlWhere) ? ' WHERE ' . join(' AND ', $sqlWhere) : '');

        $nCount = $this->db->one_data('SELECT COUNT(*) FROM ' . $sqlTable . ' I ' . $sqlTag . ' ' . $sqlWhere);
        $this->prepareOrder($orderBy, $orderDirection, 'created-desc', $aData['orders']);
        $this->tplAssigned(array('order_by', 'order_dir', 'order_dir_needed'), $f);
        $f['order'] = $orderBy . '-' . $orderDirection;

        $aData['pgn'] = $this->generatePagenation($nCount, 15, 'afishaItems.page({pageId})', $sqlLimit, 'pagenation.ajax.tpl', 'page', true);

        if ($this->type->categoriesEnabled()) {
            $aData['items'] = $this->db->select("SELECT I.id, IL.title, I.link as linkout, I.comments, I.enabled, I.created, I.moderated,
                    U.login as created_login, I.created_uid, CL.title as category_title, I.category_id
                FROM $sqlTable I
                    $sqlTag
                    INNER JOIN " . TABLE_AFISHA_ITEMS_LANG . " IL ON " . $this->model->langAnd($this->type->id, false, 'I', 'IL') . "
                    LEFT JOIN " . TABLE_USERS . " U ON U.user_id = I.created_uid
                    LEFT JOIN " . TABLE_AFISHA_CATEGORIES . " C ON I.category_id = C.id
                    LEFT JOIN " . TABLE_AFISHA_CATEGORIES_LANG . " CL ON " . $this->db->langAnd(false, 'C', 'CL') . "
                $sqlWhere
                ORDER BY I.$orderBy $orderDirection $sqlLimit"
            );
        } else {
            $aData['items'] = $this->db->select("SELECT I.id, IL.title, I.link as linkout, I.comments, I.enabled, I.created, I.moderated,
                    U.login as created_login, I.created_uid
                FROM $sqlTable I
                    $sqlTag
                    INNER JOIN " . TABLE_AFISHA_ITEMS_LANG . " IL ON " . $this->model->langAnd($this->type->id, false, 'I', 'IL') . "
                    LEFT JOIN " . TABLE_USERS . " U ON U.user_id = I.created_uid
                $sqlWhere
                ORDER BY I.$orderBy $orderDirection $sqlLimit"
            );
        }

        $aData['list'] = $this->viewPHP($aData, 'admin.items.listing.ajax');

        if (Request::isAJAX()) {
            $this->ajaxResponse(array(
                    'list'   => $aData['list'],
                    'pgn'    => $aData['pgn'],
                    'filter' => $f,
                )
            );
        }

        $aData['f'] = $f;
        if($f['user']){
            $aUser = Users::model()->userData($f['user'], array('login', 'email'));
            $aData['user_title'] = '#'.$f['user'].' '.$aUser['login'].' ('.$aUser['email'].')';
        }


        return $this->viewPHP($aData, 'admin.items.listing');
    }

    function add($typeID, $typeKey)
    {
        if (!$this->haveAccessTo('items-manage', 'afisha-' . $typeKey)) {
            return $this->showAccessDenied();
        }

        $isPublicator = ($this->type->contentPublicator());
        if ($isPublicator) {
            # инициализируем всегда, для обработки ajax запросов от публикатора
            $oPublicator = $this->initPublicator();
        }

        $aData = $this->validateItemData(0);
        $referer = $this->input->post('referer', TYPE_STR);
        $referer = (!empty($referer) ? $referer : Request::referer());

        $dp = $this->dp();
        if (Request::isPOST())
        {

            $aData['created'] = $aData['modified'] = $this->db->getNOW();

            # если автор указывается текстом или userID не указали, ставим текущего
            if ($this->type->authorText() || empty($aData['user_id'])) {
                $aData['user_id'] = User::id();
            }

            $bRedirect = $this->input->getpost('redirect', TYPE_BOOL);

            $aData['moderated'] = 1;

            $aDynpropsData = (!empty($aData['d'][$typeID]) ? $aData['d'][$typeID] : array());
            $aDataDP = $dp->prepareSaveDataByID($aDynpropsData, $dp->getByID(array_keys($aDynpropsData)), 'insert/update', true);

            unset($aData['d']);

            if ($this->errors->no()) {
                $aData = array_merge($aData, $aDataDP);
                $nItemID = $this->model->itemSave(0, $aData, $typeID);

                if ($nItemID) {
                    if ($this->type->tagsEnabled()) {
                        $this->initTags($typeID)->tagsSave($nItemID);
                    }
                    if ($this->type->imgEnabled() && !empty($aData['img'])) {
                        # переносим изображение из временной папки в постоянную
                        $oImages = $this->initImages(array('id' => $nItemID, 'created' => $aData['created']));
                        $oImages->untemp($aData['img']);
                    }

                    # обрабатываем видео данные
                    if ($this->type->videoEnabled()) {
                        # загружаем видео файл, если был выбран
                        $this->initVideo(array('id' => $nItemID), $this->type)->processData(false);
                    }

                    if ($isPublicator) {
                        # переносим фотографии публикатора из временной папки в постоянную
                        $oPublicator->dataUpdate($aData['content'], $nItemID);
                    }

                    # сохраняем место и время события
                    $this->saveItemPlace($nItemID, $aData['city_id'], false);

                    # формируем ссылку в заголовке
                    if ($this->prepareItemTitle($nItemID, $aData)) {
                        $this->model->itemSave($nItemID, array(
                                'link'         => $aData['link'],
                                'title'        => $aData['title'],
                                'title_params' => $aData['title_params'],
                            ), $typeID
                        );
                    }

                    # сразу публикуем:
                    if ($aData['enabled']) {
                        # фиксируем в календаре
                        $this->calendarUpdate($nItemID, $typeID, 'added');
                        # актуализируем RSS
                        $this->rssUpdate($typeID);
                    }
                    $this->adminRedirect(Errors::SUCCESS, ($bRedirect ? $typeKey . ':listing' : $typeKey . ':edit&item_id=' . $nItemID));
                }
            } else {
                if ($this->type->extra['title_link']) {
                    $aTitleParams = func::unserialize($aData['title_params'], array(
                        'title' => $aData['title'],
                        'link'  => $aData['link']
                    ));
                    $aData['title'] = $aTitleParams['title'];
                    $aData['link']  = $aTitleParams['link'];
                }
                if ($this->type->extra['source_link']) {
                    $aData['extra_source_link'] = func::unserialize($aData['extra_source_link'], array('title'=>'','link'=>''));
                }
                if ($isPublicator) {
                    $aData['content'] = $oPublicator->unserialize($aData['content']);
                }
            }
        }

        $aData['id'] = 0;
        $aData['dp_form'] = $dp->form($typeID, array(), false, false, 'd', 'admin.items.form.dynprops', $this->module_dir_tpl);
        $aData['referer'] = $referer;

        return $this->viewPHP($aData, 'admin.items.form');
    }

    function edit($typeID, $typeKey)
    {
        if (!$this->haveAccessTo('items-manage', 'afisha-' . $typeKey)) {
            return $this->showAccessDenied();
        }

        $sqlTable = $this->type->tableName();
        $nUserID = User::id();
        $nItemID = $this->input->get('item_id', TYPE_UINT);

        $isPublicator = ($this->type->contentPublicator());
        if ($isPublicator) {
            # инициализируем всегда, для обработки ajax запросов от публикатора
            $oPublicator = $this->initPublicator();
        }
        if (!$nItemID) {
            $this->adminRedirect(Errors::UNKNOWNRECORD, $typeKey . ':listing');
        }

        $sqlSelect = 'SELECT I.*, U2.login as modified_login, U1.email as user_email, U1.blocked as user_blocked
                       FROM ' . $sqlTable . ' as I
                            LEFT JOIN ' . TABLE_USERS . ' as U1 ON U1.user_id = I.user_id
                            LEFT JOIN ' . TABLE_USERS . ' as U2 ON U2.user_id = I.modified_uid
                        WHERE I.id = ' . $nItemID;

        $aData = $this->db->one_array($sqlSelect);
        if (empty($aData)) {
            $this->adminRedirect(Errors::UNKNOWNRECORD, $typeKey . ':listing');
        }
        $this->db->langSelect(array(
                'id'      => $nItemID,
                'type_id' => $this->type->id
            ), $aData, $this->model->langItems, TABLE_AFISHA_ITEMS_LANG
        );
        $bShowModeration = ($this->type->moderationEnabled() && !$aData['moderated']);

        $referer = $this->input->post('referer', TYPE_STR);
        $referer = (!empty($referer) ? $referer : Request::referer());

        $dp = $this->dp();

        if (Request::isPOST()) {

            # список изменений
            $aChanged = array('title' => 0, 'category' => 0, 'content_short' => 0, 'img' => 0, 'enabled' => 0);

            $bModerated = ($bShowModeration && $this->input->post('moderated', TYPE_BOOL));

            $aDataPrev = $aData;
            $aData = $this->validateItemData($nItemID);

            if ($bModerated) {
                $aData['moderated'] = 1;
                $aData['moderated_uid'] = $nUserID;
            }
            foreach ($aDataPrev['title'] as $lng => $v) {
                if ($aData['title'][$lng] != $v) {
                    $aChanged['title'] = 1;
                }
                if ($this->type->contentShort()) {
                    if ($aData['content_short'][$lng] != $v) {
                        $aChanged['content_short'] = 1;
                    }
                }
            }
            $aChanged['enabled'] = ($aData['enabled'] != $aDataPrev['enabled'] ? 1 : 0);
            if ($this->type->categoriesEnabled() && $aDataPrev['category_id'] != $aData['category_id']) {
                $aChanged['category'] = 1;
            }
            if ($this->type->imgEnabled() && $aData['img'] != $aDataPrev['img']) {
                $aChanged['img'] = 1;
            }

            $aDynpropsData = (!empty($aData['d'][$typeID]) ? $aData['d'][$typeID] : array());
            $aDataDP = $dp->prepareSaveDataByID($aDynpropsData, $dp->getByID(array_keys($aDynpropsData)), 'insert/update', true);
            $aData = array_merge($aData, $aDataDP);

            unset($aData['d']);

            if ($this->errors->no()) {
                $res = $this->model->itemSave($nItemID, $aData, $typeID);
                if (!empty($res)) {
                    if ($bModerated) {
                        $this->itemsModerationCounter($typeKey, -1);
                    }

                    # обновляем место и время события
                    $this->saveItemPlace($nItemID, $aData['city_id'], true);

                    # обрабатываем видео данные
                    if ($this->type->videoEnabled()) {
                        $this->initVideo(array('id' => $nItemID), $this->type)->processData(true);
                    }

                    # фиксируем изменения календаре
                    if ($aChanged['enabled']) {
                        $this->calendarUpdate($nItemID, $typeID, ($aData['enabled'] ? 'enabled' : 'disabled'));
                    }

                    # событие было отредактировано
                    if (array_sum($aChanged) > 0) {
                        $this->rssUpdate($typeID);
                    }

                    $bRedirect = $this->input->post('redirect', TYPE_BOOL);
                    if (!$bRedirect) {
                        $this->errors->success();
                        $aData = $this->db->one_array($sqlSelect);
                        $this->db->langSelect(array(
                                'id'      => $nItemID,
                                'type_id' => $this->type->id
                            ), $aData, $this->model->langItems, TABLE_AFISHA_ITEMS_LANG
                        );
                    } else {
                        if (!empty($referer) && strpos($referer, ':edit') === false) {
                            $this->redirect($referer);
                        } else {
                            $this->adminRedirect(Errors::SUCCESS, $typeKey . ':listing');
                        }
                    }
                }
            }
        } else {

        }

        if ($isPublicator) {
            $aData['content'] = $oPublicator->unserialize($aData['content']);
        }

        $aTitleParams   = func::unserialize($aData['title_params'], array('title'=>'','link'=>''));
        $aData['title'] = $aTitleParams['title'];
        $aData['link']  = $aTitleParams['link'];

        if ($this->type->extra['source_link']) {
            $aData['extra_source_link'] = func::unserialize($aData['extra_source_link'], array('title'=>'','link'=>''));
        }

        $aData['moderation'] = ($bShowModeration ? 1 : 0);
        $aData['places'] = $this->getItemPlaces($nItemID, $this->type);
        $aData['dp_form'] = $dp->form($typeID, $aData, false, false, 'd', 'admin.items.form.dynprops', $this->module_dir_tpl);
        $aData['referer'] = $referer;
        return $this->viewPHP($aData, 'admin.items.form');
    }

    function img_upload($typeID, $typeKey)
    {
        if (!$this->haveAccessTo('items-manage', 'afisha-' . $typeKey)) {
            return $this->showAccessDenied();
        }

        $nItemID = $this->input->get('item_id', TYPE_UINT);
        $oImages = false;
        if ($nItemID > 0) {
            $aItemData = $this->model->itemData($nItemID, array('id', 'created'), $typeID);
            if (!empty($aItemData)) {
                $oImages = $this->initImages(array('id' => $nItemID, 'created' => $aItemData['created']));
            }
        } else {
            $oImages = $this->initImages(array('id' => $nItemID));
        }
        $aData = array();

        if ($oImages !== false) {
            $aResult = $oImages->upload('img');
            if ($aResult !== false) {
                $aData = $aResult;
                $aData['success'] = 1;
            } else {
                $aData['success'] = 0;
            }
        } else {
            $aData['success'] = 0;
        }
        $aData['item_id'] = $nItemID;

        echo $this->viewPHP($aData, 'admin.items.img.upload');
        bff::shutdown();
    }

    function video_upload() // qq upload
    {
        if (!$this->security->haveAccessToAdminPanel()) {
            return $this->showAccessDenied();
        }

        $nItemID = $this->input->get('item', TYPE_UINT);
        $typeID = $this->input->get('type', TYPE_UINT);
        $sFrameTime = $this->input->get('frame_time', TYPE_STR);
        $type = $this->getTypeSettings($typeID);

        if (!$typeID || !$this->haveAccessTo('items-manage', 'afisha-' . $type->keyword)) {
            return $this->showAccessDenied();
        }

        $result = false;
        if ($type->videoEnabled() && $nItemID > 0) {
            if (empty($sFrameTime) || strpos($sFrameTime, ':') === false) {
                $sFrameTime = '00:00:00';
            }

            $oVideo = $this->initVideo(array('id' => $nItemID), $type);
            $result = $oVideo->uploadQQ('video_file', true, $sFrameTime, true);
            if ($result !== false) { // file, height, frame, frame_time
                $oVideo->updateVideoData($result, false, true);
                if (!empty($result['frame'])) {
                    $result['frame_url'] = $oVideo->buildFramePath($result['frame'], true);
                }
            }
        }

        $aResponse = array('res' => ($result !== false && $this->errors->no()));
        if ($result !== false) {
            $aResponse = array_merge($aResponse, $result);
        }
        $this->ajaxResponse($aResponse, 2, false, true);
    }

    function ajax()
    {
        if (!$this->security->haveAccessToAdminPanel()) {
            return $this->showAccessDenied();
        }

        $typeID = $this->input->getpost('type', TYPE_UINT);
        $type = $this->getTypeSettings($typeID);
        $typeKey = $type->keyword;

        if (Request::isAJAX())
        {
            switch ($this->input->get('act')) {
                case 'item-tags-autocomplete': # autocomplete.fb
                {
                    $sTag = $this->input->postget('tag', TYPE_STR);
                    $this->initTags($typeID)->tagsAutocomplete($sTag);
                }
                break;
                case 'item-author-autocomplete': # autocomplete
                {
                    if (!$this->haveAccessTo('items-manage', 'afisha-' . $typeKey)) {
                        $this->ajaxResponse(Errors::ACCESSDENIED);
                    }

                    $sQ = $this->input->post('q', TYPE_NOTAGS);
                    //получаем список подходящих по email пользователей, исключая:
                    // - заблокированных
                    // - неактивированных
                    $aResult = $this->db->select('SELECT U.user_id, U.email FROM ' . TABLE_USERS . ' U
                                  WHERE U.email LIKE (:query)
                                    AND U.blocked=0
                                    AND U.activated = 1
                                  ORDER BY U.email', array(':query' => $sQ . '%')
                    );

                    $aUsers = array();
                    foreach ($aResult as $u) {
                        $aUsers[$u['user_id']] = $u['email'];
                    }
                    unset($aResult);

                    $this->ajaxResponse($aUsers);
                }
                break;
                case 'item-place-autocomplete': #autocomplete 
                {
                    if (!$this->haveAccessTo('items-manage', 'afisha-' . $typeKey)) {
                        $this->ajaxResponse(Errors::ACCESSDENIED);
                    }

                    $sQ = $this->input->post('q', TYPE_STR);
                    # получаем список подходящих по названию объектов справочника:
                    $aResult = $this->db->select('SELECT I.id, IL.title
                                  FROM ' . TABLE_ITEMS . ' I, ' . TABLE_ITEMS_LANG . ' IL, ' . TABLE_ITEMS_IN_CATEGORIES . ' IC
                                  WHERE I.id = IC.item_id ' . (!empty($type->places['categories']) ? ' AND IC.category_id IN (' . join(',', $type->places['categories']) . ') ' : '') . '
                                    AND IL.title LIKE (:query) ' . $this->db->langAnd(true, 'I', 'IL') . '
                                  ORDER BY IL.title', array(':query' => $sQ . '%')
                    );

                    $aItems = array();
                    foreach ($aResult as $v) {
                        $aItems[$v['id']] = $v['title'];
                    }
                    unset($aResult);

                    $this->ajaxResponse($aItems);
                }
                break;
                case 'item-user-autocomplete': # autocomplete
                {
                    if (!$this->haveAccessTo('items-listing', 'afisha-' . $typeKey)) {
                        $this->ajaxResponse(Errors::ACCESSDENIED);
                    }
                    $sQ = $this->input->post('q', TYPE_NOTAGS);
                    $aData = Users::model()->autocomplete($sQ);
                    $this->autocompleteResponse($aData, 'user_id', 'title');
                }break;
                case 'item-video-validate':
                {
                    if (!$this->haveAccessTo('items-manage', 'afisha-' . $typeKey)) {
                        $this->ajaxResponse(Errors::ACCESSDENIED);
                    }

                    /** @example http://www.youtube.com/watch?v=8XziNsM3Z-c&feature=youtu.be */
                    $sCode = $this->input->post('code', TYPE_STR);
                    $oVideo = $this->initVideo(array('id' => 0), $type);
                    $this->ajaxResponse($oVideo->validate_code($sCode));

                }
                break;
                case 'item-video-updateframe':
                {
                    if (!$this->haveAccessTo('items-manage', 'afisha-' . $typeKey)) {
                        $this->ajaxResponse(Errors::ACCESSDENIED);
                    }

                    $aResponse = array();

                    $nItemID = $this->input->get('item', TYPE_UINT);
                    $sFrameTime = $this->input->post('frame_time', TYPE_NOTAGS);
                    $oVideo = $this->initVideo(array('id' => $nItemID), $type);

                    $aData = $oVideo->getVideoData();

                    if (empty($aData)) {
                        $this->errors->impossible();
                    } elseif (empty($aData['file'])) {
                        $this->errors->set(_t('afisha', 'В первую очередь необходимо загрузить видео файл'));
                    }

                    if ($this->errors->no()) {
                        $sFrame = $oVideo->makeVideoFrame($oVideo->buildPath($aData['file'], false), $oVideo->blockWidth, $aData['height'], $sFrameTime);
                        if (!empty($sFrame)) {
                            if (!empty($aData['frame'])) {
                                $oVideo->deleteFiles($aData['frame'], true);
                            }
                            $oVideo->updateVideoData(array(
                                    'frame'      => $sFrame,
                                    'frame_time' => $sFrameTime
                                ), false, true
                            );
                            $aResponse['frame'] = $sFrame;
                            $aResponse['frame_url'] = $oVideo->buildFramePath($sFrame, true);
                        } else {
                            $this->errors->set(_t('afisha', 'Неудалось сохранить кадр'));
                        }
                    }

                    $aResponse['res'] = $this->errors->no();
                    $this->ajaxResponse($aResponse);
                }
                break;
                case 'item-video-delete-file': // not implemented
                {
                    if (!$this->haveAccessTo('items-manage', 'afisha-' . $typeKey)) {
                        $this->ajaxResponse(Errors::ACCESSDENIED);
                    }

                    $nItemID = $this->input->post('item_id', TYPE_UINT);
                    if (!$nItemID) {
                        $this->ajaxResponse(Errors::IMPOSSIBLE);
                    }

                    $oVideo = $this->initVideo(array('id' => $nItemID), $type);
                    $res = $oVideo->delete(true);
                    $this->ajaxResponse(($res ? Errors::SUCCESS : Errors::IMPOSSIBLE));
                }
                break;
                case 'item-img-delete':
                {
                    if (!$this->haveAccessTo('items-manage', 'afisha-' . $typeKey)) {
                        $this->ajaxResponse(Errors::ACCESSDENIED);
                    }

                    $sFilename = $this->input->post('filename', TYPE_STR);
                    $nItemID = $this->input->post('item_id', TYPE_UINT);
                    if (!$typeID || empty($sFilename)) {
                        $this->ajaxResponse(Errors::IMPOSSIBLE);
                    }

                    $oImages = false;
                    if ($nItemID > 0) {
                        $aItemData = $this->model->itemData($nItemID, array('id', 'created'), $typeID);
                        if (!empty($aItemData)) {
                            $oImages = $this->initImages(array(
                                    'id'      => $nItemID,
                                    'created' => $aItemData['created']
                                ), $type
                            );
                        }
                    } else {
                        $oImages = $this->initImages(array('id' => $nItemID), $type);
                    }

                    if ($oImages !== false) {
                        if ($nItemID) {
                            $oImages->delete(true);
                        } else {
                            $oImages->deleteFiles($sFilename);
                        }
                    }

                    $this->ajaxResponse(Errors::SUCCESS);
                }
                break;
                case 'item-img-crop':
                {
                    if (!$this->haveAccessTo('items-manage', 'afisha-' . $typeKey)) {
                        $this->ajaxResponse(Errors::ACCESSDENIED);
                    }

                    $nItemID = $this->input->get('item_id', TYPE_UINT);
                    if (!$typeID || !$type->imgp['orig'] || !$type->imgp['crop']) {
                        $this->ajaxResponse(Errors::IMPOSSIBLE);
                    }

                    $p = $this->input->postm(array(
                            'x'        => TYPE_UINT,
                            'y'        => TYPE_UINT,
                            'w'        => TYPE_UINT,
                            'h'        => TYPE_UINT,
                            'crop'     => TYPE_STR,
                            'filename' => TYPE_STR,
                        )
                    );
                    extract($p);

                    if ($nItemID > 0) {
                        $aData = $this->model->itemData($nItemID, array('id', 'img as filename', 'created'), $typeID);
                        if (empty($aData) || empty($aData['filename'])) {
                            $this->ajaxResponse(Errors::UNKNOWNRECORD);
                        }
                    } else {
                        if (empty($p['filename'])) {
                            $this->ajaxResponse(Errors::UNKNOWNRECORD);
                        }
                        $aData['filename'] = $p['filename'];
                    }

                    list($c['x'], $c['y'], $c['x2'], $c['y2'], $c['w'], $c['h']) = explode(',', $crop);
                    $crop_packed = serialize($c);

                    $oImages = $this->initImages(array(
                            'id'      => $nItemID,
                            'created' => (isset($aData['created']) ? $aData['created'] : '')
                        ), $type
                    );
                    if ($oImages !== false) {
                        $res = $oImages->crop($aData['filename'], $x, $y, $w, $h);
                        if ($res && $nItemID > 0) {
                            $this->model->itemSave($nItemID, array('img_crop' => $crop_packed), $typeID);
                        }
                    }

                    $this->ajaxResponse(array('crop_packed' => $crop_packed));
                }
                break;
            }

        }
        $this->ajaxResponse(Errors::IMPOSSIBLE);
    }


    //-------------------------------------------------------------------------------------------------------------------------------
    // Комментарии

    function comments_ajax()
    {
        if (!$this->haveAccessTo('comments', 'afisha')) {
            return $this->showAccessDenied();
        }

        $typeID = $this->input->getpost('group_id', TYPE_UINT);

        $this->itemComments($typeID)->admAjax();
    }

    function comments_mod()
    {
        if (!$this->haveAccessTo('comments', 'afisha')) {
            return $this->showAccessDenied();
        }

        $aTypes = $this->getTypes();

        $typeID = $this->input->getpost('type', TYPE_UINT);
        if (!$typeID) {
            reset($aTypes);
            $this->type = current($aTypes);
            $typeID = $this->type->id;
        } else {
            $this->type = $this->getTypeSettings($typeID);
        }
        if (!$typeID || empty($this->type)) {
            return $this->showError(Errors::IMPOSSIBLE, true);
        }

        # для данного типа нет возможности редактировать комментарии через админ панель
        if (!$this->type->commentsManage()) {
            $this->adminRedirect(Errors::IMPOSSIBLE, 'comments_mod');
        }

        $aData = array(
            'type' => $this->type,
        );

        $oComments = $this->itemComments($typeID);
        $aData['comments'] = $oComments->admListingModerate(15);

        $sPrefix = $oComments->counterPrefix();
        foreach ($aTypes as $k => $v) {
            $aTypes[$k]->cnt = config::get($sPrefix . $v->keyword, 0);
        }

        $aData['types'] = $aTypes;

        return $this->viewPHP($aData, 'admin.items.comments.mod');
    }

    function comments($typeID, $typeKey)
    {
        if (!$this->haveAccessTo('comments', 'afisha')) {
            return $this->showAccessDenied();
        }

        $nItemID = $this->input->get('item_id', TYPE_UINT);
        if (!$nItemID) {
            $this->adminRedirect(Errors::UNKNOWNRECORD, $typeKey . ':listing');
        }

        $sqlTable = $this->type->tableName();

        $aData = $this->db->one_array('SELECT I.id, IL.title, I.link as linkout, I.created, I.comments as comments_total
                ' . ($this->type->categoriesEnabled() ? ', ICL.title as category_title, I.category_id, IC.keyword as category' : '') . '
               FROM ' . $sqlTable . ' I
                ' . ($this->type->categoriesEnabled()
                ? ' LEFT JOIN ' . TABLE_AFISHA_CATEGORIES . ' IC ON I.category_id = IC.id
                    LEFT JOIN ' . TABLE_AFISHA_CATEGORIES_LANG . ' ICL ON ' . $this->db->langAnd(false, 'IC', 'ICL')
                : '') . '
               , ' . TABLE_AFISHA_ITEMS_LANG . ' IL
               WHERE I.id=' . $nItemID . $this->model->langAnd($this->type->id, true, 'I', 'IL') . ' LIMIT 1'
        );

        if (!$aData) {
            $this->adminRedirect(Errors::IMPOSSIBLE);
        }

        if (!$aData) {
            $this->adminRedirect(Errors::IMPOSSIBLE);
        }

        $aData['type'] = $this->type;
        $aData['item_id'] = $nItemID;
        $aData['edit_allowed'] = $this->haveAccessTo('comments', 'afisha');
        $aData['comments'] = $this->itemComments($typeID)->admListing($nItemID);

        $this->itemComments($typeID)->admListingIncludes();

        return $this->viewPHP($aData, 'admin.items.form.comments');
    }

    function tags()
    {
        $typeID = $this->input->getpost('group', TYPE_UINT);
        $type = $this->getTypeSettings($typeID);
        if (!$type) {
            $typeID = 0;
        }
        $tags = $this->initTags($typeID);

        $types = $this->getTypes();
        $groups = array(0 => 'Общие');
        foreach ($types as $type) {
            if (!$type->tagsEnabled()) {
                continue;
            }
            $groups[$type->id] = $type->title;
        }

        return $tags->manage($groups, $typeID);
    }

    function categories($typeID = 0, $typeKey = '')
    {
        $sql = array();

        $mAccessModule = null;
        $typeID = ($typeID > 0 ? $typeID : $this->input->postget('type', TYPE_UINT));
        do {
            if ($typeID) {
                $oTypeSettings = $this->getTypeSettings($typeID);
                if (!$oTypeSettings->categoriesEnabled()) { # для данного типа работа с категориями закрыта
                    return $this->showError(Errors::IMPOSSIBLE, true);
                } elseif (!$oTypeSettings->categoriesCommonOnly()) {
                    $mAccessModule = $typeKey;
                    $sql[] = 'type_id = ' . $typeID;
                    break;
                }
            }

            $sql[] = 'type_id = 0';
        } while (false);

        if (!$this->haveAccessTo('cats-listing', $mAccessModule)) {
            return $this->showAccessDenied();
        }

        $sql = join(' AND ', $sql);

        $bInheritAllowed = ($typeID && $oTypeSettings->categoriesCustomAndCommon());

        if (Request::isAJAX()) {
            if (!$this->haveAccessTo('cats-manage', $mAccessModule)) {
                return $this->showAccessDenied();
            }
            $sAction = $this->input->get('act');

            switch ($sAction) {
                case 'edit':
                {
                    $nCategoryID = $this->input->get('cat_id', TYPE_UINT);
                    if (!$nCategoryID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $aData = $this->db->one_array('SELECT * FROM ' . TABLE_AFISHA_CATEGORIES . ' WHERE id = ' . $nCategoryID . ' AND ' . $sql);
                    $this->db->langSelect($nCategoryID, $aData, $this->model->langCategories, TABLE_AFISHA_CATEGORIES_LANG);
                    if (empty($aData)) {
                        $this->ajaxResponse(Errors::IMPOSSIBLE);
                    }

                    $aData['type'] = $typeID;
                    $aData['form'] = $this->viewPHP($aData, 'admin.categories.form');

                    $this->ajaxResponse($aData);
                }
                break;
                case 'toggle':
                {
                    $nCategoryID = $this->input->postget('rec', TYPE_UINT);
                    if (!$nCategoryID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    if ($bInheritAllowed) {
                        # если частичное наследование(1), переключаем в таблице наследуемых категорий
                        $this->db->update(TABLE_AFISHA_CATEGORIES_IN, array('enabled = (1 - enabled)'), array(
                            'type_id' => $typeID, 'cat_id' => $nCategoryID,
                        ));
                    } else {
                        # если полное наследование(3) или свои(1), переключаем по id
                        $this->db->update(TABLE_AFISHA_CATEGORIES, array('enabled = (1 - enabled)'), array(
                            'id' => $nCategoryID, 'type_id' => ($typeID && $oTypeSettings->categoriesCommonOnly() ? 0 : $typeID),
                        ));
                    }

                    $this->ajaxResponse(Errors::SUCCESS);
                }
                break;
                case 'rotate':
                {
                    if ($bInheritAllowed) {
                        # если частичное наследование(1), крутим в таблице наследуемых категорий, в пределах типа
                        $this->db->rotateTablednd(TABLE_AFISHA_CATEGORIES_IN, ' AND type_id = ' . $typeID, 'cat_id', 'num');
                    } else {
                        # если полное наследование(3), крутим все общие категории
                        # если только свои(1), крутим среди своих
                        $this->db->rotateTablednd(TABLE_AFISHA_CATEGORIES, ' AND type_id = ' . ($typeID && $oTypeSettings->categoriesCommonOnly() ? 0 : $typeID), 'id', 'num');
                    }
                    $this->ajaxResponse(Errors::SUCCESS);
                }
                break;
                case 'delete':
                {
                    if (!$this->haveAccessTo('cats-delete', $mAccessModule)) {
                        return $this->showAccessDenied();
                    }

                    $nCategoryID = $this->input->get('cat_id', TYPE_UINT);
                    if (!$nCategoryID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $res = $this->db->exec('DELETE FROM ' . TABLE_AFISHA_CATEGORIES . ' WHERE id = ' . $nCategoryID . ' AND ' . $sql);
                    if ($res) {
                        $this->db->delete(TABLE_AFISHA_CATEGORIES_LANG, array('id'=>$nCategoryID));
                    }

                    $this->ajaxResponse((!empty($res) ? Errors::SUCCESS : Errors::IMPOSSIBLE));
                }
                break;
                case 'uninherit':
                {
                    if (!$bInheritAllowed) {
                        $this->ajaxResponse(Errors::IMPOSSIBLE);
                    }

                    $nCategoryID = $this->input->get('cat_id', TYPE_UINT);
                    if (!$nCategoryID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $res = $this->db->exec('DELETE FROM ' . TABLE_AFISHA_CATEGORIES_IN . ' WHERE cat_id = ' . $nCategoryID . ' AND ' . $sql);
                    $this->ajaxResponse((!empty($res) ? Errors::SUCCESS : Errors::IMPOSSIBLE));
                }
                break;
                case 'get-inherit':
                {
                    if (!$bInheritAllowed) {
                        $this->ajaxResponse(Errors::IMPOSSIBLE);
                    }
                    $aData = $this->db->select('SELECT C.id, CL.title
                            FROM ' . TABLE_AFISHA_CATEGORIES . ' C
                                LEFT JOIN ' . TABLE_AFISHA_CATEGORIES_IN . ' CIN ON C.id = CIN.cat_id AND CIN.type_id = ' . $typeID . '
                                , ' . TABLE_AFISHA_CATEGORIES_LANG . ' CL
                        WHERE C.type_id = 0 AND CIN.cat_id IS NULL ' . $this->db->langAnd(true, 'C', 'CL')
                    );
                    $sOptions = (!empty($aData) && is_array($aData) ? HTML::selectOptions($aData, 0, false, 'id', 'title') : '<option value="0">нет доступных разделов</option>');
                    $this->ajaxResponse(array('opts' => $sOptions));
                }
                break;
            }
        } else {
            if (Request::isPOST()) {
                if (!$this->haveAccessTo('cats-manage', $mAccessModule)) {
                    return $this->showAccessDenied();
                }

                switch ($this->input->postget('act')) {
                    case 'add-finish':
                    {
                        $aData = $this->validateCategoryData($typeID, 0);
                        $aData['num'] = $this->categoriesGetCurrentNum($typeID, $bInheritAllowed);
                        if ($this->errors->no()) {
                            $nNewCategoryID = $this->db->insert(TABLE_AFISHA_CATEGORIES, array_diff_key($aData, $this->model->langCategories));
                            if ($nNewCategoryID) {
                                $this->db->langInsert($nNewCategoryID, $aData, $this->model->langCategories, TABLE_AFISHA_CATEGORIES_LANG);
                                if ($bInheritAllowed) {
                                    $this->db->insert(TABLE_AFISHA_CATEGORIES_IN, array(
                                        'type_id' => $typeID,
                                        'cat_id'  => $nNewCategoryID,
                                        'num'     => $aData['num'],
                                    ), false);
                                }
                            }
                        }

                    }
                    break;
                    case 'edit-finish':
                    {
                        $nCategoryID = $this->input->post('cat_id', TYPE_UINT);
                        if (!$nCategoryID) {
                            $this->errors->unknownRecord();
                        }

                        $aDataCur = $this->db->select_row(TABLE_AFISHA_CATEGORIES, '*', array('id'=>$nCategoryID));
                        if (empty($aDataCur)) {
                            $this->errors->unknownRecord();
                        }

                        $aData = $this->validateCategoryData($typeID, $nCategoryID);

                        //попытка изменения keyword'a категории
                        if ($aData['keyword'] !== $aDataCur['keyword']) {
                            $aTypes = array();
                            if ($aDataCur['type_id'] > 0) {
                                $aTypes[] = $this->getTypeSettings($aDataCur['type_id']);
                            } else {
                                $aTypes = $this->getTypes();
                            }

                            foreach ($aTypes as $type) {
                                $nItemsInCategory = $this->db->select_rows_count($type->tableName(), array('id'=>$nCategoryID));
                                if (!empty($nItemsInCategory)) {
                                    $this->errors->set(_t('afisha', 'Невозможно изменить keyword раздела, посколько с ним уже связаны события'));
                                    break;
                                }
                            }
                        }

                        if ($this->errors->no()) {
                            $this->db->update(TABLE_AFISHA_CATEGORIES, array_diff_key($aData, $this->model->langCategories), array('id'=>$nCategoryID));
                            $this->db->langUpdate($nCategoryID, $aData, $this->model->langCategories, TABLE_AFISHA_CATEGORIES_LANG);
                        }
                    }
                    break;
                    case 'inherit-finish':
                    {
                        $nInheritCategoryID = $this->input->post('inherit', TYPE_UINT);
                        if (!$nInheritCategoryID || !$bInheritAllowed) {
                            $this->errors->impossible();
                        }

                        $bEnabled = $this->input->post('enabled', TYPE_BOOL);

                        $bIsAlreadyInherited = $this->db->select_data(TABLE_AFISHA_CATEGORIES_IN, 'type_id', array(
                            'type_id' => $typeID,
                            'cat_id'  => $nInheritCategoryID,
                        ));
                        if (empty($bIsAlreadyInherited)) {
                            $nNum = $this->categoriesGetCurrentNum($typeID, true);
                            $res = $this->db->insert(TABLE_AFISHA_CATEGORIES_IN, array(
                                'type_id' => $typeID,
                                'cat_id'  => $nInheritCategoryID,
                                'enabled' => $bEnabled,
                                'num'     => $nNum,
                            ), false);
                            if (empty($res)) {
                                $this->errors->impossible();
                            }
                        }

                    }
                    break;
                }

                $sFilter = $this->input->post('filter', TYPE_STR);

                $this->adminRedirect(Errors::SUCCESS, bff::$event . (!empty($sFilter) ? $sFilter : '&type=' . $typeID));
            }
        }

        $aData = $this->validateCategoryData($typeID);
        $aData['id'] = 0;
        $aData['type'] = $typeID;
        $aData['types'] = $this->getTypes();
        $aData['menu_mini'] = $this->menuMini;

        $aData['cats'] = $this->categoriesGet(($typeID ? $oTypeSettings : null), false, false, ($typeID > 0));

        $aData['filter'] = '&' . http_build_query(array('type' => $typeID));
        $aData['inherits'] = $bInheritAllowed;

        if ($typeID) {
            $aData['typeSettings'] = $oTypeSettings;
        }

        $aData['form'] = $this->viewPHP($aData, 'admin.categories.form');

        return $this->viewPHP($aData, 'admin.categories.listing');
    }

    # ---------------------------------------------------------------------------------------------
    # Работа с типами    
    function types_listing()
    {
        if (!FORDEV)
            return $this->showAccessDenied();

        $act = $this->input->get('act');
        if (Request::isAJAX() || !empty($act)) {

            switch ($act) {
                case 'rotate':
                {
                    $this->db->rotateTablednd(TABLE_AFISHA_TYPES, '', 'id', 'num');

                    # сбрасываем кеш настроек типов
                    $this->resetTypeSettingsCache(0, true);
                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'toggle':
                {
                    $typeID = $this->input->postget('rec', TYPE_UINT);
                    if (!$typeID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $this->db->update(TABLE_AFISHA_TYPES, array('enabled = (1 - enabled)'), array('id'=>$typeID));

                    # сбрасываем кеш настроек типа
                    $this->resetTypeSettingsCache($typeID);
                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'delete':
                {
                    $typeID = $this->input->postget('rec', TYPE_UINT);
                    if (!$typeID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $this->deleteType($typeID);
                    # сбрасываем кеш настроек типа
                    $this->resetTypeSettingsCache($typeID);

                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'reset-mod-counters':
                {
                    $update = array('afisha_items_mod_all'=>0, 'afisha_comments_mod_all'=>0);
                    foreach ($this->getTypes() as $k=>$v) {
                        $update['afisha_comments_mod_'.$k] = 0;
                        $update['afisha_items_mod_'.$k] = 0;
                    }
                    config::saveMany($update, true);

                    $this->adminRedirect(Errors::SUCCESS, bff::$event);
                } break;
                case 'items-links-rebuild':
                {
                    $this->model->itemsLinksRebuild();

                    $this->adminRedirect(Errors::SUCCESS, bff::$event);
                } break;
            }
        }

        $aData = $this->db->select_rows(TABLE_AFISHA_TYPES, array('id','keyword','title_'.LNG.' as title','categories','tags','enabled','created'), array(), 'num');
        return $this->viewPHP($aData, 'admin.types.listing');
    }

    function types_add()
    {
        if (!FORDEV)
            return $this->showAccessDenied();

        $this->processTypeSettings($aData, 0);

        if (Request::isPOST()) {

            if ($this->errors->no() &&
                AfishaSettings::pack($aData)
            ) {
                $this->db->langFieldsModify($aData, $this->model->langTypes, $aData);
                $typeID = $this->db->insert(TABLE_AFISHA_TYPES, $aData);

                if ($typeID) {
                    $this->db->update(TABLE_AFISHA_TYPES, array('num'=>$typeID), array('id'=>$typeID));

                    $typeKey = $aData['keyword'];

                    $this->manageTypeFiles($typeKey, 'create');
                    $this->manageTypeTables($typeKey, 'create');

                    $this->adminRedirect(Errors::SUCCESS, 'types_listing');
                }
            }
        }

        $aData['edit'] = false;
        $aData['icategories_options'] = Items::i()->categoryOptions(0, true, 'не указана', 1);

        return $this->viewPHP($aData, 'admin.types.form');
    }

    function types_edit()
    {
        if (!FORDEV)
            return $this->showAccessDenied();

        $typeID = $this->input->get('rec', TYPE_UINT);
        if (!$typeID) $this->adminRedirect(Errors::UNKNOWNRECORD, 'types_listing');

        if (Request::isPOST()) {

            $aDataOLD = $this->getTypeSettings($typeID, true);
            $this->processTypeSettings($aData, $typeID);

            $bChangeKeyword = false;
            if ($this->errors->no()) {
                if ($aDataOLD->keyword != $aData['keyword'] && !empty($aData['keyword'])) {
                    $sImagesPath = $this->getPath($aData['keyword'], 'images');
                    if (file_exists($sImagesPath) ||
                        $this->db->isTable(TABLE_AFISHA_ITEMS_ . $aData['keyword'])
                    ) {
                        $this->errors->set(_t('afisha', '"keyword" типа указан некорректно'));
                    } else {
                        $bChangeKeyword = true;
                    }
                }
            }

            $aDataNEW = $aData;
            if ($this->errors->no() &&
                AfishaSettings::pack($aData)
            ) {
                $aData['modified'] = $this->db->now();
                $this->db->langFieldsModify($aData, $this->model->langTypes, $aData);
                $res = $this->db->update(TABLE_AFISHA_TYPES, $aData, array('id' => $typeID));
                if (!empty($res)) {
                    //сбрасываем кеш настроек типа   
                    $this->resetTypeSettingsCache($typeID);

                    if ($bChangeKeyword) {
                        $this->manageTypeFiles(array(
                                'from' => $aDataOLD->keyword,
                                'to'   => $aDataNEW['keyword']
                            ), 'rename'
                        );
                        $this->manageTypeTables(array(
                                'from' => $aDataOLD->keyword,
                                'to'   => $aDataNEW['keyword']
                            ), 'rename'
                        );
                    }

                    # обрабатываем изменение работы с категориями
                    $categoriesNEW = $aDataNEW['categories'];
                    $categoriesOLD = $aDataOLD->categories;
                    if ($categoriesOLD != $categoriesNEW) {
                        if ($categoriesOLD == 0 && $categoriesNEW > 0) # не было категорий, а теперь включаем
                        {
                            # все объекты типа останутся без привязки к категориям !
                        } else {
                            switch ($categoriesNEW) {
                                case 0: # выключаем категории
                                {
                                    $aDataNEW['categories'] = $categoriesOLD; # не позволим :)
                                }
                                break;
                                case 1: # разрешаем только свои категории
                                {
                                    if ($aDataOLD->categoriesCustomAndCommon()) # если были свои + общие
                                    {
                                        # оставляем свои категории, оставляем наследованные категории.
                                        # некоторые объекты останутся привязанными к общим категориям
                                    } else if ($aDataOLD->categoriesCommonOnly()) # если были только общие
                                    {
                                        # все объекты останутся привязанными к общим категориям
                                    }
                                }
                                break;
                                case 2: # свои + общие
                                {
                                    if ($aDataOLD->categoriesCustomOnly()) # если были только свои
                                    {
                                        $aCurCategories = $this->db->select_rows(TABLE_AFISHA_CATEGORIES, array('id','num'), array('type_id' => $typeID));
                                        $this->db->delete(TABLE_AFISHA_CATEGORIES_IN, array('type_id'=>$typeID));
                                        if (!empty($aCurCategories)) {
                                            $sqlInsert = array();
                                            foreach ($aCurCategories as $v) {
                                                $sqlInsert[] = array(
                                                    'type_id' => $typeID,
                                                    'cat_id'  => $v['id'],
                                                    'num'     => $v['num'],
                                                );
                                            }
                                            if (!empty($sqlInsert)) {
                                                $this->db->multiInsert(TABLE_AFISHA_CATEGORIES_IN, $sqlInsert);
                                            }
                                        }
                                    }
                                    else if ($aDataOLD->categoriesCommonOnly()) # если были только общие
                                    {
                                        # наследуем все общие категории для данного типа
                                        $aCurCategories = $this->db->select_rows(TABLE_AFISHA_CATEGORIES, array('id','num'), array('type_id' => 0));
                                        $this->db->delete(TABLE_AFISHA_CATEGORIES_IN, array('type_id'=>$typeID));
                                        if (!empty($aCurCategories)) {
                                            $sqlInsert = array();
                                            foreach ($aCurCategories as $v) {
                                                $sqlInsert[] = array(
                                                    'type_id' => $typeID,
                                                    'cat_id'  => $v['id'],
                                                    'num'     => $v['num'],
                                                );
                                            }
                                            if (!empty($sqlInsert)) {
                                                $this->db->multiInsert(TABLE_AFISHA_CATEGORIES_IN, $sqlInsert);
                                            }
                                        }
                                    }
                                }
                                break;
                                case 3: # только общие
                                {
                                    if ($aDataOLD->categoriesCustomOnly()) # если были только свои
                                    {
                                        # оставляем свои категории.
                                        # все объекты останутся привязанными к своим категориям
                                    }
                                    else if ($aDataOLD->categoriesCustomAndCommon()) # если были свои + общие
                                    {
                                        # оставляем свои категории, оставляем наследованные категории.
                                        # некоторые объекты останутся привязанными к своим категориям
                                    }
                                }
                                break;
                            }
                        }
                    }


                    $this->adminRedirect(Errors::SUCCESS, 'types_listing');
                }
            }

            AfishaSettings::unpack($aData); # сохранить не удалось, распаковываем
        } else {
            $aData = $this->getTypeSettings($typeID, true, true);
        }

        $aData['edit'] = true;

        $aData['icategories_options'] = Items::i()->categoryOptions(0, true, false, 1);
        $aData['icategories'] = array();
        if (!empty($aData['places']['categories'])) {
            $aICategories = $this->db->select('
                                            SELECT C.id, C.pid, C.title
                                            FROM ' . TABLE_ITEMS_CATEGORIES . ' C
                                            WHERE C.id IN(' . join(',', $aData['places']['categories']) . ')
                                            ORDER BY C.title'
            );
            if (!empty($aICategories)) {
                foreach ($aICategories as $v) {
                    if (!$v['pid']) continue; # только подкатегории
                    $aData['icategories'][$v['id']] = $v['title'];
                }
            }
        }

        return $this->viewPHP($aData, 'admin.types.form');
    }

}