<?php

use bff\img\Thumbnail;
use bff\utils\Files;

class AfishaImages extends Component
{
    var $itemID     = 0;
    var $itemData   = array();
    var $typeID     = 0;
    
    /** @var AfishaSettings object */
    var $typeSettings = array();
    /** @var Afisha object */
    var $oAfisha = null;

    var $tableItems = '';
    var $maxSize    = 5242880; //5мб
    var $saveOriginal = false;
    
    public function __construct(AfishaSettings $oTypeSettings, array $mItemData)
    {
        $this->init();

        $this->itemID   = $mItemData['id'];
        $this->itemData = $mItemData;
        
        $this->typeID       = $oTypeSettings->id;
        $this->typeSettings = $oTypeSettings;
        $this->tableItems   = $oTypeSettings->tableName();
        
        $this->saveOriginal = $this->typeSettings->imgp['orig'];
        $this->oAfisha = bff::module('afisha');
    }

    function upload($sFieldName = 'img')
    {
        do
        {
            if (empty($_FILES[$sFieldName]) || $_FILES[$sFieldName]['error']==UPLOAD_ERR_NO_FILE)
                break;
            
            $oUpload = new CUploader($sFieldName, false);
            if ( ! $this->errors->no()) {
                break;
            }
            
            $sFilenameTmp = $oUpload->getFilenameUploaded();
            # проверяем размер файла
            if ( ! $oUpload->checkSize( $this->maxSize ))
                break;

            # проверяем тип файла
            $aImageSize = getimagesize( $sFilenameTmp );
            $sExtension = Files::getExtension( $oUpload->getFilename() );
            if ($aImageSize===FALSE
                || !in_array($sExtension, array('gif','png','jpg')) 
                || !in_array($aImageSize[2], array(IMAGETYPE_GIF, IMAGETYPE_JPEG, IMAGETYPE_PNG))
              ) {
                $this->errors->setUploadError(Errors::FILE_WRONG_TYPE);
                break;
            }
            
            # сохраняем
            $aResult = $this->save(array(
                    'ext'      => $sExtension,
                    'tmp_name' => $sFilenameTmp,
                ), true);

            if ($aResult!==false && $this->itemID>0)
            {           
                $this->delete(false);
                $this->db->exec('UPDATE '.$this->tableItems.' SET
                                        img = '.$this->db->str2sql($aResult['filename']).', 
                                        img_crop = '.$this->db->str2sql('').'
                                    WHERE id = '.$this->itemID);
            }
                
            return $aResult;
            
        } while(false);
        
        return false;
    }
    
    function save($aUploadData)
    {    
        $sFilename = func::generator(8, true).'.'.$aUploadData['ext'];
        
        $th = new Thumbnail($aUploadData['tmp_name'], false);
        $nWidth  = $th->getOriginalWidth();
        $nHeight = $th->getOriginalHeight();
        $isVertical = $nHeight > $nWidth;  
        $isJPEG = ($aUploadData['ext'] == 'jpg');
        
        if ($nWidth<100 && $nHeight<100) {
            $this->errors->set( _t('afisha', 'Слишком маленькая ширина/высота изображения') );
            return false;
        }
        
        $aSave = array();
        
        $sett = $this->typeSettings->imgp;

        # глобальные настройки водяного знака
        if( ! bff::adminPanel()) {
            $watermark = Site::i()->watermarkSettings();
            $watermarkSettings = array();
            if (!empty($watermark['file']['path'])) {
                $watermarkSettings = array(
                    'watermark' => true,
                    'watermark_src' => $watermark['file']['path'],
                    'watermark_pos_x' => $watermark['pos_x'],
                    'watermark_pos_y' => $watermark['pos_y'],
                );
            }
        }

        
        foreach ($sett['sizes'] as $sz)
        {
            //p, w, h, wm, crop
            $size = array( 'filename'=> $this->buildPath($sz['p'], $sFilename),
                          'width'=>($sz['w']>0?$sz['w']:false), 'height'=>($sz['h']>0?$sz['h']:false),
                          );
            /** 
             * не накладываем watermark на: GIF/PNG изображения
             * пока релизуем только watermark на основе "изображения"
             */
            if ($isJPEG) {
                if ($sz['wm'] && $sett['wm'] == 1) {
                    $size['watermark'] = true;
                    $size['watermark_src'] = PATH_PUBLIC . $sett['wm_img'];
                    $size['watermark_resizable'] = false;
                    $size['watermark_pos_x'] = $sett['wm_pos_x'];
                    $size['watermark_pos_y'] = $sett['wm_pos_y'];
                }else{
                    if( ! bff::adminPanel()) {
                        $size += $watermarkSettings;
                    }
                }
            }

            $aSave[] = $size;
        }

        # сохраняем в оригинальных размерах
        if ( $this->saveOriginal ) {
            copy( $aUploadData['tmp_name'],  $this->buildPath($sett['size_orig'], $sFilename) );
        } 
        
        if ( ! $th->save($aSave) ) {
            return false;
        }
          
        return array (
            'filename' => $sFilename,
            'preview'  => $this->buildPath($sett['size_adm'], $sFilename, true),
        );
    }
    
    function untemp($sFilename)
    {
        if ( ! empty($sFilename))
        {
            $aTmp = array();
     
            $this->itemData['id'] = 0; //tmp path
            $aSizes = $this->typeSettings->imgp['sizes'];
            foreach ($aSizes as $szPrefix=>$v) {
                $aTmp[$szPrefix] = $this->buildPath($szPrefix, $sFilename, false);
            }
            if ($this->saveOriginal) {
                $originalPrefix = $this->typeSettings->imgp['size_orig'];
                $aTmp[$originalPrefix] = $this->buildPath($originalPrefix, $sFilename, false);
            }
            
            $this->itemData['id'] = $this->itemID; //result path
            foreach ($aSizes as $szPrefix=>$v) {
                rename($aTmp[$szPrefix], $this->buildPath($szPrefix, $sFilename, false));
            }
            if ($this->saveOriginal) {
                rename($aTmp[$originalPrefix], $this->buildPath($originalPrefix, $sFilename, false));
            }
        }
    }

    function crop($sFilename, $x, $y, $w, $h)
    {
        $sett = $this->typeSettings->imgp;
        $sOriginalFilepath = $this->buildPath($sett['size_orig'], $sFilename);
        $th = new Thumbnail($sOriginalFilepath, true);
        $nQuality = 85;
        $aSave = array();

        $isJPEG = (Files::getExtension($sFilename) == 'jpg');
        
        foreach ($sett['sizes'] as $sz)
        {
            if ( ! $sz['crop']) continue;

            $size = array( 'filename'=> $this->buildPath($sz['p'], $sFilename),
                           'width'=>($sz['w']>0?$sz['w']:false), 'height'=>($sz['h']>0?$sz['h']:false), 
                           'src_x'=>$x, 'src_y'=>$y, 'crop_width'=>$w, 'crop_height'=>$h, //crop 
                           'autofit'=>false, 'quality'=>$nQuality,
                          );
            /** 
             * не накладываем watermark на: GIF/PNG изображения
             * пока релизуем только watermark на основе "изображения"
             */
            if ($isJPEG && $sz['wm'] && $sett['wm']==1)
            {   
                $size['watermark'] = true;
                $size['watermark_src'] = PATH_PUBLIC . $sett['wm_img'];
                $size['watermark_resizable'] = false;
                $size['watermark_pos_x'] = $sett['wm_pos_x'];
                $size['watermark_pos_y'] = $sett['wm_pos_y'];
            }
            
            $aSave[] = $size;
        }

        if (empty($aSave)) return false;
        if ( ! $th->save($aSave)) return false;
          
        return true;
    }
    
    function delete($bDoQuery = false)
    {
        if ( ! $this->itemID ) {
            return;
        }
        
        $sFilename = $this->db->one_data('SELECT img FROM '.$this->tableItems.' WHERE id = '.$this->itemID);
        if ( ! empty($sFilename))
        {
            $this->deleteFiles($sFilename);
            if ($bDoQuery) {
                $sqlEmpty = $this->db->str2sql('');
                $this->db->exec('UPDATE '.$this->tableItems.'
                    SET img = '.$sqlEmpty.' ,
                        img_crop = '.$sqlEmpty.'
                    WHERE id = '.$this->itemID);
            }
        }
    }
    
    function deleteFiles($sFilename)
    {
        if (empty($sFilename)) return false;
        
        if (is_array($sFilename)) {
            foreach ($sFilename as $file) {
                $this->deleteFiles($file);
            }
            return;
        }

        $sett = $this->typeSettings->imgp;
        
        foreach ($sett['sizes'] as $sz)
        {
            $path = $this->buildPath($sz['p'], $sFilename);
            if (file_exists($path)) unlink($path);
        }
        
        if ($this->saveOriginal) {
            $path = $this->buildPath($sett['size_orig'], $sFilename);
            if (file_exists($path)) unlink($path);
        }
    }

    function buildPath($sSizePrefix = false, $sFilename = false, $bURL = false)
    {
        $aItemData = $this->itemData;
        $aItemData['size'] = $sSizePrefix;
        $aItemData['filename'] = $sFilename;
        
        return $this->oAfisha->getImagesPath($bURL, $aItemData, $this->typeSettings);
    }
    
}