<?php

/**
 * Права доступа группы:
 *  - auto: Авто
 *      - manage: Добавление/Редактирование/Модерация объявлений
 *      - delete: Удаление объявлений
 *      - claims: Жалобы
 *      - settings: Настройки (категории, марки и модели, настройки)
 *      - svc: Услуги
 */

class Auto extends AutoBase
{
    function listing()
    {
        if ( ! $this->haveAccessTo('manage'))
            return $this->showAccessDenied();

        $aData = array('f'=>array());

        $act = $this->input->get('act');
        if (Request::isAJAX() || !empty($act))
        {
            switch ($act)
            {
                case 'delete':
                {
                    if ( ! $this->haveAccessTo('delete'))
                        return $this->showAccessDenied();

                    $nItemID = $this->input->postget('id', TYPE_UINT);
                    if ( ! $nItemID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $res = $this->deleteItem($nItemID);
                    if ( $res ) $this->yandexXML();

                    $this->ajaxResponse( ($res ? Errors::SUCCESS : Errors::IMPOSSIBLE) );
                } break;
                case 'items-links-rebuild':
                {
                    if (FORDEV) {
                        $this->model->itemsLinksRebuild();
                    }

                    $this->adminRedirect(Errors::SUCCESS, bff::$event);
                } break;
                case 'items-delete-all':
                {
                    if (FORDEV) {
                        set_time_limit(0);
                        $this->db->select_rows_chunked(TABLE_AUTO_ITEMS, array('id'), array(), 'id', array(), function($items){
                            foreach ($items as $v) {
                                Auto::i()->deleteItem($v['id']);
                            }
                        });
                        if ( ! $this->errors->no()) {
                            echo '<pre>', print_r($this->errors->get(1,0), true), '</pre>'; exit;
                        }
                    }

                    $this->adminRedirect(Errors::SUCCESS, bff::$event);
                } break;
            }
        }

        $aData['orders'] = array('created'=>'desc');

        $this->input->postgetm(array(
            'page'   => TYPE_UINT,
            'city'   => TYPE_UINT,
            'cat'    => TYPE_UINT,
            'mark'   => TYPE_UINT, 
            'model'  => TYPE_UINT,
            'title'  => TYPE_NOTAGS,
            'status' => TYPE_UINT,
            'p_from' => TYPE_STR,
            'p_to'   => TYPE_STR,
            'user'   => TYPE_UINT,
            'company'=> TYPE_UINT,
        ), $f);

        $sql = array();
        if ($f['city']>0) {
            $sql[] = 'I.city_id = '.$f['city'];
        }
        if ($f['cat']>0) {
            $sql[] = 'I.cat_id = '.$f['cat'];
        }
        if ($f['mark']>0) {
            $sql[] = 'I.mark_id = '.$f['mark'];
        }
        if ($f['model']>0) {
            $sql[] = 'I.model_id = '.$f['model'];
        }
        if ( ! empty($f['title'])) {
            if (intval($f['title'])>0) {
                $sql[] = 'I.id = '.intval($f['title']);
            } else {
                $sql[] = 'I.title2 LIKE '.$this->db->str2sql('%'.$f['title'].'%');
            }
        }        
        switch ($f['status']) {
            case 2: $sql[] = 'I.status = '.self::STATUS_BLOCKED; break;
            case 3: $sql[] = 'I.moderated = 0 AND I.status!='.self::STATUS_NEW; break;
            case 4: $sql[] = 'I.status = '.self::STATUS_PUBLICATED_OUT; break;
            case 1: default:
                $f['status'] = 1; $sql[] = 'I.status = '.self::STATUS_PUBLICATED;
                if(static::premoderation()){
                    $sql[] = 'I.moderated > 0';
                }
                break;
        }

        if ( !empty($f['p_from']) ) {
            $p_from = strtotime($f['p_from']);
            if ( ! empty($p_from)) {
                $sql[] = 'DATE(I.created) >= '.$this->db->str2sql( date('Y-m-d', $p_from) );
            }
        }
        if ( !empty($f['p_to']) ) {
            $p_to = strtotime($f['p_to']);
            if ( ! empty($p_to)) {
                $sql[] = 'DATE(I.created) <= '.$this->db->str2sql( date('Y-m-d', $p_to) );
            }
        }
        if($f['user'] > 0){
            $sql[] = 'I.user_id = '.$f['user'];
        }
        if($f['company'] > 0){
            $sql[] = 'I.company_id = '.$f['company'];
        }


        $sql = join(' AND ', $sql);

        $nCount = $this->db->one_data('SELECT COUNT(*) FROM '.TABLE_AUTO_ITEMS.' I WHERE '.$sql); 
        $this->prepareOrder($orderBy, $orderDirection, 'created-desc', $aData['orders']);
        $this->tplAssigned(array('order_by', 'order_dir', 'order_dir_needed'), $f);
        $f['order'] = $orderBy.'-'.$orderDirection;

        $aData['pgn'] = $this->generatePagenation($nCount, 15, 'autoItems.page({pageId})', $sqlLimit, 'pagenation.ajax.tpl', 'page', true);

        $aData['items'] = $this->db->select('SELECT I.id, I.link, I.title2, I.status, 0 as enabled, I.created, I.moderated,
                U.login as user_login, I.user_id,
                I.mark_id, ML.title as mark_title, CL.id as claims
            FROM '.TABLE_AUTO_ITEMS.' I
                LEFT JOIN '.TABLE_AUTO_CLAIMS.' CL ON I.id = CL.item_id,
                '.TABLE_AUTO_MARKSMODELS.' M,
                '.TABLE_AUTO_MARKSMODELS_LANG.' ML,
                '.TABLE_USERS." U
            WHERE I.mark_id = M.id AND U.user_id = I.user_id AND $sql ".$this->db->langAnd(true, 'M', 'ML')."
            GROUP BY I.id
            ORDER BY I.$orderBy $orderDirection $sqlLimit");

        $aData['f'] = $f;
        $aData['list'] = $this->viewPHP($aData, 'admin.items.listing.ajax');

        if (Request::isAJAX()) {
            $this->ajaxResponse( array(
                'list'   => $aData['list'],
                'pgn'    => $aData['pgn'],
                'filter' => $f,
            ) );
        }

        $aData['cats']   = $this->categoriesGet(false, false, array('sel'=>$f['cat'], 'empty'=>'Все категории'), false);
        $aData['marks']  = ($f['cat']  > 0 ? $this->getMarksOptions($f['cat'], $f['mark'], 'Все марки') : '<option value="0">Все марки</option>' );
        $aData['models'] = ($f['mark'] > 0 ? $this->getModelsOptions($f['mark'], $f['model'], 'Все модели') : '<option value="0">Все модели</option>' );

        if($f['user']){
            $aUser = Users::model()->userData($f['user'], array('login', 'email'));
            $aData['agent_title'] = '#'.$f['user'].' '.$aUser['login'].' ('.$aUser['email'].')';
        }

        tpl::includeJS('datepicker', true);
        tpl::includeJS('autocomplete', true);

        return $this->viewPHP($aData, 'admin.items.listing');
    }
    
    function edit()
    {
        $nItemID = $this->input->getpost('id', TYPE_UINT);
        if ( ! $nItemID) $this->adminRedirect(Errors::UNKNOWNRECORD);

        if (Request::isAJAX())
        {
            $aResponse = array('success'=>false);
            
            do 
            {

                $this->input->postm(array(
                    'cat_id'      => TYPE_UINT,  // тип
                    'mark_id'      => TYPE_UINT, // марка
                    'model_id'     => TYPE_UINT, // модель
                    'price'        => TYPE_PRICE, // цена
                    'price_params' => TYPE_ARRAY_UINT, // цена: параметры; торг...
                    'price_curr'   => TYPE_UINT, // цена: валюта
                    'city_id'      => TYPE_UINT, // город
                    'filename'     => TYPE_ARRAY_NOTAGS, // фотографии
                    'info'         => array(TYPE_NOTAGS, 'len'=>10000), // доп. информация
                ), $aData);
                
                if ( ! $aData['cat_id']) {
                    $this->errors->set( _t('auto', 'Выберите тип') );
                }
                if ( ! $aData['mark_id']) {
                    $this->errors->set( _t('auto', 'Укажите марку') );
                }
                if ( ! $aData['model_id']) {
                    $this->errors->set( _t('auto', 'Укажите модель') );
                }
                if ( ! $aData['price']) {
                    $this->errors->set( _t('auto', 'Укажите цену') );
                }
                if ( ! $aData['price_curr']) {
                    $this->errors->set( _t('auto', 'Укажите валюту') );
                }
                if ( ! $aData['city_id']) {
                    $this->errors->set( _t('auto', 'Укажите город') );
                }
            
                if ( ! $this->errors->no()) break;

                // сохраняем объявление
                $this->model->itemSave($nItemID, $aData, 'd');

                $this->yandexXML();

            } while(false);
            
            $aResponse['res'] = $this->errors->no();
            $this->ajaxResponse($aResponse);
        }
        $aData = $this->db->one_array('SELECT I.*, 
                                    U.email as user_email, U.blocked as user_blocked, 
                                    R.title_'.LNG.' as city_title,
                                    CL.title as cat_title
                              FROM '.TABLE_AUTO_ITEMS.' I,
                                   '.TABLE_USERS.' U,
                                   '.TABLE_REGIONS.' R,
                                   '.TABLE_AUTO_CATEGORIES.' C,
                                   '.TABLE_AUTO_CATEGORIES_LANG.' CL
                              WHERE I.id = '.$nItemID.' 
                                AND U.user_id = I.user_id 
                                AND I.city_id = R.id
                                AND I.cat_id = C.id '.
                                $this->db->langAnd(true, 'C', 'CL'));
            
        if (empty($aData)) {
            $this->adminRedirect(Errors::IMPOSSIBLE);
        }

        $aData['curr'] = Site::currencyOptions($aData['price_curr']);
        $aData['marks'] = $this->getMarksOptions($aData['cat_id'], $aData['mark_id'], false);
        $aData['models'] = $this->getModelsOptions($aData['mark_id'], $aData['model_id'], false);
        $aData['dp'] = $this->dpForm($aData['cat_id'], false, $aData);
        if ($aData['company_id']) {
            $aData['aCompanyInfo'] = Users::model()->companyInfo($aData['user_id'], $aData['company_id']);
        }

        tpl::includeJS(array('qquploader'), true);
        return $this->viewPHP($aData, 'admin.items.edit');
    }
    
    function ajax()
    {
        switch ($this->input->get('act'))
        {
            case 'marks-options': 
            {
                $nCatID = $this->input->post('cat', TYPE_UINT);
                $aData['marks'] = ( $nCatID > 0 ? $this->getMarksOptions( $nCatID, 0, 'все марки') : '' );
                $this->ajaxResponse($aData);
            } break;
            case 'models-options': 
            {
                $nMarkID = $this->input->post('mark', TYPE_UINT);
                $aData['models'] = ( $nMarkID > 0 ? $this->getModelsOptions( $nMarkID, 0, 'все модели') : '' );
                $this->ajaxResponse($aData);
            } break;
            case 'item-block': // counters=ok
            {   
                if ( ! $this->haveAccessTo('manage'))
                    return $this->showAccessDenied();

                $sReason = $this->input->postget('blocked_reason', TYPE_NOTAGS);
                $sReason  = mb_strcut( $sReason, 0, 300);
                
                $nBlocked = $this->input->post('blocked', TYPE_UINT);
                $nItemID  = $this->input->post('id', TYPE_UINT);
                if ( ! $nItemID) break;
                
                $aData = $this->db->one_array('SELECT id, status, cat_id, mark_id, model_id FROM '.TABLE_AUTO_ITEMS.' WHERE id = '.$nItemID);
                if (empty($aData)) break;

                $res = $this->db->exec('UPDATE '.TABLE_AUTO_ITEMS.'
                               SET blocked_reason = :reason,
                                   moderated = 1
                                   '.( ! $nBlocked ? ',
                                   blocked_num = blocked_num + 1,
                                   status_prev = status,
                                   status = '.self::STATUS_BLOCKED.'
                                   ':'').'
                               WHERE id = '.$nItemID, array(':reason'=>$sReason));
                               
                if ( ! empty($res) && !$nBlocked && $aData['status'] == self::STATUS_PUBLICATED && static::premoderation()) {
                    $this->itemsCounterUpdate($aData['cat_id'], $aData['mark_id'], $aData['model_id'], false);
                }

                $this->yandexXML();

                $this->ajaxResponse( Errors::SUCCESS );
            } break;
            case 'item-approve': // counters=ok
            {   
                if ( ! $this->haveAccessTo('manage'))
                    return $this->showAccessDenied();

                $nItemID = $this->input->post('id', TYPE_UINT);
                if ( ! $nItemID) break;
                $aItemData = $this->db->one_array('SELECT cat_id, mark_id, model_id, status, publicated, publicated_to FROM '.TABLE_AUTO_ITEMS.' WHERE id = '.$nItemID);
                if (empty($aItemData) || $aItemData['status'] == self::STATUS_NEW) break;
                
                $sql = '';
                if ($aItemData['status'] == self::STATUS_BLOCKED) {
                    $newStatus = self::STATUS_PUBLICATED_OUT;
                    $now = time();
                    $from = strtotime($aItemData['publicated']);
                    $to = strtotime($aItemData['publicated_to']);
                    if ( ! empty($from) && !empty($to) && $now>=$from && $now<$to) {
                        $newStatus = self::STATUS_PUBLICATED;
                    }
                    $sql = ', status_prev = status, status = '.$newStatus;
                }
                
                $res = $this->db->exec('UPDATE '.TABLE_AUTO_ITEMS.'
                               SET moderated = 1'.$sql.'
                               WHERE id = '.$nItemID);

                if ( ! empty($res) && !empty($newStatus) && $aItemData['status']!=$newStatus && $newStatus == self::STATUS_PUBLICATED) {
                    $this->itemsCounterUpdate($aItemData['cat_id'], $aItemData['mark_id'], $aItemData['model_id'], true);
                }

                $this->yandexXML();

                $this->ajaxResponse( Errors::SUCCESS );
            } break;
            case 'item-publicate2': // counters=ok
            {
                if ( ! $this->haveAccessTo('manage'))
                    return $this->showAccessDenied();

                $nItemID = $this->input->post('id', TYPE_UINT);
                if ( ! $nItemID) { $this->ajaxResponse(Errors::IMPOSSIBLE); }
                
                $aItem = $this->db->one_array('SELECT id, status, moderated, publicated, publicated_to, cat_id, mark_id, model_id
                        FROM '.TABLE_AUTO_ITEMS.' WHERE id = '.$nItemID.' AND status != '.self::STATUS_NEW);
                if (empty($aItem)) break;
        
                if ($aItem['status'] == self::STATUS_BLOCKED) {
                    if ($aItem['moderated'] == 0) {
                        $this->errors->set( _t('auto', 'Невозможно продлить публикацию, поскольку объявление ожидает проверки') );
                    } else {
                        $this->errors->set( _t('auto', 'Невозможно продлить публикацию, поскольку объявление отклонено') );
                    }
                    break;
                }
                
                if ($aItem['status'] == self::STATUS_PUBLICATED) {
                    $this->errors->set( _t('auto', 'Невозможно продлить публикацию, поскольку объявление опубликовано') );
                    break;
                }
            
                $nPeriod = $this->input->post('period', TYPE_UINT);
                $publicateTo = $this->preparePublicatePeriodTo( $nPeriod, 
                                ( $aItem['status'] == self::STATUS_PUBLICATED_OUT ? time() : strtotime($aItem['publicated_to']) ) );
                if (empty($publicateTo)) {
                    $this->errors->set( _t('auto', 'Период публикации указан не корректно') );
                    break;
                }
                    
                if ( $aItem['status'] == self::STATUS_PUBLICATED_OUT )
                {
                    $toOld = strtotime( $aItem['publicated_to'] );
                    /* если разница между датой снятия с публикации и текущей датой
                     * более 3 дней, тогда поднимаем объявление вверх.
                     * в противном случае: оставлем дату старта публикации(pulicated) и дату порядка публикации(publicated_order) прежними
                     */
                    $bUpdatePublicatedOrder = ((time() - $toOld) > 259200); //60*60*24*3
                    $sqlNOW = $this->db->getNOW();
                    $res = $this->db->exec('UPDATE '.TABLE_AUTO_ITEMS.'
                        SET publicated_to = '.$this->db->str2sql( $publicateTo ).',
                            '.($bUpdatePublicatedOrder ? ' publicated = '.$sqlNOW.', publicated_order = '.$sqlNOW.',' : '').'
                            status_prev = status,
                            status = '.self::STATUS_PUBLICATED.',
                            moderated = 1
                        WHERE id = '.$nItemID.'
                    ');
                    
                    if ( ! empty($res)) {
                        # накручиваем счетчики кол-ва опубликованных объявлений:
                        $this->itemsCounterUpdate($aItem['cat_id'], $aItem['mark_id'], $aItem['model_id'], true);
                        $this->yandexXML();
                        $this->ajaxResponse(Errors::SUCCESS);
                    }

                } else {
                    // продление опубликованных пока НЕ делаем
//                        $res = $this->db->exec('UPDATE '.TABLE_AUTO_ITEMS.'
//                            SET publicated_to = '.$this->db->str2sql( $publicateTo ).'
//                            WHERE id = '.$nItemID.'
//                        ');
                }
            } break;
            case 'item-unpublicate': // counters=ok
            {
                if ( ! $this->haveAccessTo('manage'))
                    return $this->showAccessDenied();

                $nItemID = $this->input->post('id', TYPE_UINT);
                if ( ! $nItemID) { $this->ajaxResponse(Errors::IMPOSSIBLE); }
                
                $aItem = $this->db->one_array('SELECT id, status, cat_id, mark_id, model_id
                        FROM '.TABLE_AUTO_ITEMS.' WHERE id = '.$nItemID.' AND status = '.self::STATUS_PUBLICATED);
                if (empty($aItem)) break;
                if ($aItem['status'] != self::STATUS_PUBLICATED) break;

                $res = $this->db->exec('UPDATE '.TABLE_AUTO_ITEMS.'
                            SET status_prev = status, status = '.self::STATUS_PUBLICATED_OUT.', moderated = 1,
                                publicated_to = '.$this->db->getNOW().' 
                        WHERE id='.$nItemID);
                if ( ! empty($res)) {
                    # откручиваем счетчики кол-ва опубликованных объявлений:
                    $this->itemsCounterUpdate($aItem['cat_id'], $aItem['mark_id'], $aItem['model_id'], false);
                    $this->yandexXML();
                    $this->ajaxResponse(Errors::SUCCESS);
                }
            } break;
            case 'item-img-upload':
            {
                $nItemID = $this->input->postget('id', TYPE_UINT);
                if ( ! $this->haveAccessTo('manage') || !$nItemID) {
                    $this->ajaxResponse(array('success' => false, 'error'=> $this->errors->getSystemMessage(Errors::ACCESSDENIED) ), 1);
                }

                $aResponse = array();
                $oImages = $this->initImages();
                $aResult = $oImages->uploadImageQQ();
                $aResponse['success'] = ($aResult !== false);
                $aResponse['filename'] = $oImages->saveImageFileCustom($nItemID, $aResult);
                $aResponse['errors'] = $this->errors->get(true);
                $this->ajaxResponse($aResponse, true, false, true);
            } break;
            case 'item-img-delete':
            {
                if ( ! $this->haveAccessTo('manage'))
                    return $this->showAccessDenied();

                $nItemID   = $this->input->post('id', TYPE_UINT);
                $sFilename = $this->input->post('filename', TYPE_STR);
                
                if (empty($sFilename) || !$nItemID) {
                    $this->ajaxResponse(Errors::IMPOSSIBLE);
                }
                
                $this->initImages()->deleteImageFileCustom($nItemID, $sFilename);
                
                $this->ajaxResponse(Errors::SUCCESS);
            } break;
            case 'item-users-autocomplete': # autocomplete
            {
                if (!$this->haveAccessTo('items-listing')) {
                    $this->ajaxResponse(Errors::ACCESSDENIED);
                }
                $sQ = $this->input->post('q', TYPE_NOTAGS);
                $aData = Users::model()->autocomplete($sQ);
                $this->autocompleteResponse($aData, 'user_id', 'title');
            } break;

        }
        $this->ajaxResponse(Errors::IMPOSSIBLE);
    }

    # ------------------------------------------------------------------------------------------
    # категории 

    function categories()
    {
        if ( ! $this->haveAccessTo('settings'))
            return $this->showAccessDenied();

        $tree = $this->categoriesTree();

        $sAct = $this->input->get('act',TYPE_STR);
        if ( ! empty($sAct) || Request::isAJAX())
        {
            switch ($sAct)
            {
                case 'edit':
                {
                    $nCategoryID = $this->input->get('cat_id', TYPE_UINT);
                    if ( ! $nCategoryID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $aData = $this->db->one_array('SELECT * FROM '.TABLE_AUTO_CATEGORIES.' WHERE id = '.$nCategoryID);
                    if (empty($aData)) $this->ajaxResponse(Errors::IMPOSSIBLE);
                    $this->db->langSelect($nCategoryID, $aData, $this->model->langCategories, TABLE_AUTO_CATEGORIES_LANG);
                    $aData['edit'] = true;
                    $aData['parent'] = $this->getParentCategoryOptions($aData['pid']);
                    $aResponse['form'] = $this->viewPHP($aData, 'admin.categories.form');

                    $this->ajaxResponse($aResponse);
                } break;
                case 'toggle':
                {
                    $nCategoryID = $this->input->postget('rec', TYPE_UINT);
                    if ( ! $nCategoryID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $this->model->toggleInt(TABLE_AUTO_CATEGORIES, $nCategoryID, 'enabled');

                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'rotate':
                {
                    $tree->rotateTablednd();
                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'delete':
                {
                    $nCategoryID = $this->input->get('cat_id', TYPE_UINT);
                    if ( ! $nCategoryID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $aData = $this->db->one_array('SELECT C.*, (C.numright - C.numleft) as node, COUNT(I.id) as items 
                            FROM '.TABLE_AUTO_CATEGORIES.' C
                                LEFT JOIN '.TABLE_AUTO_ITEMS.' I ON I.cat_id = C.id 
                            WHERE C.id = '.$nCategoryID);
                            
                    // запрещаем удаление:
                    // - категорий с объявлениями
                    // - категорий с вложенными подкатегориями
                    if ($aData['node']>1 || $aData['items']>0) {
                        $this->showImpossible();
                    }

                    $res = $tree->deleteNode( $nCategoryID );
                    if ( ! empty($res)) {
                        $this->db->delete(TABLE_AUTO_CATEGORIES_LANG, array('id'=>$nCategoryID));
                    }

                    $this->ajaxResponse( ( ! empty($res) ? Errors::SUCCESS : Errors::IMPOSSIBLE) );
                } break;
                case 'dev-ns-valid':
                {
                    # Валидация целостности NestedSets категорий
                    if ( ! FORDEV) return $this->showAccessDenied();
                    return $this->categoriesTree()->validate(true);
                } break;
            }
        } 
        else if (Request::isPOST())
        {

            switch ($this->input->postget('act'))
            {
                case 'add-finish':
                {
                    $aDataAll = $this->categoriesProcessData(true);
                    $aData = array_diff_key($aDataAll, $this->model->langCategories);
                    $aData['title'] = $aDataAll['title'][LNG];

                    $nNewCategoryID = $tree->insertNode($aData['pid']);

                    if ($this->errors->no())
                    {
                        $this->db->update(TABLE_AUTO_CATEGORIES, $aData, array('id'=>$nNewCategoryID));
                        $this->db->langInsert($nNewCategoryID, $aDataAll, $this->model->langCategories, TABLE_AUTO_CATEGORIES_LANG);
                    }
                    
                } break;
                case 'edit-finish':
                {
                    $nCategoryID = $this->input->post('cat_id', TYPE_UINT);
                    if ( ! $nCategoryID) $this->errors->unknownRecord();
                    
                    $aDataCur = $this->db->one_array('SELECT * FROM '.TABLE_AUTO_CATEGORIES.' WHERE id = '.$nCategoryID);
                    if (empty($aDataCur)) $this->errors->unknownRecord();

                    $aDataAll = $this->categoriesProcessData(false);
                    $aData = array_diff_key($aDataAll, $this->model->langCategories);
                    $aData['title'] = $aDataAll['title'][LNG];

                    //попытка изменения keyword'a категории
                    if ($aData['keyword']!==$aDataCur['keyword'])
                    {
                        $nItemsInCategory = $this->db->one_data('SELECT COUNT(*) FROM '.TABLE_AUTO_ITEMS.' WHERE cat_id = '.$nCategoryID);
                        if ( ! empty($nItemsInCategory)) {
                            $this->errors->set( _t('auto', 'Невозможно изменить keyword типа, посколько с ним уже связаны объявления') );
                            break;
                        } else if ( $this->isKeywordExists($aData['keyword'], TABLE_AUTO_CATEGORIES, $nCategoryID) ) {
                            $this->errors->set( _t('auto', 'Данный keyword уже используется') );
                        }
                    }

                    unset($aData['pid']); # невоможно изменить parent
                    
                    if ($this->errors->no())
                    {
                        $this->db->update(TABLE_AUTO_CATEGORIES, $aData, array('id'=>$nCategoryID));
                        $this->db->langUpdate($nCategoryID, $aDataAll, $this->model->langCategories, TABLE_AUTO_CATEGORIES_LANG);
                    }
                } break;
            }

            $this->adminRedirect(Errors::SUCCESS, bff::$event);
        }
        
        $aData = $this->categoriesProcessData(false);
        $aData['id'] = 0;
        $aData['cats'] = $this->db->select('SELECT C.id, CL.title, C.pid, C.enabled, C.numlevel as lvl, (C.numright - C.numleft) as node, COUNT(I.id) as items
           FROM '.TABLE_AUTO_CATEGORIES.' C
                LEFT JOIN '.TABLE_AUTO_ITEMS.' I ON I.cat_id = C.id,
                '.TABLE_AUTO_CATEGORIES_LANG.' CL
           WHERE C.numlevel > 0 '.$this->db->langAnd(true, 'C', 'CL').'
           GROUP BY C.id
           ORDER BY C.numleft');
        $aData['parent'] = $this->getParentCategoryOptions(1);
  
        $aData['dynprops_link'] = $this->adminLink('dynprops_listing');

        $aData['edit'] = false;
        $aData['form'] = $this->viewPHP($aData, 'admin.categories.form');
        return $this->viewPHP($aData, 'admin.categories.listing');
    }
    
    protected function getParentCategoryOptions($nSelectedID = 0)
    {
        $aCategories = $this->db->select('
           SELECT C.id, CL.title, C.numlevel as lvl, (C.numright - C.numleft) as node, COUNT(I.id) as items
           FROM '.TABLE_AUTO_CATEGORIES.' C
                LEFT JOIN '.TABLE_AUTO_ITEMS.' I ON I.cat_id = C.id,
                '.TABLE_AUTO_CATEGORIES_LANG.' CL
           WHERE '.$this->db->langAnd(false, 'C', 'CL').'
           GROUP BY C.id
           HAVING items = 0 AND ( numlevel = 0 OR node > 0) AND numlevel <= 1
           ORDER BY C.numleft');
        $sOptions = '';
        foreach ($aCategories as $v) {
            $sOptions .= '<option value="'.$v['id'].'" '.($v['id'] == $nSelectedID?' selected':'').'>'.($v['lvl']>1 ? str_repeat('&nbsp;&nbsp;', $v['lvl']) :'').$v['title'].'</option>';
        }
        return $sOptions;
    }
    
    # ------------------------------------------------------------------------------------------
    # марки / модели

    function mm_listing()
    {
        if (Request::isAJAX())
        {
            if ( ! $this->haveAccessTo('settings'))
                $this->ajaxResponse(Errors::ACCESSDENIED); 
                        
            switch ($this->input->get('act'))
            {
                case 'toggle':
                {

                    $nRecordID = $this->input->postget('rec', TYPE_UINT);
                    if ( ! $nRecordID) $this->ajaxResponse(Errors::IMPOSSIBLE);
                    $sType = $this->input->postget('type', TYPE_NOTAGS);
                    $res = true;
                    if ($sType == 'enabled') {
                        $aData = $this->db->one_array('SELECT M.id, M.pid, M.enabled, P.enabled as pid_enabled
                                                        FROM '.TABLE_AUTO_MARKSMODELS.' M
                                                            LEFT JOIN '.TABLE_AUTO_MARKSMODELS.' P ON M.pid = P.id
                                                        WHERE M.id='.$nRecordID);
                        if (empty($aData)) $this->ajaxResponse(Errors::IMPOSSIBLE);
                        $res = $this->db->exec('UPDATE '.TABLE_AUTO_MARKSMODELS.' SET enabled=(1-enabled) WHERE id='.$nRecordID);
                    } else if ($sType == 'fav') {
                        $res = $this->db->exec('UPDATE '.TABLE_AUTO_MARKSMODELS.' SET fav=(1-fav) WHERE id='.$nRecordID);
                    }
                    $this->ajaxResponse( ($res?Errors::SUCCESS : Errors::IMPOSSIBLE) ); 
                } break;
                case 'rotate':
                {

                    $res = $this->db->rotateTablednd(TABLE_AUTO_MARKSMODELS, '', 'id', 'num', true, 'pid');
                    $this->ajaxResponse( $res ? Errors::SUCCESS : Errors::IMPOSSIBLE );
                } break;
                case 'models-list':
                {
                    $nMarkID = $this->input->postget('mark', TYPE_UINT);
                    if ( ! $nMarkID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $aData = array();
                    $aData['models'] = $this->db->select('SELECT M.id, M.pid, M.icon, M.enabled, ML.title, M.items
                                               FROM '.TABLE_AUTO_MARKSMODELS.' M,
                                                    '.TABLE_AUTO_MARKSMODELS_LANG.' ML
                                               WHERE M.pid = '.$nMarkID.$this->db->langAnd(true, 'M', 'ML').'
                                               GROUP BY M.id
                                               ORDER BY M.num');

                    $this->ajaxResponse( array('models'=> $this->viewTPL($aData, 'admin.mm.listing.ajax.tpl')) );
                } break;
            }
            $this->ajaxResponse( Errors::IMPOSSIBLE );
        }

        $aData = array();
        $nCatID = $this->input->get('cat', TYPE_UINT);
        
        $sQueryWhere = ' AND M.cat_id = '.$nCatID;
        
        $sState = $this->input->cookie(config::sys('cookie.prefix').'automm_state');
        if ( ! empty($sState)) $aVisibleMarksID = explode(',', $sState);
        if (empty($aVisibleMarksID)) $aVisibleMarksID = array();
        $aVisibleMarksID[] = 0;
        $sQueryWhere .= ' AND '.$this->db->prepareIN('M.pid', $aVisibleMarksID);
   
        # получаем марки / модели
        $sQuery = 'SELECT M.id, M.pid, M.icon, M.enabled, M.fav, ML.title, 0 as items
                   FROM '.TABLE_AUTO_MARKSMODELS.' M,
                        '.TABLE_AUTO_MARKSMODELS_LANG.' ML
                   WHERE M.id!=0 '.$sQueryWhere.$this->db->langAnd(true, 'M', 'ML').'
                   ORDER BY M.pid, M.num';
        $aData['mm']  = $this->db->transformRowsToTree( $this->db->select($sQuery), 'id', 'pid', 'models');

        $aData['cats'] = $this->categoriesGet(false, false, array('sel'=>$nCatID, 'empty'=>'выберите категорию'), false);
        
        $aData['cat'] = $nCatID;
        
        tpl::includeJS('tablednd', true);
        return $this->viewTPL($aData, 'admin.mm.listing.tpl');
    }
    
    function mm_add()
    {
        if ( ! $this->haveAccessTo('settings'))
            return $this->showAccessDenied();
        
        $nCatID = $this->input->getpost('cat', TYPE_UINT);
        if ( ! $nCatID) $this->adminRedirect(Errors::IMPOSSIBLE, 'mm_listing');
        
        $aData = $this->input->postm(array(
            'keyword'   => TYPE_NOTAGS,
            'enabled'   => TYPE_BOOL,
            'mtemplate' => TYPE_BOOL,
        ));
        $this->input->postm_lang($this->model->langMarksModels, $aData);

        if (Request::isPOST())
        {
            $aData['pid'] = $this->input->post('pid', TYPE_UINT);
            if (empty($aData['title'][LNG])) $this->errors->set( _t('auto', 'Укажите название') );

            $this->mmProcessData($aData, 0);
            
            if ($this->errors->no())
            {
                $nNum = (integer)$this->db->one_data('SELECT MAX(num) FROM '.TABLE_AUTO_MARKSMODELS.' WHERE pid = '.$aData['pid']);
             
                $nID = $this->db->insert(TABLE_AUTO_MARKSMODELS, array(
                        'cat_id'  => $nCatID,
                        'pid'     => $aData['pid'],
                        'keyword' => $aData['keyword'],
                        'enabled' => $aData['enabled'],
                        'num'     => ($nNum+1),
                        'mtemplate' => $aData['mtemplate'],
                    ) );

                if ($nID)
                {
                    $this->db->langInsert($nID, $aData, $this->model->langMarksModels, TABLE_AUTO_MARKSMODELS_LANG);
                    $this->mmIconUpdate($nID, false, true);
                }

                $this->adminRedirect(Errors::SUCCESS, 'mm_listing&cat='.$nCatID);
            }  
            $aData = HTML::escape($aData, 'html', array('title', 'keyword', 'mtitle'));
        } else {
            $aData['pid']  = $this->input->get('pid', TYPE_UINT);
        }

        $aData['pid'] = $this->marksmodelsOptions($nCatID, $aData['pid'], false, true); # марки
        $aData['cat'] = $nCatID;
        $aData['cat_title'] = $this->db->one_data('SELECT title FROM '.TABLE_AUTO_CATEGORIES_LANG.' WHERE id = '.$nCatID.' AND lang = '.$this->db->str2sql(LNG));
        $aData['edit'] = false;
        return $this->viewPHP($aData, 'admin.mm.form');
    }
    
    function mm_edit()
    {
        if ( ! $this->haveAccessTo('settings'))
            return $this->showAccessDenied();

        if (Request::isAJAX())
        {
            switch ($this->input->get('act'))
            {
                case 'icon-delete':
                {

                    $nRecordID = $this->input->postget('rec', TYPE_UINT);
                    if ( ! $nRecordID) $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    
                    $res = $this->mmIconDelete($nRecordID, true);
                    $this->ajaxResponse( ($res ? Errors::SUCCESS : Errors::IMPOSSIBLE) ); 
                } break;
            }
            $this->ajaxResponse(Errors::IMPOSSIBLE);
        }
        
        $nRecordID = $this->input->get('rec', TYPE_UINT);
        if ( ! $nRecordID) $this->adminRedirect(Errors::IMPOSSIBLE, 'mm_listing');
            
        $aData = $this->db->one_array('SELECT M.*, M2.id as models
                   FROM '.TABLE_AUTO_MARKSMODELS.' M
                      LEFT JOIN '.TABLE_AUTO_MARKSMODELS.' M2 ON M2.pid = M.id
                   WHERE M.id='.$nRecordID);
        $this->db->langSelect($nRecordID, $aData, $this->model->langMarksModels, TABLE_AUTO_MARKSMODELS_LANG);

        if ( ! $aData) $this->adminRedirect(Errors::IMPOSSIBLE, 'mm_listing');
        if (Request::isPOST())
        {
            $pid_prev = $aData['pid'];
            $this->input->postm(array(
                'pid'       => TYPE_UINT,
                'enabled'   => TYPE_BOOL,
                'keyword'   => TYPE_NOTAGS,
                'mtemplate' => TYPE_BOOL, # использовать базовый шаблон seo
            ), $aData);

            $this->input->postm_lang($this->model->langMarksModels, $aData);

            $this->mmProcessData($aData, $nRecordID);
                                                     
            if ($this->errors->no())
            {   
                $sIconFilename = $this->mmIconUpdate($nRecordID, true, false);
                
                if ($pid_prev != $aData['pid']) {
                    $nNum = (integer)$this->db->one_data('SELECT MAX(num) FROM '.TABLE_AUTO_MARKSMODELS.' WHERE pid = '.$aData['pid']);
                    $nNum++;
                }
                
                $aSqlUpdate = array(
                    'pid'       => $aData['pid'],
                    'keyword'   => $aData['keyword'],
                    'enabled'   => $aData['enabled'],
                    'mtemplate' => $aData['mtemplate'],
                );
                
                if ($sIconFilename!==false) $aSqlUpdate['icon'] = $sIconFilename;
                if (isset($nNum)) $aSqlUpdate['num'] = $nNum;
                
                $this->db->update(TABLE_AUTO_MARKSMODELS, $aSqlUpdate, array('id'=>$nRecordID));
                $this->db->langUpdate($nRecordID, $aData, $this->model->langMarksModels, TABLE_AUTO_MARKSMODELS_LANG);

                $this->adminRedirect(Errors::SUCCESS, 'mm_listing&cat='.$aData['cat_id']);
            }
        }
        
        if ($aData['pid']) {
            # если модель, выводим список марок, для возможности перемещения
            $aData['parent'] = $this->marksmodelsOptions($aData['cat_id'], $aData['pid'], false, false, 1);
        } else {
            if ($aData['models'] == 0) {
                # если марка без моделей, даем возможность сделать ее моделью
                $aData['parent'] = $this->marksmodelsOptions($aData['cat_id'], 0, false, true, 0, false, array($nRecordID));
            }
        }
        $aData['edit'] = true;
        
        $aData['cat_title'] = $this->db->one_data('SELECT title FROM '.TABLE_AUTO_CATEGORIES_LANG.' WHERE id = '.$aData['cat_id'].' AND lang = '.$this->db->str2sql(LNG));

        return $this->viewPHP($aData, 'admin.mm.form');
    }

    function mm_delete()
    {
        if ( ! $this->haveAccessTo('settings'))
            return $this->showAccessDenied();

        $nRecordID = $this->input->getpost('id', TYPE_UINT);
        if ( ! $nRecordID) $this->adminRedirect(Errors::UNKNOWNRECORD, 'mm_listing');

        $aData = $this->db->one_array('SELECT * FROM '.TABLE_AUTO_MARKSMODELS.' WHERE id='.$nRecordID);
        if (empty($aData)) $this->adminRedirect(Errors::IMPOSSIBLE, 'mm_listing');
                               
        if ($aData['pid']==0) {
            $aData['cnt_submm'] = (integer)$this->db->one_data('SELECT COUNT(id)
                                         FROM '.TABLE_AUTO_MARKSMODELS.'
                                         WHERE pid='.$nRecordID.'
                                         GROUP BY pid');
            if ($aData['cnt_submm']>0) {
                $aData['cnt_items'] = (integer)$this->db->one_data('SELECT COUNT(id)
                                             FROM '.TABLE_AUTO_ITEMS.'
                                             WHERE mark_id='.$nRecordID);
            } else {
                $aData['cnt_items'] = 0;
            }
        } else {
            $aData['cnt_submm'] = 0;
            $aData['cnt_items'] = (integer)$this->db->one_data('SELECT COUNT(id)
                                         FROM '.TABLE_AUTO_ITEMS.'
                                         WHERE mark_id = '.$nRecordID);
        }
        
        if ($aData['cnt_items']>0) $this->adminRedirect(Errors::IMPOSSIBLE, 'mm_listing');
        
        if (Request::isPOST())
        {

            if ($aData['pid']>0 || ( ! $aData['pid'] && ! $aData['cnt_submm'])) {
                #удаляем пиктограмму категории
                $this->mmIconDelete($nRecordID);
                #удаляем подкатегорию
                $this->db->exec('DELETE FROM '.TABLE_AUTO_MARKSMODELS.' WHERE id='.$nRecordID);
                $this->db->exec('DELETE FROM '.TABLE_AUTO_MARKSMODELS_LANG.' WHERE id='.$nRecordID);
            } else {
            
                $nNextID = $this->input->post('next', TYPE_UINT);
                if ($nNextID > 0 )
                {
                    #проверяем: ID не равен ID удаляемой, точно ли это марка
                    $nResultID = $this->db->one_data('SELECT id FROM '.TABLE_AUTO_MARKSMODELS.' WHERE id='.$nNextID.' AND pid=0');
                    if ($nResultID != $nNextID || $nNextID==$nRecordID)
                         $this->adminRedirect(Errors::IMPOSSIBLE, 'mm_listing');

                    #перемещаем модели
                    $this->db->exec('UPDATE '.TABLE_AUTO_MARKSMODELS.' SET pid='.$nNextID.' WHERE pid='.$nRecordID);

                    $this->mmIconDelete($nRecordID); //пиктограмма
                    
                    #удаляем 
                    $this->db->exec('DELETE FROM '.TABLE_AUTO_MARKSMODELS.' WHERE id='.$nRecordID);
                    $this->db->exec('DELETE FROM '.TABLE_AUTO_MARKSMODELS_LANG.' WHERE id='.$nRecordID);
                }
                else if ($aData['cnt_submm']>0)
                {
                    #получаем ID моделей
                    $aModelsID = $this->db->select_one_column('SELECT id FROM '.TABLE_AUTO_MARKSMODELS.' WHERE pid='.$nRecordID);
                    $aModelsID = array_merge($aModelsID, array($nRecordID));

                    $this->mmIconDelete($aModelsID); //пиктограмма
                    // $this->db->exec('DELETE FROM '.TABLE_AUTO_MARKSMODELS.' WHERE (id='.$nRecordID.' OR pid='.$nRecordID.') '); //марки и модели
                    $aIDs = $this->db->select_one_column('SELECT id FROM '.TABLE_AUTO_MARKSMODELS.' WHERE (id='.$nRecordID.' OR pid='.$nRecordID.') ');
                    if ( ! empty($aIDs)) {
                        $this->db->exec('DELETE FROM '.TABLE_AUTO_MARKSMODELS.' WHERE id IN ('.join(',', $aIDs).')');
                        $this->db->exec('DELETE FROM '.TABLE_AUTO_MARKSMODELS_LANG.' WHERE id IN ('.join(',', $aIDs).')');
                    }
                }
            }
            
            $this->adminRedirect(Errors::SUCCESS, 'mm_listing');
        }

        $aData['mm'] = $this->db->select('SELECT M.id, ML.title
                                     FROM '.TABLE_AUTO_MARKSMODELS.' M
                                        LEFT JOIN '.TABLE_AUTO_ITEMS.' I ON I.mark_id = M.id,
                                        '.TABLE_AUTO_MARKSMODELS_LANG.' ML
                                     WHERE M.id!='.$nRecordID.' AND M.pid=0 AND I.id IS NULL '.$this->db->langAnd(true, 'M', 'ML').'
                                     ORDER BY ML.title ASC');

        return $this->viewTPL($aData, 'admin.mm.delete.tpl');
    }
    
    # ------------------------------------------------------------------------------------------
    # жалобы 

    function claims()
    {
        if ( ! $this->haveAccessTo('claims') )
            return $this->showAccessDenied();
 
        if (Request::isAJAX())
        {
            switch ($this->input->get('act'))
            {
                case 'delete':
                {

                    $nClaimID = $this->input->post('id', TYPE_UINT);
                    if ($nClaimID)
                    {
                        $aData = $this->db->one_array('SELECT id, viewed FROM '.TABLE_AUTO_CLAIMS.' WHERE id = '.$nClaimID);
                        if (empty($aData)) $this->ajaxResponse(Errors::IMPOSSIBLE);
                        
                        $aResponse = array('counter_update'=>false);
                        $res = $this->db->exec('DELETE FROM '.TABLE_AUTO_CLAIMS.' WHERE id = '.$nClaimID);
                        if ($res && ! $aData['viewed']) {
                            config::saveCount('auto_claims', -1, true);
                            $aResponse['counter_update'] = true;
                        }
                        $aResponse['res'] = $res;
                        $this->ajaxResponse($aResponse);
                    }
                } break; 
                case 'view':
                {
                    $nClaimID = $this->input->post('id', TYPE_UINT);
                    if ($nClaimID) {
                        $res = $this->db->exec('UPDATE '.TABLE_AUTO_CLAIMS.' SET viewed = 1 WHERE id = '.$nClaimID);
                        if ($res) config::saveCount('auto_claims', -1, true);
                        $this->ajaxResponse(Errors::SUCCESS);
                    }
                } break;
            }
            $this->ajaxResponse(Errors::IMPOSSIBLE);
        }

        $this->input->getm(array(
            'item'    => TYPE_UINT,
            'page'    => TYPE_UINT,
            'perpage' => TYPE_UINT,
            'user'    => TYPE_UINT,
        ), $aData);
        
        $sqlWhere = array();
        if ($aData['item']) {
            $sqlWhere[] = 'CL.item_id = '.$aData['item'];
        }
        if($aData['user']) {
            $sqlWhere[] = 'CL.user_id = '.$aData['user'];
        }


        $nCount = $this->db->one_data('SELECT COUNT(CL.id) FROM '.TABLE_AUTO_CLAIMS.' CL '.( ! empty($sqlWhere) ? 'WHERE '.join(' AND ', $sqlWhere) : ''));
        $aOrdersAllowed = array('CL.created'=>'desc');
        $this->prepareOrder($orderBy, $orderDirection, 'CL.created-desc', $aOrdersAllowed);
                                                                            
        $aPerpage = $this->preparePerpage($aData['perpage'], array(20,40,60) );
        
        $aData['order'] = "$orderBy,$orderDirection";
        $sFilter = http_build_query($aData); unset($aData['page']);
        $this->generatePagenation($nCount, $aData['perpage'], $this->adminLink("claims&$sFilter&{pageId}"), $sqlLimit);
        $aData['f'] = $sFilter;

        if ($nCount>0) {
            $sqlWhere[] = 'CL.item_id = I.id ';
            $sqlWhere = ( ! empty($sqlWhere) ? 'WHERE '.join(' AND ', $sqlWhere) : '');
            $aData['complaints'] = $this->db->select('SELECT CL.*, 0 as other, I.link
                        FROM '.TABLE_AUTO_CLAIMS.' CL,
                             '.TABLE_AUTO_ITEMS.' I
                        '.$sqlWhere."
                        ORDER BY $orderBy $orderDirection $sqlLimit");
        } else {
            $aData['complaints'] = array();
        }
        
        $compl = &$aData['complaints'];
        $reasons = $this->getItemClaimReasons();
        if ( ! empty($compl) && !empty($reasons))
        {
            foreach ($compl as $k=>$v)
            {
                $compl[$k]['item_link'] = static::url('view', $v['link']);
                $r = $v['reasons'];
                if ($r==0) continue;

                $r_text = array();
                foreach ($reasons as $rk=>$rv) {
                    if ($rk!=32 && $rk & $r) {
                        $r_text[] = $rv;
                    }
                }
                $compl[$k]['reasons_text'] = join(', ', $r_text);
                $compl[$k]['other'] = $r & 32;
            }
        }

        $aData['perpage'] = $aPerpage;
        $aData['ajaxUrl'] = $this->adminLink('ajax').'&act=';
        if($aData['user']){
            $aUser = Users::model()->userData($aData['user'], array('login', 'email'));
            $aData['user_title'] = '#'.$aData['user'].' '.$aUser['login'].' ('.$aUser['email'].')';
        }
        tpl::includeJS('autocomplete', true);

        return $this->viewTPL($aData, 'admin.claims.listing.tpl');
    }
    
    # ------------------------------------------------------------------------------------------
    # настройки
     
    function settings() // niu
    {
        if ( ! $this->haveAccessTo('settings'))
            return $this->showAccessDenied();

        $sCurrentTab = $this->input->postget('tab', TYPE_STR);
        if (empty($sCurrentTab))
            $sCurrentTab = 'general';
        
        if (Request::isPOST() && $this->input->post('save',TYPE_BOOL))
        {

            $aData = $this->input->post('config', TYPE_ARRAY);
            $this->input->clean_array($aData, array(
                //general
                'view_title'  => TYPE_STR,
                'short_title' => TYPE_STR, 
                'descshort'   => TYPE_STR,
                'descfull'    => TYPE_STR,
            ));

            $this->configSave($aData);
            
            $this->adminRedirect(Errors::SUCCESS, 'settings&tab='.$sCurrentTab );
        }

        $aData = $this->configLoad();
        $aData['tabs'] = array(
            'general'=>array('t'=>'Основные настройки','a'=>0),
        );
        $aData['tabs'][$sCurrentTab]['a'] = 1;
        return $this->viewPHP($aData, 'admin.settings');
    }


    //-------------------------------------------------------------------------------------------------------------------------------
    // Услуги

    public function svc_services()
    {
        if ( ! $this->haveAccessTo('svc'))
            return $this->showAccessDenied();

        $svc = $this->svc()->model;

        if (Request::isAJAX())
        {
            $aResponse = array();

            switch ( $this->input->getpost('act') )
            {
                case 'update':
                {
                    $nSvcID = $this->input->post('id', TYPE_UINT);
                    if ( ! $nSvcID) {
                        $this->errors->unknownRecord();
                        break;
                    }

                    $aData = $svc->svcData( $nSvcID, array('id','type','keyword') );
                    if (empty($aData) || $aData['type'] != Svc::TYPE_SERVICE) {
                        $this->errors->unknownRecord();
                        break;
                    }

                    $this->svcValidateData($nSvcID, Svc::TYPE_SERVICE, $aDataSave);

                    if ( $this->errors->no() ) {
                        $svc->svcSave( $nSvcID, $aDataSave);
                        $aResponse['modified'] = tpl::date_format2(BFF_NOW, true).', <a class="bold desc" href="#" onclick="return bff.userinfo('.User::id().');">'.User::data('login').'</a>';
                    }

                } break;
                default: {
                    $this->errors->impossible();
                } break;
            }

            $this->ajaxResponseForm($aResponse);
        }

        $aData = array(
            'svc' => $svc->svcListing(Svc::TYPE_SERVICE, $this->module_name),
        );

        tpl::includeJS(array('wysiwyg'), true);
        return $this->viewPHP($aData, 'admin.services');
    }

    /**
     * Проверка данных услуги / пакета услуг
     * @param integer $nSvcID ID услуги / пакета услуг
     * @param integer $nType тип Svc::TYPE_
     * @param array $aData @ref проверенные данные
     */
    function svcValidateData($nSvcID, $nType, &$aData)
    {
        $aParams = array(
            'price' => TYPE_PRICE
        );

        if ($nType == Svc::TYPE_SERVICE)
        {
            $aSettings = array(
                'on' => TYPE_BOOL, // включена
            );
            $aSettingsLang = array(
                'description' => TYPE_STR, // описание
            );

            switch ($nSvcID)
            {
                case self::SERVICE_UP:
                {

                } break;
                case self::SERVICE_MARK:
                {

                } break;
                case self::SERVICE_FIX:
                {

                } break;
                case self::SERVICE_VIP:
                {
                    $aSettings['cnt'] = TYPE_UINT;
                } break;
            }

            $aData = $this->input->postm($aParams);
            $aData['settings'] = $this->input->postm($aSettings);
            $this->input->postm_lang($aSettingsLang, $aData['settings']);

            if ( Request::isPOST() )
            {
                //
            }
        }
    }

}