<?php

use bff\db\Dynprops;
use bff\img\Thumbnail;
use bff\utils\Files;
use bff\db\NestedSetsTree;

define('TABLE_AUTO_CATEGORIES',       DB_PREFIX.'auto_categories');
define('TABLE_AUTO_CATEGORIES_LANG',  DB_PREFIX.'auto_categories_lang');
define('TABLE_AUTO_MARKSMODELS',      DB_PREFIX.'auto_marksmodels');
define('TABLE_AUTO_MARKSMODELS_LANG', DB_PREFIX.'auto_marksmodels_lang');
define('TABLE_AUTO_DYNPROPS',         DB_PREFIX.'auto_dynprops');
define('TABLE_AUTO_DYNPROPS_MULTI',   DB_PREFIX.'auto_dynprops_multi');
define('TABLE_AUTO_ITEMS',            DB_PREFIX.'auto_items');
define('TABLE_AUTO_CLAIMS',           DB_PREFIX.'auto_claims'); 
define('TABLE_AUTO_FAV',              DB_PREFIX.'auto_fav');

define('AUTO_MM_ICONS_PATH', PATH_PUBLIC.'files/images/auto/mm/' );
define('AUTO_MM_ICONS_URL',  SITEURL_STATIC.'/files/images/auto/mm/' );

abstract class AutoBase extends Module implements IModuleWithSvc
{
    /** @var AutoModel */
    public $model = null;
    protected $securityKey = 'da96b4815e7f76e8cd3d9011b87bbbff';

    # Типы дополнительных настроек цены
    const TYPE_PRICE_TORG       = 2;

    # Статус объявления
    const STATUS_NEW            = 1; # новое
    const STATUS_PUBLICATED     = 3; # опубликованное
    const STATUS_PUBLICATED_OUT = 4; # истекший срок публикации
    const STATUS_BLOCKED        = 5; # заблокированное

    # ID Услуг
    const SERVICE_UP      = 256;  # поднятие
    const SERVICE_MARK    = 512;  # выделенние
    const SERVICE_FIX     = 1024; # закрепление
    const SERVICE_VIP     = 2048; # vip
    
    public function init()
    {
        parent::init();

        $this->module_title = 'Авто';

        bff::autoloadEx(array(
            'AutoImages' => array('app', 'modules/auto/auto.images.php'),
        ));

        if (bff::adminPanel()) {
            if (strpos(bff::$event, 'dynprops') !== false) {
                $this->dp();
            }
        }
    }

    /**
     * @return Auto
     */
    public static function i()
    {
        return bff::module('auto');
    }

    /**
     * @return AutoModel
     */
    public static function model()
    {
        return bff::model('auto');
    }

    /**
     * Формирование URL
     * @param string $key ключ
     * @param mixed $opts параметры
     * @param boolean $dynamic динамическая ссылка
     * @return string
     */
    public static function url($key = '', $opts = array(), $dynamic = false)
    {
        $base = static::urlBase(LNG, $dynamic);
        switch ($key)
        {
            # Просмотр
            case 'view':
                return strtr($opts, array(
                    '{sitehost}' => SITEHOST . bff::locale()->getLanguageUrlPrefix(),
                ));
                break;
            break;
            # Добавление
            case 'add':
                return $base.'/add'.static::urlQuery($opts);
                break;
            # Редактирование
            case 'edit':
                return $base.'/edit'.static::urlQuery($opts);
                break;
            # Продвижение
            case 'promote':
                return $base.'/promote'.static::urlQuery($opts);
                break;
            # Поиск
            case 'search':
                return $base.'/search'.
                    ( ! empty($opts['cat']) ? '/'.$opts['cat'] : '' ).
                    ( ! empty($opts['mark']) ? '/'.$opts['mark'] : '').
                    ( ! empty($opts['model']) ? '/'.$opts['model'] : '').
                    ( ! empty($opts['q']) ? static::urlQuery($opts['q'], array('cat', 'mark', 'model')) : '');
                break;
            # Автосалоны
            case 'salons':
                return $base.'/salons'.static::urlQuery($opts);
                break;
            # Главная
            case 'index':
                return $base.'/'.static::urlQuery($opts);
                break;
        }
        return $base;
    }

    public static function urlView($id, $keyword = '', $cityID = 0)
    {
        if (empty($keyword)) $keyword = 'item';
        return static::urlBase(LNG, true, array('city'=>$cityID)).'/'.$keyword.'-'.$id.'.html';
    }

    /**
     * Описание seo шаблонов страниц
     * @return array
     */
    public function seoTemplates()
    {
        $aTemplates = array(
            'pages' => array(
                'index' => array( // index
                    't'      => 'Главная страница',
                    'macros' => array(
                        'region' => array('t' => 'Регион'),
                    ),
                    'fields' => array(
                        'titleh1' => array(
                            't'      => 'Заголовок H1',
                            'type'   => 'text',
                        ),
                    ),
                ),
                'search' => array( // search
                    't'      => 'Поиск объявлений',
                    'list'   => true,
                    'inherit'=> true,
                    'macros' => array(
                        'category' => array('t' => 'Название категории'),
                        'region' => array('t' => 'Регион'),
                    ),
                    'fields' => array(
                        'titleh1' => array(
                            't'      => 'Заголовок H1',
                            'type'   => 'text',
                        ),
                    ),
                ),
                'search-mark' => array( // search
                    't'      => 'Поиск объявлений - марка',
                    'list'   => true,
                    'inherit'=> true,
                    'macros' => array(
                        'category' => array('t' => 'Название категории'),
                        'mark' => array('t' => 'Марка автомобилей'),
                        'region' => array('t' => 'Регион'),
                    ),
                    'fields' => array(
                        'titleh1' => array(
                            't'      => 'Заголовок H1',
                            'type'   => 'text',
                        ),
                    ),
                ),
                'search-model' => array( // search
                    't'      => 'Поиск объявлений - модель',
                    'list'   => true,
                    'inherit'=> true,
                    'macros' => array(
                        'category' => array('t' => 'Название категории'),
                        'mark' => array('t' => 'Марка автомобилей'),
                        'model' => array('t' => 'Модель автомобилей'),
                        'region' => array('t' => 'Регион'),
                    ),
                    'fields' => array(
                        'titleh1' => array(
                            't'      => 'Заголовок H1',
                            'type'   => 'text',
                        ),
                    ),
                ),
                'add' => array( // add
                    't'      => 'Добавление объявления',
                    'macros' => array(
                        'region' => array('t' => 'Регион'),
                    ),
                    'fields' => array(
                        'titleh1' => array(
                            't'      => 'Заголовок H1',
                            'type'   => 'text',
                        ),
                    ),
                ),
                'view' => array( // view
                    't'      => 'Просмотр объявления',
                    'macros' => array(
                        'title'  => array('t' => 'Заголовок объявления'),
                        'description'  => array('t' => 'Адрес объявления'),
                        'region' => array('t' => 'Регион'),
                    ),
                    'fields' => array(
                        'share_title'       => array(
                            't'    => 'Заголовок (поделиться в соц. сетях)',
                            'type' => 'text',
                        ),
                        'share_description' => array(
                            't'    => 'Описание (поделиться в соц. сетях)',
                            'type' => 'textarea',
                        ),
                        'share_sitename'    => array(
                            't'    => 'Название сайта (поделиться в соц. сетях)',
                            'type' => 'text',
                        ),
                    ),
                ),
                'salons' => array( // salons
                    't'      => 'Автосалоны',
                    'list'   => true,
                    'macros' => array(
                        'region' => array('t' => 'Регион'),
                    ),
                    'fields' => array(
                        'titleh1' => array(
                            't'      => 'Заголовок H1',
                            'type'   => 'text',
                        ),
                    ),
                ),
            ),
        );

        return $aTemplates;
    }

    /**
     * @return AutoImages объект
     */
    function initImages()
    {
        static $cache = null;
        if ( ! isset($cache)) {
            require_once($this->module_dir.'auto.images.php');
            $cache = new AutoImages();
        }
        return $cache;
    }

    /**
     * Включена ли премодерация объявлений
     * @return boolean
     */
    public static function premoderation()
    {
        return (bool)config::sys('auto.premoderation', true);
    }

    /**
     * ID категории салонов
     * @return int
     */
    public static function salonsCategory()
    {
        return intval(config::sys('auto.salons.category', 93));
    }


    /**
     * Максимально доступное кол-во изображений, прикрепляемых к объявлению
     * @return integer
     */
    public static function imagesLimit()
    {
        return (int)config::sys('auto.images.limit', 8);
    }

    function preparePublicatePeriodTo($nPeriod, $nFrom)
    {
        $dateFormat = 'Y-m-d H:i:s';
        $dateWeek = (60*60 * 24 * 7);
        switch ($nPeriod)
        {
            case 2: $dateTo = date($dateFormat, $nFrom+$dateWeek*2);  break; //2 недели
            case 3: $dateTo = date($dateFormat, $nFrom+$dateWeek*3);  break; //3 недели
            case 4: //1 месяц
           // case 5: //2 месяца
           // case 6: //3 месяца
           // case 9: //6 месяцев
            {
                $dateTo = date($dateFormat, mktime(date('H', $nFrom),date('i', $nFrom),date('s', $nFrom),date('m', $nFrom)+($nPeriod-3),date('d', $nFrom),date('Y', $nFrom)) );  
            } break; 
            case 1: default: $dateTo = date($dateFormat, $nFrom+$dateWeek);  break;   //1 неделя
        }
        return $dateTo;
    }
    
    function getPublicatePeriods()
    {
        $periods = array();
        $week = (60*60 * 24 * 7);
        $from = time();
        $periods[1] = date('d.m.Y', $from + $week);     //1 неделя
        $periods[2] = date('d.m.Y', $from + ($week*2)); //2 неделя
        $periods[3] = date('d.m.Y', $from + ($week*3)); //3 неделя
        $nM = date('m', $from); 
        $nD = date('d', $from); 
        $nY = date('Y', $from);
        $periods[4] = date('d.m.Y', mktime(0,0,0,$nM+1,$nD,$nY)); //1 месяц  
      //  $periods[5] = date('d.m.Y', mktime(0,0,0,$nM+2,$nD,$nY)); //2 месяца  
      //  $periods[6] = date('d.m.Y', mktime(0,0,0,$nM+3,$nD,$nY)); //3 месяца  
      //  $periods[9] = date('d.m.Y', mktime(0,0,0,$nM+6,$nD,$nY)); //6 месяцев  
        
        $options = '<option value="1" selected="selected">'._t('', 'на 1 неделю').'</option>
                    <option value="2">'._t('', 'на 2 недели').'</option>
                    <option value="3">'._t('', 'на 3 недели').'</option>
                    <option value="4">'._t('', 'на 1 месяц').'</option>';
//                    <option value="5">на 2 месяца</option>
//                    <option value="6">на 3 месяца</option>
//                    <option value="9">на 6 месяцев</option>';
        
        return array('dates'=>$periods, 'options'=>$options);
    }

    function getItemClaimReasons()
    {
        return array(
            1  => _t('', 'Неверная контактная информация'),
            2  => _t('', 'Объявление не соответствует рубрике'),
            4  => _t('', 'Объявление не отвечает правилам портала'),
            8  => _t('', 'Некорректная фотография'),
            16 => _t('', 'Антиреклама/дискредитация'),
            32 => _t('', 'Другое'),
        );        
    }
    
    function getItemClaimText($nReasons, $sComment)
    {
        $reasons = $this->getItemClaimReasons();
        if ( ! empty($nReasons) && !empty($reasons))
        {
            $r_text = array();
            foreach ($reasons as $rk=>$rv) {
                if ($rk!=32 && $rk & $nReasons) {
                    $r_text[] = $rv;
                }
            }
            $r_text = join(', ', $r_text);
            if ($nReasons & 32 && !empty($sComment)) {
                $r_text .= ', '.$sComment;
            }
            return $r_text;
        }
        return '';
    }
    
    function itemsCounterUpdate($nCatID, $nMarkID, $nModelID, $bIncrement)
    {
        $this->db->exec('UPDATE '.TABLE_AUTO_CATEGORIES.'
            SET items = items '.($bIncrement?'+ 1':'- 1').'
            WHERE id = '.$nCatID.'
        ');
        
        $this->db->exec('UPDATE '.TABLE_AUTO_MARKSMODELS.'
            SET items = items '.($bIncrement?'+ 1':'- 1').'
            WHERE id = '.$nMarkID.' OR id = '.$nModelID.'
        ');
    }
    
    function getPriceParams()
    {
        return array(
            self::TYPE_PRICE_TORG => _t('', 'возможен торг'),
        );
    }

    /**
     * Метод обрабатывающий событие "активации пользователя"
     * @param integer $nUserID ID активированного пользователя
     */
    function onUserActivated($nUserID)
    {
        /**
         * Активируем объявления, добавленные пользователем и еще неактивированные
         */
         $this->db->update(TABLE_AUTO_ITEMS, array(
            'status' => self::STATUS_PUBLICATED
         ), array(
            'user_id' => $nUserID,
            'status'  => self::STATUS_NEW,
         ));
    }

    function deleteItem($nItemID, $nUserID = false)
    {
        if (empty($nItemID) || $nItemID<=0) return false;
        
        $aData = $this->db->one_array('SELECT id, img, imgcnt, imgfav, user_id, cat_id, mark_id, model_id 
                                FROM '.TABLE_AUTO_ITEMS.' 
                                WHERE id = '.$nItemID);
        if (empty($aData)) return false;
        
        if ( ! empty($nUserID)) {
            if ($aData['user_id']!=$nUserID) {
                return false;
            }
        }
        
        $res = $this->db->delete(TABLE_AUTO_ITEMS, array('id'=>$nItemID));
        if (empty($res)) return false;
        
        # удаляем изображения
        $aImg = ($aData['imgcnt'] && !empty($aData['img']) ? explode(',', $aData['img']) : array());
        $this->initImages()->deleteImagesFiles($nItemID, $aImg);
        
        # откручиваем счетчики кол-ва объявлений в категории/типе
        $this->itemsCounterUpdate($aData['cat_id'], $aData['mark_id'], $aData['model_id'], false);
        
        # удаляем в избранных
        $this->db->delete(TABLE_AUTO_FAV, array('item_id'=>$nItemID));
        
        if ($aData['user_id'] > 0) {
            $this->security->userCounter('auto', -1, ($nUserID!==false ? false : $aData['user_id']));
        }
        
        return true;
    }
    
    function getItemTemplates($nCatID)
    {
        $aCat = $this->db->one_array('SELECT C.id,
            CL.tpl_title_view  as title_view,
            CL.tpl_title_lists as title_lists,
            CL.tpl_descshort   as descshort,
            CL.tpl_descfull    as descfull,
            CL.tpl_vip_header  as vip_header
        FROM '.TABLE_AUTO_CATEGORIES.' C,
             '.TABLE_AUTO_CATEGORIES_LANG.' CL
        WHERE C.id = '.$nCatID.$this->db->langAnd(true, 'C', 'CL'));
        
        if (empty($aCat)) {
            $this->errors->set( _t('auto', 'Тип указан некорректно') ); 
            return array();
        }
        
        $aCat['descshort'] = nl2br($aCat['descshort']);
        $aCat['descfull']  = nl2br($aCat['descfull']);
        
        return $aCat;
    }
    
    function getItemTemplatesExtra($nMarkID, $nModelID, $nCityID)
    {
        $aMarkModel = $this->db->one_array('SELECT ML.title as mark, ML2.title as model
                FROM '.TABLE_AUTO_MARKSMODELS.' M,
                     '.TABLE_AUTO_MARKSMODELS_LANG.' ML,
                     '.TABLE_AUTO_MARKSMODELS.' M2,
                     '.TABLE_AUTO_MARKSMODELS_LANG.' ML2
                WHERE M.id = :mark
                  AND M2.id = :model
                  AND M.id = M2.pid'.
                  $this->db->langAnd(true, 'M', 'ML').
                  $this->db->langAnd(true, 'M2', 'ML2'), array(':mark'=>$nMarkID, ':model'=>$nModelID));

        return array(
            '{mark}'  => ( ! empty($aMarkModel['mark']) ? $aMarkModel['mark'] : ''),
            '{model}' => ( ! empty($aMarkModel['model']) ? $aMarkModel['model'] : ''),
            '{city}'  => Geo::regionTitle($nCityID),
        );
    }
    
    # ----------------------------------------------------------------------------------------------------
    # динамические свойства
    
    /**
     * Инициализация компонента работы с дин. свойствами
     * @return \bff\db\Dynprops объект
     */
    function dp()
    {
        static $oDp = null;
        if (isset($oDp)) return $oDp;

        $oDp = $this->attachComponent('dynprops',
            new Dynprops('owner_id',
                TABLE_AUTO_CATEGORIES, TABLE_AUTO_DYNPROPS, TABLE_AUTO_DYNPROPS_MULTI,
                1 /* полное наследование */) );

        $oDp->setSettings(array(
            'module_name'=>'auto',
            'cache_method'=>'Auto_dpSettingsUpdated',
            'datafield_int_first'  => 1,
            'datafield_int_last'   => 17,
            'datafield_text_first' => 18,
            'datafield_text_last'  => 20,
            'ownerTableType'=>'ns',
            'typesAllowed'=>array(
                Dynprops::typeCheckboxGroup,
                Dynprops::typeRadioGroup,
                Dynprops::typeRadioYesNo,
                Dynprops::typeCheckbox,
                Dynprops::typeSelect,
                //  Dynprops::typeSelectMulti,
                Dynprops::typeInputText,
                Dynprops::typeTextarea,
                Dynprops::typeNumber,
                Dynprops::typeRange,
            ), 'typesAllowedParent'=>array(),
            'langs' => $this->locale->getLanguages(false)
        ));
    
        return $oDp;
    }
    
    /**
     * Получаем дин. свойства категории
     * @param integer $nCategoryID id категории
     * @param boolean $bResetCache обнулить кеш
     * @return mixed
     */
    function dpSettings($nCategoryID, $bResetCache = false)
    {
        if ($nCategoryID <= 0) return array();
        
        $cache = Cache::singleton($this->module_name, 'file');
        $cacheKey = 'cats-dynprops-'.LNG.'-'.$nCategoryID;
        if ($bResetCache) {
            # сбрасываем кеш настроек дин. свойств категории
            return $cache->delete($cacheKey);
        } else {
            if ( ($aSettings = $cache->get($cacheKey)) === false ) { # ищем в кеше
                $aSettings = $this->dp()->getByOwner($nCategoryID, true, true, false);
                $cache->set($cacheKey, $aSettings); # сохраняем в кеш
            }
            return $aSettings;
        }
    }
    
    /**
    * Метод вызываемый модулем bff\db\Dynprops, в момент изменения настроек дин. свойств категории
    * @param integer $nCategoryID id категории
    * @param integer $nDynpropID id дин.свойства
    * @param string $sEvent событие, генерирующее вызов метода
    * @return mixed
    */
    function dpSettingsUpdated($nCategoryID, $nDynpropID, $sEvent)
    {
        if (empty($nCategoryID)) return false;
        $this->dpSettings($nCategoryID, true);
    }

    /**
     * Формирование формы редактирования/фильтра дин.свойств
     * @param integer $nCategoryID ID категории
     * @param boolean $bSearch формирование формы поиска
     * @param array $aData данные
     * @return string HTML template
     */
    function dpForm($nCategoryID, $bSearch = true, $aData = array(), $aExtra = array())
    {
         if (empty($nCategoryID)) return '';

         if ($bSearch) {
            if ( ! bff::adminPanel()) {
                $aForm = $this->dp()->form($nCategoryID, $aData, true, true, 'f', 'dynprops.search', $this->module_dir_tpl, $aExtra);
            } else {
                $aForm = $this->dp()->form($nCategoryID, $aData, true, true, 'd', 'search.inline', false, $aExtra);
            }
         } else {
            if (  ! bff::adminPanel() ) {
                $aForm = $this->dp()->form($nCategoryID, $aData, true, false, 'd', 'dynprops.form', $this->module_dir_tpl, $aExtra);
            } else {
                $aForm = $this->dp()->form($nCategoryID, $aData, true, false, 'd', 'form.table', false, $aExtra);
            }
         }
         return ( ! empty($aForm['form']) ? $aForm['form'] : '');
    }

    function dpSave($nCategoryID, array $aItemData, $sFieldname = 'd')
    {
        $aData = $this->input->post($sFieldname, TYPE_ARRAY);

        $aDynpropsData = array();
        foreach ($aData as $props) {
            foreach ($props as $id=>$v) {
                $aDynpropsData[$id] = $v;
            }
        }

        $dpSettings = $this->dpSettings($nCategoryID);

        // подготавливаем значения дин. свойств для сохранения
        $aResult = $this->dp()->prepareSaveDataByID($aDynpropsData, $dpSettings, 'insert/update', true);
        // сохраняем шаблоны описаний записи
        $aTpl = $this->dp()->prepareTemplateByCacheKeys($aDynpropsData, $dpSettings,
                    $this->getItemTemplates($nCategoryID),
                    $this->getItemTemplatesExtra($aItemData['mark_id'], $aItemData['model_id'], $aItemData['city_id']) );

        return array_merge(array(
            'title'  => $aTpl['title_view'],
            'title2' => $aTpl['title_lists'],
            'descshort' => $aTpl['descshort'],
            'descfull' => $aTpl['descfull'],
            'vip_header' => $aTpl['vip_header'],
        ), $aResult);
    }

    function dpPrepareSelectFieldsQuery($sPrefix = '', $nOwnerID = 0)
    {
        if (empty($nOwnerID) || $nOwnerID<0) {
            return '';
        }

        $fields = array();
        foreach ($this->dpSettings($nOwnerID) as $v)
        {
            $f = $sPrefix.$this->dp()->datafield_prefix.$v['data_field'];
            if (!empty($v['cache_key'])) {
               $f .= ' as `'.$v['cache_key'].'`';
            }
             $fields[] = $f;
        }
        return (!empty($fields) ? ', ' . join(', ', $fields) : '');
    }

    // -----------------------------------------------------------------------------------------------
    // марки / модели
    
    function getMarksOptions($nCatID = 0, $nSelectedID = 0, $sEmptyTitle = false)
    {
        if ( ! $sEmptyTitle) $sEmptyTitle = _t('','Выбрать');
        $aData = $this->db->select('SELECT M.id, ML.title
                FROM '.TABLE_AUTO_MARKSMODELS.' M,
                     '.TABLE_AUTO_MARKSMODELS_LANG.' ML
                WHERE M.cat_id = '.$nCatID.' AND M.enabled = 1 AND M.pid = 0 '.$this->db->langAnd(true, 'M', 'ML').'
                ORDER BY title ASC');
                
        $sOptions = '';
        if ($sEmptyTitle!==false) {
            $sOptions .= '<option value="0">'.$sEmptyTitle.'</option>';
        }
        foreach ($aData as $v) {
            $sOptions .= '<option value="'.$v['id'].'"'.($nSelectedID==$v['id']?' selected="selected"':'').'>'.$v['title'].'</option>';
        }
        return $sOptions;
    }
    
    function getModelsOptions($nMarkID, $nSelectedID = 0, $sEmptyTitle = 'Выбрать')
    {
        $aData = $this->db->select('SELECT M.id, ML.title
                FROM '.TABLE_AUTO_MARKSMODELS.' M,
                     '.TABLE_AUTO_MARKSMODELS_LANG.' ML
                WHERE M.enabled = 1 AND M.pid = '.$nMarkID.$this->db->langAnd(true, 'M', 'ML').'
                ORDER BY title ASC');
                
        $sOptions = '';
        if ($sEmptyTitle!==false) {
            $sOptions .= '<option value="0">'.$sEmptyTitle.'</option>';
        }
        foreach ($aData as $v) {
            $sOptions .= '<option value="'.$v['id'].'"'.($nSelectedID==$v['id']?' selected="selected"':'').'>'.$v['title'].'</option>';
        }
        return $sOptions;
    }
    
    /**
     * @param integer $nCatID ID выбранной марки
     * @param bool $bIncludingModels выключая модели
     * @param bool $mAddRoot включая корень
     * @param integer $nType 0 - все, 1 - только марки без моделей
     * @param bool $bOnlyEnabled только включенные марки/модели
     * @param array $aIgnoreID ID игнорируемых марок/моделей
     * @return string select::options
     */
    function marksmodelsOptions($nCatID, $nParentID=null, $bIncludingModels=true, $mAddRoot=false, $nType=0, $bOnlyEnabled=false, $aIgnoreID = array())
    {
        $sDisabledStyle = 'style="color: #999;"';
        $sSelectPart = 'M.id, ML.title, M.pid, M.enabled';
        $aIgnoreID = $this->db->prepareIN('M.id', $aIgnoreID, true);

        $sParentOptions ='';
        if ($bIncludingModels)
        {
            $aData = $this->db->transformRowsToTree( $this->db->select('SELECT '.$sSelectPart.'
                                     FROM '.TABLE_AUTO_MARKSMODELS.' M,
                                          '.TABLE_AUTO_MARKSMODELS_LANG.' ML
                                     WHERE M.cat_id = '.$nCatID.$aIgnoreID.($bOnlyEnabled?' WHERE M.enabled=1 ':'').
                                                       $this->db->langAnd(true, 'M', 'ML').'
                                     ORDER BY M.num'), 'id', 'pid', 'models');

            foreach ($aData as $v)
            {
                $bOptgroup = ($nType == 1 && !empty($v['models']));
                if ($bOptgroup)
                {
                    $sParentOptions .= '<optgroup label="'.$v['title'].'">';
                } else {
                    $sParentOptions .= '<option value="'.$v['id'].'" pid="'.$v['pid'].'"'.($nParentID == $v['id']?' selected ':'').( ! $v['enabled']?$sDisabledStyle:'').'>'.$v['title'].'</option>';
                }
                
                if ( ! empty($v['models'])) {
                    foreach ($v['models'] as $v2) {
                        $sParentOptions .= '<option style="padding-left:20px;" '.( ! $v2['enabled']?$sDisabledStyle:'').' value="'.$v2['id'].'" pid="'.$v2['pid'].'"'.($nParentID == $v2['id']?' selected ':'').'>'.$v2['title'].'</option>';
                    }
                }

                if ($bOptgroup) {
                    $sParentOptions .= '</optgroup>';
                }
            }
        }
        else
        {
            $aData = $this->db->select('
                SELECT '.$sSelectPart.'
                FROM '.TABLE_AUTO_MARKSMODELS.' M,
                     '.TABLE_AUTO_MARKSMODELS_LANG.' ML
                WHERE M.cat_id = '.$nCatID.' AND M.pid=0 AND '.$aIgnoreID.
                      $this->db->langAnd(true, 'M', 'ML').'
                ORDER BY M.num');
            foreach ($aData as $v)
                $sParentOptions .= '<option value="'.$v['id'].'" pid="'.$v['pid'].'"'.($nParentID == $v['id']?' selected ':'').( ! $v['enabled']?$sDisabledStyle:'').'>'.$v['title'].'</option>';
        }
        
        if ($mAddRoot)
             $sParentOptions = '<option style="font-weight:bold;" value="0">'.($mAddRoot === TRUE ? _t('','корневой раздел') : $mAddRoot).'</option>'.$sParentOptions;
        
        return $sParentOptions;
    }
    
    function mmIconUpdate($nID, $bDeletePrevious=false, $bDoUpdateQuery = false, $sFieldName = 'icon')
    {
        if ($nID && !empty($_FILES) && !empty($_FILES[$sFieldName]['name']))
        {
            if ($bDeletePrevious)
                $this->mmIconDelete($nID);

            $aImageSize = getimagesize($_FILES[$sFieldName]['tmp_name']);
            $sExtension = Files::getExtension( $_FILES[$sFieldName]['name'] );
            
            if ($aImageSize!==FALSE && in_array($aImageSize[2], array(IMAGETYPE_GIF, IMAGETYPE_JPEG, IMAGETYPE_PNG))
                && in_array($sExtension, array('gif','jpg','png')) )
            {   
                $sFilename  = $nID.$sExtension;

                # 25x25
                $th = new Thumbnail($_FILES[$sFieldName]['tmp_name'], false);
                $th->save(array(array(
                    'width'=>25,'height'=>25,
                    'filename'=>AUTO_MM_ICONS_PATH.$sFilename,
                )));

                if ($bDoUpdateQuery) {
                    $this->db->exec('UPDATE '.TABLE_AUTO_MARKSMODELS.' SET icon=:icon WHERE id='.$nID, array(':icon'=>$sFilename));
                }
                
                return $sFilename;
            } 
        }
        return false;
    }

    function mmIconDelete($mID, $bDoUpdateQuery = false)
    {
        if ( ! empty($mID))
        {
            if (is_array($mID))
            {
                $mID = array_map('intval', $mID);
                $aFilenames = $this->db->select_one_column('SELECT icon FROM '.TABLE_AUTO_MARKSMODELS.' WHERE id IN ('.implode(',', $mID).') ');
                if ( ! empty($aFilenames))
                {
                    foreach ($aFilenames as $file) {
                        if ( ! empty($file))
                            @unlink(AUTO_MM_ICONS_PATH.$file);
                    } 
                    if ($bDoUpdateQuery) {
                        $this->db->exec('UPDATE '.TABLE_AUTO_MARKSMODELS.' SET icon='.$this->db->str2sql('').' WHERE id IN ('.implode(',', $mID).') ');
                    }
                    return true;
                }
            } else {
                $mID = intval($mID);
                
                $sFilename = $this->db->one_data('SELECT icon FROM '.TABLE_AUTO_MARKSMODELS.' WHERE id='.$mID);   
                if ( ! empty($sFilename)) {
                    @unlink(AUTO_MM_ICONS_PATH.$sFilename);
                    if ($bDoUpdateQuery) {
                        $this->db->exec('UPDATE '.TABLE_AUTO_MARKSMODELS.' SET icon='.$this->db->str2sql('').' WHERE id = '.$mID.' ');
                    }
                    return true;
                }
            }
        }
        return false;
    }
    
    function mmProcessData(&$aData, $nRecordID = 0)
    {
        $aData['mtitle'][LNG] = strtr($aData['mtitle'][LNG], array('\\'=>'',"'"=>'','"'=>'',"\r"=>'',"\n"=>''));
        if ($aData['keyword'] == '') {
            $this->errors->set( _t('auto', 'Keyword категории указан некорректно') );
        } else if ($this->isKeywordExists($aData['keyword'], TABLE_AUTO_MARKSMODELS, $nRecordID) ) {
            $this->errors->set( _t('auto', 'Данный keyword уже используется') );
        }
    }

    # ----------------------------------------------------------------------------------------------------
    # категории
               
    /**
    * Обрабатываем параметры категории
    */
    function categoriesProcessData($bNew)
    {
        $aParams = array(
            'pid'          => TYPE_UINT,   # основная категория
            'keyword'      => TYPE_NOTAGS, # keyword
            'enabled'      => TYPE_BOOL,   # включена ли категория
            'mtemplate'    => TYPE_BOOL,   # использовать базовый шаблон seo
        );
        $aData = $this->input->postm($aParams);
        $this->input->postm_lang($this->model->langCategories, $aData);

        if (Request::isPOST())
        {
            if ($aData['title'][LNG] == '') {
                $this->errors->set( _t('auto', 'Название категории указано некорректно') );
            }
            if ($aData['keyword'] == '') {
                $this->errors->set( _t('auto', 'Keyword категории указан некорректно') );
            } else if ( $bNew && $this->isKeywordExists($aData['keyword'], TABLE_AUTO_CATEGORIES, 0) ) {
                $this->errors->set( _t('auto', 'Данный keyword уже используется') );
            }
        }
        return $aData;
    }

    /**
    * @param boolean $bEnabled только включенные категории
    * @param array|boolean $sqlFields необходимые параметры
    * @param mixed $mOptions false - возвращать массив категорий, array(sel, empty) - возвращать html <options>
    * @param boolean $bCountItems подсчитывать ли кол-во записей в категориях
    * @return mixed (string | array)
    */
    function categoriesGet($bEnabled = true, $sqlFields = array('C.*'), $mOptions = false, $bCountItems = false)
    {
        $bUsePadding = true;
        $bGetOptions = !empty($mOptions);
        $bCountItems = ($bCountItems && !$bGetOptions);

        if ($bGetOptions) $sqlSelect = array('C.id','CL.title','C.numlevel','C.numleft','C.numright');
        else {
            $sqlSelect = ($sqlFields ? $sqlFields : array('C.*'));
            if ($bCountItems) $sqlSelect[] = 'COUNT(I.id) as items';
        }
        $sqlSelect = join(',', $sqlSelect);

        $sqlWhere = array();
        $sqlWhere[] = 'C.numlevel>0';
        if ($bEnabled) $sqlWhere[] = 'C.enabled = 1';
        
        if ($bCountItems) {
            $aCategories = $this->db->select('SELECT '.$sqlSelect.'
                    FROM '.TABLE_AUTO_CATEGORIES.' C 
                        LEFT JOIN '.TABLE_AUTO_ITEMS.' I ON I.cat_id = C.id,
                         '.TABLE_AUTO_CATEGORIES_LANG.' CL
                    WHERE '.join(' AND ', $sqlWhere).$this->db->langAnd(true, 'C', 'CL').'
                    GROUP BY C.id 
                    ORDER BY C.numleft');
        } else {
            $aCategories = $this->db->select('SELECT '.$sqlSelect.'
                       FROM '.TABLE_AUTO_CATEGORIES.' C,
                            '.TABLE_AUTO_CATEGORIES_LANG.' CL
                       WHERE '.join(' AND ', $sqlWhere).$this->db->langAnd(true, 'C', 'CL').'
                       GROUP BY C.id
                       ORDER BY C.numleft');
        }


        if ($bGetOptions)
        {
            $sHTML = '';   
            if ( ! $mOptions['sel'] && $mOptions['empty']===false) $mOptions['empty'] = true;
            if ( ! empty($mOptions['empty']))
            {
                $sHTML .= '<option value="0">'.(is_string($mOptions['empty']) ? $mOptions['empty'] : _t('','не указан')).'</option>';
            }
            
            foreach ($aCategories as $v) {
                $nl = $v['numlevel'];
                $disable = (($v['numright']-$v['numleft']) != 1);
                $sHTML .= '<option value="'.$v['id'].'" '.
                                ($bUsePadding && $nl>1 ? 'style="padding-left:'.($nl*10).'px;" ':'').
                                ($v['id'] == $mOptions['sel']?' selected':'').
                                ($disable ? ' disabled' : '').
                                '>'.( ! $bUsePadding && $nl>1 ? str_repeat('&nbsp;&nbsp;', $nl) :'').$v['title'].'</option>';
            }
            return $sHTML;
        } else {
            if ( ! bff::adminPanel() ) {
                return func::array_transparent($aCategories, 'id', true);
            }
            return $aCategories;
        }
    }
    
    /** @return NestedSetsTree компонент */
    function categoriesTree()
    {
        static $cache;
        if ( ! isset($cache)) {
            $cache = new NestedSetsTree( TABLE_AUTO_CATEGORIES );
            $cache->init();
        }
        return $cache;
    }
    
    # ----------------------------------------------------------------------------------------------------
    # common
    
    /**
     * Проверка существования ключа
     * @param string $sKeyword ключ
     * @param string $sTable таблица
     * @param integer $nExceptRecordID исключая записи (ID)
     * @returns integer
     */ 
    function isKeywordExists($sKeyword, $sTable, $nExceptRecordID = null)
    {
        return $this->db->one_data('SELECT id
                               FROM '.$sTable.'
                               WHERE '.( ! empty($nExceptRecordID)? ' id!='.intval($nExceptRecordID).' AND ' : '' ).'
                                  keyword='.$this->db->str2sql($sKeyword).'  LIMIT 1');
    }
    
    /**
     * Проверка ключа / Формирование ключа исходя из заголовка
     * @param string $sKeyword ключ
     * @param string $sTitle заголовок
     * @param string $sTable таблица
     * @param integer $nExceptRecordID исключая записи (ID)
     * @returns string ключ
     */ 
    function getKeyword($sKeyword = '', $sTitle = '', $sTable, $nExceptRecordID = null)
    {
        if (empty($sKeyword) && !empty($sTitle)) {
            //$sTitle = preg_replace('|\[link\](.*)\[/link\]|i', '', $sTitle);
            $sKeyword = mb_strtolower( func::translit( $sTitle ) );
        }
        
        $sKeyword = preg_replace('/[^a-zA-Z0-9_\-\']/','',$sKeyword);
        if (empty($sKeyword)){
             $this->errors->set( _t('', 'Укажите keyword') );
        } else {
            //if ($this->isKeywordExists($sKeyword, $sTable, $nExceptRecordID))
            //    $this->errors->set( 'Указанный keyword уже используется' );
        }
        
        return $sKeyword;
    }

    # --------------------------------------------------------
    # Активация услуг

    function svcActivate($nItemID, $nSvcID, $aSvcData = false, array &$aSvcSettings = array())
    {
        $svc = $this->svc();
        if ( ! $nSvcID ) {
            $this->errors->set(_t('svc', 'Неудалось активировать услугу'));
            return false;
        }
        if ( empty($aSvcData) ) {
            $aSvcData = $svc->model->svcData($nSvcID);
            if ( empty($aSvcData) ) {
                $this->errors->set(_t('svc', 'Неудалось активировать услугу'));
                return false;
            }
        }

        // получаем данные об объявлении
        if ( empty($aItemData) ) {
            $aItemData = $this->model->itemData($nItemID, array(
                            'id','status',// ID, статус
                            'publicated_to', // дата окончания публикации
                            'svc', // битовое поле активированных услуг
                            'marked_to', // дата окончания "Выделение"
                            'fixed_to', // дата окончания "Закрепления"
                            'vip_to', // дата окончания "VIP"
                            ));
        }

        // проверяем статус объявления
        if ( empty($aItemData) || $aItemData['status'] != self::STATUS_PUBLICATED ) {
            $this->errors->set( _t('auto', 'Для указанного объявления невозможно активировать данную услугу') );
            return false;
        }

        // активируем услугу
        return $this->svcActivateService($nItemID, $nSvcID, $aSvcData, $aItemData, $aSvcSettings);
    }

    /**
     * Активация услуги для объявления
     * @param integer $nItemID ID объявления
     * @param integer $nSvcID ID услуги
     * @param mixed $aSvcData данные об услуге(*) или FALSE
     * @param mixed $aItemData @ref данные об объявлении или FALSE
     * @param array $aSvcSettings @ref дополнительные параметры услуги/нескольких услуг
     * @return boolean true - услуга успешно активирована, false - ошибка активации услуги
     */
    protected function svcActivateService($nItemID, $nSvcID, $aSvcData = false, &$aItemData = false, array &$aSvcSettings = array())
    {
        if ( empty($nItemID) || empty($aItemData) || empty($nSvcID) ) {
            $this->errors->set(_t('svc', 'Неудалось активировать услугу'));
            return false;
        }
        $svc = $this->svc();
        if ( empty($aSvcData) ) {
            $aSvcData = $svc->model->svcData($nSvcID);
            if ( empty($aSvcData) ) {
                $this->errors->set(_t('svc', 'Неудалось активировать услугу'));
                return false;
            }
        }

        $sNow = $this->db->now();
        $publicatedTo = strtotime($aItemData['publicated_to']);
        $aUpdate = array();
        switch ($nSvcID)
        {
            case self::SERVICE_UP: // "поднятие"
            {
                $aUpdate['publicated_order'] = $sNow;
            } break;
            case self::SERVICE_MARK: // "выделение"
            {
                $nDays = 7; // период действия услуги (в днях)

                // считаем дату окончания действия услуги
                $to = strtotime('+'.$nDays.' days', (
                                // если услуга уже активна => продлеваем срок действия
                                ($aItemData['svc'] & $nSvcID) ? strtotime($aItemData['marked_to']) :
                                // если неактивна => активируем на требуемый период от текущей даты
                                time()
                            ));
                $toStr = date('Y-m-d H:i:s', $to);
                // в случае если дата публикация объявления завершается раньше окончания услуги:
                if ($publicatedTo < $to) {
                    // продлеваем публикацию
                    $aUpdate['publicated_to'] = $toStr;
                }
                // помечаем срок действия услуги
                $aUpdate['marked_to'] = $toStr;
                // помечаем активацию услуги
                $aUpdate['svc'] = ($aItemData['svc'] | $nSvcID);
            } break;
            case self::SERVICE_FIX: // "закрепление"
            {
                $nDays = 7; // период действия услуги (в днях)

                // считаем дату окончания действия услуги
                $to = strtotime('+'.$nDays.' days', (
                                // если услуга уже активна => продлеваем срок действия
                                ($aItemData['svc'] & $nSvcID) ? strtotime($aItemData['fixed_to']) :
                                // если неактивна => активируем на требуемый период от текущей даты
                                time()
                            ));
                $toStr = date('Y-m-d H:i:s', $to);
                // в случае если дата публикация объявления завершается раньше окончания услуги:
                if ($publicatedTo < $to) {
                    // продлеваем публикацию
                    $aUpdate['publicated_to'] = $toStr;
                }
                // помечаем срок действия услуги
                $aUpdate['fixed_to'] = $toStr;
                // ставим выше среди закрепленных
                $aUpdate['fixed_order'] = $sNow;
                // помечаем активацию услуги
                $aUpdate['svc'] = ($aItemData['svc'] | $nSvcID);
            } break;
            case self::SERVICE_VIP: // "vip"
            {
                $nDays = 7; // период действия услуги (в днях)

                // считаем дату окончания действия услуги
                $to = strtotime('+'.$nDays.' days', (
                                // если услуга уже активна => продлеваем срок действия
                                ($aItemData['svc'] & $nSvcID) ? strtotime($aItemData['vip_to']) :
                                // если неактивна => активируем на требуемый период от текущей даты
                                time()
                            ));
                $toStr = date('Y-m-d H:i:s', $to);
                // в случае если дата публикация объявления завершается раньше окончания услуги:
                if ($publicatedTo < $to) {
                    // продлеваем публикацию
                    $aUpdate['publicated_to'] = $toStr;
                }
                // помечаем срок действия услуги
                $aUpdate['vip_to'] = $toStr;
                // помечаем активацию услуги
                $aUpdate['svc'] = ($aItemData['svc'] | $nSvcID);
            } break;
        }

        $res = $this->model->itemSave($nItemID, $aUpdate);
        if ( ! empty($res) ) {
            // актуализируем данные об объявлении
            // для корректной пакетной активации услуг
            if ( ! empty($aUpdate) ) {
                foreach ($aUpdate as $k=>$v) {
                    $aItemData[$k] = $v;
                }
            }
            return true;
        }
        return false;
    }

    function svcBillDescription($nItemID, $nSvcID, $aData = false, array &$aSvcSettings = array())
    {
        $aSvc = ( ! empty($aData['svc']) ? $aData['svc'] :
                    $this->svc()->model->svcData($nSvcID) );

        $aItemData = $this->model->itemData($nItemID, 'link');
        $sItemLink = static::url('view', $aItemData['link']);

        list($sLinkOpen, $sLinkClose) = ( ! empty($sItemLink) ? array('<a href="'.$sItemLink.'" class="bill-auto-item-link" data-item="'.$nItemID.'">', '</a>') : array('','') );

        if ($aSvc['type'] == Svc::TYPE_SERVICE)
        {
            switch ($nSvcID)
            {
                case self::SERVICE_UP:   { return _t('auto', 'Поднятие [a]объявления[b] в списке', array('a'=>$sLinkOpen,'b'=>$sLinkClose)); } break;
                case self::SERVICE_MARK: { return _t('auto', 'Выделение [a]объявления[b] цветом', array('a'=>$sLinkOpen,'b'=>$sLinkClose)); } break;
                case self::SERVICE_FIX:  { return _t('auto', 'Закрепление [a]объявления[b]', array('a'=>$sLinkOpen,'b'=>$sLinkClose)); } break;
                case self::SERVICE_VIP:  { return _t('auto', 'VIP [a]объявление[b]', array('a'=>$sLinkOpen,'b'=>$sLinkClose)); } break;
            }
        }
    }

    function svcIsVIPEnabled(&$aData = array())
    {
        static $cache;
        if ( ! isset($cache) ) {
            $cache = Svc::model()->svcData(self::SERVICE_VIP);
        }
        $aData = $cache;
        return ! empty( $cache['on'] );
    }

    function svcCron()
    {
        if ( ! bff::cron() ) return;

        $sNow = $this->db->now();
        $sEmpty = '0000-00-00 00:00:00';

        # Деактивируем услугу "Выделение"
        $this->db->exec('UPDATE '.TABLE_AUTO_ITEMS.'
            SET svc = (svc - '.self::SERVICE_MARK.'), marked_to = :empty
            WHERE (svc & '.self::SERVICE_MARK.') AND marked_to <= :now',
            array(':now'=>$sNow,':empty'=>$sEmpty));

        # Деактивируем услугу "Закрепление"
        $this->db->exec('UPDATE '.TABLE_AUTO_ITEMS.'
            SET svc = (svc - '.self::SERVICE_FIX.'), fixed_to = :empty, fixed_order = :empty
            WHERE (svc & '.self::SERVICE_FIX.') AND fixed_to <= :now',
            array(':now'=>$sNow,':empty'=>$sEmpty));

        # Деактивируем услугу "VIP"
        $this->db->exec('UPDATE '.TABLE_AUTO_ITEMS.'
            SET svc = (svc - '.self::SERVICE_VIP.'), vip_to = :empty
            WHERE (svc & '.self::SERVICE_VIP.') AND vip_to <= :now',
            array(':now'=>$sNow,':empty'=>$sEmpty));
    }

    function yandexXML()
    {
        # Легковые автомобили
        $catID = 2;
        $aItems = $this->db->select('SELECT I.id, I.link, I.created, I.modified,
                I.user_name, I.user_phone, R.title_'.LNG.' as city,
                I.price, C.keyword as price_type, I.price_params,
                AM1L.title as mark, AM2L.title as model
                '.$this->dpPrepareSelectFieldsQuery('I.', $catID).'
            FROM '.TABLE_AUTO_ITEMS.' I
                 INNER JOIN '.TABLE_AUTO_MARKSMODELS.' AM1 ON I.mark_id = AM1.id
                     INNER JOIN '.TABLE_AUTO_MARKSMODELS_LANG.' AM1L ON '.$this->db->langAnd(false, 'AM1', 'AM1L').'
                 INNER JOIN '.TABLE_AUTO_MARKSMODELS.' AM2 ON I.model_id = AM2.id
                     INNER JOIN '.TABLE_AUTO_MARKSMODELS_LANG.' AM2L ON '.$this->db->langAnd(false, 'AM2', 'AM2L').'
                 INNER JOIN '.TABLE_REGIONS.' R ON I.city_id = R.id
                 INNER JOIN '.TABLE_CURRENCIES.' C ON I.price_curr = C.id
            WHERE I.status = '.self::STATUS_PUBLICATED.'
              AND I.cat_id = :catID
            ORDER BY I.id DESC
        ', array(':catID'=>$catID));

        if ( empty($aItems) ) return;
        $dateFormat = 'Y-m-d G:i:s O';
        $aOffers = array();
        foreach ($aItems as $v)
        {
            # URL-адрес страницы с объявлением.
            $sOffer  = '<url>'.htmlspecialchars( static::url('view', $v['link']) ).'</url>';
            # Дата создания объявления.
            $sOffer .= '<date>'.htmlspecialchars(date($dateFormat, strtotime($v['created']))).'</date>';
            # Дата обновления объявления
            $sOffer .=  '<update-date>'.htmlspecialchars(date($dateFormat, strtotime($v['modified']))).'</update-date>';
            # Марка автомобиля
            $sOffer .= '<mark>'.htmlspecialchars($v['mark']).'</mark>';
            # Модель автомобиля
            $sOffer .= '<model>'.htmlspecialchars($v['model']).'</model>';
            # Год выпуска автомобиля.
            $sOffer .= '<year>'.htmlspecialchars($v['year']).'</year>';
            # Имя продавца.
            $sOffer .= '<seller>'.htmlspecialchars($v['user_name']).'</seller>';
                # Город, продавца автомобиля.
                $sOffer .= '<seller-city>'.htmlspecialchars($v['city']).'</seller-city>';
                # Контактный телефон продавца автомобиля.
                $sOffer .= '<seller-phone>'.htmlspecialchars($v['user_phone']).'</seller-phone>';
            # Цена автомобиля.
            $sOffer .= '<price>'.htmlspecialchars($v['price']).'</price>';
                # Торг (возможен, невозможен, ...).
                if ($v['price_params'] & self::TYPE_PRICE_TORG) { $sOffer .= '<haggle>'.htmlspecialchars('Возможен').'</haggle>'; }
                # Валюта, в которой измеряется цена (RUR, USD, EUR ...).
                $sOffer .= '<currency-type>'.htmlspecialchars($v['price_type']).'</currency-type>';
            # Объем двигателя.
            $sOffer .= '<displacement>'.htmlspecialchars($v['volume']).'</displacement>';
            # Пробег автомобиля.
            $sOffer .= '<run>'.htmlspecialchars($v['probeg']).'</run>';
                # Размерность, в которой измеряется пробег (км, тыс.км, миль ...).
                $sOffer .= '<run-metric>'.htmlspecialchars('км').'</run-metric>';
            # Положение руля (левый, правый).
            $sOffer .= '<steering-wheel>'.htmlspecialchars($v['steering'] == 1 ? 'Левый' : 'Правый').'</steering-wheel>';
            # Примечание о наличии (в наличии, на заказ, с доставкой...).
            $sOffer .= '<stock></stock>';
            # Тип объявления – частное («private») или коммерческое («commercial»).
            $sOffer .= '<type>'.htmlspecialchars('private').'</type>';

            $aOffers[] = '<offer>'.$sOffer.'</offer>';
        }

        $sXML = strtr('<?xml version="1.0" encoding="windows-1251"?>
            <auto-catalog>
                <creation-date>{created}</creation-date>
                <host>{host}</host>
                <offers>{offers}</offers>
            </auto-catalog>', array(
            '{created}' => date($dateFormat),
            '{host}'    => SITEHOST,
            '{offers}'  => join('', $aOffers),
        ));

        Files::putFileContent(PATH_PUBLIC.'rss/yandex-auto.xml', $sXML);
    }

    /**
     * Обработка ситуации c необходимостью ре-формирования URL
     */
    public function onLinksRebuild()
    {
        $this->model->itemsLinksRebuild();
    }

    /**
     * Формирование списка директорий/файлов требующих проверки на наличие прав записи
     * @return array
     */
    public function writableCheck()
    {
        return array_merge(parent::writableCheck(), array(
            bff::path('auto', 'images') => 'dir', # изображения
            PATH_PUBLIC.'rss'           => 'dir', # rss файлы
            PATH_PUBLIC.'rss'.DS.'yandex-auto.xml' => 'file-e', # yandex-auto.xml
        ));
    }
}