<?php

class M_BBS
{
    static function declareAdminMenu(CMenu $menu, Security $security)
    {
        $sMenuTitle = 'Доска объявлений';

        # Объявления
        if( $security->haveAccessToModuleToMethod('bbs','items') )
        {
            $menu->assign($sMenuTitle, 'Объявления', 'bbs', 'items', true, 10,
                    array('rlink'=>array('event'=>'items&act=add') ));
        }

        # Комментарии
        if (BBS::commentsEnabled() && $security->haveAccessToModuleToMethod('bbs','items-comments')) {
            $menu->assign($sMenuTitle, 'Комментарии', 'bbs', 'comments_mod', true, 14, array( 'counter' => 'bbs_comments_mod' ));
        }

        # Жалобы
        if ($security->haveAccessToModuleToMethod('bbs','claims-listing')) {
            $menu->assign($sMenuTitle, 'Жалобы', 'bbs', 'claims', true, 15, array( 'counter' => 'bbs_claims' ));
        }

        # Категории
        if( $security->haveAccessToModuleToMethod('bbs','categories') )
        {
            $menu->assign($sMenuTitle, 'Категории', 'bbs', 'categories', true, 20,
                    array('rlink'=>array('event'=>'categories&act=add') ));

            $menu->assign($sMenuTitle, 'Типы категорий', 'bbs', 'types', false, 21);

            # Дин. свойства
            $menu->assign($sMenuTitle, 'Дин. св-ва категорий', 'bbs', 'dynprops_listing', false, 25);
            $menu->assign($sMenuTitle, 'Дин. св-ва категорий', 'bbs', 'dynprops_action', false, 26);
        }

        # Услуги
        if ($security->haveAccessToModuleToMethod('bbs','svc')) {
            $menu->assign($sMenuTitle, 'Услуги', 'bbs', 'svc_services', true, 30);
        }

        # SEO
        if ($security->haveAccessToModuleToMethod('bbs', 'seo')) {
            $menu->assign('SEO', $sMenuTitle, 'bbs', 'seo_templates_edit', true, 5);
        }

        # Настройки
        if ($security->haveAccessToModuleToMethod('bbs', 'settings')) {
            $menu->assign($sMenuTitle, 'Настройки', 'bbs', 'settings', true, 60);
        }

    }

}
