<?php
    $imgWidth = $img->getSizeWidth(BBSItemImages::szMini) + 5;
    $imgHeight = $img->getSizeHeight(BBSItemImages::szMini) + 5;
?>

<form method="post" action="" id="item-form-images">
<div class="relative">
    <div class="left">
        <div class="desc">
            Выберите фотографии на Вашем компьютере<br />
            Размер одной фотографий не должен превышать <?= $img->getMaxSize(true); ?>.
            <div id="item-img-upload" style="height: 15px; width: 130px"><a href="javascript:void(0);" class="ajax">Загрузить фотографии</a></div>
            <div id="item-img-uploader" style="margin-top: 10px;"></div>
        </div>
    </div>
    <div class="clear"></div>
    <span id="progress-images" class="progress" style="display:none; position: absolute; right:0; top:5px;"></span>
</div>

<ul id="item-images" style="display: block; width: 700px;">
<? foreach($images as $v) { if($v) { $imageID = $v['id']; $fn = $v['filename']; ?>
    <li class="wimg wimg<?= $imageID; ?> relative left" style="width:<?= $imgWidth ?>px; height: <?= $imgHeight ?>px;">
        <input type="hidden" class="imgfn" name="img[<?= $imageID ?>]" rel="<?= $imageID ?>" value="<?= $fn ?>" />
        <a href="<?= $img->getURL($v, BBSItemImages::szView, false); ?>" rel="wimg-group">
            <img src="<?= $img->getURL($v, BBSItemImages::szMini, false); ?>" />
        </a>
        <a class="but cross" style="position:absolute;right:2px;bottom:7px;" href="#" onclick="if(confirm('Удалить изображение?')) return jItemImages.del('<?= $imageID; ?>', '<?= $fn ?>'); return false;"></a>
    </li>
<? } } if (empty($images) && false) { ?><li style="margin:15px; font-weight: bold; width:100%; text-align: center;">нет фотографий</li><? } ?>
</ul>
<div class="clear"></div>

<div class="nophoto-hide" style="<? if($imgcnt<1){ ?>display:none;<? } ?>">
    <div class="desc" style="margin-bottom: 5px;">перетяните фото для изменения порядка<b>&nbsp;&nbsp;&harr;</b></div>
    <div>
        <? if($edit) { ?>
            <input type="button" class="btn btn-success button submit" value="Сохранить порядок" onclick="jItemImages.save();" />
            <input type="button" class="btn clr-error delete button submit" onclick="if(confirm('Удалить все фотографии?')) jItemImages.delAll(true, []);" value="Удалить все фотографии" />
        <? } ?>
    </div>
</div>

</form>

<script type="text/javascript">
var jItemImages = (function(){
    var uploader, id = <?= $id ?>, url = '<?= $this->adminLink('img&item_id='.$id.'&act='); ?>';
    var $form, $img, $progress;
    
    $(function() {
        $form = $('#item-form-images');
        $progress = $('#form-progress');
        $img = $('#item-images', $form);
        
        // init uploader
        uploader = new qq.FileUploaderBasic({
            button: $('#item-img-upload', $form).get(0),
            action: url+'upload',
            limit: <?= $img->getLimit(); ?>,
            uploaded: <?= $imgcnt ?>,
            multiple: true,
            onSubmit: function(id, fileName) {
                $progress.show();
            },
            onComplete: function(id, fileName, data) {
                if(data && data.success) {
                    onImageUpload(data);
                } else {
                    if(data.errors) {
                        bff.error( data.errors );
                    }
                }
                if(!uploader.getInProgress()) {
                    $progress.hide();
                }
                return true;
            }
        });
        
        initRotate(false);

        $('a[rel=wimg-group]', $form).fancybox();        
        
        $form.on('click', 'span.wimg-title', function(){
            var imageID = intval( $(this).attr('rel') );
            if(!titleOld[imageID]) {
                editBegin( imageID, $(this) );
            }
        });
        $form.on('click', 'input.wimg-titleedit-finish', function(){
            var $block = $(this).parent();
            var imageID = $block.attr('rel');
            var title = $('[name="title"]', $block).val();
            bff.ajax(url+'title', {image_id: imageID, title: title}, function (data) {
                if(data) {
                    var noTitle = (data.title == '');
                    $block.html( ( noTitle ? '<span class="desc">без описания</span>' : data.title) );
                    if(noTitle) $block.addClass('e'); else $block.removeClass('e');
                    delete titleOld[imageID];  
                }
            }, $progress);
            return false;
        }); 
        $form.on('click', 'input.wimg-titleedit-delete', function(){
            var $block = $(this).parent();
            var imageID = $block.attr('rel');
            bff.ajax(url+'title', {image_id: imageID, title: ''}, function (data) {
                if(data) {
                    $block.html( '<span class="desc">без описания</span>' ).addClass('e');
                    delete titleOld[imageID];  
                }
            }, $progress);
            return false;
        });  
        $form.on('click', 'input.wimg-titleedit-cancel', function(e){
            editCancel( $(this).parent() );
            return false;
        });         

    });

    var titleOld = {};
    function editBegin( imageID, $block )
    {
        var noTitle = $block.hasClass('e');
        var curTitle = (noTitle ? '' : $block.html());
        titleOld[imageID] = curTitle;

        $block.html('<textarea name="title" style="height: 49px; width: 400px; margin-bottom:5px;">'+ curTitle +'</textarea><br/>\
               <input type="button" class="button submit wimg-titleedit-finish" value="Сохранить" /> '
               +(noTitle?'': '<input type="button" class="button delete wimg-titleedit-delete" value="Удалить описание" /> ')+
               '<input type="button" class="button cancel wimg-titleedit-cancel" value="Отмена" />').find(':input:first').focus();
        return false;
    }
    
    function editCancel( $block )
    {
        var imageID = $block.attr('rel'); 
        if(titleOld[imageID] == '')
            $block.html('<span class="desc">без названия</span>').addClass('e');
        else
            $block.html( titleOld[imageID] ).removeClass('e');
        delete titleOld[imageID];
    }
    
    function initRotate(update)
    {
        if(update === true) {
            $img.sortable('refresh');
            $('a[rel=wimg-group]', $img).fancybox();
            onPhotosCountChanged();
        } else {
            $img.sortable();
        }
    }
    
    function onImageUpload(data)
    {
        var imageID = data.id;  

        if(uploader.getUploaded() == 0) $img.find('li').remove();

        $img.append('<li class="wimg wimg'+imageID+' relative left" style="width:<?= $imgWidth ?>px;  height: <?= $imgHeight ?>px;">\
                <input type="hidden" class="imgfn" name="img['+imageID+']" rel="'+imageID+'" value="'+(data.filename)+'" />\
                <a href="'+(data['<?= BBSItemImages::szView ?>'])+'" class="left" rel="wimg-group"><img src="'+(data['<?= BBSItemImages::szMini ?>'])+'" /></a>\
                <a class="but cross" style="position: absolute;right:2px;bottom:7px;" href="#" onclick="if(confirm(\'Удалить изображение?\')) return jItemImages.del('+imageID+', \''+(data.filename)+'\'); return false;"></a>\
            </li>');

        initRotate(true);
    }

    function onPhotosCountChanged()
    {
        var cnt = $img.find('li').length;
        if(cnt > 0) {
            $form.find('.nophoto-hide').show();
        } else {
            $form.find('.nophoto-hide').hide();
        }
    }

    return {
        del: function(imageID, imageFilename)
        {
            bff.ajax(url+'delete',{image_id: <? if($edit){ ?>imageID<? } else { ?>0<? } ?>, filename: imageFilename}, function(data){
                if(data && data.success) {
                    $form.find('li.wimg'+imageID).remove();
                    uploader.decrementUploaded();
                    initRotate(true);
                }
            }, $progress);
            return false;
        },
        delAll: function(async, filenames)
        {
            bff.ajax(url+'delete-all', {filenames: filenames}, function(data){
                if(data && data.success) {
                    $img.empty();
                    uploader.resetUploaded();
                    initRotate(true);
                }
            }, $progress, {async: async});
            return false;
        },
        save: function()
        {
            bff.ajax(url+'saveorder', $form.serialize(), function(data){
                if(data.success) {
                    bff.success('Порядок успешно сохранен');
                }
            }, $progress);
        }
    }
}());
</script>