<?php use bff\db\Dynprops;

/**
 * @var $this Dynprops
 */

$prefix = (isset($aData['prefix'])?$aData['prefix']:'d');
$prefixChild = 'fc';
$prefixChildID = 'dp';

$f = $aData['extra']['f'];

$lng_no = _t('dp', 'Нет');
$lng_yes = _t('dp', 'Да');

$child_tpl = 'form.child';
$child_tpl_path = false;

$searchHiddens = $this->searchHiddens;
$searchHiddensShow = $this->input->getpost('sh', TYPE_BOOL);
$searchHiddensOpen = false;

if( $searchHiddens && ! $searchHiddensShow && !empty($aData['dynprops']) ) {
    // проверяем есть ли среди фильтрующих дин. свойств, такие которые
    // фильтруют и при этом находятся на текущий момент в скрытых
    // если есть раскрываем все скрытые фильтры
    foreach($aData['dynprops'] as $d) {
        if( $d['search_hidden'] && isset($f[ $d['data_field'] ]) ) {
            $searchHiddensShow = true;
            $_GET['sh'] = $_POST['sh'] = 1;
            break;
        }
    }
}

if(!empty($aData['dynprops']))
foreach($aData['dynprops'] as $d)
{
    $name = $prefix.'['.$d['data_field'].']';
    $attr = '';
    $title = $d['title'];

    if(isset($f[ $d['data_field'] ])) {
        $d['value'] = $f[ $d['data_field'] ];
    }

    if( $searchHiddens ) {
        if($d['search_hidden'] && ! $searchHiddensOpen) {
            $searchHiddensOpen = true;
            ?><div class="more-filters" style="<?= ( $searchHiddensShow ? 'display:block' : 'display:none' ) ?>;"><?
            if( ! $searchHiddensShow ) {
                $attr .= ' disabled="disabled" ';
            }
        }
    }

    echo '<div class="b-param">
            <p class="param-name">'.$d['title'] .'</p>';

    switch ($d['type'])
    {
        case Dynprops::typeRadioGroup:
        case Dynprops::typeCheckboxGroup:
        {
            $values = (isset($d['value']) && $d['value'] ? $d['value'] : array());
            $values = $this->input->clean($values, TYPE_ARRAY_UINT);

            foreach($d['multi'] as $k=>$dm) {
                echo '<label><input type="checkbox" '.$attr.' name="'.$name.'['.$k.']" '.(in_array($dm['value'], $values)?'checked="checked"':'').' value="'.$dm['value'].'" /> &nbsp;'.$dm['name'].'</label><br />';
            }
        }break;
        case Dynprops::typeRadioYesNo:
        {
            $value = (isset($d['value'])? $d['value'] : 0);
            ?>
                <label><input type="radio" name="<?= $name ?>" <?= $attr ?> value="2" <?= ($value == 2?'checked="checked"':'') ?> /> <?= $lng_yes ?></label>&nbsp;
                <label><input type="radio" name="<?= $name ?>" <?= $attr ?> value="1" <?= ($value == 1?'checked="checked"':'') ?> /> <?= $lng_no ?></label>
            <?
        }break;
        case Dynprops::typeCheckbox:
        {
            $value = (isset($d['value'])? $d['value'] : 0);
            ?>
                <label><input type="hidden" name="<?= $name ?>" value="0" /><input type="checkbox" <?= $attr ?> name="<?= $name ?>" value="1" <?= ($value?'checked="checked"':'') ?> /> &nbsp;<?= $lng_yes ?></label>
            <?
        }break; 
        case Dynprops::typeSelect:
        {
            $value = (isset($d['value'])? $d['value'] : 0);

            // select
            ?>
                <select name="<?= $name ?>" style="width:180px;"<? if($d['parent']){ ?> <?= $attr ?> onchange="jBBSSearch.dpChild(<?= $d['id'] ?>, this.value, '<?= $prefixChild ?>')"<? } ?>>
                <?
                foreach($d['multi'] as $dm) {
                   echo '<option value="'.$dm['value'].'" '.( ($dm['value'] == $value) ?'selected="selected"':'').'>'.$dm['name'].'</option>';
                }
                ?>
                </select>
            <?

            if($d['parent'])
            { ?>
                </div> <? // закрываем блок основного parent-свойства ?>
                <div class="b-param"<? if (empty($value)){ ?> style="display: none;"<? } ?>>
                    <p class="param-name"><?= $d['child_title'] ?></p>
                       <span id="<?= $prefixChildID.$d['id']; ?>_child">
                       <?
                       if( ! empty($value) && isset($aData['children'][$d['id']])) {
                           echo $this->formChild($aData['children'][$d['id']], array('name'=>$prefixChild), true, $child_tpl, $child_tpl_path);
                       }
                       ?></span><?
            }
        }break;
        case Dynprops::typeNumber:
        {
            $d['value'] = $this->input->clean($d['value'], TYPE_ARRAY);
            $this->input->clean_array($d['value'], array(
                'f' => TYPE_UNUM,
                't' => TYPE_UNUM,
            ));
            ?>
            <div class="num-area">
                <?= _t('', 'от'); ?>&nbsp;<input type="text" name="<?= $name ?>[f]" value="<?= $d['value']['f'] ?>" <?= $attr ?> />&nbsp;до&nbsp;
                <input type="text" name="<?= $name ?>[t]" value="<?= $d['value']['t'] ?>" <?= $attr ?> />
            </div>
            <? if($d['parent'] && isset($aData['children'][$d['id']])) {
                $childForm = $this->formChild($aData['children'][$d['id']], array('name'=>$prefixChild), true, $child_tpl, $child_tpl_path);
                ?><span class="fi-tip"><?= $childForm; ?></span><?
            }
        }break; 
        case Dynprops::typeRange:
        {
            $d['value'] = $this->input->clean($d['value'], TYPE_ARRAY);
            $this->input->clean_array($d['value'], array(
                'f' => TYPE_UNUM,
                't' => TYPE_UNUM,
            ));

            $values = range($d['start'], $d['end'], $d['step']);

            $sOptionsFrom = '';
            $sOptionsTo = '';
            foreach($values as $i) {
               $sOptionsFrom .= '<option value="'.$i.'" '.($d['value']['f'] == $i ? 'selected="selected"' : '').'>'.$i.'</option>';
               $sOptionsTo   .= '<option value="'.$i.'" '.($d['value']['t'] == $i ? 'selected="selected"' : '').'>'.$i.'</option>';
            }
            ?>
            <?= _t('', 'от'); ?>&nbsp;&nbsp;<?= '<select name="'. $name .'[f]" '. $attr .' style="width:61px;"><option value="0">-</option>'. $sOptionsFrom .'</select>'; ?>
            &nbsp;&nbsp;
            <?= _t('', 'до'); ?>&nbsp;&nbsp;<?= '<select name="'. $name .'[t]" '. $attr .' style="width:61px;"><option value="0">-</option>'. $sOptionsTo .'</select>'; ?>
            <?php

            if($d['parent'] && isset($aData['children'][$d['id']])) {
                echo $this->formChild($aData['children'][$d['id']], array('name'=>$prefixChild), true, $child_tpl, $child_tpl_path);
            }
        }break;
    }

    echo '</div>';
}

if( $searchHiddensOpen ) {
    ?></div><?
    config::set('__bbs_search_morefilters', ! $searchHiddensShow);
}