<?php use bff\db\Dynprops;

$prefix = (isset($aData['prefix'])?$aData['prefix']:'dynprops');
$lng_no = _t('dp', 'Нет');
$lng_yes = _t('dp', 'Да');

foreach($aData['dynprops'] as $d)
{
    if (empty($d['value'])) continue;

    echo '<tr><td width="155"><span class="grey">'.$d['title'].':</span></td><td>';

    switch ($d['type'])
    {
        case Dynprops::typeRadioGroup:
        {
            $value = (isset($d['value'])? $d['value'] : $d['default_value']);
            foreach($d['multi'] as $dm) {
               if($value == $dm['value']) {
                   echo $dm['name'];
                   break;
               }
            }
        }break;
        case Dynprops::typeRadioYesNo:
        {
            $value = (isset($d['value'])? $d['value'] : $d['default_value']);
            echo ($value == 2 ? $lng_yes : ($value == 1 ? $lng_no : ''));
        }break;
        case Dynprops::typeCheckboxGroup:
        {
            $value = ( isset($d['value']) && $d['value'] ? explode(';', $d['value']) : explode(';', $d['default_value']) );

            $cbGroup = array();
            foreach($d['multi'] as $dm) {
               if(in_array($dm['value'], $value))
                   $cbGroup[] = $dm['name'];
            }
            echo join(', ', $cbGroup);
        }break;
        case Dynprops::typeCheckbox:
        {
            echo ( (isset($d['value'])? $d['value'] : $d['default_value'])  ? $lng_yes : $lng_no);
        }break;
        case Dynprops::typeSelect:
        {
            $value = (isset($d['value'])? $d['value'] : $d['default_value']);
            if($d['parent'])
            {
                foreach($d['multi'] as $dm) {
                   if($value == $dm['value']){ echo $dm['name']; break; }
                }

                if( ! empty($value) && isset($aData['children'][$d['id']])) {
                   echo '</td></tr>'; // close parent block
                   $dmv = current( $aData['children'][$d['id']] );
                   foreach($dmv['multi'] as $dm) {
                       if($dm['value'] == $dmv['value']) {
                           echo '<tr><td width="155"><span class="grey">'.$d['child_title'].':</span></td><td>';
                           echo $dm['name'];
                           break; // \/ close child block (</tr>)
                       }
                   }
                }
            } else {
                foreach($d['multi'] as $dm) { if($value == $dm['value'] && $value!=0){ echo $dm['name']; break; } }
            }
        }break;
        case Dynprops::typeInputText:
        case Dynprops::typeTextarea:
        case Dynprops::typeNumber:
        case Dynprops::typeRange:
        {
            echo (isset($d['value'])? $d['value'] : '');
        }break;
    }

    echo '</td></tr>';
}