<?php

class Items extends ItemsBase
{
    function route()
    {
        $prefix = ( ! bff::subdomainsEnabled('items') ? 'map/' : '' );
        $res = bff::route(array(
            $prefix.'(.*)\-([\d]+)/(.*)' => 'items/view/id=\\2&t=\\3', # просмотр
            $prefix.'([\d]+)\.html'      => 'items/view/id=\\1&t=info', # просмотр: старый вариант
            $prefix.'add\.html(.*)'      => 'items/add', # добавление
            $prefix.'phones(.*)'         => 'items/phones/cat=\\1', # телефоны
            $prefix.'full/(.*)'          => 'items/listing/full=1&cat=\\1', # карта: развернутая
            $prefix.'(.*)'               => 'items/listing/cat=\\1', # карта
        ), true);

        if ($res['event'] === false || !method_exists($this, $res['event'])) {
            $res['event'] = 'listing';
        }

        if (!Request::isAJAX()) {
            bff::setRightblock('', false);
        }

        return $this->$res['event']();
    }

    /**
     * Блок "Каталог организаций" на главной
     */
    function indexBlock()
    {
        $aData['cats'] = $this->db->select('
            SELECT C.keyword, CL.title
            FROM ' . TABLE_ITEMS_CATEGORIES . ' C, ' . TABLE_ITEMS_CATEGORIES_LANG . ' CL
            WHERE C.enabled = 1 AND C.pid = 0 ' . $this->db->langAnd(true, 'C', 'CL') . '
            ORDER BY C.num'
        );
        foreach ($aData['cats'] as &$v) {
            $v['url'] = static::url('map', array('cat'=>$v['keyword'])); unset($v['keyword']);
        } unset($v);

        return $this->viewPHP($aData, 'index.block');
    }

    /**
     * Список: на карте
     */
    function listing()
    {
        $isFull = $this->input->get('full', TYPE_BOOL);
        $aData = array('items' => array());

        $nCatID = 0;
        $mCat = Request::isAJAX() ? $this->input->post('cat', TYPE_UINT) : $this->input->get('cat', TYPE_NOTAGS);
        if (!empty($mCat)) {
            if (!Request::isAJAX()) {
                $mCat = trim($mCat, '/ ');
            }
            $aData['cat'] = $this->db->one_array('SELECT C.id, C.pid, C.keyword, CL.title, CL.titleh1,
                    CL.mtitle, CL.mkeywords, CL.mdescription, CL.seotext, C.mtemplate
                FROM ' . TABLE_ITEMS_CATEGORIES . ' C, ' . TABLE_ITEMS_CATEGORIES_LANG . ' CL
                WHERE C.enabled = 1 AND C.' . (Request::isAJAX() ? 'id' : 'keyword') . ' = :cat' .
                    $this->db->langAnd(true, 'C', 'CL') . '
                LIMIT 1', array(':cat'=>$mCat));
            if (!empty($aData['cat'])) {
                $nCatID = $aData['cat']['id'];
                $aData['informer'] = $aData['cat']['title'];
            }
        }

        $sQ = '';
        if (!$nCatID) {
            $sQ = $this->input->getpost('q', TYPE_NOTAGS);
            $sQ = $aData['q'] = $this->input->cleanSearchString($sQ, 30);
            if (!empty($sQ)) {
                $nCatID = -1;
                $aData['informer'] = _t('items', 'Результаты запроса') . ' "<strong>' . HTML::escape($sQ, 'js') . '</strong>"';
            }
        }

        $aData['cats'] = $this->db->select_key('SELECT C.id, C.pid, C.keyword, CL.title
              FROM ' . TABLE_ITEMS_CATEGORIES . ' C, ' . TABLE_ITEMS_CATEGORIES_LANG . ' CL
              WHERE C.enabled = 1 ' . $this->db->langAnd(true, 'C', 'CL') . '
              ORDER BY C.num', 'id'
        );
        foreach ($aData['cats'] as &$v) {
            $v['url'] = static::url('map', array('cat'=>$v['keyword'],'full'=>$isFull));
        } unset($v);

        $aData['cat_id'] = $nCatID;
        $isSearch = ( $nCatID == -1 );
        if ($nCatID != 0)
        {
            if ($isSearch) // search
            {
                $sqlSearch = $this->db->prepareFulltextQuery($sQ, 'IL.title');

                $aItems = $this->db->select_key('SELECT I.id, I.vip, I.link, IL.title as t, IL.descshort as d, ' . $sqlSearch . ' as score,
                                A.address as adr, A.lat, A.lng, A.city_id, A.phonesq as ph, A.site
                            FROM ' . TABLE_ITEMS . ' I, ' . TABLE_ITEMS_LANG . ' IL, ' . TABLE_ITEMS_ADDR . ' A
                            WHERE I.enabled = 1 AND I.moderated!=0 AND I.no_map = 0 
                              AND ' . $sqlSearch . '
                              AND I.id = A.item_id
                              ' . ($this->regionsFilterEnabled() ? ' AND A.city_id = ' . Geo::cityID() : '') .
                    $this->db->langAnd(true, 'I', 'IL') . '
                            GROUP BY I.id
                            ORDER BY I.vip DESC, score DESC, IL.title
                            ' . $this->db->prepareLimit(0, 50)
                );
            } else {
                $aItems = $this->db->select_key('SELECT I.id, I.vip, I.link, IL.title as t, IL.descshort as d,
                                A.address as adr, A.lat, A.lng, A.city_id, A.phonesq as ph, A.site
                            FROM ' . TABLE_ITEMS . ' I
                                INNER JOIN ' . TABLE_ITEMS_IN_CATEGORIES . ' IC ON I.id = IC.item_id AND IC.category_id = ' . $nCatID . ',
                                ' . TABLE_ITEMS_LANG . ' IL,
                                ' . TABLE_ITEMS_ADDR . ' A
                            WHERE I.enabled = 1 AND I.moderated!=0 AND I.no_map = 0 
                              AND I.id = A.item_id
                              ' . ($this->regionsFilterEnabled() ? ' AND A.city_id = ' . Geo::cityID() : '') .
                    $this->db->langAnd(true, 'I', 'IL') . '
                            GROUP BY I.id
                            ORDER BY I.vip DESC, IC.num_order'
                );
            }

            if (!empty($aItems)) {
                $num = 1;
                foreach ($aItems as &$v) {
                    $v['cats'] = array();
                    $v['cttl'] = Geo::regionTitle($v['city_id']);
                    $v['link'] = static::url('view', $v['link']);
                    $v['site_link'] = bff::urlAway($v['site']);
                    $v['num'] = $num++;
                } unset($v);

                $aItemsCategories = $this->db->select('SELECT IC.item_id as id, IC.category_id as cat_id
                    FROM ' . TABLE_ITEMS_IN_CATEGORIES . ' IC, ' . TABLE_ITEMS_CATEGORIES . ' C
                    WHERE IC.item_id IN (' . join(',', array_keys($aItems)) . ') AND IC.category_id = C.id AND C.enabled = 1
                    ORDER BY IC.item_id, IC.num
                ');

                if (!empty($aItemsCategories)) {
                    foreach ($aItemsCategories as $v) {
                        $aItems[$v['id']]['cats'][] = $aData['cats'][$v['cat_id']]['title'];
                    }
                }
            }
            $aData['items'] = & $aItems;
        }

        if (Request::isAJAX()) {
            $aData['items_html'] = $this->viewPHP($aData, 'listing.map.ajax');
            $this->ajaxResponse($aData);
        }

        $aData['cats'] = $this->db->transformRowsToTree($aData['cats'], 'id', 'pid', 'sub');

        # SEO:
        if ($isSearch || $isFull) {
            $this->seo()->robotsIndex(false);
        }
        if ($nCatID > 0) {
            # SEO: Карта - категория
            $this->urlCorrection(static::url('map', array('cat'=>$aData['cat']['keyword'],'full'=>$isFull)));
            $this->seo()->canonicalUrl(static::url('map', array('cat'=>$aData['cat']['keyword'],'full'=>$isFull), true));
            $this->setMeta('map-category', array(
                'category'  => $aData['cat']['title'],
                'region' => Geo::filter('title'),
            ), $aData['cat']);
        } else {
            # SEO: Карта - главная
            $this->urlCorrection(static::url('map', array('full'=>$isFull)));
            $this->seo()->canonicalUrl(static::url('map', array('full'=>$isFull), true));
            $this->setMeta('map-index', array(
                'region' => Geo::filter('title'),
            ), $aData);
        }

        $aData['full'] = $isFull;
        bff::setActiveMenu('//map/list', $isFull, false);
        if ($isFull) {
            View::setLayout('full');
            return $this->viewPHP($aData, 'listing.map');
        }

        bff::showRightblockBanner(false);
        return $this->viewPHP($aData, 'listing.map');
    }

    /**
     * Форма добавления объекта
     */
    function add()
    {
        if (!empty($_GET['success'])) {
            bff::setActiveMenu('//map/list', true);

            bff::setMeta(_t('items', 'Добавление организации'));
            return $this->showSuccess(
                _t('items', 'Добавление организации'),
                _t('items', 'Огранизация была успешно добавлена, после проверки модератором,[br]она будет добавлена в каталог.', array(
                        'br' => '<br/>',
                    )
                )
            );
        }

        $aData = $this->input->postm(array(
            'title'     => array(TYPE_NOTAGS, 'len' => 200), # Название фирмы
            'descshort' => array(TYPE_NOTAGS, 'len' => 500), # Чем занимается? (500 символов макс.)
            'city_id'   => TYPE_UINT, # Город
            'address'   => array(TYPE_NOTAGS, 'len' => 200), # Адрес
            'phones'    => TYPE_ARRAY_NOTAGS, # Телефоны
            'sites'     => TYPE_ARRAY_NOTAGS, # Сайты
            'emails'    => TYPE_ARRAY_NOTAGS, # E-mail адреса
            'user_type' => TYPE_UINT, # Тип пользователя: представитель / пользователь
            'name'      => array(TYPE_NOTAGS, 'len' => 150), # Имя
            'phone'     => array(TYPE_NOTAGS, 'len' => 150), # Телефон
            'email'     => array(TYPE_NOTAGS, 'len' => 150), # E-mail
            'captcha'   => TYPE_STR, # Captcha
        ));

        if (Request::isPOST()) {
            if (empty($aData['title'])) {
                $this->errors->set(_t('items', 'Укажите название фирмы'));
            } elseif (mb_strlen($aData['title']) <= 2) {
                $this->errors->set(_t('items', 'Указанное название фирмы слишком короткое'));
            }

            $aData['descshort'] = $this->input->cleanTextPlain($aData['descshort'], false, false);
            if (empty($aData['descshort'])) {
                $this->errors->set(_t('items', 'Укажите сферу деятельности фирмы'));
            }

            # город
            if (!Geo::cityIsValid($aData['city_id'])) {
                $this->errors->set(_t('items', 'Выберите город из представленных в списке'));
            }

            # адрес
            if (empty($aData['address'])) {
                $this->errors->set(_t('items', 'Укажите адрес'));
            }

            $this->prepareItemAddrContactsSave($aData);

            # представитель
            if ($aData['user_type'] == self::USERTYPE_AGENT) {
                if (empty($aData['name'])) {
                    $this->errors->set(_t('items', 'Укажите ваше имя'));
                }
                if (empty($aData['phone'])) {
                    $this->errors->set(_t('items', 'Укажите ваш номер телефона'));
                }
                if (!$this->input->isEmail($aData['email'], false)) {
                    $this->errors->set(_t('items', 'Укажите корректный e-mail адрес'));
                }
            }

            if ($this->errors->no()) {
                if (User::id()) {
                    if (!$this->security->validateToken()) {
                        $this->errors->reloadPage();
                    }
                } else {
                    # проверяем капчу
                    if (empty($aData['captcha']) || !CCaptchaProtection::correct($this->input->cookie('c2'), $aData['captcha'])) {
                        $this->errors->set(_t('', 'Результат с картинки указан некорректно'));
                    }
                }
            }

            if ($this->errors->no()) {
                $sNOW = $this->db->now();
                $nItemID = $this->db->insert(TABLE_ITEMS, array(
                    'user_id'   => User::id(),
                    'city_id'   => $aData['city_id'],
                    'created'   => $sNOW,
                    'modified'  => $sNOW,
                    'moderated' => 0,
                ));

                if ($nItemID > 0)
                {
                    $sKeyword = $this->getKeyword('', $aData['title']);
                    $this->db->update(TABLE_ITEMS, array(
                        'keyword' => $sKeyword,
                        'link'    => static::urlView($nItemID, $sKeyword, $aData['city_id']),
                        'link_short' => static::urlView($nItemID, $sKeyword, $aData['city_id'], false),
                    ), array('id' => $nItemID));

                    $aLangInsert = array(
                        'title'     => array(LNG => $aData['title']),
                        'descshort' => array(LNG => $aData['descshort']),
                    );

                    $this->db->langInsert($nItemID, $aLangInsert, $this->model->langItems, TABLE_ITEMS_LANG);

                    $this->itemsModerationCounter(1);

                    # добавляем информацию об адресе
                    $this->db->insert(TABLE_ITEMS_ADDR, array(
                        'item_id' => $nItemID,
                        'city_id' => $aData['city_id'],
                        'address' => $aData['address'],
                        'phones'  => $aData['phones'],
                        'emails'  => $aData['emails'],
                        'sites'   => $aData['sites'],
                    ), false);

                    # загружаем изображение
                    $this->initImages($nItemID)->uploadFILES('img');

                    if ($aData['user_type'] == self::USERTYPE_AGENT) {
                        # добавляем заявку на "представителя"
                        $this->addAgentRequest($nItemID, User::id(), $aData['name'], $aData['phone'], $aData['email']);
                    }

                    $this->redirect(static::url('add', array('success'=>1)));
                }
            }

            $aData['phones'] = (!empty($aData['phones']) && is_string($aData['phones']) ? unserialize($aData['phones']) : array());
            if (!empty($aData['phones'])) {
                $phones = array();
                foreach ($aData['phones'] as $v) {
                    $phones[] = $v['v'];
                }
                $aData['phones'] = $phones;
            }
            $aData['emails'] = (!empty($aData['emails']) && is_string($aData['emails']) ? unserialize($aData['emails']) : array());
            if (!empty($aData['emails'])) {
                $emails = array();
                foreach ($aData['emails'] as $v) {
                    $emails[] = $v['v'];
                }
                $aData['emails'] = $emails;
            }
            $aData['sites'] = (!empty($aData['sites']) && is_string($aData['sites']) ? unserialize($aData['sites']) : array());
            if (!empty($aData['sites'])) {
                $sites = array();
                foreach ($aData['sites'] as $v) {
                    $sites[] = $v['v'];
                }
                $aData['sites'] = $sites;
            }
        }

        # SEO: Добавление объекта
        $this->urlCorrection(static::url('add'));
        $this->seo()->canonicalUrl(static::url('add', array(), true));
        $this->setMeta('add', array('region' => Geo::filter('title')), $aData);

        bff::setActiveMenu('//map/list', true);
        return $this->viewPHP($aData, 'add');
    }

    /**
     * Просмотр объекта
     */
    public function view()
    {
        # Объект
        $nItemID = $this->input->get('id', TYPE_UINT);
        if (!$nItemID) {
            $this->errors->error404();
        }
        $aData = $this->model->itemData($nItemID, array('id','link','title','descshort',
            'imgcnt', 'img_list as img', 'enabled', 'moderated',
            'opinions','opinions_cache','descfull','no_map',
            'schedule_work','schedule_off','agent_id',
            'mtitle','mkeywords','mdescription','mtemplate',
            'share_title','share_description','share_sitename'), true);
        if (empty($aData) || (!$aData['enabled'] || !$aData['moderated'])) {
            if (Request::isAJAX()) {
                $this->ajaxResponse(Errors::IMPOSSIBLE);
            }
            $this->errors->error404();
        } else {
            $aData['phones'] = func::unserialize($aData['phones']);
            $aData['emails'] = func::unserialize($aData['emails']);
            $aData['sites']  = func::unserialize($aData['sites']);
            $aData['city_title'] = Geo::regionTitle($aData['city_id']);
            $aData['oImages'] = $this->initImages($nItemID);
            $aData['images'] = $aData['oImages']->getData();
        }
        $aData['page'] = $this->input->get('page', TYPE_UINT);
        if (!$aData['page']) $aData['page'] = 1;
        $aData['print'] = $this->input->get('print', TYPE_BOOL);

        # Табы
        $aTabs = array(
            'info'    => array('t'=>_t('items', 'Информация'), 'l'=>Items::url('view', array('link'=>$aData['link'], 'tab'=>'info'))),
            'news'    => array('t'=>_t('items', 'Новости'),    'l'=>Items::url('view', array('link'=>$aData['link'], 'tab'=>'news'))),
            'board'   => array('t'=>_t('items', 'Объявления'), 'l'=>Items::url('view', array('link'=>$aData['link'], 'tab'=>'board'))),
            'vacancy' => array('t'=>_t('items', 'Вакансии'),   'l'=>Items::url('view', array('link'=>$aData['link'], 'tab'=>'vacancy'))),
        );
        if ( ! (bff::moduleExists('auto') || bff::moduleExists('realty') || bff::moduleExists('bbs'))) {
            unset($aTabs['board']);
        }
        if ( ! bff::moduleExists('job')) {
            unset($aTabs['vacancy']);
        }
        $sTab = $this->input->get('t', TYPE_STR); $sTab = trim($sTab, '/');
        if (!isset($aTabs[$sTab]) || $aData['print']) {
            $sTab = 'info';
        }
        $aData['tab'] = $sTab;
        $aData['tabs'] = &$aTabs;

        # Категории объекта
        $aData['cats'] = $this->db->select('SELECT C.id, CL.title, C.keyword
            FROM ' . TABLE_ITEMS_IN_CATEGORIES . ' IC, ' . TABLE_ITEMS_CATEGORIES . ' C, ' . TABLE_ITEMS_CATEGORIES_LANG . ' CL
            WHERE IC.item_id = :item AND IC.category_id = C.id AND C.enabled = 1 ' . $this->db->langAnd(true, 'C', 'CL') . '
            ORDER BY IC.num', array(':item'=>$nItemID));
        foreach ($aData['cats'] as &$v) {
            $v['url'] = static::url('map', array('cat'=>$v['keyword'])); unset($v['keyword']);
        } unset($v);

        # Табы: содержание
        switch ($sTab) {
            case 'vacancy':
                $aData['content'] = Job::i()->vacancy_company($nItemID, $aData);
                break;
            case 'news':
                $aData['content'] = $this->view_news($nItemID, $aData);
                break;
            case 'board':
                $aData['content'] = $this->view_board($nItemID, $aData);
                break;
            case 'info':
            default:
                $aData['content'] = $this->view_info($nItemID, $aData);
        }

        # SEO: Просмотр объекта
        $aData['url'] = static::url('view', array('link'=>$aData['link'], 'tab'=>$sTab));
        $this->urlCorrection($aData['url']);
        $seoQuery = array();
        if ($sTab == 'board') {
            $seoQuery['st'] = $aData['subtab'];
            $seoQuery['page'] = $aData['page'];
        }
        $this->seo()->canonicalUrl(static::url('view', array('link'=>$aData['link'], 'tab'=>$sTab), true), $seoQuery);
        $this->setMeta('view', array(
            'tab'         => ( $sTab == 'info' ? '' : $aTabs[$sTab]['t'] ),
            'title'       => strip_tags($aData['title']),
            'description' => tpl::truncate($aData['descshort'], 150),
            'region'      => Geo::filter('title'),
            'page'        => $aData['page'],
        ), $aData);
        if ( ! $aData['print']) {
            $this->seo()->setSocialMetaOG($aData['share_title'], $aData['share_description'], array($aData['img']), $aData['url'], $aData['share_sitename']);
        }

        bff::setActiveMenu('//map/list', true);
        return $this->viewPHP($aData, 'view');
    }

    protected function view_info($nItemID, array & $aData)
    {
        if (Request::isAJAX())
        {
            $aResponse = array();
            switch ($this->input->post('act', TYPE_STR)) {
                case 'photo_view': {
                    $aRes = $this->initImages($nItemID)->processImagesView($aData['imgcnt']);
                    $aResponse = array_merge($aRes, $aResponse);
                }
                break;
            }
            $aResponse['res'] = $this->errors->no();
            $this->ajaxResponse($aResponse);
        }

        if ($aData['print']) {
            View::setLayout('print');
            return $this->viewPHP($aData, 'view.print');
        }

        $aData['opinions'] = $this->db->select('SELECT O.id, O.status, O.message, O.created, O.moderated, U.login, U.user_id, U.avatar, U.sex, U.blocked
                FROM ' . TABLE_ITEMS_OPINIONS . ' O, ' . TABLE_USERS . ' U
                WHERE O.item_id = :item AND (O.moderated = 1 OR O.user_id = :user) AND O.user_id = U.user_id
                ORDER BY O.created DESC
            ', array(':item'=>$nItemID, ':user'=>User::id())
        );

        $aData['opinion_added'] = $aData['user_opinion'] = false;
        if (User::id() > 0) {
            if ($aData['opinions']) {
                foreach ($aData['opinions'] as $k => $v) {
                    if (User::isCurrent($v['user_id'])) {
                        if (!$v['moderated']) {
                            unset($aData['opinions'][$k]);
                        }
                        $aData['opinion_added'] = true;
                        $aData['user_opinion'] = $v;
                        break;
                    }
                }
            }
        }

        return $this->viewPHP($aData, 'view.info');
    }

    protected function view_news($nItemID, array & $aData)
    {
        return Publications::i()->company_news($nItemID, $aData);
    }

    protected function view_board($nItemID, array & $aData)
    {
        $sSubTab = $this->input->get('st', TYPE_NOTAGS);
        $aSubTabs = array();
        if (bff::moduleExists('realty')) {
            $aSubTabs['realty'] = array('t' => _t('', 'Недвижимость'), 'a' => 0);
        }
        if (bff::moduleExists('auto')) {
            $aSubTabs['auto'] = array('t' => _t('', 'Авто'), 'a' => 0);
        }
        if (bff::moduleExists('bbs')) {
            $aSubTabs['board'] = array('t' => _t('', 'Другие объявления'), 'a' => 0);
        }

        if (!array_key_exists($sSubTab, $aSubTabs)) {
            $sSubTab = key($aSubTabs);
        }
        $aSubTabs[$sSubTab]['a'] = 1;
        foreach ($aSubTabs as $k => $v) {
            $aSubTabs[$k]['q'] = 'st=' . $k;
        }
        $aData['st'] = $aSubTabs[$sSubTab]['q'];
        switch ($sSubTab) {
            case 'board':
                $aData['tab_content'] = BBS::i()->company_items($nItemID, $aData);
                break;
            case 'realty':
                $aData['tab_content'] = Realty::i()->company_items($nItemID, $aData);
                break;
            case 'auto':
                $aData['tab_content'] = Auto::i()->company_items($nItemID, $aData);
                break;
        }

        $aData['subtabs'] = $aSubTabs;
        $aData['subtab'] = $sSubTab;

        return $this->viewPHP($aData, 'view.board');
    }

    /**
     * Список: телефоны
     */
    public function phones()
    {
        $aData = array('items' => array());

        $nCatID = 0;
        $mCat = Request::isAJAX() ? $this->input->post('cat', TYPE_UINT) : $this->input->get('cat', TYPE_NOTAGS);
        if (!empty($mCat)) {
            if (!Request::isAJAX()) {
                $mCat = trim($mCat, '/ ');
            }
            $aData['cat'] = $this->db->one_array('SELECT C.id, C.pid, C.keyword, CL.title, CL.titleh1,
                                CL.mtitle, CL.mkeywords, CL.mdescription, C.mtemplate
                          FROM ' . TABLE_ITEMS_CATEGORIES . ' C, ' . TABLE_ITEMS_CATEGORIES_LANG . ' CL
                          WHERE C.enabled = 1 AND C.' . (Request::isAJAX() ? 'id' : 'keyword') . ' = :cat' .
                $this->db->langAnd(true, 'C', 'CL'), array(':cat'=>$mCat)
            );
            if (!empty($aData['cat'])) {
                $nCatID = $aData['cat']['id'];
            }
        }

        $sQ = '';
        if (!$nCatID) {
            $sQ = $this->input->getpost('q', TYPE_NOTAGS);
            $sQ = $this->input->cleanSearchString($sQ, 30);
            if (!empty($sQ)) {
                $nCatID = -1;
            }
        }
        $aData['q'] = $sQ;

        $nPerpage = 10;
        $nPage = $this->input->get('page', TYPE_UINT);
        if (!$nPage) {
            $nPage = 1;
        }

        $sqlJoin = '';
        $sql = array();
        $sql[] = 'I.enabled = 1';
        $sql[] = 'I.moderated = 1';
        $sql[] = 'I.id = A.item_id';
        $sql[] = 'A.phonesq IS NOT NULL';
        if ($this->regionsFilterEnabled()) {
            $sql[] = 'A.city_id = ' . Geo::cityID();
        }
        if ($nCatID == -1) {
            $sqlSearch = $this->db->prepareFulltextQuery($sQ, 'IL.title');
            $sql[] = $sqlSearch;
        } elseif ($nCatID > 0) {
            $sqlJoin = ' INNER JOIN ' . TABLE_ITEMS_IN_CATEGORIES . ' IC ON I.id = IC.item_id AND IC.category_id = ' . $nCatID . ' ';
        }
        $sql = join(' AND ', $sql);

        $aData['cat_id'] = $nCatID;
        $isSearch = ( $nCatID == -1 );

        $aData['pgn'] = '';
        if ($nCatID != 0) {
            $sqlJoin .= ', ' . TABLE_ITEMS_LANG . ' IL ';
            $sql .= $this->db->langAnd(true, 'I', 'IL');
            $nTotal = $this->db->one_data('SELECT COUNT(I.id) FROM ' . TABLE_ITEMS . ' I ' . $sqlJoin . ', ' . TABLE_ITEMS_ADDR . ' A WHERE ' . $sql);
            $aData['pgn'] = $this->generatePagenationDots($nTotal, $nPerpage, 2, static::url('phones', array('cat'=>($nCatID > 0 ? $aData['cat']['keyword'] : ''))) . '?'. ($nCatID == -1 ? 'q=' . urlencode($sQ) . '&' : '') . 'page={page}',
                $sqlLimit, false
            );

            if ($nCatID > 0) { # в пределах категории
                $aData['items'] = $this->db->select('SELECT I.id, I.link, IL.title, I.no_map, A.city_id, A.address, A.phonesq as phones,
                                I.img_list as img, I.imgcnt, I.vip
                            FROM ' . TABLE_ITEMS . ' I ' . $sqlJoin . ', ' . TABLE_ITEMS_ADDR . ' A
                            WHERE ' . $sql . '
                            ORDER BY I.vip DESC, IC.num_order ' . $sqlLimit
                );
            } else { # поиск по слову
                $aData['items'] = $this->db->select('SELECT I.id, I.link, IL.title, ' . $sqlSearch . ' as score, I.no_map, A.city_id, A.address, A.phonesq as phones,
                                I.img_list as img, I.imgcnt, I.vip
                            FROM ' . TABLE_ITEMS . ' I ' . $sqlJoin . ', ' . TABLE_ITEMS_ADDR . ' A
                            WHERE ' . $sql . '
                            ORDER BY I.vip DESC, score DESC, IL.title ASC
                            ' . $sqlLimit
                );
            }
        } else { # 10 последних добавленных объектов
            $aData['items'] = $this->db->select('SELECT I.id, I.link, IL.title, I.no_map, A.city_id, A.address, A.phonesq as phones,
                                I.img_list as img, I.imgcnt, I.vip
                        FROM ' . TABLE_ITEMS . ' I, ' . TABLE_ITEMS_LANG . ' IL, ' . TABLE_ITEMS_ADDR . ' A
                        WHERE I.enabled = 1 AND I.moderated = 1 
                          AND I.id = A.item_id
                          AND A.phonesq IS NOT NULL
                          ' . ($this->regionsFilterEnabled() ? ' AND A.city_id = ' . Geo::cityID() : '') .
                $this->db->langAnd(true, 'I', 'IL') . '
                        ORDER BY I.created DESC' . $this->db->prepareLimit(0, 10)
            );
        }

        if (!empty($aData['items'])) {
            foreach($aData['items'] as &$v) {
                $v['has_image'] = ($v['imgcnt']>0 && ! empty($v['img']));
                $v['link'] = static::url('view', $v['link']);
            } unset($v);
        }
        $aData['items'] = $this->viewPHP($aData, 'listing.phones.ajax');

        if (Request::isAJAX()) {
            $this->ajaxResponse($aData);
        }

        $aData['cats'] = $this->db->select('SELECT C.id, C.pid, CL.title, C.keyword, (C.id = :id) as a
              FROM ' . TABLE_ITEMS_CATEGORIES . ' C,
                   ' . TABLE_ITEMS_CATEGORIES_LANG . ' CL
              WHERE C.enabled = 1 ' . $this->db->langAnd(true, 'C', 'CL') . '
              ORDER BY C.num', array(':id'=>$nCatID)
        );
        foreach ($aData['cats'] as &$v) {
            $v['url'] = static::url('phones', array('cat'=>$v['keyword'])); unset($v['keyword']);
        } unset($v);
        $aData['cats'] = $this->db->transformRowsToTree($aData['cats'], 'id', 'pid', 'sub');

        # SEO:
        if ($isSearch) {
            $this->seo()->robotsIndex(false);
        }
        if ($nCatID > 0) {
            # SEO: Телефоны - категория
            $this->urlCorrection(static::url('phones', array('cat'=>$aData['cat']['keyword'])));
            $this->seo()->canonicalUrl(static::url('phones', array('cat'=>$aData['cat']['keyword']), true), array(
                'page' => $nPage
            ));
            $this->setMeta('phones-category', array(
                'category' => $aData['cat']['title'],
                'region'   => Geo::filter('title'),
                'page'     => $nPage,
            ), $aData['cat']);
        } else {
            # SEO: Телефоны - главная
            $this->urlCorrection(static::url('phones'));
            $this->seo()->canonicalUrl(static::url('phones', array(), true));
            $this->setMeta('phones', array(
                'region' => Geo::filter('title'),
            ), $aData);
        }

        bff::setActiveMenu('//map/phones', false, false);
        bff::showRightblockBanner(false);
        return $this->viewPHP($aData, 'listing.phones');
    }

    function ajax()
    {
        $nUserID = User::id();

        switch ($this->input->get('act')) {
            case 'item-claim': # Жалоба
            {
                $p = $this->input->postm(array(
                    'id'      => TYPE_UINT,
                    'reasons' => TYPE_ARRAY_UINT,
                    'comment' => TYPE_NOTAGS,
                    'captcha' => TYPE_STR,
                ));

                $aResponse = array();
                do {
                    if (!$p['id']) {
                        $this->errors->impossible();
                        break;
                    }
                    if (empty($p['reasons']) && $p['comment'] == '') {
                        $this->errors->set(_t('items', 'Укажите причину и/или описание'));
                        break;
                    }

                    if (!$this->security->validateToken(true, false)) {
                        $this->errors->reloadPage();
                        break;
                    }

                    if (!$nUserID) {
                        if (!CCaptchaProtection::correct($this->input->cookie('c2'), $p['captcha'])) {
                            $aResponse['captcha'] = 1;
                            $this->errors->set(_t('', 'Результат с картинки указан некорректно'), 'captcha');
                            break;
                        }
                    } else {
                        if (Site::i()->preventSpam('items-claim', 60)) {
                            break;
                        }
                    }

                    $res = $this->db->insert(TABLE_ITEMS_CLAIMS, array(
                            'item_id' => $p['id'],
                            'user_id' => $nUserID,
                            'comment' => $p['comment'],
                            'reasons' => array_sum($p['reasons']),
                            'ip'      => Request::remoteAddress(),
                            'created' => $this->db->now(),
                        )
                    );

                    if ($res) {
                        if (!$nUserID) {
                            Request::deleteCOOKIE('c2');
                        }

                        $this->itemsClaimsCounter(1);
//                        bff::sendMailTemplate(array(
//                                'user'     => (!$nUserID ? 'Аноним' : $this->security->getUserLogin()),
//                                'claim'    => $this->getItemClaimText($nReasons, nl2br($p['comment'])),
//                                'item_url' => bff::urlItem( $p['id'] ),
//                            'items_claim', config::sys('mail.admin'));
                    }


                } while (false);

                $aResponse['res'] = $this->errors->no();
                $this->ajaxResponse($aResponse);
            }
            break;
            case 'item-agent': # Я представитель
            {
                $p = $this->input->postm(array(
                        'id'      => TYPE_UINT,
                        'name'    => TYPE_NOTAGS,
                        'phone'   => TYPE_NOTAGS,
                        'email'   => TYPE_NOTAGS,
                        'captcha' => TYPE_STR,
                    )
                );

                $aResponse = array('fields' => array(), 'captcha' => false);
                do {
                    if (!$p['id']) {
                        $this->errors->reloadPage();
                        break;
                    }

                    if (empty($p['phone']) || strlen($p['phone']) < 5) {
                        $aResponse['fields'][] = 'phone';
                        $this->errors->set(_t('items', 'Телефон указан некорректно'));
                    }
                    if (!$this->input->isEmail($p['email'])) {
                        $aResponse['fields'][] = 'email';
                        $this->errors->set(_t('items', 'E-mail адрес указан некорректно'));
                    }

                    if (!$this->security->validateToken(true, false)) {
                        $this->errors->reloadPage();
                        break;
                    }

                    if (!$nUserID) {
                        if (!CCaptchaProtection::correct($this->input->cookie('c2'), $p['captcha'])) {
                            $aResponse['fields'][] = 'captcha';
                            $aResponse['captcha'] = true;
                            $this->errors->set(_t('', 'Результат с картинки указан некорректно'), 'captcha');
                        }
                    }

                    if ($this->errors->no()) {
                        $res = $this->addAgentRequest($p['id'], $nUserID, $p['name'], $p['phone'], $p['email']);
                        if (!$nUserID) {
                            Request::deleteCOOKIE('c2');
                        }
                    }

                } while (false);

                $aResponse['res'] = $this->errors->no();
                $this->ajaxResponse($aResponse);
            }
            break;
            case 'item-opinion': # Отзыв об объекте
            {
                $p = $this->input->postm(array(
                    'id'      => TYPE_UINT,
                    'a'       => TYPE_NOTAGS,
                    'status'  => TYPE_UINT,
                    'message' => array(TYPE_NOTAGS, 'len' => 1000),
                    'edit'    => TYPE_BOOL,
                ));
                $act = $p['a'];

                $nItemID = $p['id'];

                $aResponse = array();
                do {
                    if (!$nItemID) {
                        $this->errors->impossible();
                        break;
                    }

                    if (empty($p['message']) || strlen($p['message']) <= 10) {
                        $this->errors->set(_t('items', 'Текст отзыва не может быть короче 10 символов.'));
                        break;
                    } else {
                        $p['message'] = substr($p['message'], 0, 500);
                    }

                    if (!$nUserID) {
                        $this->errors->set(_t('items', 'Возможность оставлять отзыв доступна только авторизованным пользователям'));
                        break;
                    }

                    if (!$this->security->validateToken()) {
                        $this->errors->reloadPage();
                        break;
                    }

                    if (!in_array($p['status'], array(
                            self::OPINION_STATUS_POSITIVE,
                            self::OPINION_STATUS_NEGATIVE,
                            self::OPINION_STATUS_NEUTRAL
                        )
                    )
                    ) {
                        $p['status'] = self::OPINION_STATUS_NEUTRAL;
                    }

                    $aUserOpinion = $this->db->select_row(TABLE_ITEMS_OPINIONS, array('id','status','moderated'),
                        array('item_id'=>$nItemID, 'user_id'=>$nUserID));
                    switch ($act)
                    {
                        case 'add':
                        {
                            if (!empty($aUserOpinion)) {
                                if (!$aUserOpinion['moderated']) {
                                    $this->errors->set(_t('items', 'Вы уже оставляли отзыв о данном объекте, после проверки модератора он будет опубликован'));
                                } else {
                                    $this->errors->set(_t('items', 'Вы уже оставляли отзыв о данном объекте'));
                                }
                            } else {
                                $res = $this->db->insert(TABLE_ITEMS_OPINIONS, array(
                                    'item_id' => $nItemID, 'user_id' => $nUserID, 'status' => $p['status'],
                                    'message' => $p['message'], 'created' => $this->db->now(),
                                ));
                                if ($res) {
                                    # накручиваем счетчик непромодерированных отзывов
                                    $this->itemsOpinionsModerationCounter(true);
                                    $aResponse['notify'] = _t('items', 'Ваш отзыв принят, после проверки модератором он будет опубликован');
                                }
                            }
                        }
                        break;
                        case 'edit':
                        {
                            if (empty($aUserOpinion) || !$aUserOpinion['moderated']) {
                                $this->errors->impossible();
                            } else {
                                $res = $this->db->update(TABLE_ITEMS_OPINIONS, array(
                                    'message' => $p['message'], 'status' => $p['status'],
                                    'modified' => $this->db->now(), 'modified_uid' => $nUserID,
                                ), array('item_id'=>$nItemID, 'user_id'=>$nUserID));
                                if (!empty($res) && $p['status'] != $aUserOpinion['status']) {
                                    $this->itemOpinionsCacheUpdate($nItemID);
                                    $aResponse['notify'] = _t('items', 'Отзыв был успешно отредактирован');
                                }
                            }
                        }
                        break;
                        case 'del':
                        {
                            if (empty($aUserOpinion) || !$aUserOpinion['moderated']) {
                                $this->errors->impossible();
                            } else {
                                $res = $this->db->delete(TABLE_ITEMS_OPINIONS, array('item_id'=>$nItemID, 'user_id'=>$nUserID));
                                if (!empty($res)) {
                                    $this->itemOpinionsCacheUpdate($nItemID);
                                    if (!$aUserOpinion['moderated']) {
                                        $this->itemsOpinionsModerationCounter(false);
                                    }
                                    $aResponse['notify'] = _t('items', 'Отзыв удален');
                                }
                            }
                        }
                        break;
                    }

                } while (false);

                $aResponse['res'] = $this->errors->no();
                $this->ajaxResponse($aResponse);
            }
            break;
        }
        $this->ajaxResponse(Errors::IMPOSSIBLE);
    }

    /**
     * Кабинет пользователя: объекты
     */
    function profile($nItems = 0, $nItemsRequests = 0)
    {
        $nUserID = User::id();
        if (!$nUserID) {
            return '';
        }

        if (Request::isAJAX()) {
            $aResponse = array();

            switch ($this->input->get('act')) {
                case 'vip':
                {
                    $nItemID = $this->input->post('id', TYPE_UINT);
                    $nSvcID = self::SERVICE_VIP;
                    $sPaySystem = $this->input->post('ps', TYPE_NOTAGS); # Ключ способа оплаты
                    if (empty($sPaySystem)) $sPaySystem = Bills::PS_BALANCE;

                    if (!$nItemID || !$this->security->validateToken()) {
                        $this->errors->reloadPage();
                        break;
                    }

                    $aItemData = $this->db->one_array('SELECT id, agent_id FROM ' . TABLE_ITEMS . ' WHERE id = ' . $nItemID);
                    if (empty($aItemData)) {
                        $this->errors->impossible();
                        break;
                    } else {
                        if ($aItemData['agent_id'] != $nUserID) {
                            $this->errors->set(_t('items', 'Вы не являетесь представителем данного объекта'));
                            break;
                        }
                    }
                    # проверяем способ оплаты
                    $aPaySystems = Bills::getPaySystems(true);
                    if (!isset($aPaySystems[$sPaySystem]) || empty($aPaySystems[$sPaySystem]['enabled'])) {
                        $this->errors->set( _t('bills', 'Выбранный способ оплаты на текущий момент недоступен') );
                        break;
                    }
                    # получаем стоимость услуги
                    $aSvc = Svc::model()->svcData($nSvcID);
                    if (empty($aSvc)) {
                        $this->errors->reloadPage();
                        break;
                    }
                    $nSvcPrice = $aSvc['price'];

                    $aPayAmount = Bills::getPayAmount($nSvcPrice, $sPaySystem);

                    $aResponse = $this->svc()->activateOrPay($this->module_name, $nSvcID, $nItemID,
                        $aPaySystems[$sPaySystem]['id'], $aPaySystems[$sPaySystem]['way'],
                        $nSvcPrice, $aPayAmount['amount'], $aPayAmount['currency']);
                }
                break;
                case 'edit':
                {
                    $p = $this->input->postm(array(
                            'id'     => TYPE_UINT,
                            'save'   => TYPE_BOOL,
                            'phones' => TYPE_ARRAY_NOTAGS, # Телефоны
                            'sites'  => TYPE_ARRAY_NOTAGS, # Сайты
                            'emails' => TYPE_ARRAY_NOTAGS, # E-mail адреса
                        )
                    );
                    $nItemID = $p['id'];

                    if (!$nItemID) {
                        $this->errors->reloadPage();
                        break;
                    }

                    $aData = $this->db->one_array('SELECT I.id, I.moderated, I.agent_id, I.vip, IL.title, A.phones, A.emails, A.sites, A.id as address_id
                            FROM ' . TABLE_ITEMS . ' I,
                                 ' . TABLE_ITEMS_ADDR . ' A,
                                 ' . TABLE_ITEMS_LANG . ' IL
                            WHERE I.id = :item AND I.id = A.item_id ' . $this->db->langAnd(true, 'I', 'IL'),
                    array(':item'=>$nItemID));

                    if (empty($aData) || !$this->security->validateToken()) {
                        $this->errors->reloadPage();
                        break;
                    }

                    if ($aData['agent_id'] != $nUserID) {
                        $this->errors->set(_t('items', 'Вы не являетесь представителем данного объекта'));
                    } elseif (!$aData['vip']) {
                        $this->errors->set(_t('items', 'Для того, чтобы иметь возможность редактировать информацию об объекте, необходимо активировать услугу "Приоритетное размещение"'));
                    } else {

                        if ($p['save']) {
                            $this->prepareItemAddrContactsSave($p);

                            if (!$this->security->validateToken()) {
                                $this->errors->reloadPage();
                                break;
                            }

                            if ($this->errors->no()) {
                                $res = $this->db->update(TABLE_ITEMS_ADDR, array(
                                        'phones' => $p['phones'],
                                        'emails' => $p['emails'],
                                        'sites'  => $p['sites'],
                                    ), array('id' => $aData['address_id'], 'item_id' => $nItemID)
                                );

                                if (!empty($res) && $aData['moderated'] == 1) {
                                    $res = $this->db->update(TABLE_ITEMS, array(
                                            'moderated' => 2,
                                        ), array('id'=>$nItemID)
                                    );
                                    if (!empty($res)) {
                                        $this->itemsModerationCounter(1);
                                    }
                                }
                            }

                        } else {
                            $aData['phones'] = (!empty($aData['phones']) && is_string($aData['phones']) ? unserialize($aData['phones']) : array());
                            if (!empty($aData['phones'])) {
                                $phones = array();
                                foreach ($aData['phones'] as $v) {
                                    $phones[] = $v['v'];
                                }
                                $aData['phones'] = $phones;
                            }
                            $aData['emails'] = (!empty($aData['emails']) && is_string($aData['emails']) ? unserialize($aData['emails']) : array());
                            if (!empty($aData['emails'])) {
                                $emails = array();
                                foreach ($aData['emails'] as $v) {
                                    $emails[] = $v['v'];
                                }
                                $aData['emails'] = $emails;
                            }
                            $aData['sites'] = (!empty($aData['sites']) && is_string($aData['sites']) ? unserialize($aData['sites']) : array());
                            if (!empty($aData['sites'])) {
                                $sites = array();
                                foreach ($aData['sites'] as $v) {
                                    $sites[] = $v['v'];
                                }
                                $aData['sites'] = $sites;
                            }
                            $aResponse['form'] = $this->viewPHP($aData, 'profile.item.edit');

                            $aResponse['phones'] = sizeof($aData['phones']);
                            $aResponse['emails'] = sizeof($aData['emails']);
                            $aResponse['sites'] = sizeof($aData['sites']);
                        }
                    }
                }
                break;
                default:
                {
                    $this->errors->impossible();
                }
                break;
            }

            $this->ajaxResponseForm($aResponse);
        }

        $aData = array();

        /**
         * Список объектов, закрепленных за пользователем
         */
        $aItems = $this->db->select('SELECT I.id, I.link, IL.title, I.imgcnt, I.img_list, I.vacancy,
                        I.vip, I.vip_expire, I.agent_id, (R.item_id IS NOT NULL) as request, A.address
                    FROM ' . TABLE_ITEMS . ' I
                        LEFT JOIN ' . TABLE_ITEMS_AGENTS_REQUESTS . ' R ON R.item_id = I.id AND R.user_id = :userId
                        , ' . TABLE_ITEMS_ADDR . ' A
                        , ' . TABLE_ITEMS_LANG . ' IL
                    WHERE I.enabled = 1 AND I.id = A.item_id AND ( I.agent_id = :userId OR R.item_id IS NOT NULL ) ' . $this->db->langAnd(true, 'I', 'IL') . '
                    GROUP BY I.id
                    ORDER BY I.created
                    ', array(':userId' => $nUserID)
        );

        $nRequests = 0;

        if (!empty($aItems)) {
            $aData['vip'] = $this->svc()->model->svcData(self::SERVICE_VIP);

            $aItemsTmp = array();
            foreach ($aItems as $v) {
                $v['cats'] = array();
                $aItemsTmp[$v['id']] = $v;
                if ($v['request']) {
                    $nRequests++;
                }
            }
            $aItems = $aItemsTmp;

            $aItemsCategories = $this->db->select('SELECT IC.item_id as id, IC.category_id as cat_id, CL.title
                        FROM ' . TABLE_ITEMS_IN_CATEGORIES . ' IC, ' . TABLE_ITEMS_CATEGORIES . ' C, ' . TABLE_ITEMS_CATEGORIES_LANG . ' CL
                        WHERE IC.item_id IN (' . join(',', array_keys($aItems)) . ') AND IC.category_id = C.id AND C.enabled = 1 ' .
                $this->db->langAnd(true, 'C', 'CL') . '
                        ORDER BY IC.item_id, IC.num  
                        '
            );

            if (!empty($aItemsCategories)) {
                foreach ($aItemsCategories as $v) {
                    $aItems[$v['id']]['cats'][$v['cat_id']] = $v['title'];
                }
                foreach ($aItems as $k => $v) {
                    $aItems[$k]['cats'] = join(', ', $v['cats']);
                }
            }
        }

        $this->security->userCounterCheck('items', sizeof($aItems) - $nRequests);
        $this->security->userCounterCheck('items_requests', $nRequests);

        $aData['items'] = & $aItems;
        bff::setMeta(_t('items', 'Мои объекты - Кабинет'));
        return $this->viewPHP($aData, 'profile');
    }

    protected function addAgentRequest($nItemID, $nUserID = 0, $sName = '', $sPhone = '', $sEmail = '')
    {
        $res = $this->db->insert(TABLE_ITEMS_AGENTS_REQUESTS, array(
                'user_id' => $nUserID,
                'item_id' => $nItemID,
                'name'    => $sName,
                'phone'   => $sPhone,
                'email'   => $sEmail,
                'ip'      => Request::remoteAddress(),
                'created' => $this->db->now(),
            )
        );

        if (!empty($res)) {
            config::saveCount('items_agents', 1, true);
            if ($nUserID) {
                # накручиваем счетчик запросов "на представительство" пользователя
                $this->security->userCounter('items_requests', 1);
            }

            return true;
        }

        return false;
    }

}