<?php

class ItemsImages extends CImagesUploaderTable
{
    /**
     * Константы размеров
     */
    const szSmall    = 's'; // small - preview в просмотре, списки
    const szNormal   = 'n'; // normal - просмотр
    const szOriginal = 'o'; // original  - оригинальное изображение

    function initSettings()
    {
        $this->path    = bff::path('items', 'images');
        $this->pathTmp = bff::path('tmp', 'images');
        $this->url     = bff::url('items', 'images');
        $this->urlTmp  = bff::url('tmp', 'images');

        $this->tableRecords = TABLE_ITEMS;
        $this->tableImages  = TABLE_ITEMS_IMAGES;

        $this->folderByID = true; // раскладываем файлы изображений по папкам (id(5)=>0, id(1005)=>1, ...)
        $this->filenameLetters = 8; // кол-во символов в названии файла
        $this->limit = Items::imagesLimit(); // лимит фотографий у объекта
        $this->maxSize = Items::imagesMaxSize();

        $this->minWidth  = 200;
        $this->minHeight = 200;
        $this->maxWidth  = 5000;
        $this->maxHeight = 5000;

        # размеры изображений
        $this->sizes = array(
            self::szSmall    => array('width'=>290, 'height'=>200),
            self::szNormal   => array('width'=>860, 'height'=>548, 'autofit_nocrop' => true),
            self::szOriginal => array('o'=>true), # оригинал
        );

        # размеры изображений, полный URL которых необходимо кешировать
        $this->sizesFav = array(
            # ключ размера => поле в базе
            self::szSmall => 'img_list',
        );
    }

    function urlDefault($sSizePrefix)
    {
        return $this->url.'default-'.$sSizePrefix.'.gif';
    }

    /**
     * Получаем данные об изображениях указанных ID объектов
     * @param array $aItemsID ID объектов
     * @return array массив параметров изображений сформированных: array(itemID=>data, ...)
     */
    public function getItemsImagesData($aItemsID)
    {
        if (empty($aItemsID)) {
            return array();
        }
        if ( ! is_array($aItemsID)) {
            $aItemsID = array($aItemsID);
        }
        $aData = $this->db->select('SELECT * FROM '.$this->tableImages.'
                    WHERE '.$this->fRecordID.' IN ('.join(',', $aItemsID).')
                    ORDER BY num');
        if ( ! empty( $aData ) ) {
            $aData = func::array_transparent( $aData, $this->fRecordID, false );
        }
        return $aData;
    }

    /**
     * Формирование данных для popup на страница просмотра объекта
     * @param integer $nItemID ID объекта
     * @return array
     */
    public function processImagesView($nItemID)
    {
        if ( ! $nItemID) { $this->errors->impossible(); return array(); }

        $aData = $this->getData();
        $aImages = array();

        $i = 1;
        foreach ($aData as $v)
        {
            $aImages[] = array(
                'id' => $v['id'],
                'i'  => $i-1,
                'comment' => $v['title_'.LNG],
                'created' => _t('', '[date] г.', array('date'=>tpl::date_format2($v['created']))),
                'src'     => $this->getURL($v, self::szNormal, false),
            );
            $i++;
        }

        return array(
            'offset' => 0,
            'total'  => sizeof($aData),
            'photos' => $aImages,
        );
    }

    /**
     * Пересчет порядка изображений объекта
     */
    public function rotate()
    {
        $this->db->rotateTablednd($this->tableImages, 'AND '.$this->fRecordID.' = '.$this->recordID, $this->tableRecords_id, 'num');
        $this->db->one_data('SELECT @i := 0');
        $this->db->exec('UPDATE '.$this->tableImages.' SET num = (SELECT @i:= @i + 1)
                            WHERE '.$this->fRecordID.' = '.$this->recordID.' ORDER BY num');

        $aDataFav = $this->db->one_array('SELECT * FROM '.$this->tableImages.'
                    WHERE '.$this->fRecordID.' = :id
                    ORDER BY num LIMIT 1', array(':id' => $this->recordID));
        $this->setFavoriteImage($aDataFav['id'], $aDataFav);
    }

    /**
     * Обновление описания изображения объекта
     * @param integer $nImageID ID изображения
     * @param array $aUpdate
     */
    public function updateTitle($nImageID, array $aUpdate)
    {
        $this->db->update($this->tableImages, $aUpdate, array(
            'id'             => $nImageID,
            $this->fRecordID => $this->recordID,
        ));
    }

}