<?php
    /**
     * @var $this Items
     */
    $aData = HTML::escape($aData, 'html', array('title', 'address', 'descshort'));
    Geo::mapsAPI(true);
    tpl::includeJS(array('tablednd', 'wysiwyg'), true);

    list($defaultCityCoords['lat'], $defaultCityCoords['lon']) = Geo::mapsDefaultCoords(true);
    $tabSEO = ($this->input->get('tab', TYPE_STR) === 'seo');
?>
<?= tplAdmin::blockStart( ($edit ? 'Объект #'.$id.' / Информация' : 'Справочная / Добавление объекта'), false) ?>

<form action="" name="itemsForm" id="itemsForm" method="post" onsubmit="return iSubmit();">
<input type="hidden" name="category_last" value="<?= $icategories_selected; ?>" />
<input type="hidden" name="category_change" id="category_change" value="0" />
<input type="hidden" name="category_parents" id="category_parents" value="<?= join(',', array_keys($icategories_parents)); ?>" />
<input type="hidden" name="category_parents_new" id="category_parents_new" value="<?= join(',', array_keys($icategories_parents)); ?>" />
<input type="hidden" name="urlhash" id="urlhash" value="" />
<input type="hidden" name="redirect" value="0" />

<? include('admin.items.form.menu.php') ?>

<div class="j-tab-block<? if($tabSEO){ ?> displaynone<? } ?>" data-tab="info">
<table class="admtbl tbledit">
<?= $this->locale->buildForm($aData, 'items-item-title','
<tr>
    <td>
        <div class="field-title">Название:</div>
        <input class="stretch i-title <?= $key ?>" type="text" maxlength="150" name="title[<?= $key ?>]" value="<?= HTML::escape($aData[\'title\'][$key]); ?>" />
    </td>
</tr>
'); ?>
<tr>
    <td>
        <div class="property"><span class="field-title">Keyword</span>: <a href="#" onclick="return iGenerateKeyword('.i-title:visible', '#i-keyword');" class="desc ajax small" style="margin-left: 5px;">сгенерировать</a></div>
        <div class="value">
            <label for="i-keyword" class="placeholder inline">URL keyword</label>
            <input class="stretch" type="text" maxlength="150" name="keyword" id="i-keyword" placeholder="URL keyword" value="<?= $keyword; ?>" />
        </div>
        <div class="clear-all"></div>
    </td>
</tr>
<tr>
    <td><hr size="1" />
        <div id="icategories">
            <div class="bold upper">Категории</div>
            <select style="display: none;" class="icategory_select_base"><?= $categories_options; ?></select>
            <table class="cats" style="width: 97%;"><?
                if($edit) {
                    $i = 0;
                    foreach($icategories as $catID=>$catTitle) { ?>
                    <tr><td class="catsrow">
                        <div class="cat" rel="<?= $catID; ?>">
                            <span class="icategory_title bold" style="padding-right: 5px;"><?= $catTitle; ?></span>
                                    <span class="desc"> -
                                        <a href="#" class="ajax desc icategory_delete">удалить</a>
                                    </span>
                            <select name="category[]" class="icategory_select" style="display:none;" disabled="disabled">
                                 <option selected="selected" value="<?= $catID; ?>"></option>
                            </select>
                        </div>
                    </td></tr>
                <? $i++; }
                } else { ?>
                    <tr><td class="catsrow">
                    <div class="cat" rel="0">
                        <select name="category[]" class="icategory_select" style="width:250px;"><?= $categories_options; ?></select>
                    </div>
                    </td></tr>
            <? } ?>
            </table>
            <a href="#" onclick="iCategory.add(); return false;" class="ajax">+ еще категория</a>
            <br />
        </div>
    </td>
</tr>
<tr>
    <td><hr size="1" /><b class="upper">Адрес и контакты</b> <label style="margin-left: 12px;" class="checkbox inline desc"><input name="no_map" <?= ($no_map ? 'checked':''); ?> type="checkbox" /> нет на карте</label> <span id="progress-addr" class="progress" style="margin-left:5px; display:none;"></span></td>
</tr>
<tr>
    <td>
        <div class="item-addr-block">
            <? if( ! empty($addr)): ?>
            <table class="admtbl item-addr">
            <tr>
                <td class="row1"><span class="field-title">Адрес</span>:</td>
                <td class="row2">
                    <input type="hidden" name="addr[id]" value="<?= ($addr['id']?$addr['id']:0); ?>" class="item-id" />
                    <input type="hidden" name="addr[del]" value="0" class="item-del" />
                    <div class="address-view">
                        <b><?= Geo::regionTitle($addr['city_id']).', '.$addr['address']; ?></b>
                        <a href="#" class="ajax desc address-edit-link"> - изменить</a>
                    </div>
                    <div class="address-edit" style="display:none;">
                        <input type="hidden" name="addr[lat]" value="<?= $addr['lat'] ?>" class="lat" />
                        <input type="hidden" name="addr[lng]" value="<?= $addr['lng'] ?>" class="lng" />
                        <?= Geo::cityOptionsSelect($addr['city_id'], true, 'addr[city_id]', array('class'=>'j-city')); ?>
                        <input style="width:330px;" type="text" maxlength="150" name="addr[address]" class="j-address" value="<?= $addr['address']; ?>" />
                        &nbsp;<a href="#" class="desc ajax map-show-link">на карте</a>
                        <div style="width: 100%;height:400px; margin-top:10px; display: none;" class="map"></div>
                    </div>
                </td>
            </tr>

            <tr>
                <td class="row1"><span class="field-title">Телефоны</span>:</td>
                <td class="row2">
                    <div class="phones-block">
                       <? $i = 1;
                       $addr['phones'] = unserialize($addr['phones']);
                       if($addr['phones'] === false) $addr['phones'] = array();
                       foreach($addr['phones'] as $e) { ?>
                        <div class="phone">
                            <input type="text" name="addr[phones][<?= $i ?>][v]" maxlength="40" value="<?= $e['v'] ?>" class="text-field left" style="display: block; width: 232px; margin: 0 5px 5px 0;" placeholder="телефон" />
                            <input type="text" name="addr[phones][<?= $i ?>][t]" maxlength="100" value="<?= $e['t'] ?>" class="text-field left" style="margin-bottom: 1px; display: block; width: 300px;" placeholder="название" />
                            <div class="left" style="margin: 5px 0 0 5px;"><a href="#" class="but cross phones-del"></a></div>
                            <div class="clear"></div>
                        </div>
                        <? $i++; } ?>
                    </div>
                    <a class="ajax phones-add" href="#">+ добавить</a>
                </td>
            </tr>
            <tr>
                <td class="row1"><span class="field-title">E-mail</span>:</td>
                <td class="row2">
                    <div class="emails-block">
                       <? $i = 1;
                       $addr['emails'] = unserialize($addr['emails']);
                       if($addr['emails'] === false) $addr['emails'] = array();
                       foreach($addr['emails'] as $e) { ?>
                        <div class="email">
                            <input type="text" name="addr[emails][<?= $i ?>][v]" maxlength="100" value="<?= $e['v'] ?>" class="text-field left" style="display: block; width: 232px; margin: 0 5px 5px 0;" placeholder="email" />
                            <input type="text" name="addr[emails][<?= $i ?>][t]" maxlength="100" value="<?= $e['t'] ?>" class="text-field left" style="margin-bottom: 1px; display: block; width: 300px;" placeholder="название" />
                            <div class="left" style="margin: 5px 0 0 5px;"><a href="#" class="but cross emails-del"></a></div>
                            <div class="clear"></div>
                        </div>
                        <? $i++; } ?>
                    </div>
                    <a class="ajax emails-add" href="#">+ добавить</a>
                </td>
            </tr>
            <tr>
                <td class="row1"><span class="field-title">WWW</span>:</td>
                <td class="row2">
                    <div class="sites-block">
                       <? $i = 1;
                       $addr['sites'] = unserialize($addr['sites']);
                       if($addr['sites'] === false) $addr['sites'] = array();
                       foreach($addr['sites'] as $e) { ?>
                        <div class="site">
                            <div class="desc left" style="padding-top:5px;">http://&nbsp;</div><input type="text" name="addr[sites][<?= $i ?>][v]" maxlength="100" value="<?= $e['v'] ?>" class="text-field left" style="display: block; width: 200px; margin: 0 5px 5px 0;" placeholder="адрес" />
                            <input type="text" name="addr[sites][<?= $i ?>][t]" maxlength="200" value="<?= $e['t'] ?>" class="text-field left" style="margin-bottom: 1px; display: block; width: 300px;" placeholder="название" />
                            <div class="left" style="margin: 5px 0 0 5px;"><a href="#" class="but cross sites-del"></a></div>
                            <div class="clear"></div>
                        </div>
                        <? $i++; } ?>
                    </div>
                    <a class="ajax sites-add" href="#">+ добавить</a>
                </td>
            </tr>
            <tr>
                <td class="row1" width="85"><span class="field-title">Как добраться</span>:</td>
                <td class="row2">
                <?= $this->locale->formField('addr[description]', $addr['description'], 'textarea', array('class' => 'items-item-addr', 'style' => 'width: 550px; height: 80px;')); ?>
                </td>
            </tr>
            </table>
            <? endif; ?>
        </div>
    </td>
</tr>
<tr>
    <td><hr size="1" />
        <div>
            <b class="upper">Расписание работы</b>
            <input type="hidden" name="schedule_edit" id="schedule_edit" value="0" />
            <?php if($edit): ?>&nbsp;&nbsp;<a href="#" class="ajax desc" onclick="iSchedule.init(this); return false;">изменить</a><?php endif; ?>
            <br />
        </div>
        <div id="item-sch-block" style="margin: 10px 0 0 10px;">
            <select class="sch_time_select_base hidden"><?
                $scheHoursOpts = ''; for($i=0; $i<=48; $i++) $scheHoursOpts .= '<option value="'.($i*30).'">'.intval($i/2).':'.($i%2?3:0).'0</option>';
                echo $scheHoursOpts;
            ?></select>
            <div style="width: 50%;" class="left">
                <div class="desc" style="margin-bottom: 7px;"><span class="upper">рабочие дни</span> <a href="#" class="sch-work-add ajax hidden">+ добавить</a></div>
                <div class="sch-work">
                    <?= (isset($schedule_work)?$schedule_work:''); ?>
                </div>
            </div>
            <div style="width: 50%;" class="right">
                <div class="desc" style="margin-bottom: 7px;"><span class="upper">выходные дни</span> <a href="#" class="sch-off-add ajax hidden">+ добавить</a></div>
                <div class="sch-off">
                    <?= (isset($schedule_off)?$schedule_off:''); ?>
                </div>
            </div>
            <div class="clear"></div>
        </div>
        <hr size="1" style="width: 99%" />
    </td>
</tr>
<?= $this->locale->buildForm($aData, 'items-item-desc','
<tr>
    <td>
        <div class="property"><b>Краткое описание</b></div>
        <div class="value"><textarea name="descshort[<?= $key ?>]" style="height: 90px;"><?= $aData[\'descshort\'][$key]; ?></textarea></div>
    </td>
</tr>
<tr>
    <td>
        <div class="property"><b>Полное описание</b></div>
        <div class="value"><?= tpl::jwysiwyg($aData[\'descfull\'][$key], \'descfull[\'.$key.\']\', 720, 140); ?></div>
    </td>
</tr>
'); ?>

<? if($edit && ($agent_id > 0 || $user_id > 0)){ ?>
<tr>
    <td>
        <div class="well well-small">
        <? if($user_id > 0) { ?>
            <strong>Пользователь</strong>: <a href="#" class="ajax<? if($user_blocked){ ?> block_s<? } ?>" onclick="return bff.userinfo(<?= $user_id ?>);"><?= $user_login ?></a>
            <hr />
        <? } ?>
        <?
        if($agent_id > 0)
        {
            $agentInfo = unserialize($agent_info);
            ?>
            <script type="text/javascript">
                function removeItemAgent(itemID, link)
                {
                    if(bff.confirm('sure'))
                    bff.ajax('<?= $this->adminLink('ajax&action=item-agent-remove') ?>', {item_id: itemID}, function(data){
                        if(data) {
                            $(link).parent().slideUp();
                        }
                    });
                }
            </script>
            <b class="upper">Представитель</b>:&nbsp;<a href="#" onclick="removeItemAgent(<?= $id ?>, this); return false;" class="del_s disabled desc"></a><br/>
            <table class="admtbl tbledit">
            <tr>
                <td class="field-title" style="width: 135px;">Пользователь:</td>
                <td><a href="#" class="ajax<? if($agent_blocked){ ?> block_s<? } ?>" onclick="return bff.userinfo(<?= $agent_id ?>);"><?= (!empty($agent_email) ? $agent_email : '#'.$agent_id) ?></a> <a href="<?= $this->adminLink('items_listing&agent='.$agent_id) ?>" class="desc" target="_blank">(все объекты)</a></td>
            </tr>
            <? if(!empty($agentInfo)) { ?>
            <tr><td class="field-title">Имя:</td><td><?= (!empty($agentInfo['name']) ? $agentInfo['name'] : '-') ?></td></tr>
            <tr><td class="field-title">Контактный телефон:</td><td><?= (!empty($agentInfo['phone']) ? $agentInfo['phone'] : '-') ?></tr>
            <tr><td class="field-title">Email:</td><td><?= (!empty($agentInfo['email']) ? '<a href="mailto:'.$agentInfo['email'].'">'.$agentInfo['email'].'</a>' : '-') ?></tr>
            <? } ?>
            </table>
     <? } ?>
        </div>
    </td>
</tr>
<? } ?>
<tr>
    <td>
        <? if($edit && $moderated != 1) { ?>
        <label class="checkbox clr-error bold"><input type="checkbox" name="moderated" /> промодерировано</label>
        <? } ?>
    </td>
</tr>
</table>
</div>

<!-- SEO -->
<div class="j-tab-block<? if(!$tabSEO){ ?> displaynone<? } ?>" data-tab="seo">
    <?= SEO::i()->form($this, $aData, 'view'); ?>
</div>

<div style="margin-top: 10px;">
    <span class="btn-group">
    <input type="button" class="btn btn-success button submit" value="Сохранить" onclick="iSubmitButton = this; $(this.form).submit();" />
    <input type="button" class="btn btn-success button submit" value="и вернуться к списку" onclick="document.forms.itemsForm.redirect.value = 1; iSubmitButton = this; $(this.form).submit();" />
    </span>
    <? if($edit) { ?>
    <input type="button" class="btn btn-success button submit" value="Отзывы (<?= $opinions ?>)" onclick="bff.redirect('<?= $this->adminLink('opinions&item_id='.$id) ?>');" />
    <input type="button" class="btn btn-danger button delete" value="Удалить" onclick="return iDelete(<?= $id; ?>);" />
    <? } ?>
    <input type="button" class="btn button cancel" value="Отмена" onclick="return history.back();" />
</div>
</form>
<?= tplAdmin::blockStop(); ?>

<script type="text/javascript">
var iData = {id: '<?= $id; ?>'};

var iCategory = (function(){
    var progress, catsLimit = <?= Items::categoriesLimit(); ?>, catsContainer, catsOptions, catsIterator = <?= ($edit ? sizeof($icategories) : 1); ?>, catsI = catsIterator,
        processing, categoryChange = 0, 
        categorySelected = [<?= (!empty($icategories) ? join(',', array_keys($icategories)) : ''); ?>],
        categoryParents = <?= (!empty($icategories_parents) ? func::php2js($icategories_parents) : '{}'); ?>;
    function init()
    {
        progress = false;
        catsContainer = $('#icategories table.cats');
        
        catsOptions = '<?= ($edit? '<option value="0">не выбрана</option>':''); ?>';
        catsOptions += $('select.icategory_select_base').html();                   
            
        catsContainer.find('.cat').each(function(){
            initCatBlock($(this), false);
        });
        
        initRotate('#icategories table.cats', 'catsrow');
        
        <? 
        if( ! $edit && !Request::isPOST())
        {
            $nAddCategoryID = $this->input->get('category_id', TYPE_UINT);
            if(!$nAddCategoryID) {
                $nAddCategoryID = (integer)$this->security->getSESSION('items-add-lastcat');
            }
            if($nAddCategoryID>0) {
                ?>$('select.icategory_select:first').val(<?= $nAddCategoryID; ?>).change(); <? 
            }
        } ?>
    }
    
    function initCatBlock(block, dynamic)
    {
        var select = block.find('.icategory_select');

        var cur_cat = intval(block.attr('rel'));
        var cur_parent = getCategoryParentID( cur_cat );

        if(!select.is(':disabled'))
        select.bind('change', function(e) {
            var new_cat = intval(this.value);
            var new_parent = getCategoryParentID( new_cat );
            if(new_cat == 0 || isCategoryAlreadySelected(new_cat)) {
                this.value = cur_cat;
                return false;
            }
            if(cur_cat!=0) {
                makeCategorySelected(cur_cat, cur_parent, false); 
            }
            
            makeCategorySelected(new_cat, new_parent, true);

            cur_cat    = new_cat;
            cur_parent = new_parent;
            onCategorySelect(new_cat, block);
        }); 
        
        if(dynamic) {
            select.html(catsOptions);
        } else {
            block.find('.icategory_changelink').click(function(e) {
                nothing(e); 
                changeCategory($(this), block, select);
            });
        }
        
        block.find('.icategory_delete').click(function(e) {
            nothing(e); 
            
            var ask = (!dynamic || (dynamic && select.val()>0));
            if(!ask || confirm('Удалить привязку к категории?')) {

                makeCategorySelected(cur_cat, cur_parent, false);
                
                //remove <tr>
                block.parents('tr:first').remove();
                if(dynamic) categoryChange--;
                else categoryChange++;
                catsIterator--;
            }
        });
    }
    
    function initRotate(table, tdClass, update)
    {
        if(update === true) {
            $(table).tableDnDUpdate();
        } else {
            $(table).tableDnD({onDragClass: 'rotate', dragHandle: tdClass});
        }
    }
    
    function getCategoryParentID(categoryID)
    {
        return intval($('select.icategory_select_base option[value="'+categoryID+'"]').attr('pid'));
    }
    
    function isCategoryAlreadySelected(categoryID)
    {                    
        for(var i in categorySelected) {
            if(categorySelected[i]==categoryID) return true;
        }
        return false;
    }
    
    function makeCategorySelected(categoryID, parentID, add)
    {
        if(add) { //add    
            if(isCategoryAlreadySelected(categoryID))
                return false;

            categorySelected.push( categoryID );
            
            if(categoryParents[parentID]) { //to parents
                categoryParents[parentID].push(categoryID);
            } else {
                categoryParents[parentID] = [categoryID];
            }
        } else { //remove
            if(!isCategoryAlreadySelected(categoryID))
                return false;

            for(var i=0; i<categorySelected.length; i++) {
                if(categorySelected[i] == categoryID) {
                    categorySelected.splice(i, 1);
                }
            }

            for(var i=0; i<categoryParents[parentID].length; i++) { //from parents
                if(categoryParents[parentID][i] == categoryID) {    
                   categoryParents[parentID].splice(i, 1);  
                    if(!categoryParents[parentID].length) {
                        delete categoryParents[parentID];  //remove parent
                        break;
                    }    
                }
            } 
        }
        return true;
    }                        
    
    function addCategory()
    {        
        if(catsLimit>0 && catsIterator>=catsLimit) { 
            bff.error('Максимально допустимое кол-во категорий: <b>'+catsLimit+'</b>');
            return false;
        }
        
        catsIterator++; catsI++;
        var x = catsContainer.append('<tr><td class="catsrow"><div class="cat" id="cat-'+catsI+'">\
                                      <select name="category[]" class="icategory_select" style="width:250px;">'+catsOptions+'</select>\
                                      <span class="icategory_title bold"></span>\
                                      <span>&nbsp;&nbsp;<a href="#" class="ajax desc icategory_delete">удалить</a></span>\
                              </div></td></tr>'); 
                              
        initCatBlock( catsContainer.find('#cat-'+catsI), true );
        
        initRotate(catsContainer, 'catsrow', true);
        
        categoryChange++;
        
        return false;
    }

    function changeCategory($link, block, select)
    {                                                 
        var enabled = select.is(':enabled');                    
        if(enabled) {                
            select.prop('disabled', true);
            $link.html('изменить');
            categoryChange--;
        } else {
            select.prop('disabled', false).val( block.attr('rel') );
            $link.html('отмена');   
            categoryChange++;
        }
        return false;
    }
    
    function onCategorySelect(categoryID, block)
    {
        if(categoryID==0) {
             //return;
        }
    }
    
    function getParents() {  
        var parents = [];
        for(var p in categoryParents) parents.push(p);
        return parents.join(',');
    }
    
    return {
        init: init, add: addCategory, isChange: function(){ return (categoryChange > 0); }, 
        limit: catsLimit, i:catsIterator,
        isOutOfLimit: function(){ return (catsLimit>0 && catsIterator>catsLimit); },
        isNoCategoriesSelected: function(){ return getParents() == ''; },
        getParents: getParents
    };
}());

var iAddr = (function(){
    var block, iterator = 0, progress;
    var cityDefault = <?= Geo::defaultCity(); ?>;
    function init()
    {                  
        progress = $('#progress-addr');  

        block = $('.item-addr-block');
        block.find('.item-addr').each(function(){
            initAddr($(this), false);
        });                         
        
        //live:
        
        //удаление телефонов
        block.on('click', '.phones-del', function(e){
            nothing(e);
            var p =$(this).parent().parent();
            if(p.find('input:first').val()!='') {
                if(confirm('Удалить телефон?')) {
                    p.remove();
                }
            } else {
                p.remove();    
            }
        });
        
        //удаление email'ов
        block.on('click', '.emails-del', function(e){
            nothing(e);
            var p = $(this).parent().parent();
            if(p.find('input:first').val()!='') {
                if(confirm('Удалить email?')) {
                    p.remove();
                }
            } else {
                p.remove();    
            }
        });
        
        //удаление сайтов
        block.on('click', '.sites-del', function(e){
            nothing(e);
            var p = $(this).parent().parent();
            if(p.find('input:first').val()!='') {
                if(confirm('Удалить сайт?')) {
                    p.remove();
                }
            } else {
                p.remove();    
            }
        });

        <? if(!$edit): ?>
            addAddr(false);
        <? endif; ?>
    }

    function initAddr(blockA, dyn)
    {
        if(dyn) {
            var oMapData = mapInit(blockA);
            mapShowLink(blockA, oMapData);
        } else {
            initChangeAddressLink(blockA);
            mapShowLink(blockA, false);
        }
        phonesFactory(blockA);
        emailsFactory(blockA);
        sitesFactory(blockA);
    }
    
    function addAddr(showMapToggler)
    {
        var prefix = 'addr';
        var descBlock = '<?= $this->locale->formField('addr[description]', array(), 'textarea', array('class' => 'items-item-addr', 'style' => 'width: 550px; height: 80px;')); ?>';
        block.append('<table class="admtbl item-addr">\
                        <tr><td class="row1"><span class="field-title">Адрес</span>:</td>\
                            <td class="row2">\
                                <input type="hidden" name="'+prefix+'[id]" value="0" class="item-id" />\
                                <input type="hidden" name="'+prefix+'[del]" value="0" class="item-del" />\
                                <div class="address-view hidden"></div>\
                                <div class="address-edit">\
                                    <input type="hidden" name="'+prefix+'[lat]" value="<?= HTML::escape($defaultCityCoords['lat']) ?>" class="lat" />\
                                    <input type="hidden" name="'+prefix+'[lng]" value="<?= HTML::escape($defaultCityCoords['lon']) ?>" class="lng" />\
                                    <?= Geo::cityOptionsSelect(false, true, 'addr[city_id]', array('class'=>'j-city')); ?>\
                                    <input style="width:330px;" type="text" maxlength="150" name="'+prefix+'[address]" class="j-address" placeholder="Адрес" value="" />\
                                    '+(showMapToggler!==false ? '&nbsp;<a href="#" class="desc ajax map-show-link">скрыть карту</a>':'')+'\
                                    <div style="width: 100%;height:400px; margin-top:10px;" class="map"></div>\
                                </div>\
                            </td>\
                        </tr>\
                        <tr><td class="row1"><span class="field-title">Телефоны</span>:</td>\
                            <td class="row2"><div class="phones-block"></div><a href="#" class="ajax phones-add">+ добавить</a></td>\
                        </tr>\
                        <tr><td class="row1"><span class="field-title">E-mail</span>:</td>\
                            <td class="row2"><div class="emails-block"></div><a class="ajax emails-add" href="#">+ добавить</a></td>\
                        </tr>\
                        <tr><td class="row1"><span class="field-title">WWW</span>:</td>\
                            <td class="row2"><div class="sites-block"></div><a class="ajax sites-add" href="#">+ добавить</a></td>\
                        </tr>\
                        <tr><td class="row1" width="85"><span class="field-title">Как добраться</span>:</td>\
                            <td class="row2">'+descBlock+'</td></tr>\
                    </table>');
        initAddr(block.find('.item-addr'), true);
    }
    
    function mapInit(blockA, dyn)
    {
        var mapContainer = blockA.find('.map');
        mapContainer.show();
        var lat = blockA.find('.lat');
        var lng = blockA.find('.lng');
        var addr = blockA.find('.j-address');

        var mapEditor;
        var map = bff.map.init(mapContainer.get(0), [lat.val(), lng.val()], function(map){
            mapEditor = bff.map.editor();
            mapEditor.init({
                map: map, version: '2.1',
                coords: [lat, lng],
                address: addr,
                addressKind: 'house',
                updateAddressIgnoreClass: 'typed',
                searchInit: true
            });

            addr.bind('change keyup input', $.debounce(function(){
                if($.trim(addr.val()).length) {
                    addr.addClass('typed');
                    var q = [];
                    q.push( $.trim(addr.val()) );
                    mapEditor.search(q.join(', '));
                }
            }, 700));
        }, {zoom: 12});

        blockA.find('.j-city').change(function(){
            var opt = $(this).find('option:selected');
            var ycoords = opt.data('ycoords');
            if(ycoords.length) {
                var point = bff.map.coordsFromString(ycoords);
                map.panTo(point, {duration: 800});
            }
        });

        return {map:map, container:mapContainer}
    }

    function mapToggle(data)
    {
        data.container.css('display', (data.container.css('display') == 'none') ? '' : 'none');
        data.map.refresh();
    }

    function mapShowLink(blockA, mapData)
    {
        //показать карту                       
        var isMap = (mapData!==false), oMapData = mapData, $link = blockA.find('.map-show-link');
        $link.click(function(e){
            nothing(e);
            if(!isMap) {
                isMap = true;
                if(!oMapData) oMapData = mapInit(blockA);
                else { mapToggle(oMapData); }
                $link.html('скрыть карту');
            } else {
                isMap = false;
                if(!oMapData) oMapData = mapInit(blockA);
                else { mapToggle(oMapData); }
                $link.html('на карте');
            }              
        });
    }

    function initChangeAddressLink(blockA)
    {
        var editBlock = blockA.find('.address-edit');
        var viewBlock = blockA.find('.address-view');
        var isView = true;
        blockA.find('.address-edit-link').click(function(e){
            nothing(e);
            if(isView) {
                viewBlock.hide();      
                if(!editBlock.hasClass('inited')) {
                    var cityID = $(this).attr('city');
                    var regionID = $(this).attr('reg');
                    editBlock.addClass('inited');
                }
                editBlock.show();
            } else {
                viewBlock.show();
                editBlock.hide();
            }
            isView = !isView;
        });
    }

    function phonesFactory(blockAddr)
    {
        var blockPhones = blockAddr.find('.phones-block');
        var i = blockPhones.find('.phone').length;
        
        blockAddr.find('.phones-add').click(function(e){
            nothing(e);
            ++i;
            blockPhones.append('<div class="phone">\
                <input type="text" name="addr[phones]['+i+'][v]" maxlength="40" value="" class="text-field left" style="display: block; width: 232px; margin: 0 5px 5px 0;" placeholder="телефон" />\
                <input type="text" name="addr[phones]['+i+'][t]" maxlength="100" value="" class="text-field left" style="margin-bottom: 1px; display: block; width: 300px;" placeholder="название" />\
                <div class="left" style="margin: 5px 0 0 5px;"><a href="#" class="but cross phones-del"></a></div>\
                <div class="clear"></div>\
              </div>');
        });
    }
    
    function emailsFactory(blockAddr)
    {
        var blockEmails = blockAddr.find('.emails-block');
        var i = blockEmails.find('.email').length;
        
        blockAddr.find('.emails-add').click(function(e){
            nothing(e);
            ++i;
            blockEmails.append('<div class="email">\
                <input type="text" name="addr[emails]['+i+'][v]" maxlength="40" value="" class="text-field left" style="display: block; width: 232px; margin: 0 5px 5px 0;" placeholder="email" />\
                <input type="text" name="addr[emails]['+i+'][t]" maxlength="40" value="" class="text-field left" style="margin-bottom: 1px; display: block; width: 300px;" placeholder="название" />\
                <div class="left" style="margin: 5px 0 0 5px;"><a href="#" class="but cross emails-del"></a></div>\
                <div class="clear"></div>\
              </div>');
        });
    }
    
    function sitesFactory(blockAddr)
    {
        var blockSites = blockAddr.find('.sites-block');
        var i = blockSites.find('.site').length;
        
        blockAddr.find('.sites-add').click(function(e){
            nothing(e);
            ++i;
            blockSites.append('<div class="site">\
                <div class="desc left" style="padding-top:5px;">http://&nbsp;</div><input type="text" name="addr[sites]['+i+'][v]" maxlength="40" value="" class="text-field left" style="display: block; width: 200px; margin: 0 5px 5px 0;" placeholder="адрес" />\
                <input type="text" name="addr[sites]['+i+'][t]" maxlength="40" value="" class="text-field left" style="margin-bottom: 1px; display: block; width: 300px;" placeholder="название" />\
                <div class="left" style="margin: 5px 0 0 5px;"><a href="#" class="but cross sites-del"></a></div>\
                <div class="clear"></div>\
              </div>');
        });
    }   
    
    return {
        init: init
    };
}());    

var iSchedule = (function(){
    var block, iterator = 0,  
        blocksWork,
        blocksOff;
    function init(edit)
    {                  
        block = $('#item-sch-block');
        blocksWork = $('.sch-work', block);
        blocksOff  = $('.sch-off', block);
        
        if(edit!==false) {
            $('#schedule_edit').val(1);
            //load data
            $(edit).remove();
            bff.ajax('<?= $this->adminLink('ajax&action=item-schedule-data') ?>', {item: iData.id}, function(data){
                if(data) {
                    if(data.work) {
                        blocksWork.html('');
                        for(var i=0; i<data.work.length; i++) {
                            addWorkBlock(data.work[i], false);
                        }
                    }
                    if(data.off) {
                        blocksOff.html('');
                        for(var i=0; i<data.off.length; i++) {
                            addOffBlock(data.off[i], false);
                        }
                    }                    
                }
            });
        }
        
        $('a.sch-work-add', block).click(function(e){
            nothing(e);
            addWorkBlock({id:0,title:'',days:31,time_from:540,time_to:1140,has_break:1,break_from:780,break_to:840}, true);
        }).show();
        block.on('click', 'a.sch-work-del', function(e){
            nothing(e);
            if(bff.confirm('sure')) {
                var $b = $('.work-'+this.rel, blocksWork);
                if($b.hasClass('dyn')) {
                    $b.remove();
                } else {  
                    $b.find('>.del').val(1);
                    $b.hide();
                }
            }
        });
        
        $('a.sch-off-add', block).click(function(e){
            nothing(e);
            addOffBlock({id:0,days:64,description:''}, true);
        }).show();
        block.on('click', 'a.sch-off-del', function(e){
            nothing(e);
            if(bff.confirm('sure')) {
                var $b = $('.off-'+this.rel, blocksOff);
                if($b.hasClass('dyn')) {
                    $b.remove();
                } else {  
                    $b.find('>.del').val(1);
                    $b.hide();
                }
            }
        });         
    }   
    
    function addWorkBlock(data, dynamic)
    {   
        var i = ++iterator;
        var name = 'schedule['+i+']';
        blocksWork.append('<div style="margin: 10px 10px 10px 0;" class="work-'+i+''+(dynamic?' dyn':'')+' hidden relative well well-small">\
                <a style="margin: 0;" class="close sch-work-del" rel="'+i+'" href="#">&times;</a>\
                <input type="hidden" value="'+(data.id)+'" name="'+name+'[id]" />\
                <input type="hidden" value="0" name="'+name+'[del]" class="del" />\
                <table class="admtbl">\
                    <tr><td class="field-title">\
                        <div>Дни:</div>\
                        <label class="checkbox inline field-title"><input type="checkbox" value="1" name="'+name+'[days][]" /> Пн</label><label class="checkbox inline field-title"><input type="checkbox" value="2" name="'+name+'[days][]" /> Вт</label><label class="checkbox inline field-title"><input type="checkbox" value="4" name="'+name+'[days][]" /> Ср</label><label class="checkbox inline field-title"><input type="checkbox" value="8" name="'+name+'[days][]" /> Чт</label><label class="checkbox inline field-title"><input type="checkbox" value="16" name="'+name+'[days][]" /> Пт</label><label class="checkbox inline field-title"><input type="checkbox" value="32" name="'+name+'[days][]" /> Сб</label><label class="checkbox inline field-title"><input type="checkbox" value="64" name="'+name+'[days][]" /> Вс</label>\
                    </td></tr>\
                    <tr><td class="field-title">\
                        <div>Время работы:</div>\
                        <label class="inline field-title">c <select name="'+name+'[time_from]" rel="time_from" class="time_select input-small"></select></label> <label class="inline field-title">до <select name="'+name+'[time_to]" rel="time_to" class="time_select input-small"></select></label>\
                        <label style="margin-left: 5px" class="checkbox inline field-title"><input type="checkbox" value="1" class="time_full" name="'+name+'[time_full]" /> круглосуточно</label>\
                    </td></tr>\
                  <tr><td class="field-title">\
                        <div>Перерыв:</div>\
                        <input type="hidden" value="0" name="'+name+'[no_break]" />\
                        <label class="inline field-title">c <select name="'+name+'[break_from]" rel="break_from" class="time_select input-small"></select></label> <label class="inline field-title">до <select name="'+name+'[break_to]" rel="break_to" class="time_select input-small"></select></label>\
                        <label style="margin-left: 5px" class="checkbox inline field-title"><input type="checkbox" value="1" class="no_break" name="'+name+'[no_break]" /> без перерыва</label></td></tr></table>\
                </div>\
        ');
        
        var _block = $('.work-'+i, blocksWork);
        $('input[name="'+name+'[days][]"]', _block).each(function(i,e){
            if(data.days & intval(this.value)) this.checked = true;
        });
        $('.time_select', _block).html( getTimeOpts() ).each(function(){
            var type = $(this).attr('rel');
            if(data[type]) this.value = data[type];
            if( type == 'time_from' || type == 'break_from') {
                $('option:last', this).remove();
            }
        });
        if(intval(data['no_break'])==1)
            $('.no_break', _block).prop('checked', true);
        if(intval(data['time_full'])==1)
            $('.time_full', _block).prop('checked', true);
        _block.show();
    }

    function addOffBlock(data, dynamic)
    {
        var i = ++iterator;
        var name = 'schedule_off['+i+']';
        blocksOff.append('<div style="margin: 10px 15px 10px 0;" class="off-'+i+''+(dynamic?' dyn':'')+' hidden well well-small">\
                <a style="margin: 0;" class="close sch-off-del" rel="'+i+'" href="#">&times;</a>\
                <input type="hidden" value="'+(data.id)+'" name="'+name+'[id]" />\
                <input type="hidden" value="0" name="'+name+'[del]" class="del" />\
                <table class="admtbl tbledit">\
                    <tr><td class="row1 field-title"><div>Дни:</div>\
                        <label class="checkbox inline field-title"><input type="checkbox" value="1" name="'+name+'[days][]" /> Пн</label><label class="checkbox inline field-title"><input type="checkbox" value="2" name="'+name+'[days][]" /> Вт</label><label class="checkbox inline field-title"><input type="checkbox" value="4" name="'+name+'[days][]" /> Ср</label><label class="checkbox inline field-title"><input type="checkbox" value="8" name="'+name+'[days][]" /> Чт</label><label class="checkbox inline field-title"><input type="checkbox" value="16" name="'+name+'[days][]" /> Пт</label><label class="checkbox inline field-title"><input type="checkbox" value="32" name="'+name+'[days][]" /> Сб</label><label class="checkbox inline field-title"><input type="checkbox" value="64" name="'+name+'[days][]" /> Вс</label>\
                    </td></tr>\
                    <tr><td class="row1 field-title">\
                        <div>Описание:</div>\
                        <textarea name="'+name+'[description]" style="height:74px;" class="stretch"></textarea>\
                    </td></tr>\
                </table></div>');
        
        var _block = $('.off-'+i, blocksOff);
        $('input[name="'+name+'[days][]"]', _block).each(function(i,e){
            if(data.days & intval(this.value)) this.checked = true;
        });
        $('textarea', _block).val(data.description);
        _block.show();
    }
    
    function getTimeOpts()
    {
        var timeOpts = false; 
        return function(){
                if(timeOpts === false)
                    timeOpts = $('.sch_time_select_base', block).html();
                return timeOpts;
            };
    }
    
    return { init: init };
}());
      
$(function(){
    
    iCategory.init();
    iAddr.init();
    <?php 
        if(!$edit){ ?>iSchedule.init(false);<?php }
    ?>
    
    if(location.hash) {
        $('#urlhash').val( location.hash.replace(/\?.*$/, '').replace(/^#/, '') );
    } 

    // tabs
    $('#itemsForm').on('click', '.j-tab', function(e){
        var tab = $(this).data('tab'); if (tab == 'images') { console.log(tab); return true; }
        $('.j-tab-block').addClass('displaynone').
            filter('[data-tab="'+tab+'"]').removeClass('displaynone');
        $(this).parent().addClass('tab-active').siblings().removeClass('tab-active');
        nothing(e);
    });
});

var iSubmitButton = false;
function iSubmit()
{
    if(iSubmitButton === false)
        return false;
    
    var $form = $('#itemsForm');
    var btnValue = iSubmitButton.value;
    iSubmitButton.value = 'Подождите...';
    
    do
    {
        var title_ok = 0;
        $('.i-title', $form).each(function(){
            if($(this).val().length != 0) title_ok++;
        });
        if(title_ok < 1){
            bff.error('Укажите название');
            break;
        }

        var k = $form.find('#i-keyword').val();
        if( ! k.length){
            bff.error('Укажите keyword.');
            break;
        }

        //не превышен ли лимит категорий
        if( iCategory.isOutOfLimit() ) {
            bff.error('Максимально допустимое кол-во категорий: <b>'+iCategory.limit+'</b>');
            break;
        }
               
        //изменялись ли категории
    //        var hasCategoryChanges = iCategory.isChange();
    //        if(hasCategoryChanges>0 && !bff.confirm('sure')) {
    //            return false;          
    //        } 


        if( iCategory.isNoCategoriesSelected() ) {
            bff.error('Укажите категорию');
            break;
        }
        $('#category_change', $form).val( (iCategory.isChange()>0?1:0) ); 
        <? if($edit): ?>
        //категории 
        $('.icategory_select:disabled', $form).prop('disabled', false);
        //паренты
        $('#category_parents_new', $form).val( iCategory.getParents() );        
        <? endif; ?>
        
        return true;
        
    } while(false);
    
    iSubmitButton.value = btnValue;
    iSubmitButton = false;   
    return false;
}

function iGenerateKeyword(from, to)
{
    from = $(from);
    var title = $.trim( from.val() );
    if(title.length>0)
    {
        bff.ajax('<?= $this->adminLink('ajax&action=item-gen-keyword') ?>', {title: title}, function(data){
            if(data.res) {
                $(to).val(data.keyword);
            }
        });
    }
    return false;
}

function iDelete(id)
{
    bff.ajaxDelete('Вы уверены?', id, '<?= $this->adminLink('ajax&action=item-delete') ?>', false, {remove: false, onComplete: function(){
        history.back();
    }});
}
</script>