<?php
    /**
     * Просмотр объекта: Информация
     * @var $this Items
     * @var $oImages ItemsImages
     */
    $urlCaptcha = tpl::captchaURL();
    $isOwner = User::isCurrent($agent_id);
?>
<div class="left w430">
    <div class="info">
        <span class="address"><?= $city_title ?>, <?= $address ?></span><br />
        <? if(!empty($phones)) { ?>
            <span class="phone">
            <? foreach($phones as $v) { ?>
                <?= $v['v'] ?><? if(!empty($v['t'])){ ?> - <span class="f11"><?= $v['t'] ?></span><? } ?><br />
            <? } ?>
            </span>
        <? } else { ?><br /><? } ?>
        <br />
        <? foreach($sites as $v){ ?><span><a href="<?= bff::urlAway($v['v']) ?>" rel="nofollow" target="_blank"><i class="iconlink fa fa-link f14 grey"></i><?= $v['v'] ?></a><? if(!empty($v['t'])){ ?> - <? echo $v['t']; } ?></span><br /><? } ?>
        <? foreach($emails as $v){ ?><span><i class="iconlink fa fa-mail-forward f14 grey"></i><?= HTML::mailto($v['v']); ?><? if(!empty($v['t'])){ ?> - <? echo $v['t']; } ?></span><br /><? } ?>
        <br />
    </div>
    <? if(!empty($descfull) && $descfull != '<br>')
    { ?>
    <div class="mt20"><?= $descfull ?></div>
    <? } ?>

</div>
<div class="right w290 mt20">
    <? if(!empty($images) && $imgcnt > 0)
    {
        $imgFirst = array_shift($images); $j = 1;
        tpl::includeJS('photos.viewer', false);
        ?>
        <a href="#" onclick="return appPhotosViewer.view(<?= $imgFirst['id']; ?>);"><img alt="<?= $title.' '._t('', 'фото [num]', array('num'=>$j)) ?>" src="<?= $oImages->getURL($imgFirst, ItemsImages::szSmall, false); ?>" /></a>
        <? if( ! empty($images)) { ?>
        <div class="gallery">
            <ul>
                <? foreach($images as $v) { ?>
                <li><a href="#" onclick="return appPhotosViewer.view(<?= $v['id']; ?>);"><img alt="<?= $title.' '._t('', 'фото [num]', array('num'=>$j)) ?>" src="<?= $oImages->getURL($v, ItemsImages::szSmall, false); ?>" width="90" /></a></li>
                <? } ?>
            </ul>
        </div>
        <? } ?>
        <script type="text/javascript">
            <? js::start(); ?>
            $(function(){
                appPhotosViewer.init({item_id: <?= $id ?>, title: '<?= HTML::escape($title, 'js') ?>', cnt: <?= $imgcnt ?>});
            });
            <? js::stop(); ?>
        </script>
    <? } ?>
</div>
<div class="clear"></div>
<table class="mt30">
    <tr>
        <td class="w430">
            <? if(!$no_map) { ?>
                <h3><?= _t('items', 'Как добраться') ?></h3>
                <? if($lat>0){
                    Geo::mapsAPI();
                    ?>
                    <div class="object-map" id="items_view_map" style="width: 466px; height: 300px;"></div>
                    <script type="text/javascript">
                        <? js::start(); ?>
                        $(function(){
                            app.map('items_view_map', '<?= HTML::escape($lat.','.$lng, 'js') ?>', false, {marker:true});
                        });
                        <? js::stop(); ?>
                    </script>
                <? } ?>
                <div class="clear"></div>
                <div class="grey"><?= $addr_description ?></div>
            <? } ?>
        </td>
        <td class="w290">
            <div class="ml10">
                <h3><?= _t('items', 'Время работы') ?></h3>
                <?= $schedule_work . $schedule_off ?>
            </div>
        </td>
    </tr>
</table>
<div class="news-autor">
    <div class="left textinfo">
        <? if(!$agent_id && !$isOwner){ ?><a href="#" onclick="itemsItemAgent(event);"><i class="iconlink fa fa-briefcase f14 grey"></i><?= _t('items', 'Я представитель') ?></a><br /><? } ?>
        <a href="?print=1"><i class="iconlink fa fa-print f14 grey"></i><?= _t('', 'Версия для печати') ?></a><br />
        <a href="#" onclick="itemsItemClaim(event);"><i class="iconlink fa fa-exclamation-triangle f14 red"></i><?= _t('items', 'Нашли ошибку в описании объекта?') ?></a><br />
    </div>
    <div class="left"><?= tpl::shareBlock(); ?></div>
    <div class="clear"></div>
</div>

<?
$user_opinion_status = ($user_opinion!==false ? $user_opinion['status'] : Items::OPINION_STATUS_NEUTRAL);
?>

<div class="block-form">
    <p class="title-block" style="margin-bottom: 10px;"><?= _t('', 'Отзывы:') ?> <? $ocnt = explode(',',$opinions_cache); ?><span class="green">+<?= $ocnt[0] ?></span>/<span class="grey"><?= $ocnt[1] ?></span>/<span class="red">-<?= $ocnt[2] ?></span> </p>
    <? if(!$isOwner) { ?>
    <? if(!User::id()) { ?>
        <p class="send-comment-att" style="margin-left: 17px;"><?= _t('', '[a1:start]Зарегистрируйтесь[a1:stop] или [a2:start]войдите[a2:stop], чтобы оставить отзыв', array(
                'a1:start' => '<a href="'.Users::url('register').'" onclick="app.popup(\'reg\').show(event);">',
                'a1:stop'  => '</a>',
                'a2:start' => '<a href="'.Users::url('login').'" onclick="app.popup(\'login\').show(event);">',
                'a2:stop'  => '</a>',
            )) ?> <i class="say"></i></p>
    <? } else { ?>
        <div class="bg-block bg-form-block form-box" id="itemsOpinionsForm" <? if($opinion_added){ ?>style="display:none;"<? } ?>>
            <form action="">
                <input type="hidden" name="id" value="<?= $id ?>" />
                <input type="hidden" name="a" value="<?= ($user_opinion!==false ? 'edit' : 'add') ?>" />
                <input type="hidden" name="hash" value="<?= $this->security->getToken(); ?>" />
                <div class="error" style="display: none; margin-bottom: 5px;"></div>
                <table>
                    <tbody>
                    <tr>
                        <td class="td1"><?= _t('', 'Добавить отзыв:') ?><span class="z-att">*</span></td>
                        <td><div class="textarea"><textarea cols="30" rows="7" name="message" placeholder="<?= _t('', 'Текст отзыва...') ?>"><?= ($user_opinion!==false ? $user_opinion['message'] : '') ?></textarea><i></i></div></td>
                    </tr>
                    <tr>
                        <td class="td1"><?= _t('', 'Характер отзыва:') ?></td>
                        <td><label class="green"><input type="radio" name="status" value="<?= Items::OPINION_STATUS_POSITIVE ?>" <? if($user_opinion_status == Items::OPINION_STATUS_POSITIVE){ ?> checked="checked"<? } ?> /> <?= _t('', 'Положительный') ?></label>  <label class="grey"><input type="radio" name="status" <? if($user_opinion_status == Items::OPINION_STATUS_NEUTRAL){ ?> checked="checked"<? } ?> value="<?= Items::OPINION_STATUS_NEUTRAL ?>" /> <?= _t('', 'Нейтральный') ?></label>  <label class="red"><input type="radio" name="status" value="<?= Items::OPINION_STATUS_NEGATIVE ?>" <? if($user_opinion_status == Items::OPINION_STATUS_NEGATIVE){ ?> checked="checked"<? } ?> /> <?= _t('', 'Отрицательный') ?></label></td>
                    </tr>
                    <tr>
                        <td></td>
                        <td>
                            <div class="btn mr10 left"><input type="submit" value="<?= ($user_opinion!==false ? _t('','сохранить') : _t('','добавить отзыв')) ?>" /><i></i></div>
                            <? if($user_opinion!==false){ ?><div class="btn mr10 left"><input type="submit" value="<?= _t('', 'удалить') ?>" onclick="return jItemsOpinions.del();" /><i></i></div><? } ?>
                            <div class="left"><a href="#" class="ajax" onclick="jItemsOpinions.toggle(this); return false;"><?= _t('', 'отмена') ?></a></div>
                            <div class="left"><div class="progress" style="display: none; margin: 7px 0 0 14px;"></div></div>
                            <div class="clear"></div>
                        </td>
                    </tr>
                    </tbody></table>
            </form>
            <i class="say"></i>
        </div>
    <? } ?>
    <? } ?>
</div>
<?
    $avatarSize = UsersAvatar::szNormal;
    $avatarSizeWidth = Users::i()->avatar(0)->getSizeWidth($avatarSize);
?>
<? foreach($opinions as $v){ ?>
<div class="b-comment mt20">

    <div class="left relative">
        <div class="avaBig">
            <img src="<?= UsersAvatar::url($v['user_id'], $v['avatar'], UsersAvatar::szNormal, $v['sex']) ?>" width="<?= $avatarSizeWidth ?>" height="<?= $avatarSizeWidth ?>" alt="" />
            <i class="mask">&nbsp;</i>
        </div>
        <div style="position: absolute; top:35px; right:8px; height: 25px; width: 25px; text-align: center; background-color: #fff; font-size: 20px;"><? if($v['status'] == Items::OPINION_STATUS_POSITIVE){ ?><span class="green"><b>+</b></span><? } elseif($v['status'] ==Items::OPINION_STATUS_NEUTRAL){ ?><span class="grey"><b>0</b></span><? } else { ?><span class="red"><b>-</b></span><? } ?></div>
    </div>
    <div class="text">
        <p class="comment-autor"><span><?= $v['login'] ?></span></p>
        <?= nl2br($v['message']) ?>
        <span class="info"><?= tpl::date_format2($v['created'], true, true, ' ', ' '._t('','в').' '); ?><? if(User::isCurrent($v['user_id'])){ ?> | <a href="#" onclick="return jItemsOpinions.toggle();"><?= _t('', 'Редактировать') ?></a><? } ?></span>
    </div>
</div>
<? } ?>

<div class="popup displaynone" id="popup-items-claim" style="width: 640px; margin-left: -185px;">
<div class="popup-title"><?= _t('items', 'Ошибка в описании объекта') ?></div>
<div class="error" style="display: none;"></div>
<div class="close"><span>x</span> <a href="#" class="close"><?= _t('', 'закрыть') ?></a></div>
<div class="content-popup">
    <form method="get">
        <input type="hidden" name="id" value="<?= $id ?>" />
        <input type="hidden" name="hash" value="<?= $this->security->getToken(); ?>" />
        <table class="t-popup" style="margin-left: 35px;">
            <tr>
                <td colspan="2">
                    <?= _t('items', 'Укажите причины, по которым вы считаете описание объекта некорректным') ?> <span class="z-att">*</span>:<br/><br/>
                    <?
                    $claimTypes = $this->getItemClaimReasons();
                    foreach($claimTypes as $key=>$claim) {
                        echo '<label><input type="checkbox" name="reasons[]" value="'.$key.'" /> '.$claim.'</label><br/>';
                    } ?>
                </td>
            </tr>
            <tr id="items-claim-comment" style="display: none;">
                <td><?= _t('', 'Описание ошибки') ?></td>
                <td><div class="textarea"><textarea rows="7" cols="30" name="comment"></textarea><i></i></div></td>
            </tr>
            <? if(!User::id()) { ?>
                <tr>
                    <td style="width: 175px;"><?= _t('', 'Введите результат') ?> <span class="z-att">*</span>:</td>
                    <td><img title="<?= _t('', 'обновить') ?>" alt="<?= _t('', 'код') ?>" src="" id="items-captcha" onclick="$(this).attr('src', '<?= $urlCaptcha ?>&r='+Math.random(1));" class="capth" style="cursor: pointer;" /><div class="inp inp-w4"><input type="text" name="captcha" pattern="[0-9]*" /><i></i></div></td>
                </tr>
            <? } ?>
            <tr>
                <td></td>
                <td style="padding-top: 10px;">
                    <div class="btn mr10 left"><input type="submit" value="<?= _t('', 'отправить') ?>" tabindex="2" /><i></i></div>
                    <div class="left"><a href="#" class="close"><?= _t('', 'отмена') ?></a></div>
                    <div class="left"><div class="progress" style="display: none; margin: 7px 0 0 14px;"></div></div>
                    <div class="clear"></div>
                </td>
            </tr>
        </table>
    </form>
</div>
</div>

<div class="popup displaynone" id="popup-items-agent" style="width: 640px; margin-left: -270px;">
<div class="popup-title"><?= _t('items', 'Вы представитель') ?></div>
<div class="error" style="display: none;"></div>
<div class="close"><span>x</span> <a href="#" class="close"><?= _t('', 'закрыть') ?></a></div>
<div class="content-popup">
    <form method="get">
        <input type="hidden" name="id" value="<?= $id ?>" />
        <?
        $aUserInfo = array('name'=>'', 'phone'=>'', 'email'=>'');
        if(User::id()) {
            $aUserData = User::data(array('name','surname','phone','email'));
            list($aUserInfo['name'], $aUserInfo['phone'], $aUserInfo['email']) = array($aUserData['name'].(!empty($aUserData['surname']) ? ' '.$aUserData['surname'] : ''), $aUserData['phone'], $aUserData['email'] );
            $aUserInfo = HTML::escape($aUserInfo, 'html');
        }
        ?>
        <table class="t-popup" style="margin-left: 35px;">
            <tr>
                <td colspan="2"><?= _t('', 'Укажите ваши контактные данные и мы с вами свяжемся:') ?><br/></td>
            </tr>
            <tr>
                <td><?= _t('', 'Имя') ?> <span class="z-att">*</span></td>
                <td><div class="inp inp-w3"><input type="text" name="name" value="<?= $aUserInfo['name'] ?>" tabindex="1" autocomplete="off" /><i></i></div></td>
            </tr>
            <tr>
                <td><?= _t('', 'Телефон') ?> <span class="z-att">*</span></td>
                <td><div class="inp inp-w3"><input type="tel" name="phone" value="<?= $aUserInfo['phone'] ?>" tabindex="2" autocomplete="off" /><i></i></div></td>
            </tr>
            <tr>
                <td><?= _t('', 'E-mail') ?> <span class="z-att">*</span></td>
                <td><div class="inp inp-w3"><input type="text" name="email" value="<?= $aUserInfo['email'] ?>" tabindex="3" autocomplete="off" /><i></i></div></td>
            </tr>
            <? if(!User::id()) { ?>
                <tr>
                    <td style="width: 145px;"><?= _t('', 'Введите результат') ?> <span class="z-att">*</span>:</td>
                    <td><img title="<?= _t('', 'обновить') ?>" alt="<?= _t('', 'код') ?>" src="" id="items-agent-captcha" onclick="$(this).attr('src', '<?= $urlCaptcha ?>&r='+Math.random(1));" class="capth" style="cursor: pointer;" /><div class="inp inp-w4"><input type="text" name="captcha" tabindex="4" pattern="[0-9]*" /><i></i></div></td>
                </tr>
            <? } ?>
            <tr>
                <td></td>
                <td style="padding-top: 10px;">
                    <div class="btn mr10 left"><input type="submit" value="<?= _t('items', 'отправить заявку') ?>" tabindex="5" /><i></i></div>
                    <div class="left"><a href="#" class="close"><?= _t('', 'отмена') ?></a></div>
                    <div class="left"><div class="progress" style="display: none; margin: 7px 0 0 14px;"></div></div>
                    <div class="clear"></div>
                </td>
            </tr>
        </table>
    </form>
</div>
</div>

<script type="text/javascript">
    <? js::start(); ?>
    $(function(){

        app.popup('items-claim', '#popup-items-claim', false, { onInit: function($popup)
        {
            var $form, $err = $('.error', $popup), $progress = $('.progress', $popup), $txt = $('#items-claim-comment', $popup), process = false, isOther = false, popup = this;
            $('input[value="32"]', $popup).click(function(){
                isOther = $(this).is(':checked');
                $txt.toggle(0, function(){ if(isOther) $('textarea', this).focus(); });
            });

            $('#items-captcha', $popup).attr('src', '<?= $urlCaptcha ?>');
            ($form = $('form:first', $popup)).submit(function(){
                if(process) return false;
                if( $('input:checked', this).length==0 ) {
                    app.showError($err, '<?= _t('', 'Укажите причину') ?>'); return false;
                }
                if( isOther && $.trim(this.comment.value) == '' ) {
                    this.comment.focus(); return false;
                }
                <? if(!User::id()) { ?>
                if($.trim(this.captcha.value) == '') {
                    this.captcha.focus(); return false;
                }<? } ?>
                process = true;
                bff.ajax( '<?= bff::urlAjax('items','item-claim') ?>', $form.serialize(), function(data, errors) {
                    var form = $form.get(0);
                    if(data && data.res) {
                        app.showError($err, '<?= _t('', 'Ошибка принята') ?>', true);
                        setTimeout(function() { popup.hide(); form.reset(); $txt.hide(); app.showError($err, false); }, 2000);
                    } else {
                        if(errors) {
                            app.showError($err, errors, false);
                            if(data.captcha) {
                                form.captcha.value = '';
                                form.captcha.focus();
                                $(form.captcha).parent().prev().triggerHandler('click');
                            }
                        }
                    }
                    process = false;
                }, $progress );
                return false;
            });
        }, onHide: function($popup){ app.showError($('.error', $popup), ''); } });

        app.popup('items-agent', '#popup-items-agent', false, { onInit: function($popup)
        {
            var $form, $err = $('.error', $popup), $progress = $('.progress', $popup), process = false, popup = this;
            $('#items-agent-captcha', $popup).attr('src', '<?= $urlCaptcha ?>');
            var updateCaptcha = function(f){ $(f.captcha).parent().prev().triggerHandler('click'); };
            ($form = $('form:first', $popup)).submit(function(){
                if(process) return false;
                <? if(!User::id()) { ?>
                if($.trim(this.captcha.value) == '') {
                    this.captcha.focus(); return false;
                }<? } ?>
                process = true;
                bff.ajax( '<?= bff::urlAjax('items','item-agent&hash='.$this->security->getToken()) ?>', $form.serialize(), function(data, errors) {
                    var form = $form.get(0);
                    app.fieldError([form.name, form.phone, form.email, form.captcha], false);
                    if(data && data.res) {
                        app.showError($err, '<?= _t('items', 'Заявка была успешно принята') ?>', true);
                        setTimeout(function() { popup.hide(); form.reset(); app.showError($err, false); updateCaptcha(form); }, 2000);
                    } else {
                        if(data.fields) app.fieldErrorForm(data.fields, form);
                        if(errors) app.showError($err, errors);
                        if(data.captcha) {
                            form.captcha.value = '';
                            form.captcha.focus();
                            updateCaptcha(form);
                        }
                    }
                    process = false;
                }, $progress );
                return false;
            });
        },
            onHide: function($popup){ app.showError($('.error', $popup), ''); },
            onShow: function($popup){ $('[name="name"]:first', $popup).focus(); }
        });

    });

    function itemsItemClaim(e)
    {
        app.popup('items-claim').show(e);
    }

    function itemsItemAgent(e)
    {
        app.popup('items-agent').show(e);
    }

    var jItemsOpinions = (function(){
        var $block, $form, $err, $progress, process = false;
        $(function(){
            $block    = $('#itemsOpinionsForm');
            $err      = $block.find('.error');
            $progress = $block.find('.progress');
            ($form = $block.find('form:first')).submit(function(){
                if($.trim(this.message.value).length <= 5) {
                    this.message.focus();
                    return false;
                }

                if(process) return false;
                process = true;
                var form = this;
                var act = $form.find('[name="a"]').val();
                bff.ajax( '<?= bff::urlAjax('items','item-opinion') ?>', $form.serialize(), function(data, errors) {
                    if(data && data.res) {
                        app.showError($err, data.notify, true);
                        setTimeout(function() { if(act!='add') location.reload(); jItemsOpinions.toggle(); form.reset(); app.showError($err, false);  }, 2000);
                    } else {
                        if(errors) {
                            app.showError($err, errors, false);
                        }
                    }
                    process = false;
                }, $progress );
                return false;
            });
        });

        return {
            toggle: function($e) {
                $block.toggle();
                return false;
            },
            del: function(){
                if(!confirm('<?= _t('', 'Вы уверены?') ?>')) return false;
                $form.find('[name="a"]').val('del');
                return true;
            }
        };
    }());
    <? js::stop(); ?>
</script>