<?php
    $aData = HTML::escape($aData, 'html', array('title', 'company_title', 'company_post', 'fio', 'email'));
    $edit = ($id > 0);
    
    $sNow = date('Y-m-d');
    
    if(!$edit) {
        $aUserinfo = $this->security->getUserInfo(array('name','surname','sex','birthdate'));
        $fio = $aUserinfo['name'].(!empty($aUserinfo['surname']) ? ' '.$aUserinfo['surname'] : '');
        $sex = $aUserinfo['sex'];
        $company_from = $sNow;
        $company_to = $sNow;
        $birthdate = $aUserinfo['birthdate'];
    }
    
    if (empty($phones)){ $phones = array(0=>''); }
    
?>
<div class="h1-wrap">
    <? if(!$edit){ ?>
    <h1 class="mb20"><?= _t('job', 'Новое резюме'); ?></h1>
        <ul class="form-ch">
            <li><?= _t('', 'Поля, отмеченные звездочкой ([span]), обязательны к заполнению.', array(
                    'span' => '<span class="z-att">*</span>',
                )); ?></li>
            <li><span class="red"><b><?= _t('', 'Важно:'); ?></b></span> <?= _t('job', 'резюме хранятся на сайте 60 дней'); ?></li>
        </ul>
    <? } else { ?>
        <h1 class="mb20"><?= _t('job', 'Редактирование резюме'); ?></h1>
        <ul class="form-ch">
            <li><?= _t('', 'Поля, отмеченные звездочкой[span], обязательны к заполнению.', array(
                    'span' => '<span class="z-att">*</span>',
                )); ?></li>
            <li><span class="red"><b><?= _t('', 'Важно:'); ?></b></span> <?= _t('job', 'резюме хранятся на сайте 60 дней'); ?></li>
        </ul>
    <? } ?>
</div>
<div class="realty mt20">
     <div style="display: none;" id="job-error" class="mb20 error"></div>
     <div class="form-box">     
        <script type="text/javascript">
        <? js::start(); ?>
            var jobForm = (function(){
                var $form, $err, $progress, $priceCurr, $priceCurrSel, url = '<?= Job::url('resume.'.($edit?'edit':'add')) ?>';
                function init()
                {
                    $form = $('#job-form');
                    $err = $('#job-error');
                    $progress = $('#job-progress', $form);
                    $form.submit(function(){
                        app.fieldError([this.title, this.price, this.price, this.fio], false);
                        bff.ajax(url, $form.serialize(), function(data, errors) {
                            if(data && data.res) {
                                bff.redirect( data.redirect );
                            } else {
                                app.showError( $err, errors, false, true);
                                if(data.fields) app.fieldErrorForm(data.fields, $form.get(0));
                            }
                        }, $progress);
                        return false;
                    });

                    $priceCurr    = $('#job-price-curr', $form);
                    $priceCurrSel = $('#job-price-curr-sel li', $form);

                    initPhones( $('#job-phones', $form), 'phones', <?= sizeof($phones) ?>, 3);
                }

                function initPhones($block, fieldname, index, lmt)
                {
                    var total = index;
                    var $plus  = $('a.phone-add', $block.parent());

                    $plus.click(function(){
                        if(lmt>0 && total>=lmt) { return false; }
                        index++; total++;
                        $block.append('<div class="phone-item"><div class="inp inp-w3 left mr10"><input type="text" maxlength="50" name="'+fieldname+'['+index+']" value="" /><i></i></div><a href="#" class="ajax f12 phone-remove">- <?= _t('', 'Удалить'); ?></a><div class="clear"></div></div>');
                        return false;
                    });

                    $block.delegate('a.phone-remove', 'click', function(){
                        $(this).parent().remove(); total--;
                        return false;
                    });
                }

                $(function(){ init(); });
                return {
                    onCurr: function(id, a)
                    {
                        id = intval(id);
                        if(id<=0) return false;
                        var activeClass = 'active';
                        $priceCurr.val(id);
                        $priceCurrSel.removeClass( activeClass );
                        $priceCurrSel.find(a).parent().addClass( activeClass );
                        return false;
                    },
                    onTitleTip: function(link)
                    {
                        $form.get(0).title.value = $(link).text();
                        return false;
                    }
                };
            }());
        <? js::stop(); ?>
        </script>
        <form id="job-form" action="">
            <input type="hidden" name="id" value="<?= $id ?>" />
            <input type="hidden" name="hash" value="<?= $token ?>" />
            <table width="100%">
            <tr><td colspan="2"><h3><?= _t('job', 'Пожелания к работе'); ?></h3></td></tr>
            <tr>
                <td class="td1"><?= _t('job', 'Должность'); ?><span class="z-att">*</span></td>
                <td><div class="inp inp-w1"><input type="text" name="title" value="<?= $title ?>" tabindex="1" maxlength="200" /><i></i></div><p class="form-sub-txt"><?= _t('job', 'Если желаемых должностей несколько, можно указать 2-3 названия через запятую. Например: литературный редактор, редактор, корректор.'); ?><br />
                        <?= _t('job', 'Обратите внимание: если должности несходные (то есть сильно различаются по функционалу и требуемым навыкам), то для них нужно создавать отдельные резюме.'); ?></p></td>
            </tr>
            <tr>
                <td class="td1"><?= _t('job', 'Профессиональные навыки'); ?><span class="z-att">*</span><br /><span class="f11 grey"><?= _t('job', 'Опишите свои знания и навыки, [br]которые соответствуют[br] выбранной вами должности.', array(
                            'br' => '<br />',
                        )); ?></span></td>
                <td>
                    <div class="textarea"><textarea cols="25" rows="7" name="description" tabindex="2"><?= $description ?></textarea><i></i></div>
                </td>
            </tr>
            <tr>
                <td class="td1"><?= _t('job', 'Опыт работы [br]в данной должности', array(
                        'br' => '<br />',
                    )); ?><span class="z-att">*</span></td>
                <td><select class="inp-w3" name="experience"><?= $this->getExperience($experience, 'options'); ?></select>
                </td>
            </tr>
            <tr>
                <td class="td1"><?= _t('job', 'Профессиональная сфера'); ?><span class="z-att">*</span></td>
                <td><select class="inp-w3" name="cat_id"><?= $cats ?></select></td>
            </tr>
            <tr>
                <td class="td1"><?= _t('job', 'Минимальная зарплата [br](в месяц)', array(
                        'br' => '<br />',
                    )); ?><span class="z-att">*</span></td>
                <td>
                     <p class="inform-att f12 mb20"><?= _t('', 'Укажите только цифры, без сокращений. Например: 20000'); ?><i></i></p>
                     <br />
                     <div class="inp inp-w2"><input type="text" name="price" id="job-price" value="<?= $price ?>" pattern="[0-9]*" /><i></i></div>
                     <label class="f12"> <input type="checkbox" class="checkbox" name="price_torg" <? if($price_torg){ ?> checked="checked"<? } ?> /> <?= _t('', 'по договоренности'); ?></label>
                     <input type="hidden" name="price_curr" id="job-price-curr" value="<?= $price_curr ?>" />
                     <ul class="val-sp" id="job-price-curr-sel">
                        <? foreach($curr as $v){ ?>
                            <li <?= ($v['a']?' class="active"':'') ?>><a href="#" onclick="return jobForm.onCurr(<?= $v['id'] ?>, this);"><?= $v['title_short'] ?></a></li>
                        <? } ?>
                     </ul>
                </td>
            </tr>
            <tr>
                <td class="td1"><?= _t('job', 'График работы:'); ?><span class="z-att">*</span></td>
                <td>
                    <div class="form-ch-sp"><?= $schedule_html ?></div>
                </td>
            </tr>
            <tr>
                <td class="td1"><?= _t('job', 'Город, где я живу'); ?><span class="z-att">*</span></td>
                <td>
                    <?= Geo::cityOptionsSelect($city_id, true, 'city_id', array('class'=>'inp-w3')); ?><br />
                    <label class="f12"><input class="checkbox" name="city_searchwork" <? if($city_searchwork){ ?> checked="checked"<? } ?> type="checkbox" /> <?= _t('job', 'Ищу работу в этом городе'); ?></label><br /><label class="f12"><input class="checkbox" type="checkbox" name="city_readytomove" <? if($city_readytomove){ ?> checked="checked"<? } ?> /> <?= _t('', 'Готов к перезду'); ?></label></td>
            </tr>
            <tr>
                <td colspan="2"><br><div class="separatornobr"></div></td>
            </tr>
            <tr><td colspan="2"><br /><h3><?= _t('job', 'Образование и другие навыки'); ?></h3></td></tr>
            <tr>
                <td class="td1"><?= _t('job', 'Основное образование'); ?></td>
                <td>
                    <div class="form-ch-sp"><?= $this->getEducation($education, 'radio'); ?></div>
                </td>
            </tr>
            <tr>
                <td class="td1"><?= _t('job', 'Знание ПК [start](уровень)[stop]', array(
                        'start' => '<span class="f11">',
                        'stop'  => '</span>',
                    )); ?></td>
                <td>
                    <div class="form-ch-sp"><?= $this->getPCLevel($pclevel, 'radio'); ?></div>
                </td>
            </tr>
            <tr>
                <td colspan="2"><br><div class="separatornobr"></div></td>
            </tr>
            <tr><td colspan="2"><br /><h3><?= _t('job', 'Последнее место работы'); ?></h3></td></tr>
            <tr>
                <td class="td1"><?= _t('job', 'Название компании'); ?></td>
                <td><div class="inp inp-w1"><input type="text" name="company_title" value="<?= $company_title ?>" maxlength="200" /><i></i></div></td>
            </tr>
            <tr>
                <td class="td1"><?= _t('job', 'Должность'); ?></td>
                <td><div class="inp inp-w1"><input type="text" name="company_post" value="<?= $company_post ?>" maxlength="200" /><i></i></div></td>
            </tr>
            <tr>
                <td class="td1"><?= _t('job', 'Служебные обязанности'); ?><br /><span class="f11 grey"><?= _t('job', 'Постарайтесь максимально подробно[br] и точно описать ваши обязанности.', array(
                            'br' => '<br />',
                        )); ?></span></td>
                <td>
                    <div class="textarea"><textarea cols="25" rows="7" name="company_duty"><?= $company_duty ?></textarea><i></i></div>
                </td>
            </tr>
            <tr>
                <td class="td1"><?= _t('job', 'Период работы'); ?></td>
                <td class="form-ch-date">
                    <?
                        $c_from = $this->getDateOptions( $company_from, 0, 1990  );
                        $c_to = $this->getDateOptions( $company_to, 0, 1990  );
                    ?>
                    <p><span class="ss"><?= _t('', 'с'); ?></span> <select name="company_from[day]"><?= $c_from['day'] ?></select> <select name="company_from[month]"><?= $c_from['month'] ?></select> <select name="company_from[year]"><?= $c_from['year'] ?></select></p>
                    <p><span class="ss"><?= _t('', 'по'); ?></span>  <select name="company_to[day]"><?= $c_to['day'] ?></select> <select name="company_to[month]"><?= $c_to['month'] ?></select> <select name="company_to[year]"><?= $c_to['year'] ?></select></p>
                </td>
            </tr>
            <tr>
                <td colspan="2"><br><div class="separatornobr"></div></td>
            </tr>
            <tr><td colspan="2"><br /><h3><?= _t('job', 'Личные сведения'); ?></h3></td></tr>
            <tr>
                <td class="td1"><?= _t('', 'Фамилия, Имя, Отчество'); ?><span class="z-att">*</span></td>
                <td><div class="inp inp-w1"><input name="fio" value="<?= $fio ?>" type="text" /><i></i></div></td>
            </tr>
            <tr>
                <td class="td1"><?= _t('', 'Дата рождения'); ?><span class="z-att">*</span></td>
                <? $birthdate = $this->getDateOptions( $birthdate, 10, 1940 ); ?>
                <td><select name="birthdate[day]"><?= $birthdate['day'] ?></select> <select name="birthdate[month]"><?= $birthdate['month'] ?></select> <select name="birthdate[year]"><?= $birthdate['year'] ?></select></td>
            </tr>
            <tr>
                <td class="td1"><?= _t('', 'Пол'); ?><span class="z-att">*</span></td>
                <td>
                    <label><input type="radio" name="sex" value="<?= Users::SEX_MALE ?>" <? if($sex == Users::SEX_MALE){ ?> checked="checked"<? } ?> /> <?= _t('', 'мужчина'); ?></label>
                    <label><input type="radio" name="sex" value="<?= Users::SEX_FEMALE ?>" <? if($sex == Users::SEX_FEMALE){ ?> checked="checked"<? } ?> /> <?= _t('', 'женщина'); ?></label>
                </td>
            </tr>
            <tr>
                <td class="td1"><?= _t('', 'Контактный телефон'); ?><span class="z-att">*</span></td>
                <td>
                    <div id="job-phones">
                        <? foreach($phones as $k=>$v) { ?>
                            <div class="phone-item"><div class="inp inp-w3 left mr10"><input type="tel" maxlength="50" name="phones[<?= $k+1 ?>]" value="<?= HTML::escape($v) ?>" tabindex="5" /><i></i></div><? if(!$k){ ?><a href="#" class="ajax f12 phone-add">+ <?= _t('', 'Добавить'); ?></a><? } else { ?><a href="#" class="ajax f12 phone-remove">- <?= _t('', 'Удалить'); ?></a><? } ?><div class="clear"></div></div>
                        <? } ?>
                    </div>
                </td>
            </tr>
            <tr>
                <td class="td1"><?= _t('', 'Email'); ?></td>
                <td><div class="inp inp-w3 left mr10"><input type="text" name="email" value="<?= $email ?>" /><i></i></div></td>
            </tr>
            <tr>
                <td></td>
                <td>
                    <div class="btn mr10 left"><input type="submit" value="<?= ($edit ? _t('', 'сохранить изменения') : _t('job', 'добавить резюме')) ?>" /><i></i></div>
                    <div class="progress" id="job-progress" style="display: none; margin-top: 9px;"></div>
                </td>
            </tr>
            </table>
            <div class="separator"></div>
        </form>
    </div>
</div>