<?php
    $aData = HTML::escape($aData, 'html', array('title', 'company_title', 'company_addr', 'company_phone', 'company_email', 'company_contact'));
    $edit = ($id > 0);
    
    if( ! $edit) {
        $aUserinfo = $this->security->getUserInfo(array('name','surname'));
        $company_contact = $aUserinfo['name'].(!empty($aUserinfo['surname']) ? ' '.$aUserinfo['surname'] : '');
    }
?>
<div class="h1-wrap">
    <? if( ! $edit){ ?>
    <h1 class="mb20"><?= _t('job', 'Новая вакансия'); ?></h1>
    <ul class="form-ch">
        <li><?= _t('job', 'Вакансия появится на сайте после проверки (1-2 дня).'); ?></li>
        <li><?= _t('', 'Поля, отмеченные звездочкой ([span]), обязательны к заполнению.', array(
                'span' => '<span class="z-att">*</span>',
            )); ?></li>
        <li><span class="red"><b><?= _t('', 'Важно:'); ?></b></span> <?= _t('job', 'вакансии хранятся на сайте 60 дней'); ?></li>
     </ul>
     <? } else { ?>
    <h1 class="mb20"><?= _t('job', 'Редактирование вакансии'); ?></h1>
    <ul class="form-ch">
        <li><?= _t('', 'Поля, отмеченные звездочкой[span], обязательны к заполнению.', array(
                'span' => '<span class="z-att">*</span>',
            )); ?></li>
        <li><span class="red"><b><?= _t('', 'Важно:'); ?></b></span> <?= _t('job', 'вакансии хранятся на сайте 60 дней'); ?></li>
     </ul>     
     <? } ?>
</div>
<div class="realty mt20">
     <div style="display: none;" id="job-error" class="mb20 error"></div>
     <div class="form-box">
        <script type="text/javascript">
        <? js::start(); ?>
            var jobForm = (function(){
                var $form, $err, $progress, $priceCurr, $priceCurrSel, url = '<?= Job::url('vacancy.'.($edit?'edit':'add')) ?>';
                var companyID = -1, company = {};
                function init()
                {
                    $form = $('#job-form');
                    $err = $('#job-error');
                    $progress = $('#job-progress', $form);
                    $form.submit(function(){
                        app.fieldError([this.title, this.price, this.price, this.company_title, this.company_phone, this.company_email, this.company_contact], false);
                        bff.ajax(url, $form.serialize(), function(data, errors) {
                            if(data && data.res) {
                                bff.redirect( data.redirect );
                            } else {
                                app.showError( $err, errors, false, true);
                                if(data.fields) app.fieldErrorForm(data.fields, $form.get(0));
                            }
                        }, $progress);
                        return false;
                    });

                    $priceCurr    = $('#job-price-curr', $form);
                    $priceCurrSel = $('#job-price-curr-sel li', $form);
                }

                function setCompanyContacts(id)
                {
                    var form = $form.get(0);
                    var c = ( id ===0 ? {addr:'',phone:'',email:'',city:0} : company[id]);
                    form.company_cityid.value= c.city;
                    form.company_addr.value  = c.addr;
                    form.company_phone.value = c.phone;
                    form.company_email.value = c.email;
                }

                $(function(){ init(); });
                return {
                    onCurr: function(id, a)
                    {
                        id = intval(id);
                        if(id<=0) return false;
                        var activeClass = 'active';
                        $priceCurr.val(id);
                        $priceCurrSel.removeClass( activeClass );
                        $priceCurrSel.find(a).parent().addClass( activeClass );
                        return false;
                    },
                    onTitleTip: function(link)
                    {
                        $form.get(0).title.value = $(link).text();
                        return false;
                    },
                    onCompany: function(sel)
                    {
                        sel = $(sel);
                        var id = intval(sel.val());

                        if(id === companyID) return false;
                        var other = sel.next();
                        var empty = sel.find('option[value="-1"]');
                        if(empty.length) empty.remove();

                        companyID = id;
                        if(companyID===0) {
                            other.removeClass('displaynone').find('input:first').focus();
                            setCompanyContacts( 0 );
                        } else {
                            other.addClass('displaynone');
                            if(company.hasOwnProperty(companyID)) {
                                setCompanyContacts( companyID );
                            } else {
                                bff.ajax('<?= bff::urlAjax('job','company_contacts') ?>', {company_id: id}, function(data){
                                    if(data && data.res) {
                                        company[ companyID ] = data.contacts;
                                        setCompanyContacts( companyID );
                                    }
                                });
                            }
                        }
                    }
                };
            }());
        <? js::stop(); ?>
        </script>
            <form id="job-form" action="">
            <input type="hidden" name="id" value="<?= $id ?>" />
            <input type="hidden" name="hash" value="<?= $token ?>" />
            <table width="100%">
            <tr><td colspan="2"><h3><?= _t('job', 'Информация о вакансии'); ?></h3></td></tr>
            <tr>
                <td class="td1"><?= _t('job', 'Название должности'); ?><span class="z-att">*</span></td>
                <td><div class="inp inp-w1"><input type="text" name="title" value="<?= $title ?>" tabindex="1" maxlength="200" /><i></i></div><p class="form-sub-txt"><?= _t('', 'например,'); ?> <a href="#" onclick="return jobForm.onTitleTip(this);"><?= _t('job', 'менеджер по продажам'); ?></a></p></td>
            </tr>
            <tr>
                <td class="td1"><?= _t('job', 'Описание вакансии'); ?><span class="z-att">*</span><br /><span class="f11 grey"><?= _t('job', 'Постарайтесь максимально подробно[br] и точно описать вакансию.', array(
                            'br' => '<br />',
                        )); ?></span></td>
                <td>
                    <div class="textarea"><textarea cols="25" rows="7" name="description" tabindex="2"><?= $description ?></textarea><i></i></div>
                </td>
            </tr>
            <tr>
                <td class="td1"><?= _t('', 'Город'); ?><span class="z-att">*</span></td>
                <td>
                    <?= Geo::cityOptionsSelect($city_id, true, 'city_id', array('class'=>'inp-w3')); ?>
                </td>
            </tr>
            <tr>
                <td class="td1"><?= _t('job', 'Сфера деятельности'); ?><span class="z-att">*</span></td>
                <td><select class="inp-w3" name="cat_id"><?= $cats ?></select></td>
            </tr>
            <tr>
                <td class="td1"><?= _t('job', 'График работы:'); ?><span class="z-att">*</span></td>
                <td>
                    <div class="form-ch-sp"><?= $schedule_html ?></div>
                </td>
            </tr>
            <tr>
                <td class="td1"><?= _t('job', 'Зарплата, от...'); ?><span class="z-att">*</span></td>
                <td>
                     <p class="inform-att f12 mb20"><?= _t('', 'Укажите только цифры, без сокращений. Например: 20000'); ?><i></i></p>
                     <br />
                     <div class="inp inp-w2"><input type="text" name="price" id="job-price" value="<?= $price ?>" pattern="[0-9]*" /><i></i></div>
                     <label class="f12"> <input type="checkbox" class="checkbox" name="price_torg" <? if($price_torg){ ?> checked="checked"<? } ?> /> <?= _t('', 'по договоренности'); ?></label>
                     <input type="hidden" name="price_curr" id="job-price-curr" value="<?= $price_curr ?>" />
                     <ul class="val-sp" id="job-price-curr-sel">
                        <? foreach($curr as $v){ ?>
                            <li <?= ($v['a']?' class="active"':'') ?>><a href="#" onclick="return jobForm.onCurr(<?= $v['id'] ?>, this);"><?= $v['title_short'] ?></a></li>
                        <? } ?>
                     </ul>
                </td>
            </tr>
            <tr>
                <td colspan="2"><br /><div class="separatornobr"></div></td>
            </tr>
            <tr><td colspan="2"><br /><h3><?= _t('job', 'Информация о работодателе'); ?></h3></td></tr>
            <tr>
                <td class="td1"><?= _t('job', 'Компания'); ?><span class="z-att">*</span></td>
                <td>
                    <? if(!empty($agent_company))
                       {
                            if(!$edit) array_unshift($agent_company, array('id'=>-1, 'title'=> _t('', 'Выбрать')));
                            $agent_company[] = array('id'=>0, 'title'=>_t('', 'Другая'), 'a'=>($edit && !$company_id ? 1 : 0));
                            if($edit && $company_id > 0) {
                                foreach($agent_company as $k=>$v) {
                                    $agent_company[$k]['a'] = 0;
                                    if($v['id'] == $company_id) {
                                        $agent_company[$k]['a'] = 1;
                                        break;
                                    }
                                }
                            }
                            ?>
                    <select class="inp-w3" name="company_id" onchange="jobForm.onCompany(this);"><? foreach($agent_company as $v){ echo '<option value="'.$v['id'].'"'.(!empty($v['a']) ? ' selected="selected"':'').'>'.$v['title'].'</option>'; } ?></select>
                    <? } ?>
                    <div<? if((!$edit && !empty($agent_company)) || ($edit && $company_id) ){ ?> class="displaynone"<? } ?> style="margin-top: 10px;">
                        <div class="inp inp-w1"><input type="text" name="company_title" value="<?= $company_title ?>" maxlength="200" /><i></i></div>
                        <label class="f12"><input class="checkbox" type="checkbox" name="company_staffagency" <? if($company_staffagency){ ?> checked="checked"<? } ?> /> <?= _t('job', 'Кадровое агенство'); ?></label>
                    </div>
                </td>
            </tr>
            <tr>
                <td class="td1"><?= _t('', 'Город'); ?><span class="z-att">*</span></td>
                <td><?= Geo::cityOptionsSelect($company_cityid, true, 'company_cityid', array('class'=>'inp-w3')); ?></td>
            </tr>
            <tr>
                <td class="td1"><?= _t('', 'Адрес'); ?></td>
                <td>
                    <div class="inp inp-w1"><input type="text" name="company_addr" value="<?= $company_addr ?>" maxlength="250" /><i></i></div>
                </td>
            </tr>
            <tr>
                <td class="td1"><?= _t('', 'Телефон'); ?><span class="z-att">*</span></td>
                <td>
                    <div class="inp inp-w3"><input type="text" name="company_phone" value="<?= $company_phone ?>" /><i></i></div>
                </td>
            </tr>
            <tr>
                <td class="td1"><?= _t('', 'Email'); ?><span class="z-att">*</span></td>
                <td>
                    <div class="inp inp-w3"><input type="text" name="company_email" value="<?= $company_email ?>" /><i></i></div>
                </td>
            </tr>
            <tr>
                <td class="td1"><?= _t('', 'Контактное лицо'); ?><span class="z-att">*</span></td>
                <td>
                    <div class="inp inp-w1"><input type="text" name="company_contact" value="<?= $company_contact ?>" /><i></i></div>
                </td>
            </tr>
            <tr>
                <td></td>
                <td>
                    <div class="btn mr10 left"><input type="submit" value="<?= ($edit ? _t('', 'сохранить изменения') : _t('', 'добавить вакансию')) ?>" /><i></i></div>
                    <div class="progress" id="job-progress" style="display: none; margin-top: 9px;"></div>
                </td>
            </tr>
            </table>
            <div class="separator"></div>
            </form>
     </div>
</div>

