<?php

/**
 * Права доступа группы:
 *  - publications: Публикации
 *      -- описание находится в файле /modules/publications/tpl/access-to.txt
 */
class Publications extends PublicationsBase
{

    function listing($typeID, $typeKey)
    {
        if (!$this->haveAccessTo('items-listing', 'publications-' . $typeKey)) {
            return $this->showAccessDenied();
        }
        $aData = array('f' => array(), 'type' => $this->type);

        $sqlTable = $this->getItemsTable($typeKey);

        if (Request::isAJAX()) {
            $sAction = $this->input->get('act');

            switch ($sAction) {
                case 'toggle':
                {
                    if (!$this->haveAccessTo('items-manage', 'publications-' . $typeKey)) {
                        return $this->showAccessDenied();
                    }

                    $nItemID = $this->input->get('item_id', TYPE_UINT);
                    if (!$nItemID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $aItemData = $this->model->itemData($nItemID, array('enabled','publicated','city_id','category_id'), $typeID);
                    if (empty($aItemData)) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $this->model->itemSave($nItemID, array('enabled = (1 - enabled)'), $typeID);

                    # актуализируем: календарь, RSS
                    $this->calendarUpdate($typeID, $aItemData['publicated'], $aItemData['city_id'], ($aItemData['enabled'] ? -1 : 1));
                    $this->rssUpdate($typeID, $aItemData['category_id']);

                    $this->ajaxResponse(Errors::SUCCESS);
                }
                break;
                case 'tags-autocomplete': # autocomplete
                {
                    $sQ = $this->input->post('q', TYPE_NOTAGS);
                    $this->initTags($typeID)->tagsAutocomplete($sQ);
                }
                break;
                case 'delete':
                {
                    if (!$this->haveAccessTo('items-delete', 'publications-' . $typeKey)) {
                        return $this->showAccessDenied();
                    }

                    $nItemID = $this->input->postget('item_id', TYPE_UINT);
                    if (!$nItemID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $res = $this->deleteItem($nItemID, $typeID);

                    $this->ajaxResponse(($res ? Errors::SUCCESS : Errors::IMPOSSIBLE));
                }
                break;
            }
        }

        $aData['orders'] = array('id' => 'desc');

        $f = $this->input->postgetm(array(
            'page'     => TYPE_UINT,
            'category' => TYPE_UINT,
            'city'     => TYPE_UINT,
            'mod'      => TYPE_BOOL,
            'tag'      => TYPE_UINT,
            'p_from'   => TYPE_STR,
            'p_to'     => TYPE_STR,
            'title'    => TYPE_NOTAGS,
        ));

        $bModeration = $this->type->moderationEnabled();

        $sqlWhere = array();
        if ($f['category'] > 0) {
            $sqlWhere[] = 'I.category_id = ' . $f['category'];
        }
        if ($bModeration) {
            if ($this->type->moderationPost()) {
                if ($f['mod']) {
                    $sqlWhere[] = 'I.moderated = 0';
                }
            } else {
                $sqlWhere[] = 'I.moderated = ' . ($f['mod'] ? 0 : 1);
            }
        }

        $sqlTag = '';
        if ($f['tag'] > 0 && $this->type->tagsEnabled()) {
            $aData['tag'] = $this->initTags($typeID)->tagData($f['tag']);
            if (!empty($aData['tag'])) {
                $sqlTag = ' INNER JOIN ' . TABLE_PUB_TAGS_IN . ' T ON T.type_id = '.$typeID.' AND T.item_id = I.id AND T.tag_id = ' . $f['tag'] . ' ';
            }
        }
        if (empty($sqlTag)) {
            $f['tag'] = 0;
        }

        if (!empty($f['p_from'])) {
            $p_from = strtotime($f['p_from']);
            if (!empty($p_from)) {
                $sqlWhere[] = 'DATE(I.publicated) >= ' . $this->db->str2sql(date('Y-m-d', $p_from));
            }
        }
        if (!empty($f['p_to'])) {
            $p_to = strtotime($f['p_to']);
            if (!empty($p_to)) {
                $sqlWhere[] = 'DATE(I.publicated) <= ' . $this->db->str2sql(date('Y-m-d', $p_to));
            }
        }

        if (!empty($f['title'])) {
            if (is_numeric($f['title'])) {
                $sqlWhere[] = 'I.id = '. $this->db->str2sql($f['title']);
            } else {
                $sqlWhere[] = 'IL.title LIKE '. $this->db->str2sql('%'.$f['title'].'%');
            }
        }


        if ($f['city'] > 0) {
            $sqlWhere[] = 'I.city_id = ' . $f['city'];
        }

        $sqlWhere = (!empty($sqlWhere) ? ' WHERE ' . join(' AND ', $sqlWhere) : '');

        # MySQL only
        $nCount = $this->db->one_data('
            SELECT STRAIGHT_JOIN COUNT(*)
            FROM ' . $sqlTable . ' I ' . $sqlTag . '
                INNER JOIN ' . TABLE_PUB_ITEMS_LANG . ' IL ON ' . $this->model->langAnd($this->type->id, false, 'I', 'IL') . '
                ' . $sqlWhere);
        $this->prepareOrder($orderBy, $orderDirection, 'id-desc', $aData['orders']);
        $this->tplAssigned(array('order_by', 'order_dir', 'order_dir_needed'), $f);
        $f['order'] = $orderBy . '-' . $orderDirection;

        $aData['pgn'] = $this->generatePagenation($nCount, 15, 'pubItems.page({pageId})', $sqlLimit, 'pagenation.ajax.tpl', 'page', true);

        # MySQL only
        $aData['list'] = $this->db->select('SELECT STRAIGHT_JOIN I.id, IL.title, I.link as linkout, I.comments, I.enabled, I.created, I.moderated,
                U.login as created_login, I.created_uid, CL.title as category_title, I.category_id
            FROM '.$sqlTable.' I
                '.$sqlTag.'
                INNER JOIN ' . TABLE_PUB_ITEMS_LANG . ' IL ON ' . $this->model->langAnd($this->type->id, false, 'I', 'IL') . '
                LEFT JOIN ' . TABLE_USERS . ' U ON U.user_id = I.created_uid
                LEFT JOIN ' . TABLE_PUB_CATEGORIES_LANG . ' CL ON I.category_id = CL.id AND CL.lang = :lang
            '.$sqlWhere.'
            ORDER BY I.'.$orderBy.' '.$orderDirection.' '.$sqlLimit,
        array(':lang'=>LNG));

        $aData['list'] = $this->viewPHP($aData, 'admin.items.listing.ajax');

        if (Request::isAJAX()) {
            $this->ajaxResponse(array(
                'list'   => $aData['list'],
                'pgn'    => $aData['pgn'],
                'filter' => $f,
            ));
        }

        $aData['f'] = $f;
        return $this->viewPHP($aData, 'admin.items.listing');
    }

    function add($typeID, $typeKey)
    {
        if (!$this->haveAccessTo('items-manage', 'publications-' . $typeKey)) {
            return $this->showAccessDenied();
        }

        $isPublicator = ($this->type->contentPublicator());
        if ($isPublicator) {
            # инициализируем всегда, для обработки ajax запросов от публикатора
            $oPublicator = $this->initPublicator(array('id'=>0));
        }

        $aData = $this->processItemData(0);
        $referer = $this->input->post('referer', TYPE_STR);
        $referer = (!empty($referer) ? $referer : Request::referer());

        if (Request::isPOST()) {

            if (!$this->type->publicatedDateEnabled()) {
                $aData['publicated'] = $this->db->now();
            }

            # если автор указывается текстом или userID не указали, ставим текущего
            if ($this->type->authorText() || empty($aData['user_id'])) {
                $aData['user_id'] = User::id();
            }

            $bRedirect = $this->input->getpost('redirect', TYPE_BOOL);

            $aData['moderated'] = 1;

            if ($this->errors->no()) {
                $nItemID = $this->model->itemSave(0, $aData);
                if ($nItemID) {
                    if ($this->type->tagsEnabled()) {
                        $this->initTags($typeID)->tagsSave($nItemID);
                    }
                    if ($this->type->imgEnabled() && !empty($aData['img'])) {
                        # переносим изображение из временной папки в постоянную
                        $oImages = $this->initImages(array('id' => $nItemID, 'publicated' => $aData['publicated']));
                        $oImages->untemp($aData['img']);
                    }
                    if ($isPublicator) {
                        # переносим фотографии публикатора из временной папки в постоянную
                        # повторно выполняем инициализацию - с целью построения постоянного пути
                        # к изображениям (на основе даты публикации)
                        $oPublicator = $this->initPublicator(array('id' => $nItemID, 'publicated' => $aData['publicated']));
                        $oPublicator->dataUpdate($aData['content'], $nItemID);
                        # загружаем изображение для типа "Видео"
                        if ($typeID == self::TYPE_VIDEO && $this->type->imgEnabled() && empty($aData['img'])) {
                            $aPublicatorVideo = $oPublicator->dataVideo($aData['content']);
                            if (!empty($aPublicatorVideo[0]['thumb'])) {
                                $oImages = $this->initImages(array('id' => $nItemID, 'publicated' => $aData['publicated']));
                                PublicationsVideo::downloadImage($aPublicatorVideo[0]['thumb'], $oImages);
                            }
                        }
                    }

                    if ($this->prepareItemTitle($nItemID, $aData)) {
                        $this->model->itemSave($nItemID, array(
                                'title'        => $aData['title'],
                                'title_params' => $aData['title_params'],
                                'link'         => $aData['link']
                            )
                        );
                    }

                    # сразу публикуем:
                    if ($aData['enabled']) {
                        # фиксируем в календаре
                        $this->calendarUpdate($typeID, $aData['publicated'], $aData['city_id'], 1);
                        # актуализируем RSS
                        $rssCategoryID = ( isset($aData['category_id']) ? $aData['category_id'] : 0 );
                        $this->rssUpdate($typeID, $rssCategoryID);
                    }

                    if ($aData['user_id'] && $typeID == self::TYPE_NAROD) {
                        $this->security->userCounter('narod', 1, $aData['user_id']);
                    }

                    $this->adminRedirect(Errors::SUCCESS, ($bRedirect ? $typeKey . ':listing' : $typeKey . ':edit&item_id=' . $nItemID));
                }
            } else {
                if ($this->type->extra['title_link']) {
                    $aTitleParams = (!empty($aData['title_params']) ? func::unserialize($aData['title_params']) : array(
                        'title' => $aData['title'],
                        'link'  => $aData['link']
                    ));
                    if (!empty($aTitleParams)) {
                        $aData['title'] = $aTitleParams['title'];
                        $aData['link'] = $aTitleParams['link'];
                    }
                }
                if ($this->type->extra['source_link']) {
                    $aData['extra_source_link'] = (!empty($aData['extra_source_link']) ? func::unserialize($aData['extra_source_link']) : false);
                    if (empty($aData['extra_source_link'])) {
                        $aData['extra_source_link'] = array('link' => '', 'title' => '');
                    }
                }
                if ($isPublicator) {
                    $aData['content'] = $oPublicator->unserialize($aData['content']);
                }
            }
        }

        $aData['id'] = 0;
        $aData['referer'] = $referer;

        return $this->viewPHP($aData, 'admin.items.form');
    }

    function edit($typeID, $typeKey)
    {
        if (!$this->haveAccessTo('items-manage', 'publications-' . $typeKey)) {
            return $this->showAccessDenied();
        }

        $sqlTable = $this->getItemsTable($typeKey);

        $nUserID = User::id();
        $nItemID = $this->input->get('item_id', TYPE_UINT);
        $isPublicator = $this->type->contentPublicator();
        if ($isPublicator) {
            if (!$nItemID) {
                $nItemID = $this->input->post('id', TYPE_UINT);
            }
        }

        if (!$nItemID) {
            $this->adminRedirect(Errors::UNKNOWNRECORD, $typeKey . ':listing');
        }

        $bUser = ($this->type->authorUser());
        $sqlSelect = 'SELECT I.*, U2.login as modified_login ' . ($bUser ? ', U1.login as user_login' : '') . '
                       FROM ' . $sqlTable . ' as I
                            ' . ($bUser ? ' LEFT JOIN ' . TABLE_USERS . ' as U1 ON U1.user_id = I.user_id ' : '') . '
                            , ' . TABLE_USERS . ' as U2
                        WHERE I.id = ' . $nItemID . ' AND U2.user_id = I.modified_uid';

        $aData = $this->db->one_array($sqlSelect);
        if (empty($aData)) {
            $this->adminRedirect(Errors::UNKNOWNRECORD, $typeKey . ':listing');
        }
        $this->db->langSelect(array(
                'id'      => $nItemID,
                'type_id' => $this->type->id
            ), $aData, $this->model->langItems, TABLE_PUB_ITEMS_LANG
        );
        if ($isPublicator) {
            # инициализируем всегда, для обработки ajax запросов от публикатора
            $oPublicator = $this->initPublicator(array('id' => $nItemID, 'publicated' => $aData['publicated']));
        }

        $bShowModeration = ($this->type->moderationEnabled() && !$aData['moderated']);

        $referer = $this->input->post('referer', TYPE_STR);
        $referer = (!empty($referer) ? $referer : Request::referer());

        if (Request::isPOST()) {

            # список изменений
            $aChanged = array(
                'title'         => 0,
                'category'      => 0,
                'publicated'    => 0,
                'content_short' => 0,
                'img'           => 0,
                'enabled'       => 0
            );

            $bModerated = ($bShowModeration && $this->input->post('moderated', TYPE_BOOL));

            $aDataPrev = $aData;
            $aData = $this->processItemData($nItemID, array('publicated' => $aData['publicated']));

            if ($bModerated) {
                $aData['moderated'] = 1;
                $aData['moderated_uid'] = $nUserID;
            }
            foreach ($aDataPrev['title'] as $lng => $v) {
                if (isset($aData['title'][$lng]) && $aData['title'][$lng] != $v) {
                    $aChanged['title'] = 1;
                }
                if ($this->type->contentShort()) {
                    if (isset($aData['content_short'][$lng]) && $aData['content_short'][$lng] != $v) {
                        $aChanged['content_short'] = 1;
                    }
                }
            }
            $aChanged['enabled'] = ($aData['enabled'] != $aDataPrev['enabled'] ? 1 : 0);
            $aChanged['yandex'] = ($aData['extra_xml_yandex'] != $aDataPrev['extra_xml_yandex'] ? 1 : 0);
            if ($this->type->categoriesEnabled() && $aDataPrev['category_id'] != $aData['category_id']) {
                $aChanged['category'] = 1;
            }
            if ($this->type->imgEnabled() && $aData['img'] != $aDataPrev['img']) {
                $aChanged['img'] = 1;
            }

            if ($this->type->publicatedDateEditable()) # редактируем дату публикации
            {
                # фиксируем в календаре изменение даты публикации
                if ($aData['enabled'] != $aDataPrev['enabled'] ||
                    $aData['publicated'] != $aDataPrev['publicated']
                ) {
                    if ($aData['publicated'] != $aDataPrev['publicated']) {
                        if ($aDataPrev['enabled']) {
                            $this->calendarUpdate($typeID, $aDataPrev['publicated'], $aDataPrev['city_id'], -1);
                        }
                        if ($aData['enabled']) {
                            $this->calendarUpdate($typeID, $aData['publicated'], $aData['city_id'], 1);
                        }
                        $aChanged['publicated'] = 1;
                    } else {
                        $this->calendarUpdate($typeID, $aData['publicated'], $aData['city_id'], ($aData['enabled'] && !$aDataPrev['enabled'] ? 1 : -1));
                    }
                }
            } else {
                if ($this->type->publicatedTimeEditable() && !empty($aData['publicate_time'])) # редактируем только время
                {
                    list($curDate, $curTime) = explode(' ', $aDataPrev['publicated']);
                    if ($curTime != $aData['publicate_time']) {
                        $aData['publicated'] = $curDate . ' ' . $aData['publicate_time'];
                        $aChanged['publicated'] = 1;
                    }
                    unset($aData['publicate_time']);
                }
            }
            if ($this->errors->no()) {
                $res = $this->model->itemSave($nItemID, $aData);
                if (!empty($res)) {
                    if ($bModerated) {
                        $this->itemsModerationCounter($typeID, -1);
                    }

                    # загружаем изображение для типа "Видео"
                    if ($typeID == self::TYPE_VIDEO && $isPublicator && $this->type->imgEnabled() && empty($aData['img'])) {
                        $aPublicatorVideo = $oPublicator->dataVideo($aData['content']);
                        if (!empty($aPublicatorVideo[0]['thumb'])) {
                            $oImages = $this->initImages(array('id' => $nItemID, 'publicated' =>($this->type->publicatedDateEditable() ? $aData['publicated'] : $aDataPrev['publicated'])));
                            PublicationsVideo::downloadImage($aPublicatorVideo[0]['thumb'], $oImages);
                        }
                    }

                    # публикация была измененена
                    if (array_sum($aChanged) > 0) {
                        $rssCategoryID = ( isset($aData['category_id']) ? $aData['category_id'] : 0 );
                        $this->rssUpdate($typeID, $rssCategoryID);
                    }

                    $bRedirect = $this->input->post('redirect', TYPE_BOOL);
                    if (!$bRedirect) {
                        $this->errors->success();
                        $aData = $this->db->one_array($sqlSelect);
                        $this->db->langSelect(array(
                                'id'      => $nItemID,
                                'type_id' => $this->type->id
                            ), $aData, $this->model->langItems, TABLE_PUB_ITEMS_LANG
                        );
                    } else {
                        if (!empty($referer) && strpos($referer, ':edit') === false) {
                            $this->redirect($referer);
                        } else {
                            $this->adminRedirect(Errors::SUCCESS, $typeKey . ':listing');
                        }
                    }
                }
            }
        }

        if ($isPublicator) {
            $aData['content'] = $oPublicator->unserialize($aData['content']);
        }

        $aTitleParams = unserialize($aData['title_params']);
        if (!empty($aTitleParams)) {
            foreach ($this->locale->getLanguages(true) as $lang) {
                if (!empty($aTitleParams['title'][$lang])) {
                    $aData['title'][$lang] = $aTitleParams['title'][$lang];
                } else {
                    $aData['title'][$lang] = '';
                }
            }
            $aData['link'] = $aTitleParams['link'];
        }

        if ($this->type->extra['title_link'])
        {
            $aData['extra_source_link'] = (!empty($aData['extra_source_link']) ? unserialize($aData['extra_source_link']) : false);
            if (empty($aData['extra_source_link'])) {
                $aData['extra_source_link'] = array('link' => '', 'title' => '');
            }
        }

        if ($typeID == self::TYPE_COMPANY) {
            $aData['company_data'] = Items::model()->companyData($aData['company_id']);
        }

        $aData['moderation'] = ($bShowModeration ? 1 : 0);
        $aData['referer'] = $referer;

        return $this->viewPHP($aData, 'admin.items.form');
    }

    function img_upload($typeID, $typeKey)
    {
        if (!$this->haveAccessTo('items-manage', 'publications-' . $typeKey)) {
            return $this->showAccessDenied();
        }

        $nItemID = $this->input->get('item_id', TYPE_UINT);

        $oImages = false;
        if ($nItemID > 0) {
            $aItemData = $this->db->one_array('SELECT id, publicated FROM ' . $this->getItemsTable($typeKey) . ' WHERE id = ' . $nItemID);
            if (!empty($aItemData)) {
                $oImages = $this->initImages(array('id' => $nItemID, 'publicated' => $aItemData['publicated']));
            }
        } else {
            $oImages = $this->initImages(array('id' => $nItemID));
        }
        $aData = array();

        if ($oImages !== false) {
            $aResult = $oImages->upload('img');
            if ($aResult !== false) {
                $aData = $aResult;
                $aData['success'] = 1;
            } else {
                $aData['success'] = 0;
            }
        } else {
            $aData['success'] = 0;
        }
        $aData['item_id'] = $nItemID;

        $this->iframeResponseForm($aData);
    }

    function ajax()
    {
        if (!$this->security->haveAccessToAdminPanel()) {
            $this->ajaxResponse(Errors::ACCESSDENIED);
        }

        $typeID = $this->input->getpost('type', TYPE_UINT);
        $type = $this->getTypeSettings($typeID);
        $typeKey = $type->keyword;

        if (Request::isAJAX(null)) //get или post ajax запросы, для autocomplete.fb
        {
            switch ($this->input->get('act')) {
                case 'item-tags-autocomplete': #autocomplete.fb
                {
                    $sTag = $this->input->postget('tag', TYPE_STR);
                    $this->initTags($typeID)->tagsAutocomplete($sTag);
                }
                break;
                case 'item-author-autocomplete': # autocomplete
                {
                    if (!$this->haveAccessTo('items-manage', 'publications-' . $typeKey)) {
                        $this->ajaxResponse(Errors::ACCESSDENIED);
                    }

                    $sQ = $this->input->post('q', TYPE_NOTAGS);
                    # получаем список подходящих по логину пользователей, исключая:
                    # - заблокированных пользователей
                    $aData = $this->db->select('SELECT U.user_id, U.login FROM ' . TABLE_USERS . ' U
                                  WHERE U.login LIKE (:q) AND U.blocked = 0
                                  ORDER BY U.login'.$this->db->prepareLimit(0,10), array(':q'=>$sQ.'%'));
                    $this->autocompleteResponse($aData, 'user_id', 'login');
                }
                break;
                case 'comments-author-autocomplete': # autocomplete
                {
                    if (!$this->haveAccessTo('items-manage', 'publications-' . $typeKey)) {
                        $this->ajaxResponse(Errors::ACCESSDENIED);
                    }
                    $sQ = $this->input->post('q', TYPE_NOTAGS);
                    $aData = Users::model()->autocomplete($sQ);
                    $this->autocompleteResponse($aData, 'user_id', 'title');
                }
                    break;
                case 'item-company-autocomplete': # autocomplete
                {
                    if (!$this->haveAccessTo('items-manage', 'publications-' . $typeKey)) {
                        $this->ajaxResponse(Errors::ACCESSDENIED);
                    }

                    $sQ = $this->input->post('q', TYPE_NOTAGS);
                    # получаем список подходящих по названию объектов
                    $aData = $this->db->select('SELECT I.id, I.title FROM ' . TABLE_ITEMS_LANG . ' I
                                  WHERE I.title LIKE (:q)
                                  ORDER BY I.title'.$this->db->prepareLimit(0,10), array(':q'=>$sQ.'%'));
                    $this->autocompleteResponse($aData);
                }
                break;
                case 'item-img-crop':
                {
                    if (!$this->haveAccessTo('items-manage', 'publications-' . $typeKey)) {
                        $this->ajaxResponse(Errors::ACCESSDENIED);
                    }

                    $nItemID = $this->input->get('item_id', TYPE_UINT);
                    if (!$typeID || !$type->imgp['orig'] || !$type->imgp['crop']) {
                        $this->ajaxResponse(Errors::IMPOSSIBLE);
                    }

                    $p = $this->input->postm(array(
                            'x'        => TYPE_UINT,
                            'y'        => TYPE_UINT,
                            'w'        => TYPE_UINT,
                            'h'        => TYPE_UINT,
                            'crop'     => TYPE_STR,
                            'filename' => TYPE_STR,
                        )
                    );
                    extract($p);

                    if ($nItemID > 0) {
                        $aData = $this->model->itemData($nItemID, array('id', 'img as filename', 'publicated'), $typeID);
                        if (empty($aData) || empty($aData['filename'])) {
                            $this->ajaxResponse(Errors::UNKNOWNRECORD);
                        }
                    } else {
                        if (empty($p['filename'])) {
                            $this->ajaxResponse(Errors::UNKNOWNRECORD);
                        }
                        $aData['filename'] = $p['filename'];
                    }

                    list($c['x'], $c['y'], $c['x2'], $c['y2'], $c['w'], $c['h']) = explode(',', $crop);
                    $crop_packed = serialize($c);

                    $oImages = $this->initImages(array(
                            'id'         => $nItemID,
                            'publicated' => (isset($aData['publicated']) ? $aData['publicated'] : '')
                        ), $type
                    );
                    if ($oImages !== false) {
                        $res = $oImages->crop($aData['filename'], $x, $y, $w, $h);
                        if ($res && $nItemID > 0) {
                            $this->model->itemSave($nItemID, array(
                                'img_crop' => $crop_packed
                            ), $typeID);
                        }
                    }

                    $this->ajaxResponse(array('crop_packed' => $crop_packed));
                }
                break;
                case 'item-img-delete':
                {
                    if (!$this->haveAccessTo('items-manage', 'publications-' . $typeKey)) {
                        $this->ajaxResponse(Errors::ACCESSDENIED);
                    }

                    $sFilename = $this->input->post('filename', TYPE_STR);
                    $nItemID = $this->input->post('item_id', TYPE_UINT);
                    if (!$typeID || empty($sFilename)) {
                        $this->ajaxResponse(Errors::IMPOSSIBLE);
                    }

                    $oImages = false;
                    if ($nItemID > 0) {
                        $aItemData = $this->db->one_array('SELECT id, publicated FROM ' . $this->getItemsTable($typeKey) . ' WHERE id = ' . $nItemID);
                        if (!empty($aItemData)) {
                            $oImages = $this->initImages(array(
                                    'id'         => $nItemID,
                                    'publicated' => $aItemData['publicated']
                                ), $type
                            );
                        }
                    } else {
                        $oImages = $this->initImages(array('id' => $nItemID), $type);
                    }

                    if ($oImages !== false) {
                        if ($nItemID) {
                            $oImages->delete(true);
                        } else {
                            $oImages->deleteFiles($sFilename);
                        }
                    }

                    $this->ajaxResponse(Errors::SUCCESS);
                }
                break;
            }

        }
        $this->ajaxResponse(Errors::IMPOSSIBLE);
    }

    //-------------------------------------------------------------------------------------------------------------------------------
    // Комментарии

    function comments_ajax()
    {
        if (!$this->haveAccessTo('comments', 'publications')) {
            return $this->showAccessDenied();
        }

        $typeID = $this->input->getpost('group_id', TYPE_UINT);

        $this->itemComments($typeID)->admAjax();
    }

    function comments_mod()
    {
        if (!$this->haveAccessTo('comments', 'publications')) {
            return $this->showAccessDenied();
        }

        $aTypes = $this->getTypes();

        $typeID = $this->input->getpost('type', TYPE_UINT);
        if (!$typeID) {
            reset($aTypes);
            $this->type = current($aTypes);
            $typeID = $this->type->id;
        } else {
            $this->type = $this->getTypeSettings($typeID);
        }
        if (!$typeID || empty($this->type)) {
            return $this->showError(Errors::IMPOSSIBLE, true);
        }

        # для данного типа нет возможности редактировать комментарии через админ панель
        if (!$this->type->commentsManage()) {
            $this->adminRedirect(Errors::IMPOSSIBLE, 'comments_mod');
        }

        $f = $this->input->postgetm(array(
            'id'       => TYPE_STR,
            'p_from'   => TYPE_STR,
            'p_to'     => TYPE_STR,
            'author'   => TYPE_UINT,
            'offset'   => TYPE_UINT,
        ));

        $aData = array(
            'type' => $this->type,
            'f'    => $f,
        );

        $oComments = $this->itemComments($typeID);
        $oComments->templateDir = $this->module_dir_tpl;
        $aData['comments'] = $oComments->admListingModerate(15, $f);

        $sPrefix = $oComments->counterPrefix();
        foreach ($aTypes as $k => $v) {
            if (!$v->commentsManage()) {
                unset($aTypes[$k]); continue;
            }
            $aTypes[$k]->cnt = config::get($sPrefix . $v->keyword, 0);
        }

        $aData['types'] = $aTypes;
        if($f['author']){
            $aAuthor = Users::model()->userData($f['author'], array('login', 'email'));
            $aData['author_title'] = '#'.$f['author'].' '.$aAuthor['login'].' ('.$aAuthor['email'].')';
        }
        return $this->viewPHP($aData, 'admin.items.comments.mod');
    }

    function comments($typeID, $typeKey)
    {
        if (!$this->haveAccessTo('comments', 'publications')) {
            return $this->showAccessDenied();
        }

        $nItemID = $this->input->get('item_id', TYPE_UINT);
        if (!$nItemID) {
            $this->adminRedirect(Errors::UNKNOWNRECORD, $typeKey . ':listing');
        }

        $sqlTable = $this->getItemsTable($typeKey);

        $aData = $this->db->one_array('SELECT I.id, IL.title, I.link as linkout, I.publicated, I.comments as comments_total
                ' . ($this->type->categoriesEnabled() ? ', ICL.title as category_title, I.category_id, IC.keyword as category' : '') . '
               FROM ' . $sqlTable . ' I
                ' . ($this->type->categoriesEnabled()
                ? ' LEFT JOIN ' . TABLE_PUB_CATEGORIES . ' IC ON I.category_id = IC.id
                    LEFT JOIN ' . TABLE_PUB_CATEGORIES_LANG . ' ICL ON ' . $this->db->langAnd(false, 'IC', 'ICL')
                : '') . '
               , ' . TABLE_PUB_ITEMS_LANG . ' IL
               WHERE I.id=' . $nItemID . $this->model->langAnd($this->type->id, true, 'I', 'IL') . ' LIMIT 1'
        );

        if (!$aData) {
            $this->adminRedirect(Errors::IMPOSSIBLE);
        }

        $aData['type'] = $this->type;
        $aData['item_id'] = $nItemID;
        $aData['edit_allowed'] = $this->haveAccessTo('comments', 'afisha');
        $aData['comments'] = $this->itemComments($typeID)->admListing($nItemID);

        $this->itemComments($typeID)->admListingIncludes();

        return $this->viewPHP($aData, 'admin.items.form.comments');
    }

    function tags()
    {
        $typeID = $this->input->getpost('group', TYPE_UINT);
        $type = $this->getTypeSettings($typeID);
        if (!$type) $typeID = 0;
        $tags = $this->initTags($typeID);

        $types = $this->getTypes();
        $groups = array(0=>'Общие');
        foreach ($types as $type) {
            if (!$type->tagsEnabled()) continue;
            $groups[$type->id] = $type->title;
        }
        return $tags->manage($groups, $typeID);
    }

    function categories($typeID = 0, $typeKey = '')
    {
        $sql = array();

        $mAccessModule = null;
        $typeID = ($typeID > 0 ? $typeID : $this->input->postget('type', TYPE_UINT));
        do {
            if ($typeID) {
                $oTypeSettings = $this->getTypeSettings($typeID);
                if (!$oTypeSettings->categoriesEnabled()) { # для данного типа работа с категориями закрыта
                    return $this->showError(Errors::IMPOSSIBLE, true);
                } elseif (!$oTypeSettings->categoriesCommonOnly()) {
                    $mAccessModule = 'publications-' . $typeKey;
                    $sql[] = 'type_id = ' . $typeID;
                    break;
                }
            }

            $sql[] = 'type_id = 0';
        } while (false);

        if (!$this->haveAccessTo('cats-listing', $mAccessModule)) {
            return $this->showAccessDenied();
        }

        $sql = join(' AND ', $sql);

        $bInheritAllowed = ($typeID > 0 && $oTypeSettings->categoriesCustomAndCommon());
        $bSubCatsAllowed = !$typeID || $oTypeSettings->subcategoriesEnabled();

        if (Request::isAJAX()) {
            if (!$this->haveAccessTo('cats-manage', $mAccessModule)) {
                return $this->showAccessDenied();
            }
            $sAction = $this->input->get('act');

            switch ($sAction) {
                case 'edit':
                {
                    $nCategoryID = $this->input->get('cat_id', TYPE_UINT);
                    if (!$nCategoryID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $aData = $this->db->one_array('SELECT * FROM ' . TABLE_PUB_CATEGORIES . ' WHERE id = :id', array(':id' => $nCategoryID));
                    if (empty($aData)) {
                        $this->ajaxResponse(Errors::IMPOSSIBLE);
                    }
                    $this->db->langSelect($nCategoryID, $aData, $this->model->langCategories, TABLE_PUB_CATEGORIES_LANG);

                    $aData['type'] = $typeID;
                    $aData['subcats'] = $bSubCatsAllowed;
                    if ($typeID) {
                        $aData['typeSettings'] = $oTypeSettings;
                    }

                    $aData['form'] = $this->viewPHP($aData, 'admin.categories.form');
                    $this->ajaxResponse($aData);
                }
                break;
                case 'toggle':
                {
                    $nCategoryID = $this->input->postget('rec', TYPE_UINT);
                    if (!$nCategoryID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    if ($bInheritAllowed) {
                        # если частичное наследование(1), переключаем в таблице наследуемых категорий
                        $this->db->exec('UPDATE ' . TABLE_PUB_CATEGORIES_IN . ' SET enabled = (1 - enabled)
                            WHERE type_id = ' . $typeID . ' AND cat_id = ' . $nCategoryID
                        );
                    } else {
                        # если полное наследование(3) или свои(1), переключаем по id
                        $this->db->exec('UPDATE ' . TABLE_PUB_CATEGORIES . ' SET enabled = (1 - enabled)
                            WHERE id = ' . $nCategoryID . ' AND type_id = ' . ($typeID && $oTypeSettings->categoriesCommonOnly() ? 0 : $typeID)
                        );
                    }

                    $this->ajaxResponse(Errors::SUCCESS);
                }
                break;
                case 'rotate':
                {
                    if ($bInheritAllowed) {
                        # если частичное наследование(1), крутим в таблице наследуемых категорий, в пределах типа
                        $this->db->rotateTablednd(TABLE_PUB_CATEGORIES_IN, ' AND type_id = ' . $typeID, 'cat_id', 'num');
                    } else {
                        # если полное наследование(3), крутим все общие категории
                        # если только свои(1), крутим среди своих
                        $this->db->rotateTablednd(TABLE_PUB_CATEGORIES, ' AND type_id = ' . ($typeID && $oTypeSettings->categoriesCommonOnly() ? 0 : $typeID), 'id', 'num', true, 'pid');
                    }
                    $this->ajaxResponse(Errors::SUCCESS);
                }
                break;
                case 'delete':
                {
                    if (!$this->haveAccessTo('cats-delete', $mAccessModule)) {
                        return $this->showAccessDenied();
                    }

                    $nCategoryID = $this->input->get('cat_id', TYPE_UINT);
                    if (!$nCategoryID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $nSubCount = $this->db->one_data('SELECT COUNT(id) FROM ' . TABLE_PUB_CATEGORIES . ' WHERE pid = :pid', array(':pid' => $nCategoryID));
                    if ($nSubCount) {
                        $this->errors->set(_t('pub', 'Необходимо удалить подкатегории'));
                        $this->ajaxResponse(false);
                    }

                    $res = $this->db->exec('DELETE FROM ' . TABLE_PUB_CATEGORIES . ' WHERE id = ' . $nCategoryID . ' AND ' . $sql);
                    if ($res) {
                        $this->db->exec('DELETE FROM ' . TABLE_PUB_CATEGORIES_LANG . ' WHERE id = ' . $nCategoryID);
                    }

                    $this->ajaxResponse((!empty($res) ? Errors::SUCCESS : Errors::IMPOSSIBLE));
                }
                break;
                case 'uninherit':
                {
                    if (!$bInheritAllowed) {
                        $this->ajaxResponse(Errors::IMPOSSIBLE);
                    }

                    $nCategoryID = $this->input->get('cat_id', TYPE_UINT);
                    if (!$nCategoryID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $res = $this->db->exec('DELETE FROM ' . TABLE_PUB_CATEGORIES_IN . ' WHERE cat_id = ' . $nCategoryID . ' AND ' . $sql);
                    $this->ajaxResponse((!empty($res) ? Errors::SUCCESS : Errors::IMPOSSIBLE));
                }
                break;
                case 'get-inherit':
                {
                    if (!$bInheritAllowed) {
                        $this->ajaxResponse(Errors::IMPOSSIBLE);
                    }
                    $aData = $this->db->select('SELECT C.id, CL.title
                            FROM ' . TABLE_PUB_CATEGORIES . ' C
                                LEFT JOIN ' . TABLE_PUB_CATEGORIES_IN . ' CIN ON C.id = CIN.cat_id AND CIN.type_id = ' . $typeID . '
                                , ' . TABLE_PUB_CATEGORIES_LANG . ' CL
                        WHERE C.type_id = 0 AND CIN.cat_id IS NULL ' . $this->db->langAnd(true, 'C', 'CL')
                    );
                    $sOptions = (!empty($aData) && is_array($aData) ? HTML::selectOptions($aData, 0, false, 'id', 'title') : '<option value="0">нет доступных разделов</option>');
                    $this->ajaxResponse(array('opts' => $sOptions));
                }
                break;
                case 'subs-list':
                {
                    if (!$bSubCatsAllowed) {
                        $this->ajaxResponse(Errors::IMPOSSIBLE);
                    }

                    $nCategoryID = $this->input->post('category', TYPE_UINT);
                    if (!$nCategoryID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $aData['cats'] = $this->categoriesGet(($typeID ? $oTypeSettings : null), false, array('pid' => $nCategoryID), ($typeID > 0));
                    $aData['subcats'] = false;
                    $aData['ajax'] = true;
                    $aData['type'] = $typeID;
                    $aData['nCategoryID'] = $nCategoryID;
                    if ($typeID) {
                        $aData['typeSettings'] = $oTypeSettings;
                    }
                    $this->ajaxResponse($this->viewPHP($aData, 'admin.categories.listing.ajax'));

                }
                break;
            }
        } else {
            if (Request::isPOST()) {
                if (!$this->haveAccessTo('cats-manage', $mAccessModule)) {
                    return $this->showAccessDenied();
                }

                switch ($this->input->postget('act')) {
                    case 'add-finish':
                    {
                        $aData = $this->categoriesProcessData($typeID, 0);

                        $aData['num'] = $this->categoriesGetCurrentNum($typeID, $bInheritAllowed, $aData['pid']);
                        if ($this->errors->no()) {
                            $nNewCategoryID = $this->db->insert(TABLE_PUB_CATEGORIES, array_diff_key($aData, $this->model->langCategories));
                            if ($nNewCategoryID) {
                                $this->db->langInsert($nNewCategoryID, $aData, $this->model->langCategories, TABLE_PUB_CATEGORIES_LANG);
                                if ($bInheritAllowed) {
                                    $this->db->exec('INSERT INTO ' . TABLE_PUB_CATEGORIES_IN . ' (type_id, cat_id, num)
                                    VALUES(' . $typeID . ', ' . $nNewCategoryID . ', ' . $aData['num'] . ')'
                                    );
                                }
                            }
                        }

                    }
                    break;
                    case 'edit-finish':
                    {
                        $nCategoryID = $this->input->post('cat_id', TYPE_UINT);
                        if (!$nCategoryID) {
                            $this->errors->unknownRecord();
                        }

                        $aDataCur = $this->db->one_array('SELECT * FROM ' . TABLE_PUB_CATEGORIES . ' WHERE id = ' . $nCategoryID);
                        if (empty($aDataCur)) {
                            $this->errors->unknownRecord();
                        }

                        $aData = $this->categoriesProcessData($typeID, $nCategoryID);

                        # попытка изменения keyword'a категории
                        if ($aData['keyword'] !== $aDataCur['keyword']) {
                            $aTypes = array();
                            if ($aDataCur['type_id'] > 0) {
                                $aTypes[] = $this->getTypeSettings($aDataCur['type_id']);
                            } else {
                                $aTypes = $this->getTypes();
                            }

                            foreach ($aTypes as $type) {
                                $nItemsInCategory = $this->db->one_data('SELECT COUNT(*)
                                FROM ' . $this->getItemsTable($type->keyword) . ' WHERE category_id = ' . $nCategoryID
                                );
                                if (!empty($nItemsInCategory)) {
                                    $this->errors->set(_t('pub', 'Невозможно изменить keyword раздела, посколько с ним уже связаны публикации'));
                                    break;
                                }
                            }
                        }

                        if ($this->errors->no()) {
                            $this->db->update(TABLE_PUB_CATEGORIES, array_diff_key($aData, $this->model->langCategories), array('id'=>$nCategoryID));
                            $this->db->langUpdate($nCategoryID, $aData, $this->model->langCategories, TABLE_PUB_CATEGORIES_LANG);
                        }
                    }
                    break;
                    case 'inherit-finish':
                    {
                        $nInheritCategoryID = $this->input->post('inherit', TYPE_UINT);
                        if (!$nInheritCategoryID || !$bInheritAllowed) {
                            $this->errors->impossible();
                        }

                        $bEnabled = $this->input->post('enabled', TYPE_BOOL);

                        $bIsAlreadyInherited = $this->db->one_data('SELECT type_id FROM ' . TABLE_PUB_CATEGORIES_IN . '
                        WHERE type_id = ' . $typeID . ' AND cat_id = ' . $nInheritCategoryID
                        );

                        if (empty($bIsAlreadyInherited)) {
                            $nNum = $this->categoriesGetCurrentNum($typeID, true);
                            $res = $this->db->exec('INSERT INTO ' . TABLE_PUB_CATEGORIES_IN . ' (type_id, cat_id, enabled, num)
                            VALUES(' . $typeID . ', ' . $nInheritCategoryID . ', ' . $bEnabled . ', ' . $nNum . ')'
                            );
                            if (empty($res)) {
                                $this->errors->impossible();
                            }
                        }


                    }
                    break;
                }

                $sFilter = $this->input->post('filter', TYPE_STR);

                $this->adminRedirect(Errors::SUCCESS, bff::$event . (!empty($sFilter) ? $sFilter : '&type=' . $typeID));
            }
        }

        $aData = $this->categoriesProcessData($typeID);
        $aData['id'] = 0;
        $aData['type'] = $typeID;
        $aData['types'] = $this->getTypes();
        foreach ($aData['types'] as $k=>$v) {
            if (!$v->categoriesEnabled()) {
                unset($aData['types'][$k]); continue;
            }
        }
        $aData['menu_mini'] = $this->menuMini;

        $aData['cats'] = $this->categoriesGet(($typeID ? $oTypeSettings : null), false, false, ($typeID > 0));

        $aData['filter'] = '&' . http_build_query(array('type' => $typeID));
        $aData['inherits'] = $bInheritAllowed;
        $aData['subcats'] = $bSubCatsAllowed;

        if ($typeID) {
            $aData['typeSettings'] = $oTypeSettings;
        }
        $aData['form'] = $this->viewPHP($aData, 'admin.categories.form');
        $aData['list'] = $this->viewPHP($aData, 'admin.categories.listing.ajax');

        return $this->viewPHP($aData, 'admin.categories.listing');
    }

    # ---------------------------------------------------------------------------------------------
    # Работа с типами    
    function types_listing()
    {
        if (!FORDEV)
            return $this->showAccessDenied();

        $act = $this->input->get('act');
        if (Request::isAJAX() || !empty($act)) {
            switch ($act) {
                case 'rotate':
                {
                    $this->db->rotateTablednd(TABLE_PUB_TYPES, '', 'id', 'num');

                    # сбрасываем кеш настроек типов
                    $this->resetTypeSettingsCache(0, true);

                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'toggle':
                {
                    $typeID = $this->input->postget('rec', TYPE_UINT);
                    if (!$typeID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $this->model->typeSave($typeID, array('enabled = (1 - enabled)'));

                    # сбрасываем кеш настроек типа
                    $this->resetTypeSettingsCache($typeID);

                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'delete':
                {
                    $typeID = $this->input->postget('rec', TYPE_UINT);
                    if (!$typeID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $this->deleteType($typeID);
                    # сбрасываем кеш настроек типа
                    $this->resetTypeSettingsCache($typeID);

                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'items-links-rebuild':
                {
                    $this->model->itemsLinksRebuild();

                    $this->adminRedirect(Errors::SUCCESS, bff::$event);
                } break;
            }
        }

        $aData = $this->db->select('SELECT id, keyword, title_' . LNG . ' AS title, categories, tags, enabled, created FROM ' . TABLE_PUB_TYPES . ' ORDER BY num');

        tpl::includeJS('tablednd', true);

        return $this->viewPHP($aData, 'admin.types.listing');
    }

    function types_add()
    {
        if (!FORDEV)
            return $this->showAccessDenied();

        $this->processTypeSettings($aData, 0);

        if (Request::isPOST()) {

            if ($this->errors->no() &&
                PublicationsSettings::pack($aData)
            ) {
                $typeID = $this->model->typeSave(0, $aData);
                if ($typeID)
                {
                    $typeKey = $aData['keyword'];
                    $this->manageTypeFiles($typeKey, 'create');
                    $this->manageTypeTables($typeKey, 'create');

                    $this->adminRedirect(Errors::SUCCESS, 'types_listing');
                }
            }
        }

        $aData['id'] = 0;
        return $this->viewPHP($aData, 'admin.types.form');
    }

    function types_edit()
    {
        if (!FORDEV)
            return $this->showAccessDenied();

        $typeID = $this->input->get('id', TYPE_UINT);
        if (!$typeID) $this->adminRedirect(Errors::UNKNOWNRECORD, 'types_listing');

        if (Request::isPOST()) {

            $aDataOLD = $this->getTypeSettings($typeID, true);
            $this->processTypeSettings($aData, $typeID);

            $bChangeKeyword = false;
            if ($this->errors->no()) {
                if ($aDataOLD->keyword != $aData['keyword'] && !empty($aData['keyword'])) {
                    if (file_exists(bff::path($aData['keyword'], 'images')) ||
                        $this->db->isTable(TABLE_PUB_ITEMS_ . $aData['keyword'])
                    ) {
                        $this->errors->set(_t('pub', '"keyword" типа указан некорректно'));
                    } else {
                        $bChangeKeyword = true;
                    }
                }
            }

            $aDataNEW = $aData;
            if ($this->errors->no() &&
                PublicationsSettings::pack($aData)
            ) {

                $aData['modified'] = $this->db->now();
                $res = $this->model->typeSave($typeID, $aData);
                if (!empty($res)) {
                    # сбрасываем кеш настроек типа
                    $this->resetTypeSettingsCache($typeID);

                    if ($bChangeKeyword) {
                        $this->manageTypeFiles(array(
                                'from' => $aDataOLD->keyword,
                                'to'   => $aDataNEW['keyword']
                            ), 'rename'
                        );
                        $this->manageTypeTables(array(
                                'from' => $aDataOLD->keyword,
                                'to'   => $aDataNEW['keyword']
                            ), 'rename'
                        );
                    }

                    //обрабатываем изменение работы с категориями
                    $categoriesNEW = $aDataNEW['categories'];
                    $categoriesOLD = $aDataOLD->categories;
                    if ($categoriesOLD != $categoriesNEW)
                    {
                        if ($categoriesOLD == 0 && $categoriesNEW > 0) # не было категорий, а теперь включаем
                        {
                            # все объекты типа останутся без привязки к категориям !
                        } else {
                            switch ($categoriesNEW) {
                                case 0: # выключаем категории
                                {
                                    $aDataNEW['categories'] = $categoriesOLD; // не позволим :)
                                }
                                break;
                                case 1: # разрешаем только свои категории
                                {
                                    if ($aDataOLD->categoriesCustomAndCommon()) // если были свои + общие
                                    {
                                        // оставляем свои категории, оставляем наследованные категории.
                                        // некоторые объекты останутся привязанными к общим категориям
                                    } else if ($aDataOLD->categoriesCommonOnly()) // если были только общие
                                    {
                                        // все объекты останутся привязанными к общим категориям                                   
                                    }
                                }
                                break;
                                case 2: # свои + общие
                                {
                                    if ($aDataOLD->categoriesCustomOnly()) # если были только свои
                                    {
                                        $aCurCategories = $this->db->select('SELECT id, num FROM ' . TABLE_PUB_CATEGORIES . ' WHERE type_id = ' . $typeID);
                                        $this->db->exec('DELETE FROM ' . TABLE_PUB_CATEGORIES_IN . ' WHERE type_id = ' . $typeID);
                                        if (!empty($aCurCategories)) {
                                            $sqlInsert = array();
                                            foreach ($aCurCategories as $v) {
                                                $sqlInsert[] = '(' . $typeID . ',' . $v['id'] . ',' . $v['num'] . ')';
                                            }
                                            if (!empty($sqlInsert)) {
                                                $this->db->exec('INSERT INTO ' . TABLE_PUB_CATEGORIES_IN . ' (type_id, cat_id, num)
                                                    VALUES ' . join(',', $sqlInsert) . '
                                                '
                                                );
                                            }
                                        }
                                    }
                                    else if ($aDataOLD->categoriesCommonOnly()) # если были только общие
                                    {
                                        # наследуем все общие категории для данного типа
                                        $aCurCategories = $this->db->select('SELECT id, num FROM ' . TABLE_PUB_CATEGORIES . ' WHERE type_id = 0');
                                        $this->db->exec('DELETE FROM ' . TABLE_PUB_CATEGORIES_IN . ' WHERE type_id = ' . $typeID);
                                        if (!empty($aCurCategories)) {
                                            $sqlInsert = array();
                                            foreach ($aCurCategories as $v) {
                                                $sqlInsert[] = '(' . $typeID . ',' . $v['id'] . ',' . $v['num'] . ')';
                                            }
                                            if (!empty($sqlInsert)) {
                                                $this->db->exec('INSERT INTO ' . TABLE_PUB_CATEGORIES_IN . ' (type_id, cat_id, num)
                                                    VALUES ' . join(',', $sqlInsert) . '
                                                '
                                                );
                                            }
                                        }
                                    }
                                }
                                break;
                                case 3: # только общие
                                {
                                    if ($aDataOLD->categoriesCustomOnly()) // если были только свои
                                    {
                                        // оставляем свои категории.
                                        // все объекты останутся привязанными к своим категориям
                                    } else if ($aDataOLD->categoriesCustomAndCommon()) // если были свои + общие
                                    {
                                        // оставляем свои категории, оставляем наследованные категории.
                                        // некоторые объекты останутся привязанными к своим категориям
                                    }
                                }
                                break;
                            }
                        }
                    }

                    $this->adminRedirect(Errors::SUCCESS, 'types_listing');
                }
            }

            PublicationsSettings::unpack($aData); # сохранить не удалось, распаковываем
        } else {
            $aData = $this->getTypeSettings($typeID, true, true);
        }

        return $this->viewPHP($aData, 'admin.types.form');
    }

    function dev_recrop_content_images()
    {
        if ( ! FORDEV || ! $this->security->isSuperAdmin()) {
            return $this->showAccessDenied();
        }

        set_time_limit(0);
        foreach ($this->getTypes() as $type)
        {
            $this->type = $type; $_GET['type'] = $_POST['type'] = $type->id;
            $items = $this->db->select('SELECT id, publicated, content FROM '.$this->getItemsTable($type->keyword).' ORDER BY id');
            if ( ! empty($items)) {
                foreach ($items as $v) {
                    $publicator = $this->initPublicator(array('id'=>$v['id'], 'publicated'=>$v['publicated']), $type);
                    $publicator->recropImages($v['id'], $v['content']);
                }
            }
        }

        if ($this->errors->no()) {
            $this->errors->success();
        }
    }

}