<?php
/**
 * Форма публикации видео пользователем
 * @var $this Publications
 */
if( ! User::id()) { ?>
    <div class="h1-wrap">
        <h1><?= _t('pub', 'Добавление видео'); ?></h1>
        <p class="send-comment-att ml0 mt20"><?= _t('pub','<a [link_register]>Зарегистрируйтесь</a> или <a [link_login]>войдите</a>, чтобы добавить видео', array(
                'link_register' => 'href="'.Users::url('register').'" onclick="app.popup(\'reg\').show(event);"',
                'link_login' => 'href="'.Users::url('login').'" onclick="app.popup(\'login\').show(event);"',
            )); ?> <i class="say"></i></p>
    </div>
    <?  return; }

 $categoriesOptions = $this->categoriesGet($this->type, true, array('sel' => (empty($cat['id']) ? 0 : $cat['id']), 'empty' => 0));
?>
<div class="h1-wrap">
    <h1><?= _t('pub', 'Добавление видео'); ?></h1>
    <ul class="form-ch mt20">
        <li><?= _t('', 'Поля, отмеченные звездочкой[span], обязательны к заполнению.', array(
                'span' => '<span class="z-att">*</span>',
            )); ?></li>
    </ul>
    <div class="form-box object-add">

    <form  action="" method="post" id="pub-video-form">
        <input type="hidden" name="hash" value="<?= $this->security->getToken() ?>" />

        <div class="error mb20 j-error" style="display: none;"></div>
        <table>
            <tr>
                <td class="td1"><?= _t('pub', 'Рубрика:'); ?><span class="z-att">*</span></td>
                <td><select name="cat" class="j-category" autocomplete="off"><?= $categoriesOptions ?></select></td>
            </tr>
            <tr>
                <td class="td1"><?= _t('pub', 'Заголовок:'); ?><span class="z-att">*</span></td>
                <td><div class="inp inp-w1"><input type="text" class="j-title" name="title" autocomplete="off" maxlength="150" /><i></i></div></td>
            </tr>
            <tr>
                <td class="td1"><?= _t('pub', 'Код видео:'); ?><span class="z-att">*</span></td>
                <td>
                    <div class="textarea"><textarea name="video" style="height: 70px; min-height: 70px; width: 450px;"></textarea><i></i></div>
                    <span class="grey"><?= _t('pub', 'YouTube, RuTube, Vimeo'); ?></span>
                </td>
            </tr>
            <tr>
                <td class="td1"><?= _t('pub', 'Описание:'); ?></td>
                <td>
                    <div class="textarea"><textarea rows="7" cols="30" name="content"></textarea><i></i></div>
                </td>
            </tr>
            <tr>
                <td></td>
                <td>
                    <div class="btn mr10 left"><input type="button" class="j-submit" value="<?= HTML::escape(_t('pub', 'добавить видео')); ?>" /><i></i></div>
                </td>
            </tr>
        </table>
    </form>
    <i class="say"></i>
    </div>
</div>
<script type="text/javascript">
<? js::start(); ?>
var jVideoSubmitForm = (function(){
    var $form, $err, $title, $cat;

    $(function(){
        $form  = $('#pub-video-form');
        $err   = $form.find('.j-error');
        $title = $form.find('.j-title');
        $cat   = $form.find('.j-category');

        $form.on('click', '.j-submit', function(e){

            app.fieldError($title, false);

            if(intval($cat.val())<=0) {
                app.showError($err, '<?= HTML::escape(_t('pub', 'Укажите рубрику'), 'js'); ?>');
                $cat.focus();
            }

            if(!$.trim($title.val()).length) {
                app.showError($err, '<?= HTML::escape(_t('pub', 'Укажите заголовок'),'js'); ?>');
                return app.fieldError($title);
            }

            bff.ajax(bff.ajaxURL('publications', '&ev=video_submit'), $form.serialize(), function(data, errors){
                if(data && data.success) {
                    app.showError($err, '<?= HTML::escape(_t('pub', 'Видео было успешно отправлено на модерацию'), 'js'); ?>', true, true);
                    $form.get(0).reset();
                } else {
                    app.showError($err, errors);
                }
            });
        });
    });

    return {};
}());
<? js::stop(); ?>
</script>