<?php

/**
 * Права доступа группы:
 *  - realty: Недвижимость
 *      - manage: Добавление/Редактирование/Модерация объявлений
 *      - delete: Удаление объявлений
 *      - claims: Жалобы
 *      - settings: Настройки (разделы, типы)
 *      - svc: Услуги
 */

class Realty extends RealtyBase
{
    function listing()
    {
        if( ! $this->haveAccessTo('manage'))
            return $this->showAccessDenied();
        $aData = array('f'=>array());

        $act = $this->input->get('act');
        if(Request::isAJAX() || !empty($act))
        {
            switch ($act)
            {
                case 'delete':
                {
                    if( ! $this->haveAccessTo('delete'))
                        return $this->showAccessDenied();

                    $nItemID = $this->input->postget('id', TYPE_UINT);
                    if( ! $nItemID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $res = $this->deleteItem($nItemID);
                    if( $res ) $this->yandexXML();

                    $this->ajaxResponse( ($res ? Errors::SUCCESS : Errors::IMPOSSIBLE) );
                } break;
                case 'items-links-rebuild':
                {
                    if (FORDEV) {
                        $this->model->itemsLinksRebuild();
                    }

                    $this->adminRedirect(Errors::SUCCESS, bff::$event);
                } break;
                case 'items-delete-all':
                {
                    if (FORDEV) {
                        set_time_limit(0);
                        $this->db->select_rows_chunked(TABLE_REALTY_ITEMS, array('id'), array(), 'id', array(), function($items){
                            foreach ($items as $v) {
                                Realty::i()->deleteItem($v['id']);
                            }
                        });
                        if ( ! $this->errors->no()) {
                            echo '<pre>', print_r($this->errors->get(1,0), true), '</pre>'; exit;
                        }
                    }

                    $this->adminRedirect(Errors::SUCCESS, bff::$event);
                } break;
            }
        }

        $aData['orders'] = array('created'=>'desc');

        $this->input->postgetm(array(
            'page'   => TYPE_UINT,
            'cat'    => TYPE_UINT, 
            'city'   => TYPE_UINT,
            'type'   => TYPE_UINT,
            'title'  => TYPE_NOTAGS,
            'status' => TYPE_UINT,
            'p_from' => TYPE_STR,
            'p_to'   => TYPE_STR,
            'user'   => TYPE_UINT,
            'company'=> TYPE_UINT,
        ), $f);

        $sql = array();
        if($f['cat']>0) {
            $sql[] = 'I.cat_id = '.$f['cat'];
        }
        if($f['city']>0) {
            $sql[] = 'I.city_id = '.$f['city'];
        }
        if($f['type']>0) {
            $sql[] = 'I.type_id = '.$f['type'];
        }
        if( ! empty($f['title'])) {
            if(intval($f['title'])>0) {
                $sql[] = 'I.id = '.intval($f['title']);
            } else {
                $sql[] = 'I.title LIKE '.$this->db->str2sql('%'.$f['title'].'%');
            }
        }
        switch ($f['status']) {
            case 2: $sql[] = 'I.status = '.self::STATUS_BLOCKED; break;
            case 3: $sql[] = 'I.moderated != 1 AND I.status != '.self::STATUS_NEW; break;
            case 4: $sql[] = 'I.status = '.self::STATUS_PUBLICATED_OUT; break;
            case 1: default:
                $f['status'] = 1; $sql[] = 'I.status = '.self::STATUS_PUBLICATED;
                if(static::premoderation()){
                    $sql[] = 'I.moderated > 0';
                }
                break;
        }

        if( !empty($f['p_from']) ) {
            $p_from = strtotime($f['p_from']);
            if( ! empty($p_from)) {
                $sql[] = 'DATE(I.created) >= '.$this->db->str2sql( date('Y-m-d', $p_from) );
            }
        }
        if( !empty($f['p_to']) ) {
            $p_to = strtotime($f['p_to']);
            if( ! empty($p_to)) {
                $sql[] = 'DATE(I.created) <= '.$this->db->str2sql( date('Y-m-d', $p_to) );
            }
        }
        if($f['user'] > 0){
            $sql[] = 'I.user_id = '.$f['user'];
        }
        if($f['company'] > 0){
            $sql[] = 'I.company_id = '.$f['company'];
        }

        $sql = join(' AND ', $sql);

        $nCount = $this->db->one_data('SELECT COUNT(*) FROM '.TABLE_REALTY_ITEMS.' I WHERE '.$sql); 
        $this->prepareOrder($orderBy, $orderDirection, 'created-desc', $aData['orders']);
        $this->tplAssigned(array('order_by', 'order_dir', 'order_dir_needed'), $f);
        $f['order'] = $orderBy.'-'.$orderDirection;
        
        $aData['pgn'] = $this->generatePagenation($nCount, 15, 'realtyItems.page({pageId})', $sqlLimit, 'pagenation.ajax.tpl', 'page', true);
               
        $aData['items'] = $this->db->select('SELECT I.id, I.link, I.title, I.status, 0 as enabled, I.created, I.moderated,
                U.login as user_login, I.user_id, CtL.title as cat_title, I.cat_id, CL.id as claims
            FROM '.TABLE_REALTY_ITEMS.' I
                LEFT JOIN '.TABLE_USERS.' U ON U.user_id = I.user_id
                LEFT JOIN '.TABLE_REALTY_CLAIMS.' CL ON I.id = CL.item_id,
                '.TABLE_REALTY_CATEGORIES.' C,
                '.TABLE_REALTY_CATEGORIES_LANG.' CtL
            WHERE I.cat_id = C.id '.$this->db->langAnd(true, 'C', 'CtL')." AND $sql
            GROUP BY I.id
            ORDER BY I.$orderBy $orderDirection $sqlLimit");

        $aData['f'] = $f;

        $aData['list'] = $this->viewPHP($aData, 'admin.items.listing.ajax');

        if (Request::isAJAX()) {
            $this->ajaxResponse( array(
                'list'   => $aData['list'],
                'pgn'    => $aData['pgn'],
                'filter' => $f,
            ) );
        }

        if($f['user']){
            $aUser = Users::model()->userData($f['user'], array('login', 'email'));
            $aData['agent_title'] = '#'.$f['user'].' '.$aUser['login'].' ('.$aUser['email'].')';
        }

        tpl::includeJS('datepicker', true);
        tpl::includeJS('autocomplete', true);

        return $this->viewPHP($aData, 'admin.items.listing');
    }
    
    function edit()
    {
        $nItemID = $this->input->getpost('id', TYPE_UINT);
        if( ! $nItemID) $this->adminRedirect(Errors::UNKNOWNRECORD);

        if(Request::isAJAX())
        {
            $aCategories = func::array_transparent( $this->categoriesGet( true, array('C.id','CL.title','C.address','CL.tpl_descshort','CL.tpl_descfull') ), 'id', true );

            $aResponse = array();
            
            do 
            {

                $aData = $this->input->postm(array(
                    'cat_id'       => TYPE_UINT, // категория: Квартира, Комната...
                    'type_id'      => TYPE_UINT, // тип: Продажа, Аренда...
                    'price'        => TYPE_PRICE, // цена
                    'price_params' => TYPE_ARRAY_UINT, // цена: параметры; торг...
                    'price_curr'   => TYPE_UINT, // цена: валюта
                    'city_id'      => TYPE_UINT, // город
                    'district_id'  => TYPE_UINT, // район
                    'address'      => TYPE_NOTAGS, // адрес
                    'lat'          => TYPE_NUM, // адрес, координата LAT
                    'lng'          => TYPE_NUM, // адрес, координата LNG
                    'filename'     => TYPE_ARRAY_NOTAGS, // фотографии
                    'info'         => array(TYPE_NOTAGS, 'len'=>10000), // доп. информация
                ));

                $nCatID = $aData['cat_id'];
                if( ! $nCatID || empty($aCategories[$nCatID])) {
                    $this->errors->set( _t('realty', 'Укажите тип недвижимости') );
                } else {
                    $aCatData = $aCategories[$nCatID];
                }
                if( ! $aData['type_id']) {
                    $this->errors->set( _t('realty', 'Укажите тип сделки') );
                }
                if( ! $aData['price']) {
                    $this->errors->set( _t('realty', 'Укажите цену'), 'price' );
                }
                if( ! $aData['price_curr']) {
                    $this->errors->set( _t('realty', 'Укажите валюту') );
                }

                if($nCatID && $aCatData && $aCatData['address'] > 0 && ! Geo::cityIsValid($aData['city_id'])) {
                    $this->errors->set( _t('realty', 'Укажите город'), 'city_id' );
                }
            
                if( ! $this->errors->no()) break;

                # сохраняем объявление
                $this->model->itemSave($nItemID, $aData, 'd');
                $this->yandexXML();

            } while(false);
            
            $aResponse['res'] = $this->errors->no();
            $this->ajaxResponseForm($aResponse);
        }
        
        $aData = $this->db->one_array('SELECT I.*, CL.title as cat_title, C.address as cat_address, CT.prices as cat_prices, T.title_'.LNG.' as type_title,
                                U.email as user_email, U.blocked as user_blocked
                              FROM '.TABLE_REALTY_ITEMS.' I,
                                   '.TABLE_USERS.' U,
                                   '.TABLE_REALTY_CATEGORIES.' C,
                                   '.TABLE_REALTY_CATEGORIES_LANG.' CL,
                                   '.TABLE_REALTY_TYPES.' T,
                                   '.TABLE_REALTY_CATEGORIES_TYPES.' CT
                              WHERE I.id = :itemId
                                AND U.user_id = I.user_id 
                                AND I.cat_id  = C.id 
                                AND I.type_id = T.id
                                AND I.cat_id  = CT.cat_id AND I.type_id = CT.type_id '.
                                $this->db->langAnd(true, 'C', 'CL'),
                                array(':itemId'=>$nItemID));
            
        if (empty($aData)) {
            $this->adminRedirect(Errors::IMPOSSIBLE);
        }
        
        if($aData['cat_address'])
        {
            $aData['reg'] = $this->db->one_array('SELECT С.title_'.LNG.' as c_title, С.ycoords, D.title_'.LNG.' as d_title, D.ybounds, D.ypoly
                        FROM '.TABLE_REGIONS.' С
                            LEFT JOIN '.TABLE_REGIONS_DISTRICTS.' D ON С.id = D.city_id AND D.id = :district
                        WHERE С.id = :city', array(':city'=>$aData['city_id'], ':district'=>$aData['district_id']));
        }
                                    
        $aData['curr'] = Site::currencyOptions($aData['price_curr']);

        $aData['dp'] = $this->dpForm($aData['cat_id'], false, $aData);
        if ($aData['company_id']) {
            $aData['aCompanyInfo'] = Users::model()->companyInfo($aData['user_id'], $aData['company_id']);
        }

        Geo::mapsAPI(true);
        tpl::includeJS(array('qquploader'), true);
        return $this->viewPHP($aData, 'admin.items.edit');
    }
    
    function ajax()
    {
        if( ! $this->haveAccessTo('items-edit'))
            return $this->showAccessDenied();
            
        switch ($this->input->get('act'))
        {
            case 'item-block':
            {

                $sReason = $this->input->postget('blocked_reason', TYPE_NOTAGS);
                $sReason  = mb_strcut( $sReason, 0, 300);
                
                $nBlocked = $this->input->post('blocked', TYPE_UINT);
                $nItemID  = $this->input->post('id', TYPE_UINT);
                if( ! $nItemID) break;

                $aData = $this->db->one_array('SELECT id, status, cat_id, type_id FROM '.TABLE_REALTY_ITEMS.' WHERE id = '.$nItemID);
                if (empty($aData)) break;
                                
                $res = $this->db->exec('UPDATE '.TABLE_REALTY_ITEMS.'
                               SET blocked_reason = :reason,
                                   moderated = 1
                                   '.( ! $nBlocked ? ',
                                   blocked_num = blocked_num + 1,
                                   status_prev = status,
                                   status = '.self::STATUS_BLOCKED.'
                                   ':'').'
                               WHERE id = '.$nItemID, array(':reason'=>$sReason)); 
                               
                               
                if( ! empty($res) && !$nBlocked && $aData['status'] == self::STATUS_PUBLICATED) {
                    $this->itemsCounterUpdate($aData['cat_id'], $aData['type_id'], false);
                }

                $this->yandexXML();

                $this->ajaxResponse( Errors::SUCCESS );
            } break;
            case 'item-approve':
            {
                $nItemID = $this->input->post('id', TYPE_UINT);
                if( ! $nItemID) break;
                $aItemData = $this->db->one_array('SELECT status, publicated, publicated_to, cat_id, type_id FROM '.TABLE_REALTY_ITEMS.' WHERE id = '.$nItemID);
                if (empty($aItemData) || $aItemData['status'] == self::STATUS_NEW) break;

                $sql = '';
                if($aItemData['status'] == self::STATUS_BLOCKED) {
                    $newStatus = self::STATUS_PUBLICATED_OUT;
                    $now = time();
                    $from = strtotime($aItemData['publicated']);
                    $to = strtotime($aItemData['publicated_to']);
                    if( ! empty($from) && !empty($to) && $now>=$from && $now<$to) {
                        $newStatus = self::STATUS_PUBLICATED;
                    }
                    $sql = ', status_prev = status, status = '.$newStatus;
                }
                
                $res = $this->db->exec('UPDATE '.TABLE_REALTY_ITEMS.'
                               SET moderated = 1'.$sql.'
                               WHERE id = '.$nItemID); 

                if( ! empty($res) && !empty($newStatus) && $aItemData['status']!=$newStatus && $newStatus == self::STATUS_PUBLICATED && static::premoderation()) {
                    $this->itemsCounterUpdate($aItemData['cat_id'], $aItemData['type_id'], true);
                }

                $this->yandexXML();

                $this->ajaxResponse( Errors::SUCCESS );
            } break; 
            case 'item-publicate2':
            {
                $nItemID = $this->input->post('id', TYPE_UINT); 
                if( ! $nItemID) { $this->ajaxResponse(Errors::IMPOSSIBLE); }

                $aItem = $this->db->one_array('SELECT id, status, moderated, publicated, publicated_to, cat_id, type_id
                        FROM '.TABLE_REALTY_ITEMS.' WHERE id = '.$nItemID.' AND status != '.self::STATUS_NEW);
                if (empty($aItem)) break;
        
                if($aItem['status'] == self::STATUS_BLOCKED) {
                    if($aItem['moderated'] == 0) {
                        $this->errors->set( _t('realty', 'Невозможно продлить публикацию, поскольку объявление ожидает проверки') );
                    } else {
                        $this->errors->set( _t('realty', 'Невозможно продлить публикацию, поскольку объявление отклонено') );
                    }
                    break;
                }
                
                if($aItem['status'] == self::STATUS_PUBLICATED) {
                    $this->errors->set( _t('realty', 'Невозможно продлить публикацию, поскольку объявление опубликовано') );
                    break;
                }
            
                $nPeriod = $this->input->post('period', TYPE_UINT);
                $publicateTo = $this->preparePublicatePeriodTo( $nPeriod, 
                                ( $aItem['status'] == self::STATUS_PUBLICATED_OUT ? time() : strtotime($aItem['publicated_to']) ) );
                if (empty($publicateTo)) {
                    $this->errors->set( _t('realty', 'Период публикации указан не корректно') );
                    break;
                }
                    
                if( $aItem['status'] == self::STATUS_PUBLICATED_OUT )
                {
                    $toOld = strtotime( $aItem['publicated_to'] );
                    /* если разница между датой снятия с публикации и текущей датой
                     * более 3 дней, тогда поднимаем объявление вверх.
                     * в противном случае: оставлем дату старта публикации(pulicated) и дату порядка публикации(publicated_order) прежними
                     */
                    $bUpdatePublicatedOrder = ((time() - $toOld) > 259200); //60*60*24*3
                    $sqlNOW = $this->db->getNOW();
                    $res = $this->db->exec('UPDATE '.TABLE_REALTY_ITEMS.'
                        SET publicated_to = '.$this->db->str2sql( $publicateTo ).',
                            '.($bUpdatePublicatedOrder ? ' publicated = '.$sqlNOW.', publicated_order = '.$sqlNOW.',' : '').'
                            status_prev = status,
                            status = '.self::STATUS_PUBLICATED.',
                            moderated = 1
                        WHERE id = '.$nItemID.'
                    ');
                    
                    if( ! empty($res)) {
                        # накручиваем счетчики кол-ва опубликованных объявлений:
                        # в категории и типе категории:
                        $this->itemsCounterUpdate($aItem['cat_id'], $aItem['type_id'], true);
                        $this->yandexXML();
                        $this->ajaxResponse(Errors::SUCCESS);
                    }

                } else {
                    // продление опубликованных пока НЕ делаем
//                        $res = $this->db->exec('UPDATE '.TABLE_REALTY_ITEMS.'
//                            SET publicated_to = '.$this->db->str2sql( $publicateTo ).'
//                            WHERE id = '.$nItemID.'
//                        '); 
                }
            } break;
            case 'item-unpublicate':
            {
                $nItemID = $this->input->post('id', TYPE_UINT); 
                if( ! $nItemID) { $this->ajaxResponse(Errors::IMPOSSIBLE); }

                $aItem = $this->db->one_array('SELECT id, status, cat_id, type_id
                        FROM '.TABLE_REALTY_ITEMS.' WHERE id = '.$nItemID.' AND status = '.self::STATUS_PUBLICATED);
                if (empty($aItem)) break;
                if($aItem['status'] != self::STATUS_PUBLICATED) break;
                
                $sqlDateEmpty = $this->db->str2sql('0000-00-00 00:00:00');
                $res = $this->db->exec('UPDATE '.TABLE_REALTY_ITEMS.'
                            SET status_prev = status, status = '.self::STATUS_PUBLICATED_OUT.', moderated = 1,
                                publicated_to = '.$this->db->getNOW().' 
                        WHERE id='.$nItemID);
                if( ! empty($res)){
                    # откручиваем счетчики кол-ва опубликованных объявлений:
                    # в категории и типе категории: 
                    $this->itemsCounterUpdate($aItem['cat_id'], $aItem['type_id'], false);
                    $this->yandexXML();
                    $this->ajaxResponse(Errors::SUCCESS);
                }
            } break;
            case 'item-img-upload':
            {
                $nItemID = $this->input->postget('id', TYPE_UINT);
                if( ! $this->haveAccessTo('manage') || !$nItemID) {
                    $this->ajaxResponse(array('success' => false, 'error'=> $this->errors->getSystemMessage(Errors::ACCESSDENIED) ), 1);
                }

                $aResponse = array();
                $oImages = $this->initImages();
                $aResult = $oImages->uploadImageQQ();
                $aResponse['success'] = ($aResult !== false);
                $aResponse['filename'] = $oImages->saveImageFileCustom($nItemID, $aResult);
                $aResponse['errors'] = $this->errors->get(true);
                $this->ajaxResponse($aResponse, true, false, true);
            } break;
            case 'item-img-delete':
            {
                $nItemID   = $this->input->post('id', TYPE_UINT); 
                $sFilename = $this->input->post('filename', TYPE_STR);

                if (empty($sFilename) || !$nItemID) {
                    $this->ajaxResponse(Errors::IMPOSSIBLE);
                }
                
                $this->initImages()->deleteImageFileCustom($nItemID, $sFilename);
                
                $this->ajaxResponse(Errors::SUCCESS);
            } break;
            case 'item-address-edit':
            {
                $nCityID     = $this->input->post('city', TYPE_UINT);
                $nDistrictID = $this->input->post('district', TYPE_UINT);

                $aData['districts'] = Geo::districtList($nCityID);
                
                $this->ajaxResponse( $aData );
            } break;
            case 'item-users-autocomplete': # autocomplete
            {
                $sQ = $this->input->post('q', TYPE_NOTAGS);
                $aData = Users::model()->autocomplete($sQ);
                $this->autocompleteResponse($aData, 'user_id', 'title');
            }
            break;

        }
        $this->ajaxResponse(Errors::IMPOSSIBLE);
    }
    
    // ----------------------------------------------------------------------------------------------------

    function claims()
    {
        if( !$this->haveAccessTo('claims') )
            return $this->showAccessDenied();
 
        if(Request::isAJAX())
        {
            switch ($this->input->get('act'))
            {
                case 'delete':
                {

                    $nClaimID = $this->input->post('id', TYPE_UINT);
                    if($nClaimID) 
                    {
                        $aData = $this->db->one_array('SELECT id, viewed FROM '.TABLE_REALTY_CLAIMS.' WHERE id = '.$nClaimID);
                        if (empty($aData)) $this->ajaxResponse(Errors::IMPOSSIBLE);
                        
                        $aResponse = array('counter_update'=>false);
                        $res = $this->db->exec('DELETE FROM '.TABLE_REALTY_CLAIMS.' WHERE id = '.$nClaimID);
                        if($res && !$aData['viewed']) {
                            config::saveCount('realty_claims', -1, true);
                            $aResponse['counter_update'] = true;
                        }
                        $aResponse['res'] = $res;
                        $this->ajaxResponse( $aResponse );
                    }
                } break; 
                case 'view':
                {
                    $nClaimID = $this->input->post('id', TYPE_UINT);
                    if($nClaimID) {
                        $res = $this->db->exec('UPDATE '.TABLE_REALTY_CLAIMS.' SET viewed = 1 WHERE id = '.$nClaimID);
                        if($res) config::saveCount('realty_claims', -1, true);
                        $this->ajaxResponse( Errors::SUCCESS );
                    }
                } break;
            }
            $this->ajaxResponse( Errors::IMPOSSIBLE );
        } 

        $this->input->getm(array(
                'item'    => TYPE_UINT,
                'page'    => TYPE_UINT,
                'perpage' => TYPE_UINT,
                'user'    => TYPE_UINT,
            ), $aData);
        
        $sqlWhere = array();
        if($aData['item']) {
            $sqlWhere[] = 'CL.item_id = '.$aData['item'];
        }
        if($aData['user']) {
            $sqlWhere[] = 'CL.user_id = '.$aData['user'];
        }

        $nCount = $this->db->one_data('SELECT COUNT(CL.id) FROM '.TABLE_REALTY_CLAIMS.' CL '.( ! empty($sqlWhere) ? 'WHERE '.join(' AND ', $sqlWhere) : ''));
        $aOrdersAllowed = array('CL.created'=>'desc');
        $this->prepareOrder($orderBy, $orderDirection, 'CL.created-desc', $aOrdersAllowed);

        $aPerpage = $this->preparePerpage($aData['perpage'], array(20,40,60) );   
        
        $aData['order'] = "$orderBy,$orderDirection";
        $sFilter = http_build_query($aData); unset($aData['page']);
        $this->generatePagenation($nCount, $aData['perpage'], $this->adminLink("claims&$sFilter&{pageId}"), $sqlLimit);
        $aData['f'] = $sFilter;

        if($nCount>0) {
            $sqlWhere[] = ' CL.item_id = I.id ';
            $sqlWhere = ( ! empty($sqlWhere) ? 'WHERE '.join(' AND ', $sqlWhere) : '');
            $aData['complaints'] = $this->db->select('SELECT CL.*, 0 as other, I.link
                        FROM '.TABLE_REALTY_CLAIMS.' CL,
                             '.TABLE_REALTY_ITEMS.' I
                        '.$sqlWhere."
                        ORDER BY $orderBy $orderDirection $sqlLimit");
        } else {
            $aData['complaints'] = array();
        }
        
        $compl = &$aData['complaints'];
        $reasons = $this->getItemClaimReasons();
        if( ! empty($compl))
        {
            foreach($compl as $k=>$v)
            {
                $compl[$k]['item_link'] = static::url('view', $v['link']);
                if( ! empty($reasons) ) {
                    $r = $v['reasons'];
                    if($r==0) continue;

                    $r_text = array();
                    foreach($reasons as $rk=>$rv) {
                        if($rk!=32 && $rk & $r) {
                            $r_text[] = $rv;
                        }
                    }
                    $compl[$k]['reasons_text'] = join(', ', $r_text);
                    $compl[$k]['other'] = $r & 32;
                }
            }
        }

        $aData['perpage'] = $aPerpage;
        $aData['ajaxUrl'] = $this->adminLink('ajax').'&act=';
        if($aData['user']){
            $aUser = Users::model()->userData($aData['user'], array('login', 'email'));
            $aData['user_title'] = '#'.$aData['user'].' '.$aUser['login'].' ('.$aUser['email'].')';
        }
        tpl::includeJS('autocomplete', true);

        return $this->viewTPL($aData, 'admin.claims.listing.tpl');
    }
    
    function categories()
    {
        if( ! $this->haveAccessTo('settings'))
            return $this->showAccessDenied();

        if(Request::isAJAX())
        {
            switch ($this->input->get('act'))
            {
                case 'edit':
                {
                    $nCategoryID = $this->input->get('cat_id', TYPE_UINT);
                    if( ! $nCategoryID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $aData = $this->db->one_array('SELECT * FROM '.TABLE_REALTY_CATEGORIES.' WHERE id = '.$nCategoryID);
                    if (empty($aData)) $this->ajaxResponse(Errors::IMPOSSIBLE);
                    $this->db->langSelect($nCategoryID, $aData, $this->model->langCategories, TABLE_REALTY_CATEGORIES_LANG);

                    $aData['types'] = $this->db->select('
                        SELECT T.id, T.title_'.LNG.' AS title, CT.*, (CT.cat_id IS NOT NULL) as a
                        FROM '.TABLE_REALTY_TYPES.' T
                            LEFT JOIN '.TABLE_REALTY_CATEGORIES_TYPES.' CT ON CT.cat_id = '.$nCategoryID.' AND CT.type_id = T.id
                        ORDER BY T.num');
                    foreach($aData['types'] as $k => $v){
                        $this->db->langFieldsSelect($aData['types'][$k], $this->model->langCategoriesTypes);
                    }
                    $aResponse['form'] = $this->viewPHP($aData, 'admin.categories.form');

                    $this->ajaxResponse( $aResponse ); 
                } break;
                case 'toggle':
                {

                    $nCategoryID = $this->input->postget('rec', TYPE_UINT);
                    if( ! $nCategoryID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $this->model->toggleInt(TABLE_REALTY_CATEGORIES, $nCategoryID, 'enabled');
                    
                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'rotate':
                {

                    $this->db->rotateTablednd(TABLE_REALTY_CATEGORIES, '', 'id', 'num');
                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'delete':
                {

                    $nCategoryID = $this->input->get('cat_id', TYPE_UINT);
                    if( ! $nCategoryID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $res = $this->db->delete(TABLE_REALTY_CATEGORIES, $nCategoryID);
                    
                    $this->ajaxResponse( ( ! empty($res) ? Errors::SUCCESS : Errors::IMPOSSIBLE) );
                } break;
            }
        } 
        else if (Request::isPOST())
        {

            switch ($this->input->postget('act'))
            {
                case 'add-finish': 
                {
                    $aData = $this->validateCategoryData(0, true);
                    
                    $nNum = $this->db->one_data('SELECT MAX(num) FROM '.TABLE_REALTY_CATEGORIES);
                    $aData['num'] = intval($nNum) + 1;
                    if($this->errors->no()){
                        $nCategoryID = $this->model->categorySave(0, $aData);
                    }
                    
                } break;
                case 'edit-finish':
                {
                    $nCategoryID = $this->input->post('cat_id', TYPE_UINT);
                    if( ! $nCategoryID) $this->errors->unknownRecord();
                    
                    $aDataCur = $this->db->one_array('SELECT keyword FROM '.TABLE_REALTY_CATEGORIES.' WHERE id = '.$nCategoryID);
                    if (empty($aDataCur)) $this->errors->unknownRecord();

                    $aData = $this->validateCategoryData($nCategoryID, true);

                    # попытка изменения keyword'a категории
                    if($aData['keyword']!==$aDataCur['keyword']) 
                    {
                        $nItemsInCategory = $this->db->one_data('SELECT COUNT(*) FROM '.TABLE_REALTY_ITEMS.' WHERE cat_id = '.$nCategoryID);
                        if( ! empty($nItemsInCategory)) {
                            $this->errors->set( _t('realty', 'Невозможно изменить keyword раздела, посколько с ним уже связаны объявления') );
                            break;
                        } else if( $this->isKeywordExists($aData['keyword'], TABLE_REALTY_CATEGORIES, $nCategoryID) ) {
                            $this->errors->set( _t('realty', 'Данный keyword уже используется') );
                        }
                    }

                    if($this->errors->no()){
                        $this->model->categorySave($nCategoryID, $aData);
                    }
                } break;
            }

            $this->adminRedirect(Errors::SUCCESS, bff::$event );
        }
        
        $aData = $this->validateCategoryData(0, false);
        $aData['id'] = 0;
        $aData['cats'] = $this->categoriesGet( false, array('C.*'), false, true );
        $aData['types'] = $this->db->select('
            SELECT T.id, T.title_'.LNG.' AS title, 0 as prices, 0 as a, 0 as items
            FROM '.TABLE_REALTY_TYPES.' T
            ORDER BY T.num');

        $aData['dynprops_link'] = $this->adminLink('dynprops_listing');

        $aLocales = array_fill_keys($this->locale->getLanguages(), '');
        foreach($aData['types'] as $k => $v){
            foreach($this->model->langCategoriesTypes as $field => $val)
                $aData['types'][$k][$field] = $aLocales;
        }

        $aData['form'] = $this->viewPHP($aData, 'admin.categories.form');
        unset($aData['types']);
        return $this->viewPHP($aData, 'admin.categories.listing');
    }

    /**
     * Обрабатываем параметры запроса
     * @param integer $nCategoryID ID категории или 0
     * @param boolean $bSubmit выполняем сохранение/редактирование
     * @return array параметры
     */
    function validateCategoryData($nCategoryID, $bSubmit)
    {
        $aParams = array(
            'keyword'      => TYPE_NOTAGS, # keyword
            'address'      => TYPE_UINT,   # адрес: 0 - нет; 1 - есть, без карты; 2 - есть, с картой
            'enabled'      => TYPE_BOOL,   # включена ли категория
            'types'        => TYPE_ARRAY,  # доступные типы
            'mtemplate'    => TYPE_BOOL,   # использовать базовый шаблон seo
        );
        $aData = $this->input->postm($aParams);
        $this->input->postm_lang($this->model->langCategories, $aData);

        if($bSubmit)
        {
            if($aData['title'][LNG] == '') {
                $this->errors->set( _t('realty', 'Название категории указано некорректно') );
            }
            if($aData['keyword'] == '') {
                $this->errors->set( _t('realty', 'Keyword категории указан некорректно') );
            } else if( $nCategoryID && $this->isKeywordExists($aData['keyword'], TABLE_REALTY_CATEGORIES, $nCategoryID) ) {
                $this->errors->set( _t('realty', 'Данный keyword уже используется') );
            }

            foreach($aData['types'] as $k => $v){
                $this->input->clean_array($v, array(
                    'type_id'   => TYPE_UINT,
                    'prices'    => TYPE_ARRAY_UINT,
                ));

                foreach($this->model->langCategoriesTypes as $field => $type){
                    $aLocales = array_fill_keys($this->locale->getLanguages(), $type);
                    $this->input->clean_array($v[ $field ], $aLocales);
                }

                $v['prices'] = array_sum($v['prices']);
                $aData['types'][$k] = $v;
            }
        }
        return $aData;
    }


    function types()
    {
        if( ! $this->haveAccessTo('settings'))
            return $this->showAccessDenied();

        if(Request::isAJAX())
        {
            switch ($this->input->get('act'))
            {
                case 'edit':
                {
                    $nTypeID = $this->input->get('type_id', TYPE_UINT);
                    if( ! $nTypeID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $aData = $this->db->one_array('SELECT * FROM '.TABLE_REALTY_TYPES.' WHERE id = '.$nTypeID);
                    if (empty($aData)) $this->ajaxResponse(Errors::IMPOSSIBLE);
                    $this->db->langFieldsSelect($aData, $this->model->langTypes);

                    $aData['form'] = $this->viewPHP($aData, 'admin.types.form');

                    $this->ajaxResponse( $aData ); 
                } break;
                case 'toggle':
                {

                    $nTypeID = $this->input->postget('rec', TYPE_UINT);
                    if( ! $nTypeID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $this->model->toggleInt(TABLE_REALTY_TYPES, $nTypeID, 'enabled');
                    
                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'rotate':
                {

                    $this->db->rotateTablednd(TABLE_REALTY_TYPES, '', 'id', 'num');
                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'delete':
                {
                    $nTypeID = $this->input->get('type_id', TYPE_UINT);
                    if( ! $nTypeID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $res = $this->db->delete(TABLE_REALTY_TYPES, $nTypeID);
                    
                    $this->ajaxResponse( ( ! empty($res) ? Errors::SUCCESS : Errors::IMPOSSIBLE) );
                } break;
            }
        } 
        else if (Request::isPOST())
        {

            switch ($this->input->postget('act'))
            {
                case 'add-finish': 
                {
                    $aData = $this->typesProcessData();
                    
                    $nNum = $this->db->one_data('SELECT MAX(num) FROM '.TABLE_REALTY_TYPES);
                    $aData['num'] = intval($nNum) + 1;
                    if($this->errors->no())
                    {
                        $this->db->langFieldsModify($aData, $this->model->langTypes, $aData);
                        $this->db->insert(TABLE_REALTY_TYPES, $aData);
                    }
                    
                } break;
                case 'edit-finish':
                {
                    $nTypeID = $this->input->post('type_id', TYPE_UINT);
                    if( ! $nTypeID) $this->errors->unknownRecord();
                    
                    $aDataCur = $this->db->one_array('SELECT * FROM '.TABLE_REALTY_TYPES.' WHERE id = '.$nTypeID);
                    if (empty($aDataCur)) $this->errors->unknownRecord();
                    
                    $aData = $this->typesProcessData();
                    
                    //попытка изменения keyword'a типа
                    if($aData['keyword']!==$aDataCur['keyword']) 
                    {
                        $nItemsInCategory = $this->db->one_data('SELECT COUNT(*) FROM '.TABLE_REALTY_ITEMS.' WHERE type_id = '.$nTypeID);
                        if( ! empty($nItemsInCategory)) {
                            $this->errors->set( _t('realty', 'Невозможно изменить keyword типа, посколько с ним уже связаны объявления') );
                            break;
                        }
                    }

                    if($this->errors->no()) {
                        $this->db->langFieldsModify($aData, $this->model->langTypes, $aData);
                        $this->db->update(TABLE_REALTY_TYPES, $aData, array('id'=>$nTypeID));
                    }
                } break;
            }

            $this->adminRedirect(Errors::SUCCESS, bff::$event );
        }
        
        $aData = $this->typesProcessData();
        $aData['id'] = 0;
        $aData['types'] = $this->typesGet( false, array('T.id', 'T.title_'.LNG.' AS title, T.enabled '), false );

        $aData['form'] = $this->viewPHP($aData, 'admin.types.form');
        return $this->viewPHP($aData, 'admin.types.listing');
    }

    //-------------------------------------------------------------------------------------------------------------------------------
    // Услуги

    public function svc_services()
    {
        if( ! $this->haveAccessTo('svc'))
            return $this->showAccessDenied();

        $svc = $this->svc()->model;

        if(Request::isAJAX())
        {
            $aResponse = array();

            switch ( $this->input->getpost('act') )
            {
                case 'update':
                {
                    $nSvcID = $this->input->post('id', TYPE_UINT);
                    if( ! $nSvcID) {
                        $this->errors->unknownRecord();
                        break;
                    }

                    $aData = $svc->svcData( $nSvcID, array('id','type','keyword') );
                    if (empty($aData) || $aData['type'] != Svc::TYPE_SERVICE) {
                        $this->errors->unknownRecord();
                        break;
                    }

                    $this->svcValidateData($nSvcID, Svc::TYPE_SERVICE, $aDataSave);

                    if( $this->errors->no() ) {
                        $svc->svcSave( $nSvcID, $aDataSave);
                        $aResponse['modified'] = tpl::date_format2(BFF_NOW, true).', <a class="bold desc" href="#" onclick="return bff.userinfo('.User::id().');">'.User::data('login').'</a>';
                    }

                } break;
                default: {
                    $this->errors->impossible();
                } break;
            }

            $this->ajaxResponseForm($aResponse);
        }

        $aData = array(
            'svc' => $svc->svcListing(Svc::TYPE_SERVICE, $this->module_name),
        );

        tpl::includeJS(array('wysiwyg'), true);
        return $this->viewPHP($aData, 'admin.services');
    }

    /**
     * Проверка данных услуги / пакета услуг
     * @param integer $nSvcID ID услуги / пакета услуг
     * @param integer $nType тип Svc::TYPE_
     * @param array $aData @ref проверенные данные
     */
    function svcValidateData($nSvcID, $nType, &$aData)
    {
        $aParams = array(
            'price' => TYPE_PRICE
        );

        if($nType == Svc::TYPE_SERVICE)
        {
            $aSettings = array(
                'on' => TYPE_BOOL, # включена
            );
            $aSettingsLang = array(
                'description' => TYPE_STR, # описание
            );

            switch ($nSvcID)
            {
                case self::SERVICE_UP:
                {

                } break;
                case self::SERVICE_MARK:
                {

                } break;
                case self::SERVICE_FIX:
                {

                } break;
                case self::SERVICE_VIP:
                {
                    $aSettings['cnt'] = TYPE_UINT;
                } break;
            }

            $aData = $this->input->postm($aParams);
            $aData['settings'] = $this->input->postm($aSettings);
            $this->input->postm_lang($aSettingsLang, $aData['settings']);

            if( Request::isPOST() )
            {
                //
            }
        }
    }

}