<?php
    $blocked = ($status == Realty::STATUS_BLOCKED);
?>

<script type="text/javascript">
//<![CDATA[
    var realtyUrlAjax = '<?= $this->adminLink('ajax&act=') ?>';

    var realtyEdit = (function()
    {
        var $form, $progress, id = 0;
        var addr = {i:false,addr:0,lat:0,lng:0, progress:0, ycoords:0, dist:{}}, $district,
            city = {id:<?= $city_id ?>,title:'<?= $reg['c_title'] ?>'},
            hasMap = false;

        $(function(){ init(); });
        
        function init()
        {
            id = <?= $id ?>;
            $form = $('#realty-form');
            $progress = $('#realty-form-progress', $form);

            $form.submit(function(){
                var error = false;
                $('input.req, select.req', this).each(function() {
                    var val = $(this).val();
                    if( $.trim(val) == '' || val == 0 || val === undefined || val == $(this).attr('placeholder')) {
                        error = true;
                    }
                });
                
                if(error) { 
                    bff.error('Заполните все необходимые поля');   
                } else {
                    bff.ajax(document.location, $form.serialize(), function(data, errors) {  
                        if(data && data.res) { 
                            history.back();
                        } else {
                            if(errors) {
                                bff.error(errors);
                            }
                        }
                    }, $progress); 
                }
                return false;
            });
        }

        function initAddr()
        {
            if( addr.i === true ) {
                addr.map.refresh();
                return;
            }

            addr.addr = $form.find('#realty-addr-addr');
            addr.lat  = $form.find('#realty-addr_lat');
            addr.lng  = $form.find('#realty-addr_lng');
            addr.i    = true;

            addr.map = bff.map.init('realty-addr-map', [addr.lat.val(), addr.lng.val()], function(map){
                addr.mapEditor = bff.map.editor();
                addr.mapEditor.init({
                    map: map, version: '2.1',
                    coords: [addr.lat, addr.lng],
                    address: addr.addr,
                    addressKind: 'house',
                    updateAddressIgnoreClass: 'typed',
                    onUpdate: function(marker){
                        if (addr.map.isYandex()) {
                            selectDistrictByPoint(marker.geometry.getCoordinates());
                        }
                    }
                });
                addr.addr.bind('change keyup input', $.debounce(function(){
                    if( ! $.trim(addr.addr.val()).length ) {
                        addr.addr.removeClass('typed');
                    } else {
                        addr.addr.addClass('typed');
                        realtyEdit.onMapSearch();
                    }
                }, 700));
            }, {zoom: 12});
        }

        function selectDistrictByPoint(point)
        {
            $district.val(0);
            if(city.id > 0 && addr.dist[city.id]) {
                var d = addr.dist[city.id];
                for(var i in d) {
                    if(addr.map.isYandex()) {
                        if( d[i].ypoly.contains(point) ){
                            $district.val(i);
                        }
                    }
                }
            }
        }
        
        function buildDistrictSelect(districts, cityID, ycoords)
        {
            var html = '<option value="0">Не указан</option>';
            for(var i in districts) {
                html += '<option value="'+i+'">'+districts[i].t+'</option>';
            }
            $district.html( html );
            
            if(hasMap) 
            {
                var point = false;
                if(cityID>0 && cityID!=city.id) {
                    if(ycoords.length) {
                        point = bff.map.coordsFromString(ycoords);
                        addr.map.panTo(point, {duration: 800});
                    }
                } else {
                    ycoords = addr.ycoords.val();
                    if(ycoords.length > 5) {
                        point = bff.map.coordsFromString(ycoords);
                    }
                }

                if(point!==false) {
                    selectDistrictByPoint(point);
                }
            }
        }

        function addrEdit(catAddressType)
        {
            var $view    = $('#realty-addr-view', $form).addClass('disabled');
            var $edit    = $('#realty-addr-edit', $form);
            addr.ycoords = $('#realty-addr-ycoords', $form);

            hasMap = (catAddressType == 2);
            if (hasMap) {
                initAddr();
            } else {
                $('#realty-addr-map-link', $form).hide();
                $('#realty-addr-map-block', $form).hide();
            }
            
            bff.ajax(realtyUrlAjax+'item-address-edit', {city: <?= $city_id ?>, district:<?= $district_id ?>}, function(data){
                if (data) {
                    if (data.districts && hasMap) {
                        $.each(data.districts, function(j,d) {
                            if (addr.map.isYandex()) {
                                d.ypoly = ymaps.geometry.Polygon.fromEncodedCoordinates(d.ypoly);
                                d.ypoly.options.setParent(addr.map.getMap().options);
                                d.ypoly.setMap(addr.map.getMap());
                            }
                        });
                    }
                    buildDistrictSelect( (addr.dist[city.id] = data.districts), city.id, '<?= $reg['ycoords'] ?>');
                }
                $view.remove();
                $edit.show();
                if(hasMap) {
                    addr.map.refresh();
                }
            }, addr.progress); 
        }

        return {
            onAddrEdit: function(catAddressType)
            {
                addr.addr     = $('#realty-addr-addr', $form);
                addr.progress = $('#realty-addr-progress', $form);
                addr.ycoords  = $('#realty-addr-ycoords', $form);
                $district     = $('#realty-addr-district', $form);
                
                addr.progress.show();
                addrEdit(catAddressType);
            },
            onCity: function(cityID, sel)
            {
                cityID = intval(cityID);
                if( ! cityID){ buildDistrictSelect([], 0, ''); return; }
                var opt = $('option:selected', sel);  
                city.title = opt.text(); 
                city.ycoords = opt.data('ycoords');
                if(addr.dist[cityID]) {
                    buildDistrictSelect(addr.dist[cityID], cityID, city.ycoords);
                    city.id = cityID;
                    return;
                }
                bff.ajax('<?= bff::urlAjax('geo','districts-list') ?>', {city: cityID}, function(data){
                    if(data && data.success) {
                        if(data.districts && hasMap) {
                            $.each(data.districts, function(j,d){
                                if(addr.map.isYandex()) {
                                    d.ypoly = ymaps.geometry.Polygon.fromEncodedCoordinates(d.ypoly);
                                }
                            });
                        }
                        addr.dist[cityID] = data.districts;
                        buildDistrictSelect( addr.dist[cityID], cityID, city.ycoords );
                        city.id = cityID;
                    }
                });
            },
            onMapSearch: function()
            {
                var q = [city.title];
                q.push( $.trim( addr.addr.val() ) );
                addr.mapEditor.search( q.join(', ') );
                return false;
            },
            changeBlocked: function(step, block)
            {
                var form = $form.get(0);
                if(step==1){ // заблокировать/изменить блокировку
                    $('#i_blocked', $form).hide();
                    $('#i_blocked_error, #i_blocking, #i_blocking_warn', $form).show(0, function(){
                        form['blocked_reason'].focus();
                    }); 
                } else if(step==2) { // отменить
                    if(form['blocked'].value == 1){
                        $('#i_blocking, #i_blocking_warn', $form).hide();
                        $('#i_blocked', $form).show(); 
                    } else {
                        $('#i_blocked_error, #i_blocking_warn', $form).hide(); 
                    }
                } else if(step==3) { // сохранить
                    bff.ajax(realtyUrlAjax+'item-block', $form.serializeArray(), function(data){
                        if(data)
                        {
                            if(!block){
                                $('#i_blocked_error, #i_blocking_warn', $form).hide();
                            } else {
                                $('#i_blocking_warn', $form).hide();
                                $('#i_blocked_text', $form).html(form['blocked_reason'].value);
                                $('#i_blocked_error', $form).show();
                                realtyEdit.changeBlocked(2);
                            }
                            history.back();
                        }
                    }, $progress);
                }
                return false;
            },
            approve: function()
            {
                bff.ajax(realtyUrlAjax+'item-approve', $form.serializeArray(), function(data){
                    if(data) { 
                       history.back();
                    }
                }, $progress);
            },
            unpublicate: function()
            {
                if(!bff.confirm('sure')) return;
                
                bff.ajax(realtyUrlAjax+'item-unpublicate', $form.serializeArray(), function(data){
                    if(data) {
                        history.back();
                    }
                }, $progress);
            },
            publicate2: function(step)
            {
                var $block = $('#i_publicate2', $form);
                if(step==0)
                {
                    $block.show();
                }
                else if(step==1) //сохранить
                {
                    bff.ajax(realtyUrlAjax+'item-publicate2', $form.serializeArray(), function(data){
                        if(data) { 
                           history.back();
                        }
                    }, $progress);
                }
                else if(step==2) //отмена
                {
                    $block.hide();
                }
            }
        };
    }());

    var realtyPhotos = (function()
    {

        var uploader, url = '<?= $this->adminLink('ajax&act=') ?>', path = '<?= $this->initImages()->getUrl() ?>';
        var $form, $block, $progress;
        var itemID = <?= $id ?>;
        $(function(){

            $form     = $('#realty-form');
            $block    = $('#realty-form-images', $form);
            $progress = $('#realty-form-images-progress', $form);

            // init uploader
            uploader = new qq.FileUploaderBasic({
                button: $('#realty-form-images-button', $form).get(0),
                action: url+'item-img-upload&id='+itemID,
                limit: <?= Realty::imagesLimit() ?>,
                uploaded: <?= $imgcnt ?>,
                multiple: true,
                onSubmit: function(id, fileName) {
                    $progress.show();
                },
                onComplete: function(id, fileName, data) {
                    if(data && data.success) {
                        $block.append('<div class="left" style="margin-right: 5px;">\
                                <input type="hidden" name="filename[]" value="'+data.filename+'" />\
                                <a href="'+ path + itemID + data.filename + '" rel="realty_photos" target="_blank">\
                                    <img src="' + path + itemID + 's' + data.filename + '" />\
                                </a> <br /> \
                                <a href="#" class="txt del ajax but but-text" rel="'+data.filename+'">Удалить</a>\
                            </div>');
                        $('a[rel="realty_photos"]', $block).fancybox();
                    } else {
                        if(data.errors) {
                            app.showError($('#realty-error'), data.errors, false);
                        }
                    }
                    if( ! uploader.getInProgress()) {
                        $progress.hide();
                    }
                    return true;
                }
            });

            $block.on('click', 'a.del', function (e) {
                nothing(e);
                var lnk = $(this);
                if(confirm('Удалить фото?')) {
                    var fn = lnk.attr('rel');
                    bff.ajax(url+'item-img-delete', {filename:fn, id:itemID}, function(data) {
                        if(data) {
                            lnk.parent().remove();
                            uploader.decrementUploaded();
                        }
                    });
                } return false;
            });

            $('a[rel="realty_photos"]', $block).fancybox();
        });

        return {};

    }());
//]]>
</script>

<form method="post" action="" id="realty-form" name="realtyItemEditForm">
<input type="hidden" name="id" value="<?= $id; ?>" />
<input type="hidden" name="blocked" value="<?= ($blocked?1:0) ?>" />
<input type="hidden" name="cat_id" value="<?= $cat_id; ?>" />
<input type="hidden" name="type_id" value="<?= $type_id; ?>" /> 
<table class="admtbl tbledit dp">
<tr>
    <td class="row1" width="90"><span class="field-title">Раздел</span>:</td>
    <td class="row2 bold"><div style="height:20px;"><a href="<?= $this->adminLink('listing&cat='.$cat_id) ?>"><?= $cat_title; ?></a><span class="desc"> / </span><?= $type_title; ?></div></td>
</tr>
<? if($cat_prices & Realty::TYPE_PRICE)
{ ?>
<tr id="realty-prices">
    <td class="row1"><span class="field-title">Цена</span>:<span class="req">*</span></td>
    <td class="row2">
        <input type="text" maxlength="9" name="price" class="req" value="<?= $price; ?>" style="width:120px;" pattern="[0-9]*" /> &nbsp;&nbsp;
        <select name="price_curr"><?= $curr ?></select>
        <? foreach($this->getPriceParams() as $ppKey=>$ppTitle) {
             if($cat_prices & $ppKey){ ?><label class="checkbox inline"><input type="checkbox" <?= ($price_params & $ppKey ?'checked':'') ?> name="price_params[]" value="<?= $ppKey ?>" /> <?= $ppTitle ?></label>&nbsp;<? }
           } ?>
    </td>
</tr>
<? } 
if($cat_address)
{
    Geo::mapsDefaultCoordsCorrect($lat, $lng);
?>
<tr> 
    <td class="row1"><span class="field-title">Адрес</span>:<div class="progress" id="realty-addr-progress" style="display: none;"></div></td>
    <td class="row2">
        <input type="hidden" name="lat" id="realty-addr_lat" value="<?= $lat ?>" />
        <input type="hidden" name="lng" id="realty-addr_lng" value="<?= $lng ?>" />
        <input type="hidden" name="ycoords" id="realty-addr-ycoords" value="<?= $lat.','.$lng; ?>" />

        <span id="realty-addr-view">
            <?= $address_full ?>
            <a href="#" id="realty-addr-edit-link" class="ajax desc" onclick="realtyEdit.onAddrEdit(intval(<?= $cat_address ?>)); return false;">- изменить</a>
        </span>
        <div id="realty-addr-edit" style="display:none;">
            <?= Geo::cityOptionsSelect($city_id, true, 'city_id', array('id'=>'realty-addr-city', 'onchange'=>'realtyEdit.onCity(intval(this.value), this);', 'style'=>'width:198px;')); ?>
            <select name="district_id" id="realty-addr-district" style="width:198px;"><option value="<?= $district_id ?>"></option></select><br/>
            <input type="text" name="address" value="<?= HTML::escape($address) ?>" id="realty-addr-addr" style="width: 300px; margin: 5px 5px 5px 0;" />
            <a href="#" class="ajax" id="realty-addr-map-link" onclick="realtyEdit.onMapSearch(); return false;">найти на карте</a><br/> 
            <div id="realty-addr-map-block">
                <div id="realty-addr-map" class="map" style="width:466px; height: 300px;"></div>
                <span class="desc small">Переместите маркер на карте чтобы указать точное местоположение</span>
            </div>
        </div>
    </td>
</tr>
<? } ?>
<? if( ! empty($dp)) { ?><tr><td colspan="2"><hr class="cut"></td></tr><?= $dp; } ?>
<tr><td colspan="2"><hr class="cut"></td></tr> 
<tr>
    <td class="row1"><span class="field-title">Дополнительно</span>: </td>
    <td class="row2"><textarea name="info" style="height: 110px;" class="stretch"><?= $info; ?></textarea></td>
</tr>
<tr><td colspan="2"><hr class="cut"></td></tr>    
<tr>
    <td class="row1 field-title" width="90">Тип:</td>
    <td class="row2"><span class="desc"><?= ($user_type == Realty::USERTYPE_AGENT ? 'Агент' : 'Владелец' ) ?></span></td>
</tr>
<? if($user_id > 0) { if(!empty($aCompanyInfo)) { ?>
<tr>
    <td class="row1 field-title">Компания:</td>
    <td>
        <a href="<?= Items::url('view', $aCompanyInfo['link']) ?>" class="but linkout" target="_blank"></a><a href="<?= $this->adminLink('items_edit&item_id='.$company_id, 'items') ?>"><?= $aCompanyInfo['title'] ?></a>
    </td>
</tr>
<? } ?>
<tr>
    <td class="row1 field-title">Пользователь:</td>
    <td class="row2"><a href="#" class="ajax<? if($user_blocked){ ?> block_s<? } ?>" onclick="return bff.userinfo(<?= $user_id ?>);"><?= $user_email ?></a></td>
</tr>
<? } ?>
<tr>
    <td class="row1 field-title">Имя:</td>
    <td class="row2"><?= ( ! empty($user_name) ? $user_name : 'нет') ?></td>
</tr>
<tr>
    <td class="row1 field-title">Телефон:</td>
    <td class="row2"><?= ( ! empty($user_phone) ? $user_phone : 'нет') ?></td>
</tr>
<tr>
    <td class="row1 field-title">Email:</td>
    <td class="row2"><?= ( ! empty($user_email) ? $user_email : 'нет') ?></td>
</tr>
<tr><td colspan="2"><hr class="cut"></td></tr>
<tr>
    <td class="row1 field-title">Изображения:</td>
    <td class="row2">
        <div style="margin-top: 5px;" id="realty-form-images">
                <?
                    if($imgcnt>0)
                    {
                        $img = explode(',',$img);
                        $img_url = $this->initImages()->getUrl();
                        foreach($img as $i) 
                        { if($i) { ?>
                        <div class="left" style="margin-right: 5px;">
                            <input type="hidden" name="filename[]" value="<?= $i ?>" />
                            <a href="<?= $img_url.$id.$i; ?>" rel="realty_photos" target="_blank"><img src="<?= $img_url.$id.'s'.$i ?>" /></a><br />
                            <a href="#" class="but del ajax but-text" rel="<?= $i ?>" style="margin-top:2px;">Удалить</a>
                        </div>
                    <?  } }
                    }
                ?>
        </div>
        <div class="clear"></div>
        <br/>  
        <div id="realty-form-images-button" style="height: 20px; width: 160px"><a href="javascript:void(0);" class="ajax"><?= _t('', 'Загрузить фотографии'); ?></a></div>
        <div class="left progress" style="margin-top: 4px; display:none;" id="realty-form-images-progress"></div>
        <div class="clear"></div>
    </td>
</tr>
<tr><td colspan="2"><hr class="cut"></td></tr>
<tr>
    <td class="row1 field-title">Статус:</td>
    <td class="row2"><b><?
        switch ($status) {
            case Realty::STATUS_NEW:           { echo 'Новое'; } break;
            case Realty::STATUS_PUBLICATED:    { echo 'Публикуется'; } break;
            case Realty::STATUS_PUBLICATED_OUT: { echo 'Период публикации завершился'; } break;
            case Realty::STATUS_BLOCKED:       { echo ($moderated == 0?'Заблокировано (ожидает проверки)':'Заблокировано'); } break;
        }
    ?></b></td>
</tr>
<? if($status != Realty::STATUS_NEW) { ?>
<tr>
    <td class="row1 field-title">Период публикации:</td>
    <td class="row2"><b><?= tpl::date_format2($publicated, true).' - '.tpl::date_format2($publicated_to, true); ?></b></td>
</tr>
<? } ?>
<tr>
    <td class="row1"></td>
    <td class="row2">
        <div class="warnblock<?= ( ! $blocked ? ' hidden':'') ?>" id="i_blocked_error" style="margin-bottom:10px;">
            <div class="warnblock-content">  
                <div><b>причина отклонения</b>: <div class="right description" id="i_blocking_warn" style="display:none;"></div></div>
                <div class="clear"></div> 
                <div id="i_blocked">
                    <span id="i_blocked_text"><?= ( ! empty($blocked_reason) ? $blocked_reason :'?') ?></span> - <a href="#" onclick="realtyEdit.changeBlocked(1,0); return false;" class="ajax description">изменить</a>
                </div>
                <div id="i_blocking" style="display: none;">
                    <textarea name="blocked_reason" id="i_blocking_text" class="autogrow" style="height:60px; min-height:60px;"
                        onkeyup="checkTextLength(300, this.value, $('#i_blocking_warn').get(0));"><?= $blocked_reason; ?></textarea>
                    <a onclick="return realtyEdit.changeBlocked(3,1);" class="ajax" href="#"><?= ( ! $blocked ? 'продолжить':'изменить причину') ?></a>&nbsp;&nbsp;<a onclick="return realtyEdit.changeBlocked(2);" class="ajax desc" href="#">отмена</a>
                </div> 
            </div>
        </div> 
        
        <div class="warnblock hidden" id="i_publicate2" style=margin-bottom:10px;">
            <div class="warnblock-content">
                <table class="admtbl tbledit">
                <tr class="row1">
                    <td width="115">Период публикации:</td>
                    <td>
                    <script type="text/javascript"> 
                    <?
                        $periods = $this->getPublicatePeriods();
                    ?>
                    var iPublicatePeriods = <?= func::php2js( $periods );  ?>;
                    </script>
                    <select class="inputText2" tabindex="1" name="period" onchange="$('#publicated2-till').html( iPublicatePeriods[this.value] );">
                        <?= $periods['options'] ?>
                    </select>
                    </td>
                </tr>
                <tr class="row1"><td>Срок публикации:</td><td><?= ($status == Realty::STATUS_PUBLICATED_OUT ? 'с '.date('d.m.Y').' по ' : ' до ' ) ?><span id="publicated2-till"><?= $periods['dates'][1]; ?></span></td></tr>
                <tr class="row1"><td style="margin-bottom:10px;" colspan="2">
                    <a onclick="return realtyEdit.publicate2(1);" class="ajax" href="#">опубликовать</a>&nbsp;&nbsp;<a onclick="return realtyEdit.publicate2(2);" class="ajax desc" href="#">отмена</a>
                </td></tr>
                </table>   
            </div> 
        </div>
    </td>
</tr>
<tr>
    <td class="row1" colspan="2">
        <input type="submit" class="btn btn-success button submit" value="сохранить" />
       <?
       if($moderated == 0) { ?>
            <input class="btn success button" type="button" onclick="realtyEdit.approve();" value="<?= ($status == Realty::STATUS_BLOCKED ? 'проверено, все впорядке' : 'проверено') ?>" />
       <? } else {
           if($status == Realty::STATUS_PUBLICATED_OUT) {
                ?><input class="btn submit button" type="button" onclick="realtyEdit.publicate2(0);" value="опубликовать" /><?
           } else if($status == Realty::STATUS_PUBLICATED) {
                ?><input class="btn submit button" type="button" onclick="realtyEdit.unpublicate();" value="снять с публикации" /><?
           }
       }
       if($status != Realty::STATUS_BLOCKED) { ?>
           <input class="btn clr-error delete button" onclick="realtyEdit.changeBlocked(1,0,0); return false;" id="i_block_lnk" type="button" value="отклонить" />
       <? } ?>
        <input type="button" class="btn button cancel" value="отмена" onclick="history.back();" />
        <div class="progress" style="margin: 8px 8px 0; display: none;" id="realty-form-progress"></div>
    </td>
</tr>
</table>

</form>