<?php

# Класс пользователей (members)

class Users extends UsersBase
{
    function login()
    {
        if (User::id()) $this->redirect('/');
        $aData = array();

        # SEO: Авторизация
        $this->urlCorrection(static::url('login'));
        $this->seo()->canonicalUrl(static::url('login', array(), true));
        $this->setMeta('login', array(), $aData);

        return $this->viewPHP($aData, 'login');
    }

    function register()
    {
        if (User::id()) $this->redirect('/');

        $aData = array();

        switch ($this->input->getpost('step', TYPE_STR))
        {
            case 'social': # Регистрация через аккаунт в соц. сети
            {
                $aSocialData = $this->social()->authData();
                if (empty($aSocialData)){
                    $this->redirect(bff::urlBase());
                }
                return $this->viewPHP($aSocialData, 'register.social');

            } break;
        }

        if( ! empty($_GET['success']))
        {
            $aData['email2'] = $this->setRegisterSecondEnotifyFlag(0, true);
            return $this->viewPHP($aData, 'register.success');
        }

        # SEO: Регистрация
        $this->urlCorrection(static::url('register'));
        $this->seo()->canonicalUrl(static::url('register', array(), true));
        $this->setMeta('register', array(), $aData);

        return $this->viewPHP($aData, 'register');
    }

    /**
     * Авторизация через соц. сети
     */
    public function loginSocial()
    {
        $this->social()->auth($this->input->get('provider', TYPE_NOTAGS));
    }

    /*
    public function login_social2()
    {
        if(User::id()) {
            // уже авторизованы, редирект на главную
            $this->redirectToProfile();
        }

        $social = new UsersSocial();
        $aData = $social->getSocialData();
        if (empty($aData)){
            $this->redirect(bff::urlBase());
        }
        $aData['hash'] = $this->security->getToken();
        return $this->viewPHP($aData, 'register.social');
    }
    */

    public function login_admin()
    {
        $nUserID = $this->input->get('user_id', TYPE_UINT);
        do {
            if( ! strpos(Request::referer(), SITEHOST)) break;
            if( ! $nUserID) break;
            $aData = $this->model->userData($nUserID, array('email','password'));
            if (empty($aData)) break;
            $sHash = $this->input->get('hash', TYPE_STR);
            if (empty($sHash)) break;
            if($sHash != $this->frontendAuthHash($nUserID, $aData['email'])) break;
            if($this->userAuth($nUserID, 'user_id', $aData['password']) !== true) break;

            $this->redirect(bff::urlBase());

        }while(false);
        $this->errors->error404();
    }

    public function activate()
    {
        if (User::id()) {
            $this->redirectToProfile();
        }
        
        $sCode = $this->input->get('c', TYPE_NOTAGS);

        $aData = $this->model->userDataByFilter(
                    array('activate_key'=>$sCode,'activate_expire > :expire','activated'=>0),
                    array('user_id','login','password','last_login'),
                    array(':expire'=>$this->db->now()));

        if (empty($aData)) {
            return $this->showForbidden(_t('users','Активация аккаунта'), _t('users','Срок действия ключа активации истек.'));
        }

        $nUserID = $aData['user_id'];         

        // success
        $bSuccess = $this->model->userSave($nUserID, array('activated'=>1, 'activate_key'=>''));

        if( ! empty($bSuccess) ) {
            # триггер активации аккаунта
            bff::i()->callModules('onUserActivated', array($nUserID));
        }

        $res = $this->userAuth($aData['login'], 'login', $aData['password'], true, false);
        if($res === true) {
            if($aData['last_login']=='0000-00-00 00:00:00') {
                $this->redirect( static::url('my.settings', array('start'=>1)) );
            }
            $this->redirect( static::url('my.profile') );
        }

        return $this->showForbidden(_t('users','Активация аккаунта'), _t('users','Аккаунт успешно активирован.'));
    }
    
    public function forgot()
    {
        $aData = array();
        
        if(!empty($_GET['success'])) {
             switch ($_GET['success'])
             {
                 case 1: {
                     return $this->showSuccess(_t('users','Восстановление пароля'),
                         _t('users','На ваш электронный ящик были высланы инструкции по смене пароля.'));
                 } break;
                 case 2: {
                     return $this->showSuccess(_t('users','Восстановление пароля'),
                         _t('users','Ваш пароль был успешно изменен.'));
                 } break;                 
             }                 
        }
        
        # шаг №2
        $sCode = $this->input->getpost('c', TYPE_NOTAGS);
        if(!empty($sCode))
        {
            if(Request::isAJAX())
            {
                $aData = $this->model->userDataByFilter(
                            array('activate_key'=>$sCode,'activate_expire > :expire','activated'=>1),
                            array('user_id','login','email','password','password_salt','activated'),
                            array(':expire'=>$this->db->now()));
                do {
                    if (empty($aData)) {
                        $this->errors->set( _t('users', 'Срок дейтствия ссылки восстановления пароля истек, [rlink_a]повторите попытку[rlink_b].', array('rlink_a'=>'<a href="/user/forgot">', 'rlink_b'=>'</a>')) );
                        break;
                    }
                    
                    $sPassword = $this->input->post('password', TYPE_NOTRIM);
                    if(strlen($sPassword) <= $this->passwordMinLength) {
                        $this->errors->set( _t('users', 'Пароль слишком короткий'), 'password');
                        break;
                    }
                    
                    $sPassword = $this->security->getUserPasswordMD5($sPassword, $aData['password_salt']);
                    $res = $this->model->userSave($aData['user_id'],
                        array('password'=>$sPassword, 'activate_key'=>''));
                    if( ! $res) {
                        $this->errors->impossible();
                        break;
                    }
                    if($this->input->post('social', TYPE_UINT)){  //флаг регистрация через соц. сеть
                        $oSocial = new UsersSocial();
                        $aSocialData = $oSocial->getSocialData();
                        if( ! empty($aSocialData)){
                            //привяжим соц. акаунт к созданному
                            $oSocial->linkSocialAccount2User($aSocialData['id'], $aData['user_id']);
                        }
                    }

                    
                    $this->ajaxResponse( Errors::SUCCESS );
                    
                } while(false);

                $this->ajaxResponse( null );
            }
            
            $aData['code'] = $sCode;
            $aData['step'] = 2;
            $aData['social'] = $this->input->get('social', TYPE_UINT);
            return $this->viewPHP($aData, 'forgot');
        }
        
        # шаг №1
        if(Request::isAJAX())
        {
            $sEmail = $this->input->post('email', TYPE_NOTAGS);
            
            if(User::id()) {
                $this->ajaxResponse( Errors::IMPOSSIBLE );
            }
            
            if( ! $this->input->isEmail($sEmail)) {
                $this->errors->set( _t('users', 'E-mail адрес указан некорректно'), 'email' );
            } else {
                $aData = $this->model->userDataByFilter(
                            array('email'=>$sEmail,'activated'=>1),
                            array('user_id','email','name','surname'));
                if( empty($aData) ) {
                    $this->errors->set( _t('users', 'Указанный e-mail в базе не найден'), 'email' );
                } else {
                    $sCode = func::generator(22);
                    $res = $this->model->userSave($aData['user_id'], array(
                        'activate_key'    => $sCode,
                        'activate_expire' => date('Y-m-d H:i:s', strtotime('+8 hours')),
                    ));
                    if( ! $res) {
                        $this->errors->impossible();
                    } else {
                        $isSocial = $this->input->post('social',TYPE_UINT); # флаг регистрация через соц. сеть
                        bff::sendMailTemplate(array(
                            'link'  => static::url('forgot', 'c='.$sCode.($isSocial ? '&social=1':'')),
                            'email' => $sEmail,
                            'name'  => $aData['name'],
                            'surname'=>$aData['surname']
                        ), 'member_passforgot', $sEmail);
                    }
                }
            }
            
            $this->ajaxResponse( ( $this->errors->no() ? Errors::SUCCESS : null ) );
        }


        # SEO: Восстановление пароля
        $this->urlCorrection(static::url('forgot'));
        $this->seo()->canonicalUrl(static::url('forgot', array(), true));
        $this->setMeta('forgot', array(), $aData);

        $aData['step'] = 1;
        $aData['social'] = $this->input->get('social', TYPE_UINT);
        return $this->viewPHP($aData, 'forgot');
    }
    
    public function logout()
    {
        if( strpos(Request::referer(), 'user/') === FALSE )
            $sRedirectURL = Request::referer();
        else
            $sRedirectURL = bff::urlBase();

        if( $this->security->isLogined() && $this->security->validateReferer() ) {
            $this->security->sessionDestroy(-1, true);

            $this->forum()->onUserLogout();
        }
        
        $this->redirect($sRedirectURL);
    }
    
    public function profile()
    {
        $nUserID = User::id();
        if (!$nUserID) $this->redirect('/');

        $aData = $this->model->userData($nUserID, '*');

        if (empty($aData)) {
            $this->redirect('/');
        }
                    
        if ($aData['blocked']) {
            return $this->showForbidden(_t('users','Aккаунт заблокирован'), _t('users','Ваш аккаунт был заблокирован по причине:[br][reason]', array('reason' => $aData['blocked_reason'], 'br'=>'<br/>')));
        }
        bff::setMeta(_t('users', 'Мой кабинет'));

        $cntAdv = 0;
        if (bff::moduleExists('auto')) {
            $cntAuto = $this->security->userCounter('auto', false, $nUserID);
            $cntAdv += $cntAuto;
        }
        if (bff::moduleExists('realty')) {
            $cntRealty = $this->security->userCounter('realty', false, $nUserID);
            $cntAdv += $cntRealty;
        }
        if (bff::moduleExists('bbs')) {
            $cntBBS = $this->security->userCounter('bbs', false, $nUserID);
            $cntAdv += $cntBBS;
        }
        $cntItems = $this->security->userCounter('items', false, $nUserID);
        $cntItemsRequests = $this->security->userCounter('items_requests', false, $nUserID);

        $aTabs = array(
            'narod'   => array('a'=>false, 't'=>_t('users','Народные новости'), 'c'=>false),
            'adv'     => array('a'=>false, 't'=>_t('users','Мои объявления'), 'c'=>$cntAdv),
        );

        if (!$cntAdv) {
            unset($aTabs['adv']);
        }
        
        # объекты/заявок
        if (($cntItems+$cntItemsRequests) > 0) {
            $aTabs['items'] = array('a'=>false, 't'=>_t('users','Мои объекты'), 'c'=> (!empty($cntItemsRequests) ? $cntItems.'/'.$cntItemsRequests : $cntItems) );
        }
        if (bff::moduleExists('job')) {
            # вакансии
            $cntVacancy = $this->security->userCounter('job_vacancy', false, $nUserID);
            if($cntVacancy > 0) {
                $aTabs['vacancy'] = array('a'=>false, 't'=>_t('users','Мои вакансии'), 'c'=>$cntVacancy);
            }
            # резюме
            $cntResume = $this->security->userCounter('job_resume', false, $nUserID);
            if($cntResume > 0) {
                $aTabs['resume'] = array('a'=>false, 't'=>_t('users','Мои резюме'), 'c'=>$cntResume);
            }
        }
        
        $sTab = $this->input->get('t', TYPE_NOTAGS);
        if (!array_key_exists($sTab, $aTabs)) {
            $sTab = key($aTabs);
        }

        $narod_tab_content = Publications::i()->narod_profile($nUserID, ($sTab!='narod'));
        if ($narod_tab_content === false) {
            # нет ни одной добавленной промодерированной опубликованной народной новости
            unset($aTabs['narod']);
            if($sTab == 'narod') {
                $sTab = key($aTabs); # переключаем на следующую закладку
            }
        }

        $aData['subtabs'] = array();
        $aData['tab_content'] = '';                
        switch ($sTab)
        {
            case 'narod': 
            {
                $aData['tab_content'] = &$narod_tab_content;
            } break;
            case 'adv': 
            {
                $sSubTab = $this->input->get('st', TYPE_NOTAGS);
                $aSubTabs = array();
                if( ! empty($cntRealty)) $aSubTabs['realty'] = array('t'=>_t('users','Недвижимость'),'a'=>0);
                if( ! empty($cntAuto)) $aSubTabs['auto'] = array('t'=>_t('users','Авто'),'a'=>0);
                if( ! empty($cntBBS)) $aSubTabs['board'] = array('t'=>_t('users','Другие объявления'),'a'=>0);

                if( ! array_key_exists($sSubTab, $aSubTabs)) {
                    $sSubTab = key($aSubTabs);
                } $aSubTabs[$sSubTab]['a'] = 1;
                
                switch ($sSubTab)
                {
                    case 'board': {
                        $aData['tab_content'] = bff::module('BBS')->profile();
                    }  break;
                    case 'realty': {
                        $aData['tab_content'] = bff::module('Realty')->profile();
                    }  break;
                    case 'auto': {
                        $aData['tab_content'] = bff::module('Auto')->profile();
                    }  break;
                }
                
                $aData['subtabs'] = $aSubTabs;
                $aData['subtab'] = $sSubTab;
            } break;
            case 'items': 
            {
                $aData['tab_content'] = Items::i()->profile($cntItems, $cntItemsRequests);
            } break;
            case 'vacancy': 
            {
                $aData['tab_content'] = bff::module('Job')->vacancy_profile();
            } break;
            case 'resume':
            {
                $aData['tab_content'] = bff::module( 'Job')->resume_profile();
            } break;
        }
        
        if(isset($aTabs[$sTab])) $aTabs[$sTab]['a'] = true;
        $aData['tabs'] = &$aTabs;
        $aData['tab'] = $sTab;
        return $this->viewPHP($aData, 'profile');
    }
    
    public function profile_view()
    {
        $nUserID = $this->input->get('user_id', TYPE_UINT);
        if ( ! $nUserID) $this->redirect('/');
        
        if (User::isCurrent($nUserID)) {
            return $this->profile();
        }

        $aData = $this->model->userDataByFilter(array('user_id'=>$nUserID, 'activated'=>1), '*');
        if (empty($aData)) {
            $this->errors->error404();
        }
        
        if ($aData['blocked']) {
            return $this->showForbidden(_t('users','Aккаунт заблокирован'), _t('users','Аккаунт был заблокирован по причине:[br][reason]', array('reason' => $aData['blocked_reason'], 'br' => '<br />')));
        }

        return $this->viewPHP($aData, 'profile.view');
    }
    
    public function settings_start()
    {
        if( ! User::id()) {
            $this->redirect('/');
        }

        $aData = $this->model->userData(User::id(), array('name', 'surname',
                        'login', 'avatar', 'sex','birthdate', 'phone', 'icq', 'skype', 'city_id',
                        'subscribed', 'activated', 'blocked', 'enotify'));
        if (empty($aData) || $aData['blocked'] || ! $aData['activated']) {
            if (Request::isAJAX()) {
                $this->errors->accessDenied();
                $this->ajaxResponseForm();
            }
            return $this->showForbidden();
        }
        
        if(Request::isAJAX())
        {
            $aDataPrev = $aData;
            $aData = $this->input->postm(array(
                'login'     => array(TYPE_NOTAGS, 'len'=>100),
                'name'      => array(TYPE_NOTAGS, 'len'=>100),
                'surname'   => array(TYPE_NOTAGS, 'len'=>100),
                'city_id'   => TYPE_INT,
                'birthdate' => TYPE_ARRAY_UINT,
                'sex'       => TYPE_UINT,
                'icq'       => array(TYPE_NOTAGS, 'len'=>100),
                'skype'     => array(TYPE_NOTAGS, 'len'=>100),
                'phone'     => array(TYPE_NOTAGS, 'len'=>100),
                'enotify'   => TYPE_ARRAY_UINT,
            )); extract($aData, EXTR_REFS);

            if( ! $this->security->validateToken() ) {
                $this->errors->accessDenied();
                $this->ajaxResponseForm();
            }
            
            if($login!='') {
                if( ! $this->isLoginCorrect($login)  ) {
                    $this->errors->set( _t('users', 'Логин указан некорректно, допустимые символы: 0-9, A-z, _'), 'login' );
                } else if( $this->model->userLoginExists($login, User::id()) ) {
                    $this->errors->set( _t('users', 'Пользователь с таким логином уже зарегистрирован'), 'login' );
                }
            }

            if (empty($name)) {
                $this->errors->set(_t('users', 'Укажите ваше имя'), 'name');
            }

            if($city_id == 0) {
                $this->errors->set( _t('users', 'Укажите город'), 'city_id');
            }

            $this->cleanUserData($aData);

            if($this->errors->no())
            {
                # синхронизация с форумом
                if ($aDataPrev['login']!=$aData['login']) {
                    if( ! $this->forum()->onUserLoginChanged(User::id(), $aData['login'], $aDataPrev['login'])) {
                        $this->errors->set( _t('users', 'Пользователь с таким логином уже зарегистрирован'), 'login' );
                    }
                }
            }

            if($this->errors->no())
            {
                // уведомления
                $enotify = array_sum($enotify);

                $res = $this->model->userSave(User::id(), $aData);
                if($res) {
                    $this->security->expire();
                }
            }
            
            $this->ajaxResponseForm();
        }

        $aData['id'] = User::id();
        $aData['cities'] = Geo::cityOptions($aData['city_id'], false);
        $aData['bdate'] = $this->getBirthdateOptions($aData['birthdate']);
        $aData['enotify'] = $this->getEnotifyTypes($aData['enotify']);
        $aData = HTML::escape($aData, 'html', array('name','surname','icq','skype','phone'));
        return $this->viewPHP($aData, 'settings.start');
    }

    public function settings()
    {        
        $nUserID = User::id();
        
        if( ! $nUserID) {
            $this->redirect('/');
        }
        if( ! empty($_GET['start'])) {
            return $this->settings_start();
        }
        
        $aData = $this->model->userData($nUserID, '*');
        if (empty($aData)) {
            if (Request::isAJAX()) {
                $this->ajaxResponse(Errors::ACCESSDENIED);
            }
            return $this->showForbidden();
        }
        
        if(Request::isAJAX())
        {
            if( ! $this->security->validateToken() ) {
                $this->ajaxResponse( Errors::ACCESSDENIED );
            }
            
            $errFields = array();
            $resp = array();
            switch ($this->input->get('act'))
            {
                case 'main':
                {
                    $aParams = array(
                        'login'     => array(TYPE_NOTAGS, 'len'=>100),
                        'name'      => array(TYPE_NOTAGS, 'len'=>100),
                        'surname'   => array(TYPE_NOTAGS, 'len'=>100),
                        'city_id'   => TYPE_UINT,
                        'sex'       => TYPE_UINT,
                    );

                    if (static::profileBirthdate()) {
                        $aParams['birthdate'] = TYPE_ARRAY_UINT;
                    }

                    $p = $this->input->postm($aParams);
                    extract($p, EXTR_REFS);

                    if( empty($login) ) {
                        $this->errors->set( _t('users', 'Логин указан некорректно, допустимые символы: 0-9, A-z, _'), 'login' );
                    } else {
                        if( ! $this->isLoginCorrect($login)  ) {
                            $this->errors->set( _t('users', 'Логин указан некорректно, допустимые символы: 0-9, A-z, _'), 'login' );
                            $errFields[] = 'login';
                        }
                        if( $this->model->userLoginExists($login, $nUserID) ) {
                            $this->errors->set( _t('users', 'Пользователь с таким логином уже зарегистрирован'), 'login' );
                            $errFields[] = 'login';
                        }
                    }

                    if (empty($name)) {
                        $this->errors->set(_t('users', 'Укажите ваше имя'), 'name');
                        $errFields[] = 'name';
                    }

                    if($city_id == 0) {
                        $this->errors->set( _t('users', 'Укажите город'), 'city_id');
                    }

                    $this->cleanUserData($p);

                    if ($this->errors->no())
                    {
                        # синхронизация с форумом
                        $loginCurrent = User::data('login');
                        if ($login != $loginCurrent) {
                            if ( ! $this->forum()->onUserLoginChanged($nUserID, $login, $loginCurrent)) {
                                $this->errors->set( _t('users', 'Пользователь с таким логином уже зарегистрирован'), 'login' );
                                $errFields[] = 'login';
                            }
                        }
                    }

                    if ($this->errors->no())
                    {
                        $res = $this->model->userSave($nUserID, $p);
                        if ($res) {
                            $this->security->expire();
                        }
                    }
                    
                } break;
                case 'contacts': {
                    $p = $this->input->postm(array(
                        //'email_show' => TYPE_BOOL,
                        'icq'        => array(TYPE_NOTAGS, 'len'=>100),
                        'skype'      => array(TYPE_NOTAGS, 'len'=>100),
                        'phone'      => array(TYPE_NOTAGS, 'len'=>100),
                    )); extract($p, EXTR_REFS);

                    $this->cleanUserData($p);

                    $this->model->userSave($nUserID, $p);
                    
                } break;
                case 'social-unlink': {

                    $oSocial = $this->social();
                    $providerKey = $this->input->post('provider', TYPE_STR);
                    $providerID = $oSocial->getProviderID($providerKey);
                    if ($providerID) {
                        $res = $oSocial->unlinkSocialAccountFromUser($providerID, $nUserID);
                        if (!$res) {
                            $this->errors->reloadPage();
                        }
                    }
                } break;
                case 'enotify': {

                    $enotify = $this->input->post('enotify', TYPE_ARRAY_UINT);
                    $this->model->userSave($nUserID,
                        array('enotify'=>array_sum($enotify))
                    );

                } break;
                case 'pass': {
                    $p = $this->input->postm(array(
                        'pass1' => TYPE_NOTRIM,
                        'pass2' => TYPE_NOTRIM,
                    )); extract($p, EXTR_REFS);                     
                    
                    if (empty($pass1)) {
                        $this->errors->set( _t('users', 'Укажите пароль'), 'pass1' );
                        $errFields[] = 'pass1';
                    } elseif(strlen($pass1) < $this->passwordMinLength) {
                        $this->errors->set( _t('users', 'Пароль не должен быть короче [cnt]-ти символов', array('cnt'=>$this->passwordMinLength)), 'pass1' );
                        $errFields[] = 'pass1';
                    }
                    else {

                        $this->model->userSave($nUserID, array(
                            'password' => $this->security->getUserPasswordMD5($pass1, $aData['password_salt'])
                        ));
                    }                    
                } break;
                case 'email': # смена E-mail адреса
                {
                    $email = $this->input->post('email', TYPE_STR);
                    # нечего менять
                    if($email == $aData['email']) {
                        $this->errors->set( _t('users', 'Новый email совпадает с вашим текущим'), 'email' );
                        $errFields[] = 'email';
                        break;
                    }

                    if( ! $this->input->isEmail($email)) {
                        $this->errors->set( _t('users', 'E-mail адрес указан некорректно'), 'email' );
                        $errFields[] ='email';
                    } else if( $this->model->userEmailExists($email, $nUserID) ) {
                        $this->errors->set( _t('users', 'Пользователь с таким email-ом уже зарегистрирован'), 'email' );
                        $errFields[] = 'email';
                    } else {
                        
                        $this->getActivationInfo($sActivateCode, $sActivateLink, $sActivateExpire);

                        $res = $this->model->userSave($nUserID, array(
                            'email' => $email,
                            'activated' => 0,
                            'activate_key' => $sActivateCode,
                            'activate_expire' => $sActivateExpire
                        ));

                        if ($res) {
                            bff::sendMailTemplate(array('email'=>$email, 'activate_link'=>$sActivateLink),
                                        'member_email_confirm', $email);
                        }
                        
                        $resp['email'] = $email;
                    }                    
                } break;
            }
                 
            $resp['res']    = $this->errors->no();
            $resp['fields'] = $errFields;
            $this->ajaxResponse( $resp );
        }

        $aData['cities'] = Geo::cityOptions($aData['city_id'], false);
        if (static::profileBirthdate()) {
            $aData['bdate'] = $this->getBirthdateOptions($aData['birthdate']);
        }

        # данные о привязанных соц. аккаунтах
        $oSocial = $this->social();
        $aSocialProviders = $oSocial->getProvidersEnabled();
        $aSocialUser = $oSocial->getUserSocialAccountsData($nUserID);
        foreach ($aSocialUser as $k => $v) {
            if (isset($aSocialProviders[$k]) && strpos($v['profile_data'], 'a:') === 0) {
                $aSocialProviders[$k]['user'] = unserialize($v['profile_data']);
            }
        }
        $aData['social'] = $aSocialProviders;
        $aData['enotify'] = $this->getEnotifyTypes($aData['enotify']);
        $aData = HTML::escape($aData, 'html', array('name','surname','icq','skype','phone'));
        bff::setMeta(_t('users', 'Настройки - Кабинет'));
        return $this->viewPHP($aData, 'settings');
    }
    
    function avatar_upload()
    {
        if( ! User::id() || ! $this->security->validateReferer()) {
            echo '0'; exit;
        }

        $aResult = $this->avatar(User::id())->uploadFILES('avatar', true, true);
        if($aResult!==false) {
            $aData = $aResult;
            $aData[UsersAvatar::szNormal] = UsersAvatar::url(User::id(), $aResult['filename'], UsersAvatar::szNormal, $this->security->getUserInfo('sex'));
            $aData['success'] = 1;
            $this->security->updateUserInfo(array('avatar'=>$aResult['filename']));
        } else {
            $aData['success'] = 0;
        }

        echo $this->viewPHP($aData, 'settings.avatar.upload');
        exit;
    }
    
    private function redirectToProfile($nUserID = 0)
    {             
        if($nUserID > 0) {
            $this->redirect('/user/id'.$nUserID);
        }
        $this->redirect( static::url('my.profile') );
    }

    # ============================================================================
    # ajax
    
    function ajax()
    {
        if( ! Request::isAJAX())
            $this->ajaxResponse(Errors::IMPOSSIBLE);     

        $errFields = array();

        switch ($this->input->getpost('act'))
        {
            case 'login':
            {
                $resp = array('res'=>false, 'status'=>0, 'fields'=>array());
                
                if(User::id()) {
                    $resp['res'] = true;
                    $resp['status'] = 2; // успешная авторизация
                    $this->ajaxResponse($resp);
                }
                                        
                $p = $this->input->postm(array(
                    'login'    => TYPE_STR,    // логин или email
                    'pass'     => TYPE_NOTRIM, // пароль, оригинал
                    'remember' => TYPE_BOOL,   // запомнить меня
                    'social'   => TYPE_UINT, //флаг регистрация через соц. сеть
                ));

                do 
                {
                    $mBlocked = $this->checkBan(true);
                    if( $mBlocked ) {
                        $this->errors->set(  _t('users', 'В доступе отказано по причине:<br />[reason]', array('reason'=>$mBlocked))  );
                        break;
                    }

                    if( ! $this->isLoginOrEmail( $p['login'], $isEmail, true ) ) {
                        $this->errors->field('login');
                        $errFields[] = 'login'; 
                        break;
                    }

                    $res = $this->userAuth($p['login'], ($isEmail ? 'email' : 'login'), $p['pass'], false, true);
                    if($res === true)
                    {
                        $resp['status'] = 2; // успешная авторизация
                        if($p['remember']) {
                            $this->security->setRememberMe($this->security->getUserLogin(), $this->security->getUserPasswordMD5($p['pass']) );
                        }
                        if($p['social']){ //объединение профилей
                            $oSocial = new UsersSocial();
                            $aSocialData = $oSocial->authData();
                            if( ! empty($aSocialData)){
                                //привяжим соц. акаунт к текущему
                                $this->social()->authFinish(User::id());
                            }
                        }
                    } elseif($res === 1) {
                        $resp['status'] = 1; // необходимо активировать аккаунт
                        $aUserData = $this->prepareAjaxPreActivation( $resp );
                        // при активации через login, ситуации непривязанного email-адреса быть не может
                        // поскольку изменить login можно только в настройках аккаунта, после привязки email-адреса
                    }
                    
                } while(false);
                
                $resp['res'] = $this->errors->no();
                $resp['fields'] = $errFields;                    
                $this->ajaxResponseForm( $resp );

            } break;

            case 'register':
            {
                $resp = array('captcha'=>false);
                if($this->security->isLogined()) {
                    $resp['logined'] = true;
                    $this->ajaxResponseForm( $resp );
                }

                $aData = $this->input->postm(array(
                    'email'   => TYPE_NOTAGS,
                    'pass'    => TYPE_NOTRIM,
                    'captcha' => TYPE_STR,
                    'social'  => TYPE_UINT, # флаг регистрация через соц. сеть
                )); extract($aData);

                if ($social) {
                    $oSocial = $this->social();
                    $aSocialData = $oSocial->authData();
                    if (empty($aSocialData)){
                        $social = 0;
                    }else{
                        $pass = func::generator(8);
                    }
                }

                $this->cleanUserData($aData);

                $mBlocked = $this->checkBan(true);
                if ($mBlocked) {
                    $this->errors->set(_t('users', 'В доступе отказано по причине:<br/>[reason]', array('reason'=>$mBlocked)));
                    break;
                }
                else
                {
                    if (!$this->input->isEmail($email)) {
                        $this->errors->set( _t('users', 'E-mail адрес указан некорректно'), 'email' );
                    }
                    
                    if ($this->model->userEmailExists($email)) {
                        $this->errors->set( _t('users', 'Пользователь с таким email-ом уже зарегистрирован'), 'email' );
                    }

                    if (!$social) {
                        if (empty($pass)) {
                            $this->errors->set( _t('users', 'Укажите пароль'), 'pass' );
                        } elseif(strlen($pass) < $this->passwordMinLength) {
                            $this->errors->set( _t('users', 'Пароль не должен быть короче [cnt]-ти символов', array('cnt'=>$this->passwordMinLength)), 'pass' );
                        }

                        if (config::sys('users.register.captcha', true)) {
                            $oProtection = new CCaptchaProtection();
                            if (empty($captcha) || !$oProtection->valid($this->input->cookie('c2'), $captcha)) {
                                $this->errors->set(_t('', 'Результат с картинки указан некорректно'), 'captcha');
                                $resp['captcha'] = true;
                                Request::deleteCOOKIE('c2');
                            }
                        }
                    }
                }

                if ($this->errors->no())
                {
                    $this->getActivationInfo($sActivateCode, $sActivateLink, $sActivateExpire);
                    
                    $sPasswordSalt = $this->security->generatePasswordSalt();

                    $aCreate = array(
                        'login'          => '', # будет сгенерирован уникальный
                        'email'          => $email,
                        'password'       => $this->security->getUserPasswordMD5($pass, $sPasswordSalt),
                        'password_salt'  => $sPasswordSalt,
                        'activated'      => 0,
                        'activate_key'   => $sActivateCode,
                        'activate_expire'=> $sActivateExpire,
                        'enotify'        => $this->getEnotifyTypes(0,true), # подписываем на рассылку
                    );
                    if($social){
                        if( ! empty($aSocialData['firstName'])) $aCreate['name'] = $aSocialData['firstName'];
                        if( ! empty($aSocialData['lastName'])) $aCreate['surname'] = $aSocialData['lastName'];
                    }

                    $nUserID = $this->model->userCreate($aCreate, self::GROUPID_MEMBER);

                    if ($nUserID)
                    {
                        if ($social) {
                            # Загружаем аватар из соц. сети
                            if (!empty($aSocialData['avatar'])) {
                                $this->avatar($nUserID)->uploadSocial($aSocialData['provider_id'], $aSocialData['avatar'], true);
                            }
                            # Закрепляем соц. аккаунт за пользователем
                            $this->social()->authFinish($nUserID);
                        }

                        # Добавляем возможность получить повторное email-уведомление
                        $this->setRegisterSecondEnotifyFlag($nUserID);
                        
                        bff::sendMailTemplate(
                            array('password'=>$pass, 'email'=>$aData['email'], 'activate_link'=>$sActivateLink),
                            'member_registration', $aData['email']);

                        # Синхронизация с форумом
                        $aUserData = $this->model->userData($nUserID, array('login', 'email'));
                        if ( ! empty($aUserData)) {
                            $this->forum()->onUserRegister($nUserID, $aUserData['login'], $aUserData['email'], $pass);
                        }

                    } else {
                        $this->errors->set( _t('users', 'Ошибка регистрации, обновите страницу и повторите попытку') );
                    }
                }

                $this->ajaxResponseForm($resp);
            } break;

            /**
             * Шаг Авторизации, в случае если e-mail пользователя неактивирован,
             *  cпрашиваем, правильно ли он указал его(e-mail), меняем, если необходимо и
             *  отправляем письмо со ссылкой активации.
             */
            case 'register-confirm':
            {
                $resp = array('res'=>false,'redirect'=>false,'fields'=>array());
                
                $p = $this->input->postm(array(
                    'uid'    => TYPE_UINT,
                    'email'  => TYPE_STR,
                    'hash'   => TYPE_STR,
                ));
                
                $nUserID = $p['uid'];
                $sEmail = $p['email'];

                // проверка последовательности подтверждения пароля
                if( ! $nUserID || empty($p['hash']) || ! $this->setPreAtivationFlag($nUserID, $p['hash'], true)) {
                    $this->errors->set( _t('users', 'Произошла ошибка, повторите попытку через несколько минут') );
                } else {
                    if( ! $this->input->isEmail($sEmail)) {
                        $this->errors->set( _t('users', 'E-mail адрес указан некорректно'), 'email' );
                        $errFields[] = 'email';
                    } else if( $this->model->userEmailExists($sEmail, $nUserID) ) {
                        $this->errors->set( _t('users', 'Пользователь с таким email-ом уже зарегистрирован'), 'email' );
                        $errFields[] = 'email';
                    }
                }
                
                if( strpos(Request::referer(), '/user/')!==false) {
                    // уводим со страницы авторизации/регистрации на главную
                    $resp['redirect'] = true;
                }
                
                if($this->errors->no())
                {
                    $this->getActivationInfo($sActivateCode, $sActivateLink, $sActivateExpire);

                    $res = $this->model->userSave($nUserID, array(
                        'email'=>$sEmail,
                        'activated'=>0,
                        'activate_key'=>$sActivateCode,
                        'activate_expire'=>$sActivateExpire
                    ));

                    if($res)
                    {
                        $res = bff::sendMailTemplate(array('email'=>$sEmail, 'activate_link'=>$sActivateLink), 
                                    'member_email_confirm', $sEmail);
                    }
                    
                    if( ! $res) {
                        $this->errors->set( _t('users', 'Произошла ошибка, повторите попытку через несколько минут') );
                    } else {
                        // сбрасываем последовательность подтверждения пароля
                        $this->setPreAtivationFlag($nUserID, -1);
                    }
                }
                
                $resp['res'] = $this->errors->no();                    
                $resp['fields'] = $errFields;
                $this->ajaxResponse( $resp );
            } break;
            
            /**
             * ?
             */
            case 'register-email2':
            {
                $nUserID = $this->setRegisterSecondEnotifyFlag(0, true);
                if (empty($nUserID))
                    $this->ajaxResponse(Errors::SUCCESS);

                $aData = $this->model->userData($nUserID,
                    array('user_id', 'email', 'activate_key as code', 'activated', 'blocked'));

                if (empty($aData) || $aData['blocked'] || ! $this->input->isEmail($aData['email'], false)) {
                    $this->ajaxResponse(Errors::IMPOSSIBLE);
                } elseif($aData['activated']) {
                    $this->setRegisterSecondEnotifyFlag(-1);
                    $this->ajaxResponse(Errors::SUCCESS);
                }
                
                $this->getActivationInfo($aData['code'], $sActivateLink, $sActivateExpire);
                
                $res = bff::sendMailTemplate(array('email'=>$aData['email'], 'activate_link'=>$sActivateLink), 
                    'member_email_confirm', $aData['email']);
                   
                if($res) {
                    $this->setRegisterSecondEnotifyFlag(-1);
                }
                   
                $this->ajaxResponse( ( $res ? Errors::SUCCESS : Errors::IMPOSSIBLE ) );
                
            } break;
            case 'company_contacts':
            {
                $aResponse = array();
                do {
                    if( ! User::id()) break;
                    $nCompanyID = $this->input->post('company_id', TYPE_UINT);
                    if( ! $nCompanyID) break;

                    $aData = $this->model->companyInfo(User::id(), $nCompanyID);
                    $aResponse['contacts'] = $aData;
                } while(false);

                $aResponse['res'] = $this->errors->no();
                $this->ajaxResponse($aResponse);
            } break;

        }
        
        $this->ajaxResponse(Errors::IMPOSSIBLE);
    }

    function _lastvisit($sDatetime)
    {
        //get datetime
        if (empty($sDatetime) || $sDatetime == '0000-00-00 00:00:00') return '?';
        $date = Func::parse_datetime($sDatetime);
       
        //get now datetime 
        $now = date('Y,m,d,H,i,s');
               
        $nowdt = array();
        list($nowdt['year'],$nowdt['month'],$nowdt['day'],$nowdt['hour'],$nowdt['min'],$nowdt['sec']) = explode(',', $now);

        //дата позже текущей
        if($nowdt['year'] < $date['year'])
            return '';
                          
        //since
        $since = array();
        foreach($nowdt as $k=>$v)
            $since[$k] = $nowdt[$k] - $date[$k];
            
        $tmp = array(0=>array('sec',60,_t('','секунда;секунды;секунд')),1=>array('min',60,_t('','минута;минуты;минут')),2=>array('hour',24,_t('','час;часа;часов')),
                     3=>array('day',30,_t('','день;дня;дней')),4=>array('month',12,_t('','месяц;месяца;месяцев')),5=>array('year',0,_t('','год;года;лет')));

        $minus = false;
        
        //seconds    
        if ($minus) {
            $nowdt['sec']--;
            if ($nowdt['sec'] == $date['sec']) {
                $since['sec'] = $nowdt['sec'] - $date['sec'];
            }
        }
        $minus = false;
        if ($nowdt['sec'] < $date['sec']) {
            $since['sec'] =  60 + $nowdt['sec'] - $date['sec'];
            $minus = true;
        }
        //minutes    
        if ($minus) {
            $nowdt['min']--;
            if ($nowdt['min'] == $date['min']) {
                $since['min'] = $nowdt['min'] - $date['min'];
            } else $since['min']--;
        }
        $minus = false;
        if ($nowdt['min'] < $date['min']) {
            $since['min'] =  (60 + $nowdt['min']) - $date['min'];
            $minus = true;
        }
        //hours --------------------------------------  
        if ($minus) {
            $nowdt['hour']--;
            if ($nowdt['hour'] == $date['hour']) {
                $since['hour'] = $nowdt['hour'] - $date['hour'];
            } 
        }
        $minus = false;
        if ($nowdt['hour'] < $date['hour']) {
            $since['hour'] =  (24 + $nowdt['hour']) - $date['hour'];
            $minus = true;
        }
        //days --------------------------------------- 
        if ($minus) {
            $nowdt['day']--; 
            if ($nowdt['day'] == $date['day']) {
                $since['day'] = $nowdt['day'] - $date['day'];
            } else $since['day']--;
        }
        $minus = false;
        if ($nowdt['day'] < $date['day']) {
            $since['day'] =  (30 + $nowdt['day']) - $date['day'];
            $minus = true;
        }
        //months -------------------------------------  
        if ($minus) {
            $nowdt['month']--;
            if ($nowdt['month'] == $date['month']) {
                $since['month'] = $nowdt['month'] - $date['month'];
            }
        }
        $minus = false;
        if ($nowdt['month'] < $date['month']) {
            $since['month'] =  30 + $nowdt['month'] - $date['month'];
            $minus = true;
        }
        //years   
        if ($minus) {
            $nowdt['year']--;
            if ($nowdt['year'] == $date['year']) {
                $since['year'] = $nowdt['year'] - $date['year'];
            }
        }
        $minus = false;
        if ($nowdt['year'] < $date['year']) {
            $since['year'] =  0 + $nowdt['year'] - $date['year'];
            $minus = true;
        }

        $sResult = '';
        do{
            //разница в год и более (5лет [5месяцев])
            if($since['year'])
            {
                $sResult .= $since['year'].' '.tpl::declension($since['year'],$tmp[5][2], false);
                if($since['month'])
                    $sResult .= ' '.$since['month'].' '.tpl::declension($since['month'],$tmp[4][2], false);
                break;
            }
            //разница в месяц и больше (5месяцев [5дней])
            if($since['month'])
            {
                $sResult .= $since['month'].' '.tpl::declension($since['month'],$tmp[4][2], false);
                if($since['day'])
                    $sResult .= ' '.$since['day'].' '.tpl::declension($since['day'],$tmp[3][2], false);
                break;
            }
            //разница в день и больше  (5дней [5часов] [5минут])
            if($since['day'])
            {
                $sResult .= $since['day'].' '.tpl::declension($since['day'],$tmp[3][2], false);
                if($since['hour']>0) {
                    $sResult .= ' '.$since['hour'].' '.tpl::declension($since['hour'],$tmp[2][2], false);    
                    
                    //if($since['min'])
                    //    $sResult .= ' '.$since['min'].' '.tpl::declension($since['min'],$tmp[1][2], false);
                }
                break;
            }        
            //разница в час и больше  (5часов [5минут])
            if($since['hour'])
            {
                $sResult .= $since['hour'].' '.tpl::declension($since['hour'],$tmp[2][2], false);
                if($since['min']) {
                     $sResult .= ' '.$since['min'].' '.tpl::declension($since['min'],$tmp[1][2], false);
                }
                break;
            }

            //разница в минуту и меньше (5минут 5секунд)
            if($since['min']>3) 
                $sResult = $since['min'].' '.tpl::declension($since['min'],$tmp[1][2], false);
            else
                $sResult = _t('','сейчас');
            
        }while(false);    
        return $sResult;
    }
    
    function _years_since_birthday($sBirthdate)
    {
        $birth = func::parse_datetime($sBirthdate);
        $birthYear = ( ! empty($birth) ? intval($birth['year']) : 0 );
        if(!$birthYear) {
            return '';
        } else {
            $now = time();
            $curYear = date('Y');             
            $years = ($curYear - $birthYear);
            if(mktime(0,0,0,$birth['month'],$birth['day'],$curYear) > $now)
                $years -= 1;
            return tpl::declension($years, explode(';', _t('','год;года;лет')), true);
        }
    }
    
    public function cron()
    {
        if( ! bff::cron() ) return;



        # удаляем неактивированные аккаунты с просроченным периодом активации
        $this->db->exec('DELETE U.*, US.* FROM '.TABLE_USERS.' U, '.TABLE_USERS_STAT.' US
            WHERE U.activated = 0 AND U.activate_expire < '.$this->db->getNOW().'
                AND U.user_id = US.user_id
                AND US.last_login = '.$this->db->str2sql('0000-00-00 00:00:00').'
        ');


    }

}
