<?php

# выключение сайта (offline)
if (!intval(config::get('enabled', 0)) && !Site::offlineIgnore()) {
    Site::i()->setMeta('index');
    $aData = array(); echo View::renderTemplate($aData, 'offline');
    bff::shutdown();
}



# remember me
if (!bff::$isBot) {
    bff::security()->checkRememberMe();
}

$templateData = array();
$mainRouting = true;

# subdomains routing
if (bff::$class == 2 ||
   preg_match('/^(?<subdomain>.*)\.'.preg_quote(SITEHOST).'/', Request::host(), $matches) === 1)
{
    $sDomain = ( ! empty($_GET['d']) ? strtolower( trim(strval($_GET['d'])) ) : ( isset($matches['subdomain']) ? $matches['subdomain'] : $_GET['d'] ) );
    if (strpos($sDomain, '.')) { # {city}.{module}
        list(,$sDomain) = explode('.', $sDomain, 2);
    }
    $aDomain2Module = array('map'=>'items','board'=>'bbs','afisha'=>'afisha','job'=>'job','realty'=>'realty','auto'=>'auto');
    if (isset($aDomain2Module[$sDomain])) {
        $mainRouting = false;
        if (!bff::subdomainsEnabled($aDomain2Module[$sDomain])) {
            bff::errors()->error404();
        }
        $templateData['centerblock'] = bff::module( bff::$class = $aDomain2Module[$sDomain] )->route();
        if ($templateData['centerblock'] === NULL) {
            bff::errors()->error404();
        }
    }
}

# main routing
if ($mainRouting)
{
    if( ! bff::$class) {
        bff::route(array(
            # index
            '' => 'site/index/', # главная страница
            # publications
            '(news|articles|reports|narod|video|company)/'    => 'publications/$1:listing_all/',
            '(news|articles|reports|narod|video|company)/rss' => 'publications/$1:rss/',
            '(news|articles|reports|narod|video)/(.*)/(.*)\-([\d]+)\.html' => 'publications/$1:view/category=$2&item=$4',
            'company/(.*)\-([\d]+)\.html' => 'publications/company:view/item=$2',
            '(video|company|narod)/submit/'  => 'publications/$1_submit/',
            'news/date(.*)/' => 'publications/listing_date/date=$1',
            '(narod|video)/add.html' => 'publications/$1_submit/',
            '(news|articles|reports|narod|video)/(.*)/' => 'publications/$1:listing_category/category=$2',
            # subdomain modules
            '(auto|afisha|job|realty)/(.*)' => '$1/route/',
            '(board)/(.*)'   => 'bbs/route/',
            '(map)/(.*)'     => 'items/route/',
            # common
            'search(.*)'     => 'site/search_yandex/',
            'services/(news|sitemap|voting)(.*)' => 'services/$1/',
            'business/(banks|rates)(.*)' => 'business/$1/',
            'tv(.*)'         => 'services/tv_route/',
            'weather(.*)'    => 'services/weather/',
            'away/(.*)'      => 'site/away/',
            # bill
            'bill/process/(.*)' => 'bills/processPayRequest/psystem=$1',
            'bill/(balance|history|success|fail)' => 'bills/$1/',
            # users
            'user/id(\d+)(/|)'      => 'users/profile_view/user_id=$1',
            'user/loginsocial/(.*)' => 'users/loginSocial/provider=$1',
            'user/(.*)'             => 'users/$1/',
            # banners
            'bn/(click|show)/(.*)'  => 'banners/$1/id=$2',
            # pages
            '([a-z0-9\-]+)\.html'   => 'site/pageView/page=$1',
        ), true);
    }

    try {
        $templateData['centerblock'] = bff::i()->callModule(bff::$class.'_'.bff::$event);
    } catch(\Exception $e){
        bff::errors()->set($e->getMessage().', '.$e->getFile().' ['.$e->getCode().']', true);
        bff::errors()->error404();
    }
}

$templateData['menu'] = Sitemap::i()->getMenu();
$templateData['counters'] = Site::i()->getCounters();
return $templateData;