<?php

  tpl::includeJS(array('qquploader', 'fancybox'), true);
  $aPriceParams = $this->getPriceParams();
  $userID = User::id();
  
  if ($userID) {
      $user = User::data(array('name','surname','email','phone'));
      if (empty($user_name))  $user_name  = $user['name'].' '.$user['surname'];
      if (empty($user_email)) $user_email = $user['email'];
      if (empty($user_phone)) $user_phone = $user['phone'];
  }
?>


<script type="text/javascript">
        <? js::start(); ?>
        var autoForm = (function(){
            var $models, models = {};
            var $marks, cats = {};
            var $form, $err, $progress, $errUser, $captcha, $dp;
            var $priceCurr, $priceCurrSel, $priceParams;
            var company = {};

            function init() {
                $form = $('#auto-form');
                $err = $('#auto-error'); 
                $progress = $('#auto-progress', $form);
                $errUser = $('#auto-error-user');
                $form.submit(function(){
                    app.fieldError([this.price, this.city_id, this.user_name, this.user_email, this.user_phone, this.captcha], false);
                    var error = false;
                    var namesOut = {}; 
                    var inputs = $('input.req:visible, select.req:visible', this);
                    inputs.each(function() {
                        var i = $(this);
                        if(i.is(':radio,:checkbox')) {
                            var name = i.attr('name');
                            if(namesOut[name]) return;
                            namesOut[name] = 1;
                            if( !inputs.filter('[name="'+name+'"]:checked').length ) {
                                error = true; return false;
                            }
                            return;
                        }
                        var val = i.val();
                        if( val == 0 || val === undefined || $.trim(val) == '' || val == i.attr('placeholder')) {
                            error = true; return false;
                        }
                    });     
                    
                    $err.prev().hide();
                    if(error) {
                        app.showError($err, '<?= _t('', 'Заполните все необходимые поля'); ?>', false, true);
                    } else {
                        bff.ajax('<?= Auto::url('add') ?>', $form.serialize(), function(data, errors) {
                            if(data && data.success) {
                                bff.redirect('<?= Auto::url('add') ?>?finish='+data.user+'&id='+data.id);
                            } else {
                                data.user = intval(data.user);
                                var noUser = ( ! data.user || data.user<=0);
                                if(noUser) {
                                    if(data.user == -1) { // exists
                                        autoForm.onMember(true);
                                    }
                                } else {
                                    $errUser.html('').hide();
                                }
                                app.showError( (noUser ? $errUser : $err), errors, false, true);
                                if(data.fields) app.fieldErrorForm(data.fields, $form.get(0));
                                if(data.captcha) $captcha.trigger('click');
                            }
                        }, $progress); 
                    }
                    
                    return false;
                });
                
                $priceParams  = $('#auto-price-params label', $form);
                $priceCurr    = $('#auto-price-curr', $form);
                $priceCurrSel = $('#auto-price-curr-sel li', $form);
                $dp           = $('#auto-dynprops', $form);
                $marks        = $('#auto-marks', $form);
                $models       = $('#auto-models', $form);
                $captcha      = $('#auto-captcha', $form);
            }

            function setCompanyContacts(id)
            {
                var form = $form.get(0);
                var c = ( id === 0 ? {addr:'',phone:'<?= $user_phone ?>',email:'<?= $user_email ?>',city:0} : company[id]);
                form.user_phone.value = c.phone;
                form.user_email.value = c.email;
            }

            $(function(){ init(); });
            return { 
                onCat: function(id, sel)
                {
                    if( ! id) {
                        $marks.html('<option value="0"><?= _t('', 'Выберите тип'); ?></option>');
                        $models.hide().html('<option value="0"><?= _t('', 'Выберите марку'); ?></option>');
                        $dp.html('');
                    }
                    else if(cats[id] !== undefined) {
                        $marks.html(cats[id].marks);
                        $dp.html( cats[id].dp ).show();
                        $models.hide().html('<option value="0"><?= _t('', 'Выберите марку'); ?></option>');
                    }
                    else {
                        bff.ajax('<?= bff::urlAjax('auto','cat-data') ?>', {cat:id,form:1}, function(data){
                            if(data) {
                                cats[id] = {marks: data.marks, dp: data.dp};
                                $marks.html( cats[id].marks );
                                $dp.html( cats[id].dp );
                                $models.hide().html('<option value="0">Выберите марку</option>');
                            }
                        });
                    }
                },
                onMark: function(id, sel)
                {
                    if( ! id) $models.html('<option value="0"><?= _t('', 'все модели'); ?></option>').hide();
                    else if(models[id] !== undefined) $models.html(models[id]).show();
                    else {
                        bff.ajax('<?= bff::urlAjax('auto','models-options') ?>', {mark: id, form:1}, function(data){
                            if(data) {
                                $models.html( (models[id] = data.models) ).show();
                            }
                        });
                    }
                }, 
                onCurr: function(id, a)
                {
                    id = intval(id);
                    if(id<=0) return false;
                    var activeClass = 'active';
                    $priceCurr.val(id);
                    $priceCurrSel.removeClass( activeClass );
                    $priceCurrSel.find(a).parent().addClass( activeClass );
                    return false;
                }, 
                onMember: function(setMember)
                {
                    if(setMember) {
                        $('#auto-captcha-block', $form).hide();
                        $('#auto-member-check', $form).prop('checked', true);
                        if( $('#auto-member', $form).show() ) {
                            $('#auto-member-pass', $form).focus();
                        }
                    } else {
                        $('#auto-captcha-block', $form).toggle();
                        if( $('#auto-member', $form).toggle().is(':visible') ) {
                            $('#auto-member-pass', $form).focus();
                        }
                    }
                },
                userType: function(id){
                    id = intval(id);
                    if(id == 2){
                        var $c = $form.find('[name="company_id"]');
                        $c.closest('tr').show();
                        $c.trigger('change');
                    }else{
                        $form.find('[name="company_id"]').closest('tr').hide();
                        setCompanyContacts(0);
                    }
                },
                onCompany: function(sel)
                {
                    sel = $(sel);
                    var id = intval(sel.val());
                    if( ! id) setCompanyContacts(0);

                    if(company.hasOwnProperty(id)) {
                        setCompanyContacts( id );
                    }else{
                        bff.ajax('<?= bff::urlAjax('users','company_contacts') ?>', {company_id: id}, function(data){
                            if(data && data.res) {
                                company[ id ] = data.contacts;
                                setCompanyContacts( id );
                            }
                        });
                    }
                }

            };
        }());

        var autoPhotos = (function()
        {
            var uploader, url = '<?= bff::urlAjax('auto','') ?>', path = '<?= $this->initImages()->getUrl() ?>';
            var $form, $block, $progress;
            var itemID = 0;

            $(function(){

                $form     = $('#auto-form');
                $block    = $('#auto-photos-list', $form);
                $progress = $('#auto-photos-progress', $form);

                // init uploader
                uploader = new qq.FileUploaderBasic({
                    button: $('#auto-photos-upload', $form).get(0),
                    action: url+'item-img-upload&id='+itemID,
                    limit: <?= Auto::imagesLimit() ?>,
                    uploaded: 0,
                    multiple: true,
                    onSubmit: function(id, fileName) {
                        $progress.show();
                    },
                    onComplete: function(id, fileName, data) {
                        if(data && data.success) {
                            $block.append('<div class="item">\
                                <input type="hidden" name="filename[]" value="'+data.filename+'" />\
                                <a href="'+path+itemID+data.filename+'" target="_blank" rel="auto_photos"><img src="'+path+itemID+'s'+data.filename+'" alt=""></a>\
                                <a href="#" class="del" rel="'+data.filename+'"><?= _t('', 'Удалить'); ?></a>\
                            </div>');
                            $('a[rel="auto_photos"]', $block).fancybox();
                        } else {
                            if(data.errors) {
                                app.showError($('#auto-error'), data.errors, false);
                            }
                        }
                        if( ! uploader.getInProgress()) {
                            $progress.hide();
                        }
                        return true;
                    }
                });

                $block.delegate('div a.del', 'click', function(e){
                    nothing(e);
                    var lnk = $(this);
                    if(confirm('<?= _t('', 'Удалить фото?'); ?>')) {
                        var fn = lnk.attr('rel');
                        bff.ajax(url+'item-img-delete', {filename: [fn], id: itemID}, function(data) {
                            if(data) {
                                lnk.parent().remove();
                                uploader.decrementUploaded();
                            }
                        });
                    } return false;
                });

                var lostProcessed = false;
                $(window).bind('beforeunload', function(){
                    if( ! lostProcessed) {
                        var $fn = $block.find('a.del');
                        if($fn.length > 0) {
                            lostProcessed = true;
                            var fn = []; $fn.each(function(){ fn.push($(this).attr('rel')); });
                            bff.ajax(url+'item-img-delete',{id:itemID,filename:fn},function(){},false,{async:false});
                        }
                    }
                });
            });

            return {};

        }());
        <? js::stop(); ?>
    </script>
<div class="h1-wrap">
    <h1><?= ( ! empty($titleh1) ? $titleh1 : _t('auto', 'Продать автомобиль') ); ?></h1>
</div>
<div class="realty mt20">
    <ul class="form-ch">
        <li><?= _t('', 'Поля, отмеченные звездочкой[span], обязательны к заполнению.', array(
                'span' => '<span class="z-att">*</span>',
            )); ?></li>
     </ul>
    <div style="display: none;" id="auto-error" class="error mb20"></div>
    <div class="form-box">
        <form id="auto-form">
        <input type="hidden" name="hash" value="<?= $hash ?>" />
        <table width="100%">
        <tr><td colspan="2"><h3><?= _t('auto', 'Информация об автомобиле'); ?></h3></td></tr>
        <tr>
            <td class="td1"><?= _t('', 'Тип'); ?><span class="z-att">*</span></td>
            <td>
                <select class="inp-w2 req" name="cat_id" onchange="autoForm.onCat(intval(this.value), this);">
                    <? $sel = false; $sel_gr = false;
                    foreach($cats as $v) {
                        if($v['node']>1) {
                            if($sel_gr){ ?></optgroup>
                            <? } $sel_gr = true; ?>
                            <optgroup label="<?= $v['title'] ?>">
                        <? } else { ?>
                            <option value="<?= $v['id'] ?>"<? if($v['id']==$cat_id){ ?> selected="selected"<? $sel = true; } ?>><?= $v['title'] ?></option>
                        <? }
                    } if($sel_gr){ ?></optgroup><? } unset($sel, $sel_gr); ?>
                </select>
            </td>
        </tr>
        <tr>
            <td class="td1"><?= _t('', 'Марка'); ?><span class="z-att">*</span></td>
            <td><select class="inp-w2 req" id="auto-marks" name="mark_id" onchange="autoForm.onMark(intval(this.value), this);"><?= $marks ?></select> <select class="inp-w2 req" style="display: none;" name="model_id" id="auto-models"><?= $models ?></select></td>
        </tr>
        <tbody id="auto-dynprops"><?= $dp ?></tbody>
        <tr>
            <td class="td1"><?= _t('', 'Фотографии'); ?></td>
            <td>
                <p class="inform-att f12"><?= _t('', 'Вы можете загрузить не более 8ми фотографий в формате JPG или PNG, объемом не более 3MB'); ?> &nbsp;<span class="progress" id="auto-photos-progress" style="display:none;"></span><i></i></p>
                <div class="photos-edit mt15">
                    <div id="auto-photos-list">
                    </div>
                    <br class="clear" />
                    <div id="auto-photos-upload" style="height: 20px; width: 160px"><a href="javascript:void(0);" class="ajax"><?= _t('', 'Загрузить фотографии'); ?></a></div>

                </div>
                <br />
            </td>
        </tr>
        <tr>
            <td class="td1"><?= _t('', 'Дополнительная информация'); ?></td>
            <td>
                <div class="textarea"><textarea rows="7" cols="25" name="info"><?= $info ?></textarea><i></i></div>
            </td>
        </tr>
        <tr>
            <td class="td1"><?= _t('', 'Цена'); ?><span class="z-att">*</span></td>
            <td>
                 <p class="inform-att f12 mb20"><?= _t('', 'Укажите только цифры, без сокращений. Например: 2000000'); ?><i></i></p>
                <br />
                 <div class="inp inp-w2"><input type="text" name="price" class="req" id="auto-price" value="<?= $price ?>" pattern="[0-9]*" /><i></i></div>
                 <span id="auto-price-params">
                     <?
                        foreach($aPriceParams as $ppKey=>$ppTitle) {
                            ?><label class="f12" data-pparam="<?= $ppKey ?>"><input type="checkbox" name="price_params[]" <?= ($price_params & $ppKey ? ' checked="checked"' : '') ?> value="<?= $ppKey ?>" class="checkbox" /> <?= $ppTitle ?></label><?
                        }
                     ?>
                 </span>
                 <input type="hidden" name="price_curr" id="auto-price-curr" value="<?= $price_curr ?>" />
                 <ul class="val-sp" id="auto-price-curr-sel">
                    <? foreach($curr as $v){ ?>
                        <li <?= ($v['a']?' class="active"':'') ?>><a href="#" onclick="return autoForm.onCurr(<?= $v['id'] ?>, this);"><?= $v['title_short'] ?></a></li>
                    <? } ?>
                 </ul>
            </td>
        </tr>
        <tr>
            <td colspan="2"><div class="separatornobr"></div></td>
        </tr>
        <tr><td colspan="2"><br /><h3><?= _t('', 'Контакты'); ?></h3><div style="margin-bottom:20px; display: none;" id="auto-error-user" class="error"></div></td></tr>
        <? if(! empty($agentCompanies)): ?>
        <tr>
            <td class="td1"><?= _t('bbs', 'Кто вы?:') ?><span class="z-att">*</span></td>
            <td>
                <label><input type="radio" name="user_type" value="1" onchange="autoForm.userType(1);" <?= $user_type == 1 ? 'checked="checked"' : '' ?>><?= _t('', 'Частное лицо') ?></label>&nbsp;&nbsp;&nbsp;
                <label><input type="radio" name="user_type" value="2" onchange="autoForm.userType(2);" <?= $user_type == 2 ? 'checked="checked"' : '' ?>><?= _t('', 'Компания') ?></label>
            </td>
        </tr>
        <tr<?= $user_type == 1 ? ' class="displaynone"' : '' ?>>
            <td class="td1"><?= _t('', 'Компания:'); ?></td>
            <td>
                <select class="inp-w2" name="company_id" onchange="autoForm.onCompany(this);"><? foreach($agentCompanies as $c):?><option value="<?= $c['id'] ?>" <?= $company_id == $c['id'] ? ' selected="selected" ' : '' ?>><?= $c['title'] ?></option><? endforeach; ?></select>
            </td>
        </tr>
        <? endif; ?>

        <tr>
            <td class="td1"><?= _t('', 'Ваш город'); ?><span class="z-att">*</span></td>
            <td>
                <?= Geo::cityOptionsSelect($city_id, true, 'city_id', array('class'=>'inp-w2 req')); ?>
            </td>
        </tr>
        <tr>
            <td class="td1"><?= _t('', 'Ваше имя'); ?><span class="z-att">*</span></td>
            <td><div class="inp inp-w3"><input type="text" name="user_name" value="<?= HTML::escape($user_name) ?>" maxlength="80" /><i></i></div></td>
        </tr>
        <tr>
            <td class="td1"><?= _t('', 'Телефон'); ?><span class="z-att">*</span></td>
            <td><div class="inp inp-w3"><input type="tel" name="user_phone" value="<?= HTML::escape($user_phone) ?>" maxlength="80" /><i></i></div></td>
        </tr>
        <tr>
            <td class="td1"><?= _t('', 'Email'); ?><? if( ! $userID) { ?><span class="z-att">*</span><? } ?></td>
            <td><div class="inp inp-w3"><input type="text" name="user_email" value="<?= HTML::escape($user_email) ?>" maxlength="80" /><i></i></div></td>
        </tr>
        <? if( ! $userID) { ?>
        <tr>
            <td class="td1"></td>
            <td><div class="form-ch-sp2">
                    <p><label><input type="checkbox" name="member" onclick="autoForm.onMember();" id="auto-member-check" class="checkbox" /> Я уже зарегистрирован на <?= config::sys('site.title') ?></label></p>
                </div>
            </td>
        </tr>
        <tr id="auto-member" style="display: none;">
            <td class="td1"><?= _t('', 'Введите ваш пароль'); ?><span class="z-att">*</span></td>
            <td><div class="inp inp-w3"><input type="text" name="pass" id="auto-member-pass" autocapitalize="off" /><i></i></div></td>
        </tr>
        <tr id="auto-captcha-block">
            <? $urlCaptcha = tpl::captchaURL(); ?>
            <td class="td1"><?= _t('', 'Введите код с картинки'); ?><span class="z-att">*</span></td>
            <td><img title="<?= _t('', 'обновить'); ?>" alt="<?= _t('', 'код'); ?>" src="<?= $urlCaptcha ?>" id="auto-captcha" onclick="$(this).attr('src', '<?= $urlCaptcha ?>&r='+Math.random(1));" class="capth" style="cursor: pointer;" /> <div class="inp inp-w4"><input type="text" name="captcha" pattern="[0-9]*" /><i></i></div></td>
        </tr>
        <? } ?>
        <tr>
            <td colspan="2"><div class="separatornobr"></div></td>
        </tr>
        <tr>
            <td><br /><h3><?= _t('', 'Период публикации'); ?></h3></td>
            <td>
                <script type="text/javascript">
                <? js::start(); ?>
                <?  $periods = $this->getPublicatePeriods();  ?>
                var autoPublicatePeriods = <?= func::php2js( $periods['dates'] );  ?>;
                <? js::stop(); ?>
                </script>
                <br />
                <select name="period" style="margin-right: 20px;" onchange="$('#auto-publicated-till').html( autoPublicatePeriods[this.value] );">
                    <?= $periods['options']; ?>
                </select>
                <span><?= _t('', 'с'); ?> <?= date('d.m.Y'); ?> <?= _t('', 'по'); ?> <b id="auto-publicated-till"><?= $periods['dates'][1]; ?></b></span>
            </td>
        </tr>
        <tr>
            <td></td>
            <td>
                <div class="btn mr10 left"><input type="submit" value="<?= _t('', 'добавить объявление'); ?>" /><i></i></div>
                <div class="progress" id="auto-progress" style="display: none; margin-top: 9px;"></div>
            </td>
        </tr>
        </table>
        <div class="separator"></div>
        </form>
    </div>
</div>