<?php use bff\db\Dynprops;

$prefix = (isset($aData['prefix'])?$aData['prefix']:'d');
$prefixChildID = 'dp';

if (empty($aData['dynprops'])) return;

$lng_no = _t('dp', 'Нет');
$lng_yes = _t('dp', 'Да');

$sChildFormTemplate = 'form.child';
$sChildFormTemplatePath = false;

foreach($aData['dynprops'] as $d)
{
    $name = $prefix.'['.$d[$this->ownerColumn].']'.'['.$d['id'].']';
    $name_child = $prefix.'['.$d[$this->ownerColumn].']';
    $title = $d['title'] . ($d['req']?'<span class="z-att">*</span>':'');
    $extraClass = ($d['req']?'req':'');

    echo '<tr>
            <td class="td1">'.$title.'</td>
            <td class="f12">';

    switch ($d['type'])
    {
         case Dynprops::typeRadioGroup:
        {
            $value = (isset($d['value']) && $d['value'] ? $d['value'] : $d['default_value']);
            if( ! empty( $d['group_one_row'] ) )
            {
                foreach($d['multi'] as $dm) {
                   echo '<label><input type="radio" name="'.$name.'" class="'.$extraClass.'" value="'.$dm['value'].'" '.($value == $dm['value'] ? 'checked="checked"' : '').'/> '.$dm['name'].'</label>&nbsp;';
                }
            } else {
                echo $this->formCols($d['multi'], $value, create_function('$k,$dm,$value', '
                    return \'<li><label><input type="radio" name="'.$name.'" class="'.$extraClass.'" value="\'.$dm[\'value\'].\'" \'.($value == $dm[\'value\']?\' checked="checked"\':\'\').\' /> \'.$dm[\'name\'].\'</label></li>\';'),
                    array('style'=>'margin-right: 7px;'));
            }
        }break;
        case Dynprops::typeRadioYesNo:
        {
            $value = (isset($d['value'])? $d['value'] : $d['default_value']);
            echo '<label><input type="radio" name="'.$name.'" class="'.$extraClass.'" value="2" '.($value == 2?'checked="checked"':'').' /> '.$lng_yes.'</label>&nbsp;
                  <label><input type="radio" name="'.$name.'" class="'.$extraClass.'" value="1" '.($value == 1?'checked="checked"':'').' /> '.$lng_no.'</label>';
        }break;
        case Dynprops::typeCheckboxGroup:
        {
            $value = ( isset($d['value']) && $d['value'] ? explode(';', $d['value']) : explode(';', $d['default_value']) );

            if( ! empty( $d['group_one_row']) )
            {
                foreach($d['multi'] as $dm) {
                   echo '<label><input type="checkbox" name="'.$name.'[]" class="'.$extraClass.'" '.(in_array($dm['value'], $value)?'checked="checked"':'').' value="'.$dm['value'].'" />'.$dm['name'].'</label><br/>';
                }
            } else {
                echo $this->formCols($d['multi'], $value, create_function('$k,$dm,$value', '
                    return \'<li><label><input type="checkbox" name="'.$name.'[]" class="'.$extraClass.'" title="\'.$dm[\'name\'].\'" \'.(in_array($dm[\'value\'], $value)?\' checked="checked"\':\'\').\' value="\'.$dm[\'value\'].\'" /> \'.$dm[\'name\'].\'</label></li>\';'),
                    array('style'=>'margin-right: 7px;'));
            }
        }break;
        case Dynprops::typeCheckbox:
        {
            $value = (isset($d['value'])? $d['value'] : $d['default_value']);
            echo '<label><input type="hidden" name="'.$name.'" value="0" /><input type="checkbox" name="'.$name.'" value="1" '.($value?'checked="checked"':'').' /> '.$lng_yes.'</label>';
        }break;
        case Dynprops::typeSelect:
        {
            $value = (isset($d['value'])? $d['value'] : $d['default_value']);
            ?>
                <select class="<?= $extraClass ?>" name="<?= $name ?>"<? if($d['parent']){ echo "onchange=\"bffDynpropsParents.select({$d['id']}, this.value, '{$name_child}');\""; }?>>
              <?
                foreach($d['multi'] as $dm) {
                    echo '<option value="'.$dm['value'].'" '.($value == $dm['value'] ? 'selected="selected"' : '').'>'.$dm['name'].'</option>';
                }
              ?>
              </select>
            <?
            if($d['parent']) {
                echo '</td></tr>
                    <tr'. (empty($value) ? ' style="display: none;"':'').'>
                    <td class="td1">'.$d['child_title'].'</td>
                    <td class="f12">';
            ?><span id="<?= $prefixChildID.$d['id']; ?>_child"><?
               if( ! empty($value) && isset($aData['children'][$d['id']])) {
                   echo $this->formChild($aData['children'][$d['id']], array('name'=>$name_child,'class'=>($d['req']?' req':'')), false, $sChildFormTemplate, $sChildFormTemplatePath);
               }
            ?></span><?
            }
        }break;
        case Dynprops::typeInputText:
        {
            $value = (isset($d['value'])? $d['value'] : $d['default_value']);
            echo '<div class="inp inp-w2"><input type="text" name="'.$name.'" value="'.$value.'" class="'.$extraClass.'" /><i></i></div>'.( ! empty($d['description'])?' '.$d['description']:'');
        }break;
        case Dynprops::typeTextarea:
        {
            $value = (isset($d['value'])? $d['value'] : $d['default_value']);
            ?><textarea name="<?= $name ?>" class="<?= $extraClass ?>" style="width:652px; height:80px;"><?= $value ?></textarea><?
        }break;
        case Dynprops::typeNumber:
        {
            $value = (isset($d['value'])? $d['value'] : $d['default_value']);
            echo '<div class="inp inp-w2"><input type="text" name="'.$name.'" value="'.$value.'" class="'.$extraClass.'" /><i></i></div>'.( ! empty($d['description'])?' '.$d['description']:'');
            if($d['parent'] && isset($aData['children'][$d['id']])) {
                echo $this->formChild($aData['children'][$d['id']], array('name'=>$name_child,'class'=>$extraClass), false, $sChildFormTemplate, $sChildFormTemplatePath);
            }
        }break;
        case Dynprops::typeRange:
        {
            $value = (isset($d['value']) && $d['value'] ? $d['value'] : $d['default_value']);
            ?>
            <select name="<?= $name ?>" class="<?= $extraClass ?>">
            <?
            if(!empty($value) && !intval($value)) {
                echo '<option value="0">'.$value.'</option>';
            }
            if($d['start'] <= $d['end']) {
                for($i = $d['start']; $i <= $d['end'];$i += $d['step']) {
                   echo '<option value="'.$i.'" '.($value == $i ? 'selected="selected"' : '').'>'.$i.'</option>';
                }
            } else {
                for($i = $d['start']; $i >= $d['end'];$i -= $d['step']) {
                   echo '<option value="'.$i.'" '.($value == $i ? 'selected="selected"' : '').'>'.$i.'</option>';
                }
            }
            ?>
            </select>
            <?
            if($d['parent'] && isset($aData['children'][$d['id']])) {
                echo $this->formChild($aData['children'][$d['id']], array('name'=>$name_child,'class'=>$extraClass), false, $sChildFormTemplate, $sChildFormTemplatePath);
            }
        }break;
    }

    echo '</td></tr>';
}
?>
<tr style="display: none;"><td colspan="2">
<script type="text/javascript">
<? js::start(js::POS_CURRENT); ?>
var bffDynpropsParents = (function(){
    var cache = {}, prefixID = '<?= $prefixChildID ?>';

    function view(data, id){
        var $inp = $('#'+prefixID+id+'_child').html( ( data.form ? data.form : '')).parent().parent();
        if( data.form!='' ) {
            $inp.show();
        } else {
            $inp.hide();
        }
    }

    return {
        select: function(id, val, prefix)
        {
            var key = id+'-'+val;
            if(!intval(val)) cache[key] = {id:0,form:''};
            if(cache.hasOwnProperty(key)) {
                view( cache[key], id );
            } else {
                bff.ajax('<?= bff::urlAjax('bbs','dp-child') ?>', {dp_id: id, dp_value:val, name_prefix: prefix, search:false}, function(data){
                    if(data) {
                        view( (cache[key] = data), id );
                    }
                });
            }
        }
    }
}());
<? js::stop(); ?>
</script>
</td></tr>