<?php
  $aPriceParams = $this->getPriceParams();
  $userID = User::id();
  $edit = ($id > 0);
  $bAddr = !empty($cat['addr']);

  $aData = HTML::escape($aData, 'html', array('title','addr_addr','user_name','user_email','user_phone'));
?>
<div class="h1-wrap">
    <h1><?= ( $edit ? _t('bbs', 'Редактирование объявления') : ( !empty($titleh1) ? $titleh1 : _t('bbs', 'Добавление объявления')) ) ?></h1>
</div>

<ul class="form-ch mt20">
    <li><?= _t('', 'Поля, отмеченные звездочкой[span], обязательны к заполнению.', array('span' => '<span class="z-att">*</span>')) ?></li>
 </ul>
 <? if( ! empty($_GET['success'])) { ?>
    <div style="margin-bottom:20px;" id="bbs-success-block" class="success"><?= _t('bbs', 'Информация об объявлении успешно сохранена') ?></div>
    <script type="text/javascript">
    <? js::start(); ?>
        $(function(){
            setTimeout(function(){ $('#bbs-success-block').slideUp(function(){ $(this).remove(); }); }, 3000);
        });
    <? js::stop(); ?>
    </script>
 <? } ?>
 <div id="item-error" class="error mb20 displaynone"></div>
 <div class="form-box form-box-bbs">
    <form id="item-form">
    <input type="hidden" name="id" value="<?= $id ?>" />
    <input type="hidden" name="hash" value="<?= $hash ?>" />
    <input type="hidden" name="cat_id" id="item-cat_id" value="<?= $cat_id ?>" />
    <table width="100%">
    <tr><td colspan="2"><h3><?= _t('bbs', 'Общая информация') ?></h3></td></tr>
    <tr>
        <td class="td1"><?= _t('', 'Заголовок') ?><span class="z-att">*</span></td>
        <td><div class="inp inp-w1"><input type="text" name="title" value="<?= $title ?>" class="req" tabindex="1" maxlength="150" /><i></i></div></td>
    </tr>
    <tr>
        <td class="td1"><?= _t('', 'Рубрика') ?><span class="z-att">*</span></td>
        <td>
            <div class="form-ch-sp2">
                <?
                    foreach($cats as $lvl=>$v) {
                        ?><select class="inp-w2" autocomplete="off" style="margin-right: 5px;<? if (empty($v['categories'])){ ?>display: none; <? } ?>" onchange="jBBSItemForm.onCategory($(this))"><?= $v['categories'] ?></select><?
                    }
                ?>
            </div>
        </td>
    </tr>
    <tr<? if($bAddr){ ?> style="display: none;"<? } ?>>
        <td class="td1"><?= _t('', 'Город') ?><span class="z-att">*</span></td>
        <td>
            <?= Geo::cityOptionsSelect($city_id, true, 'city_id', array('class'=>'inp-w2 req', 'id'=>'item-city', 'disabled'=>($bAddr ? 'disabled' : NULL), 'onchange'=>'jBBSItemForm.onCity(intval(this.value), this);')); ?>
        </td>
    </tr>
    <tr id="item-types"<? if( empty($types) ){ ?> style="display: none;"<? } ?>>
        <td class="td1"><?= _t('', 'Тип') ?><span class="z-att">*</span></td>
        <td>
            <div class="form-ch-sp2">
                <select name="cat_type" id="item-types-sel"><?= (! empty($types) ? $types : '') ?></select>
            </div>
        </td>
    </tr>
    <tr id="item-price"<? if( empty($cat['prices']) ){ ?> style="display: none;"<? } ?>>
        <td class="td1"><?= _t('', 'Цена') ?><span class="z-att">*</span></td>
        <td>
             <div class="inp inp-w2"><input type="text" name="price" class="req" value="<?= $price ?>" pattern="[0-9]*" /><i></i></div>
             <span>
                 <?
                    foreach($aPriceParams as $ppKey=>$ppTitle) {
                        ?><label class="f12"><input type="checkbox" name="price_params[]" <?= ($price_params & $ppKey ? ' checked="checked"' : '') ?> value="<?= $ppKey ?>" class="checkbox" /> <?= $ppTitle ?></label><?
                    }
                 ?>
             </span>
             <input type="hidden" name="price_curr" id="item-price-curr" value="<?= $price_curr ?>" />
             <ul class="val-sp" id="item-price-curr-sel">
                <? foreach($curr as $v){ ?>
                    <li <?= ($v['a']?' class="active"':'') ?>><a href="#" onclick="return jBBSItemForm.onCurr(<?= $v['id'] ?>, this);"><?= $v['title_short'] ?></a></li>
                <? } ?>
             </ul>
        </td>
    </tr>
    <tr>
        <td class="td1"><?= _t('', 'Описание') ?><span class="z-att">*</span></td>
        <td>
            <div class="textarea"><textarea rows="7" cols="25" name="descr" class="req"><?= $descr ?></textarea><i></i></div>
        </td>
    </tr>
    <tr>
        <td class="td1"><?= _t('', 'Фотографии') ?></td>
        <td>
            <p class="inform-att f12 mb20"><?= _t('', 'Вы можете загрузить не более [limit] в формате JPG или PNG, объемом не более [size]', array(
                    'limit' => tpl::declension($img->getLimit(), _t('','фотографии;фотографий;фотографий')),
                    'size'  => $img->getMaxSize(true)
                )) ?> &nbsp;<span class="progress" id="item-img-progress" style="display:none;"></span><i></i></p>
            <div id="item-img-error" class="error mb20 displaynone"></div>
            <div class="photos-edit">
                <div id="item-img-list">
                    <?
                    if( ! empty($images) ) {
                        foreach($images as $v)
                        {
                            $imageID = $v['id']; $fn = $v['filename']; ?>
                            <div class="item iimg<?= $imageID; ?>">
                                <input type="hidden" name="img[<?= $imageID ?>]" value="<?= $fn ?>" />
                                <a href="<?= $img->getURL($v, BBSItemImages::szView, false); ?>" target="_blank" rel="item-photos">
                                    <img src="<?= $img->getURL($v, BBSItemImages::szMini, false); ?>" />
                                </a>
                                <a href="#" class="del" data-id="<?= $imageID ?>" data-fn="<?= $fn ?>">Удалить</a>
                            </div><?
                        }
                    } ?>
                    </div>
                <br class="clear" />
                <div id="item-img-upload" style="height: 20px; width: 160px"><a href="javascript:void(0);" class="ajax"><?= _t('', 'Загрузить фотографии') ?></a></div>
                <div id="item-img-uploader" style="margin-top: 10px;"></div>
            </div>
            <br />
        </td>
    </tr>
    <tbody id="item-addr"<? if( ! $bAddr ){ ?> style="display: none;"<? } ?>>
        <tr>
            <td colspan="2"><div class="separatornobr"></div></td>
        </tr>
        <tr>
            <td colspan="2"><br /><h3><?= _t('', 'Местоположение') ?></h3></td>
        </tr>
        <tr>
            <td class="td1"><?= _t('', 'Город') ?><span class="z-att">*</span></td>
            <td>
                <?= Geo::cityOptionsSelect($city_id, true, 'city_id', array('class'=>'inp-w2 req', 'id'=>'item-addr-city', 'disabled'=>(!$bAddr ? 'disabled' : NULL), 'onchange'=>'jBBSItemForm.onCity(intval(this.value), this);')); ?>
            </td>
        </tr>
        <tr>
            <td class="td1"><?= _t('', 'Улица и дом') ?></td>
            <td>
                <div class="inp inp-w3 left mr10"><input type="text" name="addr_addr" value="<?= $addr_addr ?>" id="item-addr-addr" maxlength="200" /><i></i></div><a href="#" class="ajax f12" onclick="return jBBSItemForm.onMapSearch();">Найти на карте</a>
            </td>
        </tr>
        <tr>
            <td class="td1"><?= _t('', 'Расположение') ?></td>
            <td>
                <input type="hidden" name="addr_lat" id="item-addr_lat" value="<?= $addr_lat ?>" />
                <input type="hidden" name="addr_lng" id="item-addr_lng" value="<?= $addr_lng ?>" />
                <div id="item-addr-map" style="width:466px; height: 300px;"></div>
                <p class="f12 grey"><?= _t('', 'Переместите маркер на карте чтобы указать точное местоположение') ?></p>
            </td>
        </tr>
    </tbody>
    <tbody<? if( empty($dp) ){ ?> style="display: none;"<? } ?>>
        <tr><td colspan="2"><div class="separatornobr"></div></td></tr>
        <tr><td colspan="2"><br /><h3><?= _t('', 'Дополнительная информация') ?></h3></td></tr>
    </tbody>
    <tbody id="item-dp">
        <?= ( ! empty($dp) ? $dp : '' ) ?>
    </tbody>
    <tr>
        <td colspan="2"><div class="separatornobr"></div></td>
    </tr>
    <tr><td colspan="2"><br /><h3><?= _t('', 'Контакты') ?></h3><div style="margin-bottom:20px; display: none;" id="item-error-user" class="error"></div></td></tr>
    <? if(! empty($agentCompanies)): ?>
    <tr>
        <td class="td1"><?= _t('bbs', 'Кто вы?:') ?><span class="z-att">*</span></td>
        <td>
            <label><input type="radio" name="user_type" value="1" onchange="jBBSItemForm.userType(1);" <?= $user_type == 1 ? 'checked="checked"' : '' ?>><?= _t('', 'Частное лицо') ?></label>&nbsp;&nbsp;&nbsp;
            <label><input type="radio" name="user_type" value="2" onchange="jBBSItemForm.userType(2);" <?= $user_type == 2 ? 'checked="checked"' : '' ?>><?= _t('', 'Компания') ?></label>
        </td>
    </tr>
    <tr<?= $user_type == 1 ? ' class="displaynone"' : '' ?>>
        <td class="td1"><?= _t('', 'Компания:'); ?></td>
        <td>
            <select class="inp-w3" name="company_id" onchange="jBBSItemForm.onCompany(this);"><? foreach($agentCompanies as $c):?><option value="<?= $c['id'] ?>" <?= $company_id == $c['id'] ? ' selected="selected" ' : '' ?>><?= $c['title'] ?></option><? endforeach; ?></select>
        </td>
    </tr>

    <? endif; ?>
    <tr>
        <td class="td1"><?= _t('bbs', 'Ваше имя') ?><span class="z-att">*</span></td>
        <td><div class="inp inp-w3"><input type="text" name="user_name" class="req" value="<?= $user_name ?>" maxlength="80" /><i></i></div></td>
    </tr>
    <tr>
        <td class="td1"><?= _t('', 'Телефон') ?><span class="z-att">*</span></td>
        <td><div class="inp inp-w3"><input type="tel" name="user_phone" class="req" value="<?= $user_phone ?>" maxlength="80" /><i></i></div></td>
    </tr>
<? if( ! $edit ) { ?>
    <? if( ! $userID) { ?>
    <tr>
        <td class="td1"><?= _t('', 'Email') ?><? if( ! $userID) { ?><span class="z-att">*</span><? } ?></td>
        <td><div class="inp inp-w3"><input type="text" name="user_email" class="req" value="" /><i></i></div></td>
    </tr>
    <tr>
        <td class="td1"></td>
        <td><div class="form-ch-sp2">
                <p><label><input type="checkbox" name="member" onclick="jBBSItemForm.onMember();" id="item-member-check" class="checkbox" /> <?= _t('', 'Я уже зарегистрирован на') ?> <?= config::sys('site.title') ?></label></p>
            </div>
        </td>
    </tr>
    <tr id="item-member" style="display: none;">
        <td class="td1"><?= _t('', 'Введите ваш пароль') ?><span class="z-att">*</span></td>
        <td><div class="inp inp-w3"><input type="text" name="pass" id="item-member-pass" autocapitalize="off" /><i></i></div></td>
    </tr>
    <tr id="item-captcha-block">
        <? $urlCaptcha = tpl::captchaURL(); ?>
        <td class="td1"><?= _t('', 'Введите код с картинки') ?><span class="z-att">*</span></td>
        <td><img title="<?= _t('', 'обновить'); ?>" alt="<?= _t('', 'код'); ?>" src="<?= $urlCaptcha ?>" id="item-captcha" onclick="$(this).attr('src', '<?= $urlCaptcha ?>&r='+Math.random(1));" class="capth" style="cursor: pointer;" /> <div class="inp inp-w4"><input type="text" name="captcha" class="req" pattern="[0-9]*" /><i></i></div></td>
    </tr>
    <? } ?>
<? } ?>
    <tr>
        <td></td>
        <td colspan="2">
            <div class="btn mr10 left"><input type="submit" value="<?= ($edit ? _t('', 'сохранить')  : _t('bbs', 'добавить объявление')) ?>" /><i></i></div>
            <div class="progress" id="item-progress" style="display: none; margin-top: 9px;"></div>
        </td>
    </tr>
    </table>
    <div class="separator"></div>
    </form>
 </div>

<script type="text/javascript">
<? js::start(); ?>
var jBBSItemForm = (function(){
    var cats = {}, catID = 0;
    var $form, $err, $progress, $errUser, $captcha, $types, $typesSel, $price, $priceCurr, $priceCurrSel, $dp;
    var $addr, addr = {i:false,addr:0,lat:0,lng:0, city:0}, $city, city = {id:<?= $city_id ?>,title:'<?= Geo::cityData('title', $city_id) ?>'};
    var company = {};

    function init() {
        $form = $('#item-form');
        $err = $('#item-error');
        $progress = $('#item-progress', $form);
        $errUser = $('#item-error-user');
        $form.submit(function(){
            app.fieldError($form.find('.req:visible'), false);
            var error = false;
            var namesOut = {};
            var inputs = $('input.req:visible, select.req:visible', this);
            inputs.each(function(){
                var i = $(this);
                if(i.is(':radio,:checkbox')) {
                    var name = i.attr('name');
                    if(namesOut[name]) return;
                    namesOut[name] = 1;
                    if( ! inputs.filter('[name="'+name+'"]:checked').length ) {
                        error = true; return false;
                    }
                    return;
                }
                var val = i.val();
                if( val == 0 || val === undefined || $.trim(val) == '' || val == i.attr('placeholder')) {
                    error = true; return false;
                }
            });

            $err.prev().hide();
            if(error) {
                app.showError($err, '<?= _t('', 'Заполните все необходимые поля'); ?>', false, true);
            } else {
                <? if($edit) { ?>
                bff.ajax('<?= BBS::url('edit') ?>', $form.serialize(), function(data, errors) {
                    if(data && data.success) {
                        bff.redirect('<?= BBS::url('edit', array('id'=>$id, 'success'=>1)) ?>');
                    } else {
                        app.showError($err, errors, false, true);
                        if(data.fields) app.fieldErrorForm(data.fields, $form.get(0));
                    }
                }, $progress);
                <? } else { ?>
                bff.ajax('<?= BBS::url('add') ?>', $form.serialize(), function(data, errors) {
                    if(data && data.success) {
                        bff.redirect('<?= BBS::url('add') ?>?finish='+data.user+'&id='+data.id);
                    } else {
                        data.user = intval(data.user);
                        var noUser = ( ! data.user || data.user<=0);
                        if(noUser) {
                            if(data.user == -1) { // exists
                                jBBSItemForm.onMember(true);
                            }
                        } else {
                            $errUser.html('').hide();
                        }
                        app.showError( (noUser ? $errUser : $err), errors, false, true);
                        if(data.fields) app.fieldErrorForm(data.fields, $form.get(0));
                        if(data.captcha) $captcha.trigger('click');
                    }
                }, $progress);
                <? } ?>
            }

            return false;
        });

        $types        = $('#item-types', $form);
        $typesSel     = $('#item-types-sel', $form);
        $price        = $('#item-price', $form);
        $priceCurr    = $('#item-price-curr', $form);
        $priceCurrSel = $('#item-price-curr-sel li', $form);
        $dp           = $('#item-dp', $form);
        $city         = $('#item-city', $form);
        $addr         = $('#item-addr', $form);
        $captcha      = $('#item-captcha', $form);

        if( $addr.is(':visible') ) {
            initAddr();
        }
    }

    function initAddr()
    {
        if (addr.i === true) {
            addr.map.refresh();
            return;
        }

        addr.addr = $('#item-addr-addr', $addr);
        addr.lat  = $('#item-addr_lat', $addr);
        addr.lng  = $('#item-addr_lng', $addr);
        addr.city = $('#item-addr-city', $addr).val(city.id);
        addr.i    = true;

        addr.map = app.map('item-addr-map', [addr.lat.val(), addr.lng.val()], function(map) {
            addr.mapEditor = bff.map.editor();
            addr.mapEditor.init({
                map: map, version: '2.1',
                coords: [addr.lat, addr.lng],
                address: addr.addr,
                addressKind: 'house',
                updateAddressIgnoreClass: 'typed'
            });

            addr.addr.bind('change keyup input', $.debounce(function(){
                if( ! $.trim(addr.addr.val()).length ) {
                    addr.addr.removeClass('typed');
                } else {
                    addr.addr.addClass('typed');
                    jBBSItemForm.onMapSearch();
                }
            }, 700));
        }, {zoom: 12});
    }

    function mapSearch(sAddr)
    {
        var q = [city.title];
        q.push(sAddr);
        addr.mapEditor.search( q.join(', ') );
        return false;
    }

    function catView(data, $select)
    {
        if(data === 'empty') {
            $types.hide();
            $price.hide();
            $addr.hide();
            $dp.empty().prev().hide();
            toggleCity(true);
            return;
        }

        if (data.subs>0) {
            $price.hide();
            $addr.hide();
            $dp.empty().prev().hide();
            toggleCity(true);
            $select.after('<select class="inp-w2" style="margin-right: 5px;" onchange="jBBSItemForm.onCategory($(this))">'+data.cats+'</select>').show();
            return;
        }

        if(data.types) { $typesSel.html( data.types ); $types.show(); }
        else { $types.hide(); $typesSel.html(''); }

        if(intval(data.prices)!==0) { $price.show(); }
        else { $price.hide(); }

        if(intval(data.addr)!==0) { $addr.show(); initAddr(); toggleCity(false); }
        else { $addr.hide(); toggleCity(true); }

        $dp.html( data.dp ).prev().show();
    }

    function toggleCity(noAddr)
    {
        if (noAddr) {
            $city.prop('disabled', false).parent().parent().show();
            if(addr.i) addr.city.prop('disabled', true);
        } else {
            $city.prop('disabled', true).parent().parent().hide();
            if(addr.i) addr.city.prop('disabled', false);
        }
    }

    function setCompanyContacts(id)
    {
        var form = $form.get(0);
        var c = ( id === 0 ? {addr:'',phone:'<?= $user_phone ?>',email:'',city:0} : company[id]);
        form.user_phone.value = c.phone;
    }

    $(function(){ init(); });

    return {
        onCategory: function($select)
        {
            catView('empty');

            catID = intval($select.val());
            $form.find('#item-cat_id').val(catID);
            $select.nextAll().remove();

            if( ! catID) return;

            if(cats.hasOwnProperty(catID)) {
                catView( cats[catID], $select );
            } else {
                bff.ajax('<?= bff::urlAjax('bbs&ev=form','category-data') ?>', {cat_id: catID}, function(data){
                    if(data && data.success) {
                        catView( (cats[catID] = data), $select );
                    }
                }, $progress);
            }
        },
        onCurr: function(id, a)
        {
            id = intval(id);
            if(id<=0) return false;
            var activeClass = 'active';
            $priceCurr.val(id);
            $priceCurrSel.removeClass( activeClass );
            $priceCurrSel.find(a).parent().addClass( activeClass );
            return false;
        },
        onCity: function(cityID, sel)
        {
            if( ! cityID) return;
            var opt = $('option:selected', sel);
            city.title = opt.text();
            city.id = cityID;
            $city.val(cityID);
            if (addr.i) {
                addr.city.val(cityID);
                var coords = opt.data('ycoords');
                if (coords.length) {
                    addr.mapEditor.updateMarker(coords, false, true);
                }
            }
        },
        onMapSearch: function()
        {
            mapSearch( $.trim(addr.addr.val()) );
            return false;
        },
        onMember: function(setMember)
        {
            if(setMember) {
                $('#item-captcha-block', $form).hide();
                $('#item-member-check', $form).prop('checked', true);
                if( $('#item-member', $form).show() ) {
                    $('#item-member-pass', $form).focus();
                }
            } else {
                $('#item-captcha-block', $form).toggle();
                if( $('#item-member', $form).toggle().is(':visible') ) {
                    $('#item-member-pass', $form).focus();
                }
            }
        },
        userType: function(id)
        {
            id = intval(id);
            if(id == 2){
                var $c = $form.find('[name="company_id"]');
                $c.closest('tr').show();
                $c.trigger('change');
            } else {
                $form.find('[name="company_id"]').closest('tr').hide();
                setCompanyContacts(0);
            }
        },
        onCompany: function(sel)
        {
            sel = $(sel);
            var id = intval(sel.val());
            if( ! id) setCompanyContacts(0);

            if(company.hasOwnProperty(id)) {
                setCompanyContacts( id );
            }else{
                bff.ajax('<?= bff::urlAjax('users','company_contacts') ?>', {company_id: id}, function(data){
                    if(data && data.res) {
                        company[ id ] = data.contacts;
                        setCompanyContacts( id );
                    }
                });
            }
        }

    };
}());

var jBBSItemImages = (function(){
    var uploader, id = <?= $id ?>, url = '<?= bff::urlAjax('bbs&ev=form','') ?>';
    var $form, $err, $img, $progress;

    $(function() {
        $form = $('#item-form');
        $err = $('#item-img-error', $form);
        $progress = $('#item-img-progress', $form);
        $img = $('#item-img-list', $form);

        // init uploader
        uploader = new qq.FileUploaderBasic({
            button: $('#item-img-upload', $form).get(0),
            action: url+'img-upload', params: {item_id:id},
            limit: <?= $img->getLimit(); ?>,
            uploaded: <?= sizeof($images) ?>,
            multiple: true,
            onSubmit: function(id, fileName) {
                $progress.show();
            },
            onComplete: function(id, fileName, resp) {
                if(resp.data && resp.data.success) {
                    var data = resp.data;
                    var imageID = data.id;
                    var imageFilename = data.filename;
                    $img.append('<div class="item iimg'+imageID+'">\
                                    <input type="hidden" name="img['+imageID+']" value="'+imageFilename+'" />\
                                    <a href="'+data.sz['<?= BBSItemImages::szView ?>']+'" target="_blank" rel="item-photos">\
                                        <img src="'+data.sz['<?= BBSItemImages::szMini ?>']+'" />\
                                    </a>\
                                    <a href="#" class="del" data-id="'+imageID+'" data-fn="'+imageFilename+'"><?= _t('', 'Удалить') ?></a>\
                                </div>');
                    $('a[rel="item-photos"]', $img).fancybox();
                } else {
                    if(resp.errors) {
                        app.showError($err, resp.errors, false);
                    }
                }
                if( ! uploader.getInProgress()) {
                    $progress.hide();
                }
                return true;
            }
        });

        $('a[rel="item-photos"]', $img).fancybox();
        $img.on('click', 'a.del', function(){
            var $link = $(this);
            bff.ajax(url+'img-delete',{item_id:id, image_id: $link.data('id'), filename: $link.data('fn')}, function(data){
                if(data && data.success) {
                    $link.parent().remove();
                    uploader.decrementUploaded();
                }
            }, $progress);
            return false;
        });

        <? if( ! $edit) { ?>
        var lostProcessed = false;
        $(window).bind('beforeunload', function(){
            if( ! lostProcessed && id === 0) {
                var $fn = $img.find('a.del');
                if($fn.length > 0) {
                    lostProcessed = true;
                    var fn = []; $fn.each(function(){ fn.push($(this).data('fn')); });
                    bff.ajax(url+'img-delete',{item_id:id,filename:fn,bulk:true},function(){},false,{async:false});
                }
            }
        });
        <? } ?>
    });

}());

<? js::stop(); ?>
</script>