<?php
/**
 * @var $this BBS
 */
$catLevel = sizeof($cats);
?>
<h3 class="mt20"><?= _t('', 'Поиск в категории') ?>:</h3>
<div class="relative">
    <? foreach($cats as $lvl=>$c){ if($lvl == $catLevel) break;  ?>
    <div class="cat-select mb5" onclick="$(this).parent().find('.cat-select-open').addClass('displaynone'); $(this).next().toggleClass('displaynone');">
        <span class="select-content">
            <strong class="flows active"><?= $c['categories'][$c['a']]['title'] ?></strong>
            <i class="dd-arrow"></i>
        </span>
    </div>
    <div class="cat-select cat-select-open displaynone" style="top:<?= ($lvl > 1 ? (($lvl-1) * 37) : 0) ?>px;">
        <span class="select-content" onclick="$(this).parent().toggleClass('displaynone');">
            <strong class="flows active"><?= $c['categories'][$c['a']]['title'] ?></strong>
            <i class="dd-arrow"></i>
        </span>
        <ul>
            <?
            foreach($c['categories'] as $v) {
               echo '<li><a '.($c['a'] == $v['id'] ? ' class="active'.($cat['id']!=$v['id']?'-hover':'').'" ':'').' href="'.BBS::url('search', $v['keyword']).'">'.$v['title'].'</a></li>';
            }
            ?>
        </ul>
    </div>
    <? } ?>
</div>

<div class="param">
    <form id="bbs-search" method="get" action="<?= BBS::url('search', $cat['keyword'])?>" class="relative">
        <input type="hidden" name="c" value="<?= $cat['id'] ?>" />
        <input type="hidden" name="cl" value="<?= $cat['lvl'] ?>" />
        <div id="bbs-search-counter" style="display: none; position: absolute; left: -115px; border: 1px solid #DADADA; background-color: #fff; padding: 5px 10px; width: 105px;">
            <span class="found-no f12"><?= _t('', 'ничего не найдено') ?></span>
            <span class="found-yes f12"><span class="num">0</span> - <a href="#" class="j-submit"><?= _t('', 'показать') ?></a></span>
        </div>
        <? if($catLevel > 1) { ?>
        <div class="b-param f12">
            <p class="param-name"><?= _t('', 'Подкатегории') ?>:</p>
            <div>
                <? if( ! empty($parent['keyword'])): ?>
                    <a href="<?= BBS::url('search', $parent['keyword'])?>"<? if($f['c']==$parent['id']){ ?> class="bold" <? } ?>><?= _t('bbs', 'Все') ?></a><br />
                <? endif; ?>
                <? foreach($cats[$catLevel]['categories'] as $v){ ?>
                    <a href="<?= BBS::url('search', $v['keyword'])?>"<? if($f['c']==$v['id']){ ?> class="bold" <? } ?>><?= $v['title'] ?></a><br />
                <? } ?>
            </div>
        </div>
        <? } ?>
        <? if( ! Geo::cityIsOne() ) { ?>
        <div class="b-param">
            <p class="param-name"><?= _t('', 'Город') ?></p>
            <select name="rc"><?= Geo::cityOptions($f['rc'], array(-1, _t('', 'Все города') )) ?></select>
        </div>
        <? } ?>
        <? if( ! empty($types) ) { ?>
        <div class="b-param">
            <p class="param-name"><?= _t('', 'Тип') ?></p>
            <ul id="bbs-search-types">
                <li class="typeid-0"><label><input type="radio" <? if($f['t'] == 0){ ?>checked="checked"<? } ?> name="t" value="0" /> <?= _t('', 'Любой') ?></label></li>
                <? foreach($types as $id=>$v){ ?>
                <li class="nn typeid-<?= $v['id'] ?>"><label><input type="radio" <? if($f['t'] == $v['id']){ ?>checked="checked"<? } ?> name="t" value="<?= $v['id'] ?>" /> <?= $v['title'] ?></label></li>
                <? } ?>
            </ul>
        </div>
        <? } ?>
        <div id="bbs-search-dp"><?= $dp ?></div>
        <? if($cat['prices']){ ?>
        <div class="b-param">
            <p class="param-name"><?= _t('', 'Цена') ?> </p>
            <div class="num-area"><?= _t('', 'от') ?> <input type="text" name="pf" value="<?= $f['pf'] ?>" pattern="[0-9]*" /> <?= _t('', 'до') ?> <input type="text" name="pt" value="<?= $f['pt'] ?>" pattern="[0-9]*" /> <?= Site::currencyDefault() ?></div>
        </div>
        <? } ?>
        <div class="b-param">
            <ul>
                <li><label><input type="checkbox" name="ph" <? if($f['ph']){ ?>checked="checked"<? } ?> /><?= _t('', 'есть фотографии') ?></label></li>
            </ul>
        </div>
        <div class="param-btn"><div class="btn"><input type="submit" value="<?= _t('', 'Найти') ?>" /><i></i></div></div>
    </form>
</div>
<script type="text/javascript">
<? js::start(); ?>
var jBBSSearch = (function(){
    var $form, cnt = {i:false,block:0};
    
    $(function(){
        $form  = $('#bbs-search');
        $form.on('click', '.j-submit', function(e){ nothing(e);
            $form.submit();
        });
        $form.on('click', ':checkbox, :radio', function(){
            updateCounter( $(this).position() );
        });
        $form.on('change', ':text, select', function(){
            updateCounter( $(this).position() );
        });        
    });

    function updateCounter(pos)
    {
        if(cnt.i === false) {
            cnt.i = true;
            cnt.block = $('#bbs-search-counter', $form);
            cnt.num = $('.num', cnt.block); 
            cnt.yes = $('.found-yes', cnt.block);
            cnt.no = $('.found-no', cnt.block);
            cnt.timer = false; 
        }
        
        bff.ajax('<?= BBS::url('search') ?>', $form.serialize()+'&cnt=1', function(data){
            if(data) {
                var num = intval(data.total);
                cnt.num.html( num );
                if( num>0 ) {
                    cnt.yes.show();
                    cnt.no.hide();
                } else {
                    cnt.yes.hide();
                    cnt.no.show();
                }
                cnt.block.css({top:pos.top-5}).fadeIn();
                if(cnt.timer) clearTimeout(cnt.timer);
                cnt.timer = setTimeout(function(){ cnt.block.fadeOut(); }, 5000);
            }
        });
    }
    
    return {
        submit: function()
        {                 
            $form.submit();
            return false;
        },
        dpChild: function(id, val, prefix)
        {
            var $inputChild = $form.find('#dp'+id+'_child');
            if( ! intval(val)) {
                $inputChild.html('').parent().hide();
                return;
            }
            bff.ajax('<?= bff::urlAjax('bbs','dp-child') ?>', {dp_id: id, dp_value:val, name_prefix: prefix, search:true}, function(data){
                if(data && data.success) {
                    $inputChild.html( ( data.form ? data.form : '')).prop('disabled', false);
                    if( ( data.form != '' ) ) {
                        $inputChild.parent().show();
                    } else {
                        $inputChild.parent().hide();
                    }
                }
            });
        }
    };
}());
<? js::stop(); ?>
</script>