<?php

class Bills extends BillsBase
{
    protected function tabs(&$aData, $sCurrentTab)
    {
        $aTabs = array(
            'balance' => array('t'=>_t('bills','Пополнение счета'), 'tpl'=>'balance'),
            'history' => array('t'=>_t('bills','История операций'), 'tpl'=>'history'),
        );

        if ( ! array_key_exists($sCurrentTab, $aTabs)) $sCurrentTab = key($aTabs);
        $aTabs[$sCurrentTab]['a'] = true;

        $aData['balance'] = $this->security->getUserBalance();
        $aData['content'] = $this->viewPHP($aData, $aTabs[$sCurrentTab]['tpl']);
        $aData['tabs'] = $aTabs;
        return $this->viewPHP($aData, 'tabs');
    }

    /**
     * Страница пополнения счета
     */
    public function balance()
    {
        if ( ! User::id()) {
            if (Request::isAJAX()) {
                $this->errors->accessDenied();
                $this->ajaxResponseForm();
            } else {
                $this->showForbidden(_t('bills', 'Управление счетом'), '', true);
            }
        }

        $paySystems = static::getPaySystems(false);
        $fAmount = $this->input->postget('amount', TYPE_UNUM); # сумма

        if (Request::isAJAX())
        {
            $aResponse = array();

            # Формирование счета для оплаты
            do{

                $nUserID    = User::id();
                $sPaySystem = $this->input->post('ps',   TYPE_NOTAGS); # Ключ способа оплаты
                $nBillID    = $this->input->post('bill', TYPE_UINT);   # ID счета или 0

                if ( ! $this->security->validateToken() ) {
                    $this->errors->set( _t('bills', 'Ошибка создания счета, обновите страницу и повторите попытку') );
                    break;
                }

                # проверяем доступность способа оплаты
                if (!isset($paySystems[$sPaySystem]) || empty($paySystems[$sPaySystem]['id']) || empty($paySystems[$sPaySystem]['enabled'])) {
                    $this->errors->set( _t('bills', 'Выбранный способ оплаты на текущий момент недоступен') );
                    break;
                }
                $ps = $paySystems[$sPaySystem];
                $sWay = $ps['way'];

                # проверяем сумму
                if ($fAmount < 1) {
                    $this->errors->set( _t('bills', 'Некорректная сумма для пополнения'), 'amount' );
                    break;
                }
                $fAmount = $fMoney = round($fAmount, 2);
                $sDescription = _t('bills', 'Пополнения счета системой [title]', array('title'=>$ps['title']));

                if ($nBillID) { # проверяем переданный номер счета
                    $aBillData = $this->model->billData($nBillID, '*', $nUserID);
                    if (empty($aBillData) || $aBillData['status'] != self::STATUS_WAITING) {
                        $nBillID = 0; # указанный номер счета некорректный, или счет уже обрабатывался
                    } else {
                        $fMoney = $aBillData['money'];
                    }
                }
                if ( ! $nBillID) {
                    # создаем новый счет "пополнения"
                    $pay = static::getPayAmount($fAmount, $sPaySystem);
                    $fMoney = $pay['amount'];
                    $nBillID = $this->createBill_InPay($nUserID, $this->security->getUserBalance(),
                                            $fAmount, $fMoney, $pay['currency'],
                                            self::STATUS_WAITING, $ps['id'], $sWay, $sDescription);
                }

                if ($nBillID) {
                    # формируем запрос к системе оплаты
                    $aResponse['form'] = $this->buildPayRequestForm($ps['id'], $sWay, $nBillID, $fMoney);
                } else {
                    $this->errors->set( _t('bills', 'Ошибка создания счета, обновите страницу и повторите попытку') );
                }

            } while(false);

            $this->ajaxResponseForm($aResponse);
        }

        bff::setMeta(_t('users', 'Личный счет - Пополнение счета'));
        $aData = array(
            'psystems' => $paySystems,
            'amount' => $fAmount,
            'token' => $this->security->getToken(),
        );
        return $this->tabs($aData, 'balance');
    }

    /**
     * История счетов
     */
    public function history()
    {
        if ( ! User::id()) {
            if (Request::isAJAX()) {
                $this->errors->accessDenied();
                $this->ajaxResponseForm();
            } else {
                $this->showForbidden(_t('bills', 'Управление счетом'), '', true);
            }
        }

        $aData = array();
        $f = $this->input->postgetm(array(
            'status'  => TYPE_UINT, // статус счета
            'type'    => TYPE_UINT, // тип счета
            'p_from'  => TYPE_NOTAGS,  // дата создания (от)
            'p_to'    => TYPE_NOTAGS,  // дата создания (до)
        ));

        $aData['f'] = &$f;

        $aFilter = array('user_id'=>User::id(), 'status'=>self::STATUS_COMPLETED);
        if ($f['status']>0) {
            $aFilter['status'] = $f['status'];
        }
        if ($f['type']>0) {
            $aFilter['type'] = $f['type'];
        }
        if ( ! empty($f['p_from']) || ! empty($f['p_to']))
        {
            $from = strtotime($f['p_from']);
            $to = strtotime($f['p_to']);
            if ( ! empty($from) && $from!=-1) {
                $aFilter[] = array('created >= :from', ':from'=>date('Y-m-d 00:00:00', $from));
            }
            if ( ! empty($to) && $to!=-1) {
                $aFilter[] = array('created <= :to', ':to'=>date('Y-m-d 23:59:59', $to));
            }
        }

        $nTotal = $this->model->billsList($aFilter, true);
        $aData['pgn'] = $this->generatePagenationDots($nTotal, 10, 2, static::url('history').'?page={page}', $sqlLimit);
        $aData['bills'] = $this->model->billsList($aFilter, false, $sqlLimit);
        $aData['list'] = $this->viewPHP($aData, 'history.ajax');

        if (Request::isAJAX()) {
            $this->ajaxResponseForm(array(
                'list' => $aData['list'],
                'pgn'  => $aData['pgn'],
            ));
        }

        bff::setMeta(_t('users', 'Личный счет - История операций'));
        return $this->tabs($aData, 'history');
    }

    # ---------------------------------------------------------------------------------

    /**
     * Обработка запроса от системы оплаты
     * @param string::get 'psystem' система оплаты
     * @return string
     */
    public function processPayRequest()
    {
        $sPaySystem = $this->input->get('psystem', TYPE_NOTAGS);
        $sPayRequestMethod = $sPaySystem.'_request';

        $aData = $this->getPaySystemData($sPaySystem);
        if ( ! $this->isPaySystemAllowed($aData['id']) ||
            ! method_exists($this, $sPayRequestMethod) ) {
            $this->log('Данный способ оплаты отключен: '.$aData['title']);
            return $this->payError('off');
        } else {
            $this->$sPayRequestMethod();
        }
    }

    /**
     * Оплата счёта на основе данных от платёжной системы
     * @param int $nBillID ID счета (в таблице TABLE_BILLS)
     * @param float|int $fMoney сумма счета (оплачиваемая)
     * @param int $nPaySystem ID системы оплаты
     * @param mixed $mDetails детали от платежной системы
     * @param array $mExtra доп.параметры (если необходимо)
     * @return mixed
     */
    protected function processBill($nBillID, $fMoney = 0, $nPaySystem = 0, $mDetails = false, $aExtra = array())
    {
        $sPaySystem = $this->getPaySystemTitle($nPaySystem);

        # Проверяем ID счета
        if ( ! is_numeric($nBillID) || $nBillID <=0 ) {
            $this->log($sPaySystem.': некорректный номер счета, #'.$nBillID);
            return $this->payError('wrong_bill_id');
        }

        $aBill = $this->model->billData($nBillID, array('user_id','psystem','status','amount','money','svc_id','svc_activate','svc_settings','item_id'));
        if (empty($aBill)) {
            $this->log($sPaySystem.': Оплачен несуществующий счёт #'.$nBillID);
            return $this->payError('pay_error');
        }

        # Проверяем доступность способа оплаты
        if ($nPaySystem !== intval($aBill['psystem'])) {
            $this->log($sPaySystem.': Cчёт #'.$nBillID.' выставлен для оплаты другой системой оплаты ('.$this->getPaySystemTitle($aBill['psystem']).')');
            return $this->payError('pay_error');
        }

        # Проверяем статус счета
        if ($aBill['status'] == self::STATUS_CANCELED ||
           $aBill['status'] == self::STATUS_COMPLETED)
        {
            $this->log($sPaySystem.': Оплачен уже ранее оплаченный счёт или счёт с другим статусом, #'.$nBillID);
            return $this->payError('pay_error');
        }

        # Проверка суммы
        if ($fMoney < $aBill['money']) {
            $this->log("$sPaySystem: Сумма оплаты($fMoney) счета #$nBillID меньше выставленной ранее({$aBill['money']})");
            return $this->payError('amount_error');
        }

        # Закрываем счет:
        # - обновляем статус на "завершен"
        # - помечаем дату оплаты текущей
        if ( ! $this->completeBill( $nBillID, true, array('user_id'=>$aBill['user_id'], 'amount'=>$aBill['amount'], 'add'=>true), $mDetails ) ) {
            return _t('bills', 'Ошибка закрытия счета #[id]', array('id'=>$nBillID));
        } else {
            # - пополняем счет пользователя на сумму
            $this->updateUserBalance($aBill['user_id'], $aBill['amount'], true);
        }

        do {

            # Активируем услугу, если:
            # - оплачивалась услуга (svc_id > 0)
            # - если отмечена необходимость ее активации после оплаты (svc_activate = 1)
            $nSvcID  = $aBill['svc_id'];
            if ($nSvcID > 0 && ! empty($aBill['svc_activate']))
            {
                $oSvc = $this->svc();
                $aSvcData = $oSvc->model->svcData($nSvcID);
                if ( ! empty($aSvcData) ) {
                    # Активируем услугу
                    # Снимаем деньги со счета пользователя
                    $mResult = $oSvc->activate($aSvcData['module'], $nSvcID, $aSvcData, $aBill['item_id'], $aBill['user_id'],
                        $aBill['amount'], $aBill['money'], $aBill['svc_settings']);
                    if ( $mResult === false ) {
                        $this->log('Ошибка активации услуги: #'.$nSvcID.', счет: '.$nBillID);
                        break;
                    }
                } else {
                    $this->log('Ошибка активации услуги: #'.$nSvcID.', счет: '.$nBillID);
                    break;
                }
            }

        } while(false);
        return true;
    }

    # ---------------------------------------------------------------------------------

    public function success()
    {
        $sTitle = _t('bills', 'Пополнение счета');
        $sMessage = _t('bills', 'Вы успешно пополнили счет');

        if (User::id())
        {
            $sMessage .= _t('bills', '<br/>На вашем счету: [a_open][balance] [curr][a_close]',
                array('a_open'=>'<a href="'.static::url('history').'">',
                      'balance'=>$this->security->getUserBalance(),
                      'curr'=>Site::currencyDefault(),
                      'a_close'=>'</a>'));
        }

        return $this->showSuccess($sTitle, $sMessage);
    }

    public function fail()
    {
        $sPaySystemKey = $this->input->get('w', TYPE_NOTAGS);
        $aPaySystemTitle = $this->getPaySystemTitle($sPaySystemKey);

        $sTitle = _t('bills', 'Оплата счета');
        $sMessage = _t('bills', 'Ошибка оплаты счета');
        if ( ! empty($sPaySystemKey) ) {
            $sMessage .= _t('bills', ' системой "[way]"', array(
                'way' => $aPaySystemTitle));
        }

        return $this->showForbidden($sTitle, $sMessage);
    }

    # --------------------------------------------------------------------
    # Система оплаты Privat24

    protected function privat24_request()
    {
        $payment   = ( ! empty($_POST['payment'])   ? $_POST['payment']   : '');
        $signature = ( ! empty($_POST['signature']) ? $_POST['signature'] : '');

        $pass = config::sys('bills.privat24.password');

        $crc = sha1(md5($payment.$pass));

        if ($crc != $signature) {
            $this->log('privat24: неверная контрольная сумма "'.$crc.'" !== "'.$signature);
            return $this->payError('crc_error');
        }

        parse_str($payment, $aPayment);

        $InvId=0;
        $OutSum=0;

        if (empty($aPayment['amt']) || empty($aPayment['order'])) {
            $this->log('privat24: Некорректный номер счета, (#'.$aPayment['order'].') amt='.$aPayment['amt']);
            $this->payError('wrong_bill_id');
        } else {
            $InvId=$aPayment['order'];
            $OutSum=$aPayment['amt'];
        }

        $mResult = $this->processBill($InvId, $OutSum, self::PS_PRIVAT24);
        if ($mResult === true) {
            $this->redirect( static::url('success') );
        } else {
            return $mResult;
        }
        $this->redirect( static::url('fail') );
        exit;
    }

}