<?php
/**
 * @var $this Job
 */
tpl::includeJS(array('tablednd'), true);
?>
<?= tplAdmin::blockStart('Работа / Сферы деятельности / Добавить', false, array('id'=>'jobCatFormBlock', 'style'=>'display:none;')); ?>
    <form action="" method="post" name="jobCatFormNew"><?= $form ?></form>
<?= tplAdmin::blockStop(); ?>

<?= tplAdmin::blockStart('Работа / Сферы деятельности', true, array(), array(
    'title' => '+ добавить', 'onclick'=>'return jobCategories.toggle(\'add\');',
)); ?>
<table class="table table-condensed table-hover admtbl tblhover" id="job-cats-table">
<thead>
    <tr class="header nodrag nodrop">
        <? if(FORDEV) { ?><th width="50">ID</th><? } ?>
        <th class="left">Название</th>
        <th width="85">Действие</th>
    </tr>
</thead>
<? foreach($cats as $k=>$v) { $id = $v['id']; ?>
<tr class="row<?= $k%2 ?>" id="dnd-<?= $id ?>">
    <? if(FORDEV) { ?><td><?= $id ?></td><? } ?>
    <td class="left"><?= $v['title'] ?></td>
    <td>
        <a class="but <? if($v['enabled']){ ?>un<? } ?>block cat-toggle" title="Вкл/Выкл" href="#" rel="<?= $id ?>"></a>
        <a class="but edit cat-edit" title="Редактировать" href="#" rel="<?= $id ?>"></a>
        <a class="but del cat-del" title="Удалить" href="#" rel="<?= $id ?>"></a>
    </td>
</tr>
<? } if (empty($cats)) { ?>
<tr class="norecords">
    <td colspan="<?= (FORDEV ? 3 : 2) ?>">ничего не найдено (<a href="#" class="ajax" onclick="return jobCategories.toggle('add');">добавить</a>)</td>
</tr>
<? } ?>
</table>
<div>
    <div class="left">    
        
    </div>
    <div class="right desc" style="width:60px; text-align:right;">
        <div class="progress" id="progress-job-cats" style="display:none;"></div>
        &darr; &uarr;
    </div>
</div>
<?= tplAdmin::blockStop(); ?>

<script type="text/javascript">
var jobCategories = (function(){
    var $progress, $block, $blockCaption, form, formClean, $list, fChecker;
    var ajax_url = '<?= $this->adminLink('categories&act=') ?>';
    
    $(function(){
        form = document.forms.jobCatFormNew;
        
        fChecker = new bff.formChecker(form);
        formClean = $(form).html();
        
        $progress = $('#progress-job-cats');
        $block = $('#jobCatFormBlock');
        $blockCaption = $block.find('span.caption'); 
        $list = $('#job-cats-table');
        
        $list.on('click', 'a.cat-edit', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) edit( id );
            return false;
        });
        $list.on('click', 'a.cat-toggle', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) {
                bff.ajaxToggle(id, ajax_url+'toggle', {progress: $progress, link: this});
            }
            return false;
        });        
        $list.on('click', 'a.cat-del', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) del( id, this );
            return false;
        });
        
        bff.rotateTable('#job-cats-table', ajax_url+'rotate', $progress);

        $(form).on('click', '.j-tab-toggler', function(e){ nothing(e);
            var key = $(this).data('key');
            $(form).find('.j-tab').addClass('hidden');
            $(form).find('.j-tab-'+key).removeClass('hidden');
            $(this).parent().addClass('tab-active').siblings().removeClass('tab-active');
        });
    });

    function toggle(type, editData)
    {                                           
        switch(type) {
            case 'add': {
                if($block.is(':hidden')) {
                    $block.show();
                    $(form).html(formClean);
                    $blockCaption.html('Работа / Сферы деятельности / Добавить');
                    $.scrollTo($blockCaption, {duration:500, offset:-300});
                } else {
                    $block.hide();   
                }
            } break; 
            case 'cancel': {
                $block.hide();
            } break;
            case 'edit': {                           
                $blockCaption.html(editData.caption);
                $(form).html(editData.form);
                $block.show();
                $.scrollTo($blockCaption, {duration:500, offset:-300});
                form.elements['act'].value = 'edit-finish';
            } break;
        }
        fChecker.check(true, true);
        return false;
    }
    
    function del(id, link)
    {
        bff.ajaxDelete('Удалить раздел?', id, ajax_url+'delete&cat_id='+id,
            link, {progress: $progress, repaint: false});
        return false;
    }
    
    function edit(id)
    {                          
        bff.ajax(ajax_url+'edit&cat_id='+id,{},function(data){
            if(data) {
                toggle('edit', $.extend({caption: 'Работа / Сферы деятельности / Редактирование'}, data) );
            }                  
        }, $progress);
        return false;
    }
    
    return {toggle: toggle};
}());
</script>